package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class PlayCommand extends CameraCommand {
  private final String playlist;

  private final boolean repeat;

  public PlayCommand(String playlist, boolean repeat) {
    this.playlist = playlist;
    this.repeat = repeat;
  }

  public String getPlaylist() {
    return playlist;
  }

  public boolean isRepeat() {
    return repeat;
  }

  @Override
  public String toString() {
    return "PlayCommand{" + "playlist=" + playlist +", repeat=" + repeat +"}";
  }
}
