/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_ForelineVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex1VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex2VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboCurrentTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPowerTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPumpTempTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboSpeedTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVoltageTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.638889729976654;
        double dirty_24V_I = 0.13770556449890137;
        double dirty_28V_I = 0.015667974948883057;
        double dirty_48V_I = 0.3332202434539795;
        double heater_I = 0.9151987433433533;
        double protection_I = 0.5983132123947144;
        double rebps_0_2_I = 0.3930413f;
        double rebps_3_5_I = 0.1267513632774353;
        double rebps_6_8_I = 0.3148263096809387;
        double rebps_9_12_I = 0.733614981174469;
        double rebps_Spr_I = 0.6697113513946533;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double n_24vc_Board_T = 0.050904035568237305;
        double n_24vc_FPGA_T = 0.3045209050178528;
        double n_24vc_Main_I = 0.698835551738739;
        double n_24vc_Main_T = 0.22198176383972168;
        double n_24vc_Main_V = 0.7720783948898315;
        double body_Purge_I = 0.03413683f;
        double body_Purge_V = 0.5856906771659851;
        double bpu_Maq20_I = 0.05425792932510376;
        double bpu_Maq20_V = 0.3065725564956665;
        double fes_Shu_HCU_I = 0.914562f;
        double fes_Shu_HCU_V = 0.8024911284446716;
        double gauges_I = 0.561866819858551;
        double gauges_V = 0.6524629592895508;
        double ion_Pumps_I = 0.8501238226890564;
        double ion_Pumps_V = 0.7371757626533508;
        double pwr_Cry_HCU_I = 0.3195068836212158;
        double pwr_Cry_HCU_V = 0.395433247089386;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(n_24vc_Board_T, n_24vc_FPGA_T, n_24vc_Main_I, n_24vc_Main_T, n_24vc_Main_V, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)n_24vc_Board_T, (double)item_.getN_24vc_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T, (double)item_.getN_24vc_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I, (double)item_.getN_24vc_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T, (double)item_.getN_24vc_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V, (double)item_.getN_24vc_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double n_24vd_Board_T = 0.37063318490982056;
        double n_24vd_FPGA_T = 0.7104004621505737;
        double n_24vd_Main_I = 0.7501804232597351;
        double n_24vd_Main_T = 0.7821298241615295;
        double n_24vd_Main_V = 0.34100186824798584;
        double cryo_Turbo_I = 0.10711503028869629;
        double cryo_Turbo_V = 0.8710756897926331;
        double hex_Turbo_I = 0.4342998266220093;
        double hex_Turbo_V = 0.33723026514053345;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(n_24vd_Board_T, n_24vd_FPGA_T, n_24vd_Main_I, n_24vd_Main_T, n_24vd_Main_V, cryo_Turbo_I, cryo_Turbo_V, hex_Turbo_I, hex_Turbo_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)n_24vd_Board_T, (double)item_.getN_24vd_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T, (double)item_.getN_24vd_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I, (double)item_.getN_24vd_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T, (double)item_.getN_24vd_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V, (double)item_.getN_24vd_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double n_48v_Board_T = 0.9117512106895447;
        double n_48v_FPGA_T = 0.2600153684616089;
        double n_48v_Main_I = 0.1531394124031067;
        double n_48v_Main_T = 0.9253020882606506;
        double n_48v_Main_V = 0.872222363948822;
        double purge_Fan_I = 0.11161643266677856;
        double purge_Fan_V = 0.4767692f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(n_48v_Board_T, n_48v_FPGA_T, n_48v_Main_I, n_48v_Main_T, n_48v_Main_V, purge_Fan_I, purge_Fan_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)n_48v_Board_T, (double)item_.getN_48v_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T, (double)item_.getN_48v_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I, (double)item_.getN_48v_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T, (double)item_.getN_48v_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V, (double)item_.getN_48v_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.6135520339012146;
        double otm_0_A_V = 0.4675411581993103;
        double otm_0_B_I = 0.4446919f;
        double otm_0_B_V = 0.3485068082809448;
        double otm_1_A_I = 0.9594364762306213;
        double otm_1_A_V = 0.3672473430633545;
        double otm_1_B_I = 0.6357722282409668;
        double otm_1_B_V = 0.42668914794921875;
        double otm_2_A_I = 0.378991f;
        double otm_2_A_V = 0.3403865098953247;
        double otm_2_B_I = 0.9576561450958252;
        double otm_2_B_V = 0.9184102416038513;
        double otm_3_A_I = 0.4528998136520386;
        double otm_3_A_V = 0.6180059313774109;
        double otm_3_B_I = 0.43196988105773926;
        double otm_3_B_V = 0.0030002593994140625;
        double otm_4_A_I = 0.6589388847351074;
        double otm_4_A_V = 0.634658694267273;
        double otm_4_B_I = 0.3117980360984802;
        double otm_4_B_V = 0.7828250527381897;
        double otm_5_A_I = 0.33912956714630127;
        double otm_5_A_V = 0.2980002164840698;
        double otm_5_B_I = 0.9111488461494446;
        double otm_5_B_V = 0.5686032772064209;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.5744142532348633;
        double rebbulkps_0_2_T = 0.4660971760749817;
        double rebbulkps_0_2_V = 0.32455867528915405;
        double rebbulkps_3_5_I = 0.18661415576934814;
        double rebbulkps_3_5_T = 0.37383097410202026;
        double rebbulkps_3_5_V = 0.9825586080551147;
        double rebbulkps_6_8_I = 0.13037598133087158;
        double rebbulkps_6_8_T = 0.8517256379127502;
        double rebbulkps_6_8_V = 0.9634333848953247;
        double rebbulkps_9_12_I = 0.3411770462989807;
        double rebbulkps_9_12_T = 0.25867152214050293;
        double rebbulkps_9_12_V = 0.15205252170562744;
        double rebbulkps_Brd_T = 0.8976141214370728;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)273531830);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1754060750);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1977104106);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-2071421954);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-26223077);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1344792691);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-219226965);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-446336609);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1785310788);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1543863043);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1638828710);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1438043308);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1712557445);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)-1096152006);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-712789232);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)77417103);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1922119498);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)51297739);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1126386745);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)201957969);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)767546334);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1326156586);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)853841930);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)2023983567);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)15589958);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)2065921262);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1198018796);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1772774062);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1105325507);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-458164146);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1328011578);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)23255390);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)834523230);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-627945997);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-714785770);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2061670619);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)840274609);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)88513016);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-2092263202);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)-731155514);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-1944854425);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)-1404655361);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)1977123394);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)355619897);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)151732710);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)892753357);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)560623125);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double evapExitTmp = 0.509138f;
        double hexRtrnTmp = 0.2533954977989197;
        double preExpnTmp = 0.5670694708824158;
        double returnPrs = 0.7915201783180237;
        double superHeat = 0.4347783327102661;
        double supplyPrs = 0.16308891773223877;
        double supplySubCooling = 0.11034232378005981;
        double supplyTmp = 0.07947146892547607;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double evapExitTmp = 0.8545461297035217;
        double hexRtrnTmp = 0.765780508518219;
        double preExpnTmp = 0.6812258362770081;
        double returnPrs = 0.34079432487487793;
        double superHeat = 0.9090901613235474;
        double supplyPrs = 0.8828146457672119;
        double supplySubCooling = 0.1399632692337036;
        double supplyTmp = 0.21496367454528809;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.48869335651397705;
        double c4ExitTmp = 0.5236793756484985;
        double evapExitTmp = 0.1787287f;
        double hexRtrnTmp = 0.5199159383773804;
        double liquidPrs = 0.5029171705245972;
        double preC3Tmp = 0.9910563230514526;
        double preC4Tmp = 0.2425785f;
        double returnPrs = 0.9126086831092834;
        double vaporPrs = 0.6433528661727905;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.8951604962348938;
        double c4ExitTmp = 0.17329078912734985;
        double evapExitTmp = 0.5230847001075745;
        double hexRtrnTmp = 0.9876163005828857;
        double liquidPrs = 0.02663552761077881;
        double preC3Tmp = 0.8615723848342896;
        double preC4Tmp = 0.8602638244628906;
        double returnPrs = 0.745669424533844;
        double vaporPrs = 0.35171544551849365;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.7934263944625854;
        double c4ExitTmp = 0.27476412057876587;
        double evapExitTmp = 0.28927671909332275;
        double hexRtrnTmp = 0.9605495929718018;
        double liquidPrs = 0.2449181079864502;
        double preC3Tmp = 0.8207762837409973;
        double preC4Tmp = 0.004761755466461182;
        double returnPrs = 0.46034324169158936;
        double vaporPrs = 0.16555821895599365;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.27150875329971313;
        double c4ExitTmp = 0.656694f;
        double evapExitTmp = 0.10323494672775269;
        double hexRtrnTmp = 0.7840898036956787;
        double liquidPrs = 0.42524755001068115;
        double preC3Tmp = 0.7998093366622925;
        double preC4Tmp = 0.37167954444885254;
        double returnPrs = 0.3522723913192749;
        double vaporPrs = 0.3840165138244629;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.2980801f;
        double c4ExitTmp = 0.01173532f;
        double evapExitTmp = 0.5336012840270996;
        double hexRtrnTmp = 0.7146857380867004;
        double liquidPrs = 0.4387451410293579;
        double preC3Tmp = 0.7603783011436462;
        double preC4Tmp = 0.9566890597343445;
        double returnPrs = 0.9117953777313232;
        double vaporPrs = 0.2162758708000183;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.6132370829582214;
        double c4ExitTmp = 0.7398157119750977;
        double evapExitTmp = 0.2990939f;
        double hexRtrnTmp = 0.6232790946960449;
        double liquidPrs = 0.23352354764938354;
        double preC3Tmp = 0.0970807671546936;
        double preC4Tmp = 0.9377151727676392;
        double returnPrs = 0.7544595003128052;
        double vaporPrs = 0.524128f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1Telemetry() throws Exception {
        double ambientTmp = 0.8414589166641235;
        double cabinetTmp = 0.5860521793365479;
        double compCurrent = 0.003827214241027832;
        double compPower = 0.9386687278747559;
        double compVfdCurr = 0.980285108089447;
        double compVfdFreq = 0.6908504962921143;
        double compVfdVolt = 0.927821f;
        double compVoltage = 0.46268075704574585;
        double coolFlowRate = 0.06930744647979736;
        double coolValvePosn = 0.5201073288917542;
        double dischrgPrs = 0.5370232462882996;
        double dischrgtmp_M = 0.47517257928848267;
        double dischrgtmp_P = 0.3581211566925049;
        double fan1Speed = 0.1934003233909607;
        double fan2Speed = 0.9613986015319824;
        double fan3Speed = 0.7286586165428162;
        double hGBValvePosn = 0.4688141345977783;
        double liquidSubCooling = 0.6697930693626404;
        double liquidtmp_M = 0.9688416719436646;
        double liquidtmp_P = 0.2408191f;
        double suctionPrs = 0.7379346489906311;
        double suctiontmp_M = 0.9411064386367798;
        double suctiontmp_P = 0.5802518129348755;
        double waterInTmp = 0.9545862078666687;
        double waterOutTmp = 0.896969199180603;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold1Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1Telemetry));
        Refrig_Cold1Telemetry item_ = (Refrig_Cold1Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2Telemetry() throws Exception {
        double ambientTmp = 0.3008613f;
        double cabinetTmp = 0.6579626202583313;
        double compCurrent = 0.03028130531311035;
        double compPower = 0.3365599513053894;
        double compVfdCurr = 0.7464718818664551;
        double compVfdFreq = 0.5053682923316956;
        double compVfdVolt = 0.721122f;
        double compVoltage = 0.30348747968673706;
        double coolFlowRate = 0.28231215476989746;
        double coolValvePosn = 0.12685906887054443;
        double dischrgPrs = 0.04280775785446167;
        double dischrgtmp_M = 0.4164009094238281;
        double dischrgtmp_P = 0.1602160930633545;
        double fan1Speed = 0.2971833348274231;
        double fan2Speed = 0.17291676998138428;
        double fan3Speed = 0.3964492678642273;
        double hGBValvePosn = 0.28606903553009033;
        double liquidSubCooling = 0.18219107389450073;
        double liquidtmp_M = 0.45358043909072876;
        double liquidtmp_P = 0.8229976892471313;
        double suctionPrs = 0.07878583669662476;
        double suctiontmp_M = 0.1583128571510315;
        double suctiontmp_P = 0.4715355634689331;
        double waterInTmp = 0.6138122081756592;
        double waterOutTmp = 0.7616521120071411;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold2Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2Telemetry));
        Refrig_Cold2Telemetry item_ = (Refrig_Cold2Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.181441068649292;
        double compCurrent = 0.3565155267715454;
        double compPower = 0.2553596f;
        double compVoltage = 0.24437177181243896;
        double dischrgPrs = 0.55808025598526;
        double dischrgtmp_M = 0.7784669399261475;
        double dischrgtmp_P = 0.1747505f;
        double fanSpeed = 0.5939624309539795;
        double oilLevel = 0.03932642936706543;
        double oilSepTmp = 0.19584494829177856;
        double phaseSepTmp = 0.04350852966308594;
        double suctionPrs = 0.3487668037414551;
        double suctiontmp_M = 0.5736426115036011;
        double suctiontmp_P = 0.4739394187927246;
        double surgeTankTmp = 0.8685665726661682;
        double waterInTmp = 0.18529528379440308;
        double waterOutTmp = 0.8653779029846191;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.7696412205696106;
        double compCurrent = 0.9820922613143921;
        double compPower = 0.3635314702987671;
        double compVoltage = 0.6559988260269165;
        double dischrgPrs = 0.48620766401290894;
        double dischrgtmp_M = 0.15396034717559814;
        double dischrgtmp_P = 0.9419606328010559;
        double fanSpeed = 0.7031729221343994;
        double oilLevel = 0.5105147957801819;
        double oilSepTmp = 0.0745890736579895;
        double phaseSepTmp = 0.5363178253173828;
        double suctionPrs = 0.12388885021209717;
        double suctiontmp_M = 0.93117f;
        double suctiontmp_P = 0.08772832155227661;
        double surgeTankTmp = 0.7913951277732849;
        double waterInTmp = 0.7020647525787354;
        double waterOutTmp = 0.027035772800445557;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.87954181432724;
        double ambientTmp = 0.2168329358100891;
        double cabinetTmp = 0.06456923484802246;
        double compCurrent = 0.7436206340789795;
        double compPower = 0.5795066952705383;
        double compVoltage = 0.4074091911315918;
        double dischrgPrs = 0.1938508152961731;
        double dischrgtmp_M = 0.8240005373954773;
        double dischrgtmp_P = 0.518421471118927;
        double fanSpeed = 0.3058089017868042;
        double oilLevel = 0.4776777f;
        double oilSepTmp = 0.6191377639770508;
        double phaseSepTmp = 0.47795844078063965;
        double suctionPrs = 0.2792188f;
        double suctiontmp_M = 0.5696732997894287;
        double suctiontmp_P = 0.7104860544204712;
        double surgeTankTmp = 0.304135262966156;
        double waterInTmp = 0.656476616859436;
        double waterOutTmp = 0.43687504529953003;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.3795526f;
        double compCurrent = 0.03384626f;
        double compPower = 0.6241716742515564;
        double compVoltage = 0.5565491318702698;
        double dischrgPrs = 0.651703f;
        double dischrgtmp_M = 0.37985825538635254;
        double dischrgtmp_P = 0.2004251480102539;
        double fanSpeed = 0.7636793851852417;
        double oilLevel = 0.8251405954360962;
        double oilSepTmp = 0.35672032833099365;
        double phaseSepTmp = 0.4145827293395996;
        double suctionPrs = 0.4782752990722656;
        double suctiontmp_M = 0.7239797711372375;
        double suctiontmp_P = 0.7197815775871277;
        double surgeTankTmp = 0.9183598160743713;
        double waterInTmp = 0.20888584852218628;
        double waterOutTmp = 0.24312078952789307;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.5844906568527222;
        double ambientTmp = 0.4658542275428772;
        double cabinetTmp = 0.35205912590026855;
        double compCurrent = 0.3917809f;
        double compPower = 0.3365342f;
        double compVoltage = 0.03115654f;
        double dischrgPrs = 0.4191882014274597;
        double dischrgtmp_M = 0.004744529724121094;
        double dischrgtmp_P = 0.6189401745796204;
        double fanSpeed = 0.6160616278648376;
        double oilLevel = 0.22007405757904053;
        double oilSepTmp = 0.541482150554657;
        double phaseSepTmp = 0.5644496083259583;
        double suctionPrs = 0.9477417469024658;
        double suctiontmp_M = 0.03009939193725586;
        double suctiontmp_P = 0.10220110416412354;
        double surgeTankTmp = 0.4452778100967407;
        double waterInTmp = 0.5164448618888855;
        double waterOutTmp = 0.944242537021637;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.5786952972412109;
        double compCurrent = 0.8435121774673462;
        double compPower = 0.5737094879150391;
        double compVoltage = 0.0709908f;
        double dischrgPrs = 0.05176180601119995;
        double dischrgtmp_M = 0.25011515617370605;
        double dischrgtmp_P = 0.4477531909942627;
        double fanSpeed = 0.8028997182846069;
        double oilLevel = 0.4242568016052246;
        double oilSepTmp = 0.5157331228256226;
        double phaseSepTmp = 0.5582222938537598;
        double suctionPrs = 0.494049608707428;
        double suctiontmp_M = 0.32102978229522705;
        double suctiontmp_P = 0.7797937989234924;
        double surgeTankTmp = 0.8791483640670776;
        double waterInTmp = 0.6195932626724243;
        double waterOutTmp = 0.42856353521347046;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_ITelemetry() throws Exception {
        double cip1_I = 0.7638687491416931;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_ITelemetry(cip1_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_ITelemetry));
        Vacuum_CIP1_ITelemetry item_ = (Vacuum_CIP1_ITelemetry)item;
        Assert.assertEquals((double)cip1_I, (double)item_.getCip1_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VTelemetry() throws Exception {
        double cip1_V = 0.9366223216056824;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_VTelemetry(cip1_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VTelemetry));
        Vacuum_CIP1_VTelemetry item_ = (Vacuum_CIP1_VTelemetry)item;
        Assert.assertEquals((double)cip1_V, (double)item_.getCip1_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_ITelemetry() throws Exception {
        double cip2_I = 0.04617792367935181;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_ITelemetry(cip2_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_ITelemetry));
        Vacuum_CIP2_ITelemetry item_ = (Vacuum_CIP2_ITelemetry)item;
        Assert.assertEquals((double)cip2_I, (double)item_.getCip2_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VTelemetry() throws Exception {
        double cip2_V = 0.3258591294288635;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_VTelemetry(cip2_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VTelemetry));
        Vacuum_CIP2_VTelemetry item_ = (Vacuum_CIP2_VTelemetry)item;
        Assert.assertEquals((double)cip2_V, (double)item_.getCip2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_ITelemetry() throws Exception {
        double cip3_I = 0.6397758722305298;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_ITelemetry(cip3_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_ITelemetry));
        Vacuum_CIP3_ITelemetry item_ = (Vacuum_CIP3_ITelemetry)item;
        Assert.assertEquals((double)cip3_I, (double)item_.getCip3_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VTelemetry() throws Exception {
        double cip3_V = 0.19437897205352783;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_VTelemetry(cip3_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VTelemetry));
        Vacuum_CIP3_VTelemetry item_ = (Vacuum_CIP3_VTelemetry)item;
        Assert.assertEquals((double)cip3_V, (double)item_.getCip3_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_ITelemetry() throws Exception {
        double cip4_I = 0.8271254897117615;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_ITelemetry(cip4_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_ITelemetry));
        Vacuum_CIP4_ITelemetry item_ = (Vacuum_CIP4_ITelemetry)item;
        Assert.assertEquals((double)cip4_I, (double)item_.getCip4_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VTelemetry() throws Exception {
        double cip4_V = 0.06476038694381714;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_VTelemetry(cip4_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VTelemetry));
        Vacuum_CIP4_VTelemetry item_ = (Vacuum_CIP4_VTelemetry)item;
        Assert.assertEquals((double)cip4_V, (double)item_.getCip4_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_ITelemetry() throws Exception {
        double cip5_I = 0.9718087911605835;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_ITelemetry(cip5_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_ITelemetry));
        Vacuum_CIP5_ITelemetry item_ = (Vacuum_CIP5_ITelemetry)item;
        Assert.assertEquals((double)cip5_I, (double)item_.getCip5_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VTelemetry() throws Exception {
        double cip5_V = 0.4123146f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_VTelemetry(cip5_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VTelemetry));
        Vacuum_CIP5_VTelemetry item_ = (Vacuum_CIP5_VTelemetry)item;
        Assert.assertEquals((double)cip5_V, (double)item_.getCip5_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_ITelemetry() throws Exception {
        double cip6_I = 0.891336f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_ITelemetry(cip6_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_ITelemetry));
        Vacuum_CIP6_ITelemetry item_ = (Vacuum_CIP6_ITelemetry)item;
        Assert.assertEquals((double)cip6_I, (double)item_.getCip6_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VTelemetry() throws Exception {
        double cip6_V = 0.08645033836364746;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_VTelemetry(cip6_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VTelemetry));
        Vacuum_CIP6_VTelemetry item_ = (Vacuum_CIP6_VTelemetry)item;
        Assert.assertEquals((double)cip6_V, (double)item_.getCip6_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacTelemetry() throws Exception {
        double cryoVac = 0.525852f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoVacTelemetry(cryoVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacTelemetry));
        Vacuum_CryoVacTelemetry item_ = (Vacuum_CryoVacTelemetry)item;
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacTelemetry() throws Exception {
        double forelineVac = 0.12419843673706055;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_ForelineVacTelemetry(forelineVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacTelemetry));
        Vacuum_ForelineVacTelemetry item_ = (Vacuum_ForelineVacTelemetry)item;
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacTelemetry() throws Exception {
        double hex1Vac = 0.8240468502044678;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex1VacTelemetry(hex1Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacTelemetry));
        Vacuum_Hex1VacTelemetry item_ = (Vacuum_Hex1VacTelemetry)item;
        Assert.assertEquals((double)hex1Vac, (double)item_.getHex1Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacTelemetry() throws Exception {
        double hex2Vac = 0.7583534717559814;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex2VacTelemetry(hex2Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacTelemetry));
        Vacuum_Hex2VacTelemetry item_ = (Vacuum_Hex2VacTelemetry)item;
        Assert.assertEquals((double)hex2Vac, (double)item_.getHex2Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentTelemetry() throws Exception {
        double turboCurrent = 0.4666261076927185;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboCurrentTelemetry(turboCurrent));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentTelemetry));
        Vacuum_TurboCurrentTelemetry item_ = (Vacuum_TurboCurrentTelemetry)item;
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerTelemetry() throws Exception {
        double turboPower = 0.21386557817459106;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPowerTelemetry(turboPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerTelemetry));
        Vacuum_TurboPowerTelemetry item_ = (Vacuum_TurboPowerTelemetry)item;
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempTelemetry() throws Exception {
        double turboPumpTemp = 0.36055612564086914;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPumpTempTelemetry(turboPumpTemp));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempTelemetry));
        Vacuum_TurboPumpTempTelemetry item_ = (Vacuum_TurboPumpTempTelemetry)item;
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedTelemetry() throws Exception {
        double turboSpeed = 0.8323262333869934;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboSpeedTelemetry(turboSpeed));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedTelemetry));
        Vacuum_TurboSpeedTelemetry item_ = (Vacuum_TurboSpeedTelemetry)item;
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacTelemetry() throws Exception {
        double turboVac = 0.6992086172103882;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVacTelemetry(turboVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacTelemetry));
        Vacuum_TurboVacTelemetry item_ = (Vacuum_TurboVacTelemetry)item;
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageTelemetry() throws Exception {
        double turboVoltage = 0.9445028305053711;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVoltageTelemetry(turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageTelemetry));
        Vacuum_TurboVoltageTelemetry item_ = (Vacuum_TurboVoltageTelemetry)item;
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.2161598801612854;
        double freeFraction = 0.3641442656517029;
        double freeSpace = 0.8141933679580688;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)265829555);
        String location = "u";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)1588861163);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)1831495017);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)224176860);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)-1670959403);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)-1789127521);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)1224961121);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)1212539088);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)852705873);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)160394445);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-611394886);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)-168909620);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)1290174990);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)-993397103);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)-1989432275);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-684067286);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)-1195188908);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)1075929698);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)830560095);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)747590342);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)722072377);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-577998989);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)-525564043);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)-779046139);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)1467283546);
        String location = "s";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)-916078055);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)404276167);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)-296154119);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)944389036);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)-1051994494);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-274122945);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)82069906);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)-1139301294);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)1007578839);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)-930187620);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)-723292356);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)1078355669);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)-1190906171);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-120479088);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)933835646);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)-1236318131);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-395782056);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)554568337);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)1174158134);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)-13892084);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)229383545);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)2112817681);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)593166525);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)-971302927);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)47392183);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)932316403);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)645171529);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)523027453);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)-560942007);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)1403467577);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)-39023469);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)-1839900890);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.27157366275787354;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)1436765185);
        String location = "";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }
}

