/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameServiceConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_timersConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.HexConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Hex_Maq20x_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent;
import org.lsst.sal.camera.event.Image_handling_Reb_GeneralConfigurationEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.RebpowerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManagerConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_RebConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_PowerConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_CoolMaq20_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_CompLimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DeviceConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_LimitsConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasksConfigurationEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_timersConfigurationEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.event.Vacuum_AgentMonitorServiceConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6CConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6_IConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6_VConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_ForelineVacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_ForelineVacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_HeartbeatConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex1VacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex1VacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex2VacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Hex2VacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumpsConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_checkConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_publishConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_updateConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_RuntimeInfoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_SchedulersConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboCurrentConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPowerConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPumpConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPumpTempConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboSpeedConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVacConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVacGaugeConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVoltageConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_VacPlutoConfigurationEvent;
import org.lsst.sal.camera.event.Vacuum_Vacuum_stateConfigurationEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 379;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 977;
        String imageName = "kpffmnwkoekwxqcrkm";
        int imageIndex = 389;
        String imageSource = "";
        String imageController = "";
        String imageDate = "udwlsjy";
        int imageNumber = 299;
        double timestampAcquisitionStart = 0.5973697304725647;
        double requestedExposureTime = 0.5855571627616882;
        double timestampEndOfReadout = 0.20897942781448364;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 267;
        double timestampTransition = 0.37829506397247314;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 424;
        String filterName = "l";
        String filterType = "o";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 819;
        double timestampTransition = 0.5741432905197144;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 166;
        double timestampTransition = 0.2913547158241272;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 874;
        double timestampTransition = 0.07489949464797974;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 418;
        double timestampTransition = 0.9309825897216797;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 376;
        double timestampTransition = 0.38669872283935547;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 932;
        String additionalKeys = "";
        String additionalValues = "l";
        int imagesInSequence = 151;
        String imageName = "kwkiqzeetslvdrdpyn";
        int imageIndex = 335;
        String imageSource = "e";
        String imageController = "";
        String imageDate = "hn";
        int imageNumber = 399;
        double timestampAcquisitionStart = 0.9397023916244507;
        double exposureTime = 0.6912664771080017;
        String imageTag = "vpreprkfuytkjuyhyzwirzilycb";
        double timestampDateObs = 0.18176805973052979;
        double timestampDateEnd = 0.6745571494102478;
        double measuredShutterOpenTime = 0.3576050400733948;
        double darkTime = 0.837174117565155;
        String emulatedImage = "a";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 751;
        double timestampTransition = 0.9751831293106079;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 940;
        double timestampTransition = 0.01255100965499878;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 96;
        double timestampTransition = 0.8405311107635498;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 611;
        double timestampTransition = 0.17844295501708984;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 619;
        double timestampTransition = 0.6389796137809753;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 532;
        double timestampTransition = 0.40296316146850586;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 961;
        double timestampTransition = 0.28438347578048706;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 949;
        double timestampTransition = 0.5390076041221619;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 103;
        String additionalKeys = "y";
        String additionalValues = "e";
        int imagesInSequence = 688;
        String imageName = "pjijblghnyjpffbcks";
        int imageIndex = 423;
        String imageSource = "";
        String imageController = "w";
        String imageDate = "puhjt";
        int imageNumber = 514;
        double timestampAcquisitionStart = 0.5767078399658203;
        double exposureTime = 0.041435956954956055;
        String mode = "g";
        double timeout = 0.6267383098602295;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, mode, timeout));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)mode, (Object)item_.getMode());
        Assert.assertEquals((double)timeout, (double)item_.getTimeout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 215;
        double timestampTransition = 0.79919f;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 191;
        String filterName = "";
        String filterType = "q";
        int filterSlot = 773;
        double filterPosition = 0.7346276640892029;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 440;
        double timestampTransition = 0.6444873213768005;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 874;
        String filterNames = "yjgsyfqdeelosixirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpk";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 648;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 787;
        String imageName = "anwcangdisqfvxuqwqysi";
        int imageIndex = 184;
        String imageSource = "";
        String imageController = "m";
        String imageDate = "yjrzx";
        int imageNumber = 796;
        double timestampAcquisitionStart = 0.8657287359237671;
        double exposureTime = 0.4734336733818054;
        double timestampStartOfReadout = 0.23562753200531006;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 899;
        double timestampTransition = 0.1400158405303955;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 722;
        String imageName = "a";
        String ccdLocation = "z";
        String raftBay = "";
        String ccdSlot = "n";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = TestHelper.generateIntArray((int)201, (int)395252757);
        int[] overCols = TestHelper.generateIntArray((int)201, (int)1207523846);
        int[] readRows = TestHelper.generateIntArray((int)201, (int)861089503);
        int[] readCols = TestHelper.generateIntArray((int)201, (int)-366484697);
        int[] readCols2 = TestHelper.generateIntArray((int)201, (int)-1671092238);
        int[] preCols = TestHelper.generateIntArray((int)201, (int)947418342);
        int[] preRows = TestHelper.generateIntArray((int)201, (int)834180824);
        int[] postCols = TestHelper.generateIntArray((int)201, (int)-1512170075);
        int[] underCols = TestHelper.generateIntArray((int)201, (int)-1558744933);
        String daqFolder = "d";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 100;
        String ccdLocation = "b";
        String raftBay = "x";
        String ccdSlot = "o";
        String rebSerialNumber = "f";
        String rebLSSTName = "v";
        String ccdLSSTName = "";
        String raftLSSTName = "";
        String ccdManSerNum = "r";
        String ccdManufacturer = "f";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)212, (int)1259435401);
        String sequencerKey = "";
        String sequencerChecksum = "c";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsConfigurationEvent() throws Exception {
        int priority = 611;
        String version = "s";
        double clean_5_24V_I_warnHi = 0.5685842633247375;
        double clean_5_24V_I_warnLo = 0.4770635962486267;
        double clean_5_24V_I_limitHi = 0.5543696880340576;
        double clean_5_24V_I_limitLo = 0.7836690545082092;
        double dirty_24V_I_warnHi = 0.40061742067337036;
        double dirty_24V_I_warnLo = 0.4515455961227417;
        double dirty_24V_I_limitHi = 0.786760687828064;
        double dirty_24V_I_limitLo = 0.11390924453735352;
        double dirty_28V_I_warnHi = 0.27820414304733276;
        double dirty_28V_I_warnLo = 0.8154560327529907;
        double dirty_28V_I_limitHi = 0.8078804016113281;
        double dirty_28V_I_limitLo = 0.01894927f;
        double dirty_48V_I_warnHi = 0.3528527021408081;
        double dirty_48V_I_warnLo = 0.9307073354721069;
        double dirty_48V_I_limitHi = 0.974181592464447;
        double dirty_48V_I_limitLo = 0.41983598470687866;
        double heater_I_warnHi = 0.9204593300819397;
        double heater_I_warnLo = 0.844366192817688;
        double heater_I_limitHi = 0.6191104650497437;
        double heater_I_limitLo = 0.18111753463745117;
        double protection_I_warnHi = 0.6157971620559692;
        double protection_I_warnLo = 0.5302456617355347;
        double protection_I_limitHi = 0.45018547773361206;
        double protection_I_limitLo = 0.1085214f;
        double rebps_0_2_I_warnHi = 0.44511836767196655;
        double rebps_0_2_I_warnLo = 0.9004220366477966;
        double rebps_0_2_I_limitHi = 0.36087822914123535;
        double rebps_0_2_I_limitLo = 0.7641117572784424;
        double rebps_3_5_I_warnHi = 0.8607092499732971;
        double rebps_3_5_I_warnLo = 0.12108564376831055;
        double rebps_3_5_I_limitHi = 0.39221322536468506;
        double rebps_3_5_I_limitLo = 0.8009426593780518;
        double rebps_6_8_I_warnHi = 0.9310056567192078;
        double rebps_6_8_I_warnLo = 0.6005901098251343;
        double rebps_6_8_I_limitHi = 0.20480185747146606;
        double rebps_6_8_I_limitLo = 0.674481213092804;
        double rebps_9_12_I_warnHi = 0.40960294008255005;
        double rebps_9_12_I_warnLo = 0.7907758355140686;
        double rebps_9_12_I_limitHi = 0.450225293636322;
        double rebps_9_12_I_limitLo = 0.19921225309371948;
        double rebps_Spr_I_warnHi = 0.6649788618087769;
        double rebps_Spr_I_warnLo = 0.6136229634284973;
        double rebps_Spr_I_limitHi = 0.784142255783081;
        double rebps_Spr_I_limitLo = 0.5766582489013672;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsConfigurationEvent(priority, version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, heater_I_warnHi, heater_I_warnLo, heater_I_limitHi, heater_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_2_I_warnHi, rebps_0_2_I_warnLo, rebps_0_2_I_limitHi, rebps_0_2_I_limitLo, rebps_3_5_I_warnHi, rebps_3_5_I_warnLo, rebps_3_5_I_limitHi, rebps_3_5_I_limitLo, rebps_6_8_I_warnHi, rebps_6_8_I_warnLo, rebps_6_8_I_limitHi, rebps_6_8_I_limitLo, rebps_9_12_I_warnHi, rebps_9_12_I_warnLo, rebps_9_12_I_limitHi, rebps_9_12_I_limitLo, rebps_Spr_I_warnHi, rebps_Spr_I_warnLo, rebps_Spr_I_limitHi, rebps_Spr_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsConfigurationEvent));
        Quadbox_BFR_LimitsConfigurationEvent item_ = (Quadbox_BFR_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnHi, (double)item_.getHeater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnLo, (double)item_.getHeater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitHi, (double)item_.getHeater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitLo, (double)item_.getHeater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnHi, (double)item_.getRebps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnLo, (double)item_.getRebps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitHi, (double)item_.getRebps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitLo, (double)item_.getRebps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnHi, (double)item_.getRebps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnLo, (double)item_.getRebps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitHi, (double)item_.getRebps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitLo, (double)item_.getRebps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnHi, (double)item_.getRebps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnLo, (double)item_.getRebps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitHi, (double)item_.getRebps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitLo, (double)item_.getRebps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnHi, (double)item_.getRebps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnLo, (double)item_.getRebps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitHi, (double)item_.getRebps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitLo, (double)item_.getRebps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnHi, (double)item_.getRebps_Spr_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnLo, (double)item_.getRebps_Spr_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitHi, (double)item_.getRebps_Spr_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitLo, (double)item_.getRebps_Spr_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxConfigurationEvent() throws Exception {
        int priority = 760;
        String version = "o";
        int node = 435;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxConfigurationEvent));
        Quadbox_BFR_QuadboxConfigurationEvent item_ = (Quadbox_BFR_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsConfigurationEvent() throws Exception {
        int priority = 996;
        String version = "";
        double n_24vc_Board_T_warnHi = 0.8927491903305054;
        double n_24vc_Board_T_warnLo = 0.6827614307403564;
        double n_24vc_Board_T_limitHi = 0.16119670867919922;
        double n_24vc_Board_T_limitLo = 0.9963732957839966;
        double n_24vc_FPGA_T_warnHi = 0.07531487941741943;
        double n_24vc_FPGA_T_warnLo = 0.2367112f;
        double n_24vc_FPGA_T_limitHi = 0.6531934142112732;
        double n_24vc_FPGA_T_limitLo = 0.3906674385070801;
        double n_24vc_Main_I_warnHi = 0.2345457673072815;
        double n_24vc_Main_I_warnLo = 0.482200026512146;
        double n_24vc_Main_I_limitHi = 0.2835758328437805;
        double n_24vc_Main_I_limitLo = 0.8459919691085815;
        double n_24vc_Main_T_warnHi = 0.2846637964248657;
        double n_24vc_Main_T_warnLo = 0.5211543440818787;
        double n_24vc_Main_T_limitHi = 0.7494170665740967;
        double n_24vc_Main_T_limitLo = 0.29583287239074707;
        double n_24vc_Main_V_warnHi = 0.25458717346191406;
        double n_24vc_Main_V_warnLo = 0.2159196138381958;
        double n_24vc_Main_V_limitHi = 0.07165837287902832;
        double n_24vc_Main_V_limitLo = 0.53737473487854;
        double body_Purge_I_warnHi = 0.3688596487045288;
        double body_Purge_I_warnLo = 0.7609010338783264;
        double body_Purge_I_limitHi = 0.2154766321182251;
        double body_Purge_I_limitLo = 0.4796936511993408;
        double body_Purge_V_warnHi = 0.380581796169281;
        double body_Purge_V_warnLo = 0.8659494519233704;
        double body_Purge_V_limitHi = 0.8885037302970886;
        double body_Purge_V_limitLo = 0.4119594097137451;
        double bpu_Maq20_I_warnHi = 0.2212618f;
        double bpu_Maq20_I_warnLo = 0.7315186858177185;
        double bpu_Maq20_I_limitHi = 0.02538210153579712;
        double bpu_Maq20_I_limitLo = 0.5617164969444275;
        double bpu_Maq20_V_warnHi = 0.5828642249107361;
        double bpu_Maq20_V_warnLo = 0.05298245f;
        double bpu_Maq20_V_limitHi = 0.17073094844818115;
        double bpu_Maq20_V_limitLo = 0.08198577165603638;
        double fes_Shu_HCU_I_warnHi = 0.10556250810623169;
        double fes_Shu_HCU_I_warnLo = 0.300825834274292;
        double fes_Shu_HCU_I_limitHi = 0.15915173292160034;
        double fes_Shu_HCU_I_limitLo = 0.4622097f;
        double fes_Shu_HCU_V_warnHi = 0.021161377429962158;
        double fes_Shu_HCU_V_warnLo = 0.5130382180213928;
        double fes_Shu_HCU_V_limitHi = 0.7473477721214294;
        double fes_Shu_HCU_V_limitLo = 0.6755883693695068;
        double gauges_I_warnHi = 0.5228105187416077;
        double gauges_I_warnLo = 0.037378907203674316;
        double gauges_I_limitHi = 0.9072979688644409;
        double gauges_I_limitLo = 0.9558776617050171;
        double gauges_V_warnHi = 0.688093900680542;
        double gauges_V_warnLo = 0.7588313817977905;
        double gauges_V_limitHi = 0.4588811993598938;
        double gauges_V_limitLo = 0.3201286196708679;
        double ion_Pumps_I_warnHi = 0.3820696473121643;
        double ion_Pumps_I_warnLo = 0.7292030453681946;
        double ion_Pumps_I_limitHi = 0.36418086290359497;
        double ion_Pumps_I_limitLo = 0.02814584970474243;
        double ion_Pumps_V_warnHi = 0.382207453250885;
        double ion_Pumps_V_warnLo = 0.12228578329086304;
        double ion_Pumps_V_limitHi = 0.973324716091156;
        double ion_Pumps_V_limitLo = 0.38076627254486084;
        double pwr_Cry_HCU_I_warnHi = 0.6869021058082581;
        double pwr_Cry_HCU_I_warnLo = 0.6132139563560486;
        double pwr_Cry_HCU_I_limitHi = 0.5931679606437683;
        double pwr_Cry_HCU_I_limitLo = 0.22166311740875244;
        double pwr_Cry_HCU_V_warnHi = 0.04742974042892456;
        double pwr_Cry_HCU_V_warnLo = 0.6217074990272522;
        double pwr_Cry_HCU_V_limitHi = 0.1260806918144226;
        double pwr_Cry_HCU_V_limitLo = 0.41364985704421997;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsConfigurationEvent(priority, version, n_24vc_Board_T_warnHi, n_24vc_Board_T_warnLo, n_24vc_Board_T_limitHi, n_24vc_Board_T_limitLo, n_24vc_FPGA_T_warnHi, n_24vc_FPGA_T_warnLo, n_24vc_FPGA_T_limitHi, n_24vc_FPGA_T_limitLo, n_24vc_Main_I_warnHi, n_24vc_Main_I_warnLo, n_24vc_Main_I_limitHi, n_24vc_Main_I_limitLo, n_24vc_Main_T_warnHi, n_24vc_Main_T_warnLo, n_24vc_Main_T_limitHi, n_24vc_Main_T_limitLo, n_24vc_Main_V_warnHi, n_24vc_Main_V_warnLo, n_24vc_Main_V_limitHi, n_24vc_Main_V_limitLo, body_Purge_I_warnHi, body_Purge_I_warnLo, body_Purge_I_limitHi, body_Purge_I_limitLo, body_Purge_V_warnHi, body_Purge_V_warnLo, body_Purge_V_limitHi, body_Purge_V_limitLo, bpu_Maq20_I_warnHi, bpu_Maq20_I_warnLo, bpu_Maq20_I_limitHi, bpu_Maq20_I_limitLo, bpu_Maq20_V_warnHi, bpu_Maq20_V_warnLo, bpu_Maq20_V_limitHi, bpu_Maq20_V_limitLo, fes_Shu_HCU_I_warnHi, fes_Shu_HCU_I_warnLo, fes_Shu_HCU_I_limitHi, fes_Shu_HCU_I_limitLo, fes_Shu_HCU_V_warnHi, fes_Shu_HCU_V_warnLo, fes_Shu_HCU_V_limitHi, fes_Shu_HCU_V_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, pwr_Cry_HCU_I_warnHi, pwr_Cry_HCU_I_warnLo, pwr_Cry_HCU_I_limitHi, pwr_Cry_HCU_I_limitLo, pwr_Cry_HCU_V_warnHi, pwr_Cry_HCU_V_warnLo, pwr_Cry_HCU_V_limitHi, pwr_Cry_HCU_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsConfigurationEvent));
        Quadbox_PDU_24VC_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VC_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)n_24vc_Board_T_warnHi, (double)item_.getN_24vc_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_warnLo, (double)item_.getN_24vc_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_limitHi, (double)item_.getN_24vc_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_limitLo, (double)item_.getN_24vc_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_warnHi, (double)item_.getN_24vc_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_warnLo, (double)item_.getN_24vc_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_limitHi, (double)item_.getN_24vc_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_limitLo, (double)item_.getN_24vc_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_warnHi, (double)item_.getN_24vc_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_warnLo, (double)item_.getN_24vc_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_limitHi, (double)item_.getN_24vc_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_limitLo, (double)item_.getN_24vc_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_warnHi, (double)item_.getN_24vc_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_warnLo, (double)item_.getN_24vc_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_limitHi, (double)item_.getN_24vc_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_limitLo, (double)item_.getN_24vc_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_warnHi, (double)item_.getN_24vc_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_warnLo, (double)item_.getN_24vc_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_limitHi, (double)item_.getN_24vc_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_limitLo, (double)item_.getN_24vc_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnHi, (double)item_.getBody_Purge_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnLo, (double)item_.getBody_Purge_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitHi, (double)item_.getBody_Purge_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitLo, (double)item_.getBody_Purge_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnHi, (double)item_.getBody_Purge_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnLo, (double)item_.getBody_Purge_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitHi, (double)item_.getBody_Purge_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitLo, (double)item_.getBody_Purge_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnHi, (double)item_.getBpu_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnLo, (double)item_.getBpu_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitHi, (double)item_.getBpu_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitLo, (double)item_.getBpu_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnHi, (double)item_.getBpu_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnLo, (double)item_.getBpu_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitHi, (double)item_.getBpu_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitLo, (double)item_.getBpu_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnHi, (double)item_.getFes_Shu_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnLo, (double)item_.getFes_Shu_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitHi, (double)item_.getFes_Shu_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitLo, (double)item_.getFes_Shu_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnHi, (double)item_.getFes_Shu_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnLo, (double)item_.getFes_Shu_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitHi, (double)item_.getFes_Shu_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitLo, (double)item_.getFes_Shu_HCU_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnHi, (double)item_.getPwr_Cry_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnLo, (double)item_.getPwr_Cry_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitHi, (double)item_.getPwr_Cry_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitLo, (double)item_.getPwr_Cry_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnHi, (double)item_.getPwr_Cry_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnLo, (double)item_.getPwr_Cry_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitHi, (double)item_.getPwr_Cry_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitLo, (double)item_.getPwr_Cry_HCU_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxConfigurationEvent() throws Exception {
        int priority = 581;
        String version = "";
        int node = 821;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxConfigurationEvent));
        Quadbox_PDU_24VC_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VC_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsConfigurationEvent() throws Exception {
        int priority = 59;
        String version = "s";
        double n_24vd_Board_T_warnHi = 0.07299137115478516;
        double n_24vd_Board_T_warnLo = 0.14174103736877441;
        double n_24vd_Board_T_limitHi = 0.8059961199760437;
        double n_24vd_Board_T_limitLo = 0.6128490567207336;
        double n_24vd_FPGA_T_warnHi = 0.6959515810012817;
        double n_24vd_FPGA_T_warnLo = 0.2795097231864929;
        double n_24vd_FPGA_T_limitHi = 0.8401201963424683;
        double n_24vd_FPGA_T_limitLo = 0.8434627056121826;
        double n_24vd_Main_I_warnHi = 0.03871506452560425;
        double n_24vd_Main_I_warnLo = 0.01616931f;
        double n_24vd_Main_I_limitHi = 0.42615455389022827;
        double n_24vd_Main_I_limitLo = 0.3754054307937622;
        double n_24vd_Main_T_warnHi = 0.2668830156326294;
        double n_24vd_Main_T_warnLo = 0.29815244674682617;
        double n_24vd_Main_T_limitHi = 0.3598290681838989;
        double n_24vd_Main_T_limitLo = 0.8939803838729858;
        double n_24vd_Main_V_warnHi = 0.4671194553375244;
        double n_24vd_Main_V_warnLo = 0.08714598417282104;
        double n_24vd_Main_V_limitHi = 0.6992331743240356;
        double n_24vd_Main_V_limitLo = 0.4956783652305603;
        double cryo_Turbo_I_warnHi = 0.5278825759887695;
        double cryo_Turbo_I_warnLo = 0.6096928715705872;
        double cryo_Turbo_I_limitHi = 0.6548991799354553;
        double cryo_Turbo_I_limitLo = 0.564589f;
        double cryo_Turbo_V_warnHi = 0.9360262751579285;
        double cryo_Turbo_V_warnLo = 0.9758511185646057;
        double cryo_Turbo_V_limitHi = 0.6161421537399292;
        double cryo_Turbo_V_limitLo = 0.6513291001319885;
        double hex_Turbo_I_warnHi = 0.7912827730178833;
        double hex_Turbo_I_warnLo = 0.7242476940155029;
        double hex_Turbo_I_limitHi = 0.674912691116333;
        double hex_Turbo_I_limitLo = 0.16533923149108887;
        double hex_Turbo_V_warnHi = 0.2855575f;
        double hex_Turbo_V_warnLo = 0.7123373746871948;
        double hex_Turbo_V_limitHi = 0.2191150188446045;
        double hex_Turbo_V_limitLo = 0.5070011615753174;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsConfigurationEvent(priority, version, n_24vd_Board_T_warnHi, n_24vd_Board_T_warnLo, n_24vd_Board_T_limitHi, n_24vd_Board_T_limitLo, n_24vd_FPGA_T_warnHi, n_24vd_FPGA_T_warnLo, n_24vd_FPGA_T_limitHi, n_24vd_FPGA_T_limitLo, n_24vd_Main_I_warnHi, n_24vd_Main_I_warnLo, n_24vd_Main_I_limitHi, n_24vd_Main_I_limitLo, n_24vd_Main_T_warnHi, n_24vd_Main_T_warnLo, n_24vd_Main_T_limitHi, n_24vd_Main_T_limitLo, n_24vd_Main_V_warnHi, n_24vd_Main_V_warnLo, n_24vd_Main_V_limitHi, n_24vd_Main_V_limitLo, cryo_Turbo_I_warnHi, cryo_Turbo_I_warnLo, cryo_Turbo_I_limitHi, cryo_Turbo_I_limitLo, cryo_Turbo_V_warnHi, cryo_Turbo_V_warnLo, cryo_Turbo_V_limitHi, cryo_Turbo_V_limitLo, hex_Turbo_I_warnHi, hex_Turbo_I_warnLo, hex_Turbo_I_limitHi, hex_Turbo_I_limitLo, hex_Turbo_V_warnHi, hex_Turbo_V_warnLo, hex_Turbo_V_limitHi, hex_Turbo_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsConfigurationEvent));
        Quadbox_PDU_24VD_LimitsConfigurationEvent item_ = (Quadbox_PDU_24VD_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)n_24vd_Board_T_warnHi, (double)item_.getN_24vd_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_warnLo, (double)item_.getN_24vd_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_limitHi, (double)item_.getN_24vd_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_limitLo, (double)item_.getN_24vd_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_warnHi, (double)item_.getN_24vd_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_warnLo, (double)item_.getN_24vd_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_limitHi, (double)item_.getN_24vd_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_limitLo, (double)item_.getN_24vd_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_warnHi, (double)item_.getN_24vd_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_warnLo, (double)item_.getN_24vd_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_limitHi, (double)item_.getN_24vd_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_limitLo, (double)item_.getN_24vd_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_warnHi, (double)item_.getN_24vd_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_warnLo, (double)item_.getN_24vd_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_limitHi, (double)item_.getN_24vd_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_limitLo, (double)item_.getN_24vd_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_warnHi, (double)item_.getN_24vd_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_warnLo, (double)item_.getN_24vd_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_limitHi, (double)item_.getN_24vd_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_limitLo, (double)item_.getN_24vd_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnHi, (double)item_.getCryo_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnLo, (double)item_.getCryo_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitHi, (double)item_.getCryo_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitLo, (double)item_.getCryo_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnHi, (double)item_.getCryo_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnLo, (double)item_.getCryo_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitHi, (double)item_.getCryo_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitLo, (double)item_.getCryo_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnHi, (double)item_.getHex_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnLo, (double)item_.getHex_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitHi, (double)item_.getHex_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitLo, (double)item_.getHex_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnHi, (double)item_.getHex_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnLo, (double)item_.getHex_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitHi, (double)item_.getHex_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitLo, (double)item_.getHex_Turbo_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxConfigurationEvent() throws Exception {
        int priority = 738;
        String version = "";
        int node = 263;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxConfigurationEvent));
        Quadbox_PDU_24VD_QuadboxConfigurationEvent item_ = (Quadbox_PDU_24VD_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsConfigurationEvent() throws Exception {
        int priority = 694;
        String version = "";
        double n_48v_Board_T_warnHi = 0.08437883853912354;
        double n_48v_Board_T_warnLo = 0.7347772717475891;
        double n_48v_Board_T_limitHi = 0.8349572420120239;
        double n_48v_Board_T_limitLo = 0.05315440893173218;
        double n_48v_FPGA_T_warnHi = 0.8198965191841125;
        double n_48v_FPGA_T_warnLo = 0.5077343583106995;
        double n_48v_FPGA_T_limitHi = 0.7708647847175598;
        double n_48v_FPGA_T_limitLo = 0.2524857521057129;
        double n_48v_Main_I_warnHi = 0.9283267855644226;
        double n_48v_Main_I_warnLo = 0.4557059407234192;
        double n_48v_Main_I_limitHi = 0.08200287818908691;
        double n_48v_Main_I_limitLo = 0.8293628096580505;
        double n_48v_Main_T_warnHi = 0.8970068693161011;
        double n_48v_Main_T_warnLo = 0.2322337031364441;
        double n_48v_Main_T_limitHi = 0.659993f;
        double n_48v_Main_T_limitLo = 0.9325717687606812;
        double n_48v_Main_V_warnHi = 0.4854145050048828;
        double n_48v_Main_V_warnLo = 0.18520653247833252;
        double n_48v_Main_V_limitHi = 0.35989898443222046;
        double n_48v_Main_V_limitLo = 0.22506767511367798;
        double purge_Fan_I_warnHi = 0.14500826597213745;
        double purge_Fan_I_warnLo = 0.10195744037628174;
        double purge_Fan_I_limitHi = 0.7472650408744812;
        double purge_Fan_I_limitLo = 0.7284701466560364;
        double purge_Fan_V_warnHi = 0.5455885529518127;
        double purge_Fan_V_warnLo = 0.8110129237174988;
        double purge_Fan_V_limitHi = 0.19291293621063232;
        double purge_Fan_V_limitLo = 0.7421621084213257;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsConfigurationEvent(priority, version, n_48v_Board_T_warnHi, n_48v_Board_T_warnLo, n_48v_Board_T_limitHi, n_48v_Board_T_limitLo, n_48v_FPGA_T_warnHi, n_48v_FPGA_T_warnLo, n_48v_FPGA_T_limitHi, n_48v_FPGA_T_limitLo, n_48v_Main_I_warnHi, n_48v_Main_I_warnLo, n_48v_Main_I_limitHi, n_48v_Main_I_limitLo, n_48v_Main_T_warnHi, n_48v_Main_T_warnLo, n_48v_Main_T_limitHi, n_48v_Main_T_limitLo, n_48v_Main_V_warnHi, n_48v_Main_V_warnLo, n_48v_Main_V_limitHi, n_48v_Main_V_limitLo, purge_Fan_I_warnHi, purge_Fan_I_warnLo, purge_Fan_I_limitHi, purge_Fan_I_limitLo, purge_Fan_V_warnHi, purge_Fan_V_warnLo, purge_Fan_V_limitHi, purge_Fan_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsConfigurationEvent));
        Quadbox_PDU_48V_LimitsConfigurationEvent item_ = (Quadbox_PDU_48V_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)n_48v_Board_T_warnHi, (double)item_.getN_48v_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_warnLo, (double)item_.getN_48v_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_limitHi, (double)item_.getN_48v_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_limitLo, (double)item_.getN_48v_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_warnHi, (double)item_.getN_48v_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_warnLo, (double)item_.getN_48v_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_limitHi, (double)item_.getN_48v_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_limitLo, (double)item_.getN_48v_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_warnHi, (double)item_.getN_48v_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_warnLo, (double)item_.getN_48v_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_limitHi, (double)item_.getN_48v_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_limitLo, (double)item_.getN_48v_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_warnHi, (double)item_.getN_48v_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_warnLo, (double)item_.getN_48v_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_limitHi, (double)item_.getN_48v_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_limitLo, (double)item_.getN_48v_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_warnHi, (double)item_.getN_48v_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_warnLo, (double)item_.getN_48v_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_limitHi, (double)item_.getN_48v_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_limitLo, (double)item_.getN_48v_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnHi, (double)item_.getPurge_Fan_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnLo, (double)item_.getPurge_Fan_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitHi, (double)item_.getPurge_Fan_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitLo, (double)item_.getPurge_Fan_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnHi, (double)item_.getPurge_Fan_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnLo, (double)item_.getPurge_Fan_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitHi, (double)item_.getPurge_Fan_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitLo, (double)item_.getPurge_Fan_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxConfigurationEvent() throws Exception {
        int priority = 870;
        String version = "";
        int node = 525;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxConfigurationEvent));
        Quadbox_PDU_48V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_48V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsConfigurationEvent() throws Exception {
        int priority = 704;
        String version = "w";
        double otm_0_A_I_warnHi = 0.8688523173332214;
        double otm_0_A_I_warnLo = 0.05147433280944824;
        double otm_0_A_I_limitHi = 0.7004167437553406;
        double otm_0_A_I_limitLo = 0.6102726459503174;
        double otm_0_A_V_warnHi = 0.16373854875564575;
        double otm_0_A_V_warnLo = 0.2257222f;
        double otm_0_A_V_limitHi = 0.6810241937637329;
        double otm_0_A_V_limitLo = 0.1661999225616455;
        double otm_0_B_I_warnHi = 0.9088693857192993;
        double otm_0_B_I_warnLo = 0.11945706605911255;
        double otm_0_B_I_limitHi = 0.2741441f;
        double otm_0_B_I_limitLo = 0.766837f;
        double otm_0_B_V_warnHi = 0.7217692732810974;
        double otm_0_B_V_warnLo = 0.5272254347801208;
        double otm_0_B_V_limitHi = 0.7229553461074829;
        double otm_0_B_V_limitLo = 0.9956062436103821;
        double otm_1_A_I_warnHi = 0.9965223670005798;
        double otm_1_A_I_warnLo = 0.14721661806106567;
        double otm_1_A_I_limitHi = 0.4042872190475464;
        double otm_1_A_I_limitLo = 0.6199347376823425;
        double otm_1_A_V_warnHi = 0.746765673160553;
        double otm_1_A_V_warnLo = 0.9629706144332886;
        double otm_1_A_V_limitHi = 0.8263643383979797;
        double otm_1_A_V_limitLo = 0.6142929196357727;
        double otm_1_B_I_warnHi = 0.6880226731300354;
        double otm_1_B_I_warnLo = 0.6466214656829834;
        double otm_1_B_I_limitHi = 0.6851903200149536;
        double otm_1_B_I_limitLo = 0.41917216777801514;
        double otm_1_B_V_warnHi = 0.5601454377174377;
        double otm_1_B_V_warnLo = 0.33406996726989746;
        double otm_1_B_V_limitHi = 0.5312292575836182;
        double otm_1_B_V_limitLo = 0.7347690463066101;
        double otm_2_A_I_warnHi = 0.36329346895217896;
        double otm_2_A_I_warnLo = 0.4870149f;
        double otm_2_A_I_limitHi = 0.22898507118225098;
        double otm_2_A_I_limitLo = 0.6373441815376282;
        double otm_2_A_V_warnHi = 0.6345996856689453;
        double otm_2_A_V_warnLo = 0.276350736618042;
        double otm_2_A_V_limitHi = 0.5662907958030701;
        double otm_2_A_V_limitLo = 0.4810322f;
        double otm_2_B_I_warnHi = 0.17140984535217285;
        double otm_2_B_I_warnLo = 0.2860983610153198;
        double otm_2_B_I_limitHi = 0.2018665075302124;
        double otm_2_B_I_limitLo = 0.8623965978622437;
        double otm_2_B_V_warnHi = 0.2078021764755249;
        double otm_2_B_V_warnLo = 0.027436554431915283;
        double otm_2_B_V_limitHi = 0.3213622570037842;
        double otm_2_B_V_limitLo = 0.8489788770675659;
        double otm_3_A_I_warnHi = 0.17418742179870605;
        double otm_3_A_I_warnLo = 0.08984065055847168;
        double otm_3_A_I_limitHi = 0.4241867661476135;
        double otm_3_A_I_limitLo = 0.9418308734893799;
        double otm_3_A_V_warnHi = 0.9684880375862122;
        double otm_3_A_V_warnLo = 0.9527187347412109;
        double otm_3_A_V_limitHi = 0.18455815315246582;
        double otm_3_A_V_limitLo = 0.6065274477005005;
        double otm_3_B_I_warnHi = 0.4981291890144348;
        double otm_3_B_I_warnLo = 0.8888053894042969;
        double otm_3_B_I_limitHi = 0.24716395139694214;
        double otm_3_B_I_limitLo = 0.18402493000030518;
        double otm_3_B_V_warnHi = 0.9244294762611389;
        double otm_3_B_V_warnLo = 0.7530982494354248;
        double otm_3_B_V_limitHi = 0.6354634165763855;
        double otm_3_B_V_limitLo = 0.11419862508773804;
        double otm_4_A_I_warnHi = 0.06763821840286255;
        double otm_4_A_I_warnLo = 0.15208107233047485;
        double otm_4_A_I_limitHi = 0.502015f;
        double otm_4_A_I_limitLo = 0.4687958359718323;
        double otm_4_A_V_warnHi = 0.2776569128036499;
        double otm_4_A_V_warnLo = 0.8017957806587219;
        double otm_4_A_V_limitHi = 0.646397590637207;
        double otm_4_A_V_limitLo = 0.11037266254425049;
        double otm_4_B_I_warnHi = 0.4113478f;
        double otm_4_B_I_warnLo = 0.2250347137451172;
        double otm_4_B_I_limitHi = 0.3065752387046814;
        double otm_4_B_I_limitLo = 0.4486308693885803;
        double otm_4_B_V_warnHi = 0.5043429136276245;
        double otm_4_B_V_warnLo = 0.11318850517272949;
        double otm_4_B_V_limitHi = 0.511311f;
        double otm_4_B_V_limitLo = 0.8501695990562439;
        double otm_5_A_I_warnHi = 0.10861527919769287;
        double otm_5_A_I_warnLo = 0.13340067863464355;
        double otm_5_A_I_limitHi = 0.909978985786438;
        double otm_5_A_I_limitLo = 0.632366418838501;
        double otm_5_A_V_warnHi = 0.8650884032249451;
        double otm_5_A_V_warnLo = 0.033549726009368896;
        double otm_5_A_V_limitHi = 0.6954838037490845;
        double otm_5_A_V_limitLo = 0.11287665367126465;
        double otm_5_B_I_warnHi = 0.674673318862915;
        double otm_5_B_I_warnLo = 0.06375402212142944;
        double otm_5_B_I_limitHi = 0.5577300786972046;
        double otm_5_B_I_limitLo = 0.0346936f;
        double otm_5_B_V_warnHi = 0.25591927766799927;
        double otm_5_B_V_warnLo = 0.861728f;
        double otm_5_B_V_limitHi = 0.6790806651115417;
        double otm_5_B_V_limitLo = 0.500071f;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsConfigurationEvent(priority, version, otm_0_A_I_warnHi, otm_0_A_I_warnLo, otm_0_A_I_limitHi, otm_0_A_I_limitLo, otm_0_A_V_warnHi, otm_0_A_V_warnLo, otm_0_A_V_limitHi, otm_0_A_V_limitLo, otm_0_B_I_warnHi, otm_0_B_I_warnLo, otm_0_B_I_limitHi, otm_0_B_I_limitLo, otm_0_B_V_warnHi, otm_0_B_V_warnLo, otm_0_B_V_limitHi, otm_0_B_V_limitLo, otm_1_A_I_warnHi, otm_1_A_I_warnLo, otm_1_A_I_limitHi, otm_1_A_I_limitLo, otm_1_A_V_warnHi, otm_1_A_V_warnLo, otm_1_A_V_limitHi, otm_1_A_V_limitLo, otm_1_B_I_warnHi, otm_1_B_I_warnLo, otm_1_B_I_limitHi, otm_1_B_I_limitLo, otm_1_B_V_warnHi, otm_1_B_V_warnLo, otm_1_B_V_limitHi, otm_1_B_V_limitLo, otm_2_A_I_warnHi, otm_2_A_I_warnLo, otm_2_A_I_limitHi, otm_2_A_I_limitLo, otm_2_A_V_warnHi, otm_2_A_V_warnLo, otm_2_A_V_limitHi, otm_2_A_V_limitLo, otm_2_B_I_warnHi, otm_2_B_I_warnLo, otm_2_B_I_limitHi, otm_2_B_I_limitLo, otm_2_B_V_warnHi, otm_2_B_V_warnLo, otm_2_B_V_limitHi, otm_2_B_V_limitLo, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo, otm_4_A_I_warnHi, otm_4_A_I_warnLo, otm_4_A_I_limitHi, otm_4_A_I_limitLo, otm_4_A_V_warnHi, otm_4_A_V_warnLo, otm_4_A_V_limitHi, otm_4_A_V_limitLo, otm_4_B_I_warnHi, otm_4_B_I_warnLo, otm_4_B_I_limitHi, otm_4_B_I_limitLo, otm_4_B_V_warnHi, otm_4_B_V_warnLo, otm_4_B_V_limitHi, otm_4_B_V_limitLo, otm_5_A_I_warnHi, otm_5_A_I_warnLo, otm_5_A_I_limitHi, otm_5_A_I_limitLo, otm_5_A_V_warnHi, otm_5_A_V_warnLo, otm_5_A_V_limitHi, otm_5_A_V_limitLo, otm_5_B_I_warnHi, otm_5_B_I_warnLo, otm_5_B_I_limitHi, otm_5_B_I_limitLo, otm_5_B_V_warnHi, otm_5_B_V_warnLo, otm_5_B_V_limitHi, otm_5_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsConfigurationEvent));
        Quadbox_PDU_5V_LimitsConfigurationEvent item_ = (Quadbox_PDU_5V_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)otm_0_A_I_warnHi, (double)item_.getOtm_0_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_warnLo, (double)item_.getOtm_0_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitHi, (double)item_.getOtm_0_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitLo, (double)item_.getOtm_0_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnHi, (double)item_.getOtm_0_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnLo, (double)item_.getOtm_0_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitHi, (double)item_.getOtm_0_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitLo, (double)item_.getOtm_0_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnHi, (double)item_.getOtm_0_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnLo, (double)item_.getOtm_0_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitHi, (double)item_.getOtm_0_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitLo, (double)item_.getOtm_0_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnHi, (double)item_.getOtm_0_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnLo, (double)item_.getOtm_0_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitHi, (double)item_.getOtm_0_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitLo, (double)item_.getOtm_0_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnHi, (double)item_.getOtm_1_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnLo, (double)item_.getOtm_1_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitHi, (double)item_.getOtm_1_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitLo, (double)item_.getOtm_1_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnHi, (double)item_.getOtm_1_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnLo, (double)item_.getOtm_1_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitHi, (double)item_.getOtm_1_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitLo, (double)item_.getOtm_1_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnHi, (double)item_.getOtm_1_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnLo, (double)item_.getOtm_1_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitHi, (double)item_.getOtm_1_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitLo, (double)item_.getOtm_1_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnHi, (double)item_.getOtm_1_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnLo, (double)item_.getOtm_1_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitHi, (double)item_.getOtm_1_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitLo, (double)item_.getOtm_1_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnHi, (double)item_.getOtm_2_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnLo, (double)item_.getOtm_2_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitHi, (double)item_.getOtm_2_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitLo, (double)item_.getOtm_2_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnHi, (double)item_.getOtm_2_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnLo, (double)item_.getOtm_2_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitHi, (double)item_.getOtm_2_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitLo, (double)item_.getOtm_2_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnHi, (double)item_.getOtm_2_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnLo, (double)item_.getOtm_2_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitHi, (double)item_.getOtm_2_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitLo, (double)item_.getOtm_2_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnHi, (double)item_.getOtm_2_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnLo, (double)item_.getOtm_2_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitHi, (double)item_.getOtm_2_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitLo, (double)item_.getOtm_2_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnHi, (double)item_.getOtm_4_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnLo, (double)item_.getOtm_4_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitHi, (double)item_.getOtm_4_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitLo, (double)item_.getOtm_4_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnHi, (double)item_.getOtm_4_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnLo, (double)item_.getOtm_4_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitHi, (double)item_.getOtm_4_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitLo, (double)item_.getOtm_4_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnHi, (double)item_.getOtm_4_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnLo, (double)item_.getOtm_4_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitHi, (double)item_.getOtm_4_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitLo, (double)item_.getOtm_4_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnHi, (double)item_.getOtm_4_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnLo, (double)item_.getOtm_4_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitHi, (double)item_.getOtm_4_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitLo, (double)item_.getOtm_4_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnHi, (double)item_.getOtm_5_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnLo, (double)item_.getOtm_5_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitHi, (double)item_.getOtm_5_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitLo, (double)item_.getOtm_5_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnHi, (double)item_.getOtm_5_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnLo, (double)item_.getOtm_5_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitHi, (double)item_.getOtm_5_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitLo, (double)item_.getOtm_5_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnHi, (double)item_.getOtm_5_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnLo, (double)item_.getOtm_5_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitHi, (double)item_.getOtm_5_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitLo, (double)item_.getOtm_5_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnHi, (double)item_.getOtm_5_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnLo, (double)item_.getOtm_5_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitHi, (double)item_.getOtm_5_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitLo, (double)item_.getOtm_5_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxConfigurationEvent() throws Exception {
        int priority = 476;
        String version = "x";
        int node = 366;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxConfigurationEvent));
        Quadbox_PDU_5V_QuadboxConfigurationEvent item_ = (Quadbox_PDU_5V_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 525;
        String version = "";
        int schedulers_default_nTasks = 565;
        int schedulers_default_nThreads = 106;
        int schedulers_monitor_update_publish_scheduler_nTasks = 583;
        int schedulers_monitor_update_publish_scheduler_nThreads = 249;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasksConfigurationEvent));
        Quadbox_PeriodicTasksConfigurationEvent item_ = (Quadbox_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 267;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 222L;
        long heartbeat_taskPeriodMillis = 127L;
        long monitor_check_taskPeriodMillis = 800L;
        long monitor_publish_taskPeriodMillis = 670L;
        long monitor_update_taskPeriodMillis = 429L;
        long runtimeinfo_taskPeriodMillis = 224L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersConfigurationEvent));
        Quadbox_PeriodicTasks_timersConfigurationEvent item_ = (Quadbox_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_LimitsConfigurationEvent() throws Exception {
        int priority = 819;
        String version = "y";
        double rebbulkps_0_2_I_warnHi = 0.16838771104812622;
        double rebbulkps_0_2_I_warnLo = 0.9623038172721863;
        double rebbulkps_0_2_I_limitHi = 0.15011334419250488;
        double rebbulkps_0_2_I_limitLo = 0.48530107736587524;
        double rebbulkps_0_2_T_warnHi = 0.4137721657752991;
        double rebbulkps_0_2_T_warnLo = 0.0766598f;
        double rebbulkps_0_2_T_limitHi = 0.7253578305244446;
        double rebbulkps_0_2_T_limitLo = 0.1221545934677124;
        double rebbulkps_0_2_V_warnHi = 0.779416024684906;
        double rebbulkps_0_2_V_warnLo = 0.2768756151199341;
        double rebbulkps_0_2_V_limitHi = 0.4441349506378174;
        double rebbulkps_0_2_V_limitLo = 0.5148841738700867;
        double rebbulkps_3_5_I_warnHi = 0.00691455602645874;
        double rebbulkps_3_5_I_warnLo = 0.5889905095100403;
        double rebbulkps_3_5_I_limitHi = 0.862678587436676;
        double rebbulkps_3_5_I_limitLo = 0.759788f;
        double rebbulkps_3_5_T_warnHi = 0.24051225185394287;
        double rebbulkps_3_5_T_warnLo = 0.5518115162849426;
        double rebbulkps_3_5_T_limitHi = 0.5088573098182678;
        double rebbulkps_3_5_T_limitLo = 0.8950796723365784;
        double rebbulkps_3_5_V_warnHi = 0.17582905292510986;
        double rebbulkps_3_5_V_warnLo = 0.26496803760528564;
        double rebbulkps_3_5_V_limitHi = 0.4779793620109558;
        double rebbulkps_3_5_V_limitLo = 0.15224981307983398;
        double rebbulkps_6_8_I_warnHi = 0.10457044839859009;
        double rebbulkps_6_8_I_warnLo = 0.7497748136520386;
        double rebbulkps_6_8_I_limitHi = 0.1686194f;
        double rebbulkps_6_8_I_limitLo = 0.30979394912719727;
        double rebbulkps_6_8_T_warnHi = 0.21112632751464844;
        double rebbulkps_6_8_T_warnLo = 0.3359434f;
        double rebbulkps_6_8_T_limitHi = 0.147347092628479;
        double rebbulkps_6_8_T_limitLo = 0.9024807214736938;
        double rebbulkps_6_8_V_warnHi = 0.9873150587081909;
        double rebbulkps_6_8_V_warnLo = 0.7804882526397705;
        double rebbulkps_6_8_V_limitHi = 0.21205365657806396;
        double rebbulkps_6_8_V_limitLo = 0.19770705699920654;
        double rebbulkps_9_12_I_warnHi = 0.0017998814582824707;
        double rebbulkps_9_12_I_warnLo = 0.893978476524353;
        double rebbulkps_9_12_I_limitHi = 0.5026865005493164;
        double rebbulkps_9_12_I_limitLo = 0.2176659107208252;
        double rebbulkps_9_12_T_warnHi = 0.6090694069862366;
        double rebbulkps_9_12_T_warnLo = 0.9734766483306885;
        double rebbulkps_9_12_T_limitHi = 0.8928537964820862;
        double rebbulkps_9_12_T_limitLo = 0.0497211217880249;
        double rebbulkps_9_12_V_warnHi = 0.2681116461753845;
        double rebbulkps_9_12_V_warnLo = 0.529084324836731;
        double rebbulkps_9_12_V_limitHi = 0.05878615379333496;
        double rebbulkps_9_12_V_limitLo = 0.5883772969245911;
        double rebbulkps_Brd_T_warnHi = 0.6124424338340759;
        double rebbulkps_Brd_T_warnLo = 0.928119f;
        double rebbulkps_Brd_T_limitHi = 0.25203055143356323;
        double rebbulkps_Brd_T_limitLo = 0.23448187112808228;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_LimitsConfigurationEvent(priority, version, rebbulkps_0_2_I_warnHi, rebbulkps_0_2_I_warnLo, rebbulkps_0_2_I_limitHi, rebbulkps_0_2_I_limitLo, rebbulkps_0_2_T_warnHi, rebbulkps_0_2_T_warnLo, rebbulkps_0_2_T_limitHi, rebbulkps_0_2_T_limitLo, rebbulkps_0_2_V_warnHi, rebbulkps_0_2_V_warnLo, rebbulkps_0_2_V_limitHi, rebbulkps_0_2_V_limitLo, rebbulkps_3_5_I_warnHi, rebbulkps_3_5_I_warnLo, rebbulkps_3_5_I_limitHi, rebbulkps_3_5_I_limitLo, rebbulkps_3_5_T_warnHi, rebbulkps_3_5_T_warnLo, rebbulkps_3_5_T_limitHi, rebbulkps_3_5_T_limitLo, rebbulkps_3_5_V_warnHi, rebbulkps_3_5_V_warnLo, rebbulkps_3_5_V_limitHi, rebbulkps_3_5_V_limitLo, rebbulkps_6_8_I_warnHi, rebbulkps_6_8_I_warnLo, rebbulkps_6_8_I_limitHi, rebbulkps_6_8_I_limitLo, rebbulkps_6_8_T_warnHi, rebbulkps_6_8_T_warnLo, rebbulkps_6_8_T_limitHi, rebbulkps_6_8_T_limitLo, rebbulkps_6_8_V_warnHi, rebbulkps_6_8_V_warnLo, rebbulkps_6_8_V_limitHi, rebbulkps_6_8_V_limitLo, rebbulkps_9_12_I_warnHi, rebbulkps_9_12_I_warnLo, rebbulkps_9_12_I_limitHi, rebbulkps_9_12_I_limitLo, rebbulkps_9_12_T_warnHi, rebbulkps_9_12_T_warnLo, rebbulkps_9_12_T_limitHi, rebbulkps_9_12_T_limitLo, rebbulkps_9_12_V_warnHi, rebbulkps_9_12_V_warnLo, rebbulkps_9_12_V_limitHi, rebbulkps_9_12_V_limitLo, rebbulkps_Brd_T_warnHi, rebbulkps_Brd_T_warnLo, rebbulkps_Brd_T_limitHi, rebbulkps_Brd_T_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_LimitsConfigurationEvent));
        Quadbox_REB_Bulk_PS_LimitsConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)rebbulkps_0_2_I_warnHi, (double)item_.getRebbulkps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_warnLo, (double)item_.getRebbulkps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitHi, (double)item_.getRebbulkps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitLo, (double)item_.getRebbulkps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnHi, (double)item_.getRebbulkps_0_2_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnLo, (double)item_.getRebbulkps_0_2_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitHi, (double)item_.getRebbulkps_0_2_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitLo, (double)item_.getRebbulkps_0_2_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnHi, (double)item_.getRebbulkps_0_2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnLo, (double)item_.getRebbulkps_0_2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitHi, (double)item_.getRebbulkps_0_2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitLo, (double)item_.getRebbulkps_0_2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnHi, (double)item_.getRebbulkps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnLo, (double)item_.getRebbulkps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitHi, (double)item_.getRebbulkps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitLo, (double)item_.getRebbulkps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnHi, (double)item_.getRebbulkps_3_5_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnLo, (double)item_.getRebbulkps_3_5_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitHi, (double)item_.getRebbulkps_3_5_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitLo, (double)item_.getRebbulkps_3_5_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnHi, (double)item_.getRebbulkps_3_5_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnLo, (double)item_.getRebbulkps_3_5_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitHi, (double)item_.getRebbulkps_3_5_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitLo, (double)item_.getRebbulkps_3_5_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnHi, (double)item_.getRebbulkps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnLo, (double)item_.getRebbulkps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitHi, (double)item_.getRebbulkps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitLo, (double)item_.getRebbulkps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnHi, (double)item_.getRebbulkps_6_8_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnLo, (double)item_.getRebbulkps_6_8_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitHi, (double)item_.getRebbulkps_6_8_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitLo, (double)item_.getRebbulkps_6_8_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnHi, (double)item_.getRebbulkps_6_8_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnLo, (double)item_.getRebbulkps_6_8_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitHi, (double)item_.getRebbulkps_6_8_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitLo, (double)item_.getRebbulkps_6_8_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnHi, (double)item_.getRebbulkps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnLo, (double)item_.getRebbulkps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitHi, (double)item_.getRebbulkps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitLo, (double)item_.getRebbulkps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnHi, (double)item_.getRebbulkps_9_12_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnLo, (double)item_.getRebbulkps_9_12_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitHi, (double)item_.getRebbulkps_9_12_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitLo, (double)item_.getRebbulkps_9_12_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnHi, (double)item_.getRebbulkps_9_12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnLo, (double)item_.getRebbulkps_9_12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitHi, (double)item_.getRebbulkps_9_12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitLo, (double)item_.getRebbulkps_9_12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnHi, (double)item_.getRebbulkps_Brd_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnLo, (double)item_.getRebbulkps_Brd_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitHi, (double)item_.getRebbulkps_Brd_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitLo, (double)item_.getRebbulkps_Brd_T_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxConfigurationEvent() throws Exception {
        int priority = 478;
        String version = "";
        int node = 558;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent));
        Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveRebpowerConfigurationEvent() throws Exception {
        int priority = 177;
        String version = "q";
        long powerOffSleepMillis = 480L;
        SALEvent item = this.testSendReceive((SALEvent)new RebpowerConfigurationEvent(priority, version, powerOffSleepMillis));
        Assert.assertTrue((boolean)(item instanceof RebpowerConfigurationEvent));
        RebpowerConfigurationEvent item_ = (RebpowerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManagerConfigurationEvent() throws Exception {
        int priority = 627;
        String version = "j";
        boolean processOnlyClearedAlerts = false;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManagerConfigurationEvent(priority, version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManagerConfigurationEvent));
        Rebpower_EmergencyResponseManagerConfigurationEvent item_ = (Rebpower_EmergencyResponseManagerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 834;
        String version = "";
        int schedulers_default_nTasks = 392;
        int schedulers_default_nThreads = 348;
        int schedulers_monitor_check_scheduler_nTasks = 774;
        int schedulers_monitor_check_scheduler_nThreads = 123;
        int schedulers_monitor_update_publish_scheduler_nTasks = 920;
        int schedulers_monitor_update_publish_scheduler_nThreads = 308;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasksConfigurationEvent));
        Rebpower_PeriodicTasksConfigurationEvent item_ = (Rebpower_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 941;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 81L;
        long heartbeat_taskPeriodMillis = 143L;
        long monitor_check_RebPS_P00_taskPeriodMillis = 410L;
        long monitor_check_RebPS_P01_taskPeriodMillis = 503L;
        long monitor_check_RebPS_P02_taskPeriodMillis = 880L;
        long monitor_check_RebPS_P03_taskPeriodMillis = 791L;
        long monitor_check_RebPS_P04_taskPeriodMillis = 463L;
        long monitor_check_RebPS_P05_taskPeriodMillis = 899L;
        long monitor_check_RebPS_P06_taskPeriodMillis = 928L;
        long monitor_check_RebPS_P07_taskPeriodMillis = 693L;
        long monitor_check_RebPS_P08_taskPeriodMillis = 255L;
        long monitor_check_RebPS_P09_taskPeriodMillis = 650L;
        long monitor_check_RebPS_P10_taskPeriodMillis = 1L;
        long monitor_check_RebPS_P11_taskPeriodMillis = 663L;
        long monitor_check_RebPS_P12_taskPeriodMillis = 453L;
        long monitor_publish_RebPS_P00_taskPeriodMillis = 454L;
        long monitor_publish_RebPS_P01_taskPeriodMillis = 549L;
        long monitor_publish_RebPS_P02_taskPeriodMillis = 917L;
        long monitor_publish_RebPS_P03_taskPeriodMillis = 483L;
        long monitor_publish_RebPS_P04_taskPeriodMillis = 950L;
        long monitor_publish_RebPS_P05_taskPeriodMillis = 479L;
        long monitor_publish_RebPS_P06_taskPeriodMillis = 630L;
        long monitor_publish_RebPS_P07_taskPeriodMillis = 848L;
        long monitor_publish_RebPS_P08_taskPeriodMillis = 720L;
        long monitor_publish_RebPS_P09_taskPeriodMillis = 632L;
        long monitor_publish_RebPS_P10_taskPeriodMillis = 15L;
        long monitor_publish_RebPS_P11_taskPeriodMillis = 376L;
        long monitor_publish_RebPS_P12_taskPeriodMillis = 501L;
        long monitor_update_RebPS_P00_taskPeriodMillis = 727L;
        long monitor_update_RebPS_P01_taskPeriodMillis = 3L;
        long monitor_update_RebPS_P02_taskPeriodMillis = 17L;
        long monitor_update_RebPS_P03_taskPeriodMillis = 93L;
        long monitor_update_RebPS_P04_taskPeriodMillis = 988L;
        long monitor_update_RebPS_P05_taskPeriodMillis = 839L;
        long monitor_update_RebPS_P06_taskPeriodMillis = 600L;
        long monitor_update_RebPS_P07_taskPeriodMillis = 780L;
        long monitor_update_RebPS_P08_taskPeriodMillis = 802L;
        long monitor_update_RebPS_P09_taskPeriodMillis = 220L;
        long monitor_update_RebPS_P10_taskPeriodMillis = 798L;
        long monitor_update_RebPS_P11_taskPeriodMillis = 997L;
        long monitor_update_RebPS_P12_taskPeriodMillis = 815L;
        long reb_power_state_taskPeriodMillis = 679L;
        long runtimeinfo_taskPeriodMillis = 859L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_RebPS_P00_taskPeriodMillis, monitor_check_RebPS_P01_taskPeriodMillis, monitor_check_RebPS_P02_taskPeriodMillis, monitor_check_RebPS_P03_taskPeriodMillis, monitor_check_RebPS_P04_taskPeriodMillis, monitor_check_RebPS_P05_taskPeriodMillis, monitor_check_RebPS_P06_taskPeriodMillis, monitor_check_RebPS_P07_taskPeriodMillis, monitor_check_RebPS_P08_taskPeriodMillis, monitor_check_RebPS_P09_taskPeriodMillis, monitor_check_RebPS_P10_taskPeriodMillis, monitor_check_RebPS_P11_taskPeriodMillis, monitor_check_RebPS_P12_taskPeriodMillis, monitor_publish_RebPS_P00_taskPeriodMillis, monitor_publish_RebPS_P01_taskPeriodMillis, monitor_publish_RebPS_P02_taskPeriodMillis, monitor_publish_RebPS_P03_taskPeriodMillis, monitor_publish_RebPS_P04_taskPeriodMillis, monitor_publish_RebPS_P05_taskPeriodMillis, monitor_publish_RebPS_P06_taskPeriodMillis, monitor_publish_RebPS_P07_taskPeriodMillis, monitor_publish_RebPS_P08_taskPeriodMillis, monitor_publish_RebPS_P09_taskPeriodMillis, monitor_publish_RebPS_P10_taskPeriodMillis, monitor_publish_RebPS_P11_taskPeriodMillis, monitor_publish_RebPS_P12_taskPeriodMillis, monitor_update_RebPS_P00_taskPeriodMillis, monitor_update_RebPS_P01_taskPeriodMillis, monitor_update_RebPS_P02_taskPeriodMillis, monitor_update_RebPS_P03_taskPeriodMillis, monitor_update_RebPS_P04_taskPeriodMillis, monitor_update_RebPS_P05_taskPeriodMillis, monitor_update_RebPS_P06_taskPeriodMillis, monitor_update_RebPS_P07_taskPeriodMillis, monitor_update_RebPS_P08_taskPeriodMillis, monitor_update_RebPS_P09_taskPeriodMillis, monitor_update_RebPS_P10_taskPeriodMillis, monitor_update_RebPS_P11_taskPeriodMillis, monitor_update_RebPS_P12_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersConfigurationEvent));
        Rebpower_PeriodicTasks_timersConfigurationEvent item_ = (Rebpower_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebConfigurationEvent() throws Exception {
        int priority = 770;
        String version = "";
        int[] dphi = TestHelper.generateIntArray((int)71, (int)-641205701);
        int[] hvBias = TestHelper.generateIntArray((int)71, (int)1671044411);
        String location = "u";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebConfigurationEvent(priority, version, dphi, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebConfigurationEvent));
        Rebpower_RebConfigurationEvent item_ = (Rebpower_RebConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((int[])dphi, (int[])item_.getDphi());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsConfigurationEvent() throws Exception {
        int priority = 344;
        String version = "p";
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2021850032);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1754344866);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)733108109);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1362927434);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1575979722);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)2118846163);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)239976838);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2113046056);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1573406777);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-41529516);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1240758327);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1886246623);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1864925985);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1766412884);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)2024684312);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)466529439);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1603061310);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1617536484);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1879941437);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)508359972);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)480274295);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1393278404);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1585860557);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1101456597);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)81046178);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1823870822);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-982591699);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)154799573);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1418832661);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1909449927);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1948118013);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1137322580);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)2123614844);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1913412540);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)169555045);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1087185190);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1320204524);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1468654764);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-723239982);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1602463109);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)106719800);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-987884426);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)108903121);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1759038033);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-822637437);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1737310271);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)801374656);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1562629947);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1669966826);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1770584057);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)977984200);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)360661229);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1266175885);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1827129950);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1459951370);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)941697292);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1605222742);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1574722962);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1975204632);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1590452289);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)173903082);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1968906109);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-841220442);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-157997394);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1955824474);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1165344758);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-223833216);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)123870953);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1689191977);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)981476097);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)912910271);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)51163400);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1926617885);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1499436330);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1854187721);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1555524716);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)386886406);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-557629723);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1573552179);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)142758821);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-617142827);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-572588262);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1966288740);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1508901836);
        double[] dphi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)2024977259);
        double[] dphi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)2015389538);
        double[] dphi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1276745493);
        double[] dphi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1564248782);
        double[] dphi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2018169070);
        double[] dphi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-935368852);
        double[] dphi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1726724701);
        double[] dphi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1276879103);
        double[] dphi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-43381035);
        double[] dphi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)534983348);
        double[] dphi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-778399956);
        double[] dphi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1998264322);
        double[] dphi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1394574931);
        double[] dphi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1125593924);
        double[] dphi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)29580934);
        double[] dphi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1945814662);
        double[] dphi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1664336597);
        double[] dphi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1194355300);
        double[] dphi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1164681587);
        double[] dphi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1033622902);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1114549085);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1178363203);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-623197166);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)677930517);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1787274861);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2047496223);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1922109545);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)736454629);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1343700194);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1502768027);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)692191294);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-643048374);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)810491974);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)914532554);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)307455612);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1989724240);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-47365565);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)82573425);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1177393289);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)688599843);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1083968067);
        double[] hvbias_IbefSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2095015003);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-169381704);
        double[] hvbias_IbefSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)2092990895);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1818034482);
        double[] hvbias_VbefSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)600683999);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1693289697);
        double[] hvbias_VbefSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-425170810);
        String location = "o";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1122010857);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1142188025);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1402983969);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-374361999);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1072567287);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1701742267);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-642111728);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1667130501);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1569047275);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1714684414);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)1354985125);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1638591183);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1638982911);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1722200850);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1259816212);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-895233117);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-257101977);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1954563438);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-728395100);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1446658328);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1390118205);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1524197295);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1836803446);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)2101257498);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)415312498);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2093817922);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)63630387);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)505719461);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsConfigurationEvent(priority, version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, dphi_IaftLDO_warnHi, dphi_IaftLDO_warnLo, dphi_IaftLDO_limitHi, dphi_IaftLDO_limitLo, dphi_IbefLDO_warnHi, dphi_IbefLDO_warnLo, dphi_IbefLDO_limitHi, dphi_IbefLDO_limitLo, dphi_VaftLDO_warnHi, dphi_VaftLDO_warnLo, dphi_VaftLDO_limitHi, dphi_VaftLDO_limitLo, dphi_VaftSwch_warnHi, dphi_VaftSwch_warnLo, dphi_VaftSwch_limitHi, dphi_VaftSwch_limitLo, dphi_VbefLDO_warnHi, dphi_VbefLDO_warnLo, dphi_VbefLDO_limitHi, dphi_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_warnLo, hvbias_IbefSwch_limitHi, hvbias_IbefSwch_limitLo, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_warnLo, hvbias_VbefSwch_limitHi, hvbias_VbefSwch_limitLo, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsConfigurationEvent));
        Rebpower_Reb_LimitsConfigurationEvent item_ = (Rebpower_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnHi, (double[])item_.getDphi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnLo, (double[])item_.getDphi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitHi, (double[])item_.getDphi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitLo, (double[])item_.getDphi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnHi, (double[])item_.getDphi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnLo, (double[])item_.getDphi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitHi, (double[])item_.getDphi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitLo, (double[])item_.getDphi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnHi, (double[])item_.getDphi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnLo, (double[])item_.getDphi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitHi, (double[])item_.getDphi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitLo, (double[])item_.getDphi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnHi, (double[])item_.getDphi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnLo, (double[])item_.getDphi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitHi, (double[])item_.getDphi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitLo, (double[])item_.getDphi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnHi, (double[])item_.getDphi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnLo, (double[])item_.getDphi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitHi, (double[])item_.getDphi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitLo, (double[])item_.getDphi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnLo, (double[])item_.getHvbias_IbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitLo, (double[])item_.getHvbias_IbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnLo, (double[])item_.getHvbias_VbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitLo, (double[])item_.getHvbias_VbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsConfigurationEvent() throws Exception {
        int priority = 793;
        String version = "";
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)13, (int)474056220);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)13, (int)-886637887);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1307659566);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)13, (int)-2043613561);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)13, (int)-779278081);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)13, (int)87063612);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)13, (int)-580309562);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)13, (int)-585747698);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)13, (int)1882601063);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)13, (int)-990212484);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)13, (int)901450197);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)13, (int)1205511172);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)13, (int)726099078);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)13, (int)-694152508);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)13, (int)1021733199);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)13, (int)452639809);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)13, (int)-16557242);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1300150858);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)13, (int)313053182);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)13, (int)-99667053);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)13, (int)1873710749);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)13, (int)818752792);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)13, (int)-2022901862);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)13, (int)-755717078);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)13, (int)-1351882203);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)13, (int)1863163354);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1442777214);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1913236938);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsConfigurationEvent(priority, version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsConfigurationEvent));
        Rebpower_Rebps_LimitsConfigurationEvent item_ = (Rebpower_Rebps_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerConfigurationEvent() throws Exception {
        int priority = 507;
        String version = "";
        String ipAddr = "";
        String location = "r";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)13, (int)-541079858);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerConfigurationEvent(priority, version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerConfigurationEvent));
        Rebpower_Rebps_PowerConfigurationEvent item_ = (Rebpower_Rebps_PowerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveHexConfigurationEvent() throws Exception {
        int priority = 857;
        String version = "a";
        double rtnToEvapOffset = 0.7979332804679871;
        SALEvent item = this.testSendReceive((SALEvent)new HexConfigurationEvent(priority, version, rtnToEvapOffset));
        Assert.assertTrue((boolean)(item instanceof HexConfigurationEvent));
        HexConfigurationEvent item_ = (HexConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)rtnToEvapOffset, (double)item_.getRtnToEvapOffset(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold1_LimitsConfigurationEvent() throws Exception {
        int priority = 522;
        String version = "";
        double evapexittmp_warnHi = 0.9028640389442444;
        double evapexittmp_warnLo = 0.17943823337554932;
        double evapexittmp_limitHi = 0.6503531336784363;
        double evapexittmp_limitLo = 0.00792855f;
        double hexrtrntmp_warnHi = 0.03374302387237549;
        double hexrtrntmp_warnLo = 0.9140632152557373;
        double hexrtrntmp_limitHi = 0.3034737f;
        double hexrtrntmp_limitLo = 0.5301044583320618;
        double preexpntmp_warnHi = 0.8447704315185547;
        double preexpntmp_warnLo = 0.5800148248672485;
        double preexpntmp_limitHi = 0.9197233319282532;
        double preexpntmp_limitLo = 0.3724360466003418;
        double returnprs_warnHi = 0.7258525490760803;
        double returnprs_warnLo = 0.5308462977409363;
        double returnprs_limitHi = 0.689347505569458;
        double returnprs_limitLo = 0.4999144673347473;
        double superheat_warnHi = 0.15168523788452148;
        double superheat_warnLo = 0.3233150839805603;
        double superheat_limitHi = 0.6739442944526672;
        double superheat_limitLo = 0.8003124594688416;
        double supplyprs_warnHi = 0.8840603828430176;
        double supplyprs_warnLo = 0.1999720335006714;
        double supplyprs_limitHi = 0.3641918897628784;
        double supplyprs_limitLo = 0.1045953f;
        double supplysubcooling_warnHi = 0.586685299873352;
        double supplysubcooling_warnLo = 0.07568937540054321;
        double supplysubcooling_limitHi = 0.6804636716842651;
        double supplysubcooling_limitLo = 0.4218956232070923;
        double supplytmp_warnHi = 0.5800520777702332;
        double supplytmp_warnLo = 0.306423f;
        double supplytmp_limitHi = 0.7984023094177246;
        double supplytmp_limitLo = 0.549782395362854;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold1_LimitsConfigurationEvent(priority, version, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, preexpntmp_warnHi, preexpntmp_warnLo, preexpntmp_limitHi, preexpntmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, superheat_warnHi, superheat_warnLo, superheat_limitHi, superheat_limitLo, supplyprs_warnHi, supplyprs_warnLo, supplyprs_limitHi, supplyprs_limitLo, supplysubcooling_warnHi, supplysubcooling_warnLo, supplysubcooling_limitHi, supplysubcooling_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1_LimitsConfigurationEvent));
        Hex_Cold1_LimitsConfigurationEvent item_ = (Hex_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnHi, (double)item_.getPreexpntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnLo, (double)item_.getPreexpntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitHi, (double)item_.getPreexpntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitLo, (double)item_.getPreexpntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnHi, (double)item_.getSuperheat_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnLo, (double)item_.getSuperheat_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitHi, (double)item_.getSuperheat_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitLo, (double)item_.getSuperheat_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnHi, (double)item_.getSupplyprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnLo, (double)item_.getSupplyprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitHi, (double)item_.getSupplyprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitLo, (double)item_.getSupplyprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnHi, (double)item_.getSupplysubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnLo, (double)item_.getSupplysubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitHi, (double)item_.getSupplysubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitLo, (double)item_.getSupplysubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2_LimitsConfigurationEvent() throws Exception {
        int priority = 314;
        String version = "";
        double evapexittmp_warnHi = 0.4435202479362488;
        double evapexittmp_warnLo = 0.1747344732284546;
        double evapexittmp_limitHi = 0.4860857129096985;
        double evapexittmp_limitLo = 0.20062655210494995;
        double hexrtrntmp_warnHi = 0.5253089070320129;
        double hexrtrntmp_warnLo = 0.49706172943115234;
        double hexrtrntmp_limitHi = 0.1789099f;
        double hexrtrntmp_limitLo = 0.922715425491333;
        double preexpntmp_warnHi = 0.21220701932907104;
        double preexpntmp_warnLo = 0.16325223445892334;
        double preexpntmp_limitHi = 0.5513094067573547;
        double preexpntmp_limitLo = 0.13890838623046875;
        double returnprs_warnHi = 0.21476882696151733;
        double returnprs_warnLo = 0.3092518448829651;
        double returnprs_limitHi = 0.6099345684051514;
        double returnprs_limitLo = 0.600970983505249;
        double superheat_warnHi = 0.21676874160766602;
        double superheat_warnLo = 0.08100646734237671;
        double superheat_limitHi = 0.9224645495414734;
        double superheat_limitLo = 0.04314148426055908;
        double supplyprs_warnHi = 0.03470128774642944;
        double supplyprs_warnLo = 0.45235252380371094;
        double supplyprs_limitHi = 0.7059468626976013;
        double supplyprs_limitLo = 0.2009183168411255;
        double supplysubcooling_warnHi = 0.29771554470062256;
        double supplysubcooling_warnLo = 0.1817813515663147;
        double supplysubcooling_limitHi = 0.7181359529495239;
        double supplysubcooling_limitLo = 0.9000556468963623;
        double supplytmp_warnHi = 0.7156334519386292;
        double supplytmp_warnLo = 0.5936198234558105;
        double supplytmp_limitHi = 0.7342118620872498;
        double supplytmp_limitLo = 0.6810342669487;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold2_LimitsConfigurationEvent(priority, version, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, preexpntmp_warnHi, preexpntmp_warnLo, preexpntmp_limitHi, preexpntmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, superheat_warnHi, superheat_warnLo, superheat_limitHi, superheat_limitLo, supplyprs_warnHi, supplyprs_warnLo, supplyprs_limitHi, supplyprs_limitLo, supplysubcooling_warnHi, supplysubcooling_warnLo, supplysubcooling_limitHi, supplysubcooling_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2_LimitsConfigurationEvent));
        Hex_Cold2_LimitsConfigurationEvent item_ = (Hex_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnHi, (double)item_.getPreexpntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnLo, (double)item_.getPreexpntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitHi, (double)item_.getPreexpntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitLo, (double)item_.getPreexpntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnHi, (double)item_.getSuperheat_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnLo, (double)item_.getSuperheat_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitHi, (double)item_.getSuperheat_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitLo, (double)item_.getSuperheat_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnHi, (double)item_.getSupplyprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnLo, (double)item_.getSupplyprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitHi, (double)item_.getSupplyprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitLo, (double)item_.getSupplyprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnHi, (double)item_.getSupplysubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnLo, (double)item_.getSupplysubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitHi, (double)item_.getSupplysubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitLo, (double)item_.getSupplysubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1_LimitsConfigurationEvent() throws Exception {
        int priority = 711;
        String version = "d";
        double c3exittmp_warnHi = 0.08649373054504395;
        double c3exittmp_warnLo = 0.007741868495941162;
        double c3exittmp_limitHi = 0.3463588356971741;
        double c3exittmp_limitLo = 0.47391778230667114;
        double c4exittmp_warnHi = 0.18728214502334595;
        double c4exittmp_warnLo = 0.4285205602645874;
        double c4exittmp_limitHi = 0.7102625370025635;
        double c4exittmp_limitLo = 0.8721213340759277;
        double evapexittmp_warnHi = 0.028969526290893555;
        double evapexittmp_warnLo = 0.025536537170410156;
        double evapexittmp_limitHi = 0.929409384727478;
        double evapexittmp_limitLo = 0.9869453310966492;
        double hexrtrntmp_warnHi = 0.020075678825378418;
        double hexrtrntmp_warnLo = 0.276092529296875;
        double hexrtrntmp_limitHi = 0.8361074328422546;
        double hexrtrntmp_limitLo = 0.21995443105697632;
        double liquidprs_warnHi = 0.38420385122299194;
        double liquidprs_warnLo = 0.31224966049194336;
        double liquidprs_limitHi = 0.23293238878250122;
        double liquidprs_limitLo = 0.40147173404693604;
        double prec3tmp_warnHi = 0.39219456911087036;
        double prec3tmp_warnLo = 0.5753852725028992;
        double prec3tmp_limitHi = 0.22028517723083496;
        double prec3tmp_limitLo = 0.8018012642860413;
        double prec4tmp_warnHi = 0.36188453435897827;
        double prec4tmp_warnLo = 0.3241550326347351;
        double prec4tmp_limitHi = 0.9119870662689209;
        double prec4tmp_limitLo = 0.8102445602416992;
        double returnprs_warnHi = 0.24977731704711914;
        double returnprs_warnLo = 0.9065913558006287;
        double returnprs_limitHi = 0.813798725605011;
        double returnprs_limitLo = 0.8789604902267456;
        double vaporprs_warnHi = 0.9017178416252136;
        double vaporprs_warnLo = 0.4344574213027954;
        double vaporprs_limitHi = 0.1655225157737732;
        double vaporprs_limitLo = 0.8238404393196106;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo1_LimitsConfigurationEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1_LimitsConfigurationEvent));
        Hex_Cryo1_LimitsConfigurationEvent item_ = (Hex_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2_LimitsConfigurationEvent() throws Exception {
        int priority = 431;
        String version = "a";
        double c3exittmp_warnHi = 0.3343989849090576;
        double c3exittmp_warnLo = 0.16390752792358398;
        double c3exittmp_limitHi = 0.4870567321777344;
        double c3exittmp_limitLo = 0.8007899522781372;
        double c4exittmp_warnHi = 0.5389488339424133;
        double c4exittmp_warnLo = 0.21893548965454102;
        double c4exittmp_limitHi = 0.8761265277862549;
        double c4exittmp_limitLo = 0.46057581901550293;
        double evapexittmp_warnHi = 0.9353818297386169;
        double evapexittmp_warnLo = 0.19551920890808105;
        double evapexittmp_limitHi = 0.39240384101867676;
        double evapexittmp_limitLo = 0.0318138f;
        double hexrtrntmp_warnHi = 0.6826966404914856;
        double hexrtrntmp_warnLo = 0.7906205654144287;
        double hexrtrntmp_limitHi = 0.2049654722213745;
        double hexrtrntmp_limitLo = 0.7586924433708191;
        double liquidprs_warnHi = 0.6705963611602783;
        double liquidprs_warnLo = 0.6947575211524963;
        double liquidprs_limitHi = 0.250831663608551;
        double liquidprs_limitLo = 0.21544432640075684;
        double prec3tmp_warnHi = 0.47625845670700073;
        double prec3tmp_warnLo = 0.14887607097625732;
        double prec3tmp_limitHi = 0.4687969f;
        double prec3tmp_limitLo = 0.6955842971801758;
        double prec4tmp_warnHi = 0.0765959620475769;
        double prec4tmp_warnLo = 0.511004f;
        double prec4tmp_limitHi = 0.013155996799468994;
        double prec4tmp_limitLo = 0.389645516872406;
        double returnprs_warnHi = 0.3244718313217163;
        double returnprs_warnLo = 0.6400936245918274;
        double returnprs_limitHi = 0.4965214133262634;
        double returnprs_limitLo = 0.5901732444763184;
        double vaporprs_warnHi = 0.797491f;
        double vaporprs_warnLo = 0.8905333876609802;
        double vaporprs_limitHi = 0.7440076470375061;
        double vaporprs_limitLo = 0.04605609178543091;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo2_LimitsConfigurationEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2_LimitsConfigurationEvent));
        Hex_Cryo2_LimitsConfigurationEvent item_ = (Hex_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3_LimitsConfigurationEvent() throws Exception {
        int priority = 364;
        String version = "w";
        double c3exittmp_warnHi = 0.9435774087905884;
        double c3exittmp_warnLo = 0.23216503858566284;
        double c3exittmp_limitHi = 0.5061484575271606;
        double c3exittmp_limitLo = 0.1402691f;
        double c4exittmp_warnHi = 0.04249382019042969;
        double c4exittmp_warnLo = 0.37979036569595337;
        double c4exittmp_limitHi = 0.40569454431533813;
        double c4exittmp_limitLo = 0.6296751499176025;
        double evapexittmp_warnHi = 0.7937451601028442;
        double evapexittmp_warnLo = 0.014896035194396973;
        double evapexittmp_limitHi = 0.9935399293899536;
        double evapexittmp_limitLo = 0.0751552f;
        double hexrtrntmp_warnHi = 0.940955400466919;
        double hexrtrntmp_warnLo = 0.7775058150291443;
        double hexrtrntmp_limitHi = 0.10151857137680054;
        double hexrtrntmp_limitLo = 0.1776370406150818;
        double liquidprs_warnHi = 0.11870795488357544;
        double liquidprs_warnLo = 0.24811553955078125;
        double liquidprs_limitHi = 0.058002352714538574;
        double liquidprs_limitLo = 0.5878888368606567;
        double prec3tmp_warnHi = 0.34279865026474;
        double prec3tmp_warnLo = 0.446674644947052;
        double prec3tmp_limitHi = 0.6790383458137512;
        double prec3tmp_limitLo = 0.5738877654075623;
        double prec4tmp_warnHi = 0.4055485725402832;
        double prec4tmp_warnLo = 0.8601377010345459;
        double prec4tmp_limitHi = 0.21220511198043823;
        double prec4tmp_limitLo = 0.9195892214775085;
        double returnprs_warnHi = 0.9851754307746887;
        double returnprs_warnLo = 0.4957928f;
        double returnprs_limitHi = 0.7163221836090088;
        double returnprs_limitLo = 0.6140961050987244;
        double vaporprs_warnHi = 0.5226884484291077;
        double vaporprs_warnLo = 0.19604378938674927;
        double vaporprs_limitHi = 0.8590373396873474;
        double vaporprs_limitLo = 0.9079030752182007;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo3_LimitsConfigurationEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3_LimitsConfigurationEvent));
        Hex_Cryo3_LimitsConfigurationEvent item_ = (Hex_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4_LimitsConfigurationEvent() throws Exception {
        int priority = 558;
        String version = "b";
        double c3exittmp_warnHi = 0.4326738715171814;
        double c3exittmp_warnLo = 0.4598551392555237;
        double c3exittmp_limitHi = 0.9665083885192871;
        double c3exittmp_limitLo = 0.743118405342102;
        double c4exittmp_warnHi = 0.29607248306274414;
        double c4exittmp_warnLo = 0.43294817209243774;
        double c4exittmp_limitHi = 0.6063153743743896;
        double c4exittmp_limitLo = 0.7231611609458923;
        double evapexittmp_warnHi = 0.00729447603225708;
        double evapexittmp_warnLo = 0.33310025930404663;
        double evapexittmp_limitHi = 0.977205f;
        double evapexittmp_limitLo = 0.760383f;
        double hexrtrntmp_warnHi = 0.2865495f;
        double hexrtrntmp_warnLo = 0.11147481203079224;
        double hexrtrntmp_limitHi = 0.6011083126068115;
        double hexrtrntmp_limitLo = 0.9323744773864746;
        double liquidprs_warnHi = 0.9278703927993774;
        double liquidprs_warnLo = 0.2914939522743225;
        double liquidprs_limitHi = 0.6405305862426758;
        double liquidprs_limitLo = 0.7372221946716309;
        double prec3tmp_warnHi = 0.9749284982681274;
        double prec3tmp_warnLo = 0.6074967980384827;
        double prec3tmp_limitHi = 0.030330181121826172;
        double prec3tmp_limitLo = 0.7730217576026917;
        double prec4tmp_warnHi = 0.23031193017959595;
        double prec4tmp_warnLo = 0.6076322197914124;
        double prec4tmp_limitHi = 0.13174086809158325;
        double prec4tmp_limitLo = 0.06898140907287598;
        double returnprs_warnHi = 0.13688474893569946;
        double returnprs_warnLo = 0.4649277329444885;
        double returnprs_limitHi = 0.32647645473480225;
        double returnprs_limitLo = 0.6774181127548218;
        double vaporprs_warnHi = 0.07293188571929932;
        double vaporprs_warnLo = 0.2858484983444214;
        double vaporprs_limitHi = 0.1931876540184021;
        double vaporprs_limitLo = 0.042186856269836426;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo4_LimitsConfigurationEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4_LimitsConfigurationEvent));
        Hex_Cryo4_LimitsConfigurationEvent item_ = (Hex_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5_LimitsConfigurationEvent() throws Exception {
        int priority = 947;
        String version = "";
        double c3exittmp_warnHi = 0.8635f;
        double c3exittmp_warnLo = 0.7868179678916931;
        double c3exittmp_limitHi = 0.04214549f;
        double c3exittmp_limitLo = 0.9800314903259277;
        double c4exittmp_warnHi = 0.013203442096710205;
        double c4exittmp_warnLo = 0.25569117069244385;
        double c4exittmp_limitHi = 0.20352166891098022;
        double c4exittmp_limitLo = 0.250063419342041;
        double evapexittmp_warnHi = 0.3943629264831543;
        double evapexittmp_warnLo = 0.9378864169120789;
        double evapexittmp_limitHi = 0.9141576886177063;
        double evapexittmp_limitLo = 0.8772063255310059;
        double hexrtrntmp_warnHi = 0.3102787733078003;
        double hexrtrntmp_warnLo = 0.8030017614364624;
        double hexrtrntmp_limitHi = 0.7286413311958313;
        double hexrtrntmp_limitLo = 0.5008583068847656;
        double liquidprs_warnHi = 0.4470691680908203;
        double liquidprs_warnLo = 0.28140032291412354;
        double liquidprs_limitHi = 0.7706174850463867;
        double liquidprs_limitLo = 0.47354668378829956;
        double prec3tmp_warnHi = 0.7385295629501343;
        double prec3tmp_warnLo = 0.7813725471496582;
        double prec3tmp_limitHi = 0.24604082107543945;
        double prec3tmp_limitLo = 0.2682746648788452;
        double prec4tmp_warnHi = 0.7058215737342834;
        double prec4tmp_warnLo = 0.1090155839920044;
        double prec4tmp_limitHi = 0.46875715255737305;
        double prec4tmp_limitLo = 0.8462410569190979;
        double returnprs_warnHi = 0.9970532655715942;
        double returnprs_warnLo = 0.25281256437301636;
        double returnprs_limitHi = 0.1928073763847351;
        double returnprs_limitLo = 0.6669959425926208;
        double vaporprs_warnHi = 0.6861705183982849;
        double vaporprs_warnLo = 0.7266314625740051;
        double vaporprs_limitHi = 0.600325345993042;
        double vaporprs_limitLo = 0.10764491558074951;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo5_LimitsConfigurationEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5_LimitsConfigurationEvent));
        Hex_Cryo5_LimitsConfigurationEvent item_ = (Hex_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6_LimitsConfigurationEvent() throws Exception {
        int priority = 898;
        String version = "v";
        double c3exittmp_warnHi = 0.8183566927909851;
        double c3exittmp_warnLo = 0.07649964094161987;
        double c3exittmp_limitHi = 0.6318298578262329;
        double c3exittmp_limitLo = 0.23866015672683716;
        double c4exittmp_warnHi = 0.2174096703529358;
        double c4exittmp_warnLo = 0.8822810649871826;
        double c4exittmp_limitHi = 0.27603602409362793;
        double c4exittmp_limitLo = 0.5365505218505859;
        double evapexittmp_warnHi = 0.7377258539199829;
        double evapexittmp_warnLo = 0.9629201292991638;
        double evapexittmp_limitHi = 0.8280600905418396;
        double evapexittmp_limitLo = 0.969538688659668;
        double hexrtrntmp_warnHi = 0.22378402948379517;
        double hexrtrntmp_warnLo = 0.6647076606750488;
        double hexrtrntmp_limitHi = 0.3317262530326843;
        double hexrtrntmp_limitLo = 0.30432742834091187;
        double liquidprs_warnHi = 0.7666182518005371;
        double liquidprs_warnLo = 0.7806218862533569;
        double liquidprs_limitHi = 0.8396885991096497;
        double liquidprs_limitLo = 0.9289778470993042;
        double prec3tmp_warnHi = 0.3070452809333801;
        double prec3tmp_warnLo = 0.9169155359268188;
        double prec3tmp_limitHi = 0.57578444480896;
        double prec3tmp_limitLo = 0.907426655292511;
        double prec4tmp_warnHi = 0.16321277618408203;
        double prec4tmp_warnLo = 0.2419554591178894;
        double prec4tmp_limitHi = 0.8797241449356079;
        double prec4tmp_limitLo = 0.8299506306648254;
        double returnprs_warnHi = 0.7060214877128601;
        double returnprs_warnLo = 0.2755822539329529;
        double returnprs_limitHi = 0.20525145530700684;
        double returnprs_limitLo = 0.24436503648757935;
        double vaporprs_warnHi = 0.25108712911605835;
        double vaporprs_warnLo = 0.6799971461296082;
        double vaporprs_limitHi = 0.6659785509109497;
        double vaporprs_limitLo = 0.25002098083496094;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo6_LimitsConfigurationEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6_LimitsConfigurationEvent));
        Hex_Cryo6_LimitsConfigurationEvent item_ = (Hex_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Maq20_DeviceConfigurationEvent() throws Exception {
        int priority = 297;
        String version = "j";
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DeviceConfigurationEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DeviceConfigurationEvent));
        Hex_Maq20_DeviceConfigurationEvent item_ = (Hex_Maq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_Maq20x_DeviceConfigurationEvent() throws Exception {
        int priority = 149;
        String version = "q";
        String node = "h";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20x_DeviceConfigurationEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20x_DeviceConfigurationEvent));
        Hex_Maq20x_DeviceConfigurationEvent item_ = (Hex_Maq20x_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 383;
        String version = "";
        int schedulers_default_nTasks = 742;
        int schedulers_default_nThreads = 291;
        int schedulers_monitor_update_publish_scheduler_nTasks = 588;
        int schedulers_monitor_update_publish_scheduler_nThreads = 406;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasksConfigurationEvent));
        Hex_PeriodicTasksConfigurationEvent item_ = (Hex_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 808;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 259L;
        long heartbeat_taskPeriodMillis = 773L;
        long monitor_check_taskPeriodMillis = 367L;
        long monitor_publish_taskPeriodMillis = 534L;
        long monitor_update_taskPeriodMillis = 80L;
        long runtimeinfo_taskPeriodMillis = 3L;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_timersConfigurationEvent));
        Hex_PeriodicTasks_timersConfigurationEvent item_ = (Hex_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRefrig_Cold1_CompLimitsConfigurationEvent() throws Exception {
        int priority = 127;
        String version = "p";
        double cmprPowerDelayLimit = 0.5594959259033203;
        int cmprPowerDelayTime = 667;
        double cmprPowerImmedLimit = 0.5879529118537903;
        double coldTempImmedLimit = 0.32978355884552;
        double discPressDelayLimit = 0.735785186290741;
        int discPressDelayTime = 827;
        double discPressImmedLimit = 0.08542346954345703;
        double discTempDelayLimit = 0.1236853f;
        int discTempDelayTime = 524;
        double discTempImmedLimit = 0.8473304510116577;
        double discTempLowImmedLimit = 0.3294628858566284;
        double heaterTempLimit = 0.5819786190986633;
        double liquidTempDelayLimit = 0.5952181816101074;
        int liquidTempDelayTime = 303;
        double liquidTempImmedLimit = 0.0016371607780456543;
        double orificeOffPress = 0.32815104722976685;
        double orificeOnPress = 0.7488806247711182;
        double phaseSepTempDelayLimit = 0.3368644118309021;
        int phaseSepTempDelayTime = 168;
        double pressDiffImmedLimit = 0.25121062994003296;
        double suctTempImmedLimit = 0.08798271417617798;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_CompLimitsConfigurationEvent));
        Refrig_Cold1_CompLimitsConfigurationEvent item_ = (Refrig_Cold1_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1_DeviceConfigurationEvent() throws Exception {
        int priority = 810;
        String version = "";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        int vfd_address = 296;
        int vfd_baudRate = 171;
        String vfd_devcName = "r";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_DeviceConfigurationEvent));
        Refrig_Cold1_DeviceConfigurationEvent item_ = (Refrig_Cold1_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceiveRefrig_Cold1_LimitsConfigurationEvent() throws Exception {
        int priority = 329;
        String version = "x";
        double ambienttmp_warnHi = 0.3665999174118042;
        double ambienttmp_warnLo = 0.38482964038848877;
        double ambienttmp_limitHi = 0.8802147507667542;
        double ambienttmp_limitLo = 0.2488483190536499;
        double cabinettmp_warnHi = 0.4148409366607666;
        double cabinettmp_warnLo = 0.4606884f;
        double cabinettmp_limitHi = 0.6602405309677124;
        double cabinettmp_limitLo = 0.9092357754707336;
        double compcurrent_warnHi = 0.8978352546691895;
        double compcurrent_warnLo = 0.50284343957901;
        double compcurrent_limitHi = 0.21597141027450562;
        double compcurrent_limitLo = 0.002817809581756592;
        double comppower_warnHi = 0.33124858140945435;
        double comppower_warnLo = 0.1895303726196289;
        double comppower_limitHi = 0.7303743362426758;
        double comppower_limitLo = 0.34034425020217896;
        double compvfdcurr_warnHi = 0.735842227935791;
        double compvfdcurr_warnLo = 0.4493151903152466;
        double compvfdcurr_limitHi = 0.931314f;
        double compvfdcurr_limitLo = 0.1333240270614624;
        double compvfdfreq_warnHi = 0.06915563344955444;
        double compvfdfreq_warnLo = 0.8116698861122131;
        double compvfdfreq_limitHi = 0.8750594854354858;
        double compvfdfreq_limitLo = 0.38524436950683594;
        double compvfdvolt_warnHi = 0.9800442457199097;
        double compvfdvolt_warnLo = 0.28536665439605713;
        double compvfdvolt_limitHi = 0.2334151268005371;
        double compvfdvolt_limitLo = 0.1388377547264099;
        double compvoltage_warnHi = 0.5651848912239075;
        double compvoltage_warnLo = 0.5733909606933594;
        double compvoltage_limitHi = 0.41720718145370483;
        double compvoltage_limitLo = 0.26448744535446167;
        double coolflowrate_warnHi = 0.35695648193359375;
        double coolflowrate_warnLo = 0.8900324106216431;
        double coolflowrate_limitHi = 0.4097848f;
        double coolflowrate_limitLo = 0.2699854373931885;
        double coolvalveposn_warnHi = 0.3449241f;
        double coolvalveposn_warnLo = 0.6514145731925964;
        double coolvalveposn_limitHi = 0.7461811900138855;
        double coolvalveposn_limitLo = 0.5459582805633545;
        double dischrgprs_warnHi = 0.5232203006744385;
        double dischrgprs_warnLo = 0.690171480178833;
        double dischrgprs_limitHi = 0.10290920734405518;
        double dischrgprs_limitLo = 0.679862916469574;
        double dischrgtmp_M_warnHi = 0.6237860321998596;
        double dischrgtmp_M_warnLo = 0.17658203840255737;
        double dischrgtmp_M_limitHi = 0.7969587445259094;
        double dischrgtmp_M_limitLo = 0.1981566f;
        double dischrgtmp_P_warnHi = 0.2166767716407776;
        double dischrgtmp_P_warnLo = 0.09368312358856201;
        double dischrgtmp_P_limitHi = 0.6079548001289368;
        double dischrgtmp_P_limitLo = 0.8828257322311401;
        double fan1speed_warnHi = 0.8750627636909485;
        double fan1speed_warnLo = 0.3472723364830017;
        double fan1speed_limitHi = 0.6027861833572388;
        double fan1speed_limitLo = 0.7847954034805298;
        double fan2speed_warnHi = 0.2713779807090759;
        double fan2speed_warnLo = 0.5309661030769348;
        double fan2speed_limitHi = 0.566125750541687;
        double fan2speed_limitLo = 0.18084394931793213;
        double fan3speed_warnHi = 0.8151566982269287;
        double fan3speed_warnLo = 0.10243260860443115;
        double fan3speed_limitHi = 0.6225319504737854;
        double fan3speed_limitLo = 0.02865135669708252;
        double hgbvalveposn_warnHi = 0.20091331005096436;
        double hgbvalveposn_warnLo = 0.5535042881965637;
        double hgbvalveposn_limitHi = 0.216303288936615;
        double hgbvalveposn_limitLo = 0.33076733350753784;
        double liquidsubcooling_warnHi = 0.21007037162780762;
        double liquidsubcooling_warnLo = 0.8211714029312134;
        double liquidsubcooling_limitHi = 0.724603533744812;
        double liquidsubcooling_limitLo = 0.1649855375289917;
        double liquidtmp_M_warnHi = 0.524152934551239;
        double liquidtmp_M_warnLo = 0.1386559009552002;
        double liquidtmp_M_limitHi = 0.18888407945632935;
        double liquidtmp_M_limitLo = 0.746355f;
        double liquidtmp_P_warnHi = 0.6425913572311401;
        double liquidtmp_P_warnLo = 0.16918432712554932;
        double liquidtmp_P_limitHi = 0.4212082624435425;
        double liquidtmp_P_limitLo = 0.6034871339797974;
        double suctionprs_warnHi = 0.25848788022994995;
        double suctionprs_warnLo = 0.20617163181304932;
        double suctionprs_limitHi = 0.6782745122909546;
        double suctionprs_limitLo = 0.955681f;
        double suctiontmp_M_warnHi = 0.3962072f;
        double suctiontmp_M_warnLo = 0.5218521356582642;
        double suctiontmp_M_limitHi = 0.1899036169052124;
        double suctiontmp_M_limitLo = 0.4225732088088989;
        double suctiontmp_P_warnHi = 0.03787273168563843;
        double suctiontmp_P_warnLo = 0.3646594285964966;
        double suctiontmp_P_limitHi = 0.7142853140830994;
        double suctiontmp_P_limitLo = 0.8675350546836853;
        double waterintmp_warnHi = 0.9096395373344421;
        double waterintmp_warnLo = 0.3596722483634949;
        double waterintmp_limitHi = 0.4937942624092102;
        double waterintmp_limitLo = 0.1310117244720459;
        double waterouttmp_warnHi = 0.12645351886749268;
        double waterouttmp_warnLo = 0.0751606822013855;
        double waterouttmp_limitHi = 0.1677112579345703;
        double waterouttmp_limitLo = 0.6396954655647278;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_LimitsConfigurationEvent(priority, version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_LimitsConfigurationEvent));
        Refrig_Cold1_LimitsConfigurationEvent item_ = (Refrig_Cold1_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2_CompLimitsConfigurationEvent() throws Exception {
        int priority = 260;
        String version = "n";
        double cmprPowerDelayLimit = 0.9492185115814209;
        int cmprPowerDelayTime = 532;
        double cmprPowerImmedLimit = 0.74419766664505;
        double coldTempImmedLimit = 0.07167041301727295;
        double discPressDelayLimit = 0.5874601602554321;
        int discPressDelayTime = 585;
        double discPressImmedLimit = 0.5374249219894409;
        double discTempDelayLimit = 0.67213f;
        int discTempDelayTime = 830;
        double discTempImmedLimit = 0.08965545892715454;
        double discTempLowImmedLimit = 0.7400966882705688;
        double heaterTempLimit = 0.8178134560585022;
        double liquidTempDelayLimit = 0.6225771307945251;
        int liquidTempDelayTime = 935;
        double liquidTempImmedLimit = 0.4945831894874573;
        double orificeOffPress = 0.09346562623977661;
        double orificeOnPress = 0.11807596683502197;
        double phaseSepTempDelayLimit = 0.02763331f;
        int phaseSepTempDelayTime = 149;
        double pressDiffImmedLimit = 0.7953070998191833;
        double suctTempImmedLimit = 0.17072665691375732;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_CompLimitsConfigurationEvent));
        Refrig_Cold2_CompLimitsConfigurationEvent item_ = (Refrig_Cold2_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2_DeviceConfigurationEvent() throws Exception {
        int priority = 33;
        String version = "q";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        int vfd_address = 630;
        int vfd_baudRate = 446;
        String vfd_devcName = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_DeviceConfigurationEvent));
        Refrig_Cold2_DeviceConfigurationEvent item_ = (Refrig_Cold2_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceiveRefrig_Cold2_LimitsConfigurationEvent() throws Exception {
        int priority = 506;
        String version = "z";
        double ambienttmp_warnHi = 0.0295704f;
        double ambienttmp_warnLo = 0.8567120432853699;
        double ambienttmp_limitHi = 0.703027f;
        double ambienttmp_limitLo = 0.11930537223815918;
        double cabinettmp_warnHi = 0.7800835967063904;
        double cabinettmp_warnLo = 0.9634101986885071;
        double cabinettmp_limitHi = 0.6401426196098328;
        double cabinettmp_limitLo = 0.00840681791305542;
        double compcurrent_warnHi = 0.5613293051719666;
        double compcurrent_warnLo = 0.3452872633934021;
        double compcurrent_limitHi = 0.6132214665412903;
        double compcurrent_limitLo = 0.452708f;
        double comppower_warnHi = 0.2126712203025818;
        double comppower_warnLo = 0.9168487787246704;
        double comppower_limitHi = 0.2955929f;
        double comppower_limitLo = 0.4381973147392273;
        double compvfdcurr_warnHi = 0.7747090458869934;
        double compvfdcurr_warnLo = 0.1645141839981079;
        double compvfdcurr_limitHi = 0.296500027179718;
        double compvfdcurr_limitLo = 0.3348594903945923;
        double compvfdfreq_warnHi = 0.04089456796646118;
        double compvfdfreq_warnLo = 0.9079667925834656;
        double compvfdfreq_limitHi = 0.26252996921539307;
        double compvfdfreq_limitLo = 0.7911467552185059;
        double compvfdvolt_warnHi = 0.5862413048744202;
        double compvfdvolt_warnLo = 0.19596493244171143;
        double compvfdvolt_limitHi = 0.6517412066459656;
        double compvfdvolt_limitLo = 0.8109247088432312;
        double compvoltage_warnHi = 0.5020307898521423;
        double compvoltage_warnLo = 0.09269309043884277;
        double compvoltage_limitHi = 0.7096713781356812;
        double compvoltage_limitLo = 0.4633186459541321;
        double coolflowrate_warnHi = 0.610880970954895;
        double coolflowrate_warnLo = 0.2357664704322815;
        double coolflowrate_limitHi = 0.8266355991363525;
        double coolflowrate_limitLo = 0.8923792243003845;
        double coolvalveposn_warnHi = 0.7904093265533447;
        double coolvalveposn_warnLo = 0.007546544075012207;
        double coolvalveposn_limitHi = 0.02032071352005005;
        double coolvalveposn_limitLo = 0.1448100209236145;
        double dischrgprs_warnHi = 0.6774519681930542;
        double dischrgprs_warnLo = 0.9350197315216064;
        double dischrgprs_limitHi = 0.8183979392051697;
        double dischrgprs_limitLo = 0.9617493748664856;
        double dischrgtmp_M_warnHi = 0.3929516673088074;
        double dischrgtmp_M_warnLo = 0.8882981538772583;
        double dischrgtmp_M_limitHi = 0.9426085352897644;
        double dischrgtmp_M_limitLo = 0.2420047f;
        double dischrgtmp_P_warnHi = 0.6579023599624634;
        double dischrgtmp_P_warnLo = 0.792611f;
        double dischrgtmp_P_limitHi = 0.3765166401863098;
        double dischrgtmp_P_limitLo = 0.8020473122596741;
        double fan1speed_warnHi = 0.3539528250694275;
        double fan1speed_warnLo = 0.8028817176818848;
        double fan1speed_limitHi = 0.17002063989639282;
        double fan1speed_limitLo = 0.2709732f;
        double fan2speed_warnHi = 0.012377262115478516;
        double fan2speed_warnLo = 0.2536681294441223;
        double fan2speed_limitHi = 0.5590114593505859;
        double fan2speed_limitLo = 0.17061054706573486;
        double fan3speed_warnHi = 0.13917946815490723;
        double fan3speed_warnLo = 0.6210432052612305;
        double fan3speed_limitHi = 0.10065692663192749;
        double fan3speed_limitLo = 0.1617475152015686;
        double hgbvalveposn_warnHi = 0.6523122191429138;
        double hgbvalveposn_warnLo = 0.2882046699523926;
        double hgbvalveposn_limitHi = 0.8141778707504272;
        double hgbvalveposn_limitLo = 0.0724054f;
        double liquidsubcooling_warnHi = 0.9226796627044678;
        double liquidsubcooling_warnLo = 0.055135905742645264;
        double liquidsubcooling_limitHi = 0.12229812145233154;
        double liquidsubcooling_limitLo = 0.16417354345321655;
        double liquidtmp_M_warnHi = 0.0801962f;
        double liquidtmp_M_warnLo = 0.17703211307525635;
        double liquidtmp_M_limitHi = 0.38655567169189453;
        double liquidtmp_M_limitLo = 0.404455304145813;
        double liquidtmp_P_warnHi = 0.9292687773704529;
        double liquidtmp_P_warnLo = 0.7496299147605896;
        double liquidtmp_P_limitHi = 0.27523887157440186;
        double liquidtmp_P_limitLo = 0.5782743096351624;
        double suctionprs_warnHi = 0.27734827995300293;
        double suctionprs_warnLo = 0.6158115863800049;
        double suctionprs_limitHi = 0.1788643f;
        double suctionprs_limitLo = 0.4409077763557434;
        double suctiontmp_M_warnHi = 0.9314776659011841;
        double suctiontmp_M_warnLo = 0.6713199019432068;
        double suctiontmp_M_limitHi = 0.5559794902801514;
        double suctiontmp_M_limitLo = 0.8455294370651245;
        double suctiontmp_P_warnHi = 0.479996919631958;
        double suctiontmp_P_warnLo = 0.6631540656089783;
        double suctiontmp_P_limitHi = 0.9409094452857971;
        double suctiontmp_P_limitLo = 0.7073533535003662;
        double waterintmp_warnHi = 0.1218177080154419;
        double waterintmp_warnLo = 0.8578788042068481;
        double waterintmp_limitHi = 0.4422512f;
        double waterintmp_limitLo = 0.6322062015533447;
        double waterouttmp_warnHi = 0.8091465830802917;
        double waterouttmp_warnLo = 0.5049675107002258;
        double waterouttmp_limitHi = 0.8019691109657288;
        double waterouttmp_limitLo = 0.1533641219139099;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_LimitsConfigurationEvent(priority, version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_LimitsConfigurationEvent));
        Refrig_Cold2_LimitsConfigurationEvent item_ = (Refrig_Cold2_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_CoolMaq20_DeviceConfigurationEvent() throws Exception {
        int priority = 308;
        String version = "r";
        String node = "";
        String serials = "d";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_CoolMaq20_DeviceConfigurationEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Refrig_CoolMaq20_DeviceConfigurationEvent));
        Refrig_CoolMaq20_DeviceConfigurationEvent item_ = (Refrig_CoolMaq20_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_CompLimitsConfigurationEvent() throws Exception {
        int priority = 798;
        String version = "";
        double cmprPowerDelayLimit = 0.22563612461090088;
        int cmprPowerDelayTime = 487;
        double cmprPowerImmedLimit = 0.6106980443000793;
        double coldTempImmedLimit = 0.7112863063812256;
        double discPressDelayLimit = 0.22369462251663208;
        int discPressDelayTime = 477;
        double discPressImmedLimit = 0.33843398094177246;
        double discTempDelayLimit = 0.9524278044700623;
        int discTempDelayTime = 834;
        double discTempImmedLimit = 0.7489414215087891;
        double discTempLowImmedLimit = 0.9759699106216431;
        double heaterTempLimit = 0.6229037642478943;
        double liquidTempDelayLimit = 0.655523f;
        int liquidTempDelayTime = 40;
        double liquidTempImmedLimit = 0.24761521816253662;
        double orificeOffPress = 0.804999589920044;
        double orificeOnPress = 0.7068792581558228;
        double phaseSepTempDelayLimit = 0.23437517881393433;
        int phaseSepTempDelayTime = 43;
        double pressDiffImmedLimit = 0.4058322310447693;
        double suctTempImmedLimit = 0.15907102823257446;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_CompLimitsConfigurationEvent));
        Refrig_Cryo1_CompLimitsConfigurationEvent item_ = (Refrig_Cryo1_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DeviceConfigurationEvent() throws Exception {
        int priority = 187;
        String version = "";
        String maq20_node = "b";
        String maq20_serials = "";
        String plc_node = "h";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DeviceConfigurationEvent));
        Refrig_Cryo1_DeviceConfigurationEvent item_ = (Refrig_Cryo1_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_LimitsConfigurationEvent() throws Exception {
        int priority = 590;
        String version = "l";
        double aftercooltmp_warnHi = 0.7829119563102722;
        double aftercooltmp_warnLo = 0.9551782011985779;
        double aftercooltmp_limitHi = 0.8803683519363403;
        double aftercooltmp_limitLo = 0.9467967748641968;
        double compcurrent_warnHi = 0.05507081747055054;
        double compcurrent_warnLo = 0.37750154733657837;
        double compcurrent_limitHi = 0.32929152250289917;
        double compcurrent_limitLo = 0.6068287491798401;
        double comppower_warnHi = 0.19070512056350708;
        double comppower_warnLo = 0.9657025337219238;
        double comppower_limitHi = 0.811535120010376;
        double comppower_limitLo = 0.839469f;
        double compvoltage_warnHi = 0.6548264026641846;
        double compvoltage_warnLo = 0.3849772810935974;
        double compvoltage_limitHi = 0.2369445562362671;
        double compvoltage_limitLo = 0.060768187046051025;
        double dischrgprs_warnHi = 0.947840690612793;
        double dischrgprs_warnLo = 0.9907975792884827;
        double dischrgprs_limitHi = 0.3677181005477905;
        double dischrgprs_limitLo = 0.1419163942337036;
        double dischrgtmp_M_warnHi = 0.23200958967208862;
        double dischrgtmp_M_warnLo = 0.621763288974762;
        double dischrgtmp_M_limitHi = 0.1554107666015625;
        double dischrgtmp_M_limitLo = 0.5610649585723877;
        double dischrgtmp_P_warnHi = 0.37559783458709717;
        double dischrgtmp_P_warnLo = 0.32896852493286133;
        double dischrgtmp_P_limitHi = 0.8055156469345093;
        double dischrgtmp_P_limitLo = 0.08459645509719849;
        double fanspeed_warnHi = 0.33248448371887207;
        double fanspeed_warnLo = 0.5507811307907104;
        double fanspeed_limitHi = 0.9486668705940247;
        double fanspeed_limitLo = 0.6936050653457642;
        double oillevel_warnHi = 0.5140964984893799;
        double oillevel_warnLo = 0.7448531985282898;
        double oillevel_limitHi = 0.941771388053894;
        double oillevel_limitLo = 0.7484720349311829;
        double oilseptmp_warnHi = 0.7645028829574585;
        double oilseptmp_warnLo = 0.010468602180480957;
        double oilseptmp_limitHi = 0.6878884434700012;
        double oilseptmp_limitLo = 0.6218031644821167;
        double phaseseptmp_warnHi = 0.6412501335144043;
        double phaseseptmp_warnLo = 0.8648171424865723;
        double phaseseptmp_limitHi = 0.8498541712760925;
        double phaseseptmp_limitLo = 0.26377958059310913;
        double suctionprs_warnHi = 0.3724910616874695;
        double suctionprs_warnLo = 0.37040263414382935;
        double suctionprs_limitHi = 0.47953593730926514;
        double suctionprs_limitLo = 0.7584148049354553;
        double suctiontmp_M_warnHi = 0.3092666268348694;
        double suctiontmp_M_warnLo = 0.9946192502975464;
        double suctiontmp_M_limitHi = 0.8228532075881958;
        double suctiontmp_M_limitLo = 0.8266887664794922;
        double suctiontmp_P_warnHi = 0.140167236328125;
        double suctiontmp_P_warnLo = 0.36675918102264404;
        double suctiontmp_P_limitHi = 0.9616162776947021;
        double suctiontmp_P_limitLo = 0.20355886220932007;
        double surgetanktmp_warnHi = 0.06938314437866211;
        double surgetanktmp_warnLo = 0.885668f;
        double surgetanktmp_limitHi = 0.4787197709083557;
        double surgetanktmp_limitLo = 0.7090548872947693;
        double waterintmp_warnHi = 0.5793200731277466;
        double waterintmp_warnLo = 0.5293838381767273;
        double waterintmp_limitHi = 0.0858263373374939;
        double waterintmp_limitLo = 0.8258102536201477;
        double waterouttmp_warnHi = 0.0721203088760376;
        double waterouttmp_warnLo = 0.2859575152397156;
        double waterouttmp_limitHi = 0.12554824352264404;
        double waterouttmp_limitLo = 0.4413476586341858;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_LimitsConfigurationEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_LimitsConfigurationEvent));
        Refrig_Cryo1_LimitsConfigurationEvent item_ = (Refrig_Cryo1_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_CompLimitsConfigurationEvent() throws Exception {
        int priority = 917;
        String version = "";
        double cmprPowerDelayLimit = 0.6870742440223694;
        int cmprPowerDelayTime = 467;
        double cmprPowerImmedLimit = 0.02819424867630005;
        double coldTempImmedLimit = 0.07759493589401245;
        double discPressDelayLimit = 0.2796071767807007;
        int discPressDelayTime = 50;
        double discPressImmedLimit = 0.21378272771835327;
        double discTempDelayLimit = 0.7095667123794556;
        int discTempDelayTime = 914;
        double discTempImmedLimit = 0.8244872093200684;
        double discTempLowImmedLimit = 0.5943259000778198;
        double heaterTempLimit = 0.4248991012573242;
        double liquidTempDelayLimit = 0.5343916416168213;
        int liquidTempDelayTime = 378;
        double liquidTempImmedLimit = 0.8179831504821777;
        double orificeOffPress = 0.7096013426780701;
        double orificeOnPress = 0.2837026119232178;
        double phaseSepTempDelayLimit = 0.7916221618652344;
        int phaseSepTempDelayTime = 512;
        double pressDiffImmedLimit = 0.6353712677955627;
        double suctTempImmedLimit = 0.8158840537071228;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_CompLimitsConfigurationEvent));
        Refrig_Cryo2_CompLimitsConfigurationEvent item_ = (Refrig_Cryo2_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DeviceConfigurationEvent() throws Exception {
        int priority = 778;
        String version = "f";
        String maq20_node = "";
        String maq20_serials = "r";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DeviceConfigurationEvent));
        Refrig_Cryo2_DeviceConfigurationEvent item_ = (Refrig_Cryo2_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_LimitsConfigurationEvent() throws Exception {
        int priority = 257;
        String version = "";
        double aftercooltmp_warnHi = 0.11544859409332275;
        double aftercooltmp_warnLo = 0.531707f;
        double aftercooltmp_limitHi = 0.3855026960372925;
        double aftercooltmp_limitLo = 0.12662345170974731;
        double compcurrent_warnHi = 0.55040442943573;
        double compcurrent_warnLo = 0.4334644079208374;
        double compcurrent_limitHi = 0.18660622835159302;
        double compcurrent_limitLo = 0.7508691549301147;
        double comppower_warnHi = 0.941911518573761;
        double comppower_warnLo = 0.798945963382721;
        double comppower_limitHi = 0.3171289563179016;
        double comppower_limitLo = 0.3028132915496826;
        double compvoltage_warnHi = 0.6361914873123169;
        double compvoltage_warnLo = 0.610375702381134;
        double compvoltage_limitHi = 0.38867151737213135;
        double compvoltage_limitLo = 0.3044389f;
        double dischrgprs_warnHi = 0.8059951663017273;
        double dischrgprs_warnLo = 0.996269166469574;
        double dischrgprs_limitHi = 0.8227730989456177;
        double dischrgprs_limitLo = 0.6689545512199402;
        double dischrgtmp_M_warnHi = 0.5698431730270386;
        double dischrgtmp_M_warnLo = 0.9400115013122559;
        double dischrgtmp_M_limitHi = 0.2900077f;
        double dischrgtmp_M_limitLo = 0.23121285438537598;
        double dischrgtmp_P_warnHi = 0.706488f;
        double dischrgtmp_P_warnLo = 0.685739f;
        double dischrgtmp_P_limitHi = 0.5056788325309753;
        double dischrgtmp_P_limitLo = 0.810676f;
        double fanspeed_warnHi = 0.545616090297699;
        double fanspeed_warnLo = 0.35282236337661743;
        double fanspeed_limitHi = 0.30199337005615234;
        double fanspeed_limitLo = 0.9172133803367615;
        double oillevel_warnHi = 0.02047944f;
        double oillevel_warnLo = 0.1660524f;
        double oillevel_limitHi = 0.3338874578475952;
        double oillevel_limitLo = 0.521131f;
        double oilseptmp_warnHi = 0.2465037703514099;
        double oilseptmp_warnLo = 0.830807626247406;
        double oilseptmp_limitHi = 0.10707056522369385;
        double oilseptmp_limitLo = 0.9210320711135864;
        double phaseseptmp_warnHi = 0.1554531455039978;
        double phaseseptmp_warnLo = 0.09999215602874756;
        double phaseseptmp_limitHi = 0.1573919f;
        double phaseseptmp_limitLo = 0.895658016204834;
        double suctionprs_warnHi = 0.2465330958366394;
        double suctionprs_warnLo = 0.11442923545837402;
        double suctionprs_limitHi = 0.4659762978553772;
        double suctionprs_limitLo = 0.8361278176307678;
        double suctiontmp_M_warnHi = 0.00861752f;
        double suctiontmp_M_warnLo = 0.975890040397644;
        double suctiontmp_M_limitHi = 0.511019766330719;
        double suctiontmp_M_limitLo = 0.06850481033325195;
        double suctiontmp_P_warnHi = 0.8819335699081421;
        double suctiontmp_P_warnLo = 0.5103369355201721;
        double suctiontmp_P_limitHi = 0.5715826153755188;
        double suctiontmp_P_limitLo = 0.8169936537742615;
        double surgetanktmp_warnHi = 0.1390208601951599;
        double surgetanktmp_warnLo = 0.779719f;
        double surgetanktmp_limitHi = 0.9887209534645081;
        double surgetanktmp_limitLo = 0.277072012424469;
        double waterintmp_warnHi = 0.915184736251831;
        double waterintmp_warnLo = 0.538340151309967;
        double waterintmp_limitHi = 0.42300945520401;
        double waterintmp_limitLo = 0.6953703761100769;
        double waterouttmp_warnHi = 0.9652260541915894;
        double waterouttmp_warnLo = 0.14212846755981445;
        double waterouttmp_limitHi = 0.733724f;
        double waterouttmp_limitLo = 0.6471393704414368;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_LimitsConfigurationEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_LimitsConfigurationEvent));
        Refrig_Cryo2_LimitsConfigurationEvent item_ = (Refrig_Cryo2_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_CompLimitsConfigurationEvent() throws Exception {
        int priority = 301;
        String version = "u";
        double cmprPowerDelayLimit = 0.3988179f;
        int cmprPowerDelayTime = 481;
        double cmprPowerImmedLimit = 0.26867908239364624;
        double coldTempImmedLimit = 0.8790637850761414;
        double discPressDelayLimit = 0.2067958116531372;
        int discPressDelayTime = 114;
        double discPressImmedLimit = 0.5233194828033447;
        double discTempDelayLimit = 0.4429087f;
        int discTempDelayTime = 749;
        double discTempImmedLimit = 0.021564245223999023;
        double discTempLowImmedLimit = 0.1617315411567688;
        double heaterTempLimit = 0.0942736268043518;
        double liquidTempDelayLimit = 0.15730106830596924;
        int liquidTempDelayTime = 312;
        double liquidTempImmedLimit = 0.87872f;
        double orificeOffPress = 0.04913193f;
        double orificeOnPress = 0.9343748688697815;
        double phaseSepTempDelayLimit = 0.11765807867050171;
        int phaseSepTempDelayTime = 620;
        double pressDiffImmedLimit = 0.7465725541114807;
        double suctTempImmedLimit = 0.3558666706085205;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_CompLimitsConfigurationEvent));
        Refrig_Cryo3_CompLimitsConfigurationEvent item_ = (Refrig_Cryo3_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DeviceConfigurationEvent() throws Exception {
        int priority = 191;
        String version = "f";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DeviceConfigurationEvent));
        Refrig_Cryo3_DeviceConfigurationEvent item_ = (Refrig_Cryo3_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_LimitsConfigurationEvent() throws Exception {
        int priority = 177;
        String version = "";
        double aftercooltmp_warnHi = 0.6061123609542847;
        double aftercooltmp_warnLo = 0.2985035181045532;
        double aftercooltmp_limitHi = 0.813226f;
        double aftercooltmp_limitLo = 0.7704379558563232;
        double ambienttmp_warnHi = 0.009990692138671875;
        double ambienttmp_warnLo = 0.14833104610443115;
        double ambienttmp_limitHi = 0.14033353328704834;
        double ambienttmp_limitLo = 0.6291144490242004;
        double cabinettmp_warnHi = 0.19138479232788086;
        double cabinettmp_warnLo = 0.910206f;
        double cabinettmp_limitHi = 0.6549215912818909;
        double cabinettmp_limitLo = 0.8662184476852417;
        double compcurrent_warnHi = 0.7756784558296204;
        double compcurrent_warnLo = 0.6804755330085754;
        double compcurrent_limitHi = 0.9372109174728394;
        double compcurrent_limitLo = 0.3508124351501465;
        double comppower_warnHi = 0.8864843845367432;
        double comppower_warnLo = 0.1727469563484192;
        double comppower_limitHi = 0.13490456342697144;
        double comppower_limitLo = 0.3473753333091736;
        double compvoltage_warnHi = 0.6098875999450684;
        double compvoltage_warnLo = 0.7934238314628601;
        double compvoltage_limitHi = 0.1778220534324646;
        double compvoltage_limitLo = 0.4586156f;
        double dischrgprs_warnHi = 0.6101097464561462;
        double dischrgprs_warnLo = 0.299530029296875;
        double dischrgprs_limitHi = 0.12283968925476074;
        double dischrgprs_limitLo = 0.08387166261672974;
        double dischrgtmp_M_warnHi = 0.35478538274765015;
        double dischrgtmp_M_warnLo = 0.9644457697868347;
        double dischrgtmp_M_limitHi = 0.20856934785842896;
        double dischrgtmp_M_limitLo = 0.6814109086990356;
        double dischrgtmp_P_warnHi = 0.6355234384536743;
        double dischrgtmp_P_warnLo = 0.10355937480926514;
        double dischrgtmp_P_limitHi = 0.4383151f;
        double dischrgtmp_P_limitLo = 0.9260600805282593;
        double fanspeed_warnHi = 0.295015811920166;
        double fanspeed_warnLo = 0.12573248147964478;
        double fanspeed_limitHi = 0.7065396308898926;
        double fanspeed_limitLo = 0.3767498731613159;
        double oillevel_warnHi = 0.24975663423538208;
        double oillevel_warnLo = 0.4749488830566406;
        double oillevel_limitHi = 0.3190044164657593;
        double oillevel_limitLo = 0.20412278175354004;
        double oilseptmp_warnHi = 0.9971677660942078;
        double oilseptmp_warnLo = 0.10977274179458618;
        double oilseptmp_limitHi = 0.5512157082557678;
        double oilseptmp_limitLo = 0.396841824054718;
        double phaseseptmp_warnHi = 0.052951693534851074;
        double phaseseptmp_warnLo = 0.6895899176597595;
        double phaseseptmp_limitHi = 0.855726f;
        double phaseseptmp_limitLo = 0.2652818560600281;
        double suctionprs_warnHi = 0.9297782182693481;
        double suctionprs_warnLo = 0.7525027394294739;
        double suctionprs_limitHi = 0.8187400698661804;
        double suctionprs_limitLo = 0.9196393489837646;
        double suctiontmp_M_warnHi = 0.8585658669471741;
        double suctiontmp_M_warnLo = 0.6897554993629456;
        double suctiontmp_M_limitHi = 0.7235310673713684;
        double suctiontmp_M_limitLo = 0.2210521101951599;
        double suctiontmp_P_warnHi = 8.614659309387207E-4;
        double suctiontmp_P_warnLo = 0.758385f;
        double suctiontmp_P_limitHi = 0.986163318157196;
        double suctiontmp_P_limitLo = 0.8220734000205994;
        double surgetanktmp_warnHi = 0.2030126452445984;
        double surgetanktmp_warnLo = 0.1932382583618164;
        double surgetanktmp_limitHi = 0.062367022037506104;
        double surgetanktmp_limitLo = 0.7379392981529236;
        double waterintmp_warnHi = 0.7134362459182739;
        double waterintmp_warnLo = 0.3505188226699829;
        double waterintmp_limitHi = 0.09814947843551636;
        double waterintmp_limitLo = 0.16175276041030884;
        double waterouttmp_warnHi = 0.8024162650108337;
        double waterouttmp_warnLo = 0.8596912026405334;
        double waterouttmp_limitHi = 0.41652631759643555;
        double waterouttmp_limitLo = 0.27237361669540405;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_LimitsConfigurationEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_LimitsConfigurationEvent));
        Refrig_Cryo3_LimitsConfigurationEvent item_ = (Refrig_Cryo3_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4_CompLimitsConfigurationEvent() throws Exception {
        int priority = 975;
        String version = "x";
        double cmprPowerDelayLimit = 0.7289501428604126;
        int cmprPowerDelayTime = 698;
        double cmprPowerImmedLimit = 0.7711588144302368;
        double coldTempImmedLimit = 0.22900527715682983;
        double discPressDelayLimit = 0.6242959499359131;
        int discPressDelayTime = 971;
        double discPressImmedLimit = 0.19282597303390503;
        double discTempDelayLimit = 0.22758746147155762;
        int discTempDelayTime = 876;
        double discTempImmedLimit = 0.3753041625022888;
        double discTempLowImmedLimit = 0.16835826635360718;
        double heaterTempLimit = 0.5050604343414307;
        double liquidTempDelayLimit = 0.06370240449905396;
        int liquidTempDelayTime = 438;
        double liquidTempImmedLimit = 0.06612330675125122;
        double orificeOffPress = 0.24641722440719604;
        double orificeOnPress = 0.4908837676048279;
        double phaseSepTempDelayLimit = 0.5330145359039307;
        int phaseSepTempDelayTime = 450;
        double pressDiffImmedLimit = 0.9086655378341675;
        double suctTempImmedLimit = 0.5705804228782654;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_CompLimitsConfigurationEvent));
        Refrig_Cryo4_CompLimitsConfigurationEvent item_ = (Refrig_Cryo4_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DeviceConfigurationEvent() throws Exception {
        int priority = 115;
        String version = "";
        String maq20_node = "j";
        String maq20_serials = "";
        String plc_node = "l";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DeviceConfigurationEvent));
        Refrig_Cryo4_DeviceConfigurationEvent item_ = (Refrig_Cryo4_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_LimitsConfigurationEvent() throws Exception {
        int priority = 865;
        String version = "";
        double aftercooltmp_warnHi = 0.2087729573249817;
        double aftercooltmp_warnLo = 0.0972716212272644;
        double aftercooltmp_limitHi = 0.5894113183021545;
        double aftercooltmp_limitLo = 0.14540356397628784;
        double compcurrent_warnHi = 0.48003554344177246;
        double compcurrent_warnLo = 0.9238985776901245;
        double compcurrent_limitHi = 0.4512117f;
        double compcurrent_limitLo = 0.33633846044540405;
        double comppower_warnHi = 0.3604347f;
        double comppower_warnLo = 0.716579020023346;
        double comppower_limitHi = 0.8807411193847656;
        double comppower_limitLo = 0.22478598356246948;
        double compvoltage_warnHi = 0.01323777437210083;
        double compvoltage_warnLo = 0.48775774240493774;
        double compvoltage_limitHi = 0.3348802924156189;
        double compvoltage_limitLo = 0.03337627649307251;
        double dischrgprs_warnHi = 0.5512261986732483;
        double dischrgprs_warnLo = 0.3685334324836731;
        double dischrgprs_limitHi = 0.14840304851531982;
        double dischrgprs_limitLo = 0.5868754982948303;
        double dischrgtmp_M_warnHi = 0.2468433380126953;
        double dischrgtmp_M_warnLo = 0.5710065364837646;
        double dischrgtmp_M_limitHi = 0.1229315996170044;
        double dischrgtmp_M_limitLo = 0.36650723218917847;
        double dischrgtmp_P_warnHi = 0.3143569827079773;
        double dischrgtmp_P_warnLo = 0.7865678668022156;
        double dischrgtmp_P_limitHi = 0.7533522248268127;
        double dischrgtmp_P_limitLo = 0.189189612865448;
        double fanspeed_warnHi = 0.4931233525276184;
        double fanspeed_warnLo = 0.5774151682853699;
        double fanspeed_limitHi = 0.10885119438171387;
        double fanspeed_limitLo = 0.18275481462478638;
        double oillevel_warnHi = 0.6625542044639587;
        double oillevel_warnLo = 0.65358f;
        double oillevel_limitHi = 0.4216992259025574;
        double oillevel_limitLo = 0.49060964584350586;
        double oilseptmp_warnHi = 0.576188862323761;
        double oilseptmp_warnLo = 0.7076285481452942;
        double oilseptmp_limitHi = 0.8091249465942383;
        double oilseptmp_limitLo = 0.5208961963653564;
        double phaseseptmp_warnHi = 0.745803952217102;
        double phaseseptmp_warnLo = 0.4315042495727539;
        double phaseseptmp_limitHi = 0.06382858753204346;
        double phaseseptmp_limitLo = 0.44760453701019287;
        double suctionprs_warnHi = 0.22132503986358643;
        double suctionprs_warnLo = 0.582874059677124;
        double suctionprs_limitHi = 0.47678375244140625;
        double suctionprs_limitLo = 0.9815229177474976;
        double suctiontmp_M_warnHi = 0.8861351013183594;
        double suctiontmp_M_warnLo = 0.26060914993286133;
        double suctiontmp_M_limitHi = 0.40995967388153076;
        double suctiontmp_M_limitLo = 0.3302185535430908;
        double suctiontmp_P_warnHi = 0.2610187530517578;
        double suctiontmp_P_warnLo = 0.540095865726471;
        double suctiontmp_P_limitHi = 0.1026091f;
        double suctiontmp_P_limitLo = 0.4469099f;
        double surgetanktmp_warnHi = 0.22739005088806152;
        double surgetanktmp_warnLo = 0.09896194934844971;
        double surgetanktmp_limitHi = 0.5870565176010132;
        double surgetanktmp_limitLo = 0.5822194218635559;
        double waterintmp_warnHi = 0.5386918187141418;
        double waterintmp_warnLo = 0.6131938695907593;
        double waterintmp_limitHi = 0.8008796572685242;
        double waterintmp_limitLo = 0.2701093554496765;
        double waterouttmp_warnHi = 0.18812376260757446;
        double waterouttmp_warnLo = 0.3437894f;
        double waterouttmp_limitHi = 0.0325050950050354;
        double waterouttmp_limitLo = 0.9351528882980347;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_LimitsConfigurationEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_LimitsConfigurationEvent));
        Refrig_Cryo4_LimitsConfigurationEvent item_ = (Refrig_Cryo4_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_CompLimitsConfigurationEvent() throws Exception {
        int priority = 873;
        String version = "";
        double cmprPowerDelayLimit = 0.8251739144325256;
        int cmprPowerDelayTime = 982;
        double cmprPowerImmedLimit = 0.012217521667480469;
        double coldTempImmedLimit = 0.2790037989616394;
        double discPressDelayLimit = 0.8167297840118408;
        int discPressDelayTime = 46;
        double discPressImmedLimit = 0.37689924240112305;
        double discTempDelayLimit = 0.72347092628479;
        int discTempDelayTime = 127;
        double discTempImmedLimit = 0.4205285906791687;
        double discTempLowImmedLimit = 0.9744883179664612;
        double heaterTempLimit = 0.8269518613815308;
        double liquidTempDelayLimit = 0.5299327373504639;
        int liquidTempDelayTime = 923;
        double liquidTempImmedLimit = 0.8403084874153137;
        double orificeOffPress = 0.2651034f;
        double orificeOnPress = 0.2321536f;
        double phaseSepTempDelayLimit = 0.24338674545288086;
        int phaseSepTempDelayTime = 633;
        double pressDiffImmedLimit = 0.24748414754867554;
        double suctTempImmedLimit = 0.3773950934410095;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_CompLimitsConfigurationEvent));
        Refrig_Cryo5_CompLimitsConfigurationEvent item_ = (Refrig_Cryo5_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DeviceConfigurationEvent() throws Exception {
        int priority = 321;
        String version = "";
        String maq20_node = "";
        String maq20_serials = "f";
        String plc_node = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DeviceConfigurationEvent));
        Refrig_Cryo5_DeviceConfigurationEvent item_ = (Refrig_Cryo5_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_LimitsConfigurationEvent() throws Exception {
        int priority = 688;
        String version = "";
        double aftercooltmp_warnHi = 0.4228951930999756;
        double aftercooltmp_warnLo = 0.2748332f;
        double aftercooltmp_limitHi = 0.30031102895736694;
        double aftercooltmp_limitLo = 0.6927521824836731;
        double ambienttmp_warnHi = 0.037424683570861816;
        double ambienttmp_warnLo = 0.2015022f;
        double ambienttmp_limitHi = 0.024693548679351807;
        double ambienttmp_limitLo = 0.7132042646408081;
        double cabinettmp_warnHi = 0.4456857442855835;
        double cabinettmp_warnLo = 0.9054670929908752;
        double cabinettmp_limitHi = 0.3275317f;
        double cabinettmp_limitLo = 0.17269080877304077;
        double compcurrent_warnHi = 0.9117224216461182;
        double compcurrent_warnLo = 0.9080513715744019;
        double compcurrent_limitHi = 0.40556687116622925;
        double compcurrent_limitLo = 0.7757561802864075;
        double comppower_warnHi = 0.793748f;
        double comppower_warnLo = 0.250373f;
        double comppower_limitHi = 0.08731728792190552;
        double comppower_limitLo = 0.9066471457481384;
        double compvoltage_warnHi = 0.7543467879295349;
        double compvoltage_warnLo = 0.6659121513366699;
        double compvoltage_limitHi = 0.03457885980606079;
        double compvoltage_limitLo = 0.012080729007720947;
        double dischrgprs_warnHi = 0.1956343650817871;
        double dischrgprs_warnLo = 0.1312609314918518;
        double dischrgprs_limitHi = 0.17674553394317627;
        double dischrgprs_limitLo = 0.1836094856262207;
        double dischrgtmp_M_warnHi = 0.6274861693382263;
        double dischrgtmp_M_warnLo = 0.4388948678970337;
        double dischrgtmp_M_limitHi = 0.9913501739501953;
        double dischrgtmp_M_limitLo = 0.27084267139434814;
        double dischrgtmp_P_warnHi = 0.18169403076171875;
        double dischrgtmp_P_warnLo = 0.09214985370635986;
        double dischrgtmp_P_limitHi = 0.4011055827140808;
        double dischrgtmp_P_limitLo = 0.017182588577270508;
        double fanspeed_warnHi = 0.568577766418457;
        double fanspeed_warnLo = 0.2997971177101135;
        double fanspeed_limitHi = 0.03229391574859619;
        double fanspeed_limitLo = 0.46688413619995117;
        double oillevel_warnHi = 0.9947351813316345;
        double oillevel_warnLo = 0.6388403177261353;
        double oillevel_limitHi = 0.6264894604682922;
        double oillevel_limitLo = 0.5283551812171936;
        double oilseptmp_warnHi = 0.18395566940307617;
        double oilseptmp_warnLo = 0.1932077407836914;
        double oilseptmp_limitHi = 0.6003178954124451;
        double oilseptmp_limitLo = 0.6415472626686096;
        double phaseseptmp_warnHi = 0.8836649656295776;
        double phaseseptmp_warnLo = 0.6872890591621399;
        double phaseseptmp_limitHi = 0.26738274097442627;
        double phaseseptmp_limitLo = 0.05051279067993164;
        double suctionprs_warnHi = 0.5155674815177917;
        double suctionprs_warnLo = 0.4818124771118164;
        double suctionprs_limitHi = 0.5618872046470642;
        double suctionprs_limitLo = 0.05482828617095947;
        double suctiontmp_M_warnHi = 0.8134623169898987;
        double suctiontmp_M_warnLo = 0.8410322666168213;
        double suctiontmp_M_limitHi = 0.3022293448448181;
        double suctiontmp_M_limitLo = 0.6503296494483948;
        double suctiontmp_P_warnHi = 0.9587438702583313;
        double suctiontmp_P_warnLo = 0.8108999133110046;
        double suctiontmp_P_limitHi = 4.579425E-4f;
        double suctiontmp_P_limitLo = 0.28082817792892456;
        double surgetanktmp_warnHi = 0.4031602740287781;
        double surgetanktmp_warnLo = 0.4547199010848999;
        double surgetanktmp_limitHi = 0.9335781931877136;
        double surgetanktmp_limitLo = 0.6341502070426941;
        double waterintmp_warnHi = 0.9904511570930481;
        double waterintmp_warnLo = 0.30330485105514526;
        double waterintmp_limitHi = 0.9470493793487549;
        double waterintmp_limitLo = 0.9195677042007446;
        double waterouttmp_warnHi = 0.3380838632583618;
        double waterouttmp_warnLo = 0.3089866042137146;
        double waterouttmp_limitHi = 0.1393022f;
        double waterouttmp_limitLo = 0.2666983f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_LimitsConfigurationEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_LimitsConfigurationEvent));
        Refrig_Cryo5_LimitsConfigurationEvent item_ = (Refrig_Cryo5_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6_CompLimitsConfigurationEvent() throws Exception {
        int priority = 812;
        String version = "u";
        double cmprPowerDelayLimit = 0.4610862731933594;
        int cmprPowerDelayTime = 75;
        double cmprPowerImmedLimit = 0.12129944562911987;
        double coldTempImmedLimit = 0.3975124955177307;
        double discPressDelayLimit = 0.36742645502090454;
        int discPressDelayTime = 123;
        double discPressImmedLimit = 0.8481138944625854;
        double discTempDelayLimit = 0.24405282735824585;
        int discTempDelayTime = 966;
        double discTempImmedLimit = 0.553186297416687;
        double discTempLowImmedLimit = 0.04808610677719116;
        double heaterTempLimit = 0.8101748824119568;
        double liquidTempDelayLimit = 0.669546365737915;
        int liquidTempDelayTime = 397;
        double liquidTempImmedLimit = 0.14659267663955688;
        double orificeOffPress = 0.8209753632545471;
        double orificeOnPress = 0.3188077211380005;
        double phaseSepTempDelayLimit = 0.5122677683830261;
        int phaseSepTempDelayTime = 418;
        double pressDiffImmedLimit = 0.699066162109375;
        double suctTempImmedLimit = 0.8277574181556702;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_CompLimitsConfigurationEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_CompLimitsConfigurationEvent));
        Refrig_Cryo6_CompLimitsConfigurationEvent item_ = (Refrig_Cryo6_CompLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DeviceConfigurationEvent() throws Exception {
        int priority = 832;
        String version = "m";
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "a";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DeviceConfigurationEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DeviceConfigurationEvent));
        Refrig_Cryo6_DeviceConfigurationEvent item_ = (Refrig_Cryo6_DeviceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_LimitsConfigurationEvent() throws Exception {
        int priority = 391;
        String version = "";
        double aftercooltmp_warnHi = 0.6613069176673889;
        double aftercooltmp_warnLo = 0.808845579624176;
        double aftercooltmp_limitHi = 0.24356502294540405;
        double aftercooltmp_limitLo = 0.945868f;
        double compcurrent_warnHi = 0.6540940403938293;
        double compcurrent_warnLo = 0.4631303548812866;
        double compcurrent_limitHi = 0.435367226600647;
        double compcurrent_limitLo = 0.8999431133270264;
        double comppower_warnHi = 0.3723371624946594;
        double comppower_warnLo = 0.4801780581474304;
        double comppower_limitHi = 0.7776781320571899;
        double comppower_limitLo = 0.049924612045288086;
        double compvoltage_warnHi = 0.849928081035614;
        double compvoltage_warnLo = 0.1619059443473816;
        double compvoltage_limitHi = 0.04338204860687256;
        double compvoltage_limitLo = 0.7321491241455078;
        double dischrgprs_warnHi = 0.7698231339454651;
        double dischrgprs_warnLo = 0.43954282999038696;
        double dischrgprs_limitHi = 0.5815322399139404;
        double dischrgprs_limitLo = 0.8080740571022034;
        double dischrgtmp_M_warnHi = 0.8111572861671448;
        double dischrgtmp_M_warnLo = 0.4321204423904419;
        double dischrgtmp_M_limitHi = 0.6491281390190125;
        double dischrgtmp_M_limitLo = 0.6358501315116882;
        double dischrgtmp_P_warnHi = 0.3417816758155823;
        double dischrgtmp_P_warnLo = 0.8262566924095154;
        double dischrgtmp_P_limitHi = 0.1373441219329834;
        double dischrgtmp_P_limitLo = 0.7531834840774536;
        double fanspeed_warnHi = 0.917516827583313;
        double fanspeed_warnLo = 0.5608363747596741;
        double fanspeed_limitHi = 0.5418193340301514;
        double fanspeed_limitLo = 0.5804728865623474;
        double oillevel_warnHi = 0.2977433204650879;
        double oillevel_warnLo = 0.764141857624054;
        double oillevel_limitHi = 0.8136701583862305;
        double oillevel_limitLo = 0.8727527260780334;
        double oilseptmp_warnHi = 0.18094027042388916;
        double oilseptmp_warnLo = 0.976333737373352;
        double oilseptmp_limitHi = 0.2161724f;
        double oilseptmp_limitLo = 0.09665262699127197;
        double phaseseptmp_warnHi = 0.14348101615905762;
        double phaseseptmp_warnLo = 0.7611824870109558;
        double phaseseptmp_limitHi = 0.7056794166564941;
        double phaseseptmp_limitLo = 0.13147515058517456;
        double suctionprs_warnHi = 0.26106226444244385;
        double suctionprs_warnLo = 0.8099966645240784;
        double suctionprs_limitHi = 0.8740232586860657;
        double suctionprs_limitLo = 0.14178311824798584;
        double suctiontmp_M_warnHi = 0.17586815357208252;
        double suctiontmp_M_warnLo = 0.3382815718650818;
        double suctiontmp_M_limitHi = 0.6187385320663452;
        double suctiontmp_M_limitLo = 0.545904278755188;
        double suctiontmp_P_warnHi = 0.40586984157562256;
        double suctiontmp_P_warnLo = 0.8204331398010254;
        double suctiontmp_P_limitHi = 0.4479323f;
        double suctiontmp_P_limitLo = 0.3169436454772949;
        double surgetanktmp_warnHi = 0.07807135581970215;
        double surgetanktmp_warnLo = 0.07647973299026489;
        double surgetanktmp_limitHi = 0.44509416818618774;
        double surgetanktmp_limitLo = 0.45981645584106445;
        double waterintmp_warnHi = 0.9981975555419922;
        double waterintmp_warnLo = 0.17241257429122925;
        double waterintmp_limitHi = 0.1978340744972229;
        double waterintmp_limitLo = 0.17217093706130981;
        double waterouttmp_warnHi = 0.6790739297866821;
        double waterouttmp_warnLo = 0.10500502586364746;
        double waterouttmp_limitHi = 0.4812912344932556;
        double waterouttmp_limitLo = 0.6346797943115234;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_LimitsConfigurationEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_LimitsConfigurationEvent));
        Refrig_Cryo6_LimitsConfigurationEvent item_ = (Refrig_Cryo6_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 448;
        String version = "";
        int schedulers_default_nTasks = 969;
        int schedulers_default_nThreads = 390;
        int schedulers_monitor_update_publish_scheduler_nTasks = 230;
        int schedulers_monitor_update_publish_scheduler_nThreads = 878;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasksConfigurationEvent));
        Refrig_PeriodicTasksConfigurationEvent item_ = (Refrig_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 941;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 166L;
        long cold1_FanCtrl_timer_taskPeriodMillis = 450L;
        long cold2_FanCtrl_timer_taskPeriodMillis = 223L;
        long compressor_state_taskPeriodMillis = 920L;
        long cryo3_FanCtrl_timer_taskPeriodMillis = 465L;
        long cryo5_FanCtrl_timer_taskPeriodMillis = 232L;
        long heartbeat_taskPeriodMillis = 835L;
        long monitor_check_taskPeriodMillis = 321L;
        long monitor_publish_taskPeriodMillis = 943L;
        long monitor_update_taskPeriodMillis = 678L;
        long runtimeinfo_taskPeriodMillis = 870L;
        long update_time_taskPeriodMillis = 990L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, cold1_FanCtrl_timer_taskPeriodMillis, cold2_FanCtrl_timer_taskPeriodMillis, compressor_state_taskPeriodMillis, cryo3_FanCtrl_timer_taskPeriodMillis, cryo5_FanCtrl_timer_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, update_time_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_timersConfigurationEvent));
        Refrig_PeriodicTasks_timersConfigurationEvent item_ = (Refrig_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)cold1_FanCtrl_timer_taskPeriodMillis, (long)item_.getCold1_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)cold2_FanCtrl_timer_taskPeriodMillis, (long)item_.getCold2_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)compressor_state_taskPeriodMillis, (long)item_.getCompressor_state_taskPeriodMillis());
        Assert.assertEquals((long)cryo3_FanCtrl_timer_taskPeriodMillis, (long)item_.getCryo3_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)cryo5_FanCtrl_timer_taskPeriodMillis, (long)item_.getCryo5_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)update_time_taskPeriodMillis, (long)item_.getUpdate_time_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_AgentMonitorServiceConfigurationEvent() throws Exception {
        int priority = 658;
        String version = "u";
        long taskPeriodMillis = 306L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_AgentMonitorServiceConfigurationEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_AgentMonitorServiceConfigurationEvent));
        Vacuum_AgentMonitorServiceConfigurationEvent item_ = (Vacuum_AgentMonitorServiceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_CIP1CConfigurationEvent() throws Exception {
        int priority = 408;
        String version = "";
        double current = 0.48140984773635864;
        double power = 0.030275821685791016;
        double voltage = 0.4710425138473511;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1CConfigurationEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1CConfigurationEvent));
        Vacuum_CIP1CConfigurationEvent item_ = (Vacuum_CIP1CConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_IConfigurationEvent() throws Exception {
        int priority = 581;
        String version = "";
        double warnHi = 0.7920231819152832;
        double warnLo = 0.4358493685722351;
        double limitHi = 0.849946916103363;
        double limitLo = 0.5127871036529541;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1_IConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_IConfigurationEvent));
        Vacuum_CIP1_IConfigurationEvent item_ = (Vacuum_CIP1_IConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VConfigurationEvent() throws Exception {
        int priority = 470;
        String version = "r";
        double warnHi = 0.2898898720741272;
        double warnLo = 0.9397528767585754;
        double limitHi = 0.6208028793334961;
        double limitLo = 0.8012942671775818;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1_VConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VConfigurationEvent));
        Vacuum_CIP1_VConfigurationEvent item_ = (Vacuum_CIP1_VConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2CConfigurationEvent() throws Exception {
        int priority = 604;
        String version = "e";
        double current = 0.4441121816635132;
        double power = 0.38934582471847534;
        double voltage = 0.24884724617004395;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2CConfigurationEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2CConfigurationEvent));
        Vacuum_CIP2CConfigurationEvent item_ = (Vacuum_CIP2CConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_IConfigurationEvent() throws Exception {
        int priority = 1;
        String version = "d";
        double warnHi = 0.1459333896636963;
        double warnLo = 0.6906232833862305;
        double limitHi = 0.4050159f;
        double limitLo = 0.1610490083694458;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2_IConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_IConfigurationEvent));
        Vacuum_CIP2_IConfigurationEvent item_ = (Vacuum_CIP2_IConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VConfigurationEvent() throws Exception {
        int priority = 951;
        String version = "";
        double warnHi = 0.3442254662513733;
        double warnLo = 0.7518329620361328;
        double limitHi = 0.5052889585494995;
        double limitLo = 0.08975344896316528;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2_VConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VConfigurationEvent));
        Vacuum_CIP2_VConfigurationEvent item_ = (Vacuum_CIP2_VConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3CConfigurationEvent() throws Exception {
        int priority = 223;
        String version = "z";
        double current = 0.5505384802818298;
        double power = 0.014067888259887695;
        double voltage = 0.03614205f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3CConfigurationEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3CConfigurationEvent));
        Vacuum_CIP3CConfigurationEvent item_ = (Vacuum_CIP3CConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_IConfigurationEvent() throws Exception {
        int priority = 992;
        String version = "";
        double warnHi = 0.7331953048706055;
        double warnLo = 0.44190144538879395;
        double limitHi = 0.8249333500862122;
        double limitLo = 0.3438388705253601;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3_IConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_IConfigurationEvent));
        Vacuum_CIP3_IConfigurationEvent item_ = (Vacuum_CIP3_IConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VConfigurationEvent() throws Exception {
        int priority = 508;
        String version = "";
        double warnHi = 0.388649046421051;
        double warnLo = 0.192366361618042;
        double limitHi = 0.3791356682777405;
        double limitLo = 0.6766318678855896;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3_VConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VConfigurationEvent));
        Vacuum_CIP3_VConfigurationEvent item_ = (Vacuum_CIP3_VConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4CConfigurationEvent() throws Exception {
        int priority = 861;
        String version = "f";
        double current = 0.20522820949554443;
        double power = 0.04169929027557373;
        double voltage = 0.5060730576515198;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4CConfigurationEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4CConfigurationEvent));
        Vacuum_CIP4CConfigurationEvent item_ = (Vacuum_CIP4CConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_IConfigurationEvent() throws Exception {
        int priority = 374;
        String version = "";
        double warnHi = 0.20204466581344604;
        double warnLo = 0.4414917230606079;
        double limitHi = 0.8437589406967163;
        double limitLo = 0.8764467239379883;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4_IConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_IConfigurationEvent));
        Vacuum_CIP4_IConfigurationEvent item_ = (Vacuum_CIP4_IConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VConfigurationEvent() throws Exception {
        int priority = 931;
        String version = "";
        double warnHi = 0.9662340879440308;
        double warnLo = 0.11944049596786499;
        double limitHi = 0.7138491868972778;
        double limitLo = 0.15329605340957642;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4_VConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VConfigurationEvent));
        Vacuum_CIP4_VConfigurationEvent item_ = (Vacuum_CIP4_VConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5CConfigurationEvent() throws Exception {
        int priority = 411;
        String version = "";
        double current = 0.8015385270118713;
        double power = 0.03770667314529419;
        double voltage = 0.2436668872833252;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5CConfigurationEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5CConfigurationEvent));
        Vacuum_CIP5CConfigurationEvent item_ = (Vacuum_CIP5CConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_IConfigurationEvent() throws Exception {
        int priority = 777;
        String version = "v";
        double warnHi = 0.3443509340286255;
        double warnLo = 0.8494451642036438;
        double limitHi = 0.7361348271369934;
        double limitLo = 0.4846060276031494;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5_IConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_IConfigurationEvent));
        Vacuum_CIP5_IConfigurationEvent item_ = (Vacuum_CIP5_IConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VConfigurationEvent() throws Exception {
        int priority = 354;
        String version = "";
        double warnHi = 0.3612545132637024;
        double warnLo = 0.6111468076705933;
        double limitHi = 0.046657443046569824;
        double limitLo = 0.7034997344017029;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5_VConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VConfigurationEvent));
        Vacuum_CIP5_VConfigurationEvent item_ = (Vacuum_CIP5_VConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6CConfigurationEvent() throws Exception {
        int priority = 348;
        String version = "";
        double current = 0.8195973038673401;
        double power = 0.8911446928977966;
        double voltage = 0.9449220299720764;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6CConfigurationEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6CConfigurationEvent));
        Vacuum_CIP6CConfigurationEvent item_ = (Vacuum_CIP6CConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_IConfigurationEvent() throws Exception {
        int priority = 395;
        String version = "";
        double warnHi = 0.2162773609161377;
        double warnLo = 0.08686792850494385;
        double limitHi = 0.5236115455627441;
        double limitLo = 0.11660957336425781;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6_IConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_IConfigurationEvent));
        Vacuum_CIP6_IConfigurationEvent item_ = (Vacuum_CIP6_IConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VConfigurationEvent() throws Exception {
        int priority = 704;
        String version = "j";
        double warnHi = 0.7412078380584717;
        double warnLo = 0.33134692907333374;
        double limitHi = 0.14201372861862183;
        double limitLo = 0.4168702960014343;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6_VConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VConfigurationEvent));
        Vacuum_CIP6_VConfigurationEvent item_ = (Vacuum_CIP6_VConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacConfigurationEvent() throws Exception {
        int priority = 962;
        String version = "u";
        double warnHi = 0.6418435573577881;
        double warnLo = 0.3457095f;
        double limitHi = 0.5672187209129333;
        double limitLo = 0.45319098234176636;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacConfigurationEvent));
        Vacuum_CryoVacConfigurationEvent item_ = (Vacuum_CryoVacConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacGaugeConfigurationEvent() throws Exception {
        int priority = 51;
        String version = "";
        int busAddr = 641;
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGaugeConfigurationEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGaugeConfigurationEvent));
        Vacuum_CryoVacGaugeConfigurationEvent item_ = (Vacuum_CryoVacGaugeConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_ForelineVacConfigurationEvent() throws Exception {
        int priority = 559;
        String version = "";
        double warnHi = 0.9075458645820618;
        double warnLo = 0.839673f;
        double limitHi = 0.905518651008606;
        double limitLo = 0.07874f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_ForelineVacConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacConfigurationEvent));
        Vacuum_ForelineVacConfigurationEvent item_ = (Vacuum_ForelineVacConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacGaugeConfigurationEvent() throws Exception {
        int priority = 96;
        String version = "o";
        int busAddr = 143;
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_ForelineVacGaugeConfigurationEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacGaugeConfigurationEvent));
        Vacuum_ForelineVacGaugeConfigurationEvent item_ = (Vacuum_ForelineVacGaugeConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_HeartbeatConfigurationEvent() throws Exception {
        int priority = 306;
        String version = "k";
        long taskPeriodMillis = 379L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HeartbeatConfigurationEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HeartbeatConfigurationEvent));
        Vacuum_HeartbeatConfigurationEvent item_ = (Vacuum_HeartbeatConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Hex1VacConfigurationEvent() throws Exception {
        int priority = 370;
        String version = "";
        double warnHi = 0.8275190591812134;
        double warnLo = 0.10685265064239502;
        double limitHi = 0.3429415225982666;
        double limitLo = 0.4982871413230896;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex1VacConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacConfigurationEvent));
        Vacuum_Hex1VacConfigurationEvent item_ = (Vacuum_Hex1VacConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacGaugeConfigurationEvent() throws Exception {
        int priority = 734;
        String version = "";
        int busAddr = 257;
        String devcId = "q";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex1VacGaugeConfigurationEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacGaugeConfigurationEvent));
        Vacuum_Hex1VacGaugeConfigurationEvent item_ = (Vacuum_Hex1VacGaugeConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_Hex2VacConfigurationEvent() throws Exception {
        int priority = 336;
        String version = "g";
        double warnHi = 0.9268537759780884;
        double warnLo = 0.1965157389640808;
        double limitHi = 0.7145811319351196;
        double limitLo = 0.01391238f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex2VacConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacConfigurationEvent));
        Vacuum_Hex2VacConfigurationEvent item_ = (Vacuum_Hex2VacConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacGaugeConfigurationEvent() throws Exception {
        int priority = 192;
        String version = "b";
        int busAddr = 350;
        String devcId = "w";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex2VacGaugeConfigurationEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacGaugeConfigurationEvent));
        Vacuum_Hex2VacGaugeConfigurationEvent item_ = (Vacuum_Hex2VacGaugeConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_IonPumpsConfigurationEvent() throws Exception {
        int priority = 90;
        String version = "";
        String ipAddr = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumpsConfigurationEvent(priority, version, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsConfigurationEvent));
        Vacuum_IonPumpsConfigurationEvent item_ = (Vacuum_IonPumpsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_Monitor_checkConfigurationEvent() throws Exception {
        int priority = 161;
        String version = "";
        long taskPeriodMillis = 536L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_checkConfigurationEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_checkConfigurationEvent));
        Vacuum_Monitor_checkConfigurationEvent item_ = (Vacuum_Monitor_checkConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Monitor_publishConfigurationEvent() throws Exception {
        int priority = 823;
        String version = "";
        long taskPeriodMillis = 92L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_publishConfigurationEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_publishConfigurationEvent));
        Vacuum_Monitor_publishConfigurationEvent item_ = (Vacuum_Monitor_publishConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Monitor_updateConfigurationEvent() throws Exception {
        int priority = 398;
        String version = "";
        long taskPeriodMillis = 320L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_updateConfigurationEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_updateConfigurationEvent));
        Vacuum_Monitor_updateConfigurationEvent item_ = (Vacuum_Monitor_updateConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_RuntimeInfoConfigurationEvent() throws Exception {
        int priority = 640;
        String version = "f";
        long taskPeriodMillis = 966L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_RuntimeInfoConfigurationEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RuntimeInfoConfigurationEvent));
        Vacuum_RuntimeInfoConfigurationEvent item_ = (Vacuum_RuntimeInfoConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_SchedulersConfigurationEvent() throws Exception {
        int priority = 874;
        String version = "r";
        int default_nTasks = 165;
        int default_nThreads = 81;
        int monitor_update_publish_scheduler_nTasks = 585;
        int monitor_update_publish_scheduler_nThreads = 234;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_SchedulersConfigurationEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_SchedulersConfigurationEvent));
        Vacuum_SchedulersConfigurationEvent item_ = (Vacuum_SchedulersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)default_nTasks, (long)item_.getDefault_nTasks());
        Assert.assertEquals((long)default_nThreads, (long)item_.getDefault_nThreads());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nTasks, (long)item_.getMonitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nThreads, (long)item_.getMonitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentConfigurationEvent() throws Exception {
        int priority = 416;
        String version = "";
        double warnHi = 0.976365327835083;
        double warnLo = 0.8153178691864014;
        double limitHi = 0.8984127044677734;
        double limitLo = 0.6960815787315369;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboCurrentConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentConfigurationEvent));
        Vacuum_TurboCurrentConfigurationEvent item_ = (Vacuum_TurboCurrentConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerConfigurationEvent() throws Exception {
        int priority = 973;
        String version = "";
        double warnHi = 0.7142266035079956;
        double warnLo = 0.7880451679229736;
        double limitHi = 0.015918374061584473;
        double limitLo = 0.668856680393219;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPowerConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerConfigurationEvent));
        Vacuum_TurboPowerConfigurationEvent item_ = (Vacuum_TurboPowerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpConfigurationEvent() throws Exception {
        int priority = 952;
        String version = "x";
        boolean activeStopMode = false;
        String devcId = "";
        boolean interlockType = false;
        boolean lowSpeedMode = true;
        boolean model304 = false;
        boolean softStartMode = false;
        boolean ventValveByCmnd = true;
        boolean waterCooling = true;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPumpConfigurationEvent(priority, version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpConfigurationEvent));
        Vacuum_TurboPumpConfigurationEvent item_ = (Vacuum_TurboPumpConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempConfigurationEvent() throws Exception {
        int priority = 497;
        String version = "";
        double warnHi = 0.3076918125152588;
        double warnLo = 0.4680584f;
        double limitHi = 0.26654428243637085;
        double limitLo = 0.6449887752532959;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPumpTempConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempConfigurationEvent));
        Vacuum_TurboPumpTempConfigurationEvent item_ = (Vacuum_TurboPumpTempConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedConfigurationEvent() throws Exception {
        int priority = 2;
        String version = "";
        double warnHi = 0.6237963438034058;
        double warnLo = 0.3165757f;
        double limitHi = 0.7989621162414551;
        double limitLo = 0.37942272424697876;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboSpeedConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedConfigurationEvent));
        Vacuum_TurboSpeedConfigurationEvent item_ = (Vacuum_TurboSpeedConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacConfigurationEvent() throws Exception {
        int priority = 847;
        String version = "o";
        double warnHi = 0.12413114309310913;
        double warnLo = 0.5145398378372192;
        double limitHi = 0.6842864155769348;
        double limitLo = 0.16013747453689575;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVacConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacConfigurationEvent));
        Vacuum_TurboVacConfigurationEvent item_ = (Vacuum_TurboVacConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacGaugeConfigurationEvent() throws Exception {
        int priority = 919;
        String version = "";
        int busAddr = 479;
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVacGaugeConfigurationEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacGaugeConfigurationEvent));
        Vacuum_TurboVacGaugeConfigurationEvent item_ = (Vacuum_TurboVacGaugeConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageConfigurationEvent() throws Exception {
        int priority = 41;
        String version = "r";
        double warnHi = 0.44293713569641113;
        double warnLo = 0.71945720911026;
        double limitHi = 0.1985260248184204;
        double limitLo = 0.16791987419128418;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVoltageConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageConfigurationEvent));
        Vacuum_TurboVoltageConfigurationEvent item_ = (Vacuum_TurboVoltageConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VacPlutoConfigurationEvent() throws Exception {
        int priority = 0;
        String version = "";
        String node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPlutoConfigurationEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPlutoConfigurationEvent));
        Vacuum_VacPlutoConfigurationEvent item_ = (Vacuum_VacPlutoConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_Vacuum_stateConfigurationEvent() throws Exception {
        int priority = 286;
        String version = "h";
        long taskPeriodMillis = 233L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Vacuum_stateConfigurationEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Vacuum_stateConfigurationEvent));
        Vacuum_Vacuum_stateConfigurationEvent item_ = (Vacuum_Vacuum_stateConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 652;
        String version = "u";
        int schedulers_default_nTasks = 81;
        int schedulers_default_nThreads = 792;
        int schedulers_monitor_update_publish_scheduler_nTasks = 844;
        int schedulers_monitor_update_publish_scheduler_nThreads = 546;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasksConfigurationEvent));
        Daq_monitor_PeriodicTasksConfigurationEvent item_ = (Daq_monitor_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 672;
        String version = "g";
        long agentmonitorservice_taskPeriodMillis = 902L;
        long heartbeat_taskPeriodMillis = 435L;
        long monitor_check_taskPeriodMillis = 705L;
        long monitor_publish_taskPeriodMillis = 676L;
        long monitor_update_taskPeriodMillis = 318L;
        long publishstats_taskPeriodMillis = 791L;
        long purgedaq_taskPeriodMillis = 489L;
        long runtimeinfo_taskPeriodMillis = 442L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersConfigurationEvent));
        Daq_monitor_PeriodicTasks_timersConfigurationEvent item_ = (Daq_monitor_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsConfigurationEvent() throws Exception {
        int priority = 960;
        String version = "";
        int minDiffAlertWarning = 552;
        int minDiffLogWarning = 444;
        String sumDriverChecks = "s";
        String sumDriverStats = "";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "";
        String sumRdsChecks = "k";
        String sumRdsStats = "b";
        String sumRmsChecks = "z";
        String sumRmsStats = "s";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsConfigurationEvent(priority, version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsConfigurationEvent));
        Daq_monitor_Stats_StatisticsConfigurationEvent item_ = (Daq_monitor_Stats_StatisticsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_buildConfigurationEvent() throws Exception {
        int priority = 716;
        String version = "";
        boolean enablePeriodicPublication = true;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_buildConfigurationEvent(priority, version, enablePeriodicPublication));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_buildConfigurationEvent));
        Daq_monitor_Stats_buildConfigurationEvent item_ = (Daq_monitor_Stats_buildConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreConfigurationEvent() throws Exception {
        int priority = 766;
        String version = "m";
        String daqPartition = "k";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreConfigurationEvent(priority, version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreConfigurationEvent));
        Daq_monitor_StoreConfigurationEvent item_ = (Daq_monitor_StoreConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsConfigurationEvent() throws Exception {
        int priority = 704;
        String version = "";
        double capacity_warnHi = 0.03296506404876709;
        double capacity_warnLo = 0.11091488599777222;
        double capacity_limitHi = 0.9360492825508118;
        double capacity_limitLo = 0.2538573145866394;
        double freefraction_warnHi = 0.29517167806625366;
        double freefraction_warnLo = 0.29587697982788086;
        double freefraction_limitHi = 0.902417778968811;
        double freefraction_limitLo = 0.5484668612480164;
        double freespace_warnHi = 0.831264f;
        double freespace_warnLo = 0.25001317262649536;
        double freespace_limitHi = 0.4648313f;
        double freespace_limitLo = 0.4221401810646057;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsConfigurationEvent(priority, version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsConfigurationEvent));
        Daq_monitor_Store_LimitsConfigurationEvent item_ = (Daq_monitor_Store_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreConfigurationEvent() throws Exception {
        int priority = 400;
        String version = "";
        String daqFolder = "l";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.3118906021118164;
        double purgeThreshold = 0.6383227705955505;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreConfigurationEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreConfigurationEvent));
        Daq_monitor_Store_StoreConfigurationEvent item_ = (Daq_monitor_Store_StoreConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdConfigurationEvent() throws Exception {
        int priority = 432;
        String version = "g";
        String location = "";
        String manSerNum = "";
        String name = "w";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdConfigurationEvent(priority, version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdConfigurationEvent));
        Focal_plane_Ccd_HardwareIdConfigurationEvent item_ = (Focal_plane_Ccd_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsConfigurationEvent() throws Exception {
        int priority = 17;
        String version = "e";
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1475611905);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-619235455);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)1132516689);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-1942212881);
        String location = "h";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)201, (int)1458219185);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)201, (int)-401491656);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)201, (int)1022593917);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)201, (int)302081961);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-30174827);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)201, (int)154797139);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-328236423);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)201, (int)2006568180);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-960749533);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-1051804867);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)201, (int)1295919654);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-565329147);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-1016667673);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)1272282662);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)497843221);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)1858683655);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)201, (int)146500562);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)201, (int)1473953308);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)201, (int)1327074844);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)201, (int)375706589);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsConfigurationEvent(priority, version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsConfigurationEvent));
        Focal_plane_Ccd_LimitsConfigurationEvent item_ = (Focal_plane_Ccd_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsConfigurationEvent() throws Exception {
        int priority = 922;
        String version = "i";
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsConfigurationEvent(priority, version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsConfigurationEvent));
        Focal_plane_Ccd_RaftsConfigurationEvent item_ = (Focal_plane_Ccd_RaftsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseServiceConfigurationEvent() throws Exception {
        int priority = 278;
        String version = "y";
        String dbURL = "a";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseServiceConfigurationEvent(priority, version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseServiceConfigurationEvent));
        Focal_plane_ImageDatabaseServiceConfigurationEvent item_ = (Focal_plane_ImageDatabaseServiceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameServiceConfigurationEvent() throws Exception {
        int priority = 616;
        String version = "";
        String controller = "";
        String dbURL = "f";
        String offset = "k";
        String source = "";
        String timeZoneId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameServiceConfigurationEvent(priority, version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameServiceConfigurationEvent));
        Focal_plane_ImageNameServiceConfigurationEvent item_ = (Focal_plane_ImageNameServiceConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentConfigurationEvent() throws Exception {
        int priority = 171;
        String version = "";
        String instrument = "";
        String telescope = "l";
        String testStand = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(priority, version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentConfigurationEvent));
        Focal_plane_InstrumentConfig_InstrumentConfigurationEvent item_ = (Focal_plane_InstrumentConfig_InstrumentConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasksConfigurationEvent() throws Exception {
        int priority = 754;
        String version = "";
        int schedulers_default_nTasks = 796;
        int schedulers_default_nThreads = 443;
        int schedulers_monitor_check_scheduler_nTasks = 258;
        int schedulers_monitor_check_scheduler_nThreads = 198;
        int schedulers_monitor_update_publish_scheduler_nTasks = 861;
        int schedulers_monitor_update_publish_scheduler_nThreads = 975;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasksConfigurationEvent));
        Focal_plane_PeriodicTasksConfigurationEvent item_ = (Focal_plane_PeriodicTasksConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 783;
        String version = "";
        long agentmonitorservice_taskPeriodMillis = 696L;
        long heartbeat_taskPeriodMillis = 184L;
        long monitor_publish_taskPeriodMillis = 936L;
        long monitor_update_taskPeriodMillis = 519L;
        long runtimeinfo_taskPeriodMillis = 231L;
        long tempcontrol_R00_taskPeriodMillis = 827L;
        long tempcontrol_R01_taskPeriodMillis = 148L;
        long tempcontrol_R02_taskPeriodMillis = 352L;
        long tempcontrol_R03_taskPeriodMillis = 498L;
        long tempcontrol_R04_taskPeriodMillis = 118L;
        long tempcontrol_R10_taskPeriodMillis = 41L;
        long tempcontrol_R11_taskPeriodMillis = 7L;
        long tempcontrol_R12_taskPeriodMillis = 295L;
        long tempcontrol_R13_taskPeriodMillis = 109L;
        long tempcontrol_R14_taskPeriodMillis = 668L;
        long tempcontrol_R20_taskPeriodMillis = 381L;
        long tempcontrol_R21_taskPeriodMillis = 334L;
        long tempcontrol_R22_taskPeriodMillis = 135L;
        long tempcontrol_R23_taskPeriodMillis = 421L;
        long tempcontrol_R24_taskPeriodMillis = 766L;
        long tempcontrol_R30_taskPeriodMillis = 256L;
        long tempcontrol_R31_taskPeriodMillis = 474L;
        long tempcontrol_R32_taskPeriodMillis = 814L;
        long tempcontrol_R33_taskPeriodMillis = 187L;
        long tempcontrol_R34_taskPeriodMillis = 828L;
        long tempcontrol_R40_taskPeriodMillis = 898L;
        long tempcontrol_R41_taskPeriodMillis = 857L;
        long tempcontrol_R42_taskPeriodMillis = 203L;
        long tempcontrol_R43_taskPeriodMillis = 285L;
        long tempcontrol_R44_taskPeriodMillis = 41L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis, tempcontrol_R01_taskPeriodMillis, tempcontrol_R02_taskPeriodMillis, tempcontrol_R03_taskPeriodMillis, tempcontrol_R04_taskPeriodMillis, tempcontrol_R10_taskPeriodMillis, tempcontrol_R11_taskPeriodMillis, tempcontrol_R12_taskPeriodMillis, tempcontrol_R13_taskPeriodMillis, tempcontrol_R14_taskPeriodMillis, tempcontrol_R20_taskPeriodMillis, tempcontrol_R21_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis, tempcontrol_R23_taskPeriodMillis, tempcontrol_R24_taskPeriodMillis, tempcontrol_R30_taskPeriodMillis, tempcontrol_R31_taskPeriodMillis, tempcontrol_R32_taskPeriodMillis, tempcontrol_R33_taskPeriodMillis, tempcontrol_R34_taskPeriodMillis, tempcontrol_R40_taskPeriodMillis, tempcontrol_R41_taskPeriodMillis, tempcontrol_R42_taskPeriodMillis, tempcontrol_R43_taskPeriodMillis, tempcontrol_R44_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersConfigurationEvent));
        Focal_plane_PeriodicTasks_timersConfigurationEvent item_ = (Focal_plane_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R01_taskPeriodMillis, (long)item_.getTempcontrol_R01_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R02_taskPeriodMillis, (long)item_.getTempcontrol_R02_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R03_taskPeriodMillis, (long)item_.getTempcontrol_R03_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R04_taskPeriodMillis, (long)item_.getTempcontrol_R04_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R10_taskPeriodMillis, (long)item_.getTempcontrol_R10_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R11_taskPeriodMillis, (long)item_.getTempcontrol_R11_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R12_taskPeriodMillis, (long)item_.getTempcontrol_R12_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R13_taskPeriodMillis, (long)item_.getTempcontrol_R13_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R14_taskPeriodMillis, (long)item_.getTempcontrol_R14_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R20_taskPeriodMillis, (long)item_.getTempcontrol_R20_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R21_taskPeriodMillis, (long)item_.getTempcontrol_R21_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R23_taskPeriodMillis, (long)item_.getTempcontrol_R23_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R24_taskPeriodMillis, (long)item_.getTempcontrol_R24_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R30_taskPeriodMillis, (long)item_.getTempcontrol_R30_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R31_taskPeriodMillis, (long)item_.getTempcontrol_R31_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R32_taskPeriodMillis, (long)item_.getTempcontrol_R32_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R33_taskPeriodMillis, (long)item_.getTempcontrol_R33_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R34_taskPeriodMillis, (long)item_.getTempcontrol_R34_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R40_taskPeriodMillis, (long)item_.getTempcontrol_R40_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R41_taskPeriodMillis, (long)item_.getTempcontrol_R41_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R42_taskPeriodMillis, (long)item_.getTempcontrol_R42_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R43_taskPeriodMillis, (long)item_.getTempcontrol_R43_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R44_taskPeriodMillis, (long)item_.getTempcontrol_R44_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdConfigurationEvent() throws Exception {
        int priority = 203;
        String version = "t";
        String location = "r";
        String name = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdConfigurationEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdConfigurationEvent));
        Focal_plane_Raft_HardwareIdConfigurationEvent item_ = (Focal_plane_Raft_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlConfigurationEvent() throws Exception {
        int priority = 957;
        String version = "";
        String location = "";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)25, (int)575665825);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)25, (int)1922857723);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)25, (int)-273814358);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)25, (int)142636193);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)25, (int)-1276219746);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)25, (int)-286721487);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)25, (int)-1250949407);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)25, (int)-478378614);
        String tempcontrol_rebs = "s";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)25, (int)-1537337908);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)25, (int)-131609750);
        String tempcontrol_tempChans = "z";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)25, (int)-1005758474);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlConfigurationEvent(priority, version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlConfigurationEvent));
        Focal_plane_Raft_RaftTempControlConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusConfigurationEvent() throws Exception {
        int priority = 980;
        String version = "";
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{false, false, false, true, false, true, true, true, false, false, false, false, true, true, false, false, false, true, false, false, true, true, true, true, true};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusConfigurationEvent(priority, version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusConfigurationEvent));
        Focal_plane_Raft_RaftTempControlStatusConfigurationEvent item_ = (Focal_plane_Raft_RaftTempControlStatusConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsConfigurationEvent() throws Exception {
        int priority = 111;
        String version = "";
        double warnHi = 0.928351f;
        double warnLo = 0.4740072f;
        double limitHi = 0.7023636102676392;
        double limitLo = 0.47487103939056396;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsConfigurationEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsConfigurationEvent));
        Focal_plane_RebTotalPower_LimitsConfigurationEvent item_ = (Focal_plane_RebTotalPower_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdConfigurationEvent() throws Exception {
        int priority = 202;
        String version = "f";
        String location = "";
        String name = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdConfigurationEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdConfigurationEvent));
        Focal_plane_Reb_HardwareIdConfigurationEvent item_ = (Focal_plane_Reb_HardwareIdConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsConfigurationEvent() throws Exception {
        int priority = 512;
        String version = "";
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)71, (int)-47730374);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)71, (int)-506649428);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)71, (int)870978886);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)71, (int)1094681586);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)71, (int)1898131769);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)71, (int)1090731741);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)71, (int)1833800473);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)71, (int)150323003);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)320431678);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)1852268328);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)85528280);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1102684652);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-798215887);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)291052111);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)1322929016);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-981978741);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1330223634);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)470571601);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-841346615);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1885213323);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)1929879630);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1992521164);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)1147661035);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-992122299);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)318520405);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)335559173);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-905802240);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1363296388);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1490773608);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)56917789);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-877857502);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)968862558);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1578223945);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2144889691);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1437905513);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)71, (int)1788514586);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1206685014);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)71, (int)2053013595);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)71, (int)820131651);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1591691987);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)71, (int)631970686);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)71, (int)-817250411);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1153038499);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)71, (int)482106375);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)71, (int)2140394004);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1364803718);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-194051483);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1219645715);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)71, (int)192553989);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)71, (int)1033907135);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)71, (int)495108437);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-116946143);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1004071431);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-16956936);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-755878378);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1322803391);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1703116999);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1480905233);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-150011083);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-163022100);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-173864319);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-402289837);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)71, (int)1886526166);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1949141845);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-120131558);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1303269382);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1581721368);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)71, (int)49973773);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1719516456);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-74814473);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)71, (int)918359194);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1022583277);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)71, (int)402701376);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)71, (int)1254314993);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)71, (int)482321676);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)71, (int)1487976910);
        String location = "m";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)71, (int)776271177);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-995019962);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)71, (int)697428564);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)71, (int)846232046);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)71, (int)1943847797);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-356393314);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1494667164);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-844322945);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)2013239106);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)103198069);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)1328205970);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-643254289);
        double[] pclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1624112040);
        double[] pclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)521822350);
        double[] pclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)506522901);
        double[] pclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1504520835);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1776965675);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1229181006);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)827257678);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)223099509);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)667665249);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)978684884);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1180590821);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1868875271);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)-529876539);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1472766090);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)172831595);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)326013188);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1835708147);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)71, (int)713060684);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-490412523);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1658209196);
        double[] rg1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1497888717);
        double[] rg1_warnLo = TestHelper.generateDoubleArray((int)71, (int)756337950);
        double[] rg1_limitHi = TestHelper.generateDoubleArray((int)71, (int)2072988901);
        double[] rg1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2015982938);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-117670319);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1507305742);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-961976840);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)71, (int)1870501135);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1783386345);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)71, (int)1513942121);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)71, (int)887792969);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1863507351);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)71, (int)2031843969);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)71, (int)-409552791);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)71, (int)1826744715);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)71, (int)-657114909);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1807767098);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1345297660);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)71, (int)248277560);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-974292004);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-593605335);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1503864969);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1849363735);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1899043159);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)71, (int)743987566);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)71, (int)-303545634);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1185218584);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1486360682);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)71, (int)734668936);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1402002566);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)71, (int)765890563);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1755228373);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)71, (int)928960918);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1778618628);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1947811934);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)71, (int)-613800017);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1708356592);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)71, (int)123635493);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)71, (int)1342603548);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)71, (int)1439017201);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1273523651);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)2092373926);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)1363412549);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)1994280005);
        double[] sclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1276917480);
        double[] sclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)13463173);
        double[] sclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)451718987);
        double[] sclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-515058483);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)-331865518);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)1278370064);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)652776130);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)2113093625);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)1869998698);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)316592637);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)938341116);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)549401168);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)71, (int)320698939);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)71, (int)-911084078);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1511639906);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)71, (int)1839197295);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1161755813);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-597362297);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)361966191);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)1266158674);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-336249265);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1916801175);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1776498061);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)278109906);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)71, (int)85441244);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)71, (int)842409536);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1726177224);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1515240082);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)71, (int)-991704740);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)71, (int)-825340236);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)71, (int)1564315758);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)71, (int)438662221);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)71, (int)-156787708);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1247997204);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1243889219);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)71, (int)-912061309);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)71, (int)2079393570);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1268841353);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)71, (int)880393939);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)71, (int)34920083);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1200798902);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)71, (int)724108399);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2002967109);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1819041484);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)71, (int)1371938517);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1493923365);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)71, (int)-252282763);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)71, (int)1680672856);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)71, (int)1855738507);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)71, (int)-935368107);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)71, (int)719119042);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)71, (int)-758962071);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsConfigurationEvent(priority, version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclk1_warnHi, pclk1_warnLo, pclk1_limitHi, pclk1_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rg1_warnHi, rg1_warnLo, rg1_limitHi, rg1_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclk1_warnHi, sclk1_warnLo, sclk1_limitHi, sclk1_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsConfigurationEvent));
        Focal_plane_Reb_LimitsConfigurationEvent item_ = (Focal_plane_Reb_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnHi, (double[])item_.getPclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnLo, (double[])item_.getPclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitHi, (double[])item_.getPclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitLo, (double[])item_.getPclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnHi, (double[])item_.getRg1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnLo, (double[])item_.getRg1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitHi, (double[])item_.getRg1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitLo, (double[])item_.getRg1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnHi, (double[])item_.getSclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnLo, (double[])item_.getSclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitHi, (double[])item_.getSclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitLo, (double[])item_.getSclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsConfigurationEvent() throws Exception {
        int priority = 599;
        String version = "d";
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)71, (int)-1222786603);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)71, (int)2146634971);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)71, (int)1477513035);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)71, (int)1858024884);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)71, (int)904630476);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)71, (int)340414747);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)71, (int)1168774426);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)71, (int)1815508141);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)71, (int)-2045059768);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)71, (int)-1716401921);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)71, (int)-892020317);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)71, (int)436697162);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)71, (int)-2049145011);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)71, (int)-32488997);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)71, (int)673641400);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)71, (int)-5417901);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)71, (int)2031424369);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)71, (int)-283233294);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)71, (int)2087328724);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)71, (int)59205519);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)71, (int)624130975);
        boolean[] disableRTDHardwareCheck = new boolean[]{false, true, false, false, false, false, true, true, false, false, true, false, false, false, true, false, false, true, false, true, false, false, false, false, false, true, false, true, false, false, false, true, false, true, false, false, false, true, false, true, false, true, true, true, true, true, true, true, true, false, false, true, true, false, true, false, false, false, true, true, true, true, false, true, true, false, true, false, false, true, false};
        String location = "v";
        long[] serialNum = TestHelper.generateLongArray((int)71, (int)-2086039219);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsConfigurationEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsConfigurationEvent));
        Focal_plane_Reb_RaftsConfigurationEvent item_ = (Focal_plane_Reb_RaftsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsConfigurationEvent() throws Exception {
        int priority = 866;
        String version = "x";
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)71, (int)1552167000);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)71, (int)-1850466181);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)71, (int)503023364);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)71, (int)1841264303);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)71, (int)1803928495);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)71, (int)870830841);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)71, (int)150894011);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)71, (int)-2135768399);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)71, (int)-1058496508);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)71, (int)1333480094);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)71, (int)-159510796);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)71, (int)1487692314);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)71, (int)1284645356);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)71, (int)-1021791104);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)71, (int)-1844399748);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)71, (int)-1846330839);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)71, (int)1946459658);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)71, (int)1426853779);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)71, (int)523689683);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)71, (int)1616373853);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)71, (int)-776097940);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)71, (int)-452434626);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)71, (int)1536772655);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)71, (int)-187777241);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-557807564);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)71, (int)1873770283);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-43363386);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)71, (int)2086689249);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)71, (int)-1595791238);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)71, (int)277214814);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)71, (int)273511501);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)71, (int)788200446);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-244867215);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)71, (int)-2029283447);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-666149701);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)71, (int)-2036453503);
        String location = "m";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsConfigurationEvent(priority, version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsConfigurationEvent));
        Focal_plane_Reb_RaftsLimitsConfigurationEvent item_ = (Focal_plane_Reb_RaftsLimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerConfigurationEvent() throws Exception {
        int priority = 385;
        String version = "";
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)71, (int)-1421096878);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-221279324);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)71, (int)279604959);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-2041764593);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1594183144);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)71, (int)-1258849587);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)71, (int)-2004607681);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)71, (int)-222612607);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1645159538);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)71, (int)1954003400);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-824276443);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)71, (int)1011753935);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)463363028);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)957741140);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)71, (int)-641722085);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1742735191);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)71, (int)-551451010);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)31746581);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1310346694);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)71, (int)-1932788486);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-992519834);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)71, (int)-1692198998);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)369183085);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-754763176);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)71, (int)663731105);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)71, (int)-1430475521);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)71, (int)-526443333);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-506661827);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)71, (int)1443606241);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)1469143262);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)71, (int)375648708);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)1371003482);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)769831705);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)71, (int)1742180812);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)75518533);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)71, (int)-914679241);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-521650074);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1895574510);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)71, (int)-809038289);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1458576744);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)71, (int)-1470858451);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1859801831);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1692960358);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)71, (int)-500336898);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)71, (int)2004977280);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)71, (int)565815291);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)1657888709);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)71, (int)-1939950528);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-1052698427);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)71, (int)198504277);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)1880285797);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1652816741);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)71, (int)484718233);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1787344994);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)71, (int)-1646556897);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1094718250);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)893990897);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)71, (int)-5715131);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)71, (int)1047168334);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)71, (int)-2098693751);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)71, (int)2061663106);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)71, (int)503430309);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)71, (int)-1034863911);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)71, (int)1010083023);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-1008047005);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)71, (int)130067583);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)-478021520);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)1642455866);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)71, (int)1914682863);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)194485814);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)71, (int)1062957077);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)119081991);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)363790831);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)71, (int)1615248878);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)71, (int)-439045155);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)71, (int)1380520082);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)71, (int)2006777081);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1612437733);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)71, (int)-1142572297);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)71, (int)1661024012);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)71, (int)-1118348014);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-2017394604);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2038123795);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)71, (int)2037107818);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)424130202);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)71, (int)274989165);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)978362666);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1933213280);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)71, (int)-2086737047);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)671002819);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)71, (int)-1232725829);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)1233971214);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-246587340);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)71, (int)1482885209);
        double[] maxStep = TestHelper.generateDoubleArray((int)71, (int)-506937030);
        double[] minTol = TestHelper.generateDoubleArray((int)71, (int)-1082219467);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)71, (int)-539230429);
        double[] odiAmin = TestHelper.generateDoubleArray((int)71, (int)317383846);
        double[] odiQmax = TestHelper.generateDoubleArray((int)71, (int)1480005056);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerConfigurationEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerConfigurationEvent));
        Focal_plane_Reb_RaftsPowerConfigurationEvent item_ = (Focal_plane_Reb_RaftsPowerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersConfigurationEvent() throws Exception {
        int priority = 301;
        String version = "b";
        String location = "";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)386865374);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1269427024);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)104904402);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-138898637);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1811681082);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1415463780);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)399231864);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-627723039);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1486088851);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2069271943);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)959620261);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1995809808);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1058622478);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)2111581107);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1120371541);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersConfigurationEvent(priority, version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersConfigurationEvent));
        Focal_plane_Reb_timersConfigurationEvent item_ = (Focal_plane_Reb_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsConfigurationEvent() throws Exception {
        int priority = 615;
        String version = "";
        double[] i_warnHi = TestHelper.generateDoubleArray((int)3024, (int)-629903390);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)3024, (int)-790553270);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)3024, (int)1243602036);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)3024, (int)-835780481);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsConfigurationEvent(priority, version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsConfigurationEvent));
        Focal_plane_Segment_LimitsConfigurationEvent item_ = (Focal_plane_Segment_LimitsConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQConfigurationEvent() throws Exception {
        int priority = 118;
        String version = "";
        String daqFolder = "f";
        String daqPartition = "s";
        boolean emulatedDAQ = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQConfigurationEvent(priority, version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQConfigurationEvent));
        Focal_plane_SequencerConfig_DAQConfigurationEvent item_ = (Focal_plane_SequencerConfig_DAQConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerConfigurationEvent() throws Exception {
        int priority = 6;
        String version = "u";
        String clearCountParameter = "";
        String clearMain = "e";
        String idleFlushMain = "a";
        long idleFlushTimeout = 811L;
        String integrateMain = "b";
        String metaDataRegisters = "w";
        int overCols = 266;
        int overRows = 922;
        int postCols = 852;
        int postRows = 718;
        int preCols = 117;
        int preRows = 683;
        String pseudoReadMain = "";
        int readCols = 676;
        int readCols2 = 969;
        String readMain = "";
        int readRows = 805;
        String rowShiftForwardMain = "x";
        String rowShiftReverseMain = "f";
        boolean scanMode = true;
        String sequencer = "";
        String sequencerChecksums = "i";
        String shiftCountParameter = "";
        boolean stepAfterIntegrate = false;
        int transparentMode = 97;
        int underCols = 190;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerConfigurationEvent(priority, version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerConfigurationEvent));
        Focal_plane_SequencerConfig_SequencerConfigurationEvent item_ = (Focal_plane_SequencerConfig_SequencerConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationConfigurationEvent() throws Exception {
        int priority = 635;
        String version = "d";
        String webHooks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationConfigurationEvent(priority, version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationConfigurationEvent));
        Focal_plane_WebHooksConfig_VisualizationConfigurationEvent item_ = (Focal_plane_WebHooksConfig_VisualizationConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_DAQConfigurationEvent() throws Exception {
        int priority = 411;
        String version = "p";
        int imagehandlingconfig_badPixelAlarmLevel = 851;
        int imagehandlingconfig_badPixelHighThreshold = 418;
        int imagehandlingconfig_badPixelLowThreshold = 0;
        int imagehandlingconfig_badPixelWarningLevel = 442;
        boolean imagehandlingconfig_checkForBadPixels = false;
        String imagehandlingconfig_daqFolder = "k";
        String imagehandlingconfig_daqPartition = "";
        int imagehandlingconfig_daqThreads = 104;
        String imagehandlingconfig_locations = "f";
        boolean imagehandlingconfig_useStreaming = false;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_DAQConfigurationEvent(priority, version, imagehandlingconfig_badPixelAlarmLevel, imagehandlingconfig_badPixelHighThreshold, imagehandlingconfig_badPixelLowThreshold, imagehandlingconfig_badPixelWarningLevel, imagehandlingconfig_checkForBadPixels, imagehandlingconfig_daqFolder, imagehandlingconfig_daqPartition, imagehandlingconfig_daqThreads, imagehandlingconfig_locations, imagehandlingconfig_useStreaming));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_DAQConfigurationEvent));
        Image_handling_ImageHandler_DAQConfigurationEvent item_ = (Image_handling_ImageHandler_DAQConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)imagehandlingconfig_badPixelAlarmLevel, (long)item_.getImagehandlingconfig_badPixelAlarmLevel());
        Assert.assertEquals((long)imagehandlingconfig_badPixelHighThreshold, (long)item_.getImagehandlingconfig_badPixelHighThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelLowThreshold, (long)item_.getImagehandlingconfig_badPixelLowThreshold());
        Assert.assertEquals((long)imagehandlingconfig_badPixelWarningLevel, (long)item_.getImagehandlingconfig_badPixelWarningLevel());
        Assert.assertEquals((Object)imagehandlingconfig_checkForBadPixels, (Object)item_.isImagehandlingconfig_checkForBadPixels());
        Assert.assertEquals((Object)imagehandlingconfig_daqFolder, (Object)item_.getImagehandlingconfig_daqFolder());
        Assert.assertEquals((Object)imagehandlingconfig_daqPartition, (Object)item_.getImagehandlingconfig_daqPartition());
        Assert.assertEquals((long)imagehandlingconfig_daqThreads, (long)item_.getImagehandlingconfig_daqThreads());
        Assert.assertEquals((Object)imagehandlingconfig_locations, (Object)item_.getImagehandlingconfig_locations());
        Assert.assertEquals((Object)imagehandlingconfig_useStreaming, (Object)item_.isImagehandlingconfig_useStreaming());
    }

    @Test
    public void sendReceiveImage_handling_ImageHandler_FitsHandlingConfigurationEvent() throws Exception {
        int priority = 394;
        String version = "x";
        boolean imagehandlingconfig_FITSAutoSave = false;
        String imagehandlingconfig_FITSDirectoryPattern = "n";
        String imagehandlingconfig_FITSFilePattern = "q";
        String imagehandlingconfig_FITSRootDirectory = "";
        String imagehandlingconfig_subsystemsToClearOnNewRun = "";
        String imagehandlingconfig_tempFileRelativeLocation = "";
        boolean imagehandlingconfig_useTempFile = true;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_ImageHandler_FitsHandlingConfigurationEvent(priority, version, imagehandlingconfig_FITSAutoSave, imagehandlingconfig_FITSDirectoryPattern, imagehandlingconfig_FITSFilePattern, imagehandlingconfig_FITSRootDirectory, imagehandlingconfig_subsystemsToClearOnNewRun, imagehandlingconfig_tempFileRelativeLocation, imagehandlingconfig_useTempFile));
        Assert.assertTrue((boolean)(item instanceof Image_handling_ImageHandler_FitsHandlingConfigurationEvent));
        Image_handling_ImageHandler_FitsHandlingConfigurationEvent item_ = (Image_handling_ImageHandler_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)imagehandlingconfig_FITSAutoSave, (Object)item_.isImagehandlingconfig_FITSAutoSave());
        Assert.assertEquals((Object)imagehandlingconfig_FITSDirectoryPattern, (Object)item_.getImagehandlingconfig_FITSDirectoryPattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSFilePattern, (Object)item_.getImagehandlingconfig_FITSFilePattern());
        Assert.assertEquals((Object)imagehandlingconfig_FITSRootDirectory, (Object)item_.getImagehandlingconfig_FITSRootDirectory());
        Assert.assertEquals((Object)imagehandlingconfig_subsystemsToClearOnNewRun, (Object)item_.getImagehandlingconfig_subsystemsToClearOnNewRun());
        Assert.assertEquals((Object)imagehandlingconfig_tempFileRelativeLocation, (Object)item_.getImagehandlingconfig_tempFileRelativeLocation());
        Assert.assertEquals((Object)imagehandlingconfig_useTempFile, (Object)item_.isImagehandlingconfig_useTempFile());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_GeneralConfigurationEvent() throws Exception {
        int priority = 39;
        String version = "u";
        int schedulers_default_nTasks = 756;
        int schedulers_default_nThreads = 876;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_GeneralConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_GeneralConfigurationEvent));
        Image_handling_PeriodicTasks_GeneralConfigurationEvent item_ = (Image_handling_PeriodicTasks_GeneralConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
    }

    @Test
    public void sendReceiveImage_handling_PeriodicTasks_timersConfigurationEvent() throws Exception {
        int priority = 722;
        String version = "a";
        long agentmonitorservice_taskPeriodMillis = 79L;
        long heartbeat_taskPeriodMillis = 94L;
        long runtimeinfo_taskPeriodMillis = 5L;
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Image_handling_PeriodicTasks_timersConfigurationEvent));
        Image_handling_PeriodicTasks_timersConfigurationEvent item_ = (Image_handling_PeriodicTasks_timersConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveImage_handling_Reb_FitsHandlingConfigurationEvent() throws Exception {
        int priority = 960;
        String version = "d";
        boolean[] enabled = new boolean[]{true, false, false, false, true, false, true, true};
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_Reb_FitsHandlingConfigurationEvent(priority, version, enabled, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_Reb_FitsHandlingConfigurationEvent));
        Image_handling_Reb_FitsHandlingConfigurationEvent item_ = (Image_handling_Reb_FitsHandlingConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertArrayEquals((boolean[])enabled, (boolean[])item_.getEnabled());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveImage_handling_Reb_GeneralConfigurationEvent() throws Exception {
        int priority = 640;
        String version = "";
        String fitsservice_headerFilesList = "";
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Image_handling_Reb_GeneralConfigurationEvent(priority, version, fitsservice_headerFilesList, location));
        Assert.assertTrue((boolean)(item instanceof Image_handling_Reb_GeneralConfigurationEvent));
        Image_handling_Reb_GeneralConfigurationEvent item_ = (Image_handling_Reb_GeneralConfigurationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)fitsservice_headerFilesList, (Object)item_.getFitsservice_headerFilesList());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        int priority = 89;
        String configurations = "x";
        String version = "";
        String url = "h";
        String schemaVersion = "k";
        String otherInfo = "q";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(priority, configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        int priority = 816;
        String overrides = "";
        String version = "";
        String url = "u";
        String schemaVersion = "n";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(priority, overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 222;
        int errorCode = 799;
        String errorReport = "c";
        String traceback = "j";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 66;
        int level = 975;
        String subsystem = "";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 556;
        String name = "b";
        int level = 427;
        String message = "d";
        String traceback = "";
        String filePath = "r";
        String functionName = "b";
        int lineNumber = 876;
        int process = 179;
        double timestamp = 0.32494717836380005;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 738;
        int mode = 56;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 323;
        String salVersion = "cukmhfkvqaejcefntg";
        String xmlVersion = "yiuhnfalzpqqkkokltcreubjixkmrcvzdjlmmfgbwnevlxwssmvgkyhmaeggadfjzvqlkwikumaqtksyswzlqqqooynumkuqwwprxbzvezlwjuviqrlfocphdwqyejsuflbcjgnkcfem";
        String openSpliceVersion = "bnyzebsgnkguovfsplmrhvdcpmujhsxzjkhissokivbkevvoxddtcbiyqyrgzbcfehvwltkvlivlbxtjpslkksssatroxaolzavvjexzmouasrxkpjvpmbbgukwyimiadxlgdgdicvqsreonexfodgqgkbpykefiileskcykhdjrotmfigvujadcrzgvoiqdaesjnsdplbhrqgseliyccihubuyshqwn";
        String cscVersion = "iuomvcitfmduyusijaprpcoegzmvmyaocdadgpicpclfqpgwoiytcrbrkmq";
        String subsystemVersions = "q";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 18;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 226;
        String authorizedUsers = "n";
        String nonAuthorizedCSCs = "p";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        int priority = 726;
        String url = "xumpyhdyudjydvbdhaibcxbrcrmcfhemofgplyrebraetrypwaetlowzwqquauavtgpkeuhoehwozvoctducaqdvobavcugenkgqglonkbfouescjbxkkybdfuuptvxksbvgnbsiuhdsnzpdmzljkvsaqcygsqgdhjqqzhwvseqgvwzodpukmxdxtrvxykoitncbfltp";
        String generator = "vbruchlykdvtdnxzywnyzcarxdricfmvqdfxagydtmtcnbfszoovjyoyhxfardtorzjhfwovmfgefkqkacdjpstuilniuaqghvjtksxydxzkaqnkqzpvmpgqtoajroqmocauqlopckkmjjpwqoisklcwcdpgpylwfbyskkldumvjhehpcqrzgwgqzhicdrkzsaqatbhsygidkssmwwmrbwlqgjrsjvlotdnzffgo";
        float version = 0.9983982f;
        int byteSize = 38;
        String checkSum = "guglxnwdwvibmmocuqlputnfiqbfeqesohrwgpyudkptbubxbfyhebbtwehtqrithhhauzvvfpsbvegscukgebowbuzjcpfkqgrrndhoxndkiylfurmltxpmsfqwmijjhxqgvdvpoqjmohgbcxfjvqtdkeodohevreqn";
        String mimeType = "qxesdroxtffuhsngohdkcjtylhtxyshepvxetpowqdffnjeddrybspkvquxcezqjcraxumzlmgocmtlewjxtfsqjuuieknuupzleenvonikmtdgqgujbqwcwwlgiheeprkweuunrhwamatkkzsozxmkuatoqvfoyszhfhcsslaqnzerchmdxjv";
        String id = "xlyiwocwxqqawfwdxzzrzxegwtgxbnpzicsjeoelaovmfecldxfrlbwzlxkmnzdnhkqlflpacnixyvprybymwfolrfrnctfdmuswffndpntazhceggbuqmscqjxwcwkarnniantlrsdaczyenxinnfqkaxyhybzpcqbzlicgwbudutrgtybdiuhkdvywrross";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(priority, url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

