package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_SchedulersConfigurationEvent extends CameraEvent {
  private final String version;

  private final int default_nTasks;

  private final int default_nThreads;

  private final int monitor_update_publish_scheduler_nTasks;

  private final int monitor_update_publish_scheduler_nThreads;

  public Vacuum_SchedulersConfigurationEvent(int priority, String version, int default_nTasks,
      int default_nThreads, int monitor_update_publish_scheduler_nTasks,
      int monitor_update_publish_scheduler_nThreads) {
    super (priority);
    this.version = version;
    this.default_nTasks = default_nTasks;
    this.default_nThreads = default_nThreads;
    this.monitor_update_publish_scheduler_nTasks = monitor_update_publish_scheduler_nTasks;
    this.monitor_update_publish_scheduler_nThreads = monitor_update_publish_scheduler_nThreads;
  }

  public String getVersion() {
    return version;
  }

  public int getDefault_nTasks() {
    return default_nTasks;
  }

  public int getDefault_nThreads() {
    return default_nThreads;
  }

  public int getMonitor_update_publish_scheduler_nTasks() {
    return monitor_update_publish_scheduler_nTasks;
  }

  public int getMonitor_update_publish_scheduler_nThreads() {
    return monitor_update_publish_scheduler_nThreads;
  }

  @Override
  public String toString() {
    return "Vacuum_SchedulersConfigurationEvent{" + "version=" + version +
        ", default_nTasks=" + default_nTasks +", default_nThreads=" + default_nThreads +
        ", monitor_update_publish_scheduler_nTasks=" + monitor_update_publish_scheduler_nTasks +
        ", monitor_update_publish_scheduler_nThreads=" + monitor_update_publish_scheduler_nThreads +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private int default_nTasks;

    private int default_nThreads;

    private int monitor_update_publish_scheduler_nTasks;

    private int monitor_update_publish_scheduler_nThreads;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder default_nTasks(int default_nTasks) {
      this.default_nTasks = default_nTasks;
      return this;
    }

    public Builder default_nThreads(int default_nThreads) {
      this.default_nThreads = default_nThreads;
      return this;
    }

    public Builder monitor_update_publish_scheduler_nTasks(
        int monitor_update_publish_scheduler_nTasks) {
      this.monitor_update_publish_scheduler_nTasks = monitor_update_publish_scheduler_nTasks;
      return this;
    }

    public Builder monitor_update_publish_scheduler_nThreads(
        int monitor_update_publish_scheduler_nThreads) {
      this.monitor_update_publish_scheduler_nThreads = monitor_update_publish_scheduler_nThreads;
      return this;
    }

    public Vacuum_SchedulersConfigurationEvent build() {
      return new Vacuum_SchedulersConfigurationEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads);
    }
  }
}
