package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_CIP3CConfigurationEvent extends CameraEvent {
  private final String version;

  private final double current;

  private final double power;

  private final double voltage;

  public Vacuum_CIP3CConfigurationEvent(int priority, String version, double current, double power,
      double voltage) {
    super (priority);
    this.version = version;
    this.current = current;
    this.power = power;
    this.voltage = voltage;
  }

  public String getVersion() {
    return version;
  }

  public double getCurrent() {
    return current;
  }

  public double getPower() {
    return power;
  }

  public double getVoltage() {
    return voltage;
  }

  @Override
  public String toString() {
    return "Vacuum_CIP3CConfigurationEvent{" + "version=" + version +", current=" + current +
        ", power=" + power +", voltage=" + voltage +"}";
  }
}
