package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Refrig_PeriodicTasksConfigurationEvent extends CameraEvent {
  private final String version;

  private final int schedulers_default_nTasks;

  private final int schedulers_default_nThreads;

  private final int schedulers_monitor_update_publish_scheduler_nTasks;

  private final int schedulers_monitor_update_publish_scheduler_nThreads;

  public Refrig_PeriodicTasksConfigurationEvent(int priority, String version,
      int schedulers_default_nTasks, int schedulers_default_nThreads,
      int schedulers_monitor_update_publish_scheduler_nTasks,
      int schedulers_monitor_update_publish_scheduler_nThreads) {
    super (priority);
    this.version = version;
    this.schedulers_default_nTasks = schedulers_default_nTasks;
    this.schedulers_default_nThreads = schedulers_default_nThreads;
    this.schedulers_monitor_update_publish_scheduler_nTasks = schedulers_monitor_update_publish_scheduler_nTasks;
    this.schedulers_monitor_update_publish_scheduler_nThreads = schedulers_monitor_update_publish_scheduler_nThreads;
  }

  public String getVersion() {
    return version;
  }

  public int getSchedulers_default_nTasks() {
    return schedulers_default_nTasks;
  }

  public int getSchedulers_default_nThreads() {
    return schedulers_default_nThreads;
  }

  public int getSchedulers_monitor_update_publish_scheduler_nTasks() {
    return schedulers_monitor_update_publish_scheduler_nTasks;
  }

  public int getSchedulers_monitor_update_publish_scheduler_nThreads() {
    return schedulers_monitor_update_publish_scheduler_nThreads;
  }

  @Override
  public String toString() {
    return "Refrig_PeriodicTasksConfigurationEvent{" + "version=" + version +
        ", schedulers_default_nTasks=" + schedulers_default_nTasks +
        ", schedulers_default_nThreads=" + schedulers_default_nThreads +
        ", schedulers_monitor_update_publish_scheduler_nTasks=" + schedulers_monitor_update_publish_scheduler_nTasks +
        ", schedulers_monitor_update_publish_scheduler_nThreads=" + schedulers_monitor_update_publish_scheduler_nThreads +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private int schedulers_default_nTasks;

    private int schedulers_default_nThreads;

    private int schedulers_monitor_update_publish_scheduler_nTasks;

    private int schedulers_monitor_update_publish_scheduler_nThreads;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder schedulers_default_nTasks(int schedulers_default_nTasks) {
      this.schedulers_default_nTasks = schedulers_default_nTasks;
      return this;
    }

    public Builder schedulers_default_nThreads(int schedulers_default_nThreads) {
      this.schedulers_default_nThreads = schedulers_default_nThreads;
      return this;
    }

    public Builder schedulers_monitor_update_publish_scheduler_nTasks(
        int schedulers_monitor_update_publish_scheduler_nTasks) {
      this.schedulers_monitor_update_publish_scheduler_nTasks = schedulers_monitor_update_publish_scheduler_nTasks;
      return this;
    }

    public Builder schedulers_monitor_update_publish_scheduler_nThreads(
        int schedulers_monitor_update_publish_scheduler_nThreads) {
      this.schedulers_monitor_update_publish_scheduler_nThreads = schedulers_monitor_update_publish_scheduler_nThreads;
      return this;
    }

    public Refrig_PeriodicTasksConfigurationEvent build() {
      return new Refrig_PeriodicTasksConfigurationEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads);
    }
  }
}
