package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class RebpowerConfigurationEvent extends CameraEvent {
  private final String version;

  private final long powerOffSleepMillis;

  public RebpowerConfigurationEvent(int priority, String version, long powerOffSleepMillis) {
    super (priority);
    this.version = version;
    this.powerOffSleepMillis = powerOffSleepMillis;
  }

  public String getVersion() {
    return version;
  }

  public long getPowerOffSleepMillis() {
    return powerOffSleepMillis;
  }

  @Override
  public String toString() {
    return "RebpowerConfigurationEvent{" + "version=" + version +
        ", powerOffSleepMillis=" + powerOffSleepMillis +"}";
  }
}
