package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Hex_PeriodicTasks_timersConfigurationEvent extends CameraEvent {
  private final String version;

  private final long agentmonitorservice_taskPeriodMillis;

  private final long heartbeat_taskPeriodMillis;

  private final long monitor_check_taskPeriodMillis;

  private final long monitor_publish_taskPeriodMillis;

  private final long monitor_update_taskPeriodMillis;

  private final long runtimeinfo_taskPeriodMillis;

  public Hex_PeriodicTasks_timersConfigurationEvent(int priority, String version,
      long agentmonitorservice_taskPeriodMillis, long heartbeat_taskPeriodMillis,
      long monitor_check_taskPeriodMillis, long monitor_publish_taskPeriodMillis,
      long monitor_update_taskPeriodMillis, long runtimeinfo_taskPeriodMillis) {
    super (priority);
    this.version = version;
    this.agentmonitorservice_taskPeriodMillis = agentmonitorservice_taskPeriodMillis;
    this.heartbeat_taskPeriodMillis = heartbeat_taskPeriodMillis;
    this.monitor_check_taskPeriodMillis = monitor_check_taskPeriodMillis;
    this.monitor_publish_taskPeriodMillis = monitor_publish_taskPeriodMillis;
    this.monitor_update_taskPeriodMillis = monitor_update_taskPeriodMillis;
    this.runtimeinfo_taskPeriodMillis = runtimeinfo_taskPeriodMillis;
  }

  public String getVersion() {
    return version;
  }

  public long getAgentmonitorservice_taskPeriodMillis() {
    return agentmonitorservice_taskPeriodMillis;
  }

  public long getHeartbeat_taskPeriodMillis() {
    return heartbeat_taskPeriodMillis;
  }

  public long getMonitor_check_taskPeriodMillis() {
    return monitor_check_taskPeriodMillis;
  }

  public long getMonitor_publish_taskPeriodMillis() {
    return monitor_publish_taskPeriodMillis;
  }

  public long getMonitor_update_taskPeriodMillis() {
    return monitor_update_taskPeriodMillis;
  }

  public long getRuntimeinfo_taskPeriodMillis() {
    return runtimeinfo_taskPeriodMillis;
  }

  @Override
  public String toString() {
    return "Hex_PeriodicTasks_timersConfigurationEvent{" + "version=" + version +
        ", agentmonitorservice_taskPeriodMillis=" + agentmonitorservice_taskPeriodMillis +
        ", heartbeat_taskPeriodMillis=" + heartbeat_taskPeriodMillis +
        ", monitor_check_taskPeriodMillis=" + monitor_check_taskPeriodMillis +
        ", monitor_publish_taskPeriodMillis=" + monitor_publish_taskPeriodMillis +
        ", monitor_update_taskPeriodMillis=" + monitor_update_taskPeriodMillis +
        ", runtimeinfo_taskPeriodMillis=" + runtimeinfo_taskPeriodMillis +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private long agentmonitorservice_taskPeriodMillis;

    private long heartbeat_taskPeriodMillis;

    private long monitor_check_taskPeriodMillis;

    private long monitor_publish_taskPeriodMillis;

    private long monitor_update_taskPeriodMillis;

    private long runtimeinfo_taskPeriodMillis;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder agentmonitorservice_taskPeriodMillis(long agentmonitorservice_taskPeriodMillis) {
      this.agentmonitorservice_taskPeriodMillis = agentmonitorservice_taskPeriodMillis;
      return this;
    }

    public Builder heartbeat_taskPeriodMillis(long heartbeat_taskPeriodMillis) {
      this.heartbeat_taskPeriodMillis = heartbeat_taskPeriodMillis;
      return this;
    }

    public Builder monitor_check_taskPeriodMillis(long monitor_check_taskPeriodMillis) {
      this.monitor_check_taskPeriodMillis = monitor_check_taskPeriodMillis;
      return this;
    }

    public Builder monitor_publish_taskPeriodMillis(long monitor_publish_taskPeriodMillis) {
      this.monitor_publish_taskPeriodMillis = monitor_publish_taskPeriodMillis;
      return this;
    }

    public Builder monitor_update_taskPeriodMillis(long monitor_update_taskPeriodMillis) {
      this.monitor_update_taskPeriodMillis = monitor_update_taskPeriodMillis;
      return this;
    }

    public Builder runtimeinfo_taskPeriodMillis(long runtimeinfo_taskPeriodMillis) {
      this.runtimeinfo_taskPeriodMillis = runtimeinfo_taskPeriodMillis;
      return this;
    }

    public Hex_PeriodicTasks_timersConfigurationEvent build() {
      return new Hex_PeriodicTasks_timersConfigurationEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis);
    }
  }
}
