package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class HexConfigurationEvent extends CameraEvent {
  private final String version;

  private final double rtnToEvapOffset;

  public HexConfigurationEvent(int priority, String version, double rtnToEvapOffset) {
    super (priority);
    this.version = version;
    this.rtnToEvapOffset = rtnToEvapOffset;
  }

  public String getVersion() {
    return version;
  }

  public double getRtnToEvapOffset() {
    return rtnToEvapOffset;
  }

  @Override
  public String toString() {
    return "HexConfigurationEvent{" + "version=" + version +", rtnToEvapOffset=" + rtnToEvapOffset +
        "}";
  }
}
