package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_InstrumentConfig_InstrumentConfigurationEvent extends CameraEvent {
  private final String version;

  private final String instrument;

  private final String telescope;

  private final String testStand;

  public Focal_plane_InstrumentConfig_InstrumentConfigurationEvent(int priority, String version,
      String instrument, String telescope, String testStand) {
    super (priority);
    this.version = version;
    this.instrument = instrument;
    this.telescope = telescope;
    this.testStand = testStand;
  }

  public String getVersion() {
    return version;
  }

  public String getInstrument() {
    return instrument;
  }

  public String getTelescope() {
    return telescope;
  }

  public String getTestStand() {
    return testStand;
  }

  @Override
  public String toString() {
    return "Focal_plane_InstrumentConfig_InstrumentConfigurationEvent{" + "version=" + version +
        ", instrument=" + instrument +", telescope=" + telescope +", testStand=" + testStand +"}";
  }
}
