package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_ImageNameServiceConfigurationEvent extends CameraEvent {
  private final String version;

  private final String controller;

  private final String dbURL;

  private final String offset;

  private final String source;

  private final String timeZoneId;

  public Focal_plane_ImageNameServiceConfigurationEvent(int priority, String version,
      String controller, String dbURL, String offset, String source, String timeZoneId) {
    super (priority);
    this.version = version;
    this.controller = controller;
    this.dbURL = dbURL;
    this.offset = offset;
    this.source = source;
    this.timeZoneId = timeZoneId;
  }

  public String getVersion() {
    return version;
  }

  public String getController() {
    return controller;
  }

  public String getDbURL() {
    return dbURL;
  }

  public String getOffset() {
    return offset;
  }

  public String getSource() {
    return source;
  }

  public String getTimeZoneId() {
    return timeZoneId;
  }

  @Override
  public String toString() {
    return "Focal_plane_ImageNameServiceConfigurationEvent{" + "version=" + version +
        ", controller=" + controller +", dbURL=" + dbURL +", offset=" + offset +
        ", source=" + source +", timeZoneId=" + timeZoneId +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private String controller;

    private String dbURL;

    private String offset;

    private String source;

    private String timeZoneId;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder controller(String controller) {
      this.controller = controller;
      return this;
    }

    public Builder dbURL(String dbURL) {
      this.dbURL = dbURL;
      return this;
    }

    public Builder offset(String offset) {
      this.offset = offset;
      return this;
    }

    public Builder source(String source) {
      this.source = source;
      return this;
    }

    public Builder timeZoneId(String timeZoneId) {
      this.timeZoneId = timeZoneId;
      return this;
    }

    public Focal_plane_ImageNameServiceConfigurationEvent build() {
      return new Focal_plane_ImageNameServiceConfigurationEvent(priority, version, controller, dbURL, offset, source, timeZoneId);
    }
  }
}
