package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_Ccd_LimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double[] gdv_warnHi;

  private final double[] gdv_warnLo;

  private final double[] gdv_limitHi;

  private final double[] gdv_limitLo;

  private final String location;

  private final double[] odi_warnHi;

  private final double[] odi_warnLo;

  private final double[] odi_limitHi;

  private final double[] odi_limitLo;

  private final double[] odv_warnHi;

  private final double[] odv_warnLo;

  private final double[] odv_limitHi;

  private final double[] odv_limitLo;

  private final double[] ogv_warnHi;

  private final double[] ogv_warnLo;

  private final double[] ogv_limitHi;

  private final double[] ogv_limitLo;

  private final double[] rdv_warnHi;

  private final double[] rdv_warnLo;

  private final double[] rdv_limitHi;

  private final double[] rdv_limitLo;

  private final double[] temp_warnHi;

  private final double[] temp_warnLo;

  private final double[] temp_limitHi;

  private final double[] temp_limitLo;

  public Focal_plane_Ccd_LimitsConfigurationEvent(int priority, String version, double[] gdv_warnHi,
      double[] gdv_warnLo, double[] gdv_limitHi, double[] gdv_limitLo, String location,
      double[] odi_warnHi, double[] odi_warnLo, double[] odi_limitHi, double[] odi_limitLo,
      double[] odv_warnHi, double[] odv_warnLo, double[] odv_limitHi, double[] odv_limitLo,
      double[] ogv_warnHi, double[] ogv_warnLo, double[] ogv_limitHi, double[] ogv_limitLo,
      double[] rdv_warnHi, double[] rdv_warnLo, double[] rdv_limitHi, double[] rdv_limitLo,
      double[] temp_warnHi, double[] temp_warnLo, double[] temp_limitHi, double[] temp_limitLo) {
    super (priority);
    this.version = version;
    this.gdv_warnHi = gdv_warnHi;
    this.gdv_warnLo = gdv_warnLo;
    this.gdv_limitHi = gdv_limitHi;
    this.gdv_limitLo = gdv_limitLo;
    this.location = location;
    this.odi_warnHi = odi_warnHi;
    this.odi_warnLo = odi_warnLo;
    this.odi_limitHi = odi_limitHi;
    this.odi_limitLo = odi_limitLo;
    this.odv_warnHi = odv_warnHi;
    this.odv_warnLo = odv_warnLo;
    this.odv_limitHi = odv_limitHi;
    this.odv_limitLo = odv_limitLo;
    this.ogv_warnHi = ogv_warnHi;
    this.ogv_warnLo = ogv_warnLo;
    this.ogv_limitHi = ogv_limitHi;
    this.ogv_limitLo = ogv_limitLo;
    this.rdv_warnHi = rdv_warnHi;
    this.rdv_warnLo = rdv_warnLo;
    this.rdv_limitHi = rdv_limitHi;
    this.rdv_limitLo = rdv_limitLo;
    this.temp_warnHi = temp_warnHi;
    this.temp_warnLo = temp_warnLo;
    this.temp_limitHi = temp_limitHi;
    this.temp_limitLo = temp_limitLo;
  }

  public String getVersion() {
    return version;
  }

  public double[] getGdv_warnHi() {
    return gdv_warnHi;
  }

  public double[] getGdv_warnLo() {
    return gdv_warnLo;
  }

  public double[] getGdv_limitHi() {
    return gdv_limitHi;
  }

  public double[] getGdv_limitLo() {
    return gdv_limitLo;
  }

  public String getLocation() {
    return location;
  }

  public double[] getOdi_warnHi() {
    return odi_warnHi;
  }

  public double[] getOdi_warnLo() {
    return odi_warnLo;
  }

  public double[] getOdi_limitHi() {
    return odi_limitHi;
  }

  public double[] getOdi_limitLo() {
    return odi_limitLo;
  }

  public double[] getOdv_warnHi() {
    return odv_warnHi;
  }

  public double[] getOdv_warnLo() {
    return odv_warnLo;
  }

  public double[] getOdv_limitHi() {
    return odv_limitHi;
  }

  public double[] getOdv_limitLo() {
    return odv_limitLo;
  }

  public double[] getOgv_warnHi() {
    return ogv_warnHi;
  }

  public double[] getOgv_warnLo() {
    return ogv_warnLo;
  }

  public double[] getOgv_limitHi() {
    return ogv_limitHi;
  }

  public double[] getOgv_limitLo() {
    return ogv_limitLo;
  }

  public double[] getRdv_warnHi() {
    return rdv_warnHi;
  }

  public double[] getRdv_warnLo() {
    return rdv_warnLo;
  }

  public double[] getRdv_limitHi() {
    return rdv_limitHi;
  }

  public double[] getRdv_limitLo() {
    return rdv_limitLo;
  }

  public double[] getTemp_warnHi() {
    return temp_warnHi;
  }

  public double[] getTemp_warnLo() {
    return temp_warnLo;
  }

  public double[] getTemp_limitHi() {
    return temp_limitHi;
  }

  public double[] getTemp_limitLo() {
    return temp_limitLo;
  }

  @Override
  public String toString() {
    return "Focal_plane_Ccd_LimitsConfigurationEvent{" + "version=" + version +
        ", gdv_warnHi=" + Arrays.toString(gdv_warnHi) +
        ", gdv_warnLo=" + Arrays.toString(gdv_warnLo) +
        ", gdv_limitHi=" + Arrays.toString(gdv_limitHi) +
        ", gdv_limitLo=" + Arrays.toString(gdv_limitLo) +", location=" + location +
        ", odi_warnHi=" + Arrays.toString(odi_warnHi) +
        ", odi_warnLo=" + Arrays.toString(odi_warnLo) +
        ", odi_limitHi=" + Arrays.toString(odi_limitHi) +
        ", odi_limitLo=" + Arrays.toString(odi_limitLo) +
        ", odv_warnHi=" + Arrays.toString(odv_warnHi) +
        ", odv_warnLo=" + Arrays.toString(odv_warnLo) +
        ", odv_limitHi=" + Arrays.toString(odv_limitHi) +
        ", odv_limitLo=" + Arrays.toString(odv_limitLo) +
        ", ogv_warnHi=" + Arrays.toString(ogv_warnHi) +
        ", ogv_warnLo=" + Arrays.toString(ogv_warnLo) +
        ", ogv_limitHi=" + Arrays.toString(ogv_limitHi) +
        ", ogv_limitLo=" + Arrays.toString(ogv_limitLo) +
        ", rdv_warnHi=" + Arrays.toString(rdv_warnHi) +
        ", rdv_warnLo=" + Arrays.toString(rdv_warnLo) +
        ", rdv_limitHi=" + Arrays.toString(rdv_limitHi) +
        ", rdv_limitLo=" + Arrays.toString(rdv_limitLo) +
        ", temp_warnHi=" + Arrays.toString(temp_warnHi) +
        ", temp_warnLo=" + Arrays.toString(temp_warnLo) +
        ", temp_limitHi=" + Arrays.toString(temp_limitHi) +
        ", temp_limitLo=" + Arrays.toString(temp_limitLo) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private double[] gdv_warnHi;

    private double[] gdv_warnLo;

    private double[] gdv_limitHi;

    private double[] gdv_limitLo;

    private String location;

    private double[] odi_warnHi;

    private double[] odi_warnLo;

    private double[] odi_limitHi;

    private double[] odi_limitLo;

    private double[] odv_warnHi;

    private double[] odv_warnLo;

    private double[] odv_limitHi;

    private double[] odv_limitLo;

    private double[] ogv_warnHi;

    private double[] ogv_warnLo;

    private double[] ogv_limitHi;

    private double[] ogv_limitLo;

    private double[] rdv_warnHi;

    private double[] rdv_warnLo;

    private double[] rdv_limitHi;

    private double[] rdv_limitLo;

    private double[] temp_warnHi;

    private double[] temp_warnLo;

    private double[] temp_limitHi;

    private double[] temp_limitLo;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder gdv_warnHi(double[] gdv_warnHi) {
      this.gdv_warnHi = gdv_warnHi;
      return this;
    }

    public Builder gdv_warnLo(double[] gdv_warnLo) {
      this.gdv_warnLo = gdv_warnLo;
      return this;
    }

    public Builder gdv_limitHi(double[] gdv_limitHi) {
      this.gdv_limitHi = gdv_limitHi;
      return this;
    }

    public Builder gdv_limitLo(double[] gdv_limitLo) {
      this.gdv_limitLo = gdv_limitLo;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Builder odi_warnHi(double[] odi_warnHi) {
      this.odi_warnHi = odi_warnHi;
      return this;
    }

    public Builder odi_warnLo(double[] odi_warnLo) {
      this.odi_warnLo = odi_warnLo;
      return this;
    }

    public Builder odi_limitHi(double[] odi_limitHi) {
      this.odi_limitHi = odi_limitHi;
      return this;
    }

    public Builder odi_limitLo(double[] odi_limitLo) {
      this.odi_limitLo = odi_limitLo;
      return this;
    }

    public Builder odv_warnHi(double[] odv_warnHi) {
      this.odv_warnHi = odv_warnHi;
      return this;
    }

    public Builder odv_warnLo(double[] odv_warnLo) {
      this.odv_warnLo = odv_warnLo;
      return this;
    }

    public Builder odv_limitHi(double[] odv_limitHi) {
      this.odv_limitHi = odv_limitHi;
      return this;
    }

    public Builder odv_limitLo(double[] odv_limitLo) {
      this.odv_limitLo = odv_limitLo;
      return this;
    }

    public Builder ogv_warnHi(double[] ogv_warnHi) {
      this.ogv_warnHi = ogv_warnHi;
      return this;
    }

    public Builder ogv_warnLo(double[] ogv_warnLo) {
      this.ogv_warnLo = ogv_warnLo;
      return this;
    }

    public Builder ogv_limitHi(double[] ogv_limitHi) {
      this.ogv_limitHi = ogv_limitHi;
      return this;
    }

    public Builder ogv_limitLo(double[] ogv_limitLo) {
      this.ogv_limitLo = ogv_limitLo;
      return this;
    }

    public Builder rdv_warnHi(double[] rdv_warnHi) {
      this.rdv_warnHi = rdv_warnHi;
      return this;
    }

    public Builder rdv_warnLo(double[] rdv_warnLo) {
      this.rdv_warnLo = rdv_warnLo;
      return this;
    }

    public Builder rdv_limitHi(double[] rdv_limitHi) {
      this.rdv_limitHi = rdv_limitHi;
      return this;
    }

    public Builder rdv_limitLo(double[] rdv_limitLo) {
      this.rdv_limitLo = rdv_limitLo;
      return this;
    }

    public Builder temp_warnHi(double[] temp_warnHi) {
      this.temp_warnHi = temp_warnHi;
      return this;
    }

    public Builder temp_warnLo(double[] temp_warnLo) {
      this.temp_warnLo = temp_warnLo;
      return this;
    }

    public Builder temp_limitHi(double[] temp_limitHi) {
      this.temp_limitHi = temp_limitHi;
      return this;
    }

    public Builder temp_limitLo(double[] temp_limitLo) {
      this.temp_limitLo = temp_limitLo;
      return this;
    }

    public Focal_plane_Ccd_LimitsConfigurationEvent build() {
      return new Focal_plane_Ccd_LimitsConfigurationEvent(priority, version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo);
    }
  }
}
