package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Daq_monitor_Store_LimitsConfigurationEvent extends CameraEvent {
  private final String version;

  private final double capacity_warnHi;

  private final double capacity_warnLo;

  private final double capacity_limitHi;

  private final double capacity_limitLo;

  private final double freefraction_warnHi;

  private final double freefraction_warnLo;

  private final double freefraction_limitHi;

  private final double freefraction_limitLo;

  private final double freespace_warnHi;

  private final double freespace_warnLo;

  private final double freespace_limitHi;

  private final double freespace_limitLo;

  public Daq_monitor_Store_LimitsConfigurationEvent(int priority, String version,
      double capacity_warnHi, double capacity_warnLo, double capacity_limitHi,
      double capacity_limitLo, double freefraction_warnHi, double freefraction_warnLo,
      double freefraction_limitHi, double freefraction_limitLo, double freespace_warnHi,
      double freespace_warnLo, double freespace_limitHi, double freespace_limitLo) {
    super (priority);
    this.version = version;
    this.capacity_warnHi = capacity_warnHi;
    this.capacity_warnLo = capacity_warnLo;
    this.capacity_limitHi = capacity_limitHi;
    this.capacity_limitLo = capacity_limitLo;
    this.freefraction_warnHi = freefraction_warnHi;
    this.freefraction_warnLo = freefraction_warnLo;
    this.freefraction_limitHi = freefraction_limitHi;
    this.freefraction_limitLo = freefraction_limitLo;
    this.freespace_warnHi = freespace_warnHi;
    this.freespace_warnLo = freespace_warnLo;
    this.freespace_limitHi = freespace_limitHi;
    this.freespace_limitLo = freespace_limitLo;
  }

  public String getVersion() {
    return version;
  }

  public double getCapacity_warnHi() {
    return capacity_warnHi;
  }

  public double getCapacity_warnLo() {
    return capacity_warnLo;
  }

  public double getCapacity_limitHi() {
    return capacity_limitHi;
  }

  public double getCapacity_limitLo() {
    return capacity_limitLo;
  }

  public double getFreefraction_warnHi() {
    return freefraction_warnHi;
  }

  public double getFreefraction_warnLo() {
    return freefraction_warnLo;
  }

  public double getFreefraction_limitHi() {
    return freefraction_limitHi;
  }

  public double getFreefraction_limitLo() {
    return freefraction_limitLo;
  }

  public double getFreespace_warnHi() {
    return freespace_warnHi;
  }

  public double getFreespace_warnLo() {
    return freespace_warnLo;
  }

  public double getFreespace_limitHi() {
    return freespace_limitHi;
  }

  public double getFreespace_limitLo() {
    return freespace_limitLo;
  }

  @Override
  public String toString() {
    return "Daq_monitor_Store_LimitsConfigurationEvent{" + "version=" + version +
        ", capacity_warnHi=" + capacity_warnHi +", capacity_warnLo=" + capacity_warnLo +
        ", capacity_limitHi=" + capacity_limitHi +", capacity_limitLo=" + capacity_limitLo +
        ", freefraction_warnHi=" + freefraction_warnHi +
        ", freefraction_warnLo=" + freefraction_warnLo +
        ", freefraction_limitHi=" + freefraction_limitHi +
        ", freefraction_limitLo=" + freefraction_limitLo +", freespace_warnHi=" + freespace_warnHi +
        ", freespace_warnLo=" + freespace_warnLo +", freespace_limitHi=" + freespace_limitHi +
        ", freespace_limitLo=" + freespace_limitLo +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String version;

    private double capacity_warnHi;

    private double capacity_warnLo;

    private double capacity_limitHi;

    private double capacity_limitLo;

    private double freefraction_warnHi;

    private double freefraction_warnLo;

    private double freefraction_limitHi;

    private double freefraction_limitLo;

    private double freespace_warnHi;

    private double freespace_warnLo;

    private double freespace_limitHi;

    private double freespace_limitLo;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder capacity_warnHi(double capacity_warnHi) {
      this.capacity_warnHi = capacity_warnHi;
      return this;
    }

    public Builder capacity_warnLo(double capacity_warnLo) {
      this.capacity_warnLo = capacity_warnLo;
      return this;
    }

    public Builder capacity_limitHi(double capacity_limitHi) {
      this.capacity_limitHi = capacity_limitHi;
      return this;
    }

    public Builder capacity_limitLo(double capacity_limitLo) {
      this.capacity_limitLo = capacity_limitLo;
      return this;
    }

    public Builder freefraction_warnHi(double freefraction_warnHi) {
      this.freefraction_warnHi = freefraction_warnHi;
      return this;
    }

    public Builder freefraction_warnLo(double freefraction_warnLo) {
      this.freefraction_warnLo = freefraction_warnLo;
      return this;
    }

    public Builder freefraction_limitHi(double freefraction_limitHi) {
      this.freefraction_limitHi = freefraction_limitHi;
      return this;
    }

    public Builder freefraction_limitLo(double freefraction_limitLo) {
      this.freefraction_limitLo = freefraction_limitLo;
      return this;
    }

    public Builder freespace_warnHi(double freespace_warnHi) {
      this.freespace_warnHi = freespace_warnHi;
      return this;
    }

    public Builder freespace_warnLo(double freespace_warnLo) {
      this.freespace_warnLo = freespace_warnLo;
      return this;
    }

    public Builder freespace_limitHi(double freespace_limitHi) {
      this.freespace_limitHi = freespace_limitHi;
      return this;
    }

    public Builder freespace_limitLo(double freespace_limitLo) {
      this.freespace_limitLo = freespace_limitLo;
      return this;
    }

    public Daq_monitor_Store_LimitsConfigurationEvent build() {
      return new Daq_monitor_Store_LimitsConfigurationEvent(priority, version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo);
    }
  }
}
