/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Hex_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.camera.telemetry.Quadbox_REB_Bulk_PSTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.camera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cold2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo1Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo2Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo3Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo4Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo5Telemetry;
import org.lsst.sal.camera.telemetry.Refrig_Cryo6Telemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP1_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP2_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP3_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP4_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP5_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_ITelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CIP6_VTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_ForelineVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex1VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex2VacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboCurrentTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPowerTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPumpTempTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboSpeedTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVacTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVoltageTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveQuadbox_BFRTelemetry() throws Exception {
        double clean_5_24V_I = 0.6405952572822571;
        double dirty_24V_I = 0.766857922077179;
        double dirty_28V_I = 0.687667727470398;
        double dirty_48V_I = 0.34952735900878906;
        double heater_I = 0.00993675f;
        double protection_I = 0.690349817276001;
        double rebps_0_2_I = 0.28923535346984863;
        double rebps_3_5_I = 0.26285213232040405;
        double rebps_6_8_I = 0.3771381378173828;
        double rebps_9_12_I = 0.6719495058059692;
        double rebps_Spr_I = 0.7682473063468933;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_BFRTelemetry(clean_5_24V_I, dirty_24V_I, dirty_28V_I, dirty_48V_I, heater_I, protection_I, rebps_0_2_I, rebps_3_5_I, rebps_6_8_I, rebps_9_12_I, rebps_Spr_I));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFRTelemetry));
        Quadbox_BFRTelemetry item_ = (Quadbox_BFRTelemetry)item;
        Assert.assertEquals((double)clean_5_24V_I, (double)item_.getClean_5_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I, (double)item_.getDirty_24V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I, (double)item_.getDirty_28V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I, (double)item_.getDirty_48V_I(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I, (double)item_.getHeater_I(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I, (double)item_.getProtection_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I, (double)item_.getRebps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I, (double)item_.getRebps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I, (double)item_.getRebps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I, (double)item_.getRebps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I, (double)item_.getRebps_Spr_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VCTelemetry() throws Exception {
        double n_24vc_Board_T = 0.07676881551742554;
        double n_24vc_FPGA_T = 0.24139052629470825;
        double n_24vc_Main_I = 0.2275436520576477;
        double n_24vc_Main_T = 0.4622993f;
        double n_24vc_Main_V = 0.9350489377975464;
        double body_Purge_I = 0.4637170433998108;
        double body_Purge_V = 0.5707303285598755;
        double bpu_Maq20_I = 0.15987098217010498;
        double bpu_Maq20_V = 0.29332494735717773;
        double fes_Shu_HCU_I = 0.12369662523269653;
        double fes_Shu_HCU_V = 0.8678842186927795;
        double gauges_I = 0.868309736251831;
        double gauges_V = 0.02582573890686035;
        double ion_Pumps_I = 0.15500414371490479;
        double ion_Pumps_V = 0.2178855538368225;
        double pwr_Cry_HCU_I = 0.2221096158027649;
        double pwr_Cry_HCU_V = 0.9776892066001892;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VCTelemetry(n_24vc_Board_T, n_24vc_FPGA_T, n_24vc_Main_I, n_24vc_Main_T, n_24vc_Main_V, body_Purge_I, body_Purge_V, bpu_Maq20_I, bpu_Maq20_V, fes_Shu_HCU_I, fes_Shu_HCU_V, gauges_I, gauges_V, ion_Pumps_I, ion_Pumps_V, pwr_Cry_HCU_I, pwr_Cry_HCU_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VCTelemetry));
        Quadbox_PDU_24VCTelemetry item_ = (Quadbox_PDU_24VCTelemetry)item;
        Assert.assertEquals((double)n_24vc_Board_T, (double)item_.getN_24vc_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T, (double)item_.getN_24vc_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I, (double)item_.getN_24vc_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T, (double)item_.getN_24vc_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V, (double)item_.getN_24vc_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I, (double)item_.getBody_Purge_I(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V, (double)item_.getBody_Purge_V(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I, (double)item_.getBpu_Maq20_I(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V, (double)item_.getBpu_Maq20_V(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I, (double)item_.getFes_Shu_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V, (double)item_.getFes_Shu_HCU_V(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I, (double)item_.getGauges_I(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V, (double)item_.getGauges_V(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I, (double)item_.getIon_Pumps_I(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V, (double)item_.getIon_Pumps_V(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I, (double)item_.getPwr_Cry_HCU_I(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V, (double)item_.getPwr_Cry_HCU_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VDTelemetry() throws Exception {
        double n_24vd_Board_T = 0.21130973100662231;
        double n_24vd_FPGA_T = 0.0632513165473938;
        double n_24vd_Main_I = 0.3912856f;
        double n_24vd_Main_T = 0.926598310470581;
        double n_24vd_Main_V = 0.6310747265815735;
        double cryo_Turbo_I = 0.9165858030319214;
        double cryo_Turbo_V = 0.6439908742904663;
        double hex_Turbo_I = 0.08516901731491089;
        double hex_Turbo_V = 0.8014885783195496;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_24VDTelemetry(n_24vd_Board_T, n_24vd_FPGA_T, n_24vd_Main_I, n_24vd_Main_T, n_24vd_Main_V, cryo_Turbo_I, cryo_Turbo_V, hex_Turbo_I, hex_Turbo_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VDTelemetry));
        Quadbox_PDU_24VDTelemetry item_ = (Quadbox_PDU_24VDTelemetry)item;
        Assert.assertEquals((double)n_24vd_Board_T, (double)item_.getN_24vd_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T, (double)item_.getN_24vd_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I, (double)item_.getN_24vd_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T, (double)item_.getN_24vd_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V, (double)item_.getN_24vd_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I, (double)item_.getCryo_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V, (double)item_.getCryo_Turbo_V(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I, (double)item_.getHex_Turbo_I(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V, (double)item_.getHex_Turbo_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48VTelemetry() throws Exception {
        double n_48v_Board_T = 0.16051793098449707;
        double n_48v_FPGA_T = 0.2126123309135437;
        double n_48v_Main_I = 0.1681169867515564;
        double n_48v_Main_T = 0.6379313468933105;
        double n_48v_Main_V = 0.4508323669433594;
        double purge_Fan_I = 0.12970668077468872;
        double purge_Fan_V = 0.18624818325042725;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_48VTelemetry(n_48v_Board_T, n_48v_FPGA_T, n_48v_Main_I, n_48v_Main_T, n_48v_Main_V, purge_Fan_I, purge_Fan_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48VTelemetry));
        Quadbox_PDU_48VTelemetry item_ = (Quadbox_PDU_48VTelemetry)item;
        Assert.assertEquals((double)n_48v_Board_T, (double)item_.getN_48v_Board_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T, (double)item_.getN_48v_FPGA_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I, (double)item_.getN_48v_Main_I(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T, (double)item_.getN_48v_Main_T(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V, (double)item_.getN_48v_Main_V(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I, (double)item_.getPurge_Fan_I(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V, (double)item_.getPurge_Fan_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5VTelemetry() throws Exception {
        double otm_0_A_I = 0.5312761664390564;
        double otm_0_A_V = 0.07462853193283081;
        double otm_0_B_I = 0.4512097239494324;
        double otm_0_B_V = 0.11139404773712158;
        double otm_1_A_I = 0.7220391631126404;
        double otm_1_A_V = 0.8445212244987488;
        double otm_1_B_I = 0.12191075086593628;
        double otm_1_B_V = 0.30929964780807495;
        double otm_2_A_I = 0.1544435f;
        double otm_2_A_V = 0.5556836128234863;
        double otm_2_B_I = 0.4053928256034851;
        double otm_2_B_V = 0.6660559177398682;
        double otm_3_A_I = 0.977114737033844;
        double otm_3_A_V = 0.2076317f;
        double otm_3_B_I = 0.6812910437583923;
        double otm_3_B_V = 0.9709556698799133;
        double otm_4_A_I = 0.7882214188575745;
        double otm_4_A_V = 0.562879204750061;
        double otm_4_B_I = 0.7812221050262451;
        double otm_4_B_V = 0.7757747769355774;
        double otm_5_A_I = 0.7848882079124451;
        double otm_5_A_V = 0.8488917350769043;
        double otm_5_B_I = 0.3061372637748718;
        double otm_5_B_V = 0.3667f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_PDU_5VTelemetry(otm_0_A_I, otm_0_A_V, otm_0_B_I, otm_0_B_V, otm_1_A_I, otm_1_A_V, otm_1_B_I, otm_1_B_V, otm_2_A_I, otm_2_A_V, otm_2_B_I, otm_2_B_V, otm_3_A_I, otm_3_A_V, otm_3_B_I, otm_3_B_V, otm_4_A_I, otm_4_A_V, otm_4_B_I, otm_4_B_V, otm_5_A_I, otm_5_A_V, otm_5_B_I, otm_5_B_V));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5VTelemetry));
        Quadbox_PDU_5VTelemetry item_ = (Quadbox_PDU_5VTelemetry)item;
        Assert.assertEquals((double)otm_0_A_I, (double)item_.getOtm_0_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V, (double)item_.getOtm_0_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I, (double)item_.getOtm_0_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V, (double)item_.getOtm_0_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I, (double)item_.getOtm_1_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V, (double)item_.getOtm_1_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I, (double)item_.getOtm_1_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V, (double)item_.getOtm_1_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I, (double)item_.getOtm_2_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V, (double)item_.getOtm_2_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I, (double)item_.getOtm_2_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V, (double)item_.getOtm_2_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I, (double)item_.getOtm_3_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V, (double)item_.getOtm_3_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I, (double)item_.getOtm_3_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V, (double)item_.getOtm_3_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I, (double)item_.getOtm_4_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V, (double)item_.getOtm_4_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I, (double)item_.getOtm_4_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V, (double)item_.getOtm_4_B_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I, (double)item_.getOtm_5_A_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V, (double)item_.getOtm_5_A_V(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I, (double)item_.getOtm_5_B_I(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V, (double)item_.getOtm_5_B_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PSTelemetry() throws Exception {
        double rebbulkps_0_2_I = 0.2487483024597168;
        double rebbulkps_0_2_T = 0.6302184462547302;
        double rebbulkps_0_2_V = 0.3478030562400818;
        double rebbulkps_3_5_I = 0.9778169393539429;
        double rebbulkps_3_5_T = 0.37628644704818726;
        double rebbulkps_3_5_V = 0.909467f;
        double rebbulkps_6_8_I = 0.1719151735305786;
        double rebbulkps_6_8_T = 0.0897547f;
        double rebbulkps_6_8_V = 0.7045115828514099;
        double rebbulkps_9_12_I = 0.13723468780517578;
        double rebbulkps_9_12_T = 0.04690980911254883;
        double rebbulkps_9_12_V = 0.8173778057098389;
        double rebbulkps_Brd_T = 0.16545891761779785;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Quadbox_REB_Bulk_PSTelemetry(rebbulkps_0_2_I, rebbulkps_0_2_T, rebbulkps_0_2_V, rebbulkps_3_5_I, rebbulkps_3_5_T, rebbulkps_3_5_V, rebbulkps_6_8_I, rebbulkps_6_8_T, rebbulkps_6_8_V, rebbulkps_9_12_I, rebbulkps_9_12_T, rebbulkps_9_12_V, rebbulkps_Brd_T));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PSTelemetry));
        Quadbox_REB_Bulk_PSTelemetry item_ = (Quadbox_REB_Bulk_PSTelemetry)item;
        Assert.assertEquals((double)rebbulkps_0_2_I, (double)item_.getRebbulkps_0_2_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T, (double)item_.getRebbulkps_0_2_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V, (double)item_.getRebbulkps_0_2_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I, (double)item_.getRebbulkps_3_5_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T, (double)item_.getRebbulkps_3_5_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V, (double)item_.getRebbulkps_3_5_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I, (double)item_.getRebbulkps_6_8_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T, (double)item_.getRebbulkps_6_8_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V, (double)item_.getRebbulkps_6_8_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I, (double)item_.getRebbulkps_9_12_I(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T, (double)item_.getRebbulkps_9_12_T(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V, (double)item_.getRebbulkps_9_12_V(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T, (double)item_.getRebbulkps_Brd_T(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebTelemetry() throws Exception {
        double[] analog_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)15746044);
        double[] analog_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-6879595);
        double[] analog_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1940931220);
        double[] analog_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-993580434);
        double[] analog_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)354483233);
        double[] clockhi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1277878635);
        double[] clockhi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1190810361);
        double[] clockhi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1218495589);
        double[] clockhi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1115187842);
        double[] clockhi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-2101551786);
        double[] clocklo_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1964550685);
        double[] clocklo_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1391333742);
        double[] clocklo_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1283293276);
        double[] clocklo_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)536304122);
        double[] clocklo_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-1419231456);
        double[] clocklo_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-474285130);
        double[] digital_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1964182972);
        double[] digital_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1076093277);
        double[] digital_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)1727251476);
        double[] digital_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-738551259);
        double[] digital_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)192755305);
        double[] dphi_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1779536008);
        double[] dphi_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1595627409);
        double[] dphi_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)809799255);
        double[] dphi_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-498134683);
        double[] dphi_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)1355406090);
        double[] heater_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)2049770970);
        double[] heater_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)-1792816622);
        double[] heater_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-1871762392);
        double[] heater_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)1504614260);
        double[] heater_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)-249362873);
        double[] hvbias_IbefSwch = TestHelper.generateDoubleArray((int)71, (int)-1838744113);
        double[] hvbias_VbefSwch = TestHelper.generateDoubleArray((int)71, (int)-368068051);
        String location = "";
        double[] od_IaftLDO = TestHelper.generateDoubleArray((int)71, (int)1931745097);
        double[] od_IbefLDO = TestHelper.generateDoubleArray((int)71, (int)1999301497);
        double[] od_VaftLDO = TestHelper.generateDoubleArray((int)71, (int)-2114334995);
        double[] od_VaftLDO2 = TestHelper.generateDoubleArray((int)71, (int)856811190);
        double[] od_VaftSwch = TestHelper.generateDoubleArray((int)71, (int)-152600929);
        double[] od_VbefLDO = TestHelper.generateDoubleArray((int)71, (int)149987700);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)1991906968);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebTelemetry(analog_IaftLDO, analog_IbefLDO, analog_VaftLDO, analog_VaftSwch, analog_VbefLDO, clockhi_IaftLDO, clockhi_IbefLDO, clockhi_VaftLDO, clockhi_VaftSwch, clockhi_VbefLDO, clocklo_IaftLDO, clocklo_IbefLDO, clocklo_VaftLDO, clocklo_VaftLDO2, clocklo_VaftSwch, clocklo_VbefLDO, digital_IaftLDO, digital_IbefLDO, digital_VaftLDO, digital_VaftSwch, digital_VbefLDO, dphi_IaftLDO, dphi_IbefLDO, dphi_VaftLDO, dphi_VaftSwch, dphi_VbefLDO, heater_IaftLDO, heater_IbefLDO, heater_VaftLDO, heater_VaftSwch, heater_VbefLDO, hvbias_IbefSwch, hvbias_VbefSwch, location, od_IaftLDO, od_IbefLDO, od_VaftLDO, od_VaftLDO2, od_VaftSwch, od_VbefLDO, power));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebTelemetry));
        Rebpower_RebTelemetry item_ = (Rebpower_RebTelemetry)item;
        Assert.assertArrayEquals((double[])analog_IaftLDO, (double[])item_.getAnalog_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO, (double[])item_.getAnalog_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO, (double[])item_.getAnalog_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch, (double[])item_.getAnalog_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO, (double[])item_.getAnalog_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO, (double[])item_.getClockhi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO, (double[])item_.getClockhi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO, (double[])item_.getClockhi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch, (double[])item_.getClockhi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO, (double[])item_.getClockhi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO, (double[])item_.getClocklo_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO, (double[])item_.getClocklo_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO, (double[])item_.getClocklo_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2, (double[])item_.getClocklo_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch, (double[])item_.getClocklo_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO, (double[])item_.getClocklo_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO, (double[])item_.getDigital_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO, (double[])item_.getDigital_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO, (double[])item_.getDigital_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch, (double[])item_.getDigital_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO, (double[])item_.getDigital_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO, (double[])item_.getDphi_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO, (double[])item_.getDphi_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO, (double[])item_.getDphi_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch, (double[])item_.getDphi_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO, (double[])item_.getDphi_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO, (double[])item_.getHeater_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO, (double[])item_.getHeater_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO, (double[])item_.getHeater_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch, (double[])item_.getHeater_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO, (double[])item_.getHeater_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch, (double[])item_.getHvbias_IbefSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch, (double[])item_.getHvbias_VbefSwch(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO, (double[])item_.getOd_IaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO, (double[])item_.getOd_IbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO, (double[])item_.getOd_VaftLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2, (double[])item_.getOd_VaftLDO2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch, (double[])item_.getOd_VaftSwch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO, (double[])item_.getOd_VbefLDO(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_RebpsTelemetry() throws Exception {
        double[] boardTemp0 = TestHelper.generateDoubleArray((int)13, (int)-654768106);
        double[] boardTemp1 = TestHelper.generateDoubleArray((int)13, (int)-1232264175);
        double[] boardTemp2 = TestHelper.generateDoubleArray((int)13, (int)-324148768);
        double[] boardTemp3 = TestHelper.generateDoubleArray((int)13, (int)370402818);
        double[] boardTemp4 = TestHelper.generateDoubleArray((int)13, (int)-1528170775);
        double[] boardTemp5 = TestHelper.generateDoubleArray((int)13, (int)1139713151);
        double[] boardTemp6 = TestHelper.generateDoubleArray((int)13, (int)317078046);
        String location = "u";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Rebpower_RebpsTelemetry(boardTemp0, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebpsTelemetry));
        Rebpower_RebpsTelemetry item_ = (Rebpower_RebpsTelemetry)item;
        Assert.assertArrayEquals((double[])boardTemp0, (double[])item_.getBoardTemp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp1, (double[])item_.getBoardTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp2, (double[])item_.getBoardTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp3, (double[])item_.getBoardTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp4, (double[])item_.getBoardTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp5, (double[])item_.getBoardTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardTemp6, (double[])item_.getBoardTemp6(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveHex_Cold1Telemetry() throws Exception {
        double evapExitTmp = 0.5450135469436646;
        double hexRtrnTmp = 0.6083916425704956;
        double preExpnTmp = 0.4382684826850891;
        double returnPrs = 0.845430314540863;
        double superHeat = 0.9828876256942749;
        double supplyPrs = 0.7418993711471558;
        double supplySubCooling = 0.07980525493621826;
        double supplyTmp = 0.28811997175216675;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold1Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1Telemetry));
        Hex_Cold1Telemetry item_ = (Hex_Cold1Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2Telemetry() throws Exception {
        double evapExitTmp = 0.8270516395568848;
        double hexRtrnTmp = 0.8729289174079895;
        double preExpnTmp = 0.9783458113670349;
        double returnPrs = 0.08606314659118652;
        double superHeat = 0.07951432466506958;
        double supplyPrs = 0.38327741622924805;
        double supplySubCooling = 0.07689392566680908;
        double supplyTmp = 0.3709811568260193;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cold2Telemetry(evapExitTmp, hexRtrnTmp, preExpnTmp, returnPrs, superHeat, supplyPrs, supplySubCooling, supplyTmp));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2Telemetry));
        Hex_Cold2Telemetry item_ = (Hex_Cold2Telemetry)item;
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preExpnTmp, (double)item_.getPreExpnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)superHeat, (double)item_.getSuperHeat(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyPrs, (double)item_.getSupplyPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)supplySubCooling, (double)item_.getSupplySubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyTmp, (double)item_.getSupplyTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1Telemetry() throws Exception {
        double c3ExitTmp = 0.4337762f;
        double c4ExitTmp = 0.5407761931419373;
        double evapExitTmp = 0.42522042989730835;
        double hexRtrnTmp = 0.010773241519927979;
        double liquidPrs = 0.3226267099380493;
        double preC3Tmp = 0.2864617705345154;
        double preC4Tmp = 0.08847993612289429;
        double returnPrs = 0.11408644914627075;
        double vaporPrs = 0.9591028690338135;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo1Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1Telemetry));
        Hex_Cryo1Telemetry item_ = (Hex_Cryo1Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2Telemetry() throws Exception {
        double c3ExitTmp = 0.7161638736724854;
        double c4ExitTmp = 0.8000139594078064;
        double evapExitTmp = 0.7493444085121155;
        double hexRtrnTmp = 0.3515675663948059;
        double liquidPrs = 0.4386467933654785;
        double preC3Tmp = 0.11200529336929321;
        double preC4Tmp = 0.7727377414703369;
        double returnPrs = 0.3106893301010132;
        double vaporPrs = 0.1604752f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo2Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2Telemetry));
        Hex_Cryo2Telemetry item_ = (Hex_Cryo2Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3Telemetry() throws Exception {
        double c3ExitTmp = 0.9316699504852295;
        double c4ExitTmp = 0.4692228436470032;
        double evapExitTmp = 0.6340921521186829;
        double hexRtrnTmp = 0.2814931273460388;
        double liquidPrs = 0.01822417974472046;
        double preC3Tmp = 0.5734025835990906;
        double preC4Tmp = 0.9741061329841614;
        double returnPrs = 0.71956467628479;
        double vaporPrs = 0.9102600812911987;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo3Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3Telemetry));
        Hex_Cryo3Telemetry item_ = (Hex_Cryo3Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4Telemetry() throws Exception {
        double c3ExitTmp = 0.8651875853538513;
        double c4ExitTmp = 0.4640123248100281;
        double evapExitTmp = 0.8699944019317627;
        double hexRtrnTmp = 0.7108557820320129;
        double liquidPrs = 0.780899703502655;
        double preC3Tmp = 0.42520612478256226;
        double preC4Tmp = 0.5604330897331238;
        double returnPrs = 0.4883003830909729;
        double vaporPrs = 0.5871396660804749;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo4Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4Telemetry));
        Hex_Cryo4Telemetry item_ = (Hex_Cryo4Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5Telemetry() throws Exception {
        double c3ExitTmp = 0.4066761f;
        double c4ExitTmp = 0.11830466985702515;
        double evapExitTmp = 0.7664282321929932;
        double hexRtrnTmp = 0.5160966515541077;
        double liquidPrs = 0.2521233558654785;
        double preC3Tmp = 0.5227116346359253;
        double preC4Tmp = 0.6460506916046143;
        double returnPrs = 0.6314314007759094;
        double vaporPrs = 0.7600611448287964;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo5Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5Telemetry));
        Hex_Cryo5Telemetry item_ = (Hex_Cryo5Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6Telemetry() throws Exception {
        double c3ExitTmp = 0.8798719644546509;
        double c4ExitTmp = 0.6867908239364624;
        double evapExitTmp = 0.9984661936759949;
        double hexRtrnTmp = 0.03759205341339111;
        double liquidPrs = 0.7195050716400146;
        double preC3Tmp = 0.4088412f;
        double preC4Tmp = 0.2768210768699646;
        double returnPrs = 0.666645884513855;
        double vaporPrs = 0.4539481997489929;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Hex_Cryo6Telemetry(c3ExitTmp, c4ExitTmp, evapExitTmp, hexRtrnTmp, liquidPrs, preC3Tmp, preC4Tmp, returnPrs, vaporPrs));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6Telemetry));
        Hex_Cryo6Telemetry item_ = (Hex_Cryo6Telemetry)item;
        Assert.assertEquals((double)c3ExitTmp, (double)item_.getC3ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)c4ExitTmp, (double)item_.getC4ExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)evapExitTmp, (double)item_.getEvapExitTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)hexRtrnTmp, (double)item_.getHexRtrnTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidPrs, (double)item_.getLiquidPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)preC3Tmp, (double)item_.getPreC3Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)preC4Tmp, (double)item_.getPreC4Tmp(), (double)1.0E-6f);
        Assert.assertEquals((double)returnPrs, (double)item_.getReturnPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporPrs, (double)item_.getVaporPrs(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1Telemetry() throws Exception {
        double ambientTmp = 0.4719664454460144;
        double cabinetTmp = 0.08413833379745483;
        double compCurrent = 0.9477828145027161;
        double compPower = 0.632499635219574;
        double compVfdCurr = 0.5327885746955872;
        double compVfdFreq = 0.23305213451385498;
        double compVfdVolt = 0.48485177755355835;
        double compVoltage = 0.7365257740020752;
        double coolFlowRate = 0.9524611830711365;
        double coolValvePosn = 0.1976214051246643;
        double dischrgPrs = 0.2756111f;
        double dischrgtmp_M = 0.3378385901451111;
        double dischrgtmp_P = 0.859836220741272;
        double fan1Speed = 0.28822004795074463;
        double fan2Speed = 0.9087362885475159;
        double fan3Speed = 0.640973f;
        double hGBValvePosn = 0.20784467458724976;
        double liquidSubCooling = 0.014158666133880615;
        double liquidtmp_M = 0.8944817185401917;
        double liquidtmp_P = 0.17212438583374023;
        double suctionPrs = 0.9838724136352539;
        double suctiontmp_M = 0.890504777431488;
        double suctiontmp_P = 0.11074632406234741;
        double waterInTmp = 0.6021215319633484;
        double waterOutTmp = 0.44235873222351074;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold1Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1Telemetry));
        Refrig_Cold1Telemetry item_ = (Refrig_Cold1Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2Telemetry() throws Exception {
        double ambientTmp = 0.5397210717201233;
        double cabinetTmp = 0.6926897168159485;
        double compCurrent = 0.10200345516204834;
        double compPower = 0.366751492023468;
        double compVfdCurr = 0.7805096507072449;
        double compVfdFreq = 0.8747261762619019;
        double compVfdVolt = 0.9472829103469849;
        double compVoltage = 0.8885076642036438;
        double coolFlowRate = 0.556930422782898;
        double coolValvePosn = 0.5792065262794495;
        double dischrgPrs = 0.2961454391479492;
        double dischrgtmp_M = 0.19636154174804688;
        double dischrgtmp_P = 0.0023627877235412598;
        double fan1Speed = 0.28500616550445557;
        double fan2Speed = 0.6686477661132812;
        double fan3Speed = 0.6660289168357849;
        double hGBValvePosn = 0.7577430605888367;
        double liquidSubCooling = 0.578338623046875;
        double liquidtmp_M = 0.9150266051292419;
        double liquidtmp_P = 0.0884554386138916;
        double suctionPrs = 0.36490005254745483;
        double suctiontmp_M = 0.04228156805038452;
        double suctiontmp_P = 0.6637503504753113;
        double waterInTmp = 0.036338627338409424;
        double waterOutTmp = 0.26751482486724854;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cold2Telemetry(ambientTmp, cabinetTmp, compCurrent, compPower, compVfdCurr, compVfdFreq, compVfdVolt, compVoltage, coolFlowRate, coolValvePosn, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fan1Speed, fan2Speed, fan3Speed, hGBValvePosn, liquidSubCooling, liquidtmp_M, liquidtmp_P, suctionPrs, suctiontmp_M, suctiontmp_P, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2Telemetry));
        Refrig_Cold2Telemetry item_ = (Refrig_Cold2Telemetry)item;
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdCurr, (double)item_.getCompVfdCurr(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdFreq, (double)item_.getCompVfdFreq(), (double)1.0E-6f);
        Assert.assertEquals((double)compVfdVolt, (double)item_.getCompVfdVolt(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)coolFlowRate, (double)item_.getCoolFlowRate(), (double)1.0E-6f);
        Assert.assertEquals((double)coolValvePosn, (double)item_.getCoolValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1Speed, (double)item_.getFan1Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2Speed, (double)item_.getFan2Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3Speed, (double)item_.getFan3Speed(), (double)1.0E-6f);
        Assert.assertEquals((double)hGBValvePosn, (double)item_.getHGBValvePosn(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidSubCooling, (double)item_.getLiquidSubCooling(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M, (double)item_.getLiquidtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P, (double)item_.getLiquidtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1Telemetry() throws Exception {
        double afterCoolTmp = 0.8637517094612122;
        double compCurrent = 0.9317817687988281;
        double compPower = 0.1997787356376648;
        double compVoltage = 0.6986638903617859;
        double dischrgPrs = 0.8881232738494873;
        double dischrgtmp_M = 0.8241537809371948;
        double dischrgtmp_P = 0.1614902f;
        double fanSpeed = 0.6801071166992188;
        double oilLevel = 0.3216143250465393;
        double oilSepTmp = 0.876488f;
        double phaseSepTmp = 0.4421016573905945;
        double suctionPrs = 0.06011462211608887;
        double suctiontmp_M = 0.9373458623886108;
        double suctiontmp_P = 0.4472420811653137;
        double surgeTankTmp = 0.3018820285797119;
        double waterInTmp = 0.1699813f;
        double waterOutTmp = 0.37811917066574097;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo1Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1Telemetry));
        Refrig_Cryo1Telemetry item_ = (Refrig_Cryo1Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2Telemetry() throws Exception {
        double afterCoolTmp = 0.756597f;
        double compCurrent = 0.2650805711746216;
        double compPower = 0.3713676333427429;
        double compVoltage = 0.9410897493362427;
        double dischrgPrs = 0.3219779133796692;
        double dischrgtmp_M = 0.3683926463127136;
        double dischrgtmp_P = 0.7247708439826965;
        double fanSpeed = 0.3784014f;
        double oilLevel = 0.04783368110656738;
        double oilSepTmp = 0.9104452133178711;
        double phaseSepTmp = 0.8519304394721985;
        double suctionPrs = 0.6333589553833008;
        double suctiontmp_M = 0.49671435356140137;
        double suctiontmp_P = 0.8823203444480896;
        double surgeTankTmp = 0.050605833530426025;
        double waterInTmp = 0.7618787884712219;
        double waterOutTmp = 0.5727295875549316;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo2Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2Telemetry));
        Refrig_Cryo2Telemetry item_ = (Refrig_Cryo2Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3Telemetry() throws Exception {
        double afterCoolTmp = 0.1308283805847168;
        double ambientTmp = 0.998331f;
        double cabinetTmp = 0.3498866558074951;
        double compCurrent = 0.17562341690063477;
        double compPower = 0.6904461979866028;
        double compVoltage = 0.2425074f;
        double dischrgPrs = 0.6432969570159912;
        double dischrgtmp_M = 0.28806257247924805;
        double dischrgtmp_P = 0.11362528800964355;
        double fanSpeed = 0.7981902956962585;
        double oilLevel = 0.05058586597442627;
        double oilSepTmp = 0.410033f;
        double phaseSepTmp = 0.2327372431755066;
        double suctionPrs = 0.8834550380706787;
        double suctiontmp_M = 0.17927193641662598;
        double suctiontmp_P = 0.4878249168395996;
        double surgeTankTmp = 0.7535895705223083;
        double waterInTmp = 0.3272079825401306;
        double waterOutTmp = 0.7254730463027954;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo3Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3Telemetry));
        Refrig_Cryo3Telemetry item_ = (Refrig_Cryo3Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4Telemetry() throws Exception {
        double afterCoolTmp = 0.25193703174591064;
        double compCurrent = 0.7666507363319397;
        double compPower = 0.8382720947265625;
        double compVoltage = 0.2768780589103699;
        double dischrgPrs = 0.694943f;
        double dischrgtmp_M = 0.4774436354637146;
        double dischrgtmp_P = 0.8706921339035034;
        double fanSpeed = 0.9188368320465088;
        double oilLevel = 0.8191748261451721;
        double oilSepTmp = 0.7146965861320496;
        double phaseSepTmp = 0.6422613263130188;
        double suctionPrs = 0.7838386297225952;
        double suctiontmp_M = 0.5628254413604736;
        double suctiontmp_P = 0.5396012663841248;
        double surgeTankTmp = 0.2356804f;
        double waterInTmp = 0.76755690574646;
        double waterOutTmp = 0.2852470874786377;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo4Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4Telemetry));
        Refrig_Cryo4Telemetry item_ = (Refrig_Cryo4Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5Telemetry() throws Exception {
        double afterCoolTmp = 0.2208581566810608;
        double ambientTmp = 0.04956305f;
        double cabinetTmp = 0.2891341f;
        double compCurrent = 0.43691498041152954;
        double compPower = 0.08017098903656006;
        double compVoltage = 0.975362f;
        double dischrgPrs = 0.5168592929840088;
        double dischrgtmp_M = 0.1514669f;
        double dischrgtmp_P = 0.07667070627212524;
        double fanSpeed = 0.002496182918548584;
        double oilLevel = 0.05834996700286865;
        double oilSepTmp = 0.8367744088172913;
        double phaseSepTmp = 0.2647276520729065;
        double suctionPrs = 0.834425f;
        double suctiontmp_M = 0.9504293203353882;
        double suctiontmp_P = 0.2851177453994751;
        double surgeTankTmp = 0.40919822454452515;
        double waterInTmp = 0.010683178901672363;
        double waterOutTmp = 0.4298448f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo5Telemetry(afterCoolTmp, ambientTmp, cabinetTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5Telemetry));
        Refrig_Cryo5Telemetry item_ = (Refrig_Cryo5Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)ambientTmp, (double)item_.getAmbientTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinetTmp, (double)item_.getCabinetTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6Telemetry() throws Exception {
        double afterCoolTmp = 0.010835111141204834;
        double compCurrent = 0.50991290807724;
        double compPower = 0.8421172499656677;
        double compVoltage = 0.5516842007637024;
        double dischrgPrs = 0.11451911926269531;
        double dischrgtmp_M = 0.9108472466468811;
        double dischrgtmp_P = 0.687547f;
        double fanSpeed = 0.20582687854766846;
        double oilLevel = 0.8887909054756165;
        double oilSepTmp = 0.1397416591644287;
        double phaseSepTmp = 0.12922364473342896;
        double suctionPrs = 0.4991423487663269;
        double suctiontmp_M = 0.060374677181243896;
        double suctiontmp_P = 0.9349001049995422;
        double surgeTankTmp = 0.9818090796470642;
        double waterInTmp = 0.18668502569198608;
        double waterOutTmp = 0.21072006225585938;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Refrig_Cryo6Telemetry(afterCoolTmp, compCurrent, compPower, compVoltage, dischrgPrs, dischrgtmp_M, dischrgtmp_P, fanSpeed, oilLevel, oilSepTmp, phaseSepTmp, suctionPrs, suctiontmp_M, suctiontmp_P, surgeTankTmp, waterInTmp, waterOutTmp));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6Telemetry));
        Refrig_Cryo6Telemetry item_ = (Refrig_Cryo6Telemetry)item;
        Assert.assertEquals((double)afterCoolTmp, (double)item_.getAfterCoolTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)compCurrent, (double)item_.getCompCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)compPower, (double)item_.getCompPower(), (double)1.0E-6f);
        Assert.assertEquals((double)compVoltage, (double)item_.getCompVoltage(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgPrs, (double)item_.getDischrgPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M, (double)item_.getDischrgtmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P, (double)item_.getDischrgtmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)fanSpeed, (double)item_.getFanSpeed(), (double)1.0E-6f);
        Assert.assertEquals((double)oilLevel, (double)item_.getOilLevel(), (double)1.0E-6f);
        Assert.assertEquals((double)oilSepTmp, (double)item_.getOilSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTmp, (double)item_.getPhaseSepTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionPrs, (double)item_.getSuctionPrs(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M, (double)item_.getSuctiontmp_M(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P, (double)item_.getSuctiontmp_P(), (double)1.0E-6f);
        Assert.assertEquals((double)surgeTankTmp, (double)item_.getSurgeTankTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterInTmp, (double)item_.getWaterInTmp(), (double)1.0E-6f);
        Assert.assertEquals((double)waterOutTmp, (double)item_.getWaterOutTmp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_ITelemetry() throws Exception {
        double cip1_I = 0.8145656585693359;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_ITelemetry(cip1_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_ITelemetry));
        Vacuum_CIP1_ITelemetry item_ = (Vacuum_CIP1_ITelemetry)item;
        Assert.assertEquals((double)cip1_I, (double)item_.getCip1_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VTelemetry() throws Exception {
        double cip1_V = 0.7258254885673523;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP1_VTelemetry(cip1_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VTelemetry));
        Vacuum_CIP1_VTelemetry item_ = (Vacuum_CIP1_VTelemetry)item;
        Assert.assertEquals((double)cip1_V, (double)item_.getCip1_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_ITelemetry() throws Exception {
        double cip2_I = 0.791206419467926;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_ITelemetry(cip2_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_ITelemetry));
        Vacuum_CIP2_ITelemetry item_ = (Vacuum_CIP2_ITelemetry)item;
        Assert.assertEquals((double)cip2_I, (double)item_.getCip2_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VTelemetry() throws Exception {
        double cip2_V = 0.7525073885917664;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP2_VTelemetry(cip2_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VTelemetry));
        Vacuum_CIP2_VTelemetry item_ = (Vacuum_CIP2_VTelemetry)item;
        Assert.assertEquals((double)cip2_V, (double)item_.getCip2_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_ITelemetry() throws Exception {
        double cip3_I = 0.480847f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_ITelemetry(cip3_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_ITelemetry));
        Vacuum_CIP3_ITelemetry item_ = (Vacuum_CIP3_ITelemetry)item;
        Assert.assertEquals((double)cip3_I, (double)item_.getCip3_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VTelemetry() throws Exception {
        double cip3_V = 0.46290475130081177;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP3_VTelemetry(cip3_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VTelemetry));
        Vacuum_CIP3_VTelemetry item_ = (Vacuum_CIP3_VTelemetry)item;
        Assert.assertEquals((double)cip3_V, (double)item_.getCip3_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_ITelemetry() throws Exception {
        double cip4_I = 0.01742708683013916;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_ITelemetry(cip4_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_ITelemetry));
        Vacuum_CIP4_ITelemetry item_ = (Vacuum_CIP4_ITelemetry)item;
        Assert.assertEquals((double)cip4_I, (double)item_.getCip4_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VTelemetry() throws Exception {
        double cip4_V = 0.34737056493759155;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP4_VTelemetry(cip4_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VTelemetry));
        Vacuum_CIP4_VTelemetry item_ = (Vacuum_CIP4_VTelemetry)item;
        Assert.assertEquals((double)cip4_V, (double)item_.getCip4_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_ITelemetry() throws Exception {
        double cip5_I = 0.7279629111289978;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_ITelemetry(cip5_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_ITelemetry));
        Vacuum_CIP5_ITelemetry item_ = (Vacuum_CIP5_ITelemetry)item;
        Assert.assertEquals((double)cip5_I, (double)item_.getCip5_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VTelemetry() throws Exception {
        double cip5_V = 0.3086232542991638;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP5_VTelemetry(cip5_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VTelemetry));
        Vacuum_CIP5_VTelemetry item_ = (Vacuum_CIP5_VTelemetry)item;
        Assert.assertEquals((double)cip5_V, (double)item_.getCip5_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_ITelemetry() throws Exception {
        double cip6_I = 0.8943129181861877;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_ITelemetry(cip6_I));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_ITelemetry));
        Vacuum_CIP6_ITelemetry item_ = (Vacuum_CIP6_ITelemetry)item;
        Assert.assertEquals((double)cip6_I, (double)item_.getCip6_I(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VTelemetry() throws Exception {
        double cip6_V = 0.8320593237876892;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CIP6_VTelemetry(cip6_V));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VTelemetry));
        Vacuum_CIP6_VTelemetry item_ = (Vacuum_CIP6_VTelemetry)item;
        Assert.assertEquals((double)cip6_V, (double)item_.getCip6_V(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacTelemetry() throws Exception {
        double cryoVac = 0.9500392079353333;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_CryoVacTelemetry(cryoVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacTelemetry));
        Vacuum_CryoVacTelemetry item_ = (Vacuum_CryoVacTelemetry)item;
        Assert.assertEquals((double)cryoVac, (double)item_.getCryoVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacTelemetry() throws Exception {
        double forelineVac = 0.8717734217643738;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_ForelineVacTelemetry(forelineVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacTelemetry));
        Vacuum_ForelineVacTelemetry item_ = (Vacuum_ForelineVacTelemetry)item;
        Assert.assertEquals((double)forelineVac, (double)item_.getForelineVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacTelemetry() throws Exception {
        double hex1Vac = 0.9418385624885559;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex1VacTelemetry(hex1Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacTelemetry));
        Vacuum_Hex1VacTelemetry item_ = (Vacuum_Hex1VacTelemetry)item;
        Assert.assertEquals((double)hex1Vac, (double)item_.getHex1Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacTelemetry() throws Exception {
        double hex2Vac = 0.3426443934440613;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_Hex2VacTelemetry(hex2Vac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacTelemetry));
        Vacuum_Hex2VacTelemetry item_ = (Vacuum_Hex2VacTelemetry)item;
        Assert.assertEquals((double)hex2Vac, (double)item_.getHex2Vac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentTelemetry() throws Exception {
        double turboCurrent = 0.8763936161994934;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboCurrentTelemetry(turboCurrent));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentTelemetry));
        Vacuum_TurboCurrentTelemetry item_ = (Vacuum_TurboCurrentTelemetry)item;
        Assert.assertEquals((double)turboCurrent, (double)item_.getTurboCurrent(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerTelemetry() throws Exception {
        double turboPower = 0.10976654291152954;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPowerTelemetry(turboPower));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerTelemetry));
        Vacuum_TurboPowerTelemetry item_ = (Vacuum_TurboPowerTelemetry)item;
        Assert.assertEquals((double)turboPower, (double)item_.getTurboPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempTelemetry() throws Exception {
        double turboPumpTemp = 0.31328171491622925;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboPumpTempTelemetry(turboPumpTemp));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempTelemetry));
        Vacuum_TurboPumpTempTelemetry item_ = (Vacuum_TurboPumpTempTelemetry)item;
        Assert.assertEquals((double)turboPumpTemp, (double)item_.getTurboPumpTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedTelemetry() throws Exception {
        double turboSpeed = 0.17146307229995728;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboSpeedTelemetry(turboSpeed));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedTelemetry));
        Vacuum_TurboSpeedTelemetry item_ = (Vacuum_TurboSpeedTelemetry)item;
        Assert.assertEquals((double)turboSpeed, (double)item_.getTurboSpeed(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacTelemetry() throws Exception {
        double turboVac = 0.5648835897445679;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVacTelemetry(turboVac));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacTelemetry));
        Vacuum_TurboVacTelemetry item_ = (Vacuum_TurboVacTelemetry)item;
        Assert.assertEquals((double)turboVac, (double)item_.getTurboVac(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageTelemetry() throws Exception {
        double turboVoltage = 0.03226763f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Vacuum_TurboVoltageTelemetry(turboVoltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageTelemetry));
        Vacuum_TurboVoltageTelemetry item_ = (Vacuum_TurboVoltageTelemetry)item;
        Assert.assertEquals((double)turboVoltage, (double)item_.getTurboVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_StoreTelemetry() throws Exception {
        double capacity = 0.8929800391197205;
        double freeFraction = 0.007169842720031738;
        double freeSpace = 0.6722826361656189;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Daq_monitor_StoreTelemetry(capacity, freeFraction, freeSpace));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry item_ = (Daq_monitor_StoreTelemetry)item;
        Assert.assertEquals((double)capacity, (double)item_.getCapacity(), (double)1.0E-6f);
        Assert.assertEquals((double)freeFraction, (double)item_.getFreeFraction(), (double)1.0E-6f);
        Assert.assertEquals((double)freeSpace, (double)item_.getFreeSpace(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_CcdTelemetry() throws Exception {
        double[] gDV = TestHelper.generateDoubleArray((int)201, (int)-113598324);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)201, (int)678464515);
        double[] oDV = TestHelper.generateDoubleArray((int)201, (int)-2088461089);
        double[] oGV = TestHelper.generateDoubleArray((int)201, (int)573235743);
        double[] rDV = TestHelper.generateDoubleArray((int)201, (int)-1769953331);
        double[] temp = TestHelper.generateDoubleArray((int)201, (int)2022714565);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_CcdTelemetry(gDV, location, oDI, oDV, oGV, rDV, temp));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_CcdTelemetry));
        Focal_plane_CcdTelemetry item_ = (Focal_plane_CcdTelemetry)item;
        Assert.assertArrayEquals((double[])gDV, (double[])item_.getGDV(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oGV, (double[])item_.getOGV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rDV, (double[])item_.getRDV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp, (double[])item_.getTemp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTelemetry() throws Exception {
        double[] anaI = TestHelper.generateDoubleArray((int)71, (int)-887943027);
        double[] anaV = TestHelper.generateDoubleArray((int)71, (int)-631349312);
        double[] aspicl_Temp0 = TestHelper.generateDoubleArray((int)71, (int)2081431859);
        double[] aspicl_Temp1 = TestHelper.generateDoubleArray((int)71, (int)1207850612);
        double[] aspicl_Temp2 = TestHelper.generateDoubleArray((int)71, (int)897203393);
        double[] aspicu_Temp0 = TestHelper.generateDoubleArray((int)71, (int)1458003039);
        double[] aspicu_Temp1 = TestHelper.generateDoubleArray((int)71, (int)-257900303);
        double[] aspicu_Temp2 = TestHelper.generateDoubleArray((int)71, (int)1990414168);
        double[] clkHI = TestHelper.generateDoubleArray((int)71, (int)1883804102);
        double[] clkHV = TestHelper.generateDoubleArray((int)71, (int)-535623505);
        double[] clkLI = TestHelper.generateDoubleArray((int)71, (int)1330444517);
        double[] clkLV = TestHelper.generateDoubleArray((int)71, (int)-1540054388);
        double[] digI = TestHelper.generateDoubleArray((int)71, (int)-2034178544);
        double[] digV = TestHelper.generateDoubleArray((int)71, (int)-1457000112);
        double[] hVBiasSwitch = TestHelper.generateDoubleArray((int)71, (int)660788010);
        double[] htrPI = TestHelper.generateDoubleArray((int)71, (int)-1155681091);
        double[] htrPV = TestHelper.generateDoubleArray((int)71, (int)423224756);
        double[] htrV = TestHelper.generateDoubleArray((int)71, (int)2031790895);
        double[] htrW = TestHelper.generateDoubleArray((int)71, (int)140718250);
        String location = "";
        double[] oDI = TestHelper.generateDoubleArray((int)71, (int)-2000648935);
        double[] oDV = TestHelper.generateDoubleArray((int)71, (int)129393197);
        double[] pClk0 = TestHelper.generateDoubleArray((int)71, (int)1402854646);
        double[] pClk1 = TestHelper.generateDoubleArray((int)71, (int)1821893387);
        double[] pClkL = TestHelper.generateDoubleArray((int)71, (int)-2006816017);
        double[] pClkU = TestHelper.generateDoubleArray((int)71, (int)-93508098);
        double[] power = TestHelper.generateDoubleArray((int)71, (int)123374425);
        double[] rG0 = TestHelper.generateDoubleArray((int)71, (int)631279309);
        double[] rG1 = TestHelper.generateDoubleArray((int)71, (int)39880032);
        double[] rGL = TestHelper.generateDoubleArray((int)71, (int)-1864478381);
        double[] rGU = TestHelper.generateDoubleArray((int)71, (int)1038881065);
        double[] rTDTemp = TestHelper.generateDoubleArray((int)71, (int)-29679587);
        double[] ref05V = TestHelper.generateDoubleArray((int)71, (int)-421970298);
        double[] ref125V = TestHelper.generateDoubleArray((int)71, (int)-2124495045);
        double[] ref15V = TestHelper.generateDoubleArray((int)71, (int)-754159263);
        double[] ref25V = TestHelper.generateDoubleArray((int)71, (int)-725180469);
        double[] refN12 = TestHelper.generateDoubleArray((int)71, (int)-25361380);
        double[] refP12 = TestHelper.generateDoubleArray((int)71, (int)330482374);
        double[] sClk0 = TestHelper.generateDoubleArray((int)71, (int)1354075500);
        double[] sClk1 = TestHelper.generateDoubleArray((int)71, (int)474490386);
        double[] sClkL = TestHelper.generateDoubleArray((int)71, (int)-438888841);
        double[] sClkU = TestHelper.generateDoubleArray((int)71, (int)-370342677);
        double[] temp1 = TestHelper.generateDoubleArray((int)71, (int)60002115);
        double[] temp10 = TestHelper.generateDoubleArray((int)71, (int)2128608541);
        double[] temp2 = TestHelper.generateDoubleArray((int)71, (int)-1075850570);
        double[] temp3 = TestHelper.generateDoubleArray((int)71, (int)-145544021);
        double[] temp4 = TestHelper.generateDoubleArray((int)71, (int)1399546041);
        double[] temp5 = TestHelper.generateDoubleArray((int)71, (int)1779427277);
        double[] temp6 = TestHelper.generateDoubleArray((int)71, (int)1210903608);
        double[] temp7 = TestHelper.generateDoubleArray((int)71, (int)561276277);
        double[] temp8 = TestHelper.generateDoubleArray((int)71, (int)916505621);
        double[] temp9 = TestHelper.generateDoubleArray((int)71, (int)-1185378119);
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTelemetry(anaI, anaV, aspicl_Temp0, aspicl_Temp1, aspicl_Temp2, aspicu_Temp0, aspicu_Temp1, aspicu_Temp2, clkHI, clkHV, clkLI, clkLV, digI, digV, hVBiasSwitch, htrPI, htrPV, htrV, htrW, location, oDI, oDV, pClk0, pClk1, pClkL, pClkU, power, rG0, rG1, rGL, rGU, rTDTemp, ref05V, ref125V, ref15V, ref25V, refN12, refP12, sClk0, sClk1, sClkL, sClkU, temp1, temp10, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTelemetry));
        Focal_plane_RebTelemetry item_ = (Focal_plane_RebTelemetry)item;
        Assert.assertArrayEquals((double[])anaI, (double[])item_.getAnaI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anaV, (double[])item_.getAnaV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0, (double[])item_.getAspicl_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1, (double[])item_.getAspicl_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2, (double[])item_.getAspicl_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0, (double[])item_.getAspicu_Temp0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1, (double[])item_.getAspicu_Temp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2, (double[])item_.getAspicu_Temp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHI, (double[])item_.getClkHI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkHV, (double[])item_.getClkHV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLI, (double[])item_.getClkLI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkLV, (double[])item_.getClkLV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digI, (double[])item_.getDigI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digV, (double[])item_.getDigV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hVBiasSwitch, (double[])item_.getHVBiasSwitch(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPI, (double[])item_.getHtrPI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrPV, (double[])item_.getHtrPV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrV, (double[])item_.getHtrV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrW, (double[])item_.getHtrW(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])oDI, (double[])item_.getODI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])oDV, (double[])item_.getODV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk0, (double[])item_.getPClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClk1, (double[])item_.getPClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkL, (double[])item_.getPClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pClkU, (double[])item_.getPClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power, (double[])item_.getPower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG0, (double[])item_.getRG0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rG1, (double[])item_.getRG1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGL, (double[])item_.getRGL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rGU, (double[])item_.getRGU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rTDTemp, (double[])item_.getRTDTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05V, (double[])item_.getRef05V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125V, (double[])item_.getRef125V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15V, (double[])item_.getRef15V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25V, (double[])item_.getRef25V(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refN12, (double[])item_.getRefN12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refP12, (double[])item_.getRefP12(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk0, (double[])item_.getSClk0(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClk1, (double[])item_.getSClk1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkL, (double[])item_.getSClkL(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sClkU, (double[])item_.getSClkU(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1, (double[])item_.getTemp1(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10, (double[])item_.getTemp10(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2, (double[])item_.getTemp2(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3, (double[])item_.getTemp3(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4, (double[])item_.getTemp4(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5, (double[])item_.getTemp5(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6, (double[])item_.getTemp6(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7, (double[])item_.getTemp7(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8, (double[])item_.getTemp8(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9, (double[])item_.getTemp9(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPowerTelemetry() throws Exception {
        double rebTotalPower = 0.7242322564125061;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_RebTotalPowerTelemetry(rebTotalPower));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPowerTelemetry));
        Focal_plane_RebTotalPowerTelemetry item_ = (Focal_plane_RebTotalPowerTelemetry)item;
        Assert.assertEquals((double)rebTotalPower, (double)item_.getRebTotalPower(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_SegmentTelemetry() throws Exception {
        double[] i = TestHelper.generateDoubleArray((int)3024, (int)-762177588);
        String location = "a";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new Focal_plane_SegmentTelemetry(i, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SegmentTelemetry));
        Focal_plane_SegmentTelemetry item_ = (Focal_plane_SegmentTelemetry)item;
        Assert.assertArrayEquals((double[])i, (double[])item_.getI(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }
}

