/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.TestHelper;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Stats_buildSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_StoreSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Daq_monitor_Store_StoreSettingsAppliedEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_ImageNameServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_HardwareIdSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_RaftsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Reb_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_Segment_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.HexSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cold1_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cold2_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cryo1_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cryo2_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cryo3_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cryo4_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cryo5_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Cryo6_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Maq20_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_Maq20x_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Hex_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_BFR_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.RebpowerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_EmergencyResponseManagerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_RebSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_Reb_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Rebpower_Rebps_PowerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cold1_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cold2_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_CoolMaq20_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo1_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo2_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo3_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo4_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo5_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_CompLimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_DeviceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_Cryo6_LimitsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasksSettingsAppliedEvent;
import org.lsst.sal.camera.event.Refrig_PeriodicTasks_timersSettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.event.Vacuum_AgentMonitorServiceSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1CSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1_ISettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP1_VSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2CSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2_ISettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP2_VSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3CSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3_ISettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP3_VSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4CSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4_ISettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP4_VSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5CSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5_ISettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP5_VSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6CSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6_ISettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CIP6_VSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacGaugeSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_CryoVacSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_ForelineVacGaugeSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_ForelineVacSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_HeartbeatSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Hex1VacGaugeSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Hex1VacSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Hex2VacGaugeSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Hex2VacSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_IonPumpsSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_checkSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_publishSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Monitor_updateSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_RuntimeInfoSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_SchedulersSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboCurrentSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPowerSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPumpSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboPumpTempSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboSpeedSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVacGaugeSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVacSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_TurboVoltageSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_VacPlutoSettingsAppliedEvent;
import org.lsst.sal.camera.event.Vacuum_Vacuum_stateSettingsAppliedEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 379;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 977;
        String imageName = "kpffmnwkoekwxqcrkm";
        int imageIndex = 389;
        String imageSource = "";
        String imageController = "";
        String imageDate = "udwlsjy";
        int imageNumber = 299;
        double timestampAcquisitionStart = 0.5973697304725647;
        double requestedExposureTime = 0.5855571627616882;
        double timestampEndOfReadout = 0.20897942781448364;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 267;
        double timestampTransition = 0.37829506397247314;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 424;
        String filterName = "l";
        String filterType = "o";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 819;
        double timestampTransition = 0.5741432905197144;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 166;
        double timestampTransition = 0.2913547158241272;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 874;
        double timestampTransition = 0.07489949464797974;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 418;
        double timestampTransition = 0.9309825897216797;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 376;
        double timestampTransition = 0.38669872283935547;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 932;
        String additionalKeys = "";
        String additionalValues = "l";
        int imagesInSequence = 151;
        String imageName = "kwkiqzeetslvdrdpyn";
        int imageIndex = 335;
        String imageSource = "e";
        String imageController = "";
        String imageDate = "hn";
        int imageNumber = 399;
        double timestampAcquisitionStart = 0.9397023916244507;
        double exposureTime = 0.6912664771080017;
        String imageTag = "vpreprkfuytkjuyhyzwirzilycb";
        double timestampDateObs = 0.18176805973052979;
        double timestampDateEnd = 0.6745571494102478;
        double measuredShutterOpenTime = 0.3576050400733948;
        double darkTime = 0.837174117565155;
        String emulatedImage = "a";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 751;
        double timestampTransition = 0.9751831293106079;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 940;
        double timestampTransition = 0.01255100965499878;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 96;
        double timestampTransition = 0.8405311107635498;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 611;
        double timestampTransition = 0.17844295501708984;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 619;
        double timestampTransition = 0.6389796137809753;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 532;
        double timestampTransition = 0.40296316146850586;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 961;
        double timestampTransition = 0.28438347578048706;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 949;
        double timestampTransition = 0.5390076041221619;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 103;
        String additionalKeys = "y";
        String additionalValues = "e";
        int imagesInSequence = 688;
        String imageName = "pjijblghnyjpffbcks";
        int imageIndex = 423;
        String imageSource = "";
        String imageController = "w";
        String imageDate = "puhjt";
        int imageNumber = 514;
        double timestampAcquisitionStart = 0.5767078399658203;
        double exposureTime = 0.041435956954956055;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 252;
        double timestampTransition = 0.28413987159729004;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 303;
        String filterName = "";
        String filterType = "r";
        int filterSlot = 533;
        double filterPosition = 0.6463446021080017;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 784;
        double timestampTransition = 0.5278586149215698;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 972;
        String filterNames = "nqiyjgsyfqdeelosixirsmhnddyrhmpolaatatguejjmwmfeoaclwuexojmhlpkystpmanwcangdisqfvxuqwqysiafomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiutxsqcaageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhz";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 798;
        String additionalKeys = "v";
        String additionalValues = "a";
        int imagesInSequence = 314;
        String imageName = "jumwxnuioaorfjzvnqofqitxyuov";
        int imageIndex = 647;
        String imageSource = "";
        String imageController = "l";
        String imageDate = "abkzcm";
        int imageNumber = 683;
        double timestampAcquisitionStart = 0.08686012029647827;
        double exposureTime = 0.6933475732803345;
        double timestampStartOfReadout = 0.5346096754074097;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 441;
        double timestampTransition = 0.9472615718841553;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 416;
        String imageName = "";
        String ccdLocation = "l";
        String raftBay = "";
        String ccdSlot = "t";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = TestHelper.generateIntArray((int)201, (int)-1288215810);
        int[] overCols = TestHelper.generateIntArray((int)201, (int)1913701577);
        int[] readRows = TestHelper.generateIntArray((int)201, (int)801456869);
        int[] readCols = TestHelper.generateIntArray((int)201, (int)1518552583);
        int[] readCols2 = TestHelper.generateIntArray((int)201, (int)1174539276);
        int[] preCols = TestHelper.generateIntArray((int)201, (int)-1062255042);
        int[] preRows = TestHelper.generateIntArray((int)201, (int)-893915591);
        int[] postCols = TestHelper.generateIntArray((int)201, (int)1429342757);
        int[] underCols = TestHelper.generateIntArray((int)201, (int)540777305);
        String daqFolder = "";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 281;
        String ccdLocation = "a";
        String raftBay = "b";
        String ccdSlot = "";
        String rebSerialNumber = "b";
        String rebLSSTName = "v";
        String ccdLSSTName = "q";
        String raftLSSTName = "q";
        String ccdManSerNum = "w";
        String ccdManufacturer = "w";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V};
        double[] ccdTempSetPoint = TestHelper.generateDoubleArray((int)212, (int)-773538536);
        String sequencerKey = "p";
        String sequencerChecksum = "";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveQuadbox_BFR_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 622;
        int version = 134;
        double clean_5_24V_I_warnHi = 0.08200287818908691;
        double clean_5_24V_I_warnLo = 0.8293628096580505;
        double clean_5_24V_I_limitHi = 0.8970068693161011;
        double clean_5_24V_I_limitLo = 0.2322337031364441;
        double dirty_24V_I_warnHi = 0.659993f;
        double dirty_24V_I_warnLo = 0.9325717687606812;
        double dirty_24V_I_limitHi = 0.4854145050048828;
        double dirty_24V_I_limitLo = 0.18520653247833252;
        double dirty_28V_I_warnHi = 0.35989898443222046;
        double dirty_28V_I_warnLo = 0.22506767511367798;
        double dirty_28V_I_limitHi = 0.14500826597213745;
        double dirty_28V_I_limitLo = 0.10195744037628174;
        double dirty_48V_I_warnHi = 0.7472650408744812;
        double dirty_48V_I_warnLo = 0.7284701466560364;
        double dirty_48V_I_limitHi = 0.5455885529518127;
        double dirty_48V_I_limitLo = 0.8110129237174988;
        double heater_I_warnHi = 0.19291293621063232;
        double heater_I_warnLo = 0.7421621084213257;
        double heater_I_limitHi = 0.09804767370223999;
        double heater_I_limitLo = 0.4464316964149475;
        double protection_I_warnHi = 0.3112324f;
        double protection_I_warnLo = 0.15415281057357788;
        double protection_I_limitHi = 0.6058251857757568;
        double protection_I_limitLo = 0.10584050416946411;
        double rebps_0_2_I_warnHi = 0.8688523173332214;
        double rebps_0_2_I_warnLo = 0.05147433280944824;
        double rebps_0_2_I_limitHi = 0.7004167437553406;
        double rebps_0_2_I_limitLo = 0.6102726459503174;
        double rebps_3_5_I_warnHi = 0.16373854875564575;
        double rebps_3_5_I_warnLo = 0.2257222f;
        double rebps_3_5_I_limitHi = 0.6810241937637329;
        double rebps_3_5_I_limitLo = 0.1661999225616455;
        double rebps_6_8_I_warnHi = 0.9088693857192993;
        double rebps_6_8_I_warnLo = 0.11945706605911255;
        double rebps_6_8_I_limitHi = 0.2741441f;
        double rebps_6_8_I_limitLo = 0.766837f;
        double rebps_9_12_I_warnHi = 0.7217692732810974;
        double rebps_9_12_I_warnLo = 0.5272254347801208;
        double rebps_9_12_I_limitHi = 0.7229553461074829;
        double rebps_9_12_I_limitLo = 0.9956062436103821;
        double rebps_Spr_I_warnHi = 0.9965223670005798;
        double rebps_Spr_I_warnLo = 0.14721661806106567;
        double rebps_Spr_I_limitHi = 0.4042872190475464;
        double rebps_Spr_I_limitLo = 0.6199347376823425;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_LimitsSettingsAppliedEvent(priority, version, clean_5_24V_I_warnHi, clean_5_24V_I_warnLo, clean_5_24V_I_limitHi, clean_5_24V_I_limitLo, dirty_24V_I_warnHi, dirty_24V_I_warnLo, dirty_24V_I_limitHi, dirty_24V_I_limitLo, dirty_28V_I_warnHi, dirty_28V_I_warnLo, dirty_28V_I_limitHi, dirty_28V_I_limitLo, dirty_48V_I_warnHi, dirty_48V_I_warnLo, dirty_48V_I_limitHi, dirty_48V_I_limitLo, heater_I_warnHi, heater_I_warnLo, heater_I_limitHi, heater_I_limitLo, protection_I_warnHi, protection_I_warnLo, protection_I_limitHi, protection_I_limitLo, rebps_0_2_I_warnHi, rebps_0_2_I_warnLo, rebps_0_2_I_limitHi, rebps_0_2_I_limitLo, rebps_3_5_I_warnHi, rebps_3_5_I_warnLo, rebps_3_5_I_limitHi, rebps_3_5_I_limitLo, rebps_6_8_I_warnHi, rebps_6_8_I_warnLo, rebps_6_8_I_limitHi, rebps_6_8_I_limitLo, rebps_9_12_I_warnHi, rebps_9_12_I_warnLo, rebps_9_12_I_limitHi, rebps_9_12_I_limitLo, rebps_Spr_I_warnHi, rebps_Spr_I_warnLo, rebps_Spr_I_limitHi, rebps_Spr_I_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_LimitsSettingsAppliedEvent));
        Quadbox_BFR_LimitsSettingsAppliedEvent item_ = (Quadbox_BFR_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)clean_5_24V_I_warnHi, (double)item_.getClean_5_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_warnLo, (double)item_.getClean_5_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitHi, (double)item_.getClean_5_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)clean_5_24V_I_limitLo, (double)item_.getClean_5_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnHi, (double)item_.getDirty_24V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_warnLo, (double)item_.getDirty_24V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitHi, (double)item_.getDirty_24V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_24V_I_limitLo, (double)item_.getDirty_24V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnHi, (double)item_.getDirty_28V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_warnLo, (double)item_.getDirty_28V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitHi, (double)item_.getDirty_28V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_28V_I_limitLo, (double)item_.getDirty_28V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnHi, (double)item_.getDirty_48V_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_warnLo, (double)item_.getDirty_48V_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitHi, (double)item_.getDirty_48V_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dirty_48V_I_limitLo, (double)item_.getDirty_48V_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnHi, (double)item_.getHeater_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_warnLo, (double)item_.getHeater_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitHi, (double)item_.getHeater_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)heater_I_limitLo, (double)item_.getHeater_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnHi, (double)item_.getProtection_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_warnLo, (double)item_.getProtection_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitHi, (double)item_.getProtection_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)protection_I_limitLo, (double)item_.getProtection_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnHi, (double)item_.getRebps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_warnLo, (double)item_.getRebps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitHi, (double)item_.getRebps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_0_2_I_limitLo, (double)item_.getRebps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnHi, (double)item_.getRebps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_warnLo, (double)item_.getRebps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitHi, (double)item_.getRebps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_3_5_I_limitLo, (double)item_.getRebps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnHi, (double)item_.getRebps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_warnLo, (double)item_.getRebps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitHi, (double)item_.getRebps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_6_8_I_limitLo, (double)item_.getRebps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnHi, (double)item_.getRebps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_warnLo, (double)item_.getRebps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitHi, (double)item_.getRebps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_9_12_I_limitLo, (double)item_.getRebps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnHi, (double)item_.getRebps_Spr_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_warnLo, (double)item_.getRebps_Spr_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitHi, (double)item_.getRebps_Spr_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebps_Spr_I_limitLo, (double)item_.getRebps_Spr_I_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_BFR_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 177;
        int version = 653;
        int node = 21;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_BFR_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_BFR_QuadboxSettingsAppliedEvent));
        Quadbox_BFR_QuadboxSettingsAppliedEvent item_ = (Quadbox_BFR_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 122;
        int version = 540;
        double n_24vc_Board_T_warnHi = 0.6466214656829834;
        double n_24vc_Board_T_warnLo = 0.6851903200149536;
        double n_24vc_Board_T_limitHi = 0.41917216777801514;
        double n_24vc_Board_T_limitLo = 0.5601454377174377;
        double n_24vc_FPGA_T_warnHi = 0.33406996726989746;
        double n_24vc_FPGA_T_warnLo = 0.5312292575836182;
        double n_24vc_FPGA_T_limitHi = 0.7347690463066101;
        double n_24vc_FPGA_T_limitLo = 0.36329346895217896;
        double n_24vc_Main_I_warnHi = 0.4870149f;
        double n_24vc_Main_I_warnLo = 0.22898507118225098;
        double n_24vc_Main_I_limitHi = 0.6373441815376282;
        double n_24vc_Main_I_limitLo = 0.6345996856689453;
        double n_24vc_Main_T_warnHi = 0.276350736618042;
        double n_24vc_Main_T_warnLo = 0.5662907958030701;
        double n_24vc_Main_T_limitHi = 0.4810322f;
        double n_24vc_Main_T_limitLo = 0.17140984535217285;
        double n_24vc_Main_V_warnHi = 0.2860983610153198;
        double n_24vc_Main_V_warnLo = 0.2018665075302124;
        double n_24vc_Main_V_limitHi = 0.8623965978622437;
        double n_24vc_Main_V_limitLo = 0.2078021764755249;
        double body_Purge_I_warnHi = 0.027436554431915283;
        double body_Purge_I_warnLo = 0.3213622570037842;
        double body_Purge_I_limitHi = 0.8489788770675659;
        double body_Purge_I_limitLo = 0.17418742179870605;
        double body_Purge_V_warnHi = 0.08984065055847168;
        double body_Purge_V_warnLo = 0.4241867661476135;
        double body_Purge_V_limitHi = 0.9418308734893799;
        double body_Purge_V_limitLo = 0.9684880375862122;
        double bpu_Maq20_I_warnHi = 0.9527187347412109;
        double bpu_Maq20_I_warnLo = 0.18455815315246582;
        double bpu_Maq20_I_limitHi = 0.6065274477005005;
        double bpu_Maq20_I_limitLo = 0.4981291890144348;
        double bpu_Maq20_V_warnHi = 0.8888053894042969;
        double bpu_Maq20_V_warnLo = 0.24716395139694214;
        double bpu_Maq20_V_limitHi = 0.18402493000030518;
        double bpu_Maq20_V_limitLo = 0.9244294762611389;
        double fes_Shu_HCU_I_warnHi = 0.7530982494354248;
        double fes_Shu_HCU_I_warnLo = 0.6354634165763855;
        double fes_Shu_HCU_I_limitHi = 0.11419862508773804;
        double fes_Shu_HCU_I_limitLo = 0.06763821840286255;
        double fes_Shu_HCU_V_warnHi = 0.15208107233047485;
        double fes_Shu_HCU_V_warnLo = 0.502015f;
        double fes_Shu_HCU_V_limitHi = 0.4687958359718323;
        double fes_Shu_HCU_V_limitLo = 0.2776569128036499;
        double gauges_I_warnHi = 0.8017957806587219;
        double gauges_I_warnLo = 0.646397590637207;
        double gauges_I_limitHi = 0.11037266254425049;
        double gauges_I_limitLo = 0.4113478f;
        double gauges_V_warnHi = 0.2250347137451172;
        double gauges_V_warnLo = 0.3065752387046814;
        double gauges_V_limitHi = 0.4486308693885803;
        double gauges_V_limitLo = 0.5043429136276245;
        double ion_Pumps_I_warnHi = 0.11318850517272949;
        double ion_Pumps_I_warnLo = 0.511311f;
        double ion_Pumps_I_limitHi = 0.8501695990562439;
        double ion_Pumps_I_limitLo = 0.10861527919769287;
        double ion_Pumps_V_warnHi = 0.13340067863464355;
        double ion_Pumps_V_warnLo = 0.909978985786438;
        double ion_Pumps_V_limitHi = 0.632366418838501;
        double ion_Pumps_V_limitLo = 0.8650884032249451;
        double pwr_Cry_HCU_I_warnHi = 0.033549726009368896;
        double pwr_Cry_HCU_I_warnLo = 0.6954838037490845;
        double pwr_Cry_HCU_I_limitHi = 0.11287665367126465;
        double pwr_Cry_HCU_I_limitLo = 0.674673318862915;
        double pwr_Cry_HCU_V_warnHi = 0.06375402212142944;
        double pwr_Cry_HCU_V_warnLo = 0.5577300786972046;
        double pwr_Cry_HCU_V_limitHi = 0.0346936f;
        double pwr_Cry_HCU_V_limitLo = 0.25591927766799927;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_LimitsSettingsAppliedEvent(priority, version, n_24vc_Board_T_warnHi, n_24vc_Board_T_warnLo, n_24vc_Board_T_limitHi, n_24vc_Board_T_limitLo, n_24vc_FPGA_T_warnHi, n_24vc_FPGA_T_warnLo, n_24vc_FPGA_T_limitHi, n_24vc_FPGA_T_limitLo, n_24vc_Main_I_warnHi, n_24vc_Main_I_warnLo, n_24vc_Main_I_limitHi, n_24vc_Main_I_limitLo, n_24vc_Main_T_warnHi, n_24vc_Main_T_warnLo, n_24vc_Main_T_limitHi, n_24vc_Main_T_limitLo, n_24vc_Main_V_warnHi, n_24vc_Main_V_warnLo, n_24vc_Main_V_limitHi, n_24vc_Main_V_limitLo, body_Purge_I_warnHi, body_Purge_I_warnLo, body_Purge_I_limitHi, body_Purge_I_limitLo, body_Purge_V_warnHi, body_Purge_V_warnLo, body_Purge_V_limitHi, body_Purge_V_limitLo, bpu_Maq20_I_warnHi, bpu_Maq20_I_warnLo, bpu_Maq20_I_limitHi, bpu_Maq20_I_limitLo, bpu_Maq20_V_warnHi, bpu_Maq20_V_warnLo, bpu_Maq20_V_limitHi, bpu_Maq20_V_limitLo, fes_Shu_HCU_I_warnHi, fes_Shu_HCU_I_warnLo, fes_Shu_HCU_I_limitHi, fes_Shu_HCU_I_limitLo, fes_Shu_HCU_V_warnHi, fes_Shu_HCU_V_warnLo, fes_Shu_HCU_V_limitHi, fes_Shu_HCU_V_limitLo, gauges_I_warnHi, gauges_I_warnLo, gauges_I_limitHi, gauges_I_limitLo, gauges_V_warnHi, gauges_V_warnLo, gauges_V_limitHi, gauges_V_limitLo, ion_Pumps_I_warnHi, ion_Pumps_I_warnLo, ion_Pumps_I_limitHi, ion_Pumps_I_limitLo, ion_Pumps_V_warnHi, ion_Pumps_V_warnLo, ion_Pumps_V_limitHi, ion_Pumps_V_limitLo, pwr_Cry_HCU_I_warnHi, pwr_Cry_HCU_I_warnLo, pwr_Cry_HCU_I_limitHi, pwr_Cry_HCU_I_limitLo, pwr_Cry_HCU_V_warnHi, pwr_Cry_HCU_V_warnLo, pwr_Cry_HCU_V_limitHi, pwr_Cry_HCU_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_LimitsSettingsAppliedEvent));
        Quadbox_PDU_24VC_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_24VC_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)n_24vc_Board_T_warnHi, (double)item_.getN_24vc_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_warnLo, (double)item_.getN_24vc_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_limitHi, (double)item_.getN_24vc_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Board_T_limitLo, (double)item_.getN_24vc_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_warnHi, (double)item_.getN_24vc_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_warnLo, (double)item_.getN_24vc_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_limitHi, (double)item_.getN_24vc_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_FPGA_T_limitLo, (double)item_.getN_24vc_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_warnHi, (double)item_.getN_24vc_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_warnLo, (double)item_.getN_24vc_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_limitHi, (double)item_.getN_24vc_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_I_limitLo, (double)item_.getN_24vc_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_warnHi, (double)item_.getN_24vc_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_warnLo, (double)item_.getN_24vc_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_limitHi, (double)item_.getN_24vc_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_T_limitLo, (double)item_.getN_24vc_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_warnHi, (double)item_.getN_24vc_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_warnLo, (double)item_.getN_24vc_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_limitHi, (double)item_.getN_24vc_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vc_Main_V_limitLo, (double)item_.getN_24vc_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnHi, (double)item_.getBody_Purge_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_warnLo, (double)item_.getBody_Purge_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitHi, (double)item_.getBody_Purge_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_I_limitLo, (double)item_.getBody_Purge_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnHi, (double)item_.getBody_Purge_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_warnLo, (double)item_.getBody_Purge_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitHi, (double)item_.getBody_Purge_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)body_Purge_V_limitLo, (double)item_.getBody_Purge_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnHi, (double)item_.getBpu_Maq20_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_warnLo, (double)item_.getBpu_Maq20_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitHi, (double)item_.getBpu_Maq20_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_I_limitLo, (double)item_.getBpu_Maq20_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnHi, (double)item_.getBpu_Maq20_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_warnLo, (double)item_.getBpu_Maq20_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitHi, (double)item_.getBpu_Maq20_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)bpu_Maq20_V_limitLo, (double)item_.getBpu_Maq20_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnHi, (double)item_.getFes_Shu_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_warnLo, (double)item_.getFes_Shu_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitHi, (double)item_.getFes_Shu_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_I_limitLo, (double)item_.getFes_Shu_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnHi, (double)item_.getFes_Shu_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_warnLo, (double)item_.getFes_Shu_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitHi, (double)item_.getFes_Shu_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fes_Shu_HCU_V_limitLo, (double)item_.getFes_Shu_HCU_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnHi, (double)item_.getGauges_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_warnLo, (double)item_.getGauges_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitHi, (double)item_.getGauges_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_I_limitLo, (double)item_.getGauges_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnHi, (double)item_.getGauges_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_warnLo, (double)item_.getGauges_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitHi, (double)item_.getGauges_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)gauges_V_limitLo, (double)item_.getGauges_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnHi, (double)item_.getIon_Pumps_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_warnLo, (double)item_.getIon_Pumps_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitHi, (double)item_.getIon_Pumps_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_I_limitLo, (double)item_.getIon_Pumps_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnHi, (double)item_.getIon_Pumps_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_warnLo, (double)item_.getIon_Pumps_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitHi, (double)item_.getIon_Pumps_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ion_Pumps_V_limitLo, (double)item_.getIon_Pumps_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnHi, (double)item_.getPwr_Cry_HCU_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_warnLo, (double)item_.getPwr_Cry_HCU_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitHi, (double)item_.getPwr_Cry_HCU_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_I_limitLo, (double)item_.getPwr_Cry_HCU_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnHi, (double)item_.getPwr_Cry_HCU_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_warnLo, (double)item_.getPwr_Cry_HCU_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitHi, (double)item_.getPwr_Cry_HCU_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)pwr_Cry_HCU_V_limitLo, (double)item_.getPwr_Cry_HCU_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VC_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 869;
        int version = 682;
        int node = 374;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_24VC_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 476;
        int version = 490;
        double n_24vd_Board_T_warnHi = 0.5675011873245239;
        double n_24vd_Board_T_warnLo = 0.2477231f;
        double n_24vd_Board_T_limitHi = 0.6511227488517761;
        double n_24vd_Board_T_limitLo = 0.25721925497055054;
        double n_24vd_FPGA_T_warnHi = 0.053745925426483154;
        double n_24vd_FPGA_T_warnLo = 0.13506555557250977;
        double n_24vd_FPGA_T_limitHi = 0.5684199333190918;
        double n_24vd_FPGA_T_limitLo = 0.1792144775390625;
        double n_24vd_Main_I_warnHi = 0.420258f;
        double n_24vd_Main_I_warnLo = 0.24494272470474243;
        double n_24vd_Main_I_limitHi = 0.3861231803894043;
        double n_24vd_Main_I_limitLo = 0.47374796867370605;
        double n_24vd_Main_T_warnHi = 0.32380956411361694;
        double n_24vd_Main_T_warnLo = 0.34402942657470703;
        double n_24vd_Main_T_limitHi = 0.40112733840942383;
        double n_24vd_Main_T_limitLo = 0.4736320972442627;
        double n_24vd_Main_V_warnHi = 0.6918114423751831;
        double n_24vd_Main_V_warnLo = 0.963251531124115;
        double n_24vd_Main_V_limitHi = 0.18191653490066528;
        double n_24vd_Main_V_limitLo = 0.16838771104812622;
        double cryo_Turbo_I_warnHi = 0.9623038172721863;
        double cryo_Turbo_I_warnLo = 0.15011334419250488;
        double cryo_Turbo_I_limitHi = 0.48530107736587524;
        double cryo_Turbo_I_limitLo = 0.4137721657752991;
        double cryo_Turbo_V_warnHi = 0.0766598f;
        double cryo_Turbo_V_warnLo = 0.7253578305244446;
        double cryo_Turbo_V_limitHi = 0.1221545934677124;
        double cryo_Turbo_V_limitLo = 0.779416024684906;
        double hex_Turbo_I_warnHi = 0.2768756151199341;
        double hex_Turbo_I_warnLo = 0.4441349506378174;
        double hex_Turbo_I_limitHi = 0.5148841738700867;
        double hex_Turbo_I_limitLo = 0.00691455602645874;
        double hex_Turbo_V_warnHi = 0.5889905095100403;
        double hex_Turbo_V_warnLo = 0.862678587436676;
        double hex_Turbo_V_limitHi = 0.759788f;
        double hex_Turbo_V_limitLo = 0.24051225185394287;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_LimitsSettingsAppliedEvent(priority, version, n_24vd_Board_T_warnHi, n_24vd_Board_T_warnLo, n_24vd_Board_T_limitHi, n_24vd_Board_T_limitLo, n_24vd_FPGA_T_warnHi, n_24vd_FPGA_T_warnLo, n_24vd_FPGA_T_limitHi, n_24vd_FPGA_T_limitLo, n_24vd_Main_I_warnHi, n_24vd_Main_I_warnLo, n_24vd_Main_I_limitHi, n_24vd_Main_I_limitLo, n_24vd_Main_T_warnHi, n_24vd_Main_T_warnLo, n_24vd_Main_T_limitHi, n_24vd_Main_T_limitLo, n_24vd_Main_V_warnHi, n_24vd_Main_V_warnLo, n_24vd_Main_V_limitHi, n_24vd_Main_V_limitLo, cryo_Turbo_I_warnHi, cryo_Turbo_I_warnLo, cryo_Turbo_I_limitHi, cryo_Turbo_I_limitLo, cryo_Turbo_V_warnHi, cryo_Turbo_V_warnLo, cryo_Turbo_V_limitHi, cryo_Turbo_V_limitLo, hex_Turbo_I_warnHi, hex_Turbo_I_warnLo, hex_Turbo_I_limitHi, hex_Turbo_I_limitLo, hex_Turbo_V_warnHi, hex_Turbo_V_warnLo, hex_Turbo_V_limitHi, hex_Turbo_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_LimitsSettingsAppliedEvent));
        Quadbox_PDU_24VD_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_24VD_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)n_24vd_Board_T_warnHi, (double)item_.getN_24vd_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_warnLo, (double)item_.getN_24vd_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_limitHi, (double)item_.getN_24vd_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Board_T_limitLo, (double)item_.getN_24vd_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_warnHi, (double)item_.getN_24vd_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_warnLo, (double)item_.getN_24vd_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_limitHi, (double)item_.getN_24vd_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_FPGA_T_limitLo, (double)item_.getN_24vd_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_warnHi, (double)item_.getN_24vd_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_warnLo, (double)item_.getN_24vd_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_limitHi, (double)item_.getN_24vd_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_I_limitLo, (double)item_.getN_24vd_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_warnHi, (double)item_.getN_24vd_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_warnLo, (double)item_.getN_24vd_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_limitHi, (double)item_.getN_24vd_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_T_limitLo, (double)item_.getN_24vd_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_warnHi, (double)item_.getN_24vd_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_warnLo, (double)item_.getN_24vd_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_limitHi, (double)item_.getN_24vd_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_24vd_Main_V_limitLo, (double)item_.getN_24vd_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnHi, (double)item_.getCryo_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_warnLo, (double)item_.getCryo_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitHi, (double)item_.getCryo_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_I_limitLo, (double)item_.getCryo_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnHi, (double)item_.getCryo_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_warnLo, (double)item_.getCryo_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitHi, (double)item_.getCryo_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cryo_Turbo_V_limitLo, (double)item_.getCryo_Turbo_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnHi, (double)item_.getHex_Turbo_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_warnLo, (double)item_.getHex_Turbo_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitHi, (double)item_.getHex_Turbo_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_I_limitLo, (double)item_.getHex_Turbo_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnHi, (double)item_.getHex_Turbo_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_warnLo, (double)item_.getHex_Turbo_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitHi, (double)item_.getHex_Turbo_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hex_Turbo_V_limitLo, (double)item_.getHex_Turbo_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_24VD_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 235;
        int version = 811;
        int node = 53;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_24VD_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 106;
        int version = 546;
        double n_48v_Board_T_warnHi = 0.4779793620109558;
        double n_48v_Board_T_warnLo = 0.15224981307983398;
        double n_48v_Board_T_limitHi = 0.10457044839859009;
        double n_48v_Board_T_limitLo = 0.7497748136520386;
        double n_48v_FPGA_T_warnHi = 0.1686194f;
        double n_48v_FPGA_T_warnLo = 0.30979394912719727;
        double n_48v_FPGA_T_limitHi = 0.21112632751464844;
        double n_48v_FPGA_T_limitLo = 0.3359434f;
        double n_48v_Main_I_warnHi = 0.147347092628479;
        double n_48v_Main_I_warnLo = 0.9024807214736938;
        double n_48v_Main_I_limitHi = 0.9873150587081909;
        double n_48v_Main_I_limitLo = 0.7804882526397705;
        double n_48v_Main_T_warnHi = 0.21205365657806396;
        double n_48v_Main_T_warnLo = 0.19770705699920654;
        double n_48v_Main_T_limitHi = 0.0017998814582824707;
        double n_48v_Main_T_limitLo = 0.893978476524353;
        double n_48v_Main_V_warnHi = 0.5026865005493164;
        double n_48v_Main_V_warnLo = 0.2176659107208252;
        double n_48v_Main_V_limitHi = 0.6090694069862366;
        double n_48v_Main_V_limitLo = 0.9734766483306885;
        double purge_Fan_I_warnHi = 0.8928537964820862;
        double purge_Fan_I_warnLo = 0.0497211217880249;
        double purge_Fan_I_limitHi = 0.2681116461753845;
        double purge_Fan_I_limitLo = 0.529084324836731;
        double purge_Fan_V_warnHi = 0.05878615379333496;
        double purge_Fan_V_warnLo = 0.5883772969245911;
        double purge_Fan_V_limitHi = 0.6124424338340759;
        double purge_Fan_V_limitLo = 0.928119f;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_LimitsSettingsAppliedEvent(priority, version, n_48v_Board_T_warnHi, n_48v_Board_T_warnLo, n_48v_Board_T_limitHi, n_48v_Board_T_limitLo, n_48v_FPGA_T_warnHi, n_48v_FPGA_T_warnLo, n_48v_FPGA_T_limitHi, n_48v_FPGA_T_limitLo, n_48v_Main_I_warnHi, n_48v_Main_I_warnLo, n_48v_Main_I_limitHi, n_48v_Main_I_limitLo, n_48v_Main_T_warnHi, n_48v_Main_T_warnLo, n_48v_Main_T_limitHi, n_48v_Main_T_limitLo, n_48v_Main_V_warnHi, n_48v_Main_V_warnLo, n_48v_Main_V_limitHi, n_48v_Main_V_limitLo, purge_Fan_I_warnHi, purge_Fan_I_warnLo, purge_Fan_I_limitHi, purge_Fan_I_limitLo, purge_Fan_V_warnHi, purge_Fan_V_warnLo, purge_Fan_V_limitHi, purge_Fan_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_LimitsSettingsAppliedEvent));
        Quadbox_PDU_48V_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_48V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)n_48v_Board_T_warnHi, (double)item_.getN_48v_Board_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_warnLo, (double)item_.getN_48v_Board_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_limitHi, (double)item_.getN_48v_Board_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Board_T_limitLo, (double)item_.getN_48v_Board_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_warnHi, (double)item_.getN_48v_FPGA_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_warnLo, (double)item_.getN_48v_FPGA_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_limitHi, (double)item_.getN_48v_FPGA_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_FPGA_T_limitLo, (double)item_.getN_48v_FPGA_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_warnHi, (double)item_.getN_48v_Main_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_warnLo, (double)item_.getN_48v_Main_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_limitHi, (double)item_.getN_48v_Main_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_I_limitLo, (double)item_.getN_48v_Main_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_warnHi, (double)item_.getN_48v_Main_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_warnLo, (double)item_.getN_48v_Main_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_limitHi, (double)item_.getN_48v_Main_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_T_limitLo, (double)item_.getN_48v_Main_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_warnHi, (double)item_.getN_48v_Main_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_warnLo, (double)item_.getN_48v_Main_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_limitHi, (double)item_.getN_48v_Main_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)n_48v_Main_V_limitLo, (double)item_.getN_48v_Main_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnHi, (double)item_.getPurge_Fan_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_warnLo, (double)item_.getPurge_Fan_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitHi, (double)item_.getPurge_Fan_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_I_limitLo, (double)item_.getPurge_Fan_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnHi, (double)item_.getPurge_Fan_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_warnLo, (double)item_.getPurge_Fan_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitHi, (double)item_.getPurge_Fan_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)purge_Fan_V_limitLo, (double)item_.getPurge_Fan_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_48V_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 568;
        int version = 25;
        int node = 478;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_48V_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_48V_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_48V_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_48V_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 757;
        int version = 558;
        double otm_0_A_I_warnHi = 0.937881f;
        double otm_0_A_I_warnLo = 0.7643618583679199;
        double otm_0_A_I_limitHi = 0.35663992166519165;
        double otm_0_A_I_limitLo = 0.7248210906982422;
        double otm_0_A_V_warnHi = 0.00886458158493042;
        double otm_0_A_V_warnLo = 0.8635683059692383;
        double otm_0_A_V_limitHi = 0.525514f;
        double otm_0_A_V_limitLo = 0.4517327547073364;
        double otm_0_B_I_warnHi = 0.9946938753128052;
        double otm_0_B_I_warnLo = 0.11279827356338501;
        double otm_0_B_I_limitHi = 0.8843053579330444;
        double otm_0_B_I_limitLo = 0.9963942170143127;
        double otm_0_B_V_warnHi = 0.4767602f;
        double otm_0_B_V_warnLo = 0.7324386835098267;
        double otm_0_B_V_limitHi = 0.0687408447265625;
        double otm_0_B_V_limitLo = 0.14175671339035034;
        double otm_1_A_I_warnHi = 0.2010408f;
        double otm_1_A_I_warnLo = 0.16168522834777832;
        double otm_1_A_I_limitHi = 0.02596902847290039;
        double otm_1_A_I_limitLo = 0.35271936655044556;
        double otm_1_A_V_warnHi = 0.522193193435669;
        double otm_1_A_V_warnLo = 0.05116891860961914;
        double otm_1_A_V_limitHi = 0.8524715900421143;
        double otm_1_A_V_limitLo = 0.677761971950531;
        double otm_1_B_I_warnHi = 0.6856864094734192;
        double otm_1_B_I_warnLo = 0.15195822715759277;
        double otm_1_B_I_limitHi = 0.7192482352256775;
        double otm_1_B_I_limitLo = 0.8364443778991699;
        double otm_1_B_V_warnHi = 0.161748468875885;
        double otm_1_B_V_warnLo = 0.6321895122528076;
        double otm_1_B_V_limitHi = 0.10460102558135986;
        double otm_1_B_V_limitLo = 0.7797408103942871;
        double otm_2_A_I_warnHi = 0.7016832828521729;
        double otm_2_A_I_warnLo = 0.0922970175743103;
        double otm_2_A_I_limitHi = 0.8619933128356934;
        double otm_2_A_I_limitLo = 0.3623538017272949;
        double otm_2_A_V_warnHi = 0.33647865056991577;
        double otm_2_A_V_warnLo = 0.10063028335571289;
        double otm_2_A_V_limitHi = 0.710841f;
        double otm_2_A_V_limitLo = 0.6896804571151733;
        double otm_2_B_I_warnHi = 0.4579014182090759;
        double otm_2_B_I_warnLo = 0.2700703740119934;
        double otm_2_B_I_limitHi = 0.27534347772598267;
        double otm_2_B_I_limitLo = 0.5729556679725647;
        double otm_2_B_V_warnHi = 0.8949098587036133;
        double otm_2_B_V_warnLo = 0.7206348180770874;
        double otm_2_B_V_limitHi = 0.8623384237289429;
        double otm_2_B_V_limitLo = 0.4858793616294861;
        double otm_3_A_I_warnHi = 0.45777201652526855;
        double otm_3_A_I_warnLo = 0.5911467671394348;
        double otm_3_A_I_limitHi = 0.393549382686615;
        double otm_3_A_I_limitLo = 0.6219715476036072;
        double otm_3_A_V_warnHi = 0.40645831823349;
        double otm_3_A_V_warnLo = 0.0836363434791565;
        double otm_3_A_V_limitHi = 0.748494029045105;
        double otm_3_A_V_limitLo = 0.5268413424491882;
        double otm_3_B_I_warnHi = 0.29950016736984253;
        double otm_3_B_I_warnLo = 0.24664908647537231;
        double otm_3_B_I_limitHi = 0.767871618270874;
        double otm_3_B_I_limitLo = 0.2619808316230774;
        double otm_3_B_V_warnHi = 0.48851585388183594;
        double otm_3_B_V_warnLo = 0.3681f;
        double otm_3_B_V_limitHi = 0.177703857421875;
        double otm_3_B_V_limitLo = 0.8507076501846313;
        double otm_4_A_I_warnHi = 0.3890703320503235;
        double otm_4_A_I_warnLo = 0.8853934407234192;
        double otm_4_A_I_limitHi = 0.16424894332885742;
        double otm_4_A_I_limitLo = 0.582197368144989;
        double otm_4_A_V_warnHi = 0.5306582450866699;
        double otm_4_A_V_warnLo = 0.2015218734741211;
        double otm_4_A_V_limitHi = 0.5292513370513916;
        double otm_4_A_V_limitLo = 0.5915347337722778;
        double otm_4_B_I_warnHi = 0.17069f;
        double otm_4_B_I_warnLo = 0.6826686859130859;
        double otm_4_B_I_limitHi = 0.6330636143684387;
        double otm_4_B_I_limitLo = 0.49333226680755615;
        double otm_4_B_V_warnHi = 0.05587393045425415;
        double otm_4_B_V_warnLo = 0.5080180764198303;
        double otm_4_B_V_limitHi = 0.3663373f;
        double otm_4_B_V_limitLo = 0.9903306365013123;
        double otm_5_A_I_warnHi = 0.28888654708862305;
        double otm_5_A_I_warnLo = 0.43917596340179443;
        double otm_5_A_I_limitHi = 0.4342119097709656;
        double otm_5_A_I_limitLo = 0.5887249112129211;
        double otm_5_A_V_warnHi = 0.47140854597091675;
        double otm_5_A_V_warnLo = 0.10862231254577637;
        double otm_5_A_V_limitHi = 0.3732417821884155;
        double otm_5_A_V_limitLo = 0.376612f;
        double otm_5_B_I_warnHi = 0.562292f;
        double otm_5_B_I_warnLo = 0.11836177110671997;
        double otm_5_B_I_limitHi = 0.11182254552841187;
        double otm_5_B_I_limitLo = 0.32439786195755005;
        double otm_5_B_V_warnHi = 0.630763053894043;
        double otm_5_B_V_warnLo = 0.2564527988433838;
        double otm_5_B_V_limitHi = 0.018869996070861816;
        double otm_5_B_V_limitLo = 0.5753469467163086;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_LimitsSettingsAppliedEvent(priority, version, otm_0_A_I_warnHi, otm_0_A_I_warnLo, otm_0_A_I_limitHi, otm_0_A_I_limitLo, otm_0_A_V_warnHi, otm_0_A_V_warnLo, otm_0_A_V_limitHi, otm_0_A_V_limitLo, otm_0_B_I_warnHi, otm_0_B_I_warnLo, otm_0_B_I_limitHi, otm_0_B_I_limitLo, otm_0_B_V_warnHi, otm_0_B_V_warnLo, otm_0_B_V_limitHi, otm_0_B_V_limitLo, otm_1_A_I_warnHi, otm_1_A_I_warnLo, otm_1_A_I_limitHi, otm_1_A_I_limitLo, otm_1_A_V_warnHi, otm_1_A_V_warnLo, otm_1_A_V_limitHi, otm_1_A_V_limitLo, otm_1_B_I_warnHi, otm_1_B_I_warnLo, otm_1_B_I_limitHi, otm_1_B_I_limitLo, otm_1_B_V_warnHi, otm_1_B_V_warnLo, otm_1_B_V_limitHi, otm_1_B_V_limitLo, otm_2_A_I_warnHi, otm_2_A_I_warnLo, otm_2_A_I_limitHi, otm_2_A_I_limitLo, otm_2_A_V_warnHi, otm_2_A_V_warnLo, otm_2_A_V_limitHi, otm_2_A_V_limitLo, otm_2_B_I_warnHi, otm_2_B_I_warnLo, otm_2_B_I_limitHi, otm_2_B_I_limitLo, otm_2_B_V_warnHi, otm_2_B_V_warnLo, otm_2_B_V_limitHi, otm_2_B_V_limitLo, otm_3_A_I_warnHi, otm_3_A_I_warnLo, otm_3_A_I_limitHi, otm_3_A_I_limitLo, otm_3_A_V_warnHi, otm_3_A_V_warnLo, otm_3_A_V_limitHi, otm_3_A_V_limitLo, otm_3_B_I_warnHi, otm_3_B_I_warnLo, otm_3_B_I_limitHi, otm_3_B_I_limitLo, otm_3_B_V_warnHi, otm_3_B_V_warnLo, otm_3_B_V_limitHi, otm_3_B_V_limitLo, otm_4_A_I_warnHi, otm_4_A_I_warnLo, otm_4_A_I_limitHi, otm_4_A_I_limitLo, otm_4_A_V_warnHi, otm_4_A_V_warnLo, otm_4_A_V_limitHi, otm_4_A_V_limitLo, otm_4_B_I_warnHi, otm_4_B_I_warnLo, otm_4_B_I_limitHi, otm_4_B_I_limitLo, otm_4_B_V_warnHi, otm_4_B_V_warnLo, otm_4_B_V_limitHi, otm_4_B_V_limitLo, otm_5_A_I_warnHi, otm_5_A_I_warnLo, otm_5_A_I_limitHi, otm_5_A_I_limitLo, otm_5_A_V_warnHi, otm_5_A_V_warnLo, otm_5_A_V_limitHi, otm_5_A_V_limitLo, otm_5_B_I_warnHi, otm_5_B_I_warnLo, otm_5_B_I_limitHi, otm_5_B_I_limitLo, otm_5_B_V_warnHi, otm_5_B_V_warnLo, otm_5_B_V_limitHi, otm_5_B_V_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_LimitsSettingsAppliedEvent));
        Quadbox_PDU_5V_LimitsSettingsAppliedEvent item_ = (Quadbox_PDU_5V_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)otm_0_A_I_warnHi, (double)item_.getOtm_0_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_warnLo, (double)item_.getOtm_0_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitHi, (double)item_.getOtm_0_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_I_limitLo, (double)item_.getOtm_0_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnHi, (double)item_.getOtm_0_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_warnLo, (double)item_.getOtm_0_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitHi, (double)item_.getOtm_0_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_A_V_limitLo, (double)item_.getOtm_0_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnHi, (double)item_.getOtm_0_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_warnLo, (double)item_.getOtm_0_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitHi, (double)item_.getOtm_0_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_I_limitLo, (double)item_.getOtm_0_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnHi, (double)item_.getOtm_0_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_warnLo, (double)item_.getOtm_0_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitHi, (double)item_.getOtm_0_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_0_B_V_limitLo, (double)item_.getOtm_0_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnHi, (double)item_.getOtm_1_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_warnLo, (double)item_.getOtm_1_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitHi, (double)item_.getOtm_1_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_I_limitLo, (double)item_.getOtm_1_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnHi, (double)item_.getOtm_1_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_warnLo, (double)item_.getOtm_1_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitHi, (double)item_.getOtm_1_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_A_V_limitLo, (double)item_.getOtm_1_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnHi, (double)item_.getOtm_1_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_warnLo, (double)item_.getOtm_1_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitHi, (double)item_.getOtm_1_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_I_limitLo, (double)item_.getOtm_1_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnHi, (double)item_.getOtm_1_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_warnLo, (double)item_.getOtm_1_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitHi, (double)item_.getOtm_1_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_1_B_V_limitLo, (double)item_.getOtm_1_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnHi, (double)item_.getOtm_2_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_warnLo, (double)item_.getOtm_2_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitHi, (double)item_.getOtm_2_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_I_limitLo, (double)item_.getOtm_2_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnHi, (double)item_.getOtm_2_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_warnLo, (double)item_.getOtm_2_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitHi, (double)item_.getOtm_2_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_A_V_limitLo, (double)item_.getOtm_2_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnHi, (double)item_.getOtm_2_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_warnLo, (double)item_.getOtm_2_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitHi, (double)item_.getOtm_2_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_I_limitLo, (double)item_.getOtm_2_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnHi, (double)item_.getOtm_2_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_warnLo, (double)item_.getOtm_2_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitHi, (double)item_.getOtm_2_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_2_B_V_limitLo, (double)item_.getOtm_2_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnHi, (double)item_.getOtm_3_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_warnLo, (double)item_.getOtm_3_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitHi, (double)item_.getOtm_3_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_I_limitLo, (double)item_.getOtm_3_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnHi, (double)item_.getOtm_3_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_warnLo, (double)item_.getOtm_3_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitHi, (double)item_.getOtm_3_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_A_V_limitLo, (double)item_.getOtm_3_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnHi, (double)item_.getOtm_3_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_warnLo, (double)item_.getOtm_3_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitHi, (double)item_.getOtm_3_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_I_limitLo, (double)item_.getOtm_3_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnHi, (double)item_.getOtm_3_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_warnLo, (double)item_.getOtm_3_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitHi, (double)item_.getOtm_3_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_3_B_V_limitLo, (double)item_.getOtm_3_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnHi, (double)item_.getOtm_4_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_warnLo, (double)item_.getOtm_4_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitHi, (double)item_.getOtm_4_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_I_limitLo, (double)item_.getOtm_4_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnHi, (double)item_.getOtm_4_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_warnLo, (double)item_.getOtm_4_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitHi, (double)item_.getOtm_4_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_A_V_limitLo, (double)item_.getOtm_4_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnHi, (double)item_.getOtm_4_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_warnLo, (double)item_.getOtm_4_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitHi, (double)item_.getOtm_4_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_I_limitLo, (double)item_.getOtm_4_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnHi, (double)item_.getOtm_4_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_warnLo, (double)item_.getOtm_4_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitHi, (double)item_.getOtm_4_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_4_B_V_limitLo, (double)item_.getOtm_4_B_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnHi, (double)item_.getOtm_5_A_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_warnLo, (double)item_.getOtm_5_A_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitHi, (double)item_.getOtm_5_A_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_I_limitLo, (double)item_.getOtm_5_A_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnHi, (double)item_.getOtm_5_A_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_warnLo, (double)item_.getOtm_5_A_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitHi, (double)item_.getOtm_5_A_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_A_V_limitLo, (double)item_.getOtm_5_A_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnHi, (double)item_.getOtm_5_B_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_warnLo, (double)item_.getOtm_5_B_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitHi, (double)item_.getOtm_5_B_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_I_limitLo, (double)item_.getOtm_5_B_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnHi, (double)item_.getOtm_5_B_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_warnLo, (double)item_.getOtm_5_B_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitHi, (double)item_.getOtm_5_B_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)otm_5_B_V_limitLo, (double)item_.getOtm_5_B_V_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_PDU_5V_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 798;
        int version = 786;
        int node = 330;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PDU_5V_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PDU_5V_QuadboxSettingsAppliedEvent));
        Quadbox_PDU_5V_QuadboxSettingsAppliedEvent item_ = (Quadbox_PDU_5V_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 684;
        int version = 6;
        int schedulers_default_nTasks = 358;
        int schedulers_default_nThreads = 422;
        int schedulers_monitor_update_publish_scheduler_nTasks = 378;
        int schedulers_monitor_update_publish_scheduler_nThreads = 522;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasksSettingsAppliedEvent));
        Quadbox_PeriodicTasksSettingsAppliedEvent item_ = (Quadbox_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveQuadbox_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 595;
        int version = 262;
        long agentmonitorservice_taskPeriodMillis = 382L;
        long heartbeat_taskPeriodMillis = 657L;
        long monitor_check_taskPeriodMillis = 93L;
        long monitor_publish_taskPeriodMillis = 900L;
        long monitor_update_taskPeriodMillis = 435L;
        long runtimeinfo_taskPeriodMillis = 560L;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Quadbox_PeriodicTasks_timersSettingsAppliedEvent));
        Quadbox_PeriodicTasks_timersSettingsAppliedEvent item_ = (Quadbox_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 631;
        int version = 929;
        double rebbulkps_0_2_I_warnHi = 0.5955008864402771;
        double rebbulkps_0_2_I_warnLo = 0.18658453226089478;
        double rebbulkps_0_2_I_limitHi = 0.3638281226158142;
        double rebbulkps_0_2_I_limitLo = 0.6111805438995361;
        double rebbulkps_0_2_T_warnHi = 0.5877537727355957;
        double rebbulkps_0_2_T_warnLo = 0.22770464420318604;
        double rebbulkps_0_2_T_limitHi = 0.08397293090820312;
        double rebbulkps_0_2_T_limitLo = 0.705195426940918;
        double rebbulkps_0_2_V_warnHi = 0.5745881199836731;
        double rebbulkps_0_2_V_warnLo = 0.3399214f;
        double rebbulkps_0_2_V_limitHi = 0.2192559838294983;
        double rebbulkps_0_2_V_limitLo = 0.6262549161911011;
        double rebbulkps_3_5_I_warnHi = 0.3666437268257141;
        double rebbulkps_3_5_I_warnLo = 0.45988816022872925;
        double rebbulkps_3_5_I_limitHi = 0.6296939253807068;
        double rebbulkps_3_5_I_limitLo = 0.040489912033081055;
        double rebbulkps_3_5_T_warnHi = 0.45842164754867554;
        double rebbulkps_3_5_T_warnLo = 0.8041380643844604;
        double rebbulkps_3_5_T_limitHi = 0.963213324546814;
        double rebbulkps_3_5_T_limitLo = 0.4553758502006531;
        double rebbulkps_3_5_V_warnHi = 0.2713279128074646;
        double rebbulkps_3_5_V_warnLo = 0.947884738445282;
        double rebbulkps_3_5_V_limitHi = 0.0288409f;
        double rebbulkps_3_5_V_limitLo = 0.39329564571380615;
        double rebbulkps_6_8_I_warnHi = 0.22851771116256714;
        double rebbulkps_6_8_I_warnLo = 0.21255344152450562;
        double rebbulkps_6_8_I_limitHi = 0.011912405490875244;
        double rebbulkps_6_8_I_limitLo = 0.5514242649078369;
        double rebbulkps_6_8_T_warnHi = 0.6508852243423462;
        double rebbulkps_6_8_T_warnLo = 0.568288266658783;
        double rebbulkps_6_8_T_limitHi = 0.637826144695282;
        double rebbulkps_6_8_T_limitLo = 0.09007900953292847;
        double rebbulkps_6_8_V_warnHi = 0.8701666593551636;
        double rebbulkps_6_8_V_warnLo = 0.36637115478515625;
        double rebbulkps_6_8_V_limitHi = 0.03323858976364136;
        double rebbulkps_6_8_V_limitLo = 0.8563101887702942;
        double rebbulkps_9_12_I_warnHi = 0.8666839003562927;
        double rebbulkps_9_12_I_warnLo = 0.45781224966049194;
        double rebbulkps_9_12_I_limitHi = 0.3513185381889343;
        double rebbulkps_9_12_I_limitLo = 0.4714767336845398;
        double rebbulkps_9_12_T_warnHi = 0.46924442052841187;
        double rebbulkps_9_12_T_warnLo = 0.2972654700279236;
        double rebbulkps_9_12_T_limitHi = 0.6357949376106262;
        double rebbulkps_9_12_T_limitLo = 0.5301083922386169;
        double rebbulkps_9_12_V_warnHi = 0.7822174429893494;
        double rebbulkps_9_12_V_warnLo = 0.5979655385017395;
        double rebbulkps_9_12_V_limitHi = 0.7027034163475037;
        double rebbulkps_9_12_V_limitLo = 0.9898995161056519;
        double rebbulkps_Brd_T_warnHi = 0.12456047534942627;
        double rebbulkps_Brd_T_warnLo = 0.8187646269798279;
        double rebbulkps_Brd_T_limitHi = 0.4652571678161621;
        double rebbulkps_Brd_T_limitLo = 0.3246997594833374;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_LimitsSettingsAppliedEvent(priority, version, rebbulkps_0_2_I_warnHi, rebbulkps_0_2_I_warnLo, rebbulkps_0_2_I_limitHi, rebbulkps_0_2_I_limitLo, rebbulkps_0_2_T_warnHi, rebbulkps_0_2_T_warnLo, rebbulkps_0_2_T_limitHi, rebbulkps_0_2_T_limitLo, rebbulkps_0_2_V_warnHi, rebbulkps_0_2_V_warnLo, rebbulkps_0_2_V_limitHi, rebbulkps_0_2_V_limitLo, rebbulkps_3_5_I_warnHi, rebbulkps_3_5_I_warnLo, rebbulkps_3_5_I_limitHi, rebbulkps_3_5_I_limitLo, rebbulkps_3_5_T_warnHi, rebbulkps_3_5_T_warnLo, rebbulkps_3_5_T_limitHi, rebbulkps_3_5_T_limitLo, rebbulkps_3_5_V_warnHi, rebbulkps_3_5_V_warnLo, rebbulkps_3_5_V_limitHi, rebbulkps_3_5_V_limitLo, rebbulkps_6_8_I_warnHi, rebbulkps_6_8_I_warnLo, rebbulkps_6_8_I_limitHi, rebbulkps_6_8_I_limitLo, rebbulkps_6_8_T_warnHi, rebbulkps_6_8_T_warnLo, rebbulkps_6_8_T_limitHi, rebbulkps_6_8_T_limitLo, rebbulkps_6_8_V_warnHi, rebbulkps_6_8_V_warnLo, rebbulkps_6_8_V_limitHi, rebbulkps_6_8_V_limitLo, rebbulkps_9_12_I_warnHi, rebbulkps_9_12_I_warnLo, rebbulkps_9_12_I_limitHi, rebbulkps_9_12_I_limitLo, rebbulkps_9_12_T_warnHi, rebbulkps_9_12_T_warnLo, rebbulkps_9_12_T_limitHi, rebbulkps_9_12_T_limitLo, rebbulkps_9_12_V_warnHi, rebbulkps_9_12_V_warnLo, rebbulkps_9_12_V_limitHi, rebbulkps_9_12_V_limitLo, rebbulkps_Brd_T_warnHi, rebbulkps_Brd_T_warnLo, rebbulkps_Brd_T_limitHi, rebbulkps_Brd_T_limitLo));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_LimitsSettingsAppliedEvent));
        Quadbox_REB_Bulk_PS_LimitsSettingsAppliedEvent item_ = (Quadbox_REB_Bulk_PS_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)rebbulkps_0_2_I_warnHi, (double)item_.getRebbulkps_0_2_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_warnLo, (double)item_.getRebbulkps_0_2_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitHi, (double)item_.getRebbulkps_0_2_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_I_limitLo, (double)item_.getRebbulkps_0_2_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnHi, (double)item_.getRebbulkps_0_2_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_warnLo, (double)item_.getRebbulkps_0_2_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitHi, (double)item_.getRebbulkps_0_2_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_T_limitLo, (double)item_.getRebbulkps_0_2_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnHi, (double)item_.getRebbulkps_0_2_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_warnLo, (double)item_.getRebbulkps_0_2_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitHi, (double)item_.getRebbulkps_0_2_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_0_2_V_limitLo, (double)item_.getRebbulkps_0_2_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnHi, (double)item_.getRebbulkps_3_5_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_warnLo, (double)item_.getRebbulkps_3_5_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitHi, (double)item_.getRebbulkps_3_5_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_I_limitLo, (double)item_.getRebbulkps_3_5_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnHi, (double)item_.getRebbulkps_3_5_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_warnLo, (double)item_.getRebbulkps_3_5_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitHi, (double)item_.getRebbulkps_3_5_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_T_limitLo, (double)item_.getRebbulkps_3_5_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnHi, (double)item_.getRebbulkps_3_5_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_warnLo, (double)item_.getRebbulkps_3_5_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitHi, (double)item_.getRebbulkps_3_5_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_3_5_V_limitLo, (double)item_.getRebbulkps_3_5_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnHi, (double)item_.getRebbulkps_6_8_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_warnLo, (double)item_.getRebbulkps_6_8_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitHi, (double)item_.getRebbulkps_6_8_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_I_limitLo, (double)item_.getRebbulkps_6_8_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnHi, (double)item_.getRebbulkps_6_8_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_warnLo, (double)item_.getRebbulkps_6_8_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitHi, (double)item_.getRebbulkps_6_8_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_T_limitLo, (double)item_.getRebbulkps_6_8_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnHi, (double)item_.getRebbulkps_6_8_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_warnLo, (double)item_.getRebbulkps_6_8_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitHi, (double)item_.getRebbulkps_6_8_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_6_8_V_limitLo, (double)item_.getRebbulkps_6_8_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnHi, (double)item_.getRebbulkps_9_12_I_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_warnLo, (double)item_.getRebbulkps_9_12_I_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitHi, (double)item_.getRebbulkps_9_12_I_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_I_limitLo, (double)item_.getRebbulkps_9_12_I_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnHi, (double)item_.getRebbulkps_9_12_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_warnLo, (double)item_.getRebbulkps_9_12_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitHi, (double)item_.getRebbulkps_9_12_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_T_limitLo, (double)item_.getRebbulkps_9_12_T_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnHi, (double)item_.getRebbulkps_9_12_V_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_warnLo, (double)item_.getRebbulkps_9_12_V_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitHi, (double)item_.getRebbulkps_9_12_V_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_9_12_V_limitLo, (double)item_.getRebbulkps_9_12_V_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnHi, (double)item_.getRebbulkps_Brd_T_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_warnLo, (double)item_.getRebbulkps_Brd_T_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitHi, (double)item_.getRebbulkps_Brd_T_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)rebbulkps_Brd_T_limitLo, (double)item_.getRebbulkps_Brd_T_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveQuadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent() throws Exception {
        int priority = 686;
        int version = 467;
        int node = 331;
        SALEvent item = this.testSendReceive((SALEvent)new Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent));
        Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent item_ = (Quadbox_REB_Bulk_PS_QuadboxSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)node, (long)item_.getNode());
    }

    @Test
    public void sendReceiveRebpowerSettingsAppliedEvent() throws Exception {
        int priority = 298;
        int version = 998;
        long powerOffSleepMillis = 793L;
        SALEvent item = this.testSendReceive((SALEvent)new RebpowerSettingsAppliedEvent(priority, version, powerOffSleepMillis));
        Assert.assertTrue((boolean)(item instanceof RebpowerSettingsAppliedEvent));
        RebpowerSettingsAppliedEvent item_ = (RebpowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)powerOffSleepMillis, (long)item_.getPowerOffSleepMillis());
    }

    @Test
    public void sendReceiveRebpower_EmergencyResponseManagerSettingsAppliedEvent() throws Exception {
        int priority = 197;
        int version = 105;
        boolean processOnlyClearedAlerts = true;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_EmergencyResponseManagerSettingsAppliedEvent(priority, version, processOnlyClearedAlerts));
        Assert.assertTrue((boolean)(item instanceof Rebpower_EmergencyResponseManagerSettingsAppliedEvent));
        Rebpower_EmergencyResponseManagerSettingsAppliedEvent item_ = (Rebpower_EmergencyResponseManagerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)processOnlyClearedAlerts, (Object)item_.isProcessOnlyClearedAlerts());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 65;
        int version = 258;
        int schedulers_default_nTasks = 217;
        int schedulers_default_nThreads = 536;
        int schedulers_monitor_check_scheduler_nTasks = 875;
        int schedulers_monitor_check_scheduler_nThreads = 314;
        int schedulers_monitor_update_publish_scheduler_nTasks = 97;
        int schedulers_monitor_update_publish_scheduler_nThreads = 634;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasksSettingsAppliedEvent));
        Rebpower_PeriodicTasksSettingsAppliedEvent item_ = (Rebpower_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRebpower_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 647;
        int version = 461;
        long agentmonitorservice_taskPeriodMillis = 987L;
        long heartbeat_taskPeriodMillis = 277L;
        long monitor_check_RebPS_P00_taskPeriodMillis = 806L;
        long monitor_check_RebPS_P01_taskPeriodMillis = 120L;
        long monitor_check_RebPS_P02_taskPeriodMillis = 865L;
        long monitor_check_RebPS_P03_taskPeriodMillis = 712L;
        long monitor_check_RebPS_P04_taskPeriodMillis = 3L;
        long monitor_check_RebPS_P05_taskPeriodMillis = 921L;
        long monitor_check_RebPS_P06_taskPeriodMillis = 614L;
        long monitor_check_RebPS_P07_taskPeriodMillis = 146L;
        long monitor_check_RebPS_P08_taskPeriodMillis = 796L;
        long monitor_check_RebPS_P09_taskPeriodMillis = 447L;
        long monitor_check_RebPS_P10_taskPeriodMillis = 407L;
        long monitor_check_RebPS_P11_taskPeriodMillis = 999L;
        long monitor_check_RebPS_P12_taskPeriodMillis = 799L;
        long monitor_publish_RebPS_P00_taskPeriodMillis = 243L;
        long monitor_publish_RebPS_P01_taskPeriodMillis = 100L;
        long monitor_publish_RebPS_P02_taskPeriodMillis = 2L;
        long monitor_publish_RebPS_P03_taskPeriodMillis = 219L;
        long monitor_publish_RebPS_P04_taskPeriodMillis = 635L;
        long monitor_publish_RebPS_P05_taskPeriodMillis = 663L;
        long monitor_publish_RebPS_P06_taskPeriodMillis = 648L;
        long monitor_publish_RebPS_P07_taskPeriodMillis = 4L;
        long monitor_publish_RebPS_P08_taskPeriodMillis = 133L;
        long monitor_publish_RebPS_P09_taskPeriodMillis = 784L;
        long monitor_publish_RebPS_P10_taskPeriodMillis = 397L;
        long monitor_publish_RebPS_P11_taskPeriodMillis = 10L;
        long monitor_publish_RebPS_P12_taskPeriodMillis = 441L;
        long monitor_update_RebPS_P00_taskPeriodMillis = 562L;
        long monitor_update_RebPS_P01_taskPeriodMillis = 56L;
        long monitor_update_RebPS_P02_taskPeriodMillis = 455L;
        long monitor_update_RebPS_P03_taskPeriodMillis = 223L;
        long monitor_update_RebPS_P04_taskPeriodMillis = 542L;
        long monitor_update_RebPS_P05_taskPeriodMillis = 89L;
        long monitor_update_RebPS_P06_taskPeriodMillis = 659L;
        long monitor_update_RebPS_P07_taskPeriodMillis = 719L;
        long monitor_update_RebPS_P08_taskPeriodMillis = 98L;
        long monitor_update_RebPS_P09_taskPeriodMillis = 484L;
        long monitor_update_RebPS_P10_taskPeriodMillis = 102L;
        long monitor_update_RebPS_P11_taskPeriodMillis = 647L;
        long monitor_update_RebPS_P12_taskPeriodMillis = 925L;
        long reb_power_state_taskPeriodMillis = 749L;
        long runtimeinfo_taskPeriodMillis = 249L;
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_RebPS_P00_taskPeriodMillis, monitor_check_RebPS_P01_taskPeriodMillis, monitor_check_RebPS_P02_taskPeriodMillis, monitor_check_RebPS_P03_taskPeriodMillis, monitor_check_RebPS_P04_taskPeriodMillis, monitor_check_RebPS_P05_taskPeriodMillis, monitor_check_RebPS_P06_taskPeriodMillis, monitor_check_RebPS_P07_taskPeriodMillis, monitor_check_RebPS_P08_taskPeriodMillis, monitor_check_RebPS_P09_taskPeriodMillis, monitor_check_RebPS_P10_taskPeriodMillis, monitor_check_RebPS_P11_taskPeriodMillis, monitor_check_RebPS_P12_taskPeriodMillis, monitor_publish_RebPS_P00_taskPeriodMillis, monitor_publish_RebPS_P01_taskPeriodMillis, monitor_publish_RebPS_P02_taskPeriodMillis, monitor_publish_RebPS_P03_taskPeriodMillis, monitor_publish_RebPS_P04_taskPeriodMillis, monitor_publish_RebPS_P05_taskPeriodMillis, monitor_publish_RebPS_P06_taskPeriodMillis, monitor_publish_RebPS_P07_taskPeriodMillis, monitor_publish_RebPS_P08_taskPeriodMillis, monitor_publish_RebPS_P09_taskPeriodMillis, monitor_publish_RebPS_P10_taskPeriodMillis, monitor_publish_RebPS_P11_taskPeriodMillis, monitor_publish_RebPS_P12_taskPeriodMillis, monitor_update_RebPS_P00_taskPeriodMillis, monitor_update_RebPS_P01_taskPeriodMillis, monitor_update_RebPS_P02_taskPeriodMillis, monitor_update_RebPS_P03_taskPeriodMillis, monitor_update_RebPS_P04_taskPeriodMillis, monitor_update_RebPS_P05_taskPeriodMillis, monitor_update_RebPS_P06_taskPeriodMillis, monitor_update_RebPS_P07_taskPeriodMillis, monitor_update_RebPS_P08_taskPeriodMillis, monitor_update_RebPS_P09_taskPeriodMillis, monitor_update_RebPS_P10_taskPeriodMillis, monitor_update_RebPS_P11_taskPeriodMillis, monitor_update_RebPS_P12_taskPeriodMillis, reb_power_state_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Rebpower_PeriodicTasks_timersSettingsAppliedEvent));
        Rebpower_PeriodicTasks_timersSettingsAppliedEvent item_ = (Rebpower_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_check_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_publish_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P00_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P00_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P01_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P01_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P02_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P02_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P03_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P03_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P04_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P04_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P05_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P05_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P06_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P06_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P07_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P07_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P08_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P08_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P09_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P09_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P10_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P10_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P11_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P11_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_RebPS_P12_taskPeriodMillis, (long)item_.getMonitor_update_RebPS_P12_taskPeriodMillis());
        Assert.assertEquals((long)reb_power_state_taskPeriodMillis, (long)item_.getReb_power_state_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRebpower_RebSettingsAppliedEvent() throws Exception {
        int priority = 687;
        int version = 193;
        int[] dphi = TestHelper.generateIntArray((int)71, (int)505719461);
        int[] hvBias = TestHelper.generateIntArray((int)71, (int)-1014717709);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_RebSettingsAppliedEvent(priority, version, dphi, hvBias, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_RebSettingsAppliedEvent));
        Rebpower_RebSettingsAppliedEvent item_ = (Rebpower_RebSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((int[])dphi, (int[])item_.getDphi());
        Assert.assertArrayEquals((int[])hvBias, (int[])item_.getHvBias());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Reb_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 110;
        int version = 704;
        double[] analog_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1307659566);
        double[] analog_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2043613561);
        double[] analog_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-779278081);
        double[] analog_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)87063612);
        double[] analog_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-580309562);
        double[] analog_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-585747698);
        double[] analog_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1882601063);
        double[] analog_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-990212484);
        double[] analog_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)901450197);
        double[] analog_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1205511172);
        double[] analog_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)726099078);
        double[] analog_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-694152508);
        double[] analog_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1021733199);
        double[] analog_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)452639809);
        double[] analog_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-16557242);
        double[] analog_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1300150858);
        double[] analog_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)313053182);
        double[] analog_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-99667053);
        double[] analog_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1873710749);
        double[] analog_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)818752792);
        double[] clockhi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2022901862);
        double[] clockhi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-755717078);
        double[] clockhi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1351882203);
        double[] clockhi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1863163354);
        double[] clockhi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1442777214);
        double[] clockhi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1913236938);
        double[] clockhi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1325408747);
        double[] clockhi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-379642281);
        double[] clockhi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1213903785);
        double[] clockhi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1041256910);
        double[] clockhi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-432489338);
        double[] clockhi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1674455259);
        double[] clockhi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)-541079858);
        double[] clockhi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1044989715);
        double[] clockhi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2031015317);
        double[] clockhi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-806907291);
        double[] clockhi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-867869713);
        double[] clockhi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1466961045);
        double[] clockhi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1384218240);
        double[] clockhi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-417195603);
        double[] clocklo_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)770681599);
        double[] clocklo_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1501721611);
        double[] clocklo_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)34053102);
        double[] clocklo_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)144925288);
        double[] clocklo_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-369095466);
        double[] clocklo_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1303409866);
        double[] clocklo_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2018185925);
        double[] clocklo_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-666705719);
        double[] clocklo_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1803822488);
        double[] clocklo_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-344785464);
        double[] clocklo_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)1599600791);
        double[] clocklo_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1177454261);
        double[] clocklo_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2014999751);
        double[] clocklo_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1334242273);
        double[] clocklo_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)2147116405);
        double[] clocklo_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)651483309);
        double[] clocklo_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1388627728);
        double[] clocklo_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1400398560);
        double[] clocklo_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-857651363);
        double[] clocklo_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-497956802);
        double[] clocklo_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)858873578);
        double[] clocklo_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1564192294);
        double[] clocklo_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)449233408);
        double[] clocklo_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1775173030);
        double[] digital_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)325083441);
        double[] digital_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1372397901);
        double[] digital_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1812028044);
        double[] digital_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1803662540);
        double[] digital_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1316076845);
        double[] digital_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-865855271);
        double[] digital_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1933669823);
        double[] digital_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1954140628);
        double[] digital_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)363866554);
        double[] digital_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1904905178);
        double[] digital_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)750478916);
        double[] digital_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)2087722339);
        double[] digital_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)861684539);
        double[] digital_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2038782702);
        double[] digital_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)2134864051);
        double[] digital_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)768412326);
        double[] digital_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-331934514);
        double[] digital_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)911422229);
        double[] digital_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)701163257);
        double[] digital_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1927111224);
        double[] dphi_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)596607169);
        double[] dphi_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)922425108);
        double[] dphi_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1328226658);
        double[] dphi_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1675318181);
        double[] dphi_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1713816509);
        double[] dphi_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)931014788);
        double[] dphi_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)347920369);
        double[] dphi_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-333012064);
        double[] dphi_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)185291358);
        double[] dphi_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)149040896);
        double[] dphi_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1942839409);
        double[] dphi_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1262948602);
        double[] dphi_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)862937636);
        double[] dphi_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1278678638);
        double[] dphi_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)780745161);
        double[] dphi_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1210596624);
        double[] dphi_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-429257688);
        double[] dphi_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1221344927);
        double[] dphi_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1745389420);
        double[] dphi_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1141551173);
        double[] heater_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1369947344);
        double[] heater_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)2044927422);
        double[] heater_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1637422863);
        double[] heater_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)272998655);
        double[] heater_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)371487784);
        double[] heater_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)33251233);
        double[] heater_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1487600022);
        double[] heater_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)2035461396);
        double[] heater_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)804370776);
        double[] heater_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1840481921);
        double[] heater_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1244412885);
        double[] heater_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-549234473);
        double[] heater_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)124423385);
        double[] heater_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)109678737);
        double[] heater_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-303184171);
        double[] heater_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-56069203);
        double[] heater_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)86224453);
        double[] heater_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1185808489);
        double[] heater_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-703913200);
        double[] heater_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)944697287);
        double[] hvbias_IbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1650143149);
        double[] hvbias_IbefSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)1341102309);
        double[] hvbias_IbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)1000437185);
        double[] hvbias_IbefSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)1724308135);
        double[] hvbias_VbefSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)1684463055);
        double[] hvbias_VbefSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1823706291);
        double[] hvbias_VbefSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)946117771);
        double[] hvbias_VbefSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-851256861);
        String location = "";
        double[] od_IaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)1392235446);
        double[] od_IaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-378012576);
        double[] od_IaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-814993367);
        double[] od_IaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)1072785543);
        double[] od_IbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-401186905);
        double[] od_IbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-799728293);
        double[] od_IbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-519860606);
        double[] od_IbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)-422118589);
        double[] od_VaftLDO2_warnHi = TestHelper.generateDoubleArray((int)71, (int)1865980670);
        double[] od_VaftLDO2_warnLo = TestHelper.generateDoubleArray((int)71, (int)710913997);
        double[] od_VaftLDO2_limitHi = TestHelper.generateDoubleArray((int)71, (int)-756599334);
        double[] od_VaftLDO2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1192020434);
        double[] od_VaftLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-19542252);
        double[] od_VaftLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)-619950443);
        double[] od_VaftLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)1436232895);
        double[] od_VaftLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)703977514);
        double[] od_VaftSwch_warnHi = TestHelper.generateDoubleArray((int)71, (int)2091892767);
        double[] od_VaftSwch_warnLo = TestHelper.generateDoubleArray((int)71, (int)-855600459);
        double[] od_VaftSwch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1980199575);
        double[] od_VaftSwch_limitLo = TestHelper.generateDoubleArray((int)71, (int)940320828);
        double[] od_VbefLDO_warnHi = TestHelper.generateDoubleArray((int)71, (int)-532032296);
        double[] od_VbefLDO_warnLo = TestHelper.generateDoubleArray((int)71, (int)1978158113);
        double[] od_VbefLDO_limitHi = TestHelper.generateDoubleArray((int)71, (int)-277532678);
        double[] od_VbefLDO_limitLo = TestHelper.generateDoubleArray((int)71, (int)839748735);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)1685361757);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)136639448);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1362807546);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)-899277734);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Reb_LimitsSettingsAppliedEvent(priority, version, analog_IaftLDO_warnHi, analog_IaftLDO_warnLo, analog_IaftLDO_limitHi, analog_IaftLDO_limitLo, analog_IbefLDO_warnHi, analog_IbefLDO_warnLo, analog_IbefLDO_limitHi, analog_IbefLDO_limitLo, analog_VaftLDO_warnHi, analog_VaftLDO_warnLo, analog_VaftLDO_limitHi, analog_VaftLDO_limitLo, analog_VaftSwch_warnHi, analog_VaftSwch_warnLo, analog_VaftSwch_limitHi, analog_VaftSwch_limitLo, analog_VbefLDO_warnHi, analog_VbefLDO_warnLo, analog_VbefLDO_limitHi, analog_VbefLDO_limitLo, clockhi_IaftLDO_warnHi, clockhi_IaftLDO_warnLo, clockhi_IaftLDO_limitHi, clockhi_IaftLDO_limitLo, clockhi_IbefLDO_warnHi, clockhi_IbefLDO_warnLo, clockhi_IbefLDO_limitHi, clockhi_IbefLDO_limitLo, clockhi_VaftLDO_warnHi, clockhi_VaftLDO_warnLo, clockhi_VaftLDO_limitHi, clockhi_VaftLDO_limitLo, clockhi_VaftSwch_warnHi, clockhi_VaftSwch_warnLo, clockhi_VaftSwch_limitHi, clockhi_VaftSwch_limitLo, clockhi_VbefLDO_warnHi, clockhi_VbefLDO_warnLo, clockhi_VbefLDO_limitHi, clockhi_VbefLDO_limitLo, clocklo_IaftLDO_warnHi, clocklo_IaftLDO_warnLo, clocklo_IaftLDO_limitHi, clocklo_IaftLDO_limitLo, clocklo_IbefLDO_warnHi, clocklo_IbefLDO_warnLo, clocklo_IbefLDO_limitHi, clocklo_IbefLDO_limitLo, clocklo_VaftLDO2_warnHi, clocklo_VaftLDO2_warnLo, clocklo_VaftLDO2_limitHi, clocklo_VaftLDO2_limitLo, clocklo_VaftLDO_warnHi, clocklo_VaftLDO_warnLo, clocklo_VaftLDO_limitHi, clocklo_VaftLDO_limitLo, clocklo_VaftSwch_warnHi, clocklo_VaftSwch_warnLo, clocklo_VaftSwch_limitHi, clocklo_VaftSwch_limitLo, clocklo_VbefLDO_warnHi, clocklo_VbefLDO_warnLo, clocklo_VbefLDO_limitHi, clocklo_VbefLDO_limitLo, digital_IaftLDO_warnHi, digital_IaftLDO_warnLo, digital_IaftLDO_limitHi, digital_IaftLDO_limitLo, digital_IbefLDO_warnHi, digital_IbefLDO_warnLo, digital_IbefLDO_limitHi, digital_IbefLDO_limitLo, digital_VaftLDO_warnHi, digital_VaftLDO_warnLo, digital_VaftLDO_limitHi, digital_VaftLDO_limitLo, digital_VaftSwch_warnHi, digital_VaftSwch_warnLo, digital_VaftSwch_limitHi, digital_VaftSwch_limitLo, digital_VbefLDO_warnHi, digital_VbefLDO_warnLo, digital_VbefLDO_limitHi, digital_VbefLDO_limitLo, dphi_IaftLDO_warnHi, dphi_IaftLDO_warnLo, dphi_IaftLDO_limitHi, dphi_IaftLDO_limitLo, dphi_IbefLDO_warnHi, dphi_IbefLDO_warnLo, dphi_IbefLDO_limitHi, dphi_IbefLDO_limitLo, dphi_VaftLDO_warnHi, dphi_VaftLDO_warnLo, dphi_VaftLDO_limitHi, dphi_VaftLDO_limitLo, dphi_VaftSwch_warnHi, dphi_VaftSwch_warnLo, dphi_VaftSwch_limitHi, dphi_VaftSwch_limitLo, dphi_VbefLDO_warnHi, dphi_VbefLDO_warnLo, dphi_VbefLDO_limitHi, dphi_VbefLDO_limitLo, heater_IaftLDO_warnHi, heater_IaftLDO_warnLo, heater_IaftLDO_limitHi, heater_IaftLDO_limitLo, heater_IbefLDO_warnHi, heater_IbefLDO_warnLo, heater_IbefLDO_limitHi, heater_IbefLDO_limitLo, heater_VaftLDO_warnHi, heater_VaftLDO_warnLo, heater_VaftLDO_limitHi, heater_VaftLDO_limitLo, heater_VaftSwch_warnHi, heater_VaftSwch_warnLo, heater_VaftSwch_limitHi, heater_VaftSwch_limitLo, heater_VbefLDO_warnHi, heater_VbefLDO_warnLo, heater_VbefLDO_limitHi, heater_VbefLDO_limitLo, hvbias_IbefSwch_warnHi, hvbias_IbefSwch_warnLo, hvbias_IbefSwch_limitHi, hvbias_IbefSwch_limitLo, hvbias_VbefSwch_warnHi, hvbias_VbefSwch_warnLo, hvbias_VbefSwch_limitHi, hvbias_VbefSwch_limitLo, location, od_IaftLDO_warnHi, od_IaftLDO_warnLo, od_IaftLDO_limitHi, od_IaftLDO_limitLo, od_IbefLDO_warnHi, od_IbefLDO_warnLo, od_IbefLDO_limitHi, od_IbefLDO_limitLo, od_VaftLDO2_warnHi, od_VaftLDO2_warnLo, od_VaftLDO2_limitHi, od_VaftLDO2_limitLo, od_VaftLDO_warnHi, od_VaftLDO_warnLo, od_VaftLDO_limitHi, od_VaftLDO_limitLo, od_VaftSwch_warnHi, od_VaftSwch_warnLo, od_VaftSwch_limitHi, od_VaftSwch_limitLo, od_VbefLDO_warnHi, od_VbefLDO_warnLo, od_VbefLDO_limitHi, od_VbefLDO_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Reb_LimitsSettingsAppliedEvent));
        Rebpower_Reb_LimitsSettingsAppliedEvent item_ = (Rebpower_Reb_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnHi, (double[])item_.getAnalog_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_warnLo, (double[])item_.getAnalog_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitHi, (double[])item_.getAnalog_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IaftLDO_limitLo, (double[])item_.getAnalog_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnHi, (double[])item_.getAnalog_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_warnLo, (double[])item_.getAnalog_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitHi, (double[])item_.getAnalog_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_IbefLDO_limitLo, (double[])item_.getAnalog_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnHi, (double[])item_.getAnalog_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_warnLo, (double[])item_.getAnalog_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitHi, (double[])item_.getAnalog_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftLDO_limitLo, (double[])item_.getAnalog_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnHi, (double[])item_.getAnalog_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_warnLo, (double[])item_.getAnalog_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitHi, (double[])item_.getAnalog_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VaftSwch_limitLo, (double[])item_.getAnalog_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnHi, (double[])item_.getAnalog_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_warnLo, (double[])item_.getAnalog_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitHi, (double[])item_.getAnalog_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])analog_VbefLDO_limitLo, (double[])item_.getAnalog_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnHi, (double[])item_.getClockhi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_warnLo, (double[])item_.getClockhi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitHi, (double[])item_.getClockhi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IaftLDO_limitLo, (double[])item_.getClockhi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnHi, (double[])item_.getClockhi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_warnLo, (double[])item_.getClockhi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitHi, (double[])item_.getClockhi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_IbefLDO_limitLo, (double[])item_.getClockhi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnHi, (double[])item_.getClockhi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_warnLo, (double[])item_.getClockhi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitHi, (double[])item_.getClockhi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftLDO_limitLo, (double[])item_.getClockhi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnHi, (double[])item_.getClockhi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_warnLo, (double[])item_.getClockhi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitHi, (double[])item_.getClockhi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VaftSwch_limitLo, (double[])item_.getClockhi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnHi, (double[])item_.getClockhi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_warnLo, (double[])item_.getClockhi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitHi, (double[])item_.getClockhi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clockhi_VbefLDO_limitLo, (double[])item_.getClockhi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnHi, (double[])item_.getClocklo_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_warnLo, (double[])item_.getClocklo_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitHi, (double[])item_.getClocklo_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IaftLDO_limitLo, (double[])item_.getClocklo_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnHi, (double[])item_.getClocklo_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_warnLo, (double[])item_.getClocklo_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitHi, (double[])item_.getClocklo_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_IbefLDO_limitLo, (double[])item_.getClocklo_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnHi, (double[])item_.getClocklo_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_warnLo, (double[])item_.getClocklo_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitHi, (double[])item_.getClocklo_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO2_limitLo, (double[])item_.getClocklo_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnHi, (double[])item_.getClocklo_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_warnLo, (double[])item_.getClocklo_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitHi, (double[])item_.getClocklo_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftLDO_limitLo, (double[])item_.getClocklo_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnHi, (double[])item_.getClocklo_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_warnLo, (double[])item_.getClocklo_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitHi, (double[])item_.getClocklo_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VaftSwch_limitLo, (double[])item_.getClocklo_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnHi, (double[])item_.getClocklo_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_warnLo, (double[])item_.getClocklo_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitHi, (double[])item_.getClocklo_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clocklo_VbefLDO_limitLo, (double[])item_.getClocklo_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnHi, (double[])item_.getDigital_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_warnLo, (double[])item_.getDigital_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitHi, (double[])item_.getDigital_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IaftLDO_limitLo, (double[])item_.getDigital_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnHi, (double[])item_.getDigital_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_warnLo, (double[])item_.getDigital_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitHi, (double[])item_.getDigital_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_IbefLDO_limitLo, (double[])item_.getDigital_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnHi, (double[])item_.getDigital_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_warnLo, (double[])item_.getDigital_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitHi, (double[])item_.getDigital_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftLDO_limitLo, (double[])item_.getDigital_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnHi, (double[])item_.getDigital_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_warnLo, (double[])item_.getDigital_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitHi, (double[])item_.getDigital_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VaftSwch_limitLo, (double[])item_.getDigital_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnHi, (double[])item_.getDigital_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_warnLo, (double[])item_.getDigital_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitHi, (double[])item_.getDigital_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digital_VbefLDO_limitLo, (double[])item_.getDigital_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnHi, (double[])item_.getDphi_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_warnLo, (double[])item_.getDphi_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitHi, (double[])item_.getDphi_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IaftLDO_limitLo, (double[])item_.getDphi_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnHi, (double[])item_.getDphi_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_warnLo, (double[])item_.getDphi_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitHi, (double[])item_.getDphi_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_IbefLDO_limitLo, (double[])item_.getDphi_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnHi, (double[])item_.getDphi_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_warnLo, (double[])item_.getDphi_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitHi, (double[])item_.getDphi_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftLDO_limitLo, (double[])item_.getDphi_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnHi, (double[])item_.getDphi_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_warnLo, (double[])item_.getDphi_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitHi, (double[])item_.getDphi_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VaftSwch_limitLo, (double[])item_.getDphi_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnHi, (double[])item_.getDphi_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_warnLo, (double[])item_.getDphi_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitHi, (double[])item_.getDphi_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dphi_VbefLDO_limitLo, (double[])item_.getDphi_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnHi, (double[])item_.getHeater_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_warnLo, (double[])item_.getHeater_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitHi, (double[])item_.getHeater_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IaftLDO_limitLo, (double[])item_.getHeater_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnHi, (double[])item_.getHeater_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_warnLo, (double[])item_.getHeater_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitHi, (double[])item_.getHeater_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_IbefLDO_limitLo, (double[])item_.getHeater_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnHi, (double[])item_.getHeater_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_warnLo, (double[])item_.getHeater_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitHi, (double[])item_.getHeater_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftLDO_limitLo, (double[])item_.getHeater_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnHi, (double[])item_.getHeater_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_warnLo, (double[])item_.getHeater_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitHi, (double[])item_.getHeater_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VaftSwch_limitLo, (double[])item_.getHeater_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnHi, (double[])item_.getHeater_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_warnLo, (double[])item_.getHeater_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitHi, (double[])item_.getHeater_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])heater_VbefLDO_limitLo, (double[])item_.getHeater_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnHi, (double[])item_.getHvbias_IbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_warnLo, (double[])item_.getHvbias_IbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitHi, (double[])item_.getHvbias_IbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_IbefSwch_limitLo, (double[])item_.getHvbias_IbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnHi, (double[])item_.getHvbias_VbefSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_warnLo, (double[])item_.getHvbias_VbefSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitHi, (double[])item_.getHvbias_VbefSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbias_VbefSwch_limitLo, (double[])item_.getHvbias_VbefSwch_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])od_IaftLDO_warnHi, (double[])item_.getOd_IaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_warnLo, (double[])item_.getOd_IaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitHi, (double[])item_.getOd_IaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IaftLDO_limitLo, (double[])item_.getOd_IaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnHi, (double[])item_.getOd_IbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_warnLo, (double[])item_.getOd_IbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitHi, (double[])item_.getOd_IbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_IbefLDO_limitLo, (double[])item_.getOd_IbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnHi, (double[])item_.getOd_VaftLDO2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_warnLo, (double[])item_.getOd_VaftLDO2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitHi, (double[])item_.getOd_VaftLDO2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO2_limitLo, (double[])item_.getOd_VaftLDO2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnHi, (double[])item_.getOd_VaftLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_warnLo, (double[])item_.getOd_VaftLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitHi, (double[])item_.getOd_VaftLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftLDO_limitLo, (double[])item_.getOd_VaftLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnHi, (double[])item_.getOd_VaftSwch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_warnLo, (double[])item_.getOd_VaftSwch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitHi, (double[])item_.getOd_VaftSwch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VaftSwch_limitLo, (double[])item_.getOd_VaftSwch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnHi, (double[])item_.getOd_VbefLDO_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_warnLo, (double[])item_.getOd_VbefLDO_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitHi, (double[])item_.getOd_VbefLDO_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])od_VbefLDO_limitLo, (double[])item_.getOd_VbefLDO_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRebpower_Rebps_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 43;
        int version = 644;
        double[] boardtemp0_warnHi = TestHelper.generateDoubleArray((int)13, (int)-1414777772);
        double[] boardtemp0_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1311006219);
        double[] boardtemp0_limitHi = TestHelper.generateDoubleArray((int)13, (int)1077313887);
        double[] boardtemp0_limitLo = TestHelper.generateDoubleArray((int)13, (int)925326478);
        double[] boardtemp1_warnHi = TestHelper.generateDoubleArray((int)13, (int)2045514726);
        double[] boardtemp1_warnLo = TestHelper.generateDoubleArray((int)13, (int)639418088);
        double[] boardtemp1_limitHi = TestHelper.generateDoubleArray((int)13, (int)2013467549);
        double[] boardtemp1_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1307455252);
        double[] boardtemp2_warnHi = TestHelper.generateDoubleArray((int)13, (int)328977206);
        double[] boardtemp2_warnLo = TestHelper.generateDoubleArray((int)13, (int)-2100221899);
        double[] boardtemp2_limitHi = TestHelper.generateDoubleArray((int)13, (int)56504754);
        double[] boardtemp2_limitLo = TestHelper.generateDoubleArray((int)13, (int)1673514815);
        double[] boardtemp3_warnHi = TestHelper.generateDoubleArray((int)13, (int)1393596098);
        double[] boardtemp3_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1545785992);
        double[] boardtemp3_limitHi = TestHelper.generateDoubleArray((int)13, (int)2132543447);
        double[] boardtemp3_limitLo = TestHelper.generateDoubleArray((int)13, (int)-1760192352);
        double[] boardtemp4_warnHi = TestHelper.generateDoubleArray((int)13, (int)-869769270);
        double[] boardtemp4_warnLo = TestHelper.generateDoubleArray((int)13, (int)-470155428);
        double[] boardtemp4_limitHi = TestHelper.generateDoubleArray((int)13, (int)-1099478714);
        double[] boardtemp4_limitLo = TestHelper.generateDoubleArray((int)13, (int)197809642);
        double[] boardtemp5_warnHi = TestHelper.generateDoubleArray((int)13, (int)-932422568);
        double[] boardtemp5_warnLo = TestHelper.generateDoubleArray((int)13, (int)-1897436847);
        double[] boardtemp5_limitHi = TestHelper.generateDoubleArray((int)13, (int)1627716056);
        double[] boardtemp5_limitLo = TestHelper.generateDoubleArray((int)13, (int)-242333044);
        double[] boardtemp6_warnHi = TestHelper.generateDoubleArray((int)13, (int)997141376);
        double[] boardtemp6_warnLo = TestHelper.generateDoubleArray((int)13, (int)-2121076101);
        double[] boardtemp6_limitHi = TestHelper.generateDoubleArray((int)13, (int)602451439);
        double[] boardtemp6_limitLo = TestHelper.generateDoubleArray((int)13, (int)182509727);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_LimitsSettingsAppliedEvent(priority, version, boardtemp0_warnHi, boardtemp0_warnLo, boardtemp0_limitHi, boardtemp0_limitLo, boardtemp1_warnHi, boardtemp1_warnLo, boardtemp1_limitHi, boardtemp1_limitLo, boardtemp2_warnHi, boardtemp2_warnLo, boardtemp2_limitHi, boardtemp2_limitLo, boardtemp3_warnHi, boardtemp3_warnLo, boardtemp3_limitHi, boardtemp3_limitLo, boardtemp4_warnHi, boardtemp4_warnLo, boardtemp4_limitHi, boardtemp4_limitLo, boardtemp5_warnHi, boardtemp5_warnLo, boardtemp5_limitHi, boardtemp5_limitLo, boardtemp6_warnHi, boardtemp6_warnLo, boardtemp6_limitHi, boardtemp6_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_LimitsSettingsAppliedEvent));
        Rebpower_Rebps_LimitsSettingsAppliedEvent item_ = (Rebpower_Rebps_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])boardtemp0_warnHi, (double[])item_.getBoardtemp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_warnLo, (double[])item_.getBoardtemp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitHi, (double[])item_.getBoardtemp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp0_limitLo, (double[])item_.getBoardtemp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnHi, (double[])item_.getBoardtemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_warnLo, (double[])item_.getBoardtemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitHi, (double[])item_.getBoardtemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp1_limitLo, (double[])item_.getBoardtemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnHi, (double[])item_.getBoardtemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_warnLo, (double[])item_.getBoardtemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitHi, (double[])item_.getBoardtemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp2_limitLo, (double[])item_.getBoardtemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnHi, (double[])item_.getBoardtemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_warnLo, (double[])item_.getBoardtemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitHi, (double[])item_.getBoardtemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp3_limitLo, (double[])item_.getBoardtemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnHi, (double[])item_.getBoardtemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_warnLo, (double[])item_.getBoardtemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitHi, (double[])item_.getBoardtemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp4_limitLo, (double[])item_.getBoardtemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnHi, (double[])item_.getBoardtemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_warnLo, (double[])item_.getBoardtemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitHi, (double[])item_.getBoardtemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp5_limitLo, (double[])item_.getBoardtemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnHi, (double[])item_.getBoardtemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_warnLo, (double[])item_.getBoardtemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitHi, (double[])item_.getBoardtemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])boardtemp6_limitLo, (double[])item_.getBoardtemp6_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveRebpower_Rebps_PowerSettingsAppliedEvent() throws Exception {
        int priority = 518;
        int version = 162;
        String ipAddr = "n";
        String location = "m";
        int[] nPowerOnPub = TestHelper.generateIntArray((int)13, (int)-253594619);
        SALEvent item = this.testSendReceive((SALEvent)new Rebpower_Rebps_PowerSettingsAppliedEvent(priority, version, ipAddr, location, nPowerOnPub));
        Assert.assertTrue((boolean)(item instanceof Rebpower_Rebps_PowerSettingsAppliedEvent));
        Rebpower_Rebps_PowerSettingsAppliedEvent item_ = (Rebpower_Rebps_PowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
    }

    @Test
    public void sendReceiveHexSettingsAppliedEvent() throws Exception {
        int priority = 116;
        int version = 533;
        double rtnToEvapOffset = 0.1776370406150818;
        SALEvent item = this.testSendReceive((SALEvent)new HexSettingsAppliedEvent(priority, version, rtnToEvapOffset));
        Assert.assertTrue((boolean)(item instanceof HexSettingsAppliedEvent));
        HexSettingsAppliedEvent item_ = (HexSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)rtnToEvapOffset, (double)item_.getRtnToEvapOffset(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold1_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 398;
        int version = 113;
        double evapexittmp_warnHi = 0.058002352714538574;
        double evapexittmp_warnLo = 0.5878888368606567;
        double evapexittmp_limitHi = 0.34279865026474;
        double evapexittmp_limitLo = 0.446674644947052;
        double hexrtrntmp_warnHi = 0.6790383458137512;
        double hexrtrntmp_warnLo = 0.5738877654075623;
        double hexrtrntmp_limitHi = 0.4055485725402832;
        double hexrtrntmp_limitLo = 0.8601377010345459;
        double preexpntmp_warnHi = 0.21220511198043823;
        double preexpntmp_warnLo = 0.9195892214775085;
        double preexpntmp_limitHi = 0.9851754307746887;
        double preexpntmp_limitLo = 0.4957928f;
        double returnprs_warnHi = 0.7163221836090088;
        double returnprs_warnLo = 0.6140961050987244;
        double returnprs_limitHi = 0.5226884484291077;
        double returnprs_limitLo = 0.19604378938674927;
        double superheat_warnHi = 0.8590373396873474;
        double superheat_warnLo = 0.9079030752182007;
        double superheat_limitHi = 0.4614155888557434;
        double superheat_limitLo = 0.5501790642738342;
        double supplyprs_warnHi = 0.5983737707138062;
        double supplyprs_warnLo = 0.4326738715171814;
        double supplyprs_limitHi = 0.4598551392555237;
        double supplyprs_limitLo = 0.9665083885192871;
        double supplysubcooling_warnHi = 0.743118405342102;
        double supplysubcooling_warnLo = 0.29607248306274414;
        double supplysubcooling_limitHi = 0.43294817209243774;
        double supplysubcooling_limitLo = 0.6063153743743896;
        double supplytmp_warnHi = 0.7231611609458923;
        double supplytmp_warnLo = 0.00729447603225708;
        double supplytmp_limitHi = 0.33310025930404663;
        double supplytmp_limitLo = 0.977205f;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold1_LimitsSettingsAppliedEvent(priority, version, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, preexpntmp_warnHi, preexpntmp_warnLo, preexpntmp_limitHi, preexpntmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, superheat_warnHi, superheat_warnLo, superheat_limitHi, superheat_limitLo, supplyprs_warnHi, supplyprs_warnLo, supplyprs_limitHi, supplyprs_limitLo, supplysubcooling_warnHi, supplysubcooling_warnLo, supplysubcooling_limitHi, supplysubcooling_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold1_LimitsSettingsAppliedEvent));
        Hex_Cold1_LimitsSettingsAppliedEvent item_ = (Hex_Cold1_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnHi, (double)item_.getPreexpntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnLo, (double)item_.getPreexpntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitHi, (double)item_.getPreexpntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitLo, (double)item_.getPreexpntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnHi, (double)item_.getSuperheat_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnLo, (double)item_.getSuperheat_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitHi, (double)item_.getSuperheat_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitLo, (double)item_.getSuperheat_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnHi, (double)item_.getSupplyprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnLo, (double)item_.getSupplyprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitHi, (double)item_.getSupplyprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitLo, (double)item_.getSupplyprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnHi, (double)item_.getSupplysubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnLo, (double)item_.getSupplysubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitHi, (double)item_.getSupplysubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitLo, (double)item_.getSupplysubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cold2_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 110;
        int version = 414;
        double evapexittmp_warnHi = 0.11147481203079224;
        double evapexittmp_warnLo = 0.6011083126068115;
        double evapexittmp_limitHi = 0.9323744773864746;
        double evapexittmp_limitLo = 0.9278703927993774;
        double hexrtrntmp_warnHi = 0.2914939522743225;
        double hexrtrntmp_warnLo = 0.6405305862426758;
        double hexrtrntmp_limitHi = 0.7372221946716309;
        double hexrtrntmp_limitLo = 0.9749284982681274;
        double preexpntmp_warnHi = 0.6074967980384827;
        double preexpntmp_warnLo = 0.030330181121826172;
        double preexpntmp_limitHi = 0.7730217576026917;
        double preexpntmp_limitLo = 0.23031193017959595;
        double returnprs_warnHi = 0.6076322197914124;
        double returnprs_warnLo = 0.13174086809158325;
        double returnprs_limitHi = 0.06898140907287598;
        double returnprs_limitLo = 0.13688474893569946;
        double superheat_warnHi = 0.4649277329444885;
        double superheat_warnLo = 0.32647645473480225;
        double superheat_limitHi = 0.6774181127548218;
        double superheat_limitLo = 0.07293188571929932;
        double supplyprs_warnHi = 0.2858484983444214;
        double supplyprs_warnLo = 0.1931876540184021;
        double supplyprs_limitHi = 0.042186856269836426;
        double supplyprs_limitLo = 0.2089687f;
        double supplysubcooling_warnHi = 0.3314070701599121;
        double supplysubcooling_warnLo = 0.8635f;
        double supplysubcooling_limitHi = 0.7868179678916931;
        double supplysubcooling_limitLo = 0.04214549f;
        double supplytmp_warnHi = 0.9800314903259277;
        double supplytmp_warnLo = 0.013203442096710205;
        double supplytmp_limitHi = 0.25569117069244385;
        double supplytmp_limitLo = 0.20352166891098022;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cold2_LimitsSettingsAppliedEvent(priority, version, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, preexpntmp_warnHi, preexpntmp_warnLo, preexpntmp_limitHi, preexpntmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, superheat_warnHi, superheat_warnLo, superheat_limitHi, superheat_limitLo, supplyprs_warnHi, supplyprs_warnLo, supplyprs_limitHi, supplyprs_limitLo, supplysubcooling_warnHi, supplysubcooling_warnLo, supplysubcooling_limitHi, supplysubcooling_limitLo, supplytmp_warnHi, supplytmp_warnLo, supplytmp_limitHi, supplytmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cold2_LimitsSettingsAppliedEvent));
        Hex_Cold2_LimitsSettingsAppliedEvent item_ = (Hex_Cold2_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnHi, (double)item_.getPreexpntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_warnLo, (double)item_.getPreexpntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitHi, (double)item_.getPreexpntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)preexpntmp_limitLo, (double)item_.getPreexpntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnHi, (double)item_.getSuperheat_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_warnLo, (double)item_.getSuperheat_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitHi, (double)item_.getSuperheat_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)superheat_limitLo, (double)item_.getSuperheat_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnHi, (double)item_.getSupplyprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_warnLo, (double)item_.getSupplyprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitHi, (double)item_.getSupplyprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplyprs_limitLo, (double)item_.getSupplyprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnHi, (double)item_.getSupplysubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_warnLo, (double)item_.getSupplysubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitHi, (double)item_.getSupplysubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplysubcooling_limitLo, (double)item_.getSupplysubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnHi, (double)item_.getSupplytmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_warnLo, (double)item_.getSupplytmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitHi, (double)item_.getSupplytmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)supplytmp_limitLo, (double)item_.getSupplytmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo1_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 109;
        int version = 944;
        double c3exittmp_warnHi = 0.9378864169120789;
        double c3exittmp_warnLo = 0.9141576886177063;
        double c3exittmp_limitHi = 0.8772063255310059;
        double c3exittmp_limitLo = 0.3102787733078003;
        double c4exittmp_warnHi = 0.8030017614364624;
        double c4exittmp_warnLo = 0.7286413311958313;
        double c4exittmp_limitHi = 0.5008583068847656;
        double c4exittmp_limitLo = 0.4470691680908203;
        double evapexittmp_warnHi = 0.28140032291412354;
        double evapexittmp_warnLo = 0.7706174850463867;
        double evapexittmp_limitHi = 0.47354668378829956;
        double evapexittmp_limitLo = 0.7385295629501343;
        double hexrtrntmp_warnHi = 0.7813725471496582;
        double hexrtrntmp_warnLo = 0.24604082107543945;
        double hexrtrntmp_limitHi = 0.2682746648788452;
        double hexrtrntmp_limitLo = 0.7058215737342834;
        double liquidprs_warnHi = 0.1090155839920044;
        double liquidprs_warnLo = 0.46875715255737305;
        double liquidprs_limitHi = 0.8462410569190979;
        double liquidprs_limitLo = 0.9970532655715942;
        double prec3tmp_warnHi = 0.25281256437301636;
        double prec3tmp_warnLo = 0.1928073763847351;
        double prec3tmp_limitHi = 0.6669959425926208;
        double prec3tmp_limitLo = 0.6861705183982849;
        double prec4tmp_warnHi = 0.7266314625740051;
        double prec4tmp_warnLo = 0.600325345993042;
        double prec4tmp_limitHi = 0.10764491558074951;
        double prec4tmp_limitLo = 0.573624312877655;
        double returnprs_warnHi = 0.9979845881462097;
        double returnprs_warnLo = 0.6174829006195068;
        double returnprs_limitHi = 0.8183566927909851;
        double returnprs_limitLo = 0.07649964094161987;
        double vaporprs_warnHi = 0.6318298578262329;
        double vaporprs_warnLo = 0.23866015672683716;
        double vaporprs_limitHi = 0.2174096703529358;
        double vaporprs_limitLo = 0.8822810649871826;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo1_LimitsSettingsAppliedEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo1_LimitsSettingsAppliedEvent));
        Hex_Cryo1_LimitsSettingsAppliedEvent item_ = (Hex_Cryo1_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo2_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 854;
        int version = 531;
        double c3exittmp_warnHi = 0.7377258539199829;
        double c3exittmp_warnLo = 0.9629201292991638;
        double c3exittmp_limitHi = 0.8280600905418396;
        double c3exittmp_limitLo = 0.969538688659668;
        double c4exittmp_warnHi = 0.22378402948379517;
        double c4exittmp_warnLo = 0.6647076606750488;
        double c4exittmp_limitHi = 0.3317262530326843;
        double c4exittmp_limitLo = 0.30432742834091187;
        double evapexittmp_warnHi = 0.7666182518005371;
        double evapexittmp_warnLo = 0.7806218862533569;
        double evapexittmp_limitHi = 0.8396885991096497;
        double evapexittmp_limitLo = 0.9289778470993042;
        double hexrtrntmp_warnHi = 0.3070452809333801;
        double hexrtrntmp_warnLo = 0.9169155359268188;
        double hexrtrntmp_limitHi = 0.57578444480896;
        double hexrtrntmp_limitLo = 0.907426655292511;
        double liquidprs_warnHi = 0.16321277618408203;
        double liquidprs_warnLo = 0.2419554591178894;
        double liquidprs_limitHi = 0.8797241449356079;
        double liquidprs_limitLo = 0.8299506306648254;
        double prec3tmp_warnHi = 0.7060214877128601;
        double prec3tmp_warnLo = 0.2755822539329529;
        double prec3tmp_limitHi = 0.20525145530700684;
        double prec3tmp_limitLo = 0.24436503648757935;
        double prec4tmp_warnHi = 0.25108712911605835;
        double prec4tmp_warnLo = 0.6799971461296082;
        double prec4tmp_limitHi = 0.6659785509109497;
        double prec4tmp_limitLo = 0.25002098083496094;
        double returnprs_warnHi = 0.7229271531105042;
        double returnprs_warnLo = 0.7525046467781067;
        double returnprs_limitHi = 0.5276303291320801;
        double returnprs_limitLo = 0.13155996799468994;
        double vaporprs_warnHi = 0.2183634638786316;
        double vaporprs_warnLo = 0.2160738706588745;
        double vaporprs_limitHi = 0.5816146731376648;
        double vaporprs_limitLo = 0.7731895446777344;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo2_LimitsSettingsAppliedEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo2_LimitsSettingsAppliedEvent));
        Hex_Cryo2_LimitsSettingsAppliedEvent item_ = (Hex_Cryo2_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo3_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 995;
        int version = 683;
        double c3exittmp_warnHi = 0.4059907793998718;
        double c3exittmp_warnLo = 0.9888686537742615;
        double c3exittmp_limitHi = 0.25809115171432495;
        double c3exittmp_limitLo = 0.9107029438018799;
        double c4exittmp_warnHi = 0.2324819564819336;
        double c4exittmp_warnLo = 0.9317814707756042;
        double c4exittmp_limitHi = 0.36610865592956543;
        double c4exittmp_limitLo = 0.3345072269439697;
        double evapexittmp_warnHi = 0.05174213647842407;
        double evapexittmp_warnLo = 0.9009913802146912;
        double evapexittmp_limitHi = 0.2455756664276123;
        double evapexittmp_limitLo = 0.5896274447441101;
        double hexrtrntmp_warnHi = 0.9663316607475281;
        double hexrtrntmp_warnLo = 0.2779970169067383;
        double hexrtrntmp_limitHi = 0.2617756724357605;
        double hexrtrntmp_limitLo = 0.19612634181976318;
        double liquidprs_warnHi = 0.8576100468635559;
        double liquidprs_warnLo = 0.0254705548286438;
        double liquidprs_limitHi = 0.5594959259033203;
        double liquidprs_limitLo = 0.3501044511795044;
        double prec3tmp_warnHi = 0.5879529118537903;
        double prec3tmp_warnLo = 0.32978355884552;
        double prec3tmp_limitHi = 0.735785186290741;
        double prec3tmp_limitLo = 0.49566978216171265;
        double prec4tmp_warnHi = 0.08542346954345703;
        double prec4tmp_warnLo = 0.1236853f;
        double prec4tmp_limitHi = 0.971034824848175;
        double prec4tmp_limitLo = 0.8473304510116577;
        double returnprs_warnHi = 0.3294628858566284;
        double returnprs_warnLo = 0.5819786190986633;
        double returnprs_limitHi = 0.5952181816101074;
        double returnprs_limitLo = 0.7927321195602417;
        double vaporprs_warnHi = 0.0016371607780456543;
        double vaporprs_warnLo = 0.32815104722976685;
        double vaporprs_limitHi = 0.7488806247711182;
        double vaporprs_limitLo = 0.3368644118309021;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo3_LimitsSettingsAppliedEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo3_LimitsSettingsAppliedEvent));
        Hex_Cryo3_LimitsSettingsAppliedEvent item_ = (Hex_Cryo3_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo4_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 168;
        int version = 721;
        double c3exittmp_warnHi = 0.08798271417617798;
        double c3exittmp_warnLo = 0.5846213102340698;
        double c3exittmp_limitHi = 0.48808616399765015;
        double c3exittmp_limitLo = 0.1276019811630249;
        double c4exittmp_warnHi = 0.2578394412994385;
        double c4exittmp_warnLo = 0.10613560676574707;
        double c4exittmp_limitHi = 0.3082171082496643;
        double c4exittmp_limitLo = 0.9318339228630066;
        double evapexittmp_warnHi = 0.8321828842163086;
        double evapexittmp_warnLo = 0.5614796280860901;
        double evapexittmp_limitHi = 0.24628931283950806;
        double evapexittmp_limitLo = 0.9507452249526978;
        double hexrtrntmp_warnHi = 0.3649328351020813;
        double hexrtrntmp_warnLo = 0.3665999174118042;
        double hexrtrntmp_limitHi = 0.38482964038848877;
        double hexrtrntmp_limitLo = 0.8802147507667542;
        double liquidprs_warnHi = 0.2488483190536499;
        double liquidprs_warnLo = 0.4148409366607666;
        double liquidprs_limitHi = 0.4606884f;
        double liquidprs_limitLo = 0.6602405309677124;
        double prec3tmp_warnHi = 0.9092357754707336;
        double prec3tmp_warnLo = 0.8978352546691895;
        double prec3tmp_limitHi = 0.50284343957901;
        double prec3tmp_limitLo = 0.21597141027450562;
        double prec4tmp_warnHi = 0.002817809581756592;
        double prec4tmp_warnLo = 0.33124858140945435;
        double prec4tmp_limitHi = 0.1895303726196289;
        double prec4tmp_limitLo = 0.7303743362426758;
        double returnprs_warnHi = 0.34034425020217896;
        double returnprs_warnLo = 0.735842227935791;
        double returnprs_limitHi = 0.4493151903152466;
        double returnprs_limitLo = 0.931314f;
        double vaporprs_warnHi = 0.1333240270614624;
        double vaporprs_warnLo = 0.06915563344955444;
        double vaporprs_limitHi = 0.8116698861122131;
        double vaporprs_limitLo = 0.8750594854354858;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo4_LimitsSettingsAppliedEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo4_LimitsSettingsAppliedEvent));
        Hex_Cryo4_LimitsSettingsAppliedEvent item_ = (Hex_Cryo4_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo5_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 37;
        int version = 77;
        double c3exittmp_warnHi = 0.28536665439605713;
        double c3exittmp_warnLo = 0.2334151268005371;
        double c3exittmp_limitHi = 0.1388377547264099;
        double c3exittmp_limitLo = 0.5651848912239075;
        double c4exittmp_warnHi = 0.5733909606933594;
        double c4exittmp_warnLo = 0.41720718145370483;
        double c4exittmp_limitHi = 0.26448744535446167;
        double c4exittmp_limitLo = 0.35695648193359375;
        double evapexittmp_warnHi = 0.8900324106216431;
        double evapexittmp_warnLo = 0.4097848f;
        double evapexittmp_limitHi = 0.2699854373931885;
        double evapexittmp_limitLo = 0.3449241f;
        double hexrtrntmp_warnHi = 0.6514145731925964;
        double hexrtrntmp_warnLo = 0.7461811900138855;
        double hexrtrntmp_limitHi = 0.5459582805633545;
        double hexrtrntmp_limitLo = 0.5232203006744385;
        double liquidprs_warnHi = 0.690171480178833;
        double liquidprs_warnLo = 0.10290920734405518;
        double liquidprs_limitHi = 0.679862916469574;
        double liquidprs_limitLo = 0.6237860321998596;
        double prec3tmp_warnHi = 0.17658203840255737;
        double prec3tmp_warnLo = 0.7969587445259094;
        double prec3tmp_limitHi = 0.1981566f;
        double prec3tmp_limitLo = 0.2166767716407776;
        double prec4tmp_warnHi = 0.09368312358856201;
        double prec4tmp_warnLo = 0.6079548001289368;
        double prec4tmp_limitHi = 0.8828257322311401;
        double prec4tmp_limitLo = 0.8750627636909485;
        double returnprs_warnHi = 0.3472723364830017;
        double returnprs_warnLo = 0.6027861833572388;
        double returnprs_limitHi = 0.7847954034805298;
        double returnprs_limitLo = 0.2713779807090759;
        double vaporprs_warnHi = 0.5309661030769348;
        double vaporprs_warnLo = 0.566125750541687;
        double vaporprs_limitHi = 0.18084394931793213;
        double vaporprs_limitLo = 0.8151566982269287;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo5_LimitsSettingsAppliedEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo5_LimitsSettingsAppliedEvent));
        Hex_Cryo5_LimitsSettingsAppliedEvent item_ = (Hex_Cryo5_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Cryo6_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 449;
        int version = 297;
        double c3exittmp_warnHi = 0.02865135669708252;
        double c3exittmp_warnLo = 0.20091331005096436;
        double c3exittmp_limitHi = 0.5535042881965637;
        double c3exittmp_limitLo = 0.216303288936615;
        double c4exittmp_warnHi = 0.33076733350753784;
        double c4exittmp_warnLo = 0.21007037162780762;
        double c4exittmp_limitHi = 0.8211714029312134;
        double c4exittmp_limitLo = 0.724603533744812;
        double evapexittmp_warnHi = 0.1649855375289917;
        double evapexittmp_warnLo = 0.524152934551239;
        double evapexittmp_limitHi = 0.1386559009552002;
        double evapexittmp_limitLo = 0.18888407945632935;
        double hexrtrntmp_warnHi = 0.746355f;
        double hexrtrntmp_warnLo = 0.6425913572311401;
        double hexrtrntmp_limitHi = 0.16918432712554932;
        double hexrtrntmp_limitLo = 0.4212082624435425;
        double liquidprs_warnHi = 0.6034871339797974;
        double liquidprs_warnLo = 0.25848788022994995;
        double liquidprs_limitHi = 0.20617163181304932;
        double liquidprs_limitLo = 0.6782745122909546;
        double prec3tmp_warnHi = 0.955681f;
        double prec3tmp_warnLo = 0.3962072f;
        double prec3tmp_limitHi = 0.5218521356582642;
        double prec3tmp_limitLo = 0.1899036169052124;
        double prec4tmp_warnHi = 0.4225732088088989;
        double prec4tmp_warnLo = 0.03787273168563843;
        double prec4tmp_limitHi = 0.3646594285964966;
        double prec4tmp_limitLo = 0.7142853140830994;
        double returnprs_warnHi = 0.8675350546836853;
        double returnprs_warnLo = 0.9096395373344421;
        double returnprs_limitHi = 0.3596722483634949;
        double returnprs_limitLo = 0.4937942624092102;
        double vaporprs_warnHi = 0.1310117244720459;
        double vaporprs_warnLo = 0.12645351886749268;
        double vaporprs_limitHi = 0.0751606822013855;
        double vaporprs_limitLo = 0.1677112579345703;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Cryo6_LimitsSettingsAppliedEvent(priority, version, c3exittmp_warnHi, c3exittmp_warnLo, c3exittmp_limitHi, c3exittmp_limitLo, c4exittmp_warnHi, c4exittmp_warnLo, c4exittmp_limitHi, c4exittmp_limitLo, evapexittmp_warnHi, evapexittmp_warnLo, evapexittmp_limitHi, evapexittmp_limitLo, hexrtrntmp_warnHi, hexrtrntmp_warnLo, hexrtrntmp_limitHi, hexrtrntmp_limitLo, liquidprs_warnHi, liquidprs_warnLo, liquidprs_limitHi, liquidprs_limitLo, prec3tmp_warnHi, prec3tmp_warnLo, prec3tmp_limitHi, prec3tmp_limitLo, prec4tmp_warnHi, prec4tmp_warnLo, prec4tmp_limitHi, prec4tmp_limitLo, returnprs_warnHi, returnprs_warnLo, returnprs_limitHi, returnprs_limitLo, vaporprs_warnHi, vaporprs_warnLo, vaporprs_limitHi, vaporprs_limitLo));
        Assert.assertTrue((boolean)(item instanceof Hex_Cryo6_LimitsSettingsAppliedEvent));
        Hex_Cryo6_LimitsSettingsAppliedEvent item_ = (Hex_Cryo6_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)c3exittmp_warnHi, (double)item_.getC3exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_warnLo, (double)item_.getC3exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitHi, (double)item_.getC3exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c3exittmp_limitLo, (double)item_.getC3exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnHi, (double)item_.getC4exittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_warnLo, (double)item_.getC4exittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitHi, (double)item_.getC4exittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)c4exittmp_limitLo, (double)item_.getC4exittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnHi, (double)item_.getEvapexittmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_warnLo, (double)item_.getEvapexittmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitHi, (double)item_.getEvapexittmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)evapexittmp_limitLo, (double)item_.getEvapexittmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnHi, (double)item_.getHexrtrntmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_warnLo, (double)item_.getHexrtrntmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitHi, (double)item_.getHexrtrntmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hexrtrntmp_limitLo, (double)item_.getHexrtrntmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnHi, (double)item_.getLiquidprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_warnLo, (double)item_.getLiquidprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitHi, (double)item_.getLiquidprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidprs_limitLo, (double)item_.getLiquidprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnHi, (double)item_.getPrec3tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_warnLo, (double)item_.getPrec3tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitHi, (double)item_.getPrec3tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec3tmp_limitLo, (double)item_.getPrec3tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnHi, (double)item_.getPrec4tmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_warnLo, (double)item_.getPrec4tmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitHi, (double)item_.getPrec4tmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)prec4tmp_limitLo, (double)item_.getPrec4tmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnHi, (double)item_.getReturnprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_warnLo, (double)item_.getReturnprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitHi, (double)item_.getReturnprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)returnprs_limitLo, (double)item_.getReturnprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnHi, (double)item_.getVaporprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_warnLo, (double)item_.getVaporprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitHi, (double)item_.getVaporprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)vaporprs_limitLo, (double)item_.getVaporprs_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveHex_Maq20_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 663;
        int version = 260;
        String node = "n";
        String serials = "q";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20_DeviceSettingsAppliedEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20_DeviceSettingsAppliedEvent));
        Hex_Maq20_DeviceSettingsAppliedEvent item_ = (Hex_Maq20_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_Maq20x_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 436;
        int version = 40;
        String node = "b";
        String serials = "i";
        SALEvent item = this.testSendReceive((SALEvent)new Hex_Maq20x_DeviceSettingsAppliedEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Hex_Maq20x_DeviceSettingsAppliedEvent));
        Hex_Maq20x_DeviceSettingsAppliedEvent item_ = (Hex_Maq20x_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveHex_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 830;
        int version = 664;
        int schedulers_default_nTasks = 626;
        int schedulers_default_nThreads = 146;
        int schedulers_monitor_update_publish_scheduler_nTasks = 310;
        int schedulers_monitor_update_publish_scheduler_nThreads = 935;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasksSettingsAppliedEvent));
        Hex_PeriodicTasksSettingsAppliedEvent item_ = (Hex_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveHex_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 390;
        int version = 953;
        long agentmonitorservice_taskPeriodMillis = 309L;
        long heartbeat_taskPeriodMillis = 186L;
        long monitor_check_taskPeriodMillis = 149L;
        long monitor_publish_taskPeriodMillis = 73L;
        long monitor_update_taskPeriodMillis = 732L;
        long runtimeinfo_taskPeriodMillis = 33L;
        SALEvent item = this.testSendReceive((SALEvent)new Hex_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Hex_PeriodicTasks_timersSettingsAppliedEvent));
        Hex_PeriodicTasks_timersSettingsAppliedEvent item_ = (Hex_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveRefrig_Cold1_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 814;
        int version = 246;
        double cmprPowerDelayLimit = 0.10997647047042847;
        int cmprPowerDelayTime = 639;
        double cmprPowerImmedLimit = 0.4016244411468506;
        double coldTempImmedLimit = 0.08052986860275269;
        double discPressDelayLimit = 0.3799621f;
        int discPressDelayTime = 605;
        double discPressImmedLimit = 0.8836053609848022;
        double discTempDelayLimit = 0.426071f;
        int discTempDelayTime = 953;
        double discTempImmedLimit = 0.978637158870697;
        double discTempLowImmedLimit = 0.0295704f;
        double heaterTempLimit = 0.8567120432853699;
        double liquidTempDelayLimit = 0.703027f;
        int liquidTempDelayTime = 387;
        double liquidTempImmedLimit = 0.7800835967063904;
        double orificeOffPress = 0.9634101986885071;
        double orificeOnPress = 0.6401426196098328;
        double phaseSepTempDelayLimit = 0.00840681791305542;
        int phaseSepTempDelayTime = 622;
        double pressDiffImmedLimit = 0.3452872633934021;
        double suctTempImmedLimit = 0.6132214665412903;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_CompLimitsSettingsAppliedEvent));
        Refrig_Cold1_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cold1_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold1_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 92;
        int version = 73;
        String maq20_node = "d";
        String maq20_serials = "";
        String plc_node = "s";
        int vfd_address = 994;
        int vfd_baudRate = 363;
        String vfd_devcName = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_DeviceSettingsAppliedEvent));
        Refrig_Cold1_DeviceSettingsAppliedEvent item_ = (Refrig_Cold1_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceiveRefrig_Cold1_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 951;
        int version = 885;
        double ambienttmp_warnHi = 0.7911467552185059;
        double ambienttmp_warnLo = 0.5862413048744202;
        double ambienttmp_limitHi = 0.19596493244171143;
        double ambienttmp_limitLo = 0.6517412066459656;
        double cabinettmp_warnHi = 0.8109247088432312;
        double cabinettmp_warnLo = 0.5020307898521423;
        double cabinettmp_limitHi = 0.09269309043884277;
        double cabinettmp_limitLo = 0.7096713781356812;
        double compcurrent_warnHi = 0.4633186459541321;
        double compcurrent_warnLo = 0.610880970954895;
        double compcurrent_limitHi = 0.2357664704322815;
        double compcurrent_limitLo = 0.8266355991363525;
        double comppower_warnHi = 0.8923792243003845;
        double comppower_warnLo = 0.7904093265533447;
        double comppower_limitHi = 0.007546544075012207;
        double comppower_limitLo = 0.02032071352005005;
        double compvfdcurr_warnHi = 0.1448100209236145;
        double compvfdcurr_warnLo = 0.6774519681930542;
        double compvfdcurr_limitHi = 0.9350197315216064;
        double compvfdcurr_limitLo = 0.8183979392051697;
        double compvfdfreq_warnHi = 0.9617493748664856;
        double compvfdfreq_warnLo = 0.3929516673088074;
        double compvfdfreq_limitHi = 0.8882981538772583;
        double compvfdfreq_limitLo = 0.9426085352897644;
        double compvfdvolt_warnHi = 0.2420047f;
        double compvfdvolt_warnLo = 0.6579023599624634;
        double compvfdvolt_limitHi = 0.792611f;
        double compvfdvolt_limitLo = 0.3765166401863098;
        double compvoltage_warnHi = 0.8020473122596741;
        double compvoltage_warnLo = 0.3539528250694275;
        double compvoltage_limitHi = 0.8028817176818848;
        double compvoltage_limitLo = 0.17002063989639282;
        double coolflowrate_warnHi = 0.2709732f;
        double coolflowrate_warnLo = 0.012377262115478516;
        double coolflowrate_limitHi = 0.2536681294441223;
        double coolflowrate_limitLo = 0.5590114593505859;
        double coolvalveposn_warnHi = 0.17061054706573486;
        double coolvalveposn_warnLo = 0.13917946815490723;
        double coolvalveposn_limitHi = 0.6210432052612305;
        double coolvalveposn_limitLo = 0.10065692663192749;
        double dischrgprs_warnHi = 0.1617475152015686;
        double dischrgprs_warnLo = 0.6523122191429138;
        double dischrgprs_limitHi = 0.2882046699523926;
        double dischrgprs_limitLo = 0.8141778707504272;
        double dischrgtmp_M_warnHi = 0.0724054f;
        double dischrgtmp_M_warnLo = 0.9226796627044678;
        double dischrgtmp_M_limitHi = 0.055135905742645264;
        double dischrgtmp_M_limitLo = 0.12229812145233154;
        double dischrgtmp_P_warnHi = 0.16417354345321655;
        double dischrgtmp_P_warnLo = 0.0801962f;
        double dischrgtmp_P_limitHi = 0.17703211307525635;
        double dischrgtmp_P_limitLo = 0.38655567169189453;
        double fan1speed_warnHi = 0.404455304145813;
        double fan1speed_warnLo = 0.9292687773704529;
        double fan1speed_limitHi = 0.7496299147605896;
        double fan1speed_limitLo = 0.27523887157440186;
        double fan2speed_warnHi = 0.5782743096351624;
        double fan2speed_warnLo = 0.27734827995300293;
        double fan2speed_limitHi = 0.6158115863800049;
        double fan2speed_limitLo = 0.1788643f;
        double fan3speed_warnHi = 0.4409077763557434;
        double fan3speed_warnLo = 0.9314776659011841;
        double fan3speed_limitHi = 0.6713199019432068;
        double fan3speed_limitLo = 0.5559794902801514;
        double hgbvalveposn_warnHi = 0.8455294370651245;
        double hgbvalveposn_warnLo = 0.479996919631958;
        double hgbvalveposn_limitHi = 0.6631540656089783;
        double hgbvalveposn_limitLo = 0.9409094452857971;
        double liquidsubcooling_warnHi = 0.7073533535003662;
        double liquidsubcooling_warnLo = 0.1218177080154419;
        double liquidsubcooling_limitHi = 0.8578788042068481;
        double liquidsubcooling_limitLo = 0.4422512f;
        double liquidtmp_M_warnHi = 0.6322062015533447;
        double liquidtmp_M_warnLo = 0.8091465830802917;
        double liquidtmp_M_limitHi = 0.5049675107002258;
        double liquidtmp_M_limitLo = 0.8019691109657288;
        double liquidtmp_P_warnHi = 0.1533641219139099;
        double liquidtmp_P_warnLo = 0.3595404624938965;
        double liquidtmp_P_limitHi = 0.9193195104598999;
        double liquidtmp_P_limitLo = 0.4434826374053955;
        double suctionprs_warnHi = 0.4118521213531494;
        double suctionprs_warnLo = 0.7011619210243225;
        double suctionprs_limitHi = 0.4847882390022278;
        double suctionprs_limitLo = 0.7149277925491333;
        double suctiontmp_M_warnHi = 0.17381781339645386;
        double suctiontmp_M_warnLo = 0.22563612461090088;
        double suctiontmp_M_limitHi = 0.5550898909568787;
        double suctiontmp_M_limitLo = 0.6106980443000793;
        double suctiontmp_P_warnHi = 0.7112863063812256;
        double suctiontmp_P_warnLo = 0.22369462251663208;
        double suctiontmp_P_limitHi = 0.3586241f;
        double suctiontmp_P_limitLo = 0.33843398094177246;
        double waterintmp_warnHi = 0.9524278044700623;
        double waterintmp_warnLo = 0.41063958406448364;
        double waterintmp_limitHi = 0.7489414215087891;
        double waterintmp_limitLo = 0.9759699106216431;
        double waterouttmp_warnHi = 0.6229037642478943;
        double waterouttmp_warnLo = 0.655523f;
        double waterouttmp_limitHi = 0.27287375926971436;
        double waterouttmp_limitLo = 0.24761521816253662;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold1_LimitsSettingsAppliedEvent(priority, version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold1_LimitsSettingsAppliedEvent));
        Refrig_Cold1_LimitsSettingsAppliedEvent item_ = (Refrig_Cold1_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 539;
        int version = 765;
        double cmprPowerDelayLimit = 0.23437517881393433;
        int cmprPowerDelayTime = 43;
        double cmprPowerImmedLimit = 0.4058322310447693;
        double coldTempImmedLimit = 0.15907102823257446;
        double discPressDelayLimit = 0.5351780652999878;
        int discPressDelayTime = 292;
        double discPressImmedLimit = 0.6852855086326599;
        double discTempDelayLimit = 0.2801274061203003;
        int discTempDelayTime = 216;
        double discTempImmedLimit = 0.626501202583313;
        double discTempLowImmedLimit = 0.999459f;
        double heaterTempLimit = 0.9808174967765808;
        double liquidTempDelayLimit = 0.8505963683128357;
        int liquidTempDelayTime = 7;
        double liquidTempImmedLimit = 0.7829119563102722;
        double orificeOffPress = 0.9551782011985779;
        double orificeOnPress = 0.8803683519363403;
        double phaseSepTempDelayLimit = 0.9467967748641968;
        int phaseSepTempDelayTime = 705;
        double pressDiffImmedLimit = 0.37750154733657837;
        double suctTempImmedLimit = 0.32929152250289917;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_CompLimitsSettingsAppliedEvent));
        Refrig_Cold2_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cold2_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cold2_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 924;
        int version = 189;
        String maq20_node = "h";
        String maq20_serials = "z";
        String plc_node = "";
        int vfd_address = 662;
        int vfd_baudRate = 812;
        String vfd_devcName = "f";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node, vfd_address, vfd_baudRate, vfd_devcName));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_DeviceSettingsAppliedEvent));
        Refrig_Cold2_DeviceSettingsAppliedEvent item_ = (Refrig_Cold2_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
        Assert.assertEquals((long)vfd_address, (long)item_.getVfd_address());
        Assert.assertEquals((long)vfd_baudRate, (long)item_.getVfd_baudRate());
        Assert.assertEquals((Object)vfd_devcName, (Object)item_.getVfd_devcName());
    }

    @Test
    public void sendReceiveRefrig_Cold2_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 638;
        int version = 144;
        double ambienttmp_warnHi = 0.23200958967208862;
        double ambienttmp_warnLo = 0.621763288974762;
        double ambienttmp_limitHi = 0.1554107666015625;
        double ambienttmp_limitLo = 0.5610649585723877;
        double cabinettmp_warnHi = 0.37559783458709717;
        double cabinettmp_warnLo = 0.32896852493286133;
        double cabinettmp_limitHi = 0.8055156469345093;
        double cabinettmp_limitLo = 0.08459645509719849;
        double compcurrent_warnHi = 0.33248448371887207;
        double compcurrent_warnLo = 0.5507811307907104;
        double compcurrent_limitHi = 0.9486668705940247;
        double compcurrent_limitLo = 0.6936050653457642;
        double comppower_warnHi = 0.5140964984893799;
        double comppower_warnLo = 0.7448531985282898;
        double comppower_limitHi = 0.941771388053894;
        double comppower_limitLo = 0.7484720349311829;
        double compvfdcurr_warnHi = 0.7645028829574585;
        double compvfdcurr_warnLo = 0.010468602180480957;
        double compvfdcurr_limitHi = 0.6878884434700012;
        double compvfdcurr_limitLo = 0.6218031644821167;
        double compvfdfreq_warnHi = 0.6412501335144043;
        double compvfdfreq_warnLo = 0.8648171424865723;
        double compvfdfreq_limitHi = 0.8498541712760925;
        double compvfdfreq_limitLo = 0.26377958059310913;
        double compvfdvolt_warnHi = 0.3724910616874695;
        double compvfdvolt_warnLo = 0.37040263414382935;
        double compvfdvolt_limitHi = 0.47953593730926514;
        double compvfdvolt_limitLo = 0.7584148049354553;
        double compvoltage_warnHi = 0.3092666268348694;
        double compvoltage_warnLo = 0.9946192502975464;
        double compvoltage_limitHi = 0.8228532075881958;
        double compvoltage_limitLo = 0.8266887664794922;
        double coolflowrate_warnHi = 0.140167236328125;
        double coolflowrate_warnLo = 0.36675918102264404;
        double coolflowrate_limitHi = 0.9616162776947021;
        double coolflowrate_limitLo = 0.20355886220932007;
        double coolvalveposn_warnHi = 0.06938314437866211;
        double coolvalveposn_warnLo = 0.885668f;
        double coolvalveposn_limitHi = 0.4787197709083557;
        double coolvalveposn_limitLo = 0.7090548872947693;
        double dischrgprs_warnHi = 0.5793200731277466;
        double dischrgprs_warnLo = 0.5293838381767273;
        double dischrgprs_limitHi = 0.0858263373374939;
        double dischrgprs_limitLo = 0.8258102536201477;
        double dischrgtmp_M_warnHi = 0.0721203088760376;
        double dischrgtmp_M_warnLo = 0.2859575152397156;
        double dischrgtmp_M_limitHi = 0.12554824352264404;
        double dischrgtmp_M_limitLo = 0.4413476586341858;
        double dischrgtmp_P_warnHi = 0.3928038477897644;
        double dischrgtmp_P_warnLo = 0.1249426007270813;
        double dischrgtmp_P_limitHi = 0.6870742440223694;
        double dischrgtmp_P_limitLo = 0.6962341070175171;
        double fan1speed_warnHi = 0.02819424867630005;
        double fan1speed_warnLo = 0.07759493589401245;
        double fan1speed_limitHi = 0.2796071767807007;
        double fan1speed_limitLo = 0.25997406244277954;
        double fan2speed_warnHi = 0.21378272771835327;
        double fan2speed_warnLo = 0.7095667123794556;
        double fan2speed_limitHi = 0.2569117546081543;
        double fan2speed_limitLo = 0.8244872093200684;
        double fan3speed_warnHi = 0.5943259000778198;
        double fan3speed_warnLo = 0.4248991012573242;
        double fan3speed_limitHi = 0.5343916416168213;
        double fan3speed_limitLo = 0.7275944948196411;
        double hgbvalveposn_warnHi = 0.8179831504821777;
        double hgbvalveposn_warnLo = 0.7096013426780701;
        double hgbvalveposn_limitHi = 0.2837026119232178;
        double hgbvalveposn_limitLo = 0.7916221618652344;
        double liquidsubcooling_warnHi = 0.10853838920593262;
        double liquidsubcooling_warnLo = 0.6353712677955627;
        double liquidsubcooling_limitHi = 0.8158840537071228;
        double liquidsubcooling_limitLo = 0.15866601467132568;
        double liquidtmp_M_warnHi = 0.58169f;
        double liquidtmp_M_warnLo = 0.9305132627487183;
        double liquidtmp_M_limitHi = 0.49988818168640137;
        double liquidtmp_M_limitLo = 0.9259874224662781;
        double liquidtmp_P_warnHi = 0.7411353588104248;
        double liquidtmp_P_warnLo = 0.370410680770874;
        double liquidtmp_P_limitHi = 0.4273747205734253;
        double liquidtmp_P_limitLo = 0.11232644319534302;
        double suctionprs_warnHi = 0.11544859409332275;
        double suctionprs_warnLo = 0.531707f;
        double suctionprs_limitHi = 0.3855026960372925;
        double suctionprs_limitLo = 0.12662345170974731;
        double suctiontmp_M_warnHi = 0.55040442943573;
        double suctiontmp_M_warnLo = 0.4334644079208374;
        double suctiontmp_M_limitHi = 0.18660622835159302;
        double suctiontmp_M_limitLo = 0.7508691549301147;
        double suctiontmp_P_warnHi = 0.941911518573761;
        double suctiontmp_P_warnLo = 0.798945963382721;
        double suctiontmp_P_limitHi = 0.3171289563179016;
        double suctiontmp_P_limitLo = 0.3028132915496826;
        double waterintmp_warnHi = 0.6361914873123169;
        double waterintmp_warnLo = 0.610375702381134;
        double waterintmp_limitHi = 0.38867151737213135;
        double waterintmp_limitLo = 0.3044389f;
        double waterouttmp_warnHi = 0.8059951663017273;
        double waterouttmp_warnLo = 0.996269166469574;
        double waterouttmp_limitHi = 0.8227730989456177;
        double waterouttmp_limitLo = 0.6689545512199402;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cold2_LimitsSettingsAppliedEvent(priority, version, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvfdcurr_warnHi, compvfdcurr_warnLo, compvfdcurr_limitHi, compvfdcurr_limitLo, compvfdfreq_warnHi, compvfdfreq_warnLo, compvfdfreq_limitHi, compvfdfreq_limitLo, compvfdvolt_warnHi, compvfdvolt_warnLo, compvfdvolt_limitHi, compvfdvolt_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, coolflowrate_warnHi, coolflowrate_warnLo, coolflowrate_limitHi, coolflowrate_limitLo, coolvalveposn_warnHi, coolvalveposn_warnLo, coolvalveposn_limitHi, coolvalveposn_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fan1speed_warnHi, fan1speed_warnLo, fan1speed_limitHi, fan1speed_limitLo, fan2speed_warnHi, fan2speed_warnLo, fan2speed_limitHi, fan2speed_limitLo, fan3speed_warnHi, fan3speed_warnLo, fan3speed_limitHi, fan3speed_limitLo, hgbvalveposn_warnHi, hgbvalveposn_warnLo, hgbvalveposn_limitHi, hgbvalveposn_limitLo, liquidsubcooling_warnHi, liquidsubcooling_warnLo, liquidsubcooling_limitHi, liquidsubcooling_limitLo, liquidtmp_M_warnHi, liquidtmp_M_warnLo, liquidtmp_M_limitHi, liquidtmp_M_limitLo, liquidtmp_P_warnHi, liquidtmp_P_warnLo, liquidtmp_P_limitHi, liquidtmp_P_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cold2_LimitsSettingsAppliedEvent));
        Refrig_Cold2_LimitsSettingsAppliedEvent item_ = (Refrig_Cold2_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnHi, (double)item_.getCompvfdcurr_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_warnLo, (double)item_.getCompvfdcurr_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitHi, (double)item_.getCompvfdcurr_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdcurr_limitLo, (double)item_.getCompvfdcurr_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnHi, (double)item_.getCompvfdfreq_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_warnLo, (double)item_.getCompvfdfreq_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitHi, (double)item_.getCompvfdfreq_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdfreq_limitLo, (double)item_.getCompvfdfreq_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnHi, (double)item_.getCompvfdvolt_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_warnLo, (double)item_.getCompvfdvolt_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitHi, (double)item_.getCompvfdvolt_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvfdvolt_limitLo, (double)item_.getCompvfdvolt_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnHi, (double)item_.getCoolflowrate_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_warnLo, (double)item_.getCoolflowrate_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitHi, (double)item_.getCoolflowrate_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolflowrate_limitLo, (double)item_.getCoolflowrate_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnHi, (double)item_.getCoolvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_warnLo, (double)item_.getCoolvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitHi, (double)item_.getCoolvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)coolvalveposn_limitLo, (double)item_.getCoolvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnHi, (double)item_.getFan1speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_warnLo, (double)item_.getFan1speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitHi, (double)item_.getFan1speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan1speed_limitLo, (double)item_.getFan1speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnHi, (double)item_.getFan2speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_warnLo, (double)item_.getFan2speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitHi, (double)item_.getFan2speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan2speed_limitLo, (double)item_.getFan2speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnHi, (double)item_.getFan3speed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_warnLo, (double)item_.getFan3speed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitHi, (double)item_.getFan3speed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fan3speed_limitLo, (double)item_.getFan3speed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnHi, (double)item_.getHgbvalveposn_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_warnLo, (double)item_.getHgbvalveposn_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitHi, (double)item_.getHgbvalveposn_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)hgbvalveposn_limitLo, (double)item_.getHgbvalveposn_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnHi, (double)item_.getLiquidsubcooling_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_warnLo, (double)item_.getLiquidsubcooling_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitHi, (double)item_.getLiquidsubcooling_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidsubcooling_limitLo, (double)item_.getLiquidsubcooling_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnHi, (double)item_.getLiquidtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_warnLo, (double)item_.getLiquidtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitHi, (double)item_.getLiquidtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_M_limitLo, (double)item_.getLiquidtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnHi, (double)item_.getLiquidtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_warnLo, (double)item_.getLiquidtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitHi, (double)item_.getLiquidtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidtmp_P_limitLo, (double)item_.getLiquidtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_CoolMaq20_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 18;
        int version = 430;
        String node = "";
        String serials = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_CoolMaq20_DeviceSettingsAppliedEvent(priority, version, node, serials));
        Assert.assertTrue((boolean)(item instanceof Refrig_CoolMaq20_DeviceSettingsAppliedEvent));
        Refrig_CoolMaq20_DeviceSettingsAppliedEvent item_ = (Refrig_CoolMaq20_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
        Assert.assertEquals((Object)serials, (Object)item_.getSerials());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 532;
        int version = 301;
        double cmprPowerDelayLimit = 0.5056788325309753;
        int cmprPowerDelayTime = 442;
        double cmprPowerImmedLimit = 0.545616090297699;
        double coldTempImmedLimit = 0.35282236337661743;
        double discPressDelayLimit = 0.30199337005615234;
        int discPressDelayTime = 808;
        double discPressImmedLimit = 0.02047944f;
        double discTempDelayLimit = 0.1660524f;
        int discTempDelayTime = 871;
        double discTempImmedLimit = 0.521131f;
        double discTempLowImmedLimit = 0.2465037703514099;
        double heaterTempLimit = 0.830807626247406;
        double liquidTempDelayLimit = 0.10707056522369385;
        int liquidTempDelayTime = 369;
        double liquidTempImmedLimit = 0.1554531455039978;
        double orificeOffPress = 0.09999215602874756;
        double orificeOnPress = 0.1573919f;
        double phaseSepTempDelayLimit = 0.895658016204834;
        int phaseSepTempDelayTime = 883;
        double pressDiffImmedLimit = 0.11442923545837402;
        double suctTempImmedLimit = 0.4659762978553772;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_CompLimitsSettingsAppliedEvent));
        Refrig_Cryo1_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cryo1_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo1_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 903;
        int version = 990;
        String maq20_node = "u";
        String maq20_serials = "";
        String plc_node = "t";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_DeviceSettingsAppliedEvent));
        Refrig_Cryo1_DeviceSettingsAppliedEvent item_ = (Refrig_Cryo1_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo1_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 352;
        int version = 587;
        double aftercooltmp_warnHi = 0.1390208601951599;
        double aftercooltmp_warnLo = 0.779719f;
        double aftercooltmp_limitHi = 0.9887209534645081;
        double aftercooltmp_limitLo = 0.277072012424469;
        double compcurrent_warnHi = 0.915184736251831;
        double compcurrent_warnLo = 0.538340151309967;
        double compcurrent_limitHi = 0.42300945520401;
        double compcurrent_limitLo = 0.6953703761100769;
        double comppower_warnHi = 0.9652260541915894;
        double comppower_warnLo = 0.14212846755981445;
        double comppower_limitHi = 0.733724f;
        double comppower_limitLo = 0.6471393704414368;
        double compvoltage_warnHi = 0.9887987971305847;
        double compvoltage_warnLo = 0.9968788623809814;
        double compvoltage_limitHi = 0.8430869579315186;
        double compvoltage_limitLo = 0.3988179f;
        double dischrgprs_warnHi = 0.4897953271865845;
        double dischrgprs_warnLo = 0.26867908239364624;
        double dischrgprs_limitHi = 0.8790637850761414;
        double dischrgprs_limitLo = 0.2067958116531372;
        double dischrgtmp_M_warnHi = 0.8197957873344421;
        double dischrgtmp_M_warnLo = 0.5233194828033447;
        double dischrgtmp_M_limitHi = 0.4429087f;
        double dischrgtmp_M_limitLo = 0.07633805274963379;
        double dischrgtmp_P_warnHi = 0.021564245223999023;
        double dischrgtmp_P_warnLo = 0.1617315411567688;
        double dischrgtmp_P_limitHi = 0.0942736268043518;
        double dischrgtmp_P_limitLo = 0.15730106830596924;
        double fanspeed_warnHi = 0.3211820721626282;
        double fanspeed_warnLo = 0.87872f;
        double fanspeed_limitHi = 0.04913193f;
        double fanspeed_limitLo = 0.9343748688697815;
        double oillevel_warnHi = 0.11765807867050171;
        double oillevel_warnLo = 0.9988874793052673;
        double oillevel_limitHi = 0.7465725541114807;
        double oillevel_limitLo = 0.3558666706085205;
        double oilseptmp_warnHi = 0.3533428907394409;
        double oilseptmp_warnLo = 0.996278703212738;
        double oilseptmp_limitHi = 0.8528434634208679;
        double oilseptmp_limitLo = 0.291401743888855;
        double phaseseptmp_warnHi = 0.4994316101074219;
        double phaseseptmp_warnLo = 0.04557693004608154;
        double phaseseptmp_limitHi = 0.5686679482460022;
        double phaseseptmp_limitLo = 0.2983502149581909;
        double suctionprs_warnHi = 0.6061123609542847;
        double suctionprs_warnLo = 0.2985035181045532;
        double suctionprs_limitHi = 0.813226f;
        double suctionprs_limitLo = 0.7704379558563232;
        double suctiontmp_M_warnHi = 0.009990692138671875;
        double suctiontmp_M_warnLo = 0.14833104610443115;
        double suctiontmp_M_limitHi = 0.14033353328704834;
        double suctiontmp_M_limitLo = 0.6291144490242004;
        double suctiontmp_P_warnHi = 0.19138479232788086;
        double suctiontmp_P_warnLo = 0.910206f;
        double suctiontmp_P_limitHi = 0.6549215912818909;
        double suctiontmp_P_limitLo = 0.8662184476852417;
        double surgetanktmp_warnHi = 0.7756784558296204;
        double surgetanktmp_warnLo = 0.6804755330085754;
        double surgetanktmp_limitHi = 0.9372109174728394;
        double surgetanktmp_limitLo = 0.3508124351501465;
        double waterintmp_warnHi = 0.8864843845367432;
        double waterintmp_warnLo = 0.1727469563484192;
        double waterintmp_limitHi = 0.13490456342697144;
        double waterintmp_limitLo = 0.3473753333091736;
        double waterouttmp_warnHi = 0.6098875999450684;
        double waterouttmp_warnLo = 0.7934238314628601;
        double waterouttmp_limitHi = 0.1778220534324646;
        double waterouttmp_limitLo = 0.4586156f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo1_LimitsSettingsAppliedEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo1_LimitsSettingsAppliedEvent));
        Refrig_Cryo1_LimitsSettingsAppliedEvent item_ = (Refrig_Cryo1_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 737;
        int version = 955;
        double cmprPowerDelayLimit = 0.12283968925476074;
        int cmprPowerDelayTime = 144;
        double cmprPowerImmedLimit = 0.35478538274765015;
        double coldTempImmedLimit = 0.9644457697868347;
        double discPressDelayLimit = 0.20856934785842896;
        int discPressDelayTime = 865;
        double discPressImmedLimit = 0.6355234384536743;
        double discTempDelayLimit = 0.10355937480926514;
        int discTempDelayTime = 501;
        double discTempImmedLimit = 0.9260600805282593;
        double discTempLowImmedLimit = 0.295015811920166;
        double heaterTempLimit = 0.12573248147964478;
        double liquidTempDelayLimit = 0.7065396308898926;
        int liquidTempDelayTime = 296;
        double liquidTempImmedLimit = 0.24975663423538208;
        double orificeOffPress = 0.4749488830566406;
        double orificeOnPress = 0.3190044164657593;
        double phaseSepTempDelayLimit = 0.20412278175354004;
        int phaseSepTempDelayTime = 570;
        double pressDiffImmedLimit = 0.10977274179458618;
        double suctTempImmedLimit = 0.5512157082557678;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_CompLimitsSettingsAppliedEvent));
        Refrig_Cryo2_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cryo2_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo2_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 446;
        int version = 910;
        String maq20_node = "g";
        String maq20_serials = "";
        String plc_node = "e";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_DeviceSettingsAppliedEvent));
        Refrig_Cryo2_DeviceSettingsAppliedEvent item_ = (Refrig_Cryo2_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo2_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 990;
        int version = 551;
        double aftercooltmp_warnHi = 0.8585658669471741;
        double aftercooltmp_warnLo = 0.6897554993629456;
        double aftercooltmp_limitHi = 0.7235310673713684;
        double aftercooltmp_limitLo = 0.2210521101951599;
        double compcurrent_warnHi = 8.614659309387207E-4;
        double compcurrent_warnLo = 0.758385f;
        double compcurrent_limitHi = 0.986163318157196;
        double compcurrent_limitLo = 0.8220734000205994;
        double comppower_warnHi = 0.2030126452445984;
        double comppower_warnLo = 0.1932382583618164;
        double comppower_limitHi = 0.062367022037506104;
        double comppower_limitLo = 0.7379392981529236;
        double compvoltage_warnHi = 0.7134362459182739;
        double compvoltage_warnLo = 0.3505188226699829;
        double compvoltage_limitHi = 0.09814947843551636;
        double compvoltage_limitLo = 0.16175276041030884;
        double dischrgprs_warnHi = 0.8024162650108337;
        double dischrgprs_warnLo = 0.8596912026405334;
        double dischrgprs_limitHi = 0.41652631759643555;
        double dischrgprs_limitLo = 0.27237361669540405;
        double dischrgtmp_M_warnHi = 0.9842463135719299;
        double dischrgtmp_M_warnLo = 0.8040790557861328;
        double dischrgtmp_M_limitHi = 0.344898521900177;
        double dischrgtmp_M_limitLo = 0.7289501428604126;
        double dischrgtmp_P_warnHi = 0.9045096039772034;
        double dischrgtmp_P_warnLo = 0.7711588144302368;
        double dischrgtmp_P_limitHi = 0.22900527715682983;
        double dischrgtmp_P_limitLo = 0.6242959499359131;
        double fanspeed_warnHi = 0.796847939491272;
        double fanspeed_warnLo = 0.19282597303390503;
        double fanspeed_limitHi = 0.22758746147155762;
        double fanspeed_limitLo = 0.4324553608894348;
        double oillevel_warnHi = 0.3753041625022888;
        double oillevel_warnLo = 0.16835826635360718;
        double oillevel_limitHi = 0.5050604343414307;
        double oillevel_limitLo = 0.06370240449905396;
        double oilseptmp_warnHi = 0.7674635052680969;
        double oilseptmp_warnLo = 0.06612330675125122;
        double oilseptmp_limitHi = 0.24641722440719604;
        double oilseptmp_limitLo = 0.4908837676048279;
        double phaseseptmp_warnHi = 0.5330145359039307;
        double phaseseptmp_warnLo = 0.7250893115997314;
        double phaseseptmp_limitHi = 0.9086655378341675;
        double phaseseptmp_limitLo = 0.5705804228782654;
        double suctionprs_warnHi = 0.3904784321784973;
        double suctionprs_warnLo = 0.3178486227989197;
        double suctionprs_limitHi = 0.8363955616950989;
        double suctionprs_limitLo = 0.01528573f;
        double suctiontmp_M_warnHi = 0.19582092761993408;
        double suctiontmp_M_warnLo = 0.6402224898338318;
        double suctiontmp_M_limitHi = 0.7362356781959534;
        double suctiontmp_M_limitLo = 0.9210574626922607;
        double suctiontmp_P_warnHi = 0.2001828f;
        double suctiontmp_P_warnLo = 0.2087729573249817;
        double suctiontmp_P_limitHi = 0.0972716212272644;
        double suctiontmp_P_limitLo = 0.5894113183021545;
        double surgetanktmp_warnHi = 0.14540356397628784;
        double surgetanktmp_warnLo = 0.48003554344177246;
        double surgetanktmp_limitHi = 0.9238985776901245;
        double surgetanktmp_limitLo = 0.4512117f;
        double waterintmp_warnHi = 0.33633846044540405;
        double waterintmp_warnLo = 0.3604347f;
        double waterintmp_limitHi = 0.716579020023346;
        double waterintmp_limitLo = 0.8807411193847656;
        double waterouttmp_warnHi = 0.22478598356246948;
        double waterouttmp_warnLo = 0.01323777437210083;
        double waterouttmp_limitHi = 0.48775774240493774;
        double waterouttmp_limitLo = 0.3348802924156189;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo2_LimitsSettingsAppliedEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo2_LimitsSettingsAppliedEvent));
        Refrig_Cryo2_LimitsSettingsAppliedEvent item_ = (Refrig_Cryo2_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 116;
        int version = 259;
        double cmprPowerDelayLimit = 0.3685334324836731;
        int cmprPowerDelayTime = 127;
        double cmprPowerImmedLimit = 0.5868754982948303;
        double coldTempImmedLimit = 0.2468433380126953;
        double discPressDelayLimit = 0.5710065364837646;
        int discPressDelayTime = 605;
        double discPressImmedLimit = 0.36650723218917847;
        double discTempDelayLimit = 0.3143569827079773;
        int discTempDelayTime = 663;
        double discTempImmedLimit = 0.7533522248268127;
        double discTempLowImmedLimit = 0.189189612865448;
        double heaterTempLimit = 0.4931233525276184;
        double liquidTempDelayLimit = 0.5774151682853699;
        int liquidTempDelayTime = 181;
        double liquidTempImmedLimit = 0.18275481462478638;
        double orificeOffPress = 0.6625542044639587;
        double orificeOnPress = 0.65358f;
        double phaseSepTempDelayLimit = 0.4216992259025574;
        int phaseSepTempDelayTime = 296;
        double pressDiffImmedLimit = 0.576188862323761;
        double suctTempImmedLimit = 0.7076285481452942;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_CompLimitsSettingsAppliedEvent));
        Refrig_Cryo3_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cryo3_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo3_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 599;
        int version = 168;
        String maq20_node = "q";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_DeviceSettingsAppliedEvent));
        Refrig_Cryo3_DeviceSettingsAppliedEvent item_ = (Refrig_Cryo3_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo3_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 937;
        int version = 547;
        double aftercooltmp_warnHi = 0.47678375244140625;
        double aftercooltmp_warnLo = 0.9815229177474976;
        double aftercooltmp_limitHi = 0.8861351013183594;
        double aftercooltmp_limitLo = 0.26060914993286133;
        double ambienttmp_warnHi = 0.40995967388153076;
        double ambienttmp_warnLo = 0.3302185535430908;
        double ambienttmp_limitHi = 0.2610187530517578;
        double ambienttmp_limitLo = 0.540095865726471;
        double cabinettmp_warnHi = 0.1026091f;
        double cabinettmp_warnLo = 0.4469099f;
        double cabinettmp_limitHi = 0.22739005088806152;
        double cabinettmp_limitLo = 0.09896194934844971;
        double compcurrent_warnHi = 0.5870565176010132;
        double compcurrent_warnLo = 0.5822194218635559;
        double compcurrent_limitHi = 0.5386918187141418;
        double compcurrent_limitLo = 0.6131938695907593;
        double comppower_warnHi = 0.8008796572685242;
        double comppower_warnLo = 0.2701093554496765;
        double comppower_limitHi = 0.18812376260757446;
        double comppower_limitLo = 0.3437894f;
        double compvoltage_warnHi = 0.0325050950050354;
        double compvoltage_warnLo = 0.9351528882980347;
        double compvoltage_limitHi = 0.2944710850715637;
        double compvoltage_limitLo = 0.17696022987365723;
        double dischrgprs_warnHi = 0.8251739144325256;
        double dischrgprs_warnLo = 0.5536596179008484;
        double dischrgprs_limitHi = 0.012217521667480469;
        double dischrgprs_limitLo = 0.2790037989616394;
        double dischrgtmp_M_warnHi = 0.8167297840118408;
        double dischrgtmp_M_warnLo = 0.2526538372039795;
        double dischrgtmp_M_limitHi = 0.37689924240112305;
        double dischrgtmp_M_limitLo = 0.72347092628479;
        double dischrgtmp_P_warnHi = 0.7146243453025818;
        double dischrgtmp_P_warnLo = 0.4205285906791687;
        double dischrgtmp_P_limitHi = 0.9744883179664612;
        double dischrgtmp_P_limitLo = 0.8269518613815308;
        double fanspeed_warnHi = 0.5299327373504639;
        double fanspeed_warnLo = 0.12921392917633057;
        double fanspeed_limitHi = 0.8403084874153137;
        double fanspeed_limitLo = 0.2651034f;
        double oillevel_warnHi = 0.2321536f;
        double oillevel_warnLo = 0.24338674545288086;
        double oillevel_limitHi = 0.2175209f;
        double oillevel_limitLo = 0.24748414754867554;
        double oilseptmp_warnHi = 0.3773950934410095;
        double oilseptmp_warnLo = 0.0967077f;
        double oilseptmp_limitHi = 0.3596503f;
        double oilseptmp_limitLo = 0.41401517391204834;
        double phaseseptmp_warnHi = 0.8236048221588135;
        double phaseseptmp_warnLo = 0.64303f;
        double phaseseptmp_limitHi = 0.7711450457572937;
        double phaseseptmp_limitLo = 0.6237296462059021;
        double suctionprs_warnHi = 0.023287057876586914;
        double suctionprs_warnLo = 0.40233057737350464;
        double suctionprs_limitHi = 0.4228951930999756;
        double suctionprs_limitLo = 0.2748332f;
        double suctiontmp_M_warnHi = 0.30031102895736694;
        double suctiontmp_M_warnLo = 0.6927521824836731;
        double suctiontmp_M_limitHi = 0.037424683570861816;
        double suctiontmp_M_limitLo = 0.2015022f;
        double suctiontmp_P_warnHi = 0.024693548679351807;
        double suctiontmp_P_warnLo = 0.7132042646408081;
        double suctiontmp_P_limitHi = 0.4456857442855835;
        double suctiontmp_P_limitLo = 0.9054670929908752;
        double surgetanktmp_warnHi = 0.3275317f;
        double surgetanktmp_warnLo = 0.17269080877304077;
        double surgetanktmp_limitHi = 0.9117224216461182;
        double surgetanktmp_limitLo = 0.9080513715744019;
        double waterintmp_warnHi = 0.40556687116622925;
        double waterintmp_warnLo = 0.7757561802864075;
        double waterintmp_limitHi = 0.793748f;
        double waterintmp_limitLo = 0.250373f;
        double waterouttmp_warnHi = 0.08731728792190552;
        double waterouttmp_warnLo = 0.9066471457481384;
        double waterouttmp_limitHi = 0.7543467879295349;
        double waterouttmp_limitLo = 0.6659121513366699;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo3_LimitsSettingsAppliedEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo3_LimitsSettingsAppliedEvent));
        Refrig_Cryo3_LimitsSettingsAppliedEvent item_ = (Refrig_Cryo3_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 582;
        int version = 185;
        double cmprPowerDelayLimit = 0.1956343650817871;
        int cmprPowerDelayTime = 813;
        double cmprPowerImmedLimit = 0.17674553394317627;
        double coldTempImmedLimit = 0.1836094856262207;
        double discPressDelayLimit = 0.6274861693382263;
        int discPressDelayTime = 639;
        double discPressImmedLimit = 0.9913501739501953;
        double discTempDelayLimit = 0.27084267139434814;
        int discTempDelayTime = 45;
        double discTempImmedLimit = 0.09214985370635986;
        double discTempLowImmedLimit = 0.4011055827140808;
        double heaterTempLimit = 0.017182588577270508;
        double liquidTempDelayLimit = 0.568577766418457;
        int liquidTempDelayTime = 494;
        double liquidTempImmedLimit = 0.03229391574859619;
        double orificeOffPress = 0.46688413619995117;
        double orificeOnPress = 0.9947351813316345;
        double phaseSepTempDelayLimit = 0.6388403177261353;
        int phaseSepTempDelayTime = 955;
        double pressDiffImmedLimit = 0.5283551812171936;
        double suctTempImmedLimit = 0.18395566940307617;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_CompLimitsSettingsAppliedEvent));
        Refrig_Cryo4_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cryo4_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo4_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 481;
        int version = 929;
        String maq20_node = "k";
        String maq20_serials = "q";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_DeviceSettingsAppliedEvent));
        Refrig_Cryo4_DeviceSettingsAppliedEvent item_ = (Refrig_Cryo4_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo4_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 795;
        int version = 428;
        double aftercooltmp_warnHi = 0.5618872046470642;
        double aftercooltmp_warnLo = 0.05482828617095947;
        double aftercooltmp_limitHi = 0.8134623169898987;
        double aftercooltmp_limitLo = 0.8410322666168213;
        double compcurrent_warnHi = 0.3022293448448181;
        double compcurrent_warnLo = 0.6503296494483948;
        double compcurrent_limitHi = 0.9587438702583313;
        double compcurrent_limitLo = 0.8108999133110046;
        double comppower_warnHi = 4.579425E-4f;
        double comppower_warnLo = 0.28082817792892456;
        double comppower_limitHi = 0.4031602740287781;
        double comppower_limitLo = 0.4547199010848999;
        double compvoltage_warnHi = 0.9335781931877136;
        double compvoltage_warnLo = 0.6341502070426941;
        double compvoltage_limitHi = 0.9904511570930481;
        double compvoltage_limitLo = 0.30330485105514526;
        double dischrgprs_warnHi = 0.9470493793487549;
        double dischrgprs_warnLo = 0.9195677042007446;
        double dischrgprs_limitHi = 0.3380838632583618;
        double dischrgprs_limitLo = 0.3089866042137146;
        double dischrgtmp_M_warnHi = 0.1393022f;
        double dischrgtmp_M_warnLo = 0.2666983f;
        double dischrgtmp_M_limitHi = 0.605151891708374;
        double dischrgtmp_M_limitLo = 0.6058160662651062;
        double dischrgtmp_P_warnHi = 0.8867303133010864;
        double dischrgtmp_P_warnLo = 0.4610862731933594;
        double dischrgtmp_P_limitHi = 0.5934098958969116;
        double dischrgtmp_P_limitLo = 0.12129944562911987;
        double fanspeed_warnHi = 0.3975124955177307;
        double fanspeed_warnLo = 0.36742645502090454;
        double fanspeed_limitHi = 0.6493446826934814;
        double fanspeed_limitLo = 0.8481138944625854;
        double oillevel_warnHi = 0.24405282735824585;
        double oillevel_warnLo = 0.04184520244598389;
        double oillevel_limitHi = 0.553186297416687;
        double oillevel_limitLo = 0.04808610677719116;
        double oilseptmp_warnHi = 0.8101748824119568;
        double oilseptmp_warnLo = 0.669546365737915;
        double oilseptmp_limitHi = 0.6960483193397522;
        double oilseptmp_limitLo = 0.14659267663955688;
        double phaseseptmp_warnHi = 0.8209753632545471;
        double phaseseptmp_warnLo = 0.3188077211380005;
        double phaseseptmp_limitHi = 0.5122677683830261;
        double phaseseptmp_limitLo = 0.7953612804412842;
        double suctionprs_warnHi = 0.699066162109375;
        double suctionprs_warnLo = 0.8277574181556702;
        double suctionprs_limitHi = 0.7069417238235474;
        double suctionprs_limitLo = 0.8879616260528564;
        double suctiontmp_M_warnHi = 0.33757346868515015;
        double suctiontmp_M_warnLo = 0.4531694f;
        double suctiontmp_M_limitHi = 0.10819530487060547;
        double suctiontmp_M_limitLo = 0.948234498500824;
        double suctiontmp_P_warnHi = 0.5025935769081116;
        double suctiontmp_P_warnLo = 0.7429161667823792;
        double suctiontmp_P_limitHi = 0.49256646633148193;
        double suctiontmp_P_limitLo = 0.6613069176673889;
        double surgetanktmp_warnHi = 0.808845579624176;
        double surgetanktmp_warnLo = 0.24356502294540405;
        double surgetanktmp_limitHi = 0.945868f;
        double surgetanktmp_limitLo = 0.6540940403938293;
        double waterintmp_warnHi = 0.4631303548812866;
        double waterintmp_warnLo = 0.435367226600647;
        double waterintmp_limitHi = 0.8999431133270264;
        double waterintmp_limitLo = 0.3723371624946594;
        double waterouttmp_warnHi = 0.4801780581474304;
        double waterouttmp_warnLo = 0.7776781320571899;
        double waterouttmp_limitHi = 0.049924612045288086;
        double waterouttmp_limitLo = 0.849928081035614;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo4_LimitsSettingsAppliedEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo4_LimitsSettingsAppliedEvent));
        Refrig_Cryo4_LimitsSettingsAppliedEvent item_ = (Refrig_Cryo4_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 435;
        int version = 313;
        double cmprPowerDelayLimit = 0.7321491241455078;
        int cmprPowerDelayTime = 604;
        double cmprPowerImmedLimit = 0.43954282999038696;
        double coldTempImmedLimit = 0.5815322399139404;
        double discPressDelayLimit = 0.8080740571022034;
        int discPressDelayTime = 132;
        double discPressImmedLimit = 0.4321204423904419;
        double discTempDelayLimit = 0.6491281390190125;
        int discTempDelayTime = 806;
        double discTempImmedLimit = 0.3417816758155823;
        double discTempLowImmedLimit = 0.8262566924095154;
        double heaterTempLimit = 0.1373441219329834;
        double liquidTempDelayLimit = 0.7531834840774536;
        int liquidTempDelayTime = 453;
        double liquidTempImmedLimit = 0.5608363747596741;
        double orificeOffPress = 0.5418193340301514;
        double orificeOnPress = 0.5804728865623474;
        double phaseSepTempDelayLimit = 0.2977433204650879;
        int phaseSepTempDelayTime = 206;
        double pressDiffImmedLimit = 0.8136701583862305;
        double suctTempImmedLimit = 0.8727527260780334;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_CompLimitsSettingsAppliedEvent));
        Refrig_Cryo5_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cryo5_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo5_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 347;
        int version = 780;
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_DeviceSettingsAppliedEvent));
        Refrig_Cryo5_DeviceSettingsAppliedEvent item_ = (Refrig_Cryo5_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo5_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 975;
        int version = 88;
        double aftercooltmp_warnHi = 0.13147515058517456;
        double aftercooltmp_warnLo = 0.26106226444244385;
        double aftercooltmp_limitHi = 0.8099966645240784;
        double aftercooltmp_limitLo = 0.8740232586860657;
        double ambienttmp_warnHi = 0.14178311824798584;
        double ambienttmp_warnLo = 0.17586815357208252;
        double ambienttmp_limitHi = 0.3382815718650818;
        double ambienttmp_limitLo = 0.6187385320663452;
        double cabinettmp_warnHi = 0.545904278755188;
        double cabinettmp_warnLo = 0.40586984157562256;
        double cabinettmp_limitHi = 0.8204331398010254;
        double cabinettmp_limitLo = 0.4479323f;
        double compcurrent_warnHi = 0.3169436454772949;
        double compcurrent_warnLo = 0.07807135581970215;
        double compcurrent_limitHi = 0.07647973299026489;
        double compcurrent_limitLo = 0.44509416818618774;
        double comppower_warnHi = 0.45981645584106445;
        double comppower_warnLo = 0.9981975555419922;
        double comppower_limitHi = 0.17241257429122925;
        double comppower_limitLo = 0.1978340744972229;
        double compvoltage_warnHi = 0.17217093706130981;
        double compvoltage_warnLo = 0.6790739297866821;
        double compvoltage_limitHi = 0.10500502586364746;
        double compvoltage_limitLo = 0.4812912344932556;
        double dischrgprs_warnHi = 0.6346797943115234;
        double dischrgprs_warnLo = 0.16317439079284668;
        double dischrgprs_limitHi = 0.47433704137802124;
        double dischrgprs_limitLo = 0.7452647686004639;
        double dischrgtmp_M_warnHi = 0.5059914588928223;
        double dischrgtmp_M_warnLo = 0.856564462184906;
        double dischrgtmp_M_limitHi = 0.2917814254760742;
        double dischrgtmp_M_limitLo = 0.8130668997764587;
        double dischrgtmp_P_warnHi = 0.3917103409767151;
        double dischrgtmp_P_warnLo = 0.19739621877670288;
        double dischrgtmp_P_limitHi = 0.2953476905822754;
        double dischrgtmp_P_limitLo = 0.004425227642059326;
        double fanspeed_warnHi = 0.8903229236602783;
        double fanspeed_warnLo = 0.5085130333900452;
        double fanspeed_limitHi = 0.04353010654449463;
        double fanspeed_limitLo = 0.7548102736473083;
        double oillevel_warnHi = 0.3203164339065552;
        double oillevel_warnLo = 0.4175090789794922;
        double oillevel_limitHi = 0.1067974f;
        double oillevel_limitLo = 0.8453167080879211;
        double oilseptmp_warnHi = 0.13330018520355225;
        double oilseptmp_warnLo = 0.49629926681518555;
        double oilseptmp_limitHi = 0.6743577122688293;
        double oilseptmp_limitLo = 0.47228187322616577;
        double phaseseptmp_warnHi = 0.0023023486137390137;
        double phaseseptmp_warnLo = 0.3940557837486267;
        double phaseseptmp_limitHi = 0.22270601987838745;
        double phaseseptmp_limitLo = 0.48140984773635864;
        double suctionprs_warnHi = 0.030275821685791016;
        double suctionprs_warnLo = 0.4710425138473511;
        double suctionprs_limitHi = 0.7597308158874512;
        double suctionprs_limitLo = 0.3401355f;
        double suctiontmp_M_warnHi = 0.7920231819152832;
        double suctiontmp_M_warnLo = 0.4358493685722351;
        double suctiontmp_M_limitHi = 0.849946916103363;
        double suctiontmp_M_limitLo = 0.5127871036529541;
        double suctiontmp_P_warnHi = 0.5471908450126648;
        double suctiontmp_P_warnLo = 0.5348250865936279;
        double suctiontmp_P_limitHi = 0.756996214389801;
        double suctiontmp_P_limitLo = 0.2898898720741272;
        double surgetanktmp_warnHi = 0.9397528767585754;
        double surgetanktmp_warnLo = 0.6208028793334961;
        double surgetanktmp_limitHi = 0.8012942671775818;
        double surgetanktmp_limitLo = 0.2754226326942444;
        double waterintmp_warnHi = 0.530706524848938;
        double waterintmp_warnLo = 0.7597888112068176;
        double waterintmp_limitHi = 0.4441121816635132;
        double waterintmp_limitLo = 0.38934582471847534;
        double waterouttmp_warnHi = 0.24884724617004395;
        double waterouttmp_warnLo = 0.6310590505599976;
        double waterouttmp_limitHi = 0.7730971574783325;
        double waterouttmp_limitLo = 0.6482424736022949;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo5_LimitsSettingsAppliedEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, ambienttmp_warnHi, ambienttmp_warnLo, ambienttmp_limitHi, ambienttmp_limitLo, cabinettmp_warnHi, cabinettmp_warnLo, cabinettmp_limitHi, cabinettmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo5_LimitsSettingsAppliedEvent));
        Refrig_Cryo5_LimitsSettingsAppliedEvent item_ = (Refrig_Cryo5_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnHi, (double)item_.getAmbienttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_warnLo, (double)item_.getAmbienttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitHi, (double)item_.getAmbienttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)ambienttmp_limitLo, (double)item_.getAmbienttmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnHi, (double)item_.getCabinettmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_warnLo, (double)item_.getCabinettmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitHi, (double)item_.getCabinettmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)cabinettmp_limitLo, (double)item_.getCabinettmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6_CompLimitsSettingsAppliedEvent() throws Exception {
        int priority = 600;
        int version = 303;
        double cmprPowerDelayLimit = 0.4050159f;
        int cmprPowerDelayTime = 213;
        double cmprPowerImmedLimit = 0.016855478286743164;
        double coldTempImmedLimit = 0.14342546463012695;
        double discPressDelayLimit = 0.3442254662513733;
        int discPressDelayTime = 88;
        double discPressImmedLimit = 0.5052889585494995;
        double discTempDelayLimit = 0.08975344896316528;
        int discTempDelayTime = 223;
        double discTempImmedLimit = 0.6952483654022217;
        double discTempLowImmedLimit = 0.22655218839645386;
        double heaterTempLimit = 0.5505384802818298;
        double liquidTempDelayLimit = 0.014067888259887695;
        int liquidTempDelayTime = 590;
        double liquidTempImmedLimit = 0.37096112966537476;
        double orificeOffPress = 0.3495739698410034;
        double orificeOnPress = 0.7331953048706055;
        double phaseSepTempDelayLimit = 0.44190144538879395;
        int phaseSepTempDelayTime = 928;
        double pressDiffImmedLimit = 0.3438388705253601;
        double suctTempImmedLimit = 0.6647447347640991;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_CompLimitsSettingsAppliedEvent(priority, version, cmprPowerDelayLimit, cmprPowerDelayTime, cmprPowerImmedLimit, coldTempImmedLimit, discPressDelayLimit, discPressDelayTime, discPressImmedLimit, discTempDelayLimit, discTempDelayTime, discTempImmedLimit, discTempLowImmedLimit, heaterTempLimit, liquidTempDelayLimit, liquidTempDelayTime, liquidTempImmedLimit, orificeOffPress, orificeOnPress, phaseSepTempDelayLimit, phaseSepTempDelayTime, pressDiffImmedLimit, suctTempImmedLimit));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_CompLimitsSettingsAppliedEvent));
        Refrig_Cryo6_CompLimitsSettingsAppliedEvent item_ = (Refrig_Cryo6_CompLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)cmprPowerDelayLimit, (double)item_.getCmprPowerDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)cmprPowerDelayTime, (long)item_.getCmprPowerDelayTime());
        Assert.assertEquals((double)cmprPowerImmedLimit, (double)item_.getCmprPowerImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)coldTempImmedLimit, (double)item_.getColdTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discPressDelayLimit, (double)item_.getDiscPressDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discPressDelayTime, (long)item_.getDiscPressDelayTime());
        Assert.assertEquals((double)discPressImmedLimit, (double)item_.getDiscPressImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempDelayLimit, (double)item_.getDiscTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)discTempDelayTime, (long)item_.getDiscTempDelayTime());
        Assert.assertEquals((double)discTempImmedLimit, (double)item_.getDiscTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)discTempLowImmedLimit, (double)item_.getDiscTempLowImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)heaterTempLimit, (double)item_.getHeaterTempLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)liquidTempDelayLimit, (double)item_.getLiquidTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)liquidTempDelayTime, (long)item_.getLiquidTempDelayTime());
        Assert.assertEquals((double)liquidTempImmedLimit, (double)item_.getLiquidTempImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOffPress, (double)item_.getOrificeOffPress(), (double)1.0E-6f);
        Assert.assertEquals((double)orificeOnPress, (double)item_.getOrificeOnPress(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseSepTempDelayLimit, (double)item_.getPhaseSepTempDelayLimit(), (double)1.0E-6f);
        Assert.assertEquals((long)phaseSepTempDelayTime, (long)item_.getPhaseSepTempDelayTime());
        Assert.assertEquals((double)pressDiffImmedLimit, (double)item_.getPressDiffImmedLimit(), (double)1.0E-6f);
        Assert.assertEquals((double)suctTempImmedLimit, (double)item_.getSuctTempImmedLimit(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_Cryo6_DeviceSettingsAppliedEvent() throws Exception {
        int priority = 147;
        int version = 592;
        String maq20_node = "";
        String maq20_serials = "";
        String plc_node = "z";
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_DeviceSettingsAppliedEvent(priority, version, maq20_node, maq20_serials, plc_node));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_DeviceSettingsAppliedEvent));
        Refrig_Cryo6_DeviceSettingsAppliedEvent item_ = (Refrig_Cryo6_DeviceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)maq20_node, (Object)item_.getMaq20_node());
        Assert.assertEquals((Object)maq20_serials, (Object)item_.getMaq20_serials());
        Assert.assertEquals((Object)plc_node, (Object)item_.getPlc_node());
    }

    @Test
    public void sendReceiveRefrig_Cryo6_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 800;
        int version = 621;
        double aftercooltmp_warnHi = 0.20522820949554443;
        double aftercooltmp_warnLo = 0.04169929027557373;
        double aftercooltmp_limitHi = 0.5060730576515198;
        double aftercooltmp_limitLo = 0.4233966f;
        double compcurrent_warnHi = 0.02714228630065918;
        double compcurrent_warnLo = 0.20204466581344604;
        double compcurrent_limitHi = 0.4414917230606079;
        double compcurrent_limitLo = 0.8437589406967163;
        double comppower_warnHi = 0.8764467239379883;
        double comppower_warnLo = 0.4024495482444763;
        double comppower_limitHi = 0.42289382219314575;
        double comppower_limitLo = 0.9662340879440308;
        double compvoltage_warnHi = 0.11944049596786499;
        double compvoltage_warnLo = 0.7138491868972778;
        double compvoltage_limitHi = 0.15329605340957642;
        double compvoltage_limitLo = 0.3902401328086853;
        double dischrgprs_warnHi = 0.1239391f;
        double dischrgprs_warnLo = 0.8015385270118713;
        double dischrgprs_limitHi = 0.03770667314529419;
        double dischrgprs_limitLo = 0.2436668872833252;
        double dischrgtmp_M_warnHi = 0.35733717679977417;
        double dischrgtmp_M_warnLo = 0.6375284790992737;
        double dischrgtmp_M_limitHi = 0.9946182370185852;
        double dischrgtmp_M_limitLo = 0.3443509340286255;
        double dischrgtmp_P_warnHi = 0.8494451642036438;
        double dischrgtmp_P_warnLo = 0.7361348271369934;
        double dischrgtmp_P_limitHi = 0.4846060276031494;
        double dischrgtmp_P_limitLo = 0.9953231811523438;
        double fanspeed_warnHi = 0.08402401208877563;
        double fanspeed_warnLo = 0.3612545132637024;
        double fanspeed_limitHi = 0.6111468076705933;
        double fanspeed_limitLo = 0.046657443046569824;
        double oillevel_warnHi = 0.7034997344017029;
        double oillevel_warnLo = 0.6944841146469116;
        double oillevel_limitHi = 0.4423891305923462;
        double oillevel_limitLo = 0.8195973038673401;
        double oilseptmp_warnHi = 0.8911446928977966;
        double oilseptmp_warnLo = 0.9449220299720764;
        double oilseptmp_limitHi = 0.3727429509162903;
        double oilseptmp_limitLo = 0.3365599f;
        double phaseseptmp_warnHi = 0.2162773609161377;
        double phaseseptmp_warnLo = 0.08686792850494385;
        double phaseseptmp_limitHi = 0.5236115455627441;
        double phaseseptmp_limitLo = 0.11660957336425781;
        double suctionprs_warnHi = 0.6386212110519409;
        double suctionprs_warnLo = 0.5465096235275269;
        double suctionprs_limitHi = 0.8977733850479126;
        double suctionprs_limitLo = 0.7412078380584717;
        double suctiontmp_M_warnHi = 0.33134692907333374;
        double suctiontmp_M_warnLo = 0.14201372861862183;
        double suctiontmp_M_limitHi = 0.4168702960014343;
        double suctiontmp_M_limitLo = 0.9587225317955017;
        double suctiontmp_P_warnHi = 0.8275997042655945;
        double suctiontmp_P_warnLo = 0.7852810621261597;
        double suctiontmp_P_limitHi = 0.6418435573577881;
        double suctiontmp_P_limitLo = 0.3457095f;
        double surgetanktmp_warnHi = 0.5672187209129333;
        double surgetanktmp_warnLo = 0.45319098234176636;
        double surgetanktmp_limitHi = 0.09826427698135376;
        double surgetanktmp_limitLo = 0.37387335300445557;
        double waterintmp_warnHi = 0.3292325735092163;
        double waterintmp_warnLo = 0.2597543001174927;
        double waterintmp_limitHi = 0.7892430424690247;
        double waterintmp_limitLo = 0.11749368906021118;
        double waterouttmp_warnHi = 0.9075458645820618;
        double waterouttmp_warnLo = 0.839673f;
        double waterouttmp_limitHi = 0.905518651008606;
        double waterouttmp_limitLo = 0.07874f;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_Cryo6_LimitsSettingsAppliedEvent(priority, version, aftercooltmp_warnHi, aftercooltmp_warnLo, aftercooltmp_limitHi, aftercooltmp_limitLo, compcurrent_warnHi, compcurrent_warnLo, compcurrent_limitHi, compcurrent_limitLo, comppower_warnHi, comppower_warnLo, comppower_limitHi, comppower_limitLo, compvoltage_warnHi, compvoltage_warnLo, compvoltage_limitHi, compvoltage_limitLo, dischrgprs_warnHi, dischrgprs_warnLo, dischrgprs_limitHi, dischrgprs_limitLo, dischrgtmp_M_warnHi, dischrgtmp_M_warnLo, dischrgtmp_M_limitHi, dischrgtmp_M_limitLo, dischrgtmp_P_warnHi, dischrgtmp_P_warnLo, dischrgtmp_P_limitHi, dischrgtmp_P_limitLo, fanspeed_warnHi, fanspeed_warnLo, fanspeed_limitHi, fanspeed_limitLo, oillevel_warnHi, oillevel_warnLo, oillevel_limitHi, oillevel_limitLo, oilseptmp_warnHi, oilseptmp_warnLo, oilseptmp_limitHi, oilseptmp_limitLo, phaseseptmp_warnHi, phaseseptmp_warnLo, phaseseptmp_limitHi, phaseseptmp_limitLo, suctionprs_warnHi, suctionprs_warnLo, suctionprs_limitHi, suctionprs_limitLo, suctiontmp_M_warnHi, suctiontmp_M_warnLo, suctiontmp_M_limitHi, suctiontmp_M_limitLo, suctiontmp_P_warnHi, suctiontmp_P_warnLo, suctiontmp_P_limitHi, suctiontmp_P_limitLo, surgetanktmp_warnHi, surgetanktmp_warnLo, surgetanktmp_limitHi, surgetanktmp_limitLo, waterintmp_warnHi, waterintmp_warnLo, waterintmp_limitHi, waterintmp_limitLo, waterouttmp_warnHi, waterouttmp_warnLo, waterouttmp_limitHi, waterouttmp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Refrig_Cryo6_LimitsSettingsAppliedEvent));
        Refrig_Cryo6_LimitsSettingsAppliedEvent item_ = (Refrig_Cryo6_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)aftercooltmp_warnHi, (double)item_.getAftercooltmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_warnLo, (double)item_.getAftercooltmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitHi, (double)item_.getAftercooltmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)aftercooltmp_limitLo, (double)item_.getAftercooltmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnHi, (double)item_.getCompcurrent_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_warnLo, (double)item_.getCompcurrent_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitHi, (double)item_.getCompcurrent_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compcurrent_limitLo, (double)item_.getCompcurrent_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnHi, (double)item_.getComppower_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_warnLo, (double)item_.getComppower_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitHi, (double)item_.getComppower_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)comppower_limitLo, (double)item_.getComppower_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnHi, (double)item_.getCompvoltage_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_warnLo, (double)item_.getCompvoltage_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitHi, (double)item_.getCompvoltage_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)compvoltage_limitLo, (double)item_.getCompvoltage_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnHi, (double)item_.getDischrgprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_warnLo, (double)item_.getDischrgprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitHi, (double)item_.getDischrgprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgprs_limitLo, (double)item_.getDischrgprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnHi, (double)item_.getDischrgtmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_warnLo, (double)item_.getDischrgtmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitHi, (double)item_.getDischrgtmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_M_limitLo, (double)item_.getDischrgtmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnHi, (double)item_.getDischrgtmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_warnLo, (double)item_.getDischrgtmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitHi, (double)item_.getDischrgtmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)dischrgtmp_P_limitLo, (double)item_.getDischrgtmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnHi, (double)item_.getFanspeed_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_warnLo, (double)item_.getFanspeed_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitHi, (double)item_.getFanspeed_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)fanspeed_limitLo, (double)item_.getFanspeed_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnHi, (double)item_.getOillevel_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_warnLo, (double)item_.getOillevel_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitHi, (double)item_.getOillevel_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oillevel_limitLo, (double)item_.getOillevel_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnHi, (double)item_.getOilseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_warnLo, (double)item_.getOilseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitHi, (double)item_.getOilseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)oilseptmp_limitLo, (double)item_.getOilseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnHi, (double)item_.getPhaseseptmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_warnLo, (double)item_.getPhaseseptmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitHi, (double)item_.getPhaseseptmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)phaseseptmp_limitLo, (double)item_.getPhaseseptmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnHi, (double)item_.getSuctionprs_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_warnLo, (double)item_.getSuctionprs_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitHi, (double)item_.getSuctionprs_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctionprs_limitLo, (double)item_.getSuctionprs_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnHi, (double)item_.getSuctiontmp_M_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_warnLo, (double)item_.getSuctiontmp_M_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitHi, (double)item_.getSuctiontmp_M_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_M_limitLo, (double)item_.getSuctiontmp_M_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnHi, (double)item_.getSuctiontmp_P_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_warnLo, (double)item_.getSuctiontmp_P_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitHi, (double)item_.getSuctiontmp_P_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)suctiontmp_P_limitLo, (double)item_.getSuctiontmp_P_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnHi, (double)item_.getSurgetanktmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_warnLo, (double)item_.getSurgetanktmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitHi, (double)item_.getSurgetanktmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)surgetanktmp_limitLo, (double)item_.getSurgetanktmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnHi, (double)item_.getWaterintmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_warnLo, (double)item_.getWaterintmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitHi, (double)item_.getWaterintmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterintmp_limitLo, (double)item_.getWaterintmp_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnHi, (double)item_.getWaterouttmp_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_warnLo, (double)item_.getWaterouttmp_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitHi, (double)item_.getWaterouttmp_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)waterouttmp_limitLo, (double)item_.getWaterouttmp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 96;
        int version = 92;
        int schedulers_default_nTasks = 448;
        int schedulers_default_nThreads = 143;
        int schedulers_monitor_update_publish_scheduler_nTasks = 734;
        int schedulers_monitor_update_publish_scheduler_nThreads = 306;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasksSettingsAppliedEvent));
        Refrig_PeriodicTasksSettingsAppliedEvent item_ = (Refrig_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveRefrig_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 774;
        int version = 568;
        long agentmonitorservice_taskPeriodMillis = 379L;
        long cold1_FanCtrl_timer_taskPeriodMillis = 370L;
        long cold2_FanCtrl_timer_taskPeriodMillis = 337L;
        long compressor_state_taskPeriodMillis = 773L;
        long cryo3_FanCtrl_timer_taskPeriodMillis = 439L;
        long cryo5_FanCtrl_timer_taskPeriodMillis = 335L;
        long heartbeat_taskPeriodMillis = 565L;
        long monitor_check_taskPeriodMillis = 734L;
        long monitor_publish_taskPeriodMillis = 799L;
        long monitor_update_taskPeriodMillis = 257L;
        long runtimeinfo_taskPeriodMillis = 727L;
        long update_time_taskPeriodMillis = 866L;
        SALEvent item = this.testSendReceive((SALEvent)new Refrig_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, cold1_FanCtrl_timer_taskPeriodMillis, cold2_FanCtrl_timer_taskPeriodMillis, compressor_state_taskPeriodMillis, cryo3_FanCtrl_timer_taskPeriodMillis, cryo5_FanCtrl_timer_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, update_time_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Refrig_PeriodicTasks_timersSettingsAppliedEvent));
        Refrig_PeriodicTasks_timersSettingsAppliedEvent item_ = (Refrig_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)cold1_FanCtrl_timer_taskPeriodMillis, (long)item_.getCold1_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)cold2_FanCtrl_timer_taskPeriodMillis, (long)item_.getCold2_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)compressor_state_taskPeriodMillis, (long)item_.getCompressor_state_taskPeriodMillis());
        Assert.assertEquals((long)cryo3_FanCtrl_timer_taskPeriodMillis, (long)item_.getCryo3_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)cryo5_FanCtrl_timer_taskPeriodMillis, (long)item_.getCryo5_FanCtrl_timer_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)update_time_taskPeriodMillis, (long)item_.getUpdate_time_taskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_AgentMonitorServiceSettingsAppliedEvent() throws Exception {
        int priority = 336;
        int version = 970;
        long taskPeriodMillis = 834L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_AgentMonitorServiceSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_AgentMonitorServiceSettingsAppliedEvent));
        Vacuum_AgentMonitorServiceSettingsAppliedEvent item_ = (Vacuum_AgentMonitorServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_CIP1CSettingsAppliedEvent() throws Exception {
        int priority = 414;
        int version = 372;
        double current = 0.7145811319351196;
        double power = 0.01391238f;
        double voltage = 0.43761688470840454;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1CSettingsAppliedEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1CSettingsAppliedEvent));
        Vacuum_CIP1CSettingsAppliedEvent item_ = (Vacuum_CIP1CSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_ISettingsAppliedEvent() throws Exception {
        int priority = 587;
        int version = 127;
        double warnHi = 0.3067666292190552;
        double warnLo = 0.9353718161582947;
        double limitHi = 0.8341261148452759;
        double limitLo = 0.8316114544868469;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1_ISettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_ISettingsAppliedEvent));
        Vacuum_CIP1_ISettingsAppliedEvent item_ = (Vacuum_CIP1_ISettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP1_VSettingsAppliedEvent() throws Exception {
        int priority = 544;
        int version = 544;
        double warnHi = 0.832711398601532;
        double warnLo = 0.37604063749313354;
        double limitHi = 0.03953767f;
        double limitLo = 0.8931769132614136;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP1_VSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP1_VSettingsAppliedEvent));
        Vacuum_CIP1_VSettingsAppliedEvent item_ = (Vacuum_CIP1_VSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2CSettingsAppliedEvent() throws Exception {
        int priority = 878;
        int version = 92;
        double current = 0.6892715096473694;
        double power = 0.398157000541687;
        double voltage = 0.13042718172073364;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2CSettingsAppliedEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2CSettingsAppliedEvent));
        Vacuum_CIP2CSettingsAppliedEvent item_ = (Vacuum_CIP2CSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_ISettingsAppliedEvent() throws Exception {
        int priority = 640;
        int version = 638;
        double warnHi = 0.631290853023529;
        double warnLo = 0.4155048727989197;
        double limitHi = 0.19414716958999634;
        double limitLo = 0.7746595144271851;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2_ISettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_ISettingsAppliedEvent));
        Vacuum_CIP2_ISettingsAppliedEvent item_ = (Vacuum_CIP2_ISettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP2_VSettingsAppliedEvent() throws Exception {
        int priority = 375;
        int version = 165;
        double warnHi = 0.944949209690094;
        double warnLo = 0.8186742067337036;
        double limitHi = 0.0631251335144043;
        double limitLo = 0.731778f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP2_VSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP2_VSettingsAppliedEvent));
        Vacuum_CIP2_VSettingsAppliedEvent item_ = (Vacuum_CIP2_VSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3CSettingsAppliedEvent() throws Exception {
        int priority = 47;
        int version = 650;
        double current = 0.8153178691864014;
        double power = 0.8984127044677734;
        double voltage = 0.6960815787315369;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3CSettingsAppliedEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3CSettingsAppliedEvent));
        Vacuum_CIP3CSettingsAppliedEvent item_ = (Vacuum_CIP3CSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_ISettingsAppliedEvent() throws Exception {
        int priority = 973;
        int version = 486;
        double warnHi = 0.7142266035079956;
        double warnLo = 0.7880451679229736;
        double limitHi = 0.015918374061584473;
        double limitLo = 0.668856680393219;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3_ISettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_ISettingsAppliedEvent));
        Vacuum_CIP3_ISettingsAppliedEvent item_ = (Vacuum_CIP3_ISettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP3_VSettingsAppliedEvent() throws Exception {
        int priority = 952;
        int version = 60;
        double warnHi = 0.25043708086013794;
        double warnLo = 0.344391405582428;
        double limitHi = 0.32303881645202637;
        double limitLo = 0.3068814277648926;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP3_VSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP3_VSettingsAppliedEvent));
        Vacuum_CIP3_VSettingsAppliedEvent item_ = (Vacuum_CIP3_VSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4CSettingsAppliedEvent() throws Exception {
        int priority = 538;
        int version = 493;
        double current = 0.3430965542793274;
        double power = 0.9203203916549683;
        double voltage = 0.6411802172660828;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4CSettingsAppliedEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4CSettingsAppliedEvent));
        Vacuum_CIP4CSettingsAppliedEvent item_ = (Vacuum_CIP4CSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_ISettingsAppliedEvent() throws Exception {
        int priority = 497;
        int version = 114;
        double warnHi = 0.3076918125152588;
        double warnLo = 0.4680584f;
        double limitHi = 0.26654428243637085;
        double limitLo = 0.6449887752532959;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4_ISettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_ISettingsAppliedEvent));
        Vacuum_CIP4_ISettingsAppliedEvent item_ = (Vacuum_CIP4_ISettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP4_VSettingsAppliedEvent() throws Exception {
        int priority = 2;
        int version = 245;
        double warnHi = 0.6237963438034058;
        double warnLo = 0.3165757f;
        double limitHi = 0.7989621162414551;
        double limitLo = 0.37942272424697876;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP4_VSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP4_VSettingsAppliedEvent));
        Vacuum_CIP4_VSettingsAppliedEvent item_ = (Vacuum_CIP4_VSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5CSettingsAppliedEvent() throws Exception {
        int priority = 847;
        int version = 415;
        double current = 0.8417255282402039;
        double power = 0.12413114309310913;
        double voltage = 0.5145398378372192;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5CSettingsAppliedEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5CSettingsAppliedEvent));
        Vacuum_CIP5CSettingsAppliedEvent item_ = (Vacuum_CIP5CSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_ISettingsAppliedEvent() throws Exception {
        int priority = 939;
        int version = 651;
        double warnHi = 0.7154470682144165;
        double warnLo = 0.24681884050369263;
        double limitHi = 3.97861E-4f;
        double limitLo = 0.4978829026222229;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5_ISettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_ISettingsAppliedEvent));
        Vacuum_CIP5_ISettingsAppliedEvent item_ = (Vacuum_CIP5_ISettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP5_VSettingsAppliedEvent() throws Exception {
        int priority = 41;
        int version = 710;
        double warnHi = 0.24865102767944336;
        double warnLo = 0.44293713569641113;
        double limitHi = 0.71945720911026;
        double limitLo = 0.1985260248184204;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP5_VSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP5_VSettingsAppliedEvent));
        Vacuum_CIP5_VSettingsAppliedEvent item_ = (Vacuum_CIP5_VSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6CSettingsAppliedEvent() throws Exception {
        int priority = 220;
        int version = 0;
        double current = 0.07557564973831177;
        double power = 0.26327353715896606;
        double voltage = 0.5822992920875549;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6CSettingsAppliedEvent(priority, version, current, power, voltage));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6CSettingsAppliedEvent));
        Vacuum_CIP6CSettingsAppliedEvent item_ = (Vacuum_CIP6CSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)current, (double)item_.getCurrent(), (double)1.0E-6f);
        Assert.assertEquals((double)power, (double)item_.getPower(), (double)1.0E-6f);
        Assert.assertEquals((double)voltage, (double)item_.getVoltage(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_ISettingsAppliedEvent() throws Exception {
        int priority = 590;
        int version = 23;
        double warnHi = 0.525576114654541;
        double warnLo = 0.43829184770584106;
        double limitHi = 0.9741195440292358;
        double limitLo = 0.7157511115074158;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6_ISettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_ISettingsAppliedEvent));
        Vacuum_CIP6_ISettingsAppliedEvent item_ = (Vacuum_CIP6_ISettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CIP6_VSettingsAppliedEvent() throws Exception {
        int priority = 81;
        int version = 792;
        double warnHi = 0.5752629637718201;
        double warnLo = 0.9463352560997009;
        double limitHi = 0.5632772445678711;
        double limitLo = 0.7127206921577454;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CIP6_VSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CIP6_VSettingsAppliedEvent));
        Vacuum_CIP6_VSettingsAppliedEvent item_ = (Vacuum_CIP6_VSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacSettingsAppliedEvent() throws Exception {
        int priority = 356;
        int version = 902;
        double warnHi = 0.16633951663970947;
        double warnLo = 0.19426536560058594;
        double limitHi = 0.071639f;
        double limitLo = 0.1569261f;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacSettingsAppliedEvent));
        Vacuum_CryoVacSettingsAppliedEvent item_ = (Vacuum_CryoVacSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_CryoVacGaugeSettingsAppliedEvent() throws Exception {
        int priority = 791;
        int version = 489;
        int busAddr = 442;
        String devcId = "i";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_CryoVacGaugeSettingsAppliedEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_CryoVacGaugeSettingsAppliedEvent));
        Vacuum_CryoVacGaugeSettingsAppliedEvent item_ = (Vacuum_CryoVacGaugeSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_ForelineVacSettingsAppliedEvent() throws Exception {
        int priority = 552;
        int version = 444;
        double warnHi = 0.591046f;
        double warnLo = 0.4325159788131714;
        double limitHi = 0.4223732352256775;
        double limitLo = 0.38127797842025757;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_ForelineVacSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacSettingsAppliedEvent));
        Vacuum_ForelineVacSettingsAppliedEvent item_ = (Vacuum_ForelineVacSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_ForelineVacGaugeSettingsAppliedEvent() throws Exception {
        int priority = 215;
        int version = 765;
        int busAddr = 656;
        String devcId = "b";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_ForelineVacGaugeSettingsAppliedEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_ForelineVacGaugeSettingsAppliedEvent));
        Vacuum_ForelineVacGaugeSettingsAppliedEvent item_ = (Vacuum_ForelineVacGaugeSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_HeartbeatSettingsAppliedEvent() throws Exception {
        int priority = 174;
        int version = 237;
        long taskPeriodMillis = 206L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_HeartbeatSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_HeartbeatSettingsAppliedEvent));
        Vacuum_HeartbeatSettingsAppliedEvent item_ = (Vacuum_HeartbeatSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Hex1VacSettingsAppliedEvent() throws Exception {
        int priority = 340;
        int version = 716;
        double warnHi = 0.4356348514556885;
        double warnLo = 0.5805953741073608;
        double limitHi = 0.7147592306137085;
        double limitLo = 0.9934367537498474;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex1VacSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacSettingsAppliedEvent));
        Vacuum_Hex1VacSettingsAppliedEvent item_ = (Vacuum_Hex1VacSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex1VacGaugeSettingsAppliedEvent() throws Exception {
        int priority = 878;
        int version = 165;
        int busAddr = 26;
        String devcId = "n";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex1VacGaugeSettingsAppliedEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex1VacGaugeSettingsAppliedEvent));
        Vacuum_Hex1VacGaugeSettingsAppliedEvent item_ = (Vacuum_Hex1VacGaugeSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_Hex2VacSettingsAppliedEvent() throws Exception {
        int priority = 941;
        int version = 15;
        double warnHi = 0.9360492825508118;
        double warnLo = 0.2538573145866394;
        double limitHi = 0.29517167806625366;
        double limitLo = 0.29587697982788086;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex2VacSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacSettingsAppliedEvent));
        Vacuum_Hex2VacSettingsAppliedEvent item_ = (Vacuum_Hex2VacSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_Hex2VacGaugeSettingsAppliedEvent() throws Exception {
        int priority = 538;
        int version = 659;
        int busAddr = 939;
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Hex2VacGaugeSettingsAppliedEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Hex2VacGaugeSettingsAppliedEvent));
        Vacuum_Hex2VacGaugeSettingsAppliedEvent item_ = (Vacuum_Hex2VacGaugeSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_IonPumpsSettingsAppliedEvent() throws Exception {
        int priority = 614;
        int version = 242;
        String ipAddr = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_IonPumpsSettingsAppliedEvent(priority, version, ipAddr));
        Assert.assertTrue((boolean)(item instanceof Vacuum_IonPumpsSettingsAppliedEvent));
        Vacuum_IonPumpsSettingsAppliedEvent item_ = (Vacuum_IonPumpsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)ipAddr, (Object)item_.getIpAddr());
    }

    @Test
    public void sendReceiveVacuum_Monitor_checkSettingsAppliedEvent() throws Exception {
        int priority = 679;
        int version = 626;
        long taskPeriodMillis = 107L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_checkSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_checkSettingsAppliedEvent));
        Vacuum_Monitor_checkSettingsAppliedEvent item_ = (Vacuum_Monitor_checkSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Monitor_publishSettingsAppliedEvent() throws Exception {
        int priority = 419;
        int version = 2;
        long taskPeriodMillis = 821L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_publishSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_publishSettingsAppliedEvent));
        Vacuum_Monitor_publishSettingsAppliedEvent item_ = (Vacuum_Monitor_publishSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_Monitor_updateSettingsAppliedEvent() throws Exception {
        int priority = 432;
        int version = 281;
        long taskPeriodMillis = 278L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Monitor_updateSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Monitor_updateSettingsAppliedEvent));
        Vacuum_Monitor_updateSettingsAppliedEvent item_ = (Vacuum_Monitor_updateSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_RuntimeInfoSettingsAppliedEvent() throws Exception {
        int priority = 389;
        int version = 111;
        long taskPeriodMillis = 887L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_RuntimeInfoSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_RuntimeInfoSettingsAppliedEvent));
        Vacuum_RuntimeInfoSettingsAppliedEvent item_ = (Vacuum_RuntimeInfoSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveVacuum_SchedulersSettingsAppliedEvent() throws Exception {
        int priority = 136;
        int version = 17;
        int default_nTasks = 239;
        int default_nThreads = 138;
        int monitor_update_publish_scheduler_nTasks = 695;
        int monitor_update_publish_scheduler_nThreads = 920;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_SchedulersSettingsAppliedEvent(priority, version, default_nTasks, default_nThreads, monitor_update_publish_scheduler_nTasks, monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Vacuum_SchedulersSettingsAppliedEvent));
        Vacuum_SchedulersSettingsAppliedEvent item_ = (Vacuum_SchedulersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)default_nTasks, (long)item_.getDefault_nTasks());
        Assert.assertEquals((long)default_nThreads, (long)item_.getDefault_nThreads());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nTasks, (long)item_.getMonitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)monitor_update_publish_scheduler_nThreads, (long)item_.getMonitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveVacuum_TurboCurrentSettingsAppliedEvent() throws Exception {
        int priority = 344;
        int version = 207;
        double warnHi = 0.8488180637359619;
        double warnLo = 0.3473512f;
        double limitHi = 0.33951807022094727;
        double limitLo = 0.906520426273346;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboCurrentSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboCurrentSettingsAppliedEvent));
        Vacuum_TurboCurrentSettingsAppliedEvent item_ = (Vacuum_TurboCurrentSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPowerSettingsAppliedEvent() throws Exception {
        int priority = 958;
        int version = 980;
        double warnHi = 0.9929743409156799;
        double warnLo = 0.0360414981842041;
        double limitHi = 0.9235764741897583;
        double limitLo = 0.4671905040740967;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPowerSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPowerSettingsAppliedEvent));
        Vacuum_TurboPowerSettingsAppliedEvent item_ = (Vacuum_TurboPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboPumpSettingsAppliedEvent() throws Exception {
        int priority = 881;
        int version = 214;
        boolean activeStopMode = false;
        String devcId = "n";
        boolean interlockType = false;
        boolean lowSpeedMode = false;
        boolean model304 = false;
        boolean softStartMode = false;
        boolean ventValveByCmnd = false;
        boolean waterCooling = false;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPumpSettingsAppliedEvent(priority, version, activeStopMode, devcId, interlockType, lowSpeedMode, model304, softStartMode, ventValveByCmnd, waterCooling));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpSettingsAppliedEvent));
        Vacuum_TurboPumpSettingsAppliedEvent item_ = (Vacuum_TurboPumpSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)activeStopMode, (Object)item_.isActiveStopMode());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
        Assert.assertEquals((Object)interlockType, (Object)item_.isInterlockType());
        Assert.assertEquals((Object)lowSpeedMode, (Object)item_.isLowSpeedMode());
        Assert.assertEquals((Object)model304, (Object)item_.isModel304());
        Assert.assertEquals((Object)softStartMode, (Object)item_.isSoftStartMode());
        Assert.assertEquals((Object)ventValveByCmnd, (Object)item_.isVentValveByCmnd());
        Assert.assertEquals((Object)waterCooling, (Object)item_.isWaterCooling());
    }

    @Test
    public void sendReceiveVacuum_TurboPumpTempSettingsAppliedEvent() throws Exception {
        int priority = 294;
        int version = 922;
        double warnHi = 0.5691242218017578;
        double warnLo = 0.3387439250946045;
        double limitHi = 0.2125802f;
        double limitLo = 0.6120885610580444;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboPumpTempSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboPumpTempSettingsAppliedEvent));
        Vacuum_TurboPumpTempSettingsAppliedEvent item_ = (Vacuum_TurboPumpTempSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboSpeedSettingsAppliedEvent() throws Exception {
        int priority = 631;
        int version = 514;
        double warnHi = 0.7670446038246155;
        double warnLo = 0.6325418949127197;
        double limitHi = 0.14544326066970825;
        double limitLo = 0.15658771991729736;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboSpeedSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboSpeedSettingsAppliedEvent));
        Vacuum_TurboSpeedSettingsAppliedEvent item_ = (Vacuum_TurboSpeedSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacSettingsAppliedEvent() throws Exception {
        int priority = 724;
        int version = 141;
        double warnHi = 0.6301425099372864;
        double warnLo = 0.5715990662574768;
        double limitHi = 0.9308252334594727;
        double limitLo = 0.8303444981575012;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVacSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacSettingsAppliedEvent));
        Vacuum_TurboVacSettingsAppliedEvent item_ = (Vacuum_TurboVacSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_TurboVacGaugeSettingsAppliedEvent() throws Exception {
        int priority = 971;
        int version = 73;
        int busAddr = 171;
        String devcId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVacGaugeSettingsAppliedEvent(priority, version, busAddr, devcId));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVacGaugeSettingsAppliedEvent));
        Vacuum_TurboVacGaugeSettingsAppliedEvent item_ = (Vacuum_TurboVacGaugeSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)busAddr, (long)item_.getBusAddr());
        Assert.assertEquals((Object)devcId, (Object)item_.getDevcId());
    }

    @Test
    public void sendReceiveVacuum_TurboVoltageSettingsAppliedEvent() throws Exception {
        int priority = 255;
        int version = 518;
        double warnHi = 0.4971230626106262;
        double warnLo = 0.46246641874313354;
        double limitHi = 0.37017685174942017;
        double limitLo = 0.18240207433700562;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_TurboVoltageSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Vacuum_TurboVoltageSettingsAppliedEvent));
        Vacuum_TurboVoltageSettingsAppliedEvent item_ = (Vacuum_TurboVoltageSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveVacuum_VacPlutoSettingsAppliedEvent() throws Exception {
        int priority = 796;
        int version = 443;
        String node = "i";
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_VacPlutoSettingsAppliedEvent(priority, version, node));
        Assert.assertTrue((boolean)(item instanceof Vacuum_VacPlutoSettingsAppliedEvent));
        Vacuum_VacPlutoSettingsAppliedEvent item_ = (Vacuum_VacPlutoSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)node, (Object)item_.getNode());
    }

    @Test
    public void sendReceiveVacuum_Vacuum_stateSettingsAppliedEvent() throws Exception {
        int priority = 861;
        int version = 975;
        long taskPeriodMillis = 783L;
        SALEvent item = this.testSendReceive((SALEvent)new Vacuum_Vacuum_stateSettingsAppliedEvent(priority, version, taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Vacuum_Vacuum_stateSettingsAppliedEvent));
        Vacuum_Vacuum_stateSettingsAppliedEvent item_ = (Vacuum_Vacuum_stateSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)taskPeriodMillis, (long)item_.getTaskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 954;
        int version = 696;
        int schedulers_default_nTasks = 184;
        int schedulers_default_nThreads = 936;
        int schedulers_monitor_update_publish_scheduler_nTasks = 519;
        int schedulers_monitor_update_publish_scheduler_nThreads = 231;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasksSettingsAppliedEvent));
        Daq_monitor_PeriodicTasksSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveDaq_monitor_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 827;
        int version = 148;
        long agentmonitorservice_taskPeriodMillis = 352L;
        long heartbeat_taskPeriodMillis = 498L;
        long monitor_check_taskPeriodMillis = 118L;
        long monitor_publish_taskPeriodMillis = 41L;
        long monitor_update_taskPeriodMillis = 7L;
        long publishstats_taskPeriodMillis = 295L;
        long purgedaq_taskPeriodMillis = 109L;
        long runtimeinfo_taskPeriodMillis = 668L;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_check_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, publishstats_taskPeriodMillis, purgedaq_taskPeriodMillis, runtimeinfo_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent));
        Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent item_ = (Daq_monitor_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_check_taskPeriodMillis, (long)item_.getMonitor_check_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)publishstats_taskPeriodMillis, (long)item_.getPublishstats_taskPeriodMillis());
        Assert.assertEquals((long)purgedaq_taskPeriodMillis, (long)item_.getPurgedaq_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_StatisticsSettingsAppliedEvent() throws Exception {
        int priority = 381;
        int version = 334;
        int minDiffAlertWarning = 135;
        int minDiffLogWarning = 421;
        String sumDriverChecks = "g";
        String sumDriverStats = "e";
        String sumFirmwareChecks = "";
        String sumFirmwareStats = "u";
        String sumRdsChecks = "";
        String sumRdsStats = "";
        String sumRmsChecks = "z";
        String sumRmsStats = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_StatisticsSettingsAppliedEvent(priority, version, minDiffAlertWarning, minDiffLogWarning, sumDriverChecks, sumDriverStats, sumFirmwareChecks, sumFirmwareStats, sumRdsChecks, sumRdsStats, sumRmsChecks, sumRmsStats));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_StatisticsSettingsAppliedEvent));
        Daq_monitor_Stats_StatisticsSettingsAppliedEvent item_ = (Daq_monitor_Stats_StatisticsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)minDiffAlertWarning, (long)item_.getMinDiffAlertWarning());
        Assert.assertEquals((long)minDiffLogWarning, (long)item_.getMinDiffLogWarning());
        Assert.assertEquals((Object)sumDriverChecks, (Object)item_.getSumDriverChecks());
        Assert.assertEquals((Object)sumDriverStats, (Object)item_.getSumDriverStats());
        Assert.assertEquals((Object)sumFirmwareChecks, (Object)item_.getSumFirmwareChecks());
        Assert.assertEquals((Object)sumFirmwareStats, (Object)item_.getSumFirmwareStats());
        Assert.assertEquals((Object)sumRdsChecks, (Object)item_.getSumRdsChecks());
        Assert.assertEquals((Object)sumRdsStats, (Object)item_.getSumRdsStats());
        Assert.assertEquals((Object)sumRmsChecks, (Object)item_.getSumRmsChecks());
        Assert.assertEquals((Object)sumRmsStats, (Object)item_.getSumRmsStats());
    }

    @Test
    public void sendReceiveDaq_monitor_Stats_buildSettingsAppliedEvent() throws Exception {
        int priority = 299;
        int version = 35;
        boolean enablePeriodicPublication = true;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Stats_buildSettingsAppliedEvent(priority, version, enablePeriodicPublication));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Stats_buildSettingsAppliedEvent));
        Daq_monitor_Stats_buildSettingsAppliedEvent item_ = (Daq_monitor_Stats_buildSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)enablePeriodicPublication, (Object)item_.isEnablePeriodicPublication());
    }

    @Test
    public void sendReceiveDaq_monitor_StoreSettingsAppliedEvent() throws Exception {
        int priority = 873;
        int version = 538;
        String daqPartition = "";
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_StoreSettingsAppliedEvent(priority, version, daqPartition));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_StoreSettingsAppliedEvent));
        Daq_monitor_StoreSettingsAppliedEvent item_ = (Daq_monitor_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
    }

    @Test
    public void sendReceiveDaq_monitor_Store_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 957;
        int version = 989;
        double capacity_warnHi = 0.1515814f;
        double capacity_warnLo = 0.1340326f;
        double capacity_limitHi = 0.4477001428604126;
        double capacity_limitLo = 0.9362475872039795;
        double freefraction_warnHi = 0.03321004f;
        double freefraction_warnLo = 0.7028568983078003;
        double freefraction_limitHi = 0.9332424402236938;
        double freefraction_limitLo = 0.7087405920028687;
        double freespace_warnHi = 0.8886187672615051;
        double freespace_warnLo = 0.8060168623924255;
        double freespace_limitHi = 0.5156503915786743;
        double freespace_limitLo = 0.6420605778694153;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_LimitsSettingsAppliedEvent(priority, version, capacity_warnHi, capacity_warnLo, capacity_limitHi, capacity_limitLo, freefraction_warnHi, freefraction_warnLo, freefraction_limitHi, freefraction_limitLo, freespace_warnHi, freespace_warnLo, freespace_limitHi, freespace_limitLo));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_LimitsSettingsAppliedEvent));
        Daq_monitor_Store_LimitsSettingsAppliedEvent item_ = (Daq_monitor_Store_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)capacity_warnHi, (double)item_.getCapacity_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_warnLo, (double)item_.getCapacity_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitHi, (double)item_.getCapacity_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)capacity_limitLo, (double)item_.getCapacity_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnHi, (double)item_.getFreefraction_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_warnLo, (double)item_.getFreefraction_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitHi, (double)item_.getFreefraction_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freefraction_limitLo, (double)item_.getFreefraction_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnHi, (double)item_.getFreespace_warnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_warnLo, (double)item_.getFreespace_warnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitHi, (double)item_.getFreespace_limitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)freespace_limitLo, (double)item_.getFreespace_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveDaq_monitor_Store_StoreSettingsAppliedEvent() throws Exception {
        int priority = 773;
        int version = 189;
        String daqFolder = "v";
        boolean enableAutoPurge = false;
        double purgeTarget = 0.047164082527160645;
        double purgeThreshold = 0.07853960990905762;
        SALEvent item = this.testSendReceive((SALEvent)new Daq_monitor_Store_StoreSettingsAppliedEvent(priority, version, daqFolder, enableAutoPurge, purgeTarget, purgeThreshold));
        Assert.assertTrue((boolean)(item instanceof Daq_monitor_Store_StoreSettingsAppliedEvent));
        Daq_monitor_Store_StoreSettingsAppliedEvent item_ = (Daq_monitor_Store_StoreSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)enableAutoPurge, (Object)item_.isEnableAutoPurge());
        Assert.assertEquals((double)purgeTarget, (double)item_.getPurgeTarget(), (double)1.0E-6f);
        Assert.assertEquals((double)purgeThreshold, (double)item_.getPurgeThreshold(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 31;
        int version = 792;
        String location = "";
        String manSerNum = "x";
        String name = "i";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_HardwareIdSettingsAppliedEvent(priority, version, location, manSerNum, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_HardwareIdSettingsAppliedEvent));
        Focal_plane_Ccd_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Ccd_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)manSerNum, (Object)item_.getManSerNum());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 444;
        int version = 478;
        double[] gdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)1162635661);
        double[] gdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)381272171);
        double[] gdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)1096561460);
        double[] gdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-1224151692);
        String location = "p";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)201, (int)884064738);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)201, (int)1278412372);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)201, (int)-577209992);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)201, (int)262869804);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)201, (int)1793337504);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-703860519);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-1676767081);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)201, (int)-1210187630);
        double[] ogv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-871873572);
        double[] ogv_warnLo = TestHelper.generateDoubleArray((int)201, (int)-2082831703);
        double[] ogv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-198985073);
        double[] ogv_limitLo = TestHelper.generateDoubleArray((int)201, (int)104377596);
        double[] rdv_warnHi = TestHelper.generateDoubleArray((int)201, (int)-307729942);
        double[] rdv_warnLo = TestHelper.generateDoubleArray((int)201, (int)2035845400);
        double[] rdv_limitHi = TestHelper.generateDoubleArray((int)201, (int)-1278338309);
        double[] rdv_limitLo = TestHelper.generateDoubleArray((int)201, (int)2039555838);
        double[] temp_warnHi = TestHelper.generateDoubleArray((int)201, (int)1330822405);
        double[] temp_warnLo = TestHelper.generateDoubleArray((int)201, (int)-2002039584);
        double[] temp_limitHi = TestHelper.generateDoubleArray((int)201, (int)-1902015946);
        double[] temp_limitLo = TestHelper.generateDoubleArray((int)201, (int)1541208417);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_LimitsSettingsAppliedEvent(priority, version, gdv_warnHi, gdv_warnLo, gdv_limitHi, gdv_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, ogv_warnHi, ogv_warnLo, ogv_limitHi, ogv_limitLo, rdv_warnHi, rdv_warnLo, rdv_limitHi, rdv_limitLo, temp_warnHi, temp_warnLo, temp_limitHi, temp_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_LimitsSettingsAppliedEvent));
        Focal_plane_Ccd_LimitsSettingsAppliedEvent item_ = (Focal_plane_Ccd_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])gdv_warnHi, (double[])item_.getGdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_warnLo, (double[])item_.getGdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitHi, (double[])item_.getGdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])gdv_limitLo, (double[])item_.getGdv_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnHi, (double[])item_.getOgv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_warnLo, (double[])item_.getOgv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitHi, (double[])item_.getOgv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ogv_limitLo, (double[])item_.getOgv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnHi, (double[])item_.getRdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_warnLo, (double[])item_.getRdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitHi, (double[])item_.getRdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rdv_limitLo, (double[])item_.getRdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnHi, (double[])item_.getTemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_warnLo, (double[])item_.getTemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitHi, (double[])item_.getTemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp_limitLo, (double[])item_.getTemp_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Ccd_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 561;
        int version = 512;
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Ccd_RaftsSettingsAppliedEvent(priority, version, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Ccd_RaftsSettingsAppliedEvent));
        Focal_plane_Ccd_RaftsSettingsAppliedEvent item_ = (Focal_plane_Ccd_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_ImageDatabaseServiceSettingsAppliedEvent() throws Exception {
        int priority = 461;
        int version = 934;
        String dbURL = "";
        boolean enabled = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageDatabaseServiceSettingsAppliedEvent(priority, version, dbURL, enabled));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageDatabaseServiceSettingsAppliedEvent));
        Focal_plane_ImageDatabaseServiceSettingsAppliedEvent item_ = (Focal_plane_ImageDatabaseServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)enabled, (Object)item_.isEnabled());
    }

    @Test
    public void sendReceiveFocal_plane_ImageNameServiceSettingsAppliedEvent() throws Exception {
        int priority = 884;
        int version = 870;
        String controller = "";
        String dbURL = "";
        String offset = "";
        String source = "";
        String timeZoneId = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_ImageNameServiceSettingsAppliedEvent(priority, version, controller, dbURL, offset, source, timeZoneId));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_ImageNameServiceSettingsAppliedEvent));
        Focal_plane_ImageNameServiceSettingsAppliedEvent item_ = (Focal_plane_ImageNameServiceSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)controller, (Object)item_.getController());
        Assert.assertEquals((Object)dbURL, (Object)item_.getDbURL());
        Assert.assertEquals((Object)offset, (Object)item_.getOffset());
        Assert.assertEquals((Object)source, (Object)item_.getSource());
        Assert.assertEquals((Object)timeZoneId, (Object)item_.getTimeZoneId());
    }

    @Test
    public void sendReceiveFocal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent() throws Exception {
        int priority = 326;
        int version = 704;
        String instrument = "";
        String telescope = "";
        String testStand = "t";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent(priority, version, instrument, telescope, testStand));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent));
        Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent item_ = (Focal_plane_InstrumentConfig_InstrumentSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)instrument, (Object)item_.getInstrument());
        Assert.assertEquals((Object)telescope, (Object)item_.getTelescope());
        Assert.assertEquals((Object)testStand, (Object)item_.getTestStand());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasksSettingsAppliedEvent() throws Exception {
        int priority = 800;
        int version = 340;
        int schedulers_default_nTasks = 986;
        int schedulers_default_nThreads = 815;
        int schedulers_monitor_check_scheduler_nTasks = 66;
        int schedulers_monitor_check_scheduler_nThreads = 517;
        int schedulers_monitor_update_publish_scheduler_nTasks = 498;
        int schedulers_monitor_update_publish_scheduler_nThreads = 202;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasksSettingsAppliedEvent(priority, version, schedulers_default_nTasks, schedulers_default_nThreads, schedulers_monitor_check_scheduler_nTasks, schedulers_monitor_check_scheduler_nThreads, schedulers_monitor_update_publish_scheduler_nTasks, schedulers_monitor_update_publish_scheduler_nThreads));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasksSettingsAppliedEvent));
        Focal_plane_PeriodicTasksSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasksSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)schedulers_default_nTasks, (long)item_.getSchedulers_default_nTasks());
        Assert.assertEquals((long)schedulers_default_nThreads, (long)item_.getSchedulers_default_nThreads());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nTasks, (long)item_.getSchedulers_monitor_check_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_check_scheduler_nThreads, (long)item_.getSchedulers_monitor_check_scheduler_nThreads());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nTasks, (long)item_.getSchedulers_monitor_update_publish_scheduler_nTasks());
        Assert.assertEquals((long)schedulers_monitor_update_publish_scheduler_nThreads, (long)item_.getSchedulers_monitor_update_publish_scheduler_nThreads());
    }

    @Test
    public void sendReceiveFocal_plane_PeriodicTasks_timersSettingsAppliedEvent() throws Exception {
        int priority = 586;
        int version = 528;
        long agentmonitorservice_taskPeriodMillis = 454L;
        long heartbeat_taskPeriodMillis = 804L;
        long monitor_publish_taskPeriodMillis = 894L;
        long monitor_update_taskPeriodMillis = 897L;
        long runtimeinfo_taskPeriodMillis = 279L;
        long tempcontrol_R00_taskPeriodMillis = 675L;
        long tempcontrol_R01_taskPeriodMillis = 802L;
        long tempcontrol_R02_taskPeriodMillis = 891L;
        long tempcontrol_R03_taskPeriodMillis = 293L;
        long tempcontrol_R04_taskPeriodMillis = 141L;
        long tempcontrol_R10_taskPeriodMillis = 797L;
        long tempcontrol_R11_taskPeriodMillis = 825L;
        long tempcontrol_R12_taskPeriodMillis = 654L;
        long tempcontrol_R13_taskPeriodMillis = 343L;
        long tempcontrol_R14_taskPeriodMillis = 442L;
        long tempcontrol_R20_taskPeriodMillis = 398L;
        long tempcontrol_R21_taskPeriodMillis = 187L;
        long tempcontrol_R22_taskPeriodMillis = 2L;
        long tempcontrol_R23_taskPeriodMillis = 859L;
        long tempcontrol_R24_taskPeriodMillis = 906L;
        long tempcontrol_R30_taskPeriodMillis = 790L;
        long tempcontrol_R31_taskPeriodMillis = 994L;
        long tempcontrol_R32_taskPeriodMillis = 567L;
        long tempcontrol_R33_taskPeriodMillis = 218L;
        long tempcontrol_R34_taskPeriodMillis = 576L;
        long tempcontrol_R40_taskPeriodMillis = 932L;
        long tempcontrol_R41_taskPeriodMillis = 180L;
        long tempcontrol_R42_taskPeriodMillis = 459L;
        long tempcontrol_R43_taskPeriodMillis = 952L;
        long tempcontrol_R44_taskPeriodMillis = 148L;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_PeriodicTasks_timersSettingsAppliedEvent(priority, version, agentmonitorservice_taskPeriodMillis, heartbeat_taskPeriodMillis, monitor_publish_taskPeriodMillis, monitor_update_taskPeriodMillis, runtimeinfo_taskPeriodMillis, tempcontrol_R00_taskPeriodMillis, tempcontrol_R01_taskPeriodMillis, tempcontrol_R02_taskPeriodMillis, tempcontrol_R03_taskPeriodMillis, tempcontrol_R04_taskPeriodMillis, tempcontrol_R10_taskPeriodMillis, tempcontrol_R11_taskPeriodMillis, tempcontrol_R12_taskPeriodMillis, tempcontrol_R13_taskPeriodMillis, tempcontrol_R14_taskPeriodMillis, tempcontrol_R20_taskPeriodMillis, tempcontrol_R21_taskPeriodMillis, tempcontrol_R22_taskPeriodMillis, tempcontrol_R23_taskPeriodMillis, tempcontrol_R24_taskPeriodMillis, tempcontrol_R30_taskPeriodMillis, tempcontrol_R31_taskPeriodMillis, tempcontrol_R32_taskPeriodMillis, tempcontrol_R33_taskPeriodMillis, tempcontrol_R34_taskPeriodMillis, tempcontrol_R40_taskPeriodMillis, tempcontrol_R41_taskPeriodMillis, tempcontrol_R42_taskPeriodMillis, tempcontrol_R43_taskPeriodMillis, tempcontrol_R44_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_PeriodicTasks_timersSettingsAppliedEvent));
        Focal_plane_PeriodicTasks_timersSettingsAppliedEvent item_ = (Focal_plane_PeriodicTasks_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((long)agentmonitorservice_taskPeriodMillis, (long)item_.getAgentmonitorservice_taskPeriodMillis());
        Assert.assertEquals((long)heartbeat_taskPeriodMillis, (long)item_.getHeartbeat_taskPeriodMillis());
        Assert.assertEquals((long)monitor_publish_taskPeriodMillis, (long)item_.getMonitor_publish_taskPeriodMillis());
        Assert.assertEquals((long)monitor_update_taskPeriodMillis, (long)item_.getMonitor_update_taskPeriodMillis());
        Assert.assertEquals((long)runtimeinfo_taskPeriodMillis, (long)item_.getRuntimeinfo_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R00_taskPeriodMillis, (long)item_.getTempcontrol_R00_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R01_taskPeriodMillis, (long)item_.getTempcontrol_R01_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R02_taskPeriodMillis, (long)item_.getTempcontrol_R02_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R03_taskPeriodMillis, (long)item_.getTempcontrol_R03_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R04_taskPeriodMillis, (long)item_.getTempcontrol_R04_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R10_taskPeriodMillis, (long)item_.getTempcontrol_R10_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R11_taskPeriodMillis, (long)item_.getTempcontrol_R11_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R12_taskPeriodMillis, (long)item_.getTempcontrol_R12_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R13_taskPeriodMillis, (long)item_.getTempcontrol_R13_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R14_taskPeriodMillis, (long)item_.getTempcontrol_R14_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R20_taskPeriodMillis, (long)item_.getTempcontrol_R20_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R21_taskPeriodMillis, (long)item_.getTempcontrol_R21_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R22_taskPeriodMillis, (long)item_.getTempcontrol_R22_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R23_taskPeriodMillis, (long)item_.getTempcontrol_R23_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R24_taskPeriodMillis, (long)item_.getTempcontrol_R24_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R30_taskPeriodMillis, (long)item_.getTempcontrol_R30_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R31_taskPeriodMillis, (long)item_.getTempcontrol_R31_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R32_taskPeriodMillis, (long)item_.getTempcontrol_R32_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R33_taskPeriodMillis, (long)item_.getTempcontrol_R33_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R34_taskPeriodMillis, (long)item_.getTempcontrol_R34_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R40_taskPeriodMillis, (long)item_.getTempcontrol_R40_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R41_taskPeriodMillis, (long)item_.getTempcontrol_R41_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R42_taskPeriodMillis, (long)item_.getTempcontrol_R42_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R43_taskPeriodMillis, (long)item_.getTempcontrol_R43_taskPeriodMillis());
        Assert.assertEquals((long)tempcontrol_R44_taskPeriodMillis, (long)item_.getTempcontrol_R44_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 616;
        int version = 106;
        String location = "i";
        String name = "j";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_HardwareIdSettingsAppliedEvent));
        Focal_plane_Raft_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Raft_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlSettingsAppliedEvent() throws Exception {
        int priority = 725;
        int version = 869;
        String location = "i";
        double[] tempcontrol_basePower = TestHelper.generateDoubleArray((int)25, (int)49973773);
        double[] tempcontrol_coefD = TestHelper.generateDoubleArray((int)25, (int)1719516456);
        double[] tempcontrol_coefI = TestHelper.generateDoubleArray((int)25, (int)-74814473);
        double[] tempcontrol_coefP = TestHelper.generateDoubleArray((int)25, (int)918359194);
        double[] tempcontrol_maxInput = TestHelper.generateDoubleArray((int)25, (int)-1022583277);
        double[] tempcontrol_maxOutput = TestHelper.generateDoubleArray((int)25, (int)402701376);
        double[] tempcontrol_minInput = TestHelper.generateDoubleArray((int)25, (int)1254314993);
        double[] tempcontrol_minOutput = TestHelper.generateDoubleArray((int)25, (int)482321676);
        String tempcontrol_rebs = "";
        double[] tempcontrol_setTemp = TestHelper.generateDoubleArray((int)25, (int)-980626627);
        double[] tempcontrol_smoothTime = TestHelper.generateDoubleArray((int)25, (int)791695501);
        String tempcontrol_tempChans = "";
        double[] tempcontrol_timeConst = TestHelper.generateDoubleArray((int)25, (int)-995019962);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlSettingsAppliedEvent(priority, version, location, tempcontrol_basePower, tempcontrol_coefD, tempcontrol_coefI, tempcontrol_coefP, tempcontrol_maxInput, tempcontrol_maxOutput, tempcontrol_minInput, tempcontrol_minOutput, tempcontrol_rebs, tempcontrol_setTemp, tempcontrol_smoothTime, tempcontrol_tempChans, tempcontrol_timeConst));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])tempcontrol_basePower, (double[])item_.getTempcontrol_basePower(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefD, (double[])item_.getTempcontrol_coefD(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefI, (double[])item_.getTempcontrol_coefI(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_coefP, (double[])item_.getTempcontrol_coefP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxInput, (double[])item_.getTempcontrol_maxInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_maxOutput, (double[])item_.getTempcontrol_maxOutput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minInput, (double[])item_.getTempcontrol_minInput(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_minOutput, (double[])item_.getTempcontrol_minOutput(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_rebs, (Object)item_.getTempcontrol_rebs());
        Assert.assertArrayEquals((double[])tempcontrol_setTemp, (double[])item_.getTempcontrol_setTemp(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])tempcontrol_smoothTime, (double[])item_.getTempcontrol_smoothTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)tempcontrol_tempChans, (Object)item_.getTempcontrol_tempChans());
        Assert.assertArrayEquals((double[])tempcontrol_timeConst, (double[])item_.getTempcontrol_timeConst(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent() throws Exception {
        int priority = 282;
        int version = 23;
        String location = "";
        boolean[] tempcontrol_active = new boolean[]{true, true, true, false, false, false, true, false, false, false, true, true, true, false, false, false, false, true, true, true, true, false, false, true, false};
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent(priority, version, location, tempcontrol_active));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent));
        Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent item_ = (Focal_plane_Raft_RaftTempControlStatusSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((boolean[])tempcontrol_active, (boolean[])item_.getTempcontrol_active());
    }

    @Test
    public void sendReceiveFocal_plane_RebTotalPower_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 386;
        int version = 598;
        double warnHi = 0.348754346370697;
        double warnLo = 0.17609864473342896;
        double limitHi = 0.4826553f;
        double limitLo = 0.530617356300354;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent(priority, version, warnHi, warnLo, limitHi, limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent));
        Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent item_ = (Focal_plane_RebTotalPower_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((double)warnHi, (double)item_.getWarnHi(), (double)1.0E-6f);
        Assert.assertEquals((double)warnLo, (double)item_.getWarnLo(), (double)1.0E-6f);
        Assert.assertEquals((double)limitHi, (double)item_.getLimitHi(), (double)1.0E-6f);
        Assert.assertEquals((double)limitLo, (double)item_.getLimitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_HardwareIdSettingsAppliedEvent() throws Exception {
        int priority = 488;
        int version = 777;
        String location = "r";
        String name = "o";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_HardwareIdSettingsAppliedEvent(priority, version, location, name));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_HardwareIdSettingsAppliedEvent));
        Focal_plane_Reb_HardwareIdSettingsAppliedEvent item_ = (Focal_plane_Reb_HardwareIdSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertEquals((Object)name, (Object)item_.getName());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 484;
        int version = 972;
        double[] anai_warnHi = TestHelper.generateDoubleArray((int)71, (int)2031843969);
        double[] anai_warnLo = TestHelper.generateDoubleArray((int)71, (int)-409552791);
        double[] anai_limitHi = TestHelper.generateDoubleArray((int)71, (int)1826744715);
        double[] anai_limitLo = TestHelper.generateDoubleArray((int)71, (int)-657114909);
        double[] anav_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1807767098);
        double[] anav_warnLo = TestHelper.generateDoubleArray((int)71, (int)1345297660);
        double[] anav_limitHi = TestHelper.generateDoubleArray((int)71, (int)248277560);
        double[] anav_limitLo = TestHelper.generateDoubleArray((int)71, (int)-974292004);
        double[] aspicl_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-593605335);
        double[] aspicl_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1503864969);
        double[] aspicl_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1849363735);
        double[] aspicl_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1899043159);
        double[] aspicl_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)743987566);
        double[] aspicl_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-303545634);
        double[] aspicl_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1185218584);
        double[] aspicl_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1486360682);
        double[] aspicl_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)734668936);
        double[] aspicl_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)1402002566);
        double[] aspicl_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)765890563);
        double[] aspicl_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1755228373);
        double[] aspicu_Temp0_warnHi = TestHelper.generateDoubleArray((int)71, (int)928960918);
        double[] aspicu_Temp0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1778618628);
        double[] aspicu_Temp0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1947811934);
        double[] aspicu_Temp0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-613800017);
        double[] aspicu_Temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1708356592);
        double[] aspicu_Temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)123635493);
        double[] aspicu_Temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)1342603548);
        double[] aspicu_Temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)1439017201);
        double[] aspicu_Temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1273523651);
        double[] aspicu_Temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)2092373926);
        double[] aspicu_Temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)1363412549);
        double[] aspicu_Temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)1994280005);
        double[] clkhi_warnHi = TestHelper.generateDoubleArray((int)71, (int)1276917480);
        double[] clkhi_warnLo = TestHelper.generateDoubleArray((int)71, (int)13463173);
        double[] clkhi_limitHi = TestHelper.generateDoubleArray((int)71, (int)451718987);
        double[] clkhi_limitLo = TestHelper.generateDoubleArray((int)71, (int)-515058483);
        double[] clkhv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-331865518);
        double[] clkhv_warnLo = TestHelper.generateDoubleArray((int)71, (int)1278370064);
        double[] clkhv_limitHi = TestHelper.generateDoubleArray((int)71, (int)652776130);
        double[] clkhv_limitLo = TestHelper.generateDoubleArray((int)71, (int)2113093625);
        double[] clkli_warnHi = TestHelper.generateDoubleArray((int)71, (int)1869998698);
        double[] clkli_warnLo = TestHelper.generateDoubleArray((int)71, (int)316592637);
        double[] clkli_limitHi = TestHelper.generateDoubleArray((int)71, (int)938341116);
        double[] clkli_limitLo = TestHelper.generateDoubleArray((int)71, (int)549401168);
        double[] clklv_warnHi = TestHelper.generateDoubleArray((int)71, (int)320698939);
        double[] clklv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-911084078);
        double[] clklv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1511639906);
        double[] clklv_limitLo = TestHelper.generateDoubleArray((int)71, (int)1839197295);
        double[] digi_warnHi = TestHelper.generateDoubleArray((int)71, (int)1161755813);
        double[] digi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-597362297);
        double[] digi_limitHi = TestHelper.generateDoubleArray((int)71, (int)361966191);
        double[] digi_limitLo = TestHelper.generateDoubleArray((int)71, (int)1266158674);
        double[] digv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-336249265);
        double[] digv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1916801175);
        double[] digv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1776498061);
        double[] digv_limitLo = TestHelper.generateDoubleArray((int)71, (int)278109906);
        double[] hvbiasswitch_warnHi = TestHelper.generateDoubleArray((int)71, (int)85441244);
        double[] hvbiasswitch_warnLo = TestHelper.generateDoubleArray((int)71, (int)842409536);
        double[] hvbiasswitch_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1726177224);
        double[] hvbiasswitch_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1515240082);
        double[] htrpi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-991704740);
        double[] htrpi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-825340236);
        double[] htrpi_limitHi = TestHelper.generateDoubleArray((int)71, (int)1564315758);
        double[] htrpi_limitLo = TestHelper.generateDoubleArray((int)71, (int)438662221);
        double[] htrpv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-156787708);
        double[] htrpv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1247997204);
        double[] htrpv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1243889219);
        double[] htrpv_limitLo = TestHelper.generateDoubleArray((int)71, (int)-912061309);
        double[] htrv_warnHi = TestHelper.generateDoubleArray((int)71, (int)2079393570);
        double[] htrv_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1268841353);
        double[] htrv_limitHi = TestHelper.generateDoubleArray((int)71, (int)880393939);
        double[] htrv_limitLo = TestHelper.generateDoubleArray((int)71, (int)34920083);
        double[] htrw_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1200798902);
        double[] htrw_warnLo = TestHelper.generateDoubleArray((int)71, (int)724108399);
        double[] htrw_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2002967109);
        double[] htrw_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1819041484);
        String location = "";
        double[] odi_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1493923365);
        double[] odi_warnLo = TestHelper.generateDoubleArray((int)71, (int)-252282763);
        double[] odi_limitHi = TestHelper.generateDoubleArray((int)71, (int)1680672856);
        double[] odi_limitLo = TestHelper.generateDoubleArray((int)71, (int)1855738507);
        double[] odv_warnHi = TestHelper.generateDoubleArray((int)71, (int)-935368107);
        double[] odv_warnLo = TestHelper.generateDoubleArray((int)71, (int)719119042);
        double[] odv_limitHi = TestHelper.generateDoubleArray((int)71, (int)-758962071);
        double[] odv_limitLo = TestHelper.generateDoubleArray((int)71, (int)92663199);
        double[] pclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1756559124);
        double[] pclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-731903682);
        double[] pclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1222786603);
        double[] pclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)2146634971);
        double[] pclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)1477513035);
        double[] pclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1858024884);
        double[] pclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)904630476);
        double[] pclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)340414747);
        double[] pclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)1168774426);
        double[] pclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)1815508141);
        double[] pclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2045059768);
        double[] pclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1716401921);
        double[] pclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)-892020317);
        double[] pclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)436697162);
        double[] pclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2049145011);
        double[] pclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)-32488997);
        double[] power_warnHi = TestHelper.generateDoubleArray((int)71, (int)673641400);
        double[] power_warnLo = TestHelper.generateDoubleArray((int)71, (int)-5417901);
        double[] power_limitHi = TestHelper.generateDoubleArray((int)71, (int)2031424369);
        double[] power_limitLo = TestHelper.generateDoubleArray((int)71, (int)-283233294);
        double[] rg0_warnHi = TestHelper.generateDoubleArray((int)71, (int)2087328724);
        double[] rg0_warnLo = TestHelper.generateDoubleArray((int)71, (int)59205519);
        double[] rg0_limitHi = TestHelper.generateDoubleArray((int)71, (int)624130975);
        double[] rg0_limitLo = TestHelper.generateDoubleArray((int)71, (int)555531748);
        double[] rg1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1386253184);
        double[] rg1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1832453717);
        double[] rg1_limitHi = TestHelper.generateDoubleArray((int)71, (int)1604175895);
        double[] rg1_limitLo = TestHelper.generateDoubleArray((int)71, (int)205284196);
        double[] rgl_warnHi = TestHelper.generateDoubleArray((int)71, (int)1103394040);
        double[] rgl_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1413432733);
        double[] rgl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-127945544);
        double[] rgl_limitLo = TestHelper.generateDoubleArray((int)71, (int)337937197);
        double[] rgu_warnHi = TestHelper.generateDoubleArray((int)71, (int)1055480334);
        double[] rgu_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1574753299);
        double[] rgu_limitHi = TestHelper.generateDoubleArray((int)71, (int)583526017);
        double[] rgu_limitLo = TestHelper.generateDoubleArray((int)71, (int)514308150);
        double[] rtdtemp_warnHi = TestHelper.generateDoubleArray((int)71, (int)381894989);
        double[] rtdtemp_warnLo = TestHelper.generateDoubleArray((int)71, (int)-2035087367);
        double[] rtdtemp_limitHi = TestHelper.generateDoubleArray((int)71, (int)1298429269);
        double[] rtdtemp_limitLo = TestHelper.generateDoubleArray((int)71, (int)1723898404);
        double[] ref05v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1788718496);
        double[] ref05v_warnLo = TestHelper.generateDoubleArray((int)71, (int)130054121);
        double[] ref05v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-90714626);
        double[] ref05v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1253413119);
        double[] ref125v_warnHi = TestHelper.generateDoubleArray((int)71, (int)408328885);
        double[] ref125v_warnLo = TestHelper.generateDoubleArray((int)71, (int)839908953);
        double[] ref125v_limitHi = TestHelper.generateDoubleArray((int)71, (int)386609267);
        double[] ref125v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1459204136);
        double[] ref15v_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1508606115);
        double[] ref15v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1528941866);
        double[] ref15v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-2083238307);
        double[] ref15v_limitLo = TestHelper.generateDoubleArray((int)71, (int)2118896778);
        double[] ref25v_warnHi = TestHelper.generateDoubleArray((int)71, (int)1360259381);
        double[] ref25v_warnLo = TestHelper.generateDoubleArray((int)71, (int)1078978783);
        double[] ref25v_limitHi = TestHelper.generateDoubleArray((int)71, (int)-747123241);
        double[] ref25v_limitLo = TestHelper.generateDoubleArray((int)71, (int)1509179920);
        double[] refn12_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1334603958);
        double[] refn12_warnLo = TestHelper.generateDoubleArray((int)71, (int)1700441383);
        double[] refn12_limitHi = TestHelper.generateDoubleArray((int)71, (int)1531622517);
        double[] refn12_limitLo = TestHelper.generateDoubleArray((int)71, (int)907353174);
        double[] refp12_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1063517319);
        double[] refp12_warnLo = TestHelper.generateDoubleArray((int)71, (int)375424698);
        double[] refp12_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1034879352);
        double[] refp12_limitLo = TestHelper.generateDoubleArray((int)71, (int)1292342946);
        double[] sclk0_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1208720042);
        double[] sclk0_warnLo = TestHelper.generateDoubleArray((int)71, (int)-206113176);
        double[] sclk0_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1277696353);
        double[] sclk0_limitLo = TestHelper.generateDoubleArray((int)71, (int)-721606891);
        double[] sclk1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-260776113);
        double[] sclk1_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1763167890);
        double[] sclk1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1561419441);
        double[] sclk1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1010202339);
        double[] sclkl_warnHi = TestHelper.generateDoubleArray((int)71, (int)83972624);
        double[] sclkl_warnLo = TestHelper.generateDoubleArray((int)71, (int)1081733899);
        double[] sclkl_limitHi = TestHelper.generateDoubleArray((int)71, (int)-188182217);
        double[] sclkl_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2128708819);
        double[] sclku_warnHi = TestHelper.generateDoubleArray((int)71, (int)1530450471);
        double[] sclku_warnLo = TestHelper.generateDoubleArray((int)71, (int)-78163118);
        double[] sclku_limitHi = TestHelper.generateDoubleArray((int)71, (int)255866686);
        double[] sclku_limitLo = TestHelper.generateDoubleArray((int)71, (int)785982384);
        double[] temp10_warnHi = TestHelper.generateDoubleArray((int)71, (int)504159211);
        double[] temp10_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1241467071);
        double[] temp10_limitHi = TestHelper.generateDoubleArray((int)71, (int)-832412898);
        double[] temp10_limitLo = TestHelper.generateDoubleArray((int)71, (int)-192130758);
        double[] temp1_warnHi = TestHelper.generateDoubleArray((int)71, (int)-448962150);
        double[] temp1_warnLo = TestHelper.generateDoubleArray((int)71, (int)1212296723);
        double[] temp1_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1403164634);
        double[] temp1_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2039346688);
        double[] temp2_warnHi = TestHelper.generateDoubleArray((int)71, (int)134551489);
        double[] temp2_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1755197486);
        double[] temp2_limitHi = TestHelper.generateDoubleArray((int)71, (int)1520982587);
        double[] temp2_limitLo = TestHelper.generateDoubleArray((int)71, (int)1403133578);
        double[] temp3_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1475107872);
        double[] temp3_warnLo = TestHelper.generateDoubleArray((int)71, (int)1069347119);
        double[] temp3_limitHi = TestHelper.generateDoubleArray((int)71, (int)-705521889);
        double[] temp3_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1156402266);
        double[] temp4_warnHi = TestHelper.generateDoubleArray((int)71, (int)-2086039219);
        double[] temp4_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1562099563);
        double[] temp4_limitHi = TestHelper.generateDoubleArray((int)71, (int)-794025995);
        double[] temp4_limitLo = TestHelper.generateDoubleArray((int)71, (int)-440207457);
        double[] temp5_warnHi = TestHelper.generateDoubleArray((int)71, (int)1552167000);
        double[] temp5_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1850466181);
        double[] temp5_limitHi = TestHelper.generateDoubleArray((int)71, (int)503023364);
        double[] temp5_limitLo = TestHelper.generateDoubleArray((int)71, (int)1841264303);
        double[] temp6_warnHi = TestHelper.generateDoubleArray((int)71, (int)1803928495);
        double[] temp6_warnLo = TestHelper.generateDoubleArray((int)71, (int)870830841);
        double[] temp6_limitHi = TestHelper.generateDoubleArray((int)71, (int)150894011);
        double[] temp6_limitLo = TestHelper.generateDoubleArray((int)71, (int)-2135768399);
        double[] temp7_warnHi = TestHelper.generateDoubleArray((int)71, (int)-1058496508);
        double[] temp7_warnLo = TestHelper.generateDoubleArray((int)71, (int)1333480094);
        double[] temp7_limitHi = TestHelper.generateDoubleArray((int)71, (int)-159510796);
        double[] temp7_limitLo = TestHelper.generateDoubleArray((int)71, (int)1487692314);
        double[] temp8_warnHi = TestHelper.generateDoubleArray((int)71, (int)1284645356);
        double[] temp8_warnLo = TestHelper.generateDoubleArray((int)71, (int)-1021791104);
        double[] temp8_limitHi = TestHelper.generateDoubleArray((int)71, (int)-1844399748);
        double[] temp8_limitLo = TestHelper.generateDoubleArray((int)71, (int)-1846330839);
        double[] temp9_warnHi = TestHelper.generateDoubleArray((int)71, (int)1946459658);
        double[] temp9_warnLo = TestHelper.generateDoubleArray((int)71, (int)1426853779);
        double[] temp9_limitHi = TestHelper.generateDoubleArray((int)71, (int)523689683);
        double[] temp9_limitLo = TestHelper.generateDoubleArray((int)71, (int)1616373853);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_LimitsSettingsAppliedEvent(priority, version, anai_warnHi, anai_warnLo, anai_limitHi, anai_limitLo, anav_warnHi, anav_warnLo, anav_limitHi, anav_limitLo, aspicl_Temp0_warnHi, aspicl_Temp0_warnLo, aspicl_Temp0_limitHi, aspicl_Temp0_limitLo, aspicl_Temp1_warnHi, aspicl_Temp1_warnLo, aspicl_Temp1_limitHi, aspicl_Temp1_limitLo, aspicl_Temp2_warnHi, aspicl_Temp2_warnLo, aspicl_Temp2_limitHi, aspicl_Temp2_limitLo, aspicu_Temp0_warnHi, aspicu_Temp0_warnLo, aspicu_Temp0_limitHi, aspicu_Temp0_limitLo, aspicu_Temp1_warnHi, aspicu_Temp1_warnLo, aspicu_Temp1_limitHi, aspicu_Temp1_limitLo, aspicu_Temp2_warnHi, aspicu_Temp2_warnLo, aspicu_Temp2_limitHi, aspicu_Temp2_limitLo, clkhi_warnHi, clkhi_warnLo, clkhi_limitHi, clkhi_limitLo, clkhv_warnHi, clkhv_warnLo, clkhv_limitHi, clkhv_limitLo, clkli_warnHi, clkli_warnLo, clkli_limitHi, clkli_limitLo, clklv_warnHi, clklv_warnLo, clklv_limitHi, clklv_limitLo, digi_warnHi, digi_warnLo, digi_limitHi, digi_limitLo, digv_warnHi, digv_warnLo, digv_limitHi, digv_limitLo, hvbiasswitch_warnHi, hvbiasswitch_warnLo, hvbiasswitch_limitHi, hvbiasswitch_limitLo, htrpi_warnHi, htrpi_warnLo, htrpi_limitHi, htrpi_limitLo, htrpv_warnHi, htrpv_warnLo, htrpv_limitHi, htrpv_limitLo, htrv_warnHi, htrv_warnLo, htrv_limitHi, htrv_limitLo, htrw_warnHi, htrw_warnLo, htrw_limitHi, htrw_limitLo, location, odi_warnHi, odi_warnLo, odi_limitHi, odi_limitLo, odv_warnHi, odv_warnLo, odv_limitHi, odv_limitLo, pclk0_warnHi, pclk0_warnLo, pclk0_limitHi, pclk0_limitLo, pclk1_warnHi, pclk1_warnLo, pclk1_limitHi, pclk1_limitLo, pclkl_warnHi, pclkl_warnLo, pclkl_limitHi, pclkl_limitLo, pclku_warnHi, pclku_warnLo, pclku_limitHi, pclku_limitLo, power_warnHi, power_warnLo, power_limitHi, power_limitLo, rg0_warnHi, rg0_warnLo, rg0_limitHi, rg0_limitLo, rg1_warnHi, rg1_warnLo, rg1_limitHi, rg1_limitLo, rgl_warnHi, rgl_warnLo, rgl_limitHi, rgl_limitLo, rgu_warnHi, rgu_warnLo, rgu_limitHi, rgu_limitLo, rtdtemp_warnHi, rtdtemp_warnLo, rtdtemp_limitHi, rtdtemp_limitLo, ref05v_warnHi, ref05v_warnLo, ref05v_limitHi, ref05v_limitLo, ref125v_warnHi, ref125v_warnLo, ref125v_limitHi, ref125v_limitLo, ref15v_warnHi, ref15v_warnLo, ref15v_limitHi, ref15v_limitLo, ref25v_warnHi, ref25v_warnLo, ref25v_limitHi, ref25v_limitLo, refn12_warnHi, refn12_warnLo, refn12_limitHi, refn12_limitLo, refp12_warnHi, refp12_warnLo, refp12_limitHi, refp12_limitLo, sclk0_warnHi, sclk0_warnLo, sclk0_limitHi, sclk0_limitLo, sclk1_warnHi, sclk1_warnLo, sclk1_limitHi, sclk1_limitLo, sclkl_warnHi, sclkl_warnLo, sclkl_limitHi, sclkl_limitLo, sclku_warnHi, sclku_warnLo, sclku_limitHi, sclku_limitLo, temp10_warnHi, temp10_warnLo, temp10_limitHi, temp10_limitLo, temp1_warnHi, temp1_warnLo, temp1_limitHi, temp1_limitLo, temp2_warnHi, temp2_warnLo, temp2_limitHi, temp2_limitLo, temp3_warnHi, temp3_warnLo, temp3_limitHi, temp3_limitLo, temp4_warnHi, temp4_warnLo, temp4_limitHi, temp4_limitLo, temp5_warnHi, temp5_warnLo, temp5_limitHi, temp5_limitLo, temp6_warnHi, temp6_warnLo, temp6_limitHi, temp6_limitLo, temp7_warnHi, temp7_warnLo, temp7_limitHi, temp7_limitLo, temp8_warnHi, temp8_warnLo, temp8_limitHi, temp8_limitLo, temp9_warnHi, temp9_warnLo, temp9_limitHi, temp9_limitLo));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_LimitsSettingsAppliedEvent));
        Focal_plane_Reb_LimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])anai_warnHi, (double[])item_.getAnai_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_warnLo, (double[])item_.getAnai_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitHi, (double[])item_.getAnai_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anai_limitLo, (double[])item_.getAnai_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnHi, (double[])item_.getAnav_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_warnLo, (double[])item_.getAnav_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitHi, (double[])item_.getAnav_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])anav_limitLo, (double[])item_.getAnav_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnHi, (double[])item_.getAspicl_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_warnLo, (double[])item_.getAspicl_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitHi, (double[])item_.getAspicl_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp0_limitLo, (double[])item_.getAspicl_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnHi, (double[])item_.getAspicl_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_warnLo, (double[])item_.getAspicl_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitHi, (double[])item_.getAspicl_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp1_limitLo, (double[])item_.getAspicl_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnHi, (double[])item_.getAspicl_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_warnLo, (double[])item_.getAspicl_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitHi, (double[])item_.getAspicl_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicl_Temp2_limitLo, (double[])item_.getAspicl_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnHi, (double[])item_.getAspicu_Temp0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_warnLo, (double[])item_.getAspicu_Temp0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitHi, (double[])item_.getAspicu_Temp0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp0_limitLo, (double[])item_.getAspicu_Temp0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnHi, (double[])item_.getAspicu_Temp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_warnLo, (double[])item_.getAspicu_Temp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitHi, (double[])item_.getAspicu_Temp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp1_limitLo, (double[])item_.getAspicu_Temp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnHi, (double[])item_.getAspicu_Temp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_warnLo, (double[])item_.getAspicu_Temp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitHi, (double[])item_.getAspicu_Temp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])aspicu_Temp2_limitLo, (double[])item_.getAspicu_Temp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnHi, (double[])item_.getClkhi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_warnLo, (double[])item_.getClkhi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitHi, (double[])item_.getClkhi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhi_limitLo, (double[])item_.getClkhi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnHi, (double[])item_.getClkhv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_warnLo, (double[])item_.getClkhv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitHi, (double[])item_.getClkhv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhv_limitLo, (double[])item_.getClkhv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnHi, (double[])item_.getClkli_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_warnLo, (double[])item_.getClkli_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitHi, (double[])item_.getClkli_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkli_limitLo, (double[])item_.getClkli_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnHi, (double[])item_.getClklv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_warnLo, (double[])item_.getClklv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitHi, (double[])item_.getClklv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clklv_limitLo, (double[])item_.getClklv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnHi, (double[])item_.getDigi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_warnLo, (double[])item_.getDigi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitHi, (double[])item_.getDigi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digi_limitLo, (double[])item_.getDigi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnHi, (double[])item_.getDigv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_warnLo, (double[])item_.getDigv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitHi, (double[])item_.getDigv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])digv_limitLo, (double[])item_.getDigv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnHi, (double[])item_.getHvbiasswitch_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_warnLo, (double[])item_.getHvbiasswitch_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitHi, (double[])item_.getHvbiasswitch_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])hvbiasswitch_limitLo, (double[])item_.getHvbiasswitch_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnHi, (double[])item_.getHtrpi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_warnLo, (double[])item_.getHtrpi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitHi, (double[])item_.getHtrpi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpi_limitLo, (double[])item_.getHtrpi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnHi, (double[])item_.getHtrpv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_warnLo, (double[])item_.getHtrpv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitHi, (double[])item_.getHtrpv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrpv_limitLo, (double[])item_.getHtrpv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnHi, (double[])item_.getHtrv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_warnLo, (double[])item_.getHtrv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitHi, (double[])item_.getHtrv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrv_limitLo, (double[])item_.getHtrv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnHi, (double[])item_.getHtrw_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_warnLo, (double[])item_.getHtrw_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitHi, (double[])item_.getHtrw_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])htrw_limitLo, (double[])item_.getHtrw_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])odi_warnHi, (double[])item_.getOdi_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_warnLo, (double[])item_.getOdi_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitHi, (double[])item_.getOdi_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odi_limitLo, (double[])item_.getOdi_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnHi, (double[])item_.getOdv_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_warnLo, (double[])item_.getOdv_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitHi, (double[])item_.getOdv_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odv_limitLo, (double[])item_.getOdv_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnHi, (double[])item_.getPclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_warnLo, (double[])item_.getPclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitHi, (double[])item_.getPclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk0_limitLo, (double[])item_.getPclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnHi, (double[])item_.getPclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_warnLo, (double[])item_.getPclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitHi, (double[])item_.getPclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclk1_limitLo, (double[])item_.getPclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnHi, (double[])item_.getPclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_warnLo, (double[])item_.getPclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitHi, (double[])item_.getPclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclkl_limitLo, (double[])item_.getPclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnHi, (double[])item_.getPclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_warnLo, (double[])item_.getPclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitHi, (double[])item_.getPclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])pclku_limitLo, (double[])item_.getPclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnHi, (double[])item_.getPower_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_warnLo, (double[])item_.getPower_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitHi, (double[])item_.getPower_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])power_limitLo, (double[])item_.getPower_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnHi, (double[])item_.getRg0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_warnLo, (double[])item_.getRg0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitHi, (double[])item_.getRg0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg0_limitLo, (double[])item_.getRg0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnHi, (double[])item_.getRg1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_warnLo, (double[])item_.getRg1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitHi, (double[])item_.getRg1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rg1_limitLo, (double[])item_.getRg1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnHi, (double[])item_.getRgl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_warnLo, (double[])item_.getRgl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitHi, (double[])item_.getRgl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgl_limitLo, (double[])item_.getRgl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnHi, (double[])item_.getRgu_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_warnLo, (double[])item_.getRgu_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitHi, (double[])item_.getRgu_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rgu_limitLo, (double[])item_.getRgu_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnHi, (double[])item_.getRtdtemp_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_warnLo, (double[])item_.getRtdtemp_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitHi, (double[])item_.getRtdtemp_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])rtdtemp_limitLo, (double[])item_.getRtdtemp_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnHi, (double[])item_.getRef05v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_warnLo, (double[])item_.getRef05v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitHi, (double[])item_.getRef05v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref05v_limitLo, (double[])item_.getRef05v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnHi, (double[])item_.getRef125v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_warnLo, (double[])item_.getRef125v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitHi, (double[])item_.getRef125v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref125v_limitLo, (double[])item_.getRef125v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnHi, (double[])item_.getRef15v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_warnLo, (double[])item_.getRef15v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitHi, (double[])item_.getRef15v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref15v_limitLo, (double[])item_.getRef15v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnHi, (double[])item_.getRef25v_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_warnLo, (double[])item_.getRef25v_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitHi, (double[])item_.getRef25v_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])ref25v_limitLo, (double[])item_.getRef25v_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnHi, (double[])item_.getRefn12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_warnLo, (double[])item_.getRefn12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitHi, (double[])item_.getRefn12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refn12_limitLo, (double[])item_.getRefn12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnHi, (double[])item_.getRefp12_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_warnLo, (double[])item_.getRefp12_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitHi, (double[])item_.getRefp12_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])refp12_limitLo, (double[])item_.getRefp12_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnHi, (double[])item_.getSclk0_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_warnLo, (double[])item_.getSclk0_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitHi, (double[])item_.getSclk0_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk0_limitLo, (double[])item_.getSclk0_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnHi, (double[])item_.getSclk1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_warnLo, (double[])item_.getSclk1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitHi, (double[])item_.getSclk1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclk1_limitLo, (double[])item_.getSclk1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnHi, (double[])item_.getSclkl_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_warnLo, (double[])item_.getSclkl_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitHi, (double[])item_.getSclkl_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclkl_limitLo, (double[])item_.getSclkl_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnHi, (double[])item_.getSclku_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_warnLo, (double[])item_.getSclku_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitHi, (double[])item_.getSclku_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])sclku_limitLo, (double[])item_.getSclku_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnHi, (double[])item_.getTemp10_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_warnLo, (double[])item_.getTemp10_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitHi, (double[])item_.getTemp10_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp10_limitLo, (double[])item_.getTemp10_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnHi, (double[])item_.getTemp1_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_warnLo, (double[])item_.getTemp1_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitHi, (double[])item_.getTemp1_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp1_limitLo, (double[])item_.getTemp1_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnHi, (double[])item_.getTemp2_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_warnLo, (double[])item_.getTemp2_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitHi, (double[])item_.getTemp2_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp2_limitLo, (double[])item_.getTemp2_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnHi, (double[])item_.getTemp3_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_warnLo, (double[])item_.getTemp3_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitHi, (double[])item_.getTemp3_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp3_limitLo, (double[])item_.getTemp3_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnHi, (double[])item_.getTemp4_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_warnLo, (double[])item_.getTemp4_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitHi, (double[])item_.getTemp4_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp4_limitLo, (double[])item_.getTemp4_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnHi, (double[])item_.getTemp5_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_warnLo, (double[])item_.getTemp5_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitHi, (double[])item_.getTemp5_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp5_limitLo, (double[])item_.getTemp5_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnHi, (double[])item_.getTemp6_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_warnLo, (double[])item_.getTemp6_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitHi, (double[])item_.getTemp6_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp6_limitLo, (double[])item_.getTemp6_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnHi, (double[])item_.getTemp7_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_warnLo, (double[])item_.getTemp7_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitHi, (double[])item_.getTemp7_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp7_limitLo, (double[])item_.getTemp7_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnHi, (double[])item_.getTemp8_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_warnLo, (double[])item_.getTemp8_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitHi, (double[])item_.getTemp8_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp8_limitLo, (double[])item_.getTemp8_limitLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnHi, (double[])item_.getTemp9_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_warnLo, (double[])item_.getTemp9_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitHi, (double[])item_.getTemp9_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])temp9_limitLo, (double[])item_.getTemp9_limitLo(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsSettingsAppliedEvent() throws Exception {
        int priority = 678;
        int version = 335;
        double[] bias0_csGateP = TestHelper.generateDoubleArray((int)71, (int)1536772655);
        double[] bias0_gdP = TestHelper.generateDoubleArray((int)71, (int)-187777241);
        double[] bias0_odP = TestHelper.generateDoubleArray((int)71, (int)-557807564);
        double[] bias0_ogP = TestHelper.generateDoubleArray((int)71, (int)1873770283);
        double[] bias0_rdP = TestHelper.generateDoubleArray((int)71, (int)-43363386);
        double[] bias1_csGateP = TestHelper.generateDoubleArray((int)71, (int)2086689249);
        double[] bias1_gdP = TestHelper.generateDoubleArray((int)71, (int)-1595791238);
        double[] bias1_odP = TestHelper.generateDoubleArray((int)71, (int)277214814);
        double[] bias1_ogP = TestHelper.generateDoubleArray((int)71, (int)273511501);
        double[] bias1_rdP = TestHelper.generateDoubleArray((int)71, (int)788200446);
        double[] bias2_csGateP = TestHelper.generateDoubleArray((int)71, (int)-244867215);
        double[] bias2_gdP = TestHelper.generateDoubleArray((int)71, (int)-2029283447);
        double[] bias2_odP = TestHelper.generateDoubleArray((int)71, (int)-666149701);
        double[] bias2_ogP = TestHelper.generateDoubleArray((int)71, (int)-2036453503);
        double[] bias2_rdP = TestHelper.generateDoubleArray((int)71, (int)-706430264);
        double[] dac_pclkHighP = TestHelper.generateDoubleArray((int)71, (int)-2024826723);
        double[] dac_pclkLowP = TestHelper.generateDoubleArray((int)71, (int)226610770);
        double[] dac_rgHighP = TestHelper.generateDoubleArray((int)71, (int)1090344627);
        double[] dac_rgLowP = TestHelper.generateDoubleArray((int)71, (int)-1421096878);
        double[] dac_sclkHighP = TestHelper.generateDoubleArray((int)71, (int)-221279324);
        double[] dac_sclkLowP = TestHelper.generateDoubleArray((int)71, (int)279604959);
        boolean[] disableRTDHardwareCheck = new boolean[]{true, false, true, true, true, true, false, true, false, false, false, true, false, true, false, false, true, true, true, false, true, false, true, true, true, false, false, false, false, false, false, false, true, true, true, true, false, true, true, false, true, false, false, false, true, true, false, false, true, false, false, true, true, false, true, false, true, false, false, true, false, true, false, true, false, false, false, false, false, false, false};
        String location = "d";
        long[] serialNum = TestHelper.generateLongArray((int)71, (int)2006777081);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsSettingsAppliedEvent(priority, version, bias0_csGateP, bias0_gdP, bias0_odP, bias0_ogP, bias0_rdP, bias1_csGateP, bias1_gdP, bias1_odP, bias1_ogP, bias1_rdP, bias2_csGateP, bias2_gdP, bias2_odP, bias2_ogP, bias2_rdP, dac_pclkHighP, dac_pclkLowP, dac_rgHighP, dac_rgLowP, dac_sclkHighP, dac_sclkLowP, disableRTDHardwareCheck, location, serialNum));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_csGateP, (double[])item_.getBias0_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdP, (double[])item_.getBias0_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odP, (double[])item_.getBias0_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogP, (double[])item_.getBias0_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdP, (double[])item_.getBias0_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_csGateP, (double[])item_.getBias1_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdP, (double[])item_.getBias1_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odP, (double[])item_.getBias1_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogP, (double[])item_.getBias1_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdP, (double[])item_.getBias1_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_csGateP, (double[])item_.getBias2_csGateP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdP, (double[])item_.getBias2_gdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odP, (double[])item_.getBias2_odP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogP, (double[])item_.getBias2_ogP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdP, (double[])item_.getBias2_rdP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighP, (double[])item_.getDac_pclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowP, (double[])item_.getDac_pclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighP, (double[])item_.getDac_rgHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowP, (double[])item_.getDac_rgLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighP, (double[])item_.getDac_sclkHighP(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowP, (double[])item_.getDac_sclkLowP(), (double)1.0E-6f);
        Assert.assertArrayEquals((boolean[])disableRTDHardwareCheck, (boolean[])item_.getDisableRTDHardwareCheck());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])serialNum, (long[])item_.getSerialNum());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsLimitsSettingsAppliedEvent() throws Exception {
        int priority = 781;
        int version = 499;
        double[] bias0_gdMax = TestHelper.generateDoubleArray((int)71, (int)1661024012);
        double[] bias0_gdMin = TestHelper.generateDoubleArray((int)71, (int)-1118348014);
        double[] bias0_odMax = TestHelper.generateDoubleArray((int)71, (int)-2017394604);
        double[] bias0_odMin = TestHelper.generateDoubleArray((int)71, (int)-2038123795);
        double[] bias0_ogMax = TestHelper.generateDoubleArray((int)71, (int)2037107818);
        double[] bias0_ogMin = TestHelper.generateDoubleArray((int)71, (int)424130202);
        double[] bias0_rdMax = TestHelper.generateDoubleArray((int)71, (int)274989165);
        double[] bias0_rdMin = TestHelper.generateDoubleArray((int)71, (int)978362666);
        double[] bias1_gdMax = TestHelper.generateDoubleArray((int)71, (int)-1933213280);
        double[] bias1_gdMin = TestHelper.generateDoubleArray((int)71, (int)-2086737047);
        double[] bias1_odMax = TestHelper.generateDoubleArray((int)71, (int)671002819);
        double[] bias1_odMin = TestHelper.generateDoubleArray((int)71, (int)-1232725829);
        double[] bias1_ogMax = TestHelper.generateDoubleArray((int)71, (int)1233971214);
        double[] bias1_ogMin = TestHelper.generateDoubleArray((int)71, (int)-246587340);
        double[] bias1_rdMax = TestHelper.generateDoubleArray((int)71, (int)172228825);
        double[] bias1_rdMin = TestHelper.generateDoubleArray((int)71, (int)1482885209);
        double[] bias2_gdMax = TestHelper.generateDoubleArray((int)71, (int)-506937030);
        double[] bias2_gdMin = TestHelper.generateDoubleArray((int)71, (int)-1082219467);
        double[] bias2_odMax = TestHelper.generateDoubleArray((int)71, (int)-539230429);
        double[] bias2_odMin = TestHelper.generateDoubleArray((int)71, (int)317383846);
        double[] bias2_ogMax = TestHelper.generateDoubleArray((int)71, (int)1480005056);
        double[] bias2_ogMin = TestHelper.generateDoubleArray((int)71, (int)-969576693);
        double[] bias2_rdMax = TestHelper.generateDoubleArray((int)71, (int)-1759917278);
        double[] bias2_rdMin = TestHelper.generateDoubleArray((int)71, (int)-1370705225);
        double[] dac_pclkHighMax = TestHelper.generateDoubleArray((int)71, (int)1440892806);
        double[] dac_pclkHighMin = TestHelper.generateDoubleArray((int)71, (int)386865374);
        double[] dac_pclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-1269427024);
        double[] dac_pclkLowMin = TestHelper.generateDoubleArray((int)71, (int)104904402);
        double[] dac_rgHighMax = TestHelper.generateDoubleArray((int)71, (int)-138898637);
        double[] dac_rgHighMin = TestHelper.generateDoubleArray((int)71, (int)-1811681082);
        double[] dac_rgLowMax = TestHelper.generateDoubleArray((int)71, (int)-1415463780);
        double[] dac_rgLowMin = TestHelper.generateDoubleArray((int)71, (int)399231864);
        double[] dac_sclkHighMax = TestHelper.generateDoubleArray((int)71, (int)-627723039);
        double[] dac_sclkHighMin = TestHelper.generateDoubleArray((int)71, (int)-1486088851);
        double[] dac_sclkLowMax = TestHelper.generateDoubleArray((int)71, (int)-2069271943);
        double[] dac_sclkLowMin = TestHelper.generateDoubleArray((int)71, (int)959620261);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent(priority, version, bias0_gdMax, bias0_gdMin, bias0_odMax, bias0_odMin, bias0_ogMax, bias0_ogMin, bias0_rdMax, bias0_rdMin, bias1_gdMax, bias1_gdMin, bias1_odMax, bias1_odMin, bias1_ogMax, bias1_ogMin, bias1_rdMax, bias1_rdMin, bias2_gdMax, bias2_gdMin, bias2_odMax, bias2_odMin, bias2_ogMax, bias2_ogMin, bias2_rdMax, bias2_rdMin, dac_pclkHighMax, dac_pclkHighMin, dac_pclkLowMax, dac_pclkLowMin, dac_rgHighMax, dac_rgHighMin, dac_rgLowMax, dac_rgLowMin, dac_sclkHighMax, dac_sclkHighMin, dac_sclkLowMax, dac_sclkLowMin, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent));
        Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsLimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdMax, (double[])item_.getBias0_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdMin, (double[])item_.getBias0_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMax, (double[])item_.getBias0_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odMin, (double[])item_.getBias0_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMax, (double[])item_.getBias0_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogMin, (double[])item_.getBias0_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMax, (double[])item_.getBias0_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdMin, (double[])item_.getBias0_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMax, (double[])item_.getBias1_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdMin, (double[])item_.getBias1_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMax, (double[])item_.getBias1_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odMin, (double[])item_.getBias1_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMax, (double[])item_.getBias1_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogMin, (double[])item_.getBias1_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMax, (double[])item_.getBias1_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdMin, (double[])item_.getBias1_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMax, (double[])item_.getBias2_gdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdMin, (double[])item_.getBias2_gdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMax, (double[])item_.getBias2_odMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odMin, (double[])item_.getBias2_odMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMax, (double[])item_.getBias2_ogMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogMin, (double[])item_.getBias2_ogMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMax, (double[])item_.getBias2_rdMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdMin, (double[])item_.getBias2_rdMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMax, (double[])item_.getDac_pclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighMin, (double[])item_.getDac_pclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMax, (double[])item_.getDac_pclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowMin, (double[])item_.getDac_pclkLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMax, (double[])item_.getDac_rgHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighMin, (double[])item_.getDac_rgHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMax, (double[])item_.getDac_rgLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowMin, (double[])item_.getDac_rgLowMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMax, (double[])item_.getDac_sclkHighMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighMin, (double[])item_.getDac_sclkHighMin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMax, (double[])item_.getDac_sclkLowMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowMin, (double[])item_.getDac_sclkLowMin(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_Reb_RaftsPowerSettingsAppliedEvent() throws Exception {
        int priority = 409;
        int version = 553;
        double[] bias0_gdCal = TestHelper.generateDoubleArray((int)71, (int)1120371541);
        double[] bias0_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1166187230);
        double[] bias0_gdTol = TestHelper.generateDoubleArray((int)71, (int)1010553104);
        double[] bias0_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-629903390);
        double[] bias0_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-790553270);
        double[] bias0_odCal = TestHelper.generateDoubleArray((int)71, (int)1243602036);
        double[] bias0_odIMax = TestHelper.generateDoubleArray((int)71, (int)-835780481);
        double[] bias0_odTol = TestHelper.generateDoubleArray((int)71, (int)1361311330);
        double[] bias0_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)921812236);
        double[] bias0_ogCal = TestHelper.generateDoubleArray((int)71, (int)1463152323);
        double[] bias0_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)-239358311);
        double[] bias0_ogTol = TestHelper.generateDoubleArray((int)71, (int)-736591581);
        double[] bias0_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-1784553935);
        double[] bias0_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)1713126256);
        double[] bias0_rdCal = TestHelper.generateDoubleArray((int)71, (int)1822023745);
        double[] bias0_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-535273283);
        double[] bias0_rdTol = TestHelper.generateDoubleArray((int)71, (int)-1438529058);
        double[] bias0_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1094235124);
        double[] bias0_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1450478848);
        double[] bias1_gdCal = TestHelper.generateDoubleArray((int)71, (int)-1261228602);
        double[] bias1_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)18478989);
        double[] bias1_gdTol = TestHelper.generateDoubleArray((int)71, (int)-945678968);
        double[] bias1_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-114755728);
        double[] bias1_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-311147673);
        double[] bias1_odCal = TestHelper.generateDoubleArray((int)71, (int)-564513264);
        double[] bias1_odIMax = TestHelper.generateDoubleArray((int)71, (int)1508640487);
        double[] bias1_odTol = TestHelper.generateDoubleArray((int)71, (int)-470243363);
        double[] bias1_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-615919827);
        double[] bias1_ogCal = TestHelper.generateDoubleArray((int)71, (int)1591992533);
        double[] bias1_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)1985793845);
        double[] bias1_ogTol = TestHelper.generateDoubleArray((int)71, (int)235793704);
        double[] bias1_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-835941860);
        double[] bias1_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)1932240234);
        double[] bias1_rdCal = TestHelper.generateDoubleArray((int)71, (int)2087325367);
        double[] bias1_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)1884096494);
        double[] bias1_rdTol = TestHelper.generateDoubleArray((int)71, (int)2088857353);
        double[] bias1_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1624007357);
        double[] bias1_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)1402627939);
        double[] bias2_gdCal = TestHelper.generateDoubleArray((int)71, (int)23749610);
        double[] bias2_gdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-261094871);
        double[] bias2_gdTol = TestHelper.generateDoubleArray((int)71, (int)325500859);
        double[] bias2_gdValueErr = TestHelper.generateDoubleArray((int)71, (int)-1122721646);
        double[] bias2_gdZeroErr = TestHelper.generateDoubleArray((int)71, (int)199263127);
        double[] bias2_odCal = TestHelper.generateDoubleArray((int)71, (int)-2038628892);
        double[] bias2_odIMax = TestHelper.generateDoubleArray((int)71, (int)925560920);
        double[] bias2_odTol = TestHelper.generateDoubleArray((int)71, (int)-1420766733);
        double[] bias2_odZeroErr = TestHelper.generateDoubleArray((int)71, (int)-504987111);
        double[] bias2_ogCal = TestHelper.generateDoubleArray((int)71, (int)2086828271);
        double[] bias2_ogTestVolts = TestHelper.generateDoubleArray((int)71, (int)529476946);
        double[] bias2_ogTol = TestHelper.generateDoubleArray((int)71, (int)-1581463101);
        double[] bias2_ogValueErr = TestHelper.generateDoubleArray((int)71, (int)-1707978915);
        double[] bias2_ogZeroErr = TestHelper.generateDoubleArray((int)71, (int)2063325593);
        double[] bias2_rdCal = TestHelper.generateDoubleArray((int)71, (int)1859101270);
        double[] bias2_rdTestVolts = TestHelper.generateDoubleArray((int)71, (int)-846978502);
        double[] bias2_rdTol = TestHelper.generateDoubleArray((int)71, (int)-1084224898);
        double[] bias2_rdValueErr = TestHelper.generateDoubleArray((int)71, (int)749546084);
        double[] bias2_rdZeroErr = TestHelper.generateDoubleArray((int)71, (int)-2067684473);
        double[] clkhiAmin = TestHelper.generateDoubleArray((int)71, (int)-2034255288);
        double[] clkhiQmax = TestHelper.generateDoubleArray((int)71, (int)1435115114);
        double[] clkliAmin = TestHelper.generateDoubleArray((int)71, (int)-401431594);
        double[] clkliQmax = TestHelper.generateDoubleArray((int)71, (int)-925510460);
        double[] dac_clkhIMax = TestHelper.generateDoubleArray((int)71, (int)-313031295);
        double[] dac_clklIMax = TestHelper.generateDoubleArray((int)71, (int)-734788411);
        double[] dac_pclkHighCal = TestHelper.generateDoubleArray((int)71, (int)1715371921);
        double[] dac_pclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-1132527312);
        double[] dac_pclkHighTol = TestHelper.generateDoubleArray((int)71, (int)1243408212);
        double[] dac_pclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)1482937101);
        double[] dac_pclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)1637378209);
        double[] dac_pclkLowCal = TestHelper.generateDoubleArray((int)71, (int)-995072274);
        double[] dac_pclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)575868291);
        double[] dac_pclkLowTol = TestHelper.generateDoubleArray((int)71, (int)1910830590);
        double[] dac_pclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)1741888789);
        double[] dac_pclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1961985236);
        double[] dac_rgHighCal = TestHelper.generateDoubleArray((int)71, (int)-1791099442);
        double[] dac_rgHighTestV = TestHelper.generateDoubleArray((int)71, (int)963690295);
        double[] dac_rgHighTol = TestHelper.generateDoubleArray((int)71, (int)-2086529840);
        double[] dac_rgHighValueErr = TestHelper.generateDoubleArray((int)71, (int)395930211);
        double[] dac_rgHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1347925263);
        double[] dac_rgLowCal = TestHelper.generateDoubleArray((int)71, (int)1780459804);
        double[] dac_rgLowTestV = TestHelper.generateDoubleArray((int)71, (int)589447584);
        double[] dac_rgLowTol = TestHelper.generateDoubleArray((int)71, (int)1917376732);
        double[] dac_rgLowValueErr = TestHelper.generateDoubleArray((int)71, (int)467313873);
        double[] dac_rgLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1051691778);
        double[] dac_sclkHighCal = TestHelper.generateDoubleArray((int)71, (int)-1819919217);
        double[] dac_sclkHighTestV = TestHelper.generateDoubleArray((int)71, (int)-1652250763);
        double[] dac_sclkHighTol = TestHelper.generateDoubleArray((int)71, (int)-1535133711);
        double[] dac_sclkHighValueErr = TestHelper.generateDoubleArray((int)71, (int)190875513);
        double[] dac_sclkHighZeroErr = TestHelper.generateDoubleArray((int)71, (int)-221809543);
        double[] dac_sclkLowCal = TestHelper.generateDoubleArray((int)71, (int)-153173852);
        double[] dac_sclkLowTestV = TestHelper.generateDoubleArray((int)71, (int)-912125910);
        double[] dac_sclkLowTol = TestHelper.generateDoubleArray((int)71, (int)-1016912099);
        double[] dac_sclkLowValueErr = TestHelper.generateDoubleArray((int)71, (int)-903663138);
        double[] dac_sclkLowZeroErr = TestHelper.generateDoubleArray((int)71, (int)-1355927108);
        String location = "";
        double[] maxDelta = TestHelper.generateDoubleArray((int)71, (int)-1363443376);
        double[] maxStep = TestHelper.generateDoubleArray((int)71, (int)-381451271);
        double[] minTol = TestHelper.generateDoubleArray((int)71, (int)-965995409);
        int[] nPowerOnPub = TestHelper.generateIntArray((int)71, (int)-1550556451);
        double[] odiAmin = TestHelper.generateDoubleArray((int)71, (int)760715634);
        double[] odiQmax = TestHelper.generateDoubleArray((int)71, (int)794913553);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_RaftsPowerSettingsAppliedEvent(priority, version, bias0_gdCal, bias0_gdTestVolts, bias0_gdTol, bias0_gdValueErr, bias0_gdZeroErr, bias0_odCal, bias0_odIMax, bias0_odTol, bias0_odZeroErr, bias0_ogCal, bias0_ogTestVolts, bias0_ogTol, bias0_ogValueErr, bias0_ogZeroErr, bias0_rdCal, bias0_rdTestVolts, bias0_rdTol, bias0_rdValueErr, bias0_rdZeroErr, bias1_gdCal, bias1_gdTestVolts, bias1_gdTol, bias1_gdValueErr, bias1_gdZeroErr, bias1_odCal, bias1_odIMax, bias1_odTol, bias1_odZeroErr, bias1_ogCal, bias1_ogTestVolts, bias1_ogTol, bias1_ogValueErr, bias1_ogZeroErr, bias1_rdCal, bias1_rdTestVolts, bias1_rdTol, bias1_rdValueErr, bias1_rdZeroErr, bias2_gdCal, bias2_gdTestVolts, bias2_gdTol, bias2_gdValueErr, bias2_gdZeroErr, bias2_odCal, bias2_odIMax, bias2_odTol, bias2_odZeroErr, bias2_ogCal, bias2_ogTestVolts, bias2_ogTol, bias2_ogValueErr, bias2_ogZeroErr, bias2_rdCal, bias2_rdTestVolts, bias2_rdTol, bias2_rdValueErr, bias2_rdZeroErr, clkhiAmin, clkhiQmax, clkliAmin, clkliQmax, dac_clkhIMax, dac_clklIMax, dac_pclkHighCal, dac_pclkHighTestV, dac_pclkHighTol, dac_pclkHighValueErr, dac_pclkHighZeroErr, dac_pclkLowCal, dac_pclkLowTestV, dac_pclkLowTol, dac_pclkLowValueErr, dac_pclkLowZeroErr, dac_rgHighCal, dac_rgHighTestV, dac_rgHighTol, dac_rgHighValueErr, dac_rgHighZeroErr, dac_rgLowCal, dac_rgLowTestV, dac_rgLowTol, dac_rgLowValueErr, dac_rgLowZeroErr, dac_sclkHighCal, dac_sclkHighTestV, dac_sclkHighTol, dac_sclkHighValueErr, dac_sclkHighZeroErr, dac_sclkLowCal, dac_sclkLowTestV, dac_sclkLowTol, dac_sclkLowValueErr, dac_sclkLowZeroErr, location, maxDelta, maxStep, minTol, nPowerOnPub, odiAmin, odiQmax));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_RaftsPowerSettingsAppliedEvent));
        Focal_plane_Reb_RaftsPowerSettingsAppliedEvent item_ = (Focal_plane_Reb_RaftsPowerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])bias0_gdCal, (double[])item_.getBias0_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTestVolts, (double[])item_.getBias0_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdTol, (double[])item_.getBias0_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdValueErr, (double[])item_.getBias0_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_gdZeroErr, (double[])item_.getBias0_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odCal, (double[])item_.getBias0_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odIMax, (double[])item_.getBias0_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odTol, (double[])item_.getBias0_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_odZeroErr, (double[])item_.getBias0_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogCal, (double[])item_.getBias0_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTestVolts, (double[])item_.getBias0_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogTol, (double[])item_.getBias0_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogValueErr, (double[])item_.getBias0_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_ogZeroErr, (double[])item_.getBias0_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdCal, (double[])item_.getBias0_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTestVolts, (double[])item_.getBias0_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdTol, (double[])item_.getBias0_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdValueErr, (double[])item_.getBias0_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias0_rdZeroErr, (double[])item_.getBias0_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdCal, (double[])item_.getBias1_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTestVolts, (double[])item_.getBias1_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdTol, (double[])item_.getBias1_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdValueErr, (double[])item_.getBias1_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_gdZeroErr, (double[])item_.getBias1_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odCal, (double[])item_.getBias1_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odIMax, (double[])item_.getBias1_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odTol, (double[])item_.getBias1_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_odZeroErr, (double[])item_.getBias1_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogCal, (double[])item_.getBias1_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTestVolts, (double[])item_.getBias1_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogTol, (double[])item_.getBias1_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogValueErr, (double[])item_.getBias1_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_ogZeroErr, (double[])item_.getBias1_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdCal, (double[])item_.getBias1_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTestVolts, (double[])item_.getBias1_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdTol, (double[])item_.getBias1_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdValueErr, (double[])item_.getBias1_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias1_rdZeroErr, (double[])item_.getBias1_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdCal, (double[])item_.getBias2_gdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTestVolts, (double[])item_.getBias2_gdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdTol, (double[])item_.getBias2_gdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdValueErr, (double[])item_.getBias2_gdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_gdZeroErr, (double[])item_.getBias2_gdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odCal, (double[])item_.getBias2_odCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odIMax, (double[])item_.getBias2_odIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odTol, (double[])item_.getBias2_odTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_odZeroErr, (double[])item_.getBias2_odZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogCal, (double[])item_.getBias2_ogCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTestVolts, (double[])item_.getBias2_ogTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogTol, (double[])item_.getBias2_ogTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogValueErr, (double[])item_.getBias2_ogValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_ogZeroErr, (double[])item_.getBias2_ogZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdCal, (double[])item_.getBias2_rdCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTestVolts, (double[])item_.getBias2_rdTestVolts(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdTol, (double[])item_.getBias2_rdTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdValueErr, (double[])item_.getBias2_rdValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])bias2_rdZeroErr, (double[])item_.getBias2_rdZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiAmin, (double[])item_.getClkhiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkhiQmax, (double[])item_.getClkhiQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliAmin, (double[])item_.getClkliAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])clkliQmax, (double[])item_.getClkliQmax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clkhIMax, (double[])item_.getDac_clkhIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_clklIMax, (double[])item_.getDac_clklIMax(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighCal, (double[])item_.getDac_pclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTestV, (double[])item_.getDac_pclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighTol, (double[])item_.getDac_pclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighValueErr, (double[])item_.getDac_pclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkHighZeroErr, (double[])item_.getDac_pclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowCal, (double[])item_.getDac_pclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTestV, (double[])item_.getDac_pclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowTol, (double[])item_.getDac_pclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowValueErr, (double[])item_.getDac_pclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_pclkLowZeroErr, (double[])item_.getDac_pclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighCal, (double[])item_.getDac_rgHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTestV, (double[])item_.getDac_rgHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighTol, (double[])item_.getDac_rgHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighValueErr, (double[])item_.getDac_rgHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgHighZeroErr, (double[])item_.getDac_rgHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowCal, (double[])item_.getDac_rgLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTestV, (double[])item_.getDac_rgLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowTol, (double[])item_.getDac_rgLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowValueErr, (double[])item_.getDac_rgLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_rgLowZeroErr, (double[])item_.getDac_rgLowZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighCal, (double[])item_.getDac_sclkHighCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTestV, (double[])item_.getDac_sclkHighTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighTol, (double[])item_.getDac_sclkHighTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighValueErr, (double[])item_.getDac_sclkHighValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkHighZeroErr, (double[])item_.getDac_sclkHighZeroErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowCal, (double[])item_.getDac_sclkLowCal(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTestV, (double[])item_.getDac_sclkLowTestV(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowTol, (double[])item_.getDac_sclkLowTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowValueErr, (double[])item_.getDac_sclkLowValueErr(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])dac_sclkLowZeroErr, (double[])item_.getDac_sclkLowZeroErr(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((double[])maxDelta, (double[])item_.getMaxDelta(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])maxStep, (double[])item_.getMaxStep(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])minTol, (double[])item_.getMinTol(), (double)1.0E-6f);
        Assert.assertArrayEquals((int[])nPowerOnPub, (int[])item_.getNPowerOnPub());
        Assert.assertArrayEquals((double[])odiAmin, (double[])item_.getOdiAmin(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])odiQmax, (double[])item_.getOdiQmax(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveFocal_plane_Reb_timersSettingsAppliedEvent() throws Exception {
        int priority = 849;
        int version = 493;
        String location = "";
        long[] periodictasks_monitor_check_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-424750066);
        long[] periodictasks_monitor_publish_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2065015255);
        long[] periodictasks_monitor_publish_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)355852705);
        long[] periodictasks_monitor_publish_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1935057280);
        long[] periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)875313486);
        long[] periodictasks_monitor_publish_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)411164570);
        long[] periodictasks_monitor_publish_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)840436754);
        long[] periodictasks_monitor_publish_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)871796178);
        long[] periodictasks_monitor_update_aspicTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-67699527);
        long[] periodictasks_monitor_update_biasVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-2007741374);
        long[] periodictasks_monitor_update_boardPower_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)2097542495);
        long[] periodictasks_monitor_update_ccdCurrent_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-1729218837);
        long[] periodictasks_monitor_update_crVolt_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-447033582);
        long[] periodictasks_monitor_update_rebTemp_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)-364790990);
        long[] periodictasks_monitor_update_taskPeriodMillis = TestHelper.generateLongArray((int)71, (int)1570916693);
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Reb_timersSettingsAppliedEvent(priority, version, location, periodictasks_monitor_check_taskPeriodMillis, periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, periodictasks_monitor_publish_biasVolt_taskPeriodMillis, periodictasks_monitor_publish_boardPower_taskPeriodMillis, periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, periodictasks_monitor_publish_crVolt_taskPeriodMillis, periodictasks_monitor_publish_rebTemp_taskPeriodMillis, periodictasks_monitor_publish_taskPeriodMillis, periodictasks_monitor_update_aspicTemp_taskPeriodMillis, periodictasks_monitor_update_biasVolt_taskPeriodMillis, periodictasks_monitor_update_boardPower_taskPeriodMillis, periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, periodictasks_monitor_update_crVolt_taskPeriodMillis, periodictasks_monitor_update_rebTemp_taskPeriodMillis, periodictasks_monitor_update_taskPeriodMillis));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Reb_timersSettingsAppliedEvent));
        Focal_plane_Reb_timersSettingsAppliedEvent item_ = (Focal_plane_Reb_timersSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
        Assert.assertArrayEquals((long[])periodictasks_monitor_check_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_check_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_publish_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_publish_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_aspicTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_aspicTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_biasVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_biasVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_boardPower_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_boardPower_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_ccdCurrent_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_ccdCurrent_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_crVolt_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_crVolt_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_rebTemp_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_rebTemp_taskPeriodMillis());
        Assert.assertArrayEquals((long[])periodictasks_monitor_update_taskPeriodMillis, (long[])item_.getPeriodictasks_monitor_update_taskPeriodMillis());
    }

    @Test
    public void sendReceiveFocal_plane_Segment_LimitsSettingsAppliedEvent() throws Exception {
        int priority = 772;
        int version = 864;
        double[] i_warnHi = TestHelper.generateDoubleArray((int)3024, (int)294403633);
        double[] i_warnLo = TestHelper.generateDoubleArray((int)3024, (int)249822647);
        double[] i_limitHi = TestHelper.generateDoubleArray((int)3024, (int)958272510);
        double[] i_limitLo = TestHelper.generateDoubleArray((int)3024, (int)-1488742739);
        String location = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_Segment_LimitsSettingsAppliedEvent(priority, version, i_warnHi, i_warnLo, i_limitHi, i_limitLo, location));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_Segment_LimitsSettingsAppliedEvent));
        Focal_plane_Segment_LimitsSettingsAppliedEvent item_ = (Focal_plane_Segment_LimitsSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertArrayEquals((double[])i_warnHi, (double[])item_.getI_warnHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_warnLo, (double[])item_.getI_warnLo(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitHi, (double[])item_.getI_limitHi(), (double)1.0E-6f);
        Assert.assertArrayEquals((double[])i_limitLo, (double[])item_.getI_limitLo(), (double)1.0E-6f);
        Assert.assertEquals((Object)location, (Object)item_.getLocation());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_DAQSettingsAppliedEvent() throws Exception {
        int priority = 534;
        int version = 481;
        String daqFolder = "j";
        String daqPartition = "c";
        boolean emulatedDAQ = true;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_DAQSettingsAppliedEvent(priority, version, daqFolder, daqPartition, emulatedDAQ));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_DAQSettingsAppliedEvent));
        Focal_plane_SequencerConfig_DAQSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_DAQSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqPartition, (Object)item_.getDaqPartition());
        Assert.assertEquals((Object)emulatedDAQ, (Object)item_.isEmulatedDAQ());
    }

    @Test
    public void sendReceiveFocal_plane_SequencerConfig_SequencerSettingsAppliedEvent() throws Exception {
        int priority = 269;
        int version = 66;
        String clearCountParameter = "k";
        String clearMain = "c";
        String idleFlushMain = "";
        long idleFlushTimeout = 427L;
        String integrateMain = "d";
        String metaDataRegisters = "";
        int overCols = 184;
        int overRows = 871;
        int postCols = 554;
        int postRows = 261;
        int preCols = 876;
        int preRows = 179;
        String pseudoReadMain = "";
        int readCols = 738;
        int readCols2 = 56;
        String readMain = "s";
        int readRows = 530;
        String rowShiftForwardMain = "";
        String rowShiftReverseMain = "m";
        boolean scanMode = true;
        String sequencer = "";
        String sequencerChecksums = "";
        String shiftCountParameter = "q";
        boolean stepAfterIntegrate = false;
        int transparentMode = 406;
        int underCols = 51;
        boolean useParallelRegisters = false;
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent(priority, version, clearCountParameter, clearMain, idleFlushMain, idleFlushTimeout, integrateMain, metaDataRegisters, overCols, overRows, postCols, postRows, preCols, preRows, pseudoReadMain, readCols, readCols2, readMain, readRows, rowShiftForwardMain, rowShiftReverseMain, scanMode, sequencer, sequencerChecksums, shiftCountParameter, stepAfterIntegrate, transparentMode, underCols, useParallelRegisters));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent));
        Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent item_ = (Focal_plane_SequencerConfig_SequencerSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)clearCountParameter, (Object)item_.getClearCountParameter());
        Assert.assertEquals((Object)clearMain, (Object)item_.getClearMain());
        Assert.assertEquals((Object)idleFlushMain, (Object)item_.getIdleFlushMain());
        Assert.assertEquals((long)idleFlushTimeout, (long)item_.getIdleFlushTimeout());
        Assert.assertEquals((Object)integrateMain, (Object)item_.getIntegrateMain());
        Assert.assertEquals((Object)metaDataRegisters, (Object)item_.getMetaDataRegisters());
        Assert.assertEquals((long)overCols, (long)item_.getOverCols());
        Assert.assertEquals((long)overRows, (long)item_.getOverRows());
        Assert.assertEquals((long)postCols, (long)item_.getPostCols());
        Assert.assertEquals((long)postRows, (long)item_.getPostRows());
        Assert.assertEquals((long)preCols, (long)item_.getPreCols());
        Assert.assertEquals((long)preRows, (long)item_.getPreRows());
        Assert.assertEquals((Object)pseudoReadMain, (Object)item_.getPseudoReadMain());
        Assert.assertEquals((long)readCols, (long)item_.getReadCols());
        Assert.assertEquals((long)readCols2, (long)item_.getReadCols2());
        Assert.assertEquals((Object)readMain, (Object)item_.getReadMain());
        Assert.assertEquals((long)readRows, (long)item_.getReadRows());
        Assert.assertEquals((Object)rowShiftForwardMain, (Object)item_.getRowShiftForwardMain());
        Assert.assertEquals((Object)rowShiftReverseMain, (Object)item_.getRowShiftReverseMain());
        Assert.assertEquals((Object)scanMode, (Object)item_.isScanMode());
        Assert.assertEquals((Object)sequencer, (Object)item_.getSequencer());
        Assert.assertEquals((Object)sequencerChecksums, (Object)item_.getSequencerChecksums());
        Assert.assertEquals((Object)shiftCountParameter, (Object)item_.getShiftCountParameter());
        Assert.assertEquals((Object)stepAfterIntegrate, (Object)item_.isStepAfterIntegrate());
        Assert.assertEquals((long)transparentMode, (long)item_.getTransparentMode());
        Assert.assertEquals((long)underCols, (long)item_.getUnderCols());
        Assert.assertEquals((Object)useParallelRegisters, (Object)item_.isUseParallelRegisters());
    }

    @Test
    public void sendReceiveFocal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent() throws Exception {
        int priority = 436;
        int version = 537;
        String webHooks = "";
        SALEvent item = this.testSendReceive((SALEvent)new Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent(priority, version, webHooks));
        Assert.assertTrue((boolean)(item instanceof Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent));
        Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent item_ = (Focal_plane_WebHooksConfig_VisualizationSettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)version, (long)item_.getVersion());
        Assert.assertEquals((Object)webHooks, (Object)item_.getWebHooks());
    }

    @Test
    public void sendReceiveConfigurationAppliedEvent() throws Exception {
        int priority = 55;
        String configurations = "k";
        String version = "";
        String url = "u";
        String schemaVersion = "n";
        String otherInfo = "";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationAppliedEvent(priority, configurations, version, url, schemaVersion, otherInfo));
        Assert.assertTrue((boolean)(item instanceof ConfigurationAppliedEvent));
        ConfigurationAppliedEvent item_ = (ConfigurationAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)configurations, (Object)item_.getConfigurations());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
        Assert.assertEquals((Object)otherInfo, (Object)item_.getOtherInfo());
    }

    @Test
    public void sendReceiveConfigurationsAvailableEvent() throws Exception {
        int priority = 550;
        String overrides = "z";
        String version = "";
        String url = "";
        String schemaVersion = "k";
        SALEvent item = this.testSendReceive((SALEvent)new ConfigurationsAvailableEvent(priority, overrides, version, url, schemaVersion));
        Assert.assertTrue((boolean)(item instanceof ConfigurationsAvailableEvent));
        ConfigurationsAvailableEvent item_ = (ConfigurationsAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)overrides, (Object)item_.getOverrides());
        Assert.assertEquals((Object)version, (Object)item_.getVersion());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)schemaVersion, (Object)item_.getSchemaVersion());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 924;
        int errorCode = 470;
        String errorReport = "";
        String traceback = "t";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 834;
        int level = 57;
        String subsystem = "u";
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level, subsystem));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)subsystem, (Object)item_.getSubsystem());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 673;
        String name = "";
        int level = 508;
        String message = "k";
        String traceback = "r";
        String filePath = "";
        String functionName = "z";
        int lineNumber = 387;
        int process = 177;
        double timestamp = 0.6217285990715027;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process, timestamp));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
        Assert.assertEquals((double)timestamp, (double)item_.getTimestamp(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 66;
        int mode = 524;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 979;
        String salVersion = "bwnevlxwssm";
        String xmlVersion = "gkyhmaeggadfjzvqlkwikumaqtksyswzlqqqooynumkuqwwprxbz";
        String openSpliceVersion = "ezlwjuviqrlfocphdw";
        String cscVersion = "yejsufl";
        String subsystemVersions = "c";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 335;
        boolean heartbeat = true;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 403;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }

    @Test
    public void sendReceiveLargeFileObjectAvailableEvent() throws Exception {
        int priority = 603;
        String url = "mjbnyzebsgnkguovfsplmrhvdcpmujhsxzjkhissokivbkevvoxddtcbiyqyrgzbcfehvwltkvlivlbxtjpslkksssatroxaolzavvjexzmouasrxkpjvpmbbgukwyimiadxlgdgdicvqsreonexfodgqgkbpykefiileskcykhdjrotmfigvujadcrzgvoiqdaesjnsdplbhrqgseliyccihubuy";
        String generator = "hqwnviuomvcitfmduyusij";
        float version = 0.661967f;
        int byteSize = 771;
        String checkSum = "pcoegzmvmyaocdadgpicpclfqpgwoiytcrbrkmqxqawkkngpcnxumpyhdyudjydvbdhaibcxbrcrmcfhemofgplyreb";
        String mimeType = "aetrypwaetlowzwqquauavtgpkeuhoehwozvoctducaqdvobavcugenkgqglonkbfouescjbxkkybdfuuptvxksbvgnbsiuhdsnzpdmzljkvsaqcygsqgdhjqqzhwvseqgvwzodpukmxdxtrvxykoitncbfltptvbruchlykdvtdnxzywnyzcarxdricfmvqdfxagydtmtcnbfszoovjyoyhxfardtorzjh";
        String id = "wovmfgefkqkacdjpstuilniuaqghvjtksxydxzkaqnkqzpvmpgqtoajroqmocauqlopckkmjjpwqoiskl";
        SALEvent item = this.testSendReceive((SALEvent)new LargeFileObjectAvailableEvent(priority, url, generator, version, byteSize, checkSum, mimeType, id));
        Assert.assertTrue((boolean)(item instanceof LargeFileObjectAvailableEvent));
        LargeFileObjectAvailableEvent item_ = (LargeFileObjectAvailableEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)url, (Object)item_.getUrl());
        Assert.assertEquals((Object)generator, (Object)item_.getGenerator());
        Assert.assertEquals((float)version, (float)item_.getVersion(), (float)1.0E-6f);
        Assert.assertEquals((long)byteSize, (long)item_.getByteSize());
        Assert.assertEquals((Object)checkSum, (Object)item_.getCheckSum());
        Assert.assertEquals((Object)mimeType, (Object)item_.getMimeType());
        Assert.assertEquals((Object)id, (Object)item_.getId());
    }
}

