package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_HeartbeatSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final long taskPeriodMillis;

  public Vacuum_HeartbeatSettingsAppliedEvent(int priority, int version, long taskPeriodMillis) {
    super (priority);
    this.version = version;
    this.taskPeriodMillis = taskPeriodMillis;
  }

  public int getVersion() {
    return version;
  }

  public long getTaskPeriodMillis() {
    return taskPeriodMillis;
  }

  @Override
  public String toString() {
    return "Vacuum_HeartbeatSettingsAppliedEvent{" + "version=" + version +
        ", taskPeriodMillis=" + taskPeriodMillis +"}";
  }
}
