package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;

public class ImageReadoutParametersEvent extends CameraEvent {
  private final String imageName;

  private final String ccdLocation;

  private final String raftBay;

  private final String ccdSlot;

  private final CcdType[] ccdType;

  private final int[] overRows;

  private final int[] overCols;

  private final int[] readRows;

  private final int[] readCols;

  private final int[] readCols2;

  private final int[] preCols;

  private final int[] preRows;

  private final int[] postCols;

  private final int[] underCols;

  private final String daqFolder;

  private final String daqAnnotation;

  public ImageReadoutParametersEvent(int priority, String imageName, String ccdLocation,
      String raftBay, String ccdSlot, CcdType[] ccdType, int[] overRows, int[] overCols,
      int[] readRows, int[] readCols, int[] readCols2, int[] preCols, int[] preRows, int[] postCols,
      int[] underCols, String daqFolder, String daqAnnotation) {
    super (priority);
    this.imageName = imageName;
    this.ccdLocation = ccdLocation;
    this.raftBay = raftBay;
    this.ccdSlot = ccdSlot;
    this.ccdType = ccdType;
    this.overRows = overRows;
    this.overCols = overCols;
    this.readRows = readRows;
    this.readCols = readCols;
    this.readCols2 = readCols2;
    this.preCols = preCols;
    this.preRows = preRows;
    this.postCols = postCols;
    this.underCols = underCols;
    this.daqFolder = daqFolder;
    this.daqAnnotation = daqAnnotation;
  }

  public String getImageName() {
    return imageName;
  }

  public String getCcdLocation() {
    return ccdLocation;
  }

  public String getRaftBay() {
    return raftBay;
  }

  public String getCcdSlot() {
    return ccdSlot;
  }

  public CcdType[] getCcdType() {
    return ccdType;
  }

  public int[] getOverRows() {
    return overRows;
  }

  public int[] getOverCols() {
    return overCols;
  }

  public int[] getReadRows() {
    return readRows;
  }

  public int[] getReadCols() {
    return readCols;
  }

  public int[] getReadCols2() {
    return readCols2;
  }

  public int[] getPreCols() {
    return preCols;
  }

  public int[] getPreRows() {
    return preRows;
  }

  public int[] getPostCols() {
    return postCols;
  }

  public int[] getUnderCols() {
    return underCols;
  }

  public String getDaqFolder() {
    return daqFolder;
  }

  public String getDaqAnnotation() {
    return daqAnnotation;
  }

  @Override
  public String toString() {
    return "ImageReadoutParametersEvent{" + "imageName=" + imageName +
        ", ccdLocation=" + ccdLocation +", raftBay=" + raftBay +", ccdSlot=" + ccdSlot +
        ", ccdType=" + Arrays.toString(ccdType) +", overRows=" + Arrays.toString(overRows) +
        ", overCols=" + Arrays.toString(overCols) +", readRows=" + Arrays.toString(readRows) +
        ", readCols=" + Arrays.toString(readCols) +", readCols2=" + Arrays.toString(readCols2) +
        ", preCols=" + Arrays.toString(preCols) +", preRows=" + Arrays.toString(preRows) +
        ", postCols=" + Arrays.toString(postCols) +", underCols=" + Arrays.toString(underCols) +
        ", daqFolder=" + daqFolder +", daqAnnotation=" + daqAnnotation +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public enum CcdType implements SALEnum {
    E2V,

    ITL
  }

  public static class Builder {
    private int priority;

    private String imageName;

    private String ccdLocation;

    private String raftBay;

    private String ccdSlot;

    private CcdType[] ccdType;

    private int[] overRows;

    private int[] overCols;

    private int[] readRows;

    private int[] readCols;

    private int[] readCols2;

    private int[] preCols;

    private int[] preRows;

    private int[] postCols;

    private int[] underCols;

    private String daqFolder;

    private String daqAnnotation;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder imageName(String imageName) {
      this.imageName = imageName;
      return this;
    }

    public Builder ccdLocation(String ccdLocation) {
      this.ccdLocation = ccdLocation;
      return this;
    }

    public Builder raftBay(String raftBay) {
      this.raftBay = raftBay;
      return this;
    }

    public Builder ccdSlot(String ccdSlot) {
      this.ccdSlot = ccdSlot;
      return this;
    }

    public Builder ccdType(CcdType[] ccdType) {
      this.ccdType = ccdType;
      return this;
    }

    public Builder overRows(int[] overRows) {
      this.overRows = overRows;
      return this;
    }

    public Builder overCols(int[] overCols) {
      this.overCols = overCols;
      return this;
    }

    public Builder readRows(int[] readRows) {
      this.readRows = readRows;
      return this;
    }

    public Builder readCols(int[] readCols) {
      this.readCols = readCols;
      return this;
    }

    public Builder readCols2(int[] readCols2) {
      this.readCols2 = readCols2;
      return this;
    }

    public Builder preCols(int[] preCols) {
      this.preCols = preCols;
      return this;
    }

    public Builder preRows(int[] preRows) {
      this.preRows = preRows;
      return this;
    }

    public Builder postCols(int[] postCols) {
      this.postCols = postCols;
      return this;
    }

    public Builder underCols(int[] underCols) {
      this.underCols = underCols;
      return this;
    }

    public Builder daqFolder(String daqFolder) {
      this.daqFolder = daqFolder;
      return this;
    }

    public Builder daqAnnotation(String daqAnnotation) {
      this.daqAnnotation = daqAnnotation;
      return this;
    }

    public ImageReadoutParametersEvent build() {
      return new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation);
    }
  }
}
