package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Focal_plane_SequencerConfig_DAQSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final String daqFolder;

  private final String daqPartition;

  private final boolean emulatedDAQ;

  public Focal_plane_SequencerConfig_DAQSettingsAppliedEvent(int priority, int version,
      String daqFolder, String daqPartition, boolean emulatedDAQ) {
    super (priority);
    this.version = version;
    this.daqFolder = daqFolder;
    this.daqPartition = daqPartition;
    this.emulatedDAQ = emulatedDAQ;
  }

  public int getVersion() {
    return version;
  }

  public String getDaqFolder() {
    return daqFolder;
  }

  public String getDaqPartition() {
    return daqPartition;
  }

  public boolean isEmulatedDAQ() {
    return emulatedDAQ;
  }

  @Override
  public String toString() {
    return "Focal_plane_SequencerConfig_DAQSettingsAppliedEvent{" + "version=" + version +
        ", daqFolder=" + daqFolder +", daqPartition=" + daqPartition +
        ", emulatedDAQ=" + emulatedDAQ +"}";
  }
}
