package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class EndOfImageTelemetryEvent extends CameraEvent {
  private final String additionalKeys;

  private final String additionalValues;

  private final int imagesInSequence;

  private final String imageName;

  private final int imageIndex;

  private final String imageSource;

  private final String imageController;

  private final String imageDate;

  private final int imageNumber;

  private final double timestampAcquisitionStart;

  private final double exposureTime;

  private final String imageTag;

  private final double timestampDateObs;

  private final double timestampDateEnd;

  private final double measuredShutterOpenTime;

  private final double darkTime;

  private final String emulatedImage;

  public EndOfImageTelemetryEvent(int priority, String additionalKeys, String additionalValues,
      int imagesInSequence, String imageName, int imageIndex, String imageSource,
      String imageController, String imageDate, int imageNumber, double timestampAcquisitionStart,
      double exposureTime, String imageTag, double timestampDateObs, double timestampDateEnd,
      double measuredShutterOpenTime, double darkTime, String emulatedImage) {
    super (priority);
    this.additionalKeys = additionalKeys;
    this.additionalValues = additionalValues;
    this.imagesInSequence = imagesInSequence;
    this.imageName = imageName;
    this.imageIndex = imageIndex;
    this.imageSource = imageSource;
    this.imageController = imageController;
    this.imageDate = imageDate;
    this.imageNumber = imageNumber;
    this.timestampAcquisitionStart = timestampAcquisitionStart;
    this.exposureTime = exposureTime;
    this.imageTag = imageTag;
    this.timestampDateObs = timestampDateObs;
    this.timestampDateEnd = timestampDateEnd;
    this.measuredShutterOpenTime = measuredShutterOpenTime;
    this.darkTime = darkTime;
    this.emulatedImage = emulatedImage;
  }

  public String getAdditionalKeys() {
    return additionalKeys;
  }

  public String getAdditionalValues() {
    return additionalValues;
  }

  public int getImagesInSequence() {
    return imagesInSequence;
  }

  public String getImageName() {
    return imageName;
  }

  public int getImageIndex() {
    return imageIndex;
  }

  public String getImageSource() {
    return imageSource;
  }

  public String getImageController() {
    return imageController;
  }

  public String getImageDate() {
    return imageDate;
  }

  public int getImageNumber() {
    return imageNumber;
  }

  public double getTimestampAcquisitionStart() {
    return timestampAcquisitionStart;
  }

  public double getExposureTime() {
    return exposureTime;
  }

  public String getImageTag() {
    return imageTag;
  }

  public double getTimestampDateObs() {
    return timestampDateObs;
  }

  public double getTimestampDateEnd() {
    return timestampDateEnd;
  }

  public double getMeasuredShutterOpenTime() {
    return measuredShutterOpenTime;
  }

  public double getDarkTime() {
    return darkTime;
  }

  public String getEmulatedImage() {
    return emulatedImage;
  }

  @Override
  public String toString() {
    return "EndOfImageTelemetryEvent{" + "additionalKeys=" + additionalKeys +
        ", additionalValues=" + additionalValues +", imagesInSequence=" + imagesInSequence +
        ", imageName=" + imageName +", imageIndex=" + imageIndex +", imageSource=" + imageSource +
        ", imageController=" + imageController +", imageDate=" + imageDate +
        ", imageNumber=" + imageNumber +", timestampAcquisitionStart=" + timestampAcquisitionStart +
        ", exposureTime=" + exposureTime +", imageTag=" + imageTag +
        ", timestampDateObs=" + timestampDateObs +", timestampDateEnd=" + timestampDateEnd +
        ", measuredShutterOpenTime=" + measuredShutterOpenTime +", darkTime=" + darkTime +
        ", emulatedImage=" + emulatedImage +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String additionalKeys;

    private String additionalValues;

    private int imagesInSequence;

    private String imageName;

    private int imageIndex;

    private String imageSource;

    private String imageController;

    private String imageDate;

    private int imageNumber;

    private double timestampAcquisitionStart;

    private double exposureTime;

    private String imageTag;

    private double timestampDateObs;

    private double timestampDateEnd;

    private double measuredShutterOpenTime;

    private double darkTime;

    private String emulatedImage;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder additionalKeys(String additionalKeys) {
      this.additionalKeys = additionalKeys;
      return this;
    }

    public Builder additionalValues(String additionalValues) {
      this.additionalValues = additionalValues;
      return this;
    }

    public Builder imagesInSequence(int imagesInSequence) {
      this.imagesInSequence = imagesInSequence;
      return this;
    }

    public Builder imageName(String imageName) {
      this.imageName = imageName;
      return this;
    }

    public Builder imageIndex(int imageIndex) {
      this.imageIndex = imageIndex;
      return this;
    }

    public Builder imageSource(String imageSource) {
      this.imageSource = imageSource;
      return this;
    }

    public Builder imageController(String imageController) {
      this.imageController = imageController;
      return this;
    }

    public Builder imageDate(String imageDate) {
      this.imageDate = imageDate;
      return this;
    }

    public Builder imageNumber(int imageNumber) {
      this.imageNumber = imageNumber;
      return this;
    }

    public Builder timestampAcquisitionStart(double timestampAcquisitionStart) {
      this.timestampAcquisitionStart = timestampAcquisitionStart;
      return this;
    }

    public Builder exposureTime(double exposureTime) {
      this.exposureTime = exposureTime;
      return this;
    }

    public Builder imageTag(String imageTag) {
      this.imageTag = imageTag;
      return this;
    }

    public Builder timestampDateObs(double timestampDateObs) {
      this.timestampDateObs = timestampDateObs;
      return this;
    }

    public Builder timestampDateEnd(double timestampDateEnd) {
      this.timestampDateEnd = timestampDateEnd;
      return this;
    }

    public Builder measuredShutterOpenTime(double measuredShutterOpenTime) {
      this.measuredShutterOpenTime = measuredShutterOpenTime;
      return this;
    }

    public Builder darkTime(double darkTime) {
      this.darkTime = darkTime;
      return this;
    }

    public Builder emulatedImage(String emulatedImage) {
      this.emulatedImage = emulatedImage;
      return this;
    }

    public EndOfImageTelemetryEvent build() {
      return new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage);
    }
  }
}
