package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class ConfigurationAppliedEvent extends CameraEvent {
  private final String configurations;

  private final String version;

  private final String url;

  private final String schemaVersion;

  private final String otherInfo;

  public ConfigurationAppliedEvent(int priority, String configurations, String version, String url,
      String schemaVersion, String otherInfo) {
    super (priority);
    this.configurations = configurations;
    this.version = version;
    this.url = url;
    this.schemaVersion = schemaVersion;
    this.otherInfo = otherInfo;
  }

  public String getConfigurations() {
    return configurations;
  }

  public String getVersion() {
    return version;
  }

  public String getUrl() {
    return url;
  }

  public String getSchemaVersion() {
    return schemaVersion;
  }

  public String getOtherInfo() {
    return otherInfo;
  }

  @Override
  public String toString() {
    return "ConfigurationAppliedEvent{" + "configurations=" + configurations +
        ", version=" + version +", url=" + url +", schemaVersion=" + schemaVersion +
        ", otherInfo=" + otherInfo +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int priority;

    private String configurations;

    private String version;

    private String url;

    private String schemaVersion;

    private String otherInfo;

    private Builder() {
    }

    public Builder priority(int priority) {
      this.priority = priority;
      return this;
    }

    public Builder configurations(String configurations) {
      this.configurations = configurations;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    public Builder url(String url) {
      this.url = url;
      return this;
    }

    public Builder schemaVersion(String schemaVersion) {
      this.schemaVersion = schemaVersion;
      return this;
    }

    public Builder otherInfo(String otherInfo) {
      this.otherInfo = otherInfo;
      return this;
    }

    public ConfigurationAppliedEvent build() {
      return new ConfigurationAppliedEvent(priority, configurations, version, url, schemaVersion, otherInfo);
    }
  }
}
