package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class CalibrationDetailedStateEvent extends CameraStateChangeEvent {
  private final CalibrationState substate;

  public CalibrationDetailedStateEvent(int priority, CalibrationState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public CalibrationState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "CalibrationDetailedStateEvent{" + "substate=" + substate +"}";
  }

  public enum CalibrationState implements SALEnum {
    DISABLED,

    ENABLED,

    INTEGRATING
  }
}
