package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class Vacuum_ForelineVacGaugeSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final int busAddr;

  private final String devcId;

  public Vacuum_ForelineVacGaugeSettingsAppliedEvent(int priority, int version, int busAddr,
      String devcId) {
    super (priority);
    this.version = version;
    this.busAddr = busAddr;
    this.devcId = devcId;
  }

  public int getVersion() {
    return version;
  }

  public int getBusAddr() {
    return busAddr;
  }

  public String getDevcId() {
    return devcId;
  }

  @Override
  public String toString() {
    return "Vacuum_ForelineVacGaugeSettingsAppliedEvent{" + "version=" + version +
        ", busAddr=" + busAddr +", devcId=" + devcId +"}";
  }
}
