package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class RebpowerSettingsAppliedEvent extends CameraEvent {
  private final int version;

  private final long powerOffSleepMillis;

  public RebpowerSettingsAppliedEvent(int priority, int version, long powerOffSleepMillis) {
    super (priority);
    this.version = version;
    this.powerOffSleepMillis = powerOffSleepMillis;
  }

  public int getVersion() {
    return version;
  }

  public long getPowerOffSleepMillis() {
    return powerOffSleepMillis;
  }

  @Override
  public String toString() {
    return "RebpowerSettingsAppliedEvent{" + "version=" + version +
        ", powerOffSleepMillis=" + powerOffSleepMillis +"}";
  }
}
