package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_24VDTelemetry extends CameraTelemetry {
  private final double n_24vd_Board_T;

  private final double n_24vd_FPGA_T;

  private final double n_24vd_Main_I;

  private final double n_24vd_Main_T;

  private final double n_24vd_Main_V;

  private final double cryo_Turbo_I;

  private final double cryo_Turbo_V;

  private final double hex_Turbo_I;

  private final double hex_Turbo_V;

  public Quadbox_PDU_24VDTelemetry(double n_24vd_Board_T, double n_24vd_FPGA_T,
      double n_24vd_Main_I, double n_24vd_Main_T, double n_24vd_Main_V, double cryo_Turbo_I,
      double cryo_Turbo_V, double hex_Turbo_I, double hex_Turbo_V) {
    this.n_24vd_Board_T = n_24vd_Board_T;
    this.n_24vd_FPGA_T = n_24vd_FPGA_T;
    this.n_24vd_Main_I = n_24vd_Main_I;
    this.n_24vd_Main_T = n_24vd_Main_T;
    this.n_24vd_Main_V = n_24vd_Main_V;
    this.cryo_Turbo_I = cryo_Turbo_I;
    this.cryo_Turbo_V = cryo_Turbo_V;
    this.hex_Turbo_I = hex_Turbo_I;
    this.hex_Turbo_V = hex_Turbo_V;
  }

  public double getN_24vd_Board_T() {
    return n_24vd_Board_T;
  }

  public double getN_24vd_FPGA_T() {
    return n_24vd_FPGA_T;
  }

  public double getN_24vd_Main_I() {
    return n_24vd_Main_I;
  }

  public double getN_24vd_Main_T() {
    return n_24vd_Main_T;
  }

  public double getN_24vd_Main_V() {
    return n_24vd_Main_V;
  }

  public double getCryo_Turbo_I() {
    return cryo_Turbo_I;
  }

  public double getCryo_Turbo_V() {
    return cryo_Turbo_V;
  }

  public double getHex_Turbo_I() {
    return hex_Turbo_I;
  }

  public double getHex_Turbo_V() {
    return hex_Turbo_V;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_24VDTelemetry{" + "n_24vd_Board_T=" + n_24vd_Board_T +
        ", n_24vd_FPGA_T=" + n_24vd_FPGA_T +", n_24vd_Main_I=" + n_24vd_Main_I +
        ", n_24vd_Main_T=" + n_24vd_Main_T +", n_24vd_Main_V=" + n_24vd_Main_V +
        ", cryo_Turbo_I=" + cryo_Turbo_I +", cryo_Turbo_V=" + cryo_Turbo_V +
        ", hex_Turbo_I=" + hex_Turbo_I +", hex_Turbo_V=" + hex_Turbo_V +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double n_24vd_Board_T;

    private double n_24vd_FPGA_T;

    private double n_24vd_Main_I;

    private double n_24vd_Main_T;

    private double n_24vd_Main_V;

    private double cryo_Turbo_I;

    private double cryo_Turbo_V;

    private double hex_Turbo_I;

    private double hex_Turbo_V;

    private Builder() {
    }

    public Builder n_24vd_Board_T(double n_24vd_Board_T) {
      this.n_24vd_Board_T = n_24vd_Board_T;
      return this;
    }

    public Builder n_24vd_FPGA_T(double n_24vd_FPGA_T) {
      this.n_24vd_FPGA_T = n_24vd_FPGA_T;
      return this;
    }

    public Builder n_24vd_Main_I(double n_24vd_Main_I) {
      this.n_24vd_Main_I = n_24vd_Main_I;
      return this;
    }

    public Builder n_24vd_Main_T(double n_24vd_Main_T) {
      this.n_24vd_Main_T = n_24vd_Main_T;
      return this;
    }

    public Builder n_24vd_Main_V(double n_24vd_Main_V) {
      this.n_24vd_Main_V = n_24vd_Main_V;
      return this;
    }

    public Builder cryo_Turbo_I(double cryo_Turbo_I) {
      this.cryo_Turbo_I = cryo_Turbo_I;
      return this;
    }

    public Builder cryo_Turbo_V(double cryo_Turbo_V) {
      this.cryo_Turbo_V = cryo_Turbo_V;
      return this;
    }

    public Builder hex_Turbo_I(double hex_Turbo_I) {
      this.hex_Turbo_I = hex_Turbo_I;
      return this;
    }

    public Builder hex_Turbo_V(double hex_Turbo_V) {
      this.hex_Turbo_V = hex_Turbo_V;
      return this;
    }

    public Quadbox_PDU_24VDTelemetry build() {
      return new Quadbox_PDU_24VDTelemetry(n_24vd_Board_T, n_24vd_FPGA_T, n_24vd_Main_I, n_24vd_Main_T, n_24vd_Main_V, cryo_Turbo_I, cryo_Turbo_V, hex_Turbo_I, hex_Turbo_V);
    }
  }
}
