package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class SetLogLevelCommand extends CameraCommand {
  private final int level;

  private final String subsystem;

  public SetLogLevelCommand(int level, String subsystem) {
    this.level = level;
    this.subsystem = subsystem;
  }

  public int getLevel() {
    return level;
  }

  public String getSubsystem() {
    return subsystem;
  }

  @Override
  public String toString() {
    return "SetLogLevelCommand{" + "level=" + level +", subsystem=" + subsystem +"}";
  }
}
