/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 495;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 74;
        String imageName = "irsmhnddyrhmpolaa";
        int imageIndex = 337;
        String imageSource = "";
        String imageController = "g";
        String imageDate = "ejj";
        int imageNumber = 172;
        double timestampAcquisitionStart = 0.4246455430984497;
        double requestedExposureTime = 0.9393898248672485;
        double timestampEndOfReadout = 0.9142882227897644;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, requestedExposureTime, timestampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)requestedExposureTime, (double)item_.getRequestedExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampEndOfReadout, (double)item_.getTimestampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 794;
        double timestampTransition = 0.7368072867393494;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 796;
        String filterName = "";
        String filterType = "w";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName, filterType));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 588;
        double timestampTransition = 0.942844569683075;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 783;
        double timestampTransition = 0.86098313331604;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 27;
        double timestampTransition = 0.5015073418617249;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 231;
        double timestampTransition = 0.354770302772522;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 675;
        double timestampTransition = 0.8005862236022949;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 648;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 787;
        String imageName = "anwcangdisqfvxuqwqysi";
        int imageIndex = 184;
        String imageSource = "";
        String imageController = "m";
        String imageDate = "yjrzx";
        int imageNumber = 796;
        double timestampAcquisitionStart = 0.8657287359237671;
        double exposureTime = 0.4734336733818054;
        String imageTag = "namoaezfanauhnnootuhjusprpmldiutxsqcaageu";
        double timestampDateObs = 0.6832115650177002;
        double timestampDateEnd = 0.3940030336380005;
        double measuredShutterOpenTime = 0.46446192264556885;
        double darkTime = 0.6667547225952148;
        String emulatedImage = "u";
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, measuredShutterOpenTime, darkTime, emulatedImage));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)measuredShutterOpenTime, (double)item_.getMeasuredShutterOpenTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)emulatedImage, (Object)item_.getEmulatedImage());
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 498;
        double timestampTransition = 0.2241965f;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 270;
        double timestampTransition = 0.3308407f;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 835;
        double timestampTransition = 0.19930672645568848;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 163;
        double timestampTransition = 0.29876023530960083;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 21;
        double timestampTransition = 0.9616172313690186;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 267;
        double timestampTransition = 0.5977584719657898;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 128;
        double timestampTransition = 0.5300258994102478;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 521;
        double timestampTransition = 0.761646032333374;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 452;
        String additionalKeys = "j";
        String additionalValues = "k";
        int imagesInSequence = 56;
        String imageName = "wrpjmwrtkaigzuaqyzmyymnpodo";
        int imageIndex = 165;
        String imageSource = "y";
        String imageController = "";
        String imageDate = "ggilkxlh";
        int imageNumber = 598;
        double timestampAcquisitionStart = 0.3579188585281372;
        double exposureTime = 0.05984848737716675;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 720;
        double timestampTransition = 0.25452548265457153;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 404;
        String filterName = "";
        String filterType = "u";
        int filterSlot = 140;
        double filterPosition = 0.4018269181251526;
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName, filterType, filterSlot, filterPosition));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
        Assert.assertEquals((Object)filterType, (Object)item_.getFilterType());
        Assert.assertEquals((long)filterSlot, (long)item_.getFilterSlot());
        Assert.assertEquals((double)filterPosition, (double)item_.getFilterPosition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 625;
        double timestampTransition = 0.290006160736084;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 231;
        String filterNames = "hzqoveaoljumwxnuioao";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 587;
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 423;
        String imageName = "nqofqitxyuovvua";
        int imageIndex = 241;
        String imageSource = "";
        String imageController = "";
        String imageDate = "kzc";
        int imageNumber = 404;
        double timestampAcquisitionStart = 0.40720945596694946;
        double exposureTime = 0.08686012029647827;
        double timestampStartOfReadout = 0.6933475732803345;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timestampAcquisitionStart, exposureTime, timestampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timestampAcquisitionStart, (double)item_.getTimestampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampStartOfReadout, (double)item_.getTimestampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 649;
        double timestampTransition = 0.671680748462677;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority, timestampTransition));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((double)timestampTransition, (double)item_.getTimestampTransition(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 754;
        String imageName = "b";
        String ccdLocation = "l";
        String raftBay = "";
        String ccdSlot = "t";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = new int[]{743, 788, 434, 291, 638, 127, 852, 378, 652, 186, 947, 281, 691, 84, 12, 881, 910, 770, 293, 275, 187, 202, 216, 849, 20, 965, 398, 848, 356, 72, 943, 669, 302, 560, 485, 873, 705, 495, 264, 58, 201, 271, 604, 759, 767, 498, 398, 95, 584, 756, 662, 135, 859, 677, 215, 255, 979, 711, 529, 351, 900, 496, 0, 619, 931, 700, 301, 216, 566, 611, 786, 306, 419, 330, 891, 523, 413, 905, 736, 258, 960, 545, 71, 358, 526, 815, 94, 934, 434, 617, 630, 46, 449, 971, 43, 968, 480, 678, 128, 596, 121, 535, 591, 309, 439, 528, 726, 458, 729, 261, 517, 78, 300, 316, 732, 229, 760, 986, 106, 435, 996, 254, 336, 114, 390, 421, 563, 463, 219, 25, 248, 786, 492, 926, 899, 529, 977, 371, 824, 912, 184, 561, 178, 630, 614, 324, 185, 367, 262, 138, 166, 418, 759, 84, 451, 982, 983, 193, 853, 662, 750, 801, 795, 285, 149, 989, 81, 688, 637, 713, 453, 79, 908, 18, 346, 640, 571, 770, 362, 816, 963, 373, 143, 22, 533, 39, 690, 798, 312, 332, 581, 351, 821, 59, 764, 954, 799, 664, 533, 391, 671};
        int[] overCols = new int[]{676, 440, 478, 3, 340, 962, 86, 14, 619, 68, 333, 427, 605, 880, 253, 235, 553, 355, 719, 230, 441, 318, 679, 846, 89, 63, 348, 159, 874, 956, 722, 738, 242, 263, 694, 337, 178, 261, 133, 237, 380, 289, 625, 74, 622, 134, 962, 181, 615, 105, 277, 692, 813, 84, 219, 251, 913, 951, 512, 735, 600, 106, 485, 11, 870, 797, 525, 704, 681, 800, 202, 402, 519, 630, 865, 757, 341, 708, 144, 102, 22, 32, 802, 30, 868, 197, 509, 321, 254, 810, 177, 653, 21, 122, 540, 94, 133, 446, 206, 894, 269, 526, 839, 538, 746, 280, 448, 751, 342, 855, 949, 667, 129, 708, 804, 617, 249, 298, 706, 444, 164, 523, 251, 916, 655, 808, 299, 119, 625, 638, 270, 294, 401, 764, 89, 624, 32, 393, 715, 397, 309, 522, 771, 424, 388, 529, 175, 576, 10, 417, 598, 848, 79, 670, 235, 585, 208, 842, 38, 769, 239, 993, 496, 869, 682, 374, 476, 490, 557, 366, 525, 265, 565, 106, 583, 249, 267, 515, 222, 127, 800, 670, 429, 224, 819, 927, 868, 927, 780, 41, 185, 73, 772, 155, 81, 269, 956, 583, 371, 970, 582};
        int[] readRows = new int[]{172, 314, 161, 235, 811, 53, 106, 546, 982, 69, 330, 210, 396, 554, 361, 76, 554, 594, 946, 784, 811, 775, 235, 187, 112, 68, 668, 274, 51, 332, 413, 941, 341, 711, 112, 427, 568, 25, 478, 757, 558, 177, 702, 402, 480, 627, 847, 791, 811, 834, 534, 392, 348, 774, 123, 920, 308, 941, 430, 81, 143, 410, 503, 880, 791, 463, 899, 928, 693, 255, 650, 1, 663, 453, 454, 549, 917, 483, 950, 479, 630, 848, 720, 632, 15, 376, 501, 727, 3, 17, 93, 988, 839, 600, 780, 802, 220, 798, 997, 815, 679, 859, 770, 201, 797, 205, 30, 974, 344, 909, 49, 632, 215, 54, 931, 787, 81, 419, 620, 388, 890, 163, 311, 992, 206, 156, 719, 655, 242, 929, 986, 147, 202, 369, 298, 89, 237, 798, 786, 330, 684, 6, 358, 422, 378, 522, 595, 262, 382, 657, 93, 900, 435, 560, 631, 929, 512, 328, 973, 235, 619, 100, 614, 705, 673, 685, 646, 277, 481, 316, 503, 541, 54, 427, 951, 237, 379, 40, 476, 988, 48, 135, 700, 705, 483, 787, 290, 203, 786, 89, 410, 234, 517, 370, 918, 629, 769, 746, 257, 113, 222};
        int[] readCols = new int[]{297, 96, 130, 674, 670, 161, 465, 686, 467, 331, 298, 998, 793, 197, 105, 46, 65, 258, 217, 536, 875, 314, 97, 634, 647, 461, 987, 277, 806, 120, 865, 712, 3, 921, 614, 146, 796, 447, 407, 999, 799, 243, 100, 2, 219, 635, 663, 648, 4, 133, 784, 397, 10, 441, 562, 56, 455, 223, 542, 89, 659, 719, 98, 484, 102, 647, 925, 749, 249, 687, 193, 730, 793, 168, 110, 704, 865, 867, 607, 806, 867, 799, 531, 406, 98, 586, 539, 394, 599, 904, 27, 219, 591, 121, 374, 396, 717, 109, 546, 677, 41, 179, 373, 507, 892, 455, 979, 629, 719, 857, 989, 2, 791, 522, 120, 846, 799, 842, 551, 644, 915, 933, 685, 788, 404, 916, 395, 517, 772, 511, 202, 654, 864, 368, 966, 247, 789, 147, 704, 133, 720, 697, 22, 378, 422, 12, 736, 314, 277, 589, 458, 169, 269, 297, 25, 163, 391, 114, 628, 36, 584, 554, 329, 557, 393, 394, 184, 616, 679, 448, 704, 347, 818, 319, 580, 336, 804, 184, 938, 61, 976, 711, 216, 327, 892, 616, 11, 698, 388, 960, 205, 411, 692, 368, 562, 46, 226, 244, 48, 643, 574};
        int[] readCols2 = new int[]{154, 592, 67, 527, 502, 885, 217, 188, 723, 360, 964, 771, 195, 501, 345, 353, 335, 998, 981, 431, 522, 426, 447, 757, 383, 418, 860, 414, 500, 56, 309, 367, 878, 724, 875, 781, 43, 644, 762, 538, 943, 239, 363, 44, 774, 22, 603, 698, 377, 407, 49, 652, 723, 472, 13, 934, 291, 821, 364, 224, 28, 126, 688, 597, 719, 863, 716, 518, 162, 781, 61, 763, 674, 338, 116, 533, 724, 398, 113, 187, 698, 602, 569, 790, 697, 17, 679, 19, 886, 174, 977, 261, 401, 988, 913, 677, 25, 558, 556, 975, 71, 516, 64, 698, 919, 206, 406, 819, 873, 376, 751, 110, 414, 395, 282, 947, 502, 523, 11, 609, 70, 562, 688, 642, 190, 264, 445, 522, 825, 813, 895, 420, 134, 85, 381, 595, 947, 319, 227, 827, 769, 674, 208, 690, 474, 109, 944, 822, 759, 313, 660, 251, 422, 100, 748, 697, 521, 885, 270, 768, 714, 471, 352, 233, 426, 869, 666, 883, 809, 904, 39, 303, 943, 800, 898, 648, 497, 676, 766, 322, 831, 735, 277, 854, 531, 234, 322, 623, 500, 656, 898, 732, 288, 249, 772, 618, 760, 807, 218, 782, 933};
        int[] preCols = new int[]{879, 463, 324, 448, 628, 432, 206, 31, 590, 824, 68, 36, 297, 532, 565, 951, 54, 149, 120, 964, 995, 683, 673, 383, 591, 742, 291, 588, 406, 808, 430, 259, 773, 367, 534, 80, 3, 127, 584, 697, 421, 667, 321, 808, 756, 827, 596, 216, 524, 402, 160, 637, 340, 303, 860, 44, 949, 931, 168, 721, 560, 810, 113, 280, 57, 522, 296, 171, 162, 321, 329, 914, 421, 371, 395, 784, 770, 184, 888, 826, 65, 540, 98, 122, 261, 912, 400, 2, 758, 191, 140, 637, 248, 635, 923, 975, 37, 77, 232, 292, 884, 355, 805, 630, 580, 259, 151, 192, 345, 934, 180, 991, 521, 136, 84, 849, 540, 340, 58, 997, 78, 884, 21, 58, 939, 86, 703, 580, 397, 819, 129, 897, 525, 729, 449, 297, 348, 128, 433, 804, 468, 761, 277, 253, 784, 937, 289, 548, 180, 486, 596, 906, 874, 521, 237, 549, 395, 601, 969, 915, 135, 89, 182, 36, 369, 87, 296, 128, 641, 965, 413, 255, 663, 260, 606, 607, 321, 532, 436, 40, 153, 585, 349, 188, 830, 664, 626, 146, 310, 935, 390, 953, 309, 186, 149, 73, 732, 33, 814, 246, 753};
        int[] preRows = new int[]{639, 943, 630, 446, 605, 83, 506, 953, 325, 27, 145, 88, 387, 774, 775, 878, 557, 622, 812, 102, 92, 73, 817, 955, 594, 48, 606, 994, 363, 528, 951, 885, 729, 626, 597, 693, 559, 921, 16, 715, 279, 928, 714, 555, 895, 133, 111, 429, 213, 30, 657, 305, 164, 359, 855, 519, 127, 613, 189, 424, 538, 961, 399, 604, 624, 28, 272, 969, 414, 684, 151, 140, 158, 832, 920, 784, 433, 502, 521, 264, 28, 62, 603, 2, 243, 587, 88, 35, 643, 990, 332, 169, 272, 62, 579, 904, 703, 600, 578, 708, 870, 638, 762, 272, 592, 79, 479, 673, 52, 308, 656, 827, 749, 842, 895, 798, 949, 961, 487, 75, 746, 600, 477, 521, 202, 834, 462, 550, 659, 969, 40, 716, 539, 765, 902, 43, 150, 529, 187, 292, 430, 99, 216, 177, 29, 590, 872, 7, 734, 574, 688, 669, 705, 487, 252, 924, 189, 522, 453, 34, 31, 428, 662, 812, 393, 653, 638, 144, 918, 618, 168, 916, 218, 592, 765, 591, 31, 566, 636, 618, 914, 157, 776, 571, 531, 231, 231, 142, 227, 745, 954, 391, 584, 726, 648, 496, 76, 697, 910, 683, 948};
        int[] postCols = new int[]{462, 249, 366, 196, 598, 916, 873, 456, 230, 757, 68, 197, 123, 849, 993, 917, 243, 784, 467, 761, 963, 939, 50, 10, 929, 914, 876, 272, 893, 378, 378, 555, 385, 811, 716, 512, 530, 736, 778, 843, 89, 696, 952, 107, 923, 257, 260, 51, 89, 804, 848, 548, 781, 931, 238, 656, 482, 271, 685, 937, 934, 847, 599, 448, 847, 834, 68, 18, 430, 822, 927, 532, 301, 25, 442, 720, 329, 836, 808, 344, 836, 871, 295, 918, 914, 399, 369, 102, 629, 572, 21, 883, 951, 552, 903, 990, 907, 642, 40, 934, 345, 352, 587, 145, 844, 187, 638, 312, 754, 940, 521, 208, 615, 341, 326, 301, 70, 506, 925, 481, 30, 117, 706, 114, 100, 321, 749, 946, 923, 143, 510, 312, 805, 108, 763, 828, 620, 420, 976, 191, 249, 487, 594, 280, 736, 177, 272, 435, 494, 624, 30, 925, 560, 78, 23, 794, 554, 486, 958, 879, 185, 244, 1, 772, 358, 469, 875, 673, 767, 966, 629, 737, 955, 304, 144, 932, 593, 296, 865, 198, 182, 501, 985, 645, 489, 371, 296, 336, 37, 780, 342, 570, 258, 806, 446, 910, 160, 672, 559, 605, 442};
        int[] underCols = new int[]{990, 551, 274, 707, 212, 806, 47, 487, 710, 269, 417, 112, 190, 666, 733, 484, 415, 505, 934, 895, 574, 904, 975, 683, 25, 599, 698, 16, 215, 466, 971, 633, 359, 876, 559, 669, 45, 914, 438, 830, 999, 865, 55, 450, 390, 189, 115, 812, 879, 919, 337, 351, 161, 865, 369, 542, 225, 289, 780, 482, 193, 777, 368, 672, 791, 247, 226, 958, 889, 14, 116, 259, 599, 127, 630, 56, 201, 605, 288, 559, 663, 636, 725, 406, 727, 181, 980, 344, 489, 209, 296, 248, 807, 599, 168, 843, 440, 964, 432, 937, 547, 374, 446, 711, 993, 725, 49, 613, 123, 398, 802, 439, 275, 390, 807, 938, 910, 87, 509, 765, 238, 242, 603, 873, 294, 601, 982, 38, 151, 903, 46, 27, 96, 127, 375, 785, 722, 6, 923, 829, 281, 70, 109, 633, 222, 848, 321, 262, 857, 940, 431, 408, 292, 688, 391, 558, 923, 123, 70, 988, 688, 61, 566, 959, 803, 45, 732, 108, 478, 294, 770, 957, 950, 519, 37, 513, 485, 582, 185, 711, 813, 208, 488, 375, 639, 319, 313, 45, 377, 760, 389, 475, 494, 760, 117, 657, 240, 955, 192, 804, 481};
        String daqFolder = "t";
        String daqAnnotation = "m";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveFocalPlaneSummaryInfoEvent() throws Exception {
        int priority = 110;
        String ccdLocation = "";
        String raftBay = "y";
        String ccdSlot = "t";
        String rebSerialNumber = "b";
        String rebLSSTName = "";
        String ccdLSSTName = "t";
        String raftLSSTName = "t";
        String ccdManSerNum = "";
        String ccdManufacturer = "";
        Object[] ccdType = new FocalPlaneSummaryInfoEvent.CcdType[]{FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.E2V, FocalPlaneSummaryInfoEvent.CcdType.ITL};
        double[] ccdTempSetPoint = new double[]{0.03770667314529419, 0.2436668872833252, 0.35733717679977417, 0.6375284790992737, 0.9946182370185852, 0.3443509340286255, 0.8494451642036438, 0.7361348271369934, 0.4846060276031494, 0.9953231811523438, 0.08402401208877563, 0.3612545132637024, 0.6111468076705933, 0.046657443046569824, 0.7034997344017029, 0.6944841146469116, 0.4423891305923462, 0.8195973038673401, 0.8911446928977966, 0.9449220299720764, 0.3727429509162903, 0.3365599f, 0.2162773609161377, 0.08686792850494385, 0.5236115455627441, 0.11660957336425781, 0.6386212110519409, 0.5465096235275269, 0.8977733850479126, 0.7412078380584717, 0.33134692907333374, 0.14201372861862183, 0.4168702960014343, 0.9587225317955017, 0.8275997042655945, 0.7852810621261597, 0.6418435573577881, 0.3457095f, 0.5672187209129333, 0.45319098234176636, 0.09826427698135376, 0.37387335300445557, 0.3292325735092163, 0.2597543001174927, 0.7892430424690247, 0.11749368906021118, 0.9075458645820618, 0.839673f, 0.905518651008606, 0.07874f, 0.1136139f, 0.8729338049888611, 0.5535796880722046, 0.587564f, 0.17806684970855713, 0.32693952322006226, 0.7770497798919678, 0.6567665934562683, 0.5460378527641296, 0.7081224322319031, 0.3934918f, 0.8275190591812134, 0.10685265064239502, 0.3429415225982666, 0.4982871413230896, 0.5403322577476501, 0.02185011f, 0.9457008838653564, 0.5799921751022339, 0.6035947203636169, 0.4841491f, 0.67794269323349, 0.3688562512397766, 0.9268537759780884, 0.1965157389640808, 0.7145811319351196, 0.01391238f, 0.43761688470840454, 0.8390809297561646, 0.36190032958984375, 0.3067666292190552, 0.9353718161582947, 0.8341261148452759, 0.8316114544868469, 0.1850796341896057, 0.059637486934661865, 0.832711398601532, 0.37604063749313354, 0.03953767f, 0.8931769132614136, 0.34542137384414673, 0.09803193807601929, 0.6892715096473694, 0.398157000541687, 0.13042718172073364, 0.034231483936309814, 0.6972344517707825, 0.631290853023529, 0.4155048727989197, 0.19414716958999634, 0.7746595144271851, 0.8212222456932068, 0.8613449335098267, 0.944949209690094, 0.8186742067337036, 0.0631251335144043, 0.731778f, 0.24170565605163574, 0.976365327835083, 0.8153178691864014, 0.8984127044677734, 0.6960815787315369, 0.5096038579940796, 0.12239694595336914, 0.7142266035079956, 0.7880451679229736, 0.015918374061584473, 0.668856680393219, 0.10010641813278198, 0.7925052046775818, 0.25043708086013794, 0.344391405582428, 0.32303881645202637, 0.3068814277648926, 0.7918167114257812, 0.01320219f, 0.3430965542793274, 0.9203203916549683, 0.6411802172660828, 0.9889153242111206, 0.4726397395133972, 0.3076918125152588, 0.4680584f, 0.26654428243637085, 0.6449887752532959, 0.31182122230529785, 0.19246304035186768, 0.6237963438034058, 0.3165757f, 0.7989621162414551, 0.37942272424697876, 0.12457782030105591, 0.9272174835205078, 0.8417255282402039, 0.12413114309310913, 0.5145398378372192, 0.6842864155769348, 0.16013747453689575, 0.7154470682144165, 0.24681884050369263, 3.97861E-4f, 0.4978829026222229, 0.016645967960357666, 0.9987613558769226, 0.24865102767944336, 0.44293713569641113, 0.71945720911026, 0.1985260248184204, 0.16791987419128418, 0.03862518072128296, 0.07557564973831177, 0.26327353715896606, 0.5822992920875549, 0.7447644472122192, 0.44467437267303467, 0.525576114654541, 0.43829184770584106, 0.9741195440292358, 0.7157511115074158, 0.5872114896774292, 0.12102806568145752, 0.5752629637718201, 0.9463352560997009, 0.5632772445678711, 0.7127206921577454, 0.4905286431312561, 0.14919966459274292, 0.16633951663970947, 0.19426536560058594, 0.071639f, 0.1569261f, 0.20998424291610718, 0.47163963317871094, 0.5734783411026001, 0.6697577834129333, 0.0916903018951416, 0.7053773999214172, 0.5091942548751831, 0.591046f, 0.4325159788131714, 0.4223732352256775, 0.38127797842025757, 0.36730343103408813, 0.9199444651603699, 0.7487133145332336, 0.8005784153938293, 0.4570775032043457, 0.7127537727355957, 0.2898542284965515, 0.8685352206230164, 0.07583820819854736, 0.5434670448303223, 0.4356348514556885, 0.5805953741073608, 0.7147592306137085, 0.9934367537498474, 0.4332842230796814, 0.767250120639801, 0.4621874f, 0.7446750998497009, 0.46838104724884033, 0.03296506404876709};
        String sequencerKey = "";
        String sequencerChecksum = "l";
        SALEvent item = this.testSendReceive((SALEvent)new FocalPlaneSummaryInfoEvent(priority, ccdLocation, raftBay, ccdSlot, rebSerialNumber, rebLSSTName, ccdLSSTName, raftLSSTName, ccdManSerNum, ccdManufacturer, (FocalPlaneSummaryInfoEvent.CcdType[])ccdType, ccdTempSetPoint, sequencerKey, sequencerChecksum));
        Assert.assertTrue((boolean)(item instanceof FocalPlaneSummaryInfoEvent));
        FocalPlaneSummaryInfoEvent item_ = (FocalPlaneSummaryInfoEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertEquals((Object)rebSerialNumber, (Object)item_.getRebSerialNumber());
        Assert.assertEquals((Object)rebLSSTName, (Object)item_.getRebLSSTName());
        Assert.assertEquals((Object)ccdLSSTName, (Object)item_.getCcdLSSTName());
        Assert.assertEquals((Object)raftLSSTName, (Object)item_.getRaftLSSTName());
        Assert.assertEquals((Object)ccdManSerNum, (Object)item_.getCcdManSerNum());
        Assert.assertEquals((Object)ccdManufacturer, (Object)item_.getCcdManufacturer());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((double[])ccdTempSetPoint, (double[])item_.getCcdTempSetPoint(), (double)1.0E-6f);
        Assert.assertEquals((Object)sequencerKey, (Object)item_.getSequencerKey());
        Assert.assertEquals((Object)sequencerChecksum, (Object)item_.getSequencerChecksum());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 402;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "z";
        String settingsUrl = "t";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 614;
        int errorCode = 242;
        String errorReport = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 626;
        boolean appliedSettingsMatchStartIsTrue = true;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 419;
        int level = 2;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 821;
        String name = "x";
        int level = 278;
        String message = "";
        String traceback = "";
        String filePath = "w";
        String functionName = "d";
        int lineNumber = 138;
        int process = 695;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 920;
        String settingsVersion = "fshqoqmubaqjgvonhclnycssainytyqauucnsfckvdpshelccrmtoirzxqyoopzziiswvnrfolwdtagkeleuhhbztttdrsfjbgqdfsneofxskfdzvsqrtwmkxgioicdkgcpziuossdxmcxmlcxrosfkxcodszzakszruqckzqjtwiovgnykacsgwxhlgvhxrnqlwqlejqqincqyaheyukoixjxrfi";
        String otherSettingsEvents = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 228;
        int mode = 411;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 597;
        String salVersion = "gewpomwrufkjqfrgndwfaycrneiehwmdnkemwkgpehebirroscmsbtbwmgstsefxwruvrdbodloqasmdcokepctsdwlymchhttylhhxwrlwkcpyijysskjxrrbjnryaliwzsjmpudytfuylhcmrbjcningvartwwolaefsgtqejkkqkiuxlogpawfuzgzhufvenutyztafirdzwezdwvbfwleprlnrkq";
        String xmlVersion = "dbwrhvcsgxkvgxpyxswzqpkaaqntloobhdkxrkxdoxagtoomlxvilfeafgnmwlmwphvexpbnsmshrgmbqpwemntzhumcznkheakygpm";
        String openSpliceVersion = "fxqopslcwnprkthvghnlwdyztmjwojbermijzrsugxcznshxbbtujhdqwaesuwjzonoflujbkrmfaseypuateyavqbiwaeiyblxsffhsxbfemtixzzoinvduzyppwioookemrfdiqxrcngqmmgbluuyuybarqvaodqvcxfplcgarzhdyxrnhpkgqirnwuwnujzcujqpkwcbzsdjarsbqvbgwxscukmhfkvqae";
        String cscVersion = "cefntgkyiuhnfalzpqqkkokltcreubjixkmrcvzdjlmmfgbwnevlxwssmvgkyhmaeggadfjzvqlkwikumaqtksyswzlqqqooynumkuqw";
        String subsystemVersions = "p";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 791;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 527;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "e";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }
}

