package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class Rebpower_RebpsTelemetry extends CameraTelemetry {
  private final double[] boardTemp0;

  private final String location;

  private final double[] boardTemp1;

  private final double[] boardTemp2;

  private final double[] boardTemp3;

  private final double[] boardTemp4;

  private final double[] boardTemp5;

  private final double[] boardTemp6;

  public Rebpower_RebpsTelemetry(double[] boardTemp0, String location, double[] boardTemp1,
      double[] boardTemp2, double[] boardTemp3, double[] boardTemp4, double[] boardTemp5,
      double[] boardTemp6) {
    this.boardTemp0 = boardTemp0;
    this.location = location;
    this.boardTemp1 = boardTemp1;
    this.boardTemp2 = boardTemp2;
    this.boardTemp3 = boardTemp3;
    this.boardTemp4 = boardTemp4;
    this.boardTemp5 = boardTemp5;
    this.boardTemp6 = boardTemp6;
  }

  public double[] getBoardTemp0() {
    return boardTemp0;
  }

  public String getLocation() {
    return location;
  }

  public double[] getBoardTemp1() {
    return boardTemp1;
  }

  public double[] getBoardTemp2() {
    return boardTemp2;
  }

  public double[] getBoardTemp3() {
    return boardTemp3;
  }

  public double[] getBoardTemp4() {
    return boardTemp4;
  }

  public double[] getBoardTemp5() {
    return boardTemp5;
  }

  public double[] getBoardTemp6() {
    return boardTemp6;
  }

  @Override
  public String toString() {
    return "Rebpower_RebpsTelemetry{" + "boardTemp0=" + Arrays.toString(boardTemp0) +
        ", location=" + location +", boardTemp1=" + Arrays.toString(boardTemp1) +
        ", boardTemp2=" + Arrays.toString(boardTemp2) +
        ", boardTemp3=" + Arrays.toString(boardTemp3) +
        ", boardTemp4=" + Arrays.toString(boardTemp4) +
        ", boardTemp5=" + Arrays.toString(boardTemp5) +
        ", boardTemp6=" + Arrays.toString(boardTemp6) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double[] boardTemp0;

    private String location;

    private double[] boardTemp1;

    private double[] boardTemp2;

    private double[] boardTemp3;

    private double[] boardTemp4;

    private double[] boardTemp5;

    private double[] boardTemp6;

    private Builder() {
    }

    public Builder boardTemp0(double[] boardTemp0) {
      this.boardTemp0 = boardTemp0;
      return this;
    }

    public Builder location(String location) {
      this.location = location;
      return this;
    }

    public Builder boardTemp1(double[] boardTemp1) {
      this.boardTemp1 = boardTemp1;
      return this;
    }

    public Builder boardTemp2(double[] boardTemp2) {
      this.boardTemp2 = boardTemp2;
      return this;
    }

    public Builder boardTemp3(double[] boardTemp3) {
      this.boardTemp3 = boardTemp3;
      return this;
    }

    public Builder boardTemp4(double[] boardTemp4) {
      this.boardTemp4 = boardTemp4;
      return this;
    }

    public Builder boardTemp5(double[] boardTemp5) {
      this.boardTemp5 = boardTemp5;
      return this;
    }

    public Builder boardTemp6(double[] boardTemp6) {
      this.boardTemp6 = boardTemp6;
      return this;
    }

    public Rebpower_RebpsTelemetry build() {
      return new Rebpower_RebpsTelemetry(boardTemp0, location, boardTemp1, boardTemp2, boardTemp3, boardTemp4, boardTemp5, boardTemp6);
    }
  }
}
