package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Hex_Cold2Telemetry extends CameraTelemetry {
  private final double supplyTmp;

  private final double preExpnTmp;

  private final double evapExitTmp;

  private final double hexRtrnTmp;

  private final double supplyPrs;

  private final double returnPrs;

  private final double superHeat;

  private final double supplySubCooling;

  public Hex_Cold2Telemetry(double supplyTmp, double preExpnTmp, double evapExitTmp,
      double hexRtrnTmp, double supplyPrs, double returnPrs, double superHeat,
      double supplySubCooling) {
    this.supplyTmp = supplyTmp;
    this.preExpnTmp = preExpnTmp;
    this.evapExitTmp = evapExitTmp;
    this.hexRtrnTmp = hexRtrnTmp;
    this.supplyPrs = supplyPrs;
    this.returnPrs = returnPrs;
    this.superHeat = superHeat;
    this.supplySubCooling = supplySubCooling;
  }

  public double getSupplyTmp() {
    return supplyTmp;
  }

  public double getPreExpnTmp() {
    return preExpnTmp;
  }

  public double getEvapExitTmp() {
    return evapExitTmp;
  }

  public double getHexRtrnTmp() {
    return hexRtrnTmp;
  }

  public double getSupplyPrs() {
    return supplyPrs;
  }

  public double getReturnPrs() {
    return returnPrs;
  }

  public double getSuperHeat() {
    return superHeat;
  }

  public double getSupplySubCooling() {
    return supplySubCooling;
  }

  @Override
  public String toString() {
    return "Hex_Cold2Telemetry{" + "supplyTmp=" + supplyTmp +", preExpnTmp=" + preExpnTmp +
        ", evapExitTmp=" + evapExitTmp +", hexRtrnTmp=" + hexRtrnTmp +", supplyPrs=" + supplyPrs +
        ", returnPrs=" + returnPrs +", superHeat=" + superHeat +
        ", supplySubCooling=" + supplySubCooling +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double supplyTmp;

    private double preExpnTmp;

    private double evapExitTmp;

    private double hexRtrnTmp;

    private double supplyPrs;

    private double returnPrs;

    private double superHeat;

    private double supplySubCooling;

    private Builder() {
    }

    public Builder supplyTmp(double supplyTmp) {
      this.supplyTmp = supplyTmp;
      return this;
    }

    public Builder preExpnTmp(double preExpnTmp) {
      this.preExpnTmp = preExpnTmp;
      return this;
    }

    public Builder evapExitTmp(double evapExitTmp) {
      this.evapExitTmp = evapExitTmp;
      return this;
    }

    public Builder hexRtrnTmp(double hexRtrnTmp) {
      this.hexRtrnTmp = hexRtrnTmp;
      return this;
    }

    public Builder supplyPrs(double supplyPrs) {
      this.supplyPrs = supplyPrs;
      return this;
    }

    public Builder returnPrs(double returnPrs) {
      this.returnPrs = returnPrs;
      return this;
    }

    public Builder superHeat(double superHeat) {
      this.superHeat = superHeat;
      return this;
    }

    public Builder supplySubCooling(double supplySubCooling) {
      this.supplySubCooling = supplySubCooling;
      return this;
    }

    public Hex_Cold2Telemetry build() {
      return new Hex_Cold2Telemetry(supplyTmp, preExpnTmp, evapExitTmp, hexRtrnTmp, supplyPrs, returnPrs, superHeat, supplySubCooling);
    }
  }
}
