package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_24VDTelemetry extends CameraTelemetry {
  private final double main_V;

  private final double main_I;

  private final double main_T;

  private final double board_T;

  private final double fPGA_T;

  private final double cryo_Turbo_V;

  private final double cryo_Turbo_I;

  private final double hex_Turbo_V;

  private final double hex_Turbo_I;

  public Quadbox_PDU_24VDTelemetry(double main_V, double main_I, double main_T, double board_T,
      double fPGA_T, double cryo_Turbo_V, double cryo_Turbo_I, double hex_Turbo_V,
      double hex_Turbo_I) {
    this.main_V = main_V;
    this.main_I = main_I;
    this.main_T = main_T;
    this.board_T = board_T;
    this.fPGA_T = fPGA_T;
    this.cryo_Turbo_V = cryo_Turbo_V;
    this.cryo_Turbo_I = cryo_Turbo_I;
    this.hex_Turbo_V = hex_Turbo_V;
    this.hex_Turbo_I = hex_Turbo_I;
  }

  public double getMain_V() {
    return main_V;
  }

  public double getMain_I() {
    return main_I;
  }

  public double getMain_T() {
    return main_T;
  }

  public double getBoard_T() {
    return board_T;
  }

  public double getFPGA_T() {
    return fPGA_T;
  }

  public double getCryo_Turbo_V() {
    return cryo_Turbo_V;
  }

  public double getCryo_Turbo_I() {
    return cryo_Turbo_I;
  }

  public double getHex_Turbo_V() {
    return hex_Turbo_V;
  }

  public double getHex_Turbo_I() {
    return hex_Turbo_I;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_24VDTelemetry{" + "main_V=" + main_V +", main_I=" + main_I +
        ", main_T=" + main_T +", board_T=" + board_T +", fPGA_T=" + fPGA_T +
        ", cryo_Turbo_V=" + cryo_Turbo_V +", cryo_Turbo_I=" + cryo_Turbo_I +
        ", hex_Turbo_V=" + hex_Turbo_V +", hex_Turbo_I=" + hex_Turbo_I +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double main_V;

    private double main_I;

    private double main_T;

    private double board_T;

    private double fPGA_T;

    private double cryo_Turbo_V;

    private double cryo_Turbo_I;

    private double hex_Turbo_V;

    private double hex_Turbo_I;

    private Builder() {
    }

    public Builder main_V(double main_V) {
      this.main_V = main_V;
      return this;
    }

    public Builder main_I(double main_I) {
      this.main_I = main_I;
      return this;
    }

    public Builder main_T(double main_T) {
      this.main_T = main_T;
      return this;
    }

    public Builder board_T(double board_T) {
      this.board_T = board_T;
      return this;
    }

    public Builder fPGA_T(double fPGA_T) {
      this.fPGA_T = fPGA_T;
      return this;
    }

    public Builder cryo_Turbo_V(double cryo_Turbo_V) {
      this.cryo_Turbo_V = cryo_Turbo_V;
      return this;
    }

    public Builder cryo_Turbo_I(double cryo_Turbo_I) {
      this.cryo_Turbo_I = cryo_Turbo_I;
      return this;
    }

    public Builder hex_Turbo_V(double hex_Turbo_V) {
      this.hex_Turbo_V = hex_Turbo_V;
      return this;
    }

    public Builder hex_Turbo_I(double hex_Turbo_I) {
      this.hex_Turbo_I = hex_Turbo_I;
      return this;
    }

    public Quadbox_PDU_24VDTelemetry build() {
      return new Quadbox_PDU_24VDTelemetry(main_V, main_I, main_T, board_T, fPGA_T, cryo_Turbo_V, cryo_Turbo_I, hex_Turbo_V, hex_Turbo_I);
    }
  }
}
