package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_48VTelemetry extends CameraTelemetry {
  private final double main_V;

  private final double main_I;

  private final double main_T;

  private final double board_T;

  private final double fPGA_T;

  private final double purge_Fan_V;

  private final double purge_Fan_I;

  public Quadbox_PDU_48VTelemetry(double main_V, double main_I, double main_T, double board_T,
      double fPGA_T, double purge_Fan_V, double purge_Fan_I) {
    this.main_V = main_V;
    this.main_I = main_I;
    this.main_T = main_T;
    this.board_T = board_T;
    this.fPGA_T = fPGA_T;
    this.purge_Fan_V = purge_Fan_V;
    this.purge_Fan_I = purge_Fan_I;
  }

  public double getMain_V() {
    return main_V;
  }

  public double getMain_I() {
    return main_I;
  }

  public double getMain_T() {
    return main_T;
  }

  public double getBoard_T() {
    return board_T;
  }

  public double getFPGA_T() {
    return fPGA_T;
  }

  public double getPurge_Fan_V() {
    return purge_Fan_V;
  }

  public double getPurge_Fan_I() {
    return purge_Fan_I;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_48VTelemetry{" + "main_V=" + main_V +", main_I=" + main_I +
        ", main_T=" + main_T +", board_T=" + board_T +", fPGA_T=" + fPGA_T +
        ", purge_Fan_V=" + purge_Fan_V +", purge_Fan_I=" + purge_Fan_I +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double main_V;

    private double main_I;

    private double main_T;

    private double board_T;

    private double fPGA_T;

    private double purge_Fan_V;

    private double purge_Fan_I;

    private Builder() {
    }

    public Builder main_V(double main_V) {
      this.main_V = main_V;
      return this;
    }

    public Builder main_I(double main_I) {
      this.main_I = main_I;
      return this;
    }

    public Builder main_T(double main_T) {
      this.main_T = main_T;
      return this;
    }

    public Builder board_T(double board_T) {
      this.board_T = board_T;
      return this;
    }

    public Builder fPGA_T(double fPGA_T) {
      this.fPGA_T = fPGA_T;
      return this;
    }

    public Builder purge_Fan_V(double purge_Fan_V) {
      this.purge_Fan_V = purge_Fan_V;
      return this;
    }

    public Builder purge_Fan_I(double purge_Fan_I) {
      this.purge_Fan_I = purge_Fan_I;
      return this;
    }

    public Quadbox_PDU_48VTelemetry build() {
      return new Quadbox_PDU_48VTelemetry(main_V, main_I, main_T, board_T, fPGA_T, purge_Fan_V, purge_Fan_I);
    }
  }
}
