package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class Quadbox_PDU_24VCTelemetry extends CameraTelemetry {
  private final double main_V;

  private final double main_I;

  private final double main_T;

  private final double board_T;

  private final double fPGA_T;

  private final double pwr_Cry_HCU_V;

  private final double pwr_Cry_HCU_I;

  private final double fes_Shu_HCU_V;

  private final double fes_Shu_HCU_I;

  private final double ion_Pumps_V;

  private final double ion_Pumps_I;

  private final double body_Purge_V;

  private final double body_Purge_I;

  private final double bpu_Maq20_V;

  private final double bpu_Maq20_I;

  private final double gauges_V;

  private final double gauges_I;

  public Quadbox_PDU_24VCTelemetry(double main_V, double main_I, double main_T, double board_T,
      double fPGA_T, double pwr_Cry_HCU_V, double pwr_Cry_HCU_I, double fes_Shu_HCU_V,
      double fes_Shu_HCU_I, double ion_Pumps_V, double ion_Pumps_I, double body_Purge_V,
      double body_Purge_I, double bpu_Maq20_V, double bpu_Maq20_I, double gauges_V,
      double gauges_I) {
    this.main_V = main_V;
    this.main_I = main_I;
    this.main_T = main_T;
    this.board_T = board_T;
    this.fPGA_T = fPGA_T;
    this.pwr_Cry_HCU_V = pwr_Cry_HCU_V;
    this.pwr_Cry_HCU_I = pwr_Cry_HCU_I;
    this.fes_Shu_HCU_V = fes_Shu_HCU_V;
    this.fes_Shu_HCU_I = fes_Shu_HCU_I;
    this.ion_Pumps_V = ion_Pumps_V;
    this.ion_Pumps_I = ion_Pumps_I;
    this.body_Purge_V = body_Purge_V;
    this.body_Purge_I = body_Purge_I;
    this.bpu_Maq20_V = bpu_Maq20_V;
    this.bpu_Maq20_I = bpu_Maq20_I;
    this.gauges_V = gauges_V;
    this.gauges_I = gauges_I;
  }

  public double getMain_V() {
    return main_V;
  }

  public double getMain_I() {
    return main_I;
  }

  public double getMain_T() {
    return main_T;
  }

  public double getBoard_T() {
    return board_T;
  }

  public double getFPGA_T() {
    return fPGA_T;
  }

  public double getPwr_Cry_HCU_V() {
    return pwr_Cry_HCU_V;
  }

  public double getPwr_Cry_HCU_I() {
    return pwr_Cry_HCU_I;
  }

  public double getFes_Shu_HCU_V() {
    return fes_Shu_HCU_V;
  }

  public double getFes_Shu_HCU_I() {
    return fes_Shu_HCU_I;
  }

  public double getIon_Pumps_V() {
    return ion_Pumps_V;
  }

  public double getIon_Pumps_I() {
    return ion_Pumps_I;
  }

  public double getBody_Purge_V() {
    return body_Purge_V;
  }

  public double getBody_Purge_I() {
    return body_Purge_I;
  }

  public double getBpu_Maq20_V() {
    return bpu_Maq20_V;
  }

  public double getBpu_Maq20_I() {
    return bpu_Maq20_I;
  }

  public double getGauges_V() {
    return gauges_V;
  }

  public double getGauges_I() {
    return gauges_I;
  }

  @Override
  public String toString() {
    return "Quadbox_PDU_24VCTelemetry{" + "main_V=" + main_V +", main_I=" + main_I +
        ", main_T=" + main_T +", board_T=" + board_T +", fPGA_T=" + fPGA_T +
        ", pwr_Cry_HCU_V=" + pwr_Cry_HCU_V +", pwr_Cry_HCU_I=" + pwr_Cry_HCU_I +
        ", fes_Shu_HCU_V=" + fes_Shu_HCU_V +", fes_Shu_HCU_I=" + fes_Shu_HCU_I +
        ", ion_Pumps_V=" + ion_Pumps_V +", ion_Pumps_I=" + ion_Pumps_I +
        ", body_Purge_V=" + body_Purge_V +", body_Purge_I=" + body_Purge_I +
        ", bpu_Maq20_V=" + bpu_Maq20_V +", bpu_Maq20_I=" + bpu_Maq20_I +", gauges_V=" + gauges_V +
        ", gauges_I=" + gauges_I +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private double main_V;

    private double main_I;

    private double main_T;

    private double board_T;

    private double fPGA_T;

    private double pwr_Cry_HCU_V;

    private double pwr_Cry_HCU_I;

    private double fes_Shu_HCU_V;

    private double fes_Shu_HCU_I;

    private double ion_Pumps_V;

    private double ion_Pumps_I;

    private double body_Purge_V;

    private double body_Purge_I;

    private double bpu_Maq20_V;

    private double bpu_Maq20_I;

    private double gauges_V;

    private double gauges_I;

    private Builder() {
    }

    public Builder main_V(double main_V) {
      this.main_V = main_V;
      return this;
    }

    public Builder main_I(double main_I) {
      this.main_I = main_I;
      return this;
    }

    public Builder main_T(double main_T) {
      this.main_T = main_T;
      return this;
    }

    public Builder board_T(double board_T) {
      this.board_T = board_T;
      return this;
    }

    public Builder fPGA_T(double fPGA_T) {
      this.fPGA_T = fPGA_T;
      return this;
    }

    public Builder pwr_Cry_HCU_V(double pwr_Cry_HCU_V) {
      this.pwr_Cry_HCU_V = pwr_Cry_HCU_V;
      return this;
    }

    public Builder pwr_Cry_HCU_I(double pwr_Cry_HCU_I) {
      this.pwr_Cry_HCU_I = pwr_Cry_HCU_I;
      return this;
    }

    public Builder fes_Shu_HCU_V(double fes_Shu_HCU_V) {
      this.fes_Shu_HCU_V = fes_Shu_HCU_V;
      return this;
    }

    public Builder fes_Shu_HCU_I(double fes_Shu_HCU_I) {
      this.fes_Shu_HCU_I = fes_Shu_HCU_I;
      return this;
    }

    public Builder ion_Pumps_V(double ion_Pumps_V) {
      this.ion_Pumps_V = ion_Pumps_V;
      return this;
    }

    public Builder ion_Pumps_I(double ion_Pumps_I) {
      this.ion_Pumps_I = ion_Pumps_I;
      return this;
    }

    public Builder body_Purge_V(double body_Purge_V) {
      this.body_Purge_V = body_Purge_V;
      return this;
    }

    public Builder body_Purge_I(double body_Purge_I) {
      this.body_Purge_I = body_Purge_I;
      return this;
    }

    public Builder bpu_Maq20_V(double bpu_Maq20_V) {
      this.bpu_Maq20_V = bpu_Maq20_V;
      return this;
    }

    public Builder bpu_Maq20_I(double bpu_Maq20_I) {
      this.bpu_Maq20_I = bpu_Maq20_I;
      return this;
    }

    public Builder gauges_V(double gauges_V) {
      this.gauges_V = gauges_V;
      return this;
    }

    public Builder gauges_I(double gauges_I) {
      this.gauges_I = gauges_I;
      return this;
    }

    public Quadbox_PDU_24VCTelemetry build() {
      return new Quadbox_PDU_24VCTelemetry(main_V, main_I, main_T, board_T, fPGA_T, pwr_Cry_HCU_V, pwr_Cry_HCU_I, fes_Shu_HCU_V, fes_Shu_HCU_I, ion_Pumps_V, ion_Pumps_I, body_Purge_V, body_Purge_I, bpu_Maq20_V, bpu_Maq20_I, gauges_V, gauges_I);
    }
  }
}
