package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class TakeImagesCommand extends CameraCommand {
  private final int numImages;

  private final double expTime;

  private final boolean shutter;

  private final String sensors;

  private final String keyValueMap;

  private final String obsNote;

  public TakeImagesCommand(int numImages, double expTime, boolean shutter, String sensors,
      String keyValueMap, String obsNote) {
    this.numImages = numImages;
    this.expTime = expTime;
    this.shutter = shutter;
    this.sensors = sensors;
    this.keyValueMap = keyValueMap;
    this.obsNote = obsNote;
  }

  public int getNumImages() {
    return numImages;
  }

  public double getExpTime() {
    return expTime;
  }

  public boolean isShutter() {
    return shutter;
  }

  public String getSensors() {
    return sensors;
  }

  public String getKeyValueMap() {
    return keyValueMap;
  }

  public String getObsNote() {
    return obsNote;
  }

  @Override
  public String toString() {
    return "TakeImagesCommand{" + "numImages=" + numImages +", expTime=" + expTime +
        ", shutter=" + shutter +", sensors=" + sensors +", keyValueMap=" + keyValueMap +
        ", obsNote=" + obsNote +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private int numImages;

    private double expTime;

    private boolean shutter;

    private String sensors;

    private String keyValueMap;

    private String obsNote;

    private Builder() {
    }

    public Builder numImages(int numImages) {
      this.numImages = numImages;
      return this;
    }

    public Builder expTime(double expTime) {
      this.expTime = expTime;
      return this;
    }

    public Builder shutter(boolean shutter) {
      this.shutter = shutter;
      return this;
    }

    public Builder sensors(String sensors) {
      this.sensors = sensors;
      return this;
    }

    public Builder keyValueMap(String keyValueMap) {
      this.keyValueMap = keyValueMap;
      return this;
    }

    public Builder obsNote(String obsNote) {
      this.obsNote = obsNote;
      return this;
    }

    public TakeImagesCommand build() {
      return new TakeImagesCommand(numImages, expTime, shutter, sensors, keyValueMap, obsNote);
    }
  }
}
