/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class ShutterTelemetry
extends CameraTelemetry {
    private final short[] bladeHome;
    private final float[] closeProfile;
    private final float[] motorCurrent;
    private final float[] motorTemp;
    private final short openDirection;
    private final float[] openProfile;
    private final String profileFunction;

    public ShutterTelemetry(short[] bladeHome, float[] closeProfile, float[] motorCurrent, float[] motorTemp, short openDirection, float[] openProfile, String profileFunction) {
        this.bladeHome = bladeHome;
        this.closeProfile = closeProfile;
        this.motorCurrent = motorCurrent;
        this.motorTemp = motorTemp;
        this.openDirection = openDirection;
        this.openProfile = openProfile;
        this.profileFunction = profileFunction;
    }

    public short[] getBladeHome() {
        return this.bladeHome;
    }

    public float[] getCloseProfile() {
        return this.closeProfile;
    }

    public float[] getMotorCurrent() {
        return this.motorCurrent;
    }

    public float[] getMotorTemp() {
        return this.motorTemp;
    }

    public short getOpenDirection() {
        return this.openDirection;
    }

    public float[] getOpenProfile() {
        return this.openProfile;
    }

    public String getProfileFunction() {
        return this.profileFunction;
    }

    public String toString() {
        return "ShutterTelemetry{bladeHome=" + Arrays.toString(this.bladeHome) + ", closeProfile=" + Arrays.toString(this.closeProfile) + ", motorCurrent=" + Arrays.toString(this.motorCurrent) + ", motorTemp=" + Arrays.toString(this.motorTemp) + ", openDirection=" + this.openDirection + ", openProfile=" + Arrays.toString(this.openProfile) + ", profileFunction=" + this.profileFunction + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private short[] bladeHome;
        private float[] closeProfile;
        private float[] motorCurrent;
        private float[] motorTemp;
        private short openDirection;
        private float[] openProfile;
        private String profileFunction;

        private Builder() {
        }

        public Builder bladeHome(short[] bladeHome) {
            this.bladeHome = bladeHome;
            return this;
        }

        public Builder closeProfile(float[] closeProfile) {
            this.closeProfile = closeProfile;
            return this;
        }

        public Builder motorCurrent(float[] motorCurrent) {
            this.motorCurrent = motorCurrent;
            return this;
        }

        public Builder motorTemp(float[] motorTemp) {
            this.motorTemp = motorTemp;
            return this;
        }

        public Builder openDirection(short openDirection) {
            this.openDirection = openDirection;
            return this;
        }

        public Builder openProfile(float[] openProfile) {
            this.openProfile = openProfile;
            return this;
        }

        public Builder profileFunction(String profileFunction) {
            this.profileFunction = profileFunction;
            return this;
        }

        public ShutterTelemetry build() {
            return new ShutterTelemetry(this.bladeHome, this.closeProfile, this.motorCurrent, this.motorTemp, this.openDirection, this.openProfile, this.profileFunction);
        }
    }
}

