/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class CyroTelemetry
extends CameraTelemetry {
    private final float[] coldTemperature;
    private final float compressor;
    private final float[] compressorSpeed;
    private final float[] cryoTemperature;
    private final float[] dischargePressure;
    private final float[] dischargeTemp;
    private final short[] flowInterlock;
    private final float[] heaterCurrent;
    private final float[] heaterVoltage;
    private final float[] intakeFlow;
    private final float[] intakePressure;
    private final float[] intakeTemp;
    private final float[] postExpansionPressure;
    private final float[] postExpansionTemp;
    private final float[] preExpansionPressure;
    private final float[] preExpansionTemp;
    private final float[] returnTemp;

    public CyroTelemetry(float[] coldTemperature, float compressor, float[] compressorSpeed, float[] cryoTemperature, float[] dischargePressure, float[] dischargeTemp, short[] flowInterlock, float[] heaterCurrent, float[] heaterVoltage, float[] intakeFlow, float[] intakePressure, float[] intakeTemp, float[] postExpansionPressure, float[] postExpansionTemp, float[] preExpansionPressure, float[] preExpansionTemp, float[] returnTemp) {
        this.coldTemperature = coldTemperature;
        this.compressor = compressor;
        this.compressorSpeed = compressorSpeed;
        this.cryoTemperature = cryoTemperature;
        this.dischargePressure = dischargePressure;
        this.dischargeTemp = dischargeTemp;
        this.flowInterlock = flowInterlock;
        this.heaterCurrent = heaterCurrent;
        this.heaterVoltage = heaterVoltage;
        this.intakeFlow = intakeFlow;
        this.intakePressure = intakePressure;
        this.intakeTemp = intakeTemp;
        this.postExpansionPressure = postExpansionPressure;
        this.postExpansionTemp = postExpansionTemp;
        this.preExpansionPressure = preExpansionPressure;
        this.preExpansionTemp = preExpansionTemp;
        this.returnTemp = returnTemp;
    }

    public float[] getColdTemperature() {
        return this.coldTemperature;
    }

    public float getCompressor() {
        return this.compressor;
    }

    public float[] getCompressorSpeed() {
        return this.compressorSpeed;
    }

    public float[] getCryoTemperature() {
        return this.cryoTemperature;
    }

    public float[] getDischargePressure() {
        return this.dischargePressure;
    }

    public float[] getDischargeTemp() {
        return this.dischargeTemp;
    }

    public short[] getFlowInterlock() {
        return this.flowInterlock;
    }

    public float[] getHeaterCurrent() {
        return this.heaterCurrent;
    }

    public float[] getHeaterVoltage() {
        return this.heaterVoltage;
    }

    public float[] getIntakeFlow() {
        return this.intakeFlow;
    }

    public float[] getIntakePressure() {
        return this.intakePressure;
    }

    public float[] getIntakeTemp() {
        return this.intakeTemp;
    }

    public float[] getPostExpansionPressure() {
        return this.postExpansionPressure;
    }

    public float[] getPostExpansionTemp() {
        return this.postExpansionTemp;
    }

    public float[] getPreExpansionPressure() {
        return this.preExpansionPressure;
    }

    public float[] getPreExpansionTemp() {
        return this.preExpansionTemp;
    }

    public float[] getReturnTemp() {
        return this.returnTemp;
    }

    public String toString() {
        return "CyroTelemetry{coldTemperature=" + Arrays.toString(this.coldTemperature) + ", compressor=" + this.compressor + ", compressorSpeed=" + Arrays.toString(this.compressorSpeed) + ", cryoTemperature=" + Arrays.toString(this.cryoTemperature) + ", dischargePressure=" + Arrays.toString(this.dischargePressure) + ", dischargeTemp=" + Arrays.toString(this.dischargeTemp) + ", flowInterlock=" + Arrays.toString(this.flowInterlock) + ", heaterCurrent=" + Arrays.toString(this.heaterCurrent) + ", heaterVoltage=" + Arrays.toString(this.heaterVoltage) + ", intakeFlow=" + Arrays.toString(this.intakeFlow) + ", intakePressure=" + Arrays.toString(this.intakePressure) + ", intakeTemp=" + Arrays.toString(this.intakeTemp) + ", postExpansionPressure=" + Arrays.toString(this.postExpansionPressure) + ", postExpansionTemp=" + Arrays.toString(this.postExpansionTemp) + ", preExpansionPressure=" + Arrays.toString(this.preExpansionPressure) + ", preExpansionTemp=" + Arrays.toString(this.preExpansionTemp) + ", returnTemp=" + Arrays.toString(this.returnTemp) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float[] coldTemperature;
        private float compressor;
        private float[] compressorSpeed;
        private float[] cryoTemperature;
        private float[] dischargePressure;
        private float[] dischargeTemp;
        private short[] flowInterlock;
        private float[] heaterCurrent;
        private float[] heaterVoltage;
        private float[] intakeFlow;
        private float[] intakePressure;
        private float[] intakeTemp;
        private float[] postExpansionPressure;
        private float[] postExpansionTemp;
        private float[] preExpansionPressure;
        private float[] preExpansionTemp;
        private float[] returnTemp;

        private Builder() {
        }

        public Builder coldTemperature(float[] coldTemperature) {
            this.coldTemperature = coldTemperature;
            return this;
        }

        public Builder compressor(float compressor) {
            this.compressor = compressor;
            return this;
        }

        public Builder compressorSpeed(float[] compressorSpeed) {
            this.compressorSpeed = compressorSpeed;
            return this;
        }

        public Builder cryoTemperature(float[] cryoTemperature) {
            this.cryoTemperature = cryoTemperature;
            return this;
        }

        public Builder dischargePressure(float[] dischargePressure) {
            this.dischargePressure = dischargePressure;
            return this;
        }

        public Builder dischargeTemp(float[] dischargeTemp) {
            this.dischargeTemp = dischargeTemp;
            return this;
        }

        public Builder flowInterlock(short[] flowInterlock) {
            this.flowInterlock = flowInterlock;
            return this;
        }

        public Builder heaterCurrent(float[] heaterCurrent) {
            this.heaterCurrent = heaterCurrent;
            return this;
        }

        public Builder heaterVoltage(float[] heaterVoltage) {
            this.heaterVoltage = heaterVoltage;
            return this;
        }

        public Builder intakeFlow(float[] intakeFlow) {
            this.intakeFlow = intakeFlow;
            return this;
        }

        public Builder intakePressure(float[] intakePressure) {
            this.intakePressure = intakePressure;
            return this;
        }

        public Builder intakeTemp(float[] intakeTemp) {
            this.intakeTemp = intakeTemp;
            return this;
        }

        public Builder postExpansionPressure(float[] postExpansionPressure) {
            this.postExpansionPressure = postExpansionPressure;
            return this;
        }

        public Builder postExpansionTemp(float[] postExpansionTemp) {
            this.postExpansionTemp = postExpansionTemp;
            return this;
        }

        public Builder preExpansionPressure(float[] preExpansionPressure) {
            this.preExpansionPressure = preExpansionPressure;
            return this;
        }

        public Builder preExpansionTemp(float[] preExpansionTemp) {
            this.preExpansionTemp = preExpansionTemp;
            return this;
        }

        public Builder returnTemp(float[] returnTemp) {
            this.returnTemp = returnTemp;
            return this;
        }

        public CyroTelemetry build() {
            return new CyroTelemetry(this.coldTemperature, this.compressor, this.compressorSpeed, this.cryoTemperature, this.dischargePressure, this.dischargeTemp, this.flowInterlock, this.heaterCurrent, this.heaterVoltage, this.intakeFlow, this.intakePressure, this.intakeTemp, this.postExpansionPressure, this.postExpansionTemp, this.preExpansionPressure, this.preExpansionTemp, this.returnTemp);
        }
    }
}

