/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class ColdTelemetry
extends CameraTelemetry {
    private final float[] compressorLoad;
    private final float[] compressorSpeed;
    private final float[] dischargePressure;
    private final float[] dischargeTemp;
    private final short[] flowInterlock;
    private final float[] heaterCurrent;
    private final float[] heaterVoltage;
    private final float[] intakeFlow;
    private final float[] intakePressure;
    private final float[] intakeTemp;
    private final float[] ionPump;
    private final short[] mechPump;
    private final float[] postExpansionPressure;
    private final float[] postExpansionTemp;
    private final float[] preExpansionPressure;
    private final float[] preExpansionTemp;
    private final int[] rga;
    private final float[] returnTemp;
    private final float utilityRoomTemperature;
    private final float[] vacuumGauge;
    private final short[] valveStatus;

    public ColdTelemetry(float[] compressorLoad, float[] compressorSpeed, float[] dischargePressure, float[] dischargeTemp, short[] flowInterlock, float[] heaterCurrent, float[] heaterVoltage, float[] intakeFlow, float[] intakePressure, float[] intakeTemp, float[] ionPump, short[] mechPump, float[] postExpansionPressure, float[] postExpansionTemp, float[] preExpansionPressure, float[] preExpansionTemp, int[] rga, float[] returnTemp, float utilityRoomTemperature, float[] vacuumGauge, short[] valveStatus) {
        this.compressorLoad = compressorLoad;
        this.compressorSpeed = compressorSpeed;
        this.dischargePressure = dischargePressure;
        this.dischargeTemp = dischargeTemp;
        this.flowInterlock = flowInterlock;
        this.heaterCurrent = heaterCurrent;
        this.heaterVoltage = heaterVoltage;
        this.intakeFlow = intakeFlow;
        this.intakePressure = intakePressure;
        this.intakeTemp = intakeTemp;
        this.ionPump = ionPump;
        this.mechPump = mechPump;
        this.postExpansionPressure = postExpansionPressure;
        this.postExpansionTemp = postExpansionTemp;
        this.preExpansionPressure = preExpansionPressure;
        this.preExpansionTemp = preExpansionTemp;
        this.rga = rga;
        this.returnTemp = returnTemp;
        this.utilityRoomTemperature = utilityRoomTemperature;
        this.vacuumGauge = vacuumGauge;
        this.valveStatus = valveStatus;
    }

    public float[] getCompressorLoad() {
        return this.compressorLoad;
    }

    public float[] getCompressorSpeed() {
        return this.compressorSpeed;
    }

    public float[] getDischargePressure() {
        return this.dischargePressure;
    }

    public float[] getDischargeTemp() {
        return this.dischargeTemp;
    }

    public short[] getFlowInterlock() {
        return this.flowInterlock;
    }

    public float[] getHeaterCurrent() {
        return this.heaterCurrent;
    }

    public float[] getHeaterVoltage() {
        return this.heaterVoltage;
    }

    public float[] getIntakeFlow() {
        return this.intakeFlow;
    }

    public float[] getIntakePressure() {
        return this.intakePressure;
    }

    public float[] getIntakeTemp() {
        return this.intakeTemp;
    }

    public float[] getIonPump() {
        return this.ionPump;
    }

    public short[] getMechPump() {
        return this.mechPump;
    }

    public float[] getPostExpansionPressure() {
        return this.postExpansionPressure;
    }

    public float[] getPostExpansionTemp() {
        return this.postExpansionTemp;
    }

    public float[] getPreExpansionPressure() {
        return this.preExpansionPressure;
    }

    public float[] getPreExpansionTemp() {
        return this.preExpansionTemp;
    }

    public int[] getRga() {
        return this.rga;
    }

    public float[] getReturnTemp() {
        return this.returnTemp;
    }

    public float getUtilityRoomTemperature() {
        return this.utilityRoomTemperature;
    }

    public float[] getVacuumGauge() {
        return this.vacuumGauge;
    }

    public short[] getValveStatus() {
        return this.valveStatus;
    }

    public String toString() {
        return "ColdTelemetry{compressorLoad=" + Arrays.toString(this.compressorLoad) + ", compressorSpeed=" + Arrays.toString(this.compressorSpeed) + ", dischargePressure=" + Arrays.toString(this.dischargePressure) + ", dischargeTemp=" + Arrays.toString(this.dischargeTemp) + ", flowInterlock=" + Arrays.toString(this.flowInterlock) + ", heaterCurrent=" + Arrays.toString(this.heaterCurrent) + ", heaterVoltage=" + Arrays.toString(this.heaterVoltage) + ", intakeFlow=" + Arrays.toString(this.intakeFlow) + ", intakePressure=" + Arrays.toString(this.intakePressure) + ", intakeTemp=" + Arrays.toString(this.intakeTemp) + ", ionPump=" + Arrays.toString(this.ionPump) + ", mechPump=" + Arrays.toString(this.mechPump) + ", postExpansionPressure=" + Arrays.toString(this.postExpansionPressure) + ", postExpansionTemp=" + Arrays.toString(this.postExpansionTemp) + ", preExpansionPressure=" + Arrays.toString(this.preExpansionPressure) + ", preExpansionTemp=" + Arrays.toString(this.preExpansionTemp) + ", rga=" + Arrays.toString(this.rga) + ", returnTemp=" + Arrays.toString(this.returnTemp) + ", utilityRoomTemperature=" + this.utilityRoomTemperature + ", vacuumGauge=" + Arrays.toString(this.vacuumGauge) + ", valveStatus=" + Arrays.toString(this.valveStatus) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float[] compressorLoad;
        private float[] compressorSpeed;
        private float[] dischargePressure;
        private float[] dischargeTemp;
        private short[] flowInterlock;
        private float[] heaterCurrent;
        private float[] heaterVoltage;
        private float[] intakeFlow;
        private float[] intakePressure;
        private float[] intakeTemp;
        private float[] ionPump;
        private short[] mechPump;
        private float[] postExpansionPressure;
        private float[] postExpansionTemp;
        private float[] preExpansionPressure;
        private float[] preExpansionTemp;
        private int[] rga;
        private float[] returnTemp;
        private float utilityRoomTemperature;
        private float[] vacuumGauge;
        private short[] valveStatus;

        private Builder() {
        }

        public Builder compressorLoad(float[] compressorLoad) {
            this.compressorLoad = compressorLoad;
            return this;
        }

        public Builder compressorSpeed(float[] compressorSpeed) {
            this.compressorSpeed = compressorSpeed;
            return this;
        }

        public Builder dischargePressure(float[] dischargePressure) {
            this.dischargePressure = dischargePressure;
            return this;
        }

        public Builder dischargeTemp(float[] dischargeTemp) {
            this.dischargeTemp = dischargeTemp;
            return this;
        }

        public Builder flowInterlock(short[] flowInterlock) {
            this.flowInterlock = flowInterlock;
            return this;
        }

        public Builder heaterCurrent(float[] heaterCurrent) {
            this.heaterCurrent = heaterCurrent;
            return this;
        }

        public Builder heaterVoltage(float[] heaterVoltage) {
            this.heaterVoltage = heaterVoltage;
            return this;
        }

        public Builder intakeFlow(float[] intakeFlow) {
            this.intakeFlow = intakeFlow;
            return this;
        }

        public Builder intakePressure(float[] intakePressure) {
            this.intakePressure = intakePressure;
            return this;
        }

        public Builder intakeTemp(float[] intakeTemp) {
            this.intakeTemp = intakeTemp;
            return this;
        }

        public Builder ionPump(float[] ionPump) {
            this.ionPump = ionPump;
            return this;
        }

        public Builder mechPump(short[] mechPump) {
            this.mechPump = mechPump;
            return this;
        }

        public Builder postExpansionPressure(float[] postExpansionPressure) {
            this.postExpansionPressure = postExpansionPressure;
            return this;
        }

        public Builder postExpansionTemp(float[] postExpansionTemp) {
            this.postExpansionTemp = postExpansionTemp;
            return this;
        }

        public Builder preExpansionPressure(float[] preExpansionPressure) {
            this.preExpansionPressure = preExpansionPressure;
            return this;
        }

        public Builder preExpansionTemp(float[] preExpansionTemp) {
            this.preExpansionTemp = preExpansionTemp;
            return this;
        }

        public Builder rga(int[] rga) {
            this.rga = rga;
            return this;
        }

        public Builder returnTemp(float[] returnTemp) {
            this.returnTemp = returnTemp;
            return this;
        }

        public Builder utilityRoomTemperature(float utilityRoomTemperature) {
            this.utilityRoomTemperature = utilityRoomTemperature;
            return this;
        }

        public Builder vacuumGauge(float[] vacuumGauge) {
            this.vacuumGauge = vacuumGauge;
            return this;
        }

        public Builder valveStatus(short[] valveStatus) {
            this.valveStatus = valveStatus;
            return this;
        }

        public ColdTelemetry build() {
            return new ColdTelemetry(this.compressorLoad, this.compressorSpeed, this.dischargePressure, this.dischargeTemp, this.flowInterlock, this.heaterCurrent, this.heaterVoltage, this.intakeFlow, this.intakePressure, this.intakeTemp, this.ionPump, this.mechPump, this.postExpansionPressure, this.postExpansionTemp, this.preExpansionPressure, this.preExpansionTemp, this.rga, this.returnTemp, this.utilityRoomTemperature, this.vacuumGauge, this.valveStatus);
        }
    }
}

