/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.CCSTelemetry;
import org.lsst.sal.camera.telemetry.ClusterEncoderTelemetry;
import org.lsst.sal.camera.telemetry.ColdTelemetry;
import org.lsst.sal.camera.telemetry.CyroTelemetry;
import org.lsst.sal.camera.telemetry.FilterTelemetry;
import org.lsst.sal.camera.telemetry.GasTelemetry;
import org.lsst.sal.camera.telemetry.GdsTelemetry;
import org.lsst.sal.camera.telemetry.HeartbeatTelemetry;
import org.lsst.sal.camera.telemetry.PcmsTelemetry;
import org.lsst.sal.camera.telemetry.ProtTelemetry;
import org.lsst.sal.camera.telemetry.PurgeTelemetry;
import org.lsst.sal.camera.telemetry.SasTelemetry;
import org.lsst.sal.camera.telemetry.SdsTelemetry;
import org.lsst.sal.camera.telemetry.ShutterTelemetry;
import org.lsst.sal.camera.telemetry.WasTelemetry;
import org.lsst.sal.camera.telemetry.WdsTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveShutterTelemetry() throws Exception {
        short[] bladeHome = new short[]{866, 336};
        float[] closeProfile = new float[]{0.6779427f, 0.36885625f, 0.9268538f, 0.19651574f, 0.71458113f, 0.01391238f, 0.43761688f, 0.8390809f, 0.36190033f, 0.30676663f, 0.9353718f, 0.8341261f, 0.83161145f, 0.18507963f, 0.059637487f, 0.8327114f, 0.37604064f, 0.03953767f, 0.8931769f, 0.34542137f, 0.09803194f, 0.6892715f, 0.398157f, 0.13042718f};
        float[] motorCurrent = new float[]{0.034231484f, 0.69723445f};
        float[] motorTemp = new float[]{0.63129085f, 0.41550487f};
        short openDirection = 874;
        float[] openProfile = new float[]{0.7746595f, 0.82122225f, 0.86134493f, 0.9449492f, 0.8186742f, 0.06312513f, 0.731778f, 0.24170566f, 0.9763653f, 0.81531787f, 0.8984127f, 0.6960816f, 0.50960386f, 0.122396946f, 0.7142266f, 0.78804517f, 0.015918374f, 0.6688567f, 0.10010642f, 0.7925052f, 0.25043708f, 0.3443914f, 0.32303882f, 0.30688143f};
        String profileFunction = "bjddrmakxmojjdtbbzotfrl";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ShutterTelemetry(bladeHome, closeProfile, motorCurrent, motorTemp, openDirection, openProfile, profileFunction));
        Assert.assertTrue((boolean)(item instanceof ShutterTelemetry));
        ShutterTelemetry item_ = (ShutterTelemetry)item;
        Assert.assertArrayEquals((short[])bladeHome, (short[])item_.getBladeHome());
        Assert.assertArrayEquals((float[])closeProfile, (float[])item_.getCloseProfile(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorCurrent, (float[])item_.getMotorCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorTemp, (float[])item_.getMotorTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)openDirection, (long)item_.getOpenDirection());
        Assert.assertArrayEquals((float[])openProfile, (float[])item_.getOpenProfile(), (float)1.0E-6f);
        Assert.assertEquals((Object)profileFunction, (Object)item_.getProfileFunction());
    }

    @Test
    public void sendReceiveProtTelemetry() throws Exception {
        int[] status = new int[]{919, 508};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ProtTelemetry(status));
        Assert.assertTrue((boolean)(item instanceof ProtTelemetry));
        ProtTelemetry item_ = (ProtTelemetry)item;
        Assert.assertArrayEquals((int[])status, (int[])item_.getStatus());
    }

    @Test
    public void sendReceiveFilterTelemetry() throws Exception {
        int loaderTelemetry = 479;
        short rebID = 495;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterTelemetry(loaderTelemetry, rebID));
        Assert.assertTrue((boolean)(item instanceof FilterTelemetry));
        FilterTelemetry item_ = (FilterTelemetry)item;
        Assert.assertEquals((long)loaderTelemetry, (long)item_.getLoaderTelemetry());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveHeartbeatTelemetry() throws Exception {
        boolean heartbeat = false;
        int priority = 710;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new HeartbeatTelemetry(heartbeat, priority));
        Assert.assertTrue((boolean)(item instanceof HeartbeatTelemetry));
        HeartbeatTelemetry item_ = (HeartbeatTelemetry)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveWasTelemetry() throws Exception {
        short boardID = 29;
        float[] boardCurrent = new float[]{0.44293714f, 0.7194572f, 0.19852602f, 0.16791987f};
        float[] boardTemp = new float[]{0.03862518f, 0.07557565f, 0.26327354f, 0.5822993f, 0.74476445f, 0.44467437f, 0.5255761f, 0.43829185f, 0.97411954f, 0.7157511f, 0.5872115f, 0.121028066f};
        float[] boardVoltage = new float[]{0.57526296f, 0.94633526f, 0.56327724f, 0.7127207f};
        int[] cabacMUX = new int[]{356, 902, 435, 705};
        short ccdID = 676;
        int ccdtemp = 318;
        int[] fpgaCheckSum = new int[]{791, 489};
        short rebID = 442;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof WasTelemetry));
        WasTelemetry item_ = (WasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveCCSTelemetry() throws Exception {
        int[] ccsStatus = new int[]{960, 494, 552, 444, 593, 28, 718, 351, 215, 765, 656, 145, 587, 174, 237, 206, 340, 716, 810, 107};
        int[] imageStatus = new int[]{766, 252, 878, 165, 26, 704, 719, 941, 15, 603, 491, 402, 78, 538, 659, 939, 291, 614, 242, 400};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CCSTelemetry(ccsStatus, imageStatus));
        Assert.assertTrue((boolean)(item instanceof CCSTelemetry));
        CCSTelemetry item_ = (CCSTelemetry)item;
        Assert.assertArrayEquals((int[])ccsStatus, (int[])item_.getCcsStatus());
        Assert.assertArrayEquals((int[])imageStatus, (int[])item_.getImageStatus());
    }

    @Test
    public void sendReceiveClusterEncoderTelemetry() throws Exception {
        float[] imageSD = new float[]{0.10578269f, 0.8073093f, 0.53541875f, 0.43833786f, 0.3118906f, 0.6383228f, 0.7984319f, 0.76435053f, 0.6254391f, 0.43846172f, 0.38200063f, 0.5367989f, 0.115888715f, 0.86348873f, 0.5453998f, 0.083868444f, 0.6564323f, 0.855823f, 0.26368457f, 0.54779327f, 0.84881806f, 0.3473512f, 0.33951807f, 0.9065204f, 0.23809117f, 0.0703339f, 0.99297434f, 0.0360415f, 0.9235765f, 0.4671905f, 0.77630806f, 0.7551076f, 0.3017298f, 0.86837405f, 0.76328856f, 0.29622638f, 0.11591315f, 0.4327585f, 0.03410977f, 0.3431815f, 0.30898368f, 0.087475955f, 0.5024643f, 0.5691242f, 0.33874393f, 0.2125802f, 0.61208856f, 0.60701907f, 0.726321f, 0.7670446f, 0.6325419f, 0.14544326f, 0.15658772f, 0.20130384f, 0.49040705f, 0.6301425f, 0.57159907f, 0.93082523f, 0.8303445f, 0.08115542f, 0.41710728f, 0.51619023f, 0.37397075f, 0.2256726f, 0.68357563f, 0.49712306f, 0.46246642f, 0.37017685f, 0.18240207f, 0.1282174f, 0.7758813f, 0.7670015f, 0.8115732f, 0.95828426f, 0.728636f, 0.19857323f, 0.4796157f, 0.25690705f, 0.5727071f, 0.83871365f, 0.100034475f, 0.02270621f, 0.18902206f, 0.3390364f, 0.2585823f, 0.5878645f, 0.32090956f, 0.41738057f, 0.051495135f, 0.37065208f, 0.27390105f, 0.8351987f, 0.3436535f, 0.90815467f, 0.062237978f, 0.58580023f, 0.59153914f, 0.039404333f, 0.5782076f, 0.87242234f};
        float[] imageMean = new float[]{0.09750861f, 0.6970199f, 0.5656336f, 0.2344464f, 0.4305929f, 0.72379744f, 0.22883946f, 0.13502043f, 0.97666645f, 0.0580796f, 0.95415944f, 0.81034f, 0.5199497f, 0.45492905f, 0.37919122f, 0.009437978f, 0.1515814f, 0.1340326f, 0.44770014f, 0.9362476f, 0.03321004f, 0.7028569f, 0.93324244f, 0.7087406f, 0.88861877f, 0.80601686f, 0.5156504f, 0.6420606f, 0.9693572f, 0.93834573f, 0.93062675f, 0.76582855f, 0.44687086f, 0.047164083f, 0.07853961f, 0.0254004f, 0.1699807f, 0.0842371f, 0.63446087f, 0.37111545f, 0.82968706f, 0.77351934f, 0.5235157f, 0.38994354f, 0.27069718f, 0.08877182f, 0.2553131f, 0.71497995f, 0.8489567f, 0.41537887f, 0.20583731f, 0.29765356f, 0.8656078f, 0.061204135f, 0.4175439f, 0.83611965f, 0.6095972f, 0.7182312f, 0.79700106f, 0.5150529f, 0.95367014f, 0.024302244f, 0.928351f, 0.4740072f, 0.7023636f, 0.47487104f, 0.30985624f, 0.5338638f, 0.5571524f, 0.35884053f, 0.14520413f, 0.07696706f, 0.10501045f, 0.9888869f, 0.88203645f, 0.20279056f, 0.25487536f, 0.44194323f, 0.25395572f, 0.42696494f, 0.034999788f, 0.0746063f, 0.43126482f, 0.019913554f, 0.25673872f, 0.81415087f, 0.06776583f, 0.3080184f, 0.7713652f, 0.30971682f, 0.10956347f, 0.8041087f, 0.56106454f, 0.4493351f, 0.53608f, 0.2672106f, 0.7690035f, 0.07416129f, 0.07812846f, 0.7891015f};
        float[] overscanSD = new float[]{0.6825828f, 0.34709775f, 0.013252199f, 0.79560786f, 0.22558087f, 0.63254106f, 0.5006039f, 0.6652115f, 0.416421f, 0.7190467f, 0.47800446f, 0.19095176f, 0.6294053f, 0.14714211f, 0.809719f, 0.7315373f, 0.112249136f, 0.4983493f, 0.3177681f, 0.95481884f, 0.71602905f, 0.044832468f, 0.24072522f, 0.115276396f, 0.97277135f, 0.76622134f, 0.99605185f, 0.82400835f, 0.6920108f, 0.60346216f, 0.3448001f, 0.9650728f, 0.9620434f, 0.959519f, 0.9063346f, 0.43924105f, 0.54618f, 0.9720297f, 0.6965589f, 0.63172674f, 0.011635423f, 0.4003561f, 0.98258084f, 0.21382213f, 0.7619113f, 0.093761206f, 0.2920429f, 0.11229926f, 0.34644657f, 0.77168006f, 0.18433094f, 0.1807397f, 0.76832885f, 0.16238272f, 0.1970287f, 0.4525873f, 0.9170207f, 0.65199566f, 0.8034157f, 0.46874374f, 0.024027646f, 0.30924702f, 0.85023063f, 0.378143f, 0.1214962f, 0.11793405f, 0.6497014f, 0.5862679f, 0.71380895f, 0.19261092f, 0.051944375f, 0.1554529f, 0.22786778f, 0.7251223f, 0.5648685f, 0.87662846f, 0.6570949f, 0.040240467f, 0.07590586f, 0.5725909f, 0.16602236f, 0.88581693f, 0.38608187f, 0.34875435f, 0.17609864f, 0.4826553f, 0.53061736f, 0.9726027f, 0.649053f, 0.77602226f, 0.43550998f, 0.584773f, 0.3524921f, 0.20670539f, 0.56611836f, 0.4730755f, 0.90464354f, 0.42532212f, 0.84700346f, 0.5790964f};
        float[] overscanMean = new float[]{0.31322646f, 0.05780661f, 0.7731549f, 0.8617905f, 0.6498541f, 0.5694114f, 0.5578445f, 0.17322308f, 0.9293252f, 0.72404474f, 0.65392965f, 0.17105341f, 0.32642913f, 0.17832279f, 0.59132904f, 0.21629053f, 0.585883f, 0.54648966f, 0.8570885f, 0.60224223f, 0.028786123f, 0.31259924f, 0.33504725f, 0.70348465f, 0.48716873f, 0.3174442f, 0.46432948f, 0.29730546f, 0.0031346083f, 0.105174005f, 0.88007855f, 0.9227315f, 0.29764372f, 0.15198624f, 0.4919929f, 0.43539298f, 0.07371241f, 0.2184745f, 0.12791741f, 0.07466853f, 0.78787166f, 0.6480439f, 0.42822146f, 0.27049232f, 0.8609157f, 0.084276795f, 0.29480052f, 0.92171085f, 0.5537099f, 0.5863768f, 0.06475246f, 0.019893289f, 0.19613874f, 0.59809303f, 0.64720565f, 0.7691007f, 0.80783546f, 0.36422062f, 0.10213399f, 0.963495f, 0.70942795f, 0.7103844f, 0.78764415f, 0.48414654f, 0.7045748f, 0.20498264f, 0.008130431f, 0.7204172f, 0.1685946f, 0.53364784f, 0.5764714f, 0.31942928f, 0.6521688f, 0.9412608f, 0.39131212f, 0.43207276f, 0.7822176f, 0.1674329f, 0.82329035f, 0.021574795f, 0.59101915f, 0.8295904f, 0.71529776f, 0.49980235f, 0.3440103f, 0.4326051f, 0.21062565f, 0.07925898f, 0.2721265f, 0.4227059f, 0.5238474f, 0.600369f, 0.7923103f, 0.101676464f, 0.52289623f, 0.9924355f, 0.15684432f, 0.9987385f, 0.47297782f, 0.93405455f};
        float[] psf = new float[]{0.48599404f, 0.013784826f, 0.14531678f, 0.12934476f, 0.67723775f, 0.42665136f, 0.3735013f, 0.04779643f, 0.2569039f, 0.6709095f, 0.9702103f, 0.078682125f, 0.24574816f, 0.6333491f, 0.13586271f, 0.119746685f, 0.08891684f, 0.52616924f, 0.3023141f, 0.40137637f, 0.5835315f, 0.03028053f, 0.9788788f, 0.29183292f, 0.095071435f, 0.19555652f, 0.09001446f, 0.33974743f, 0.64875025f, 0.3559845f, 0.51495826f, 0.49334407f, 0.31671005f, 0.25121927f, 0.82604676f, 0.35138333f, 0.6892633f, 0.39591485f, 0.35660863f, 0.2112596f, 0.75238055f, 0.08741033f, 0.75904834f, 0.300897f, 0.7185729f, 0.9520105f, 0.7025131f, 0.8319878f, 0.9392833f, 0.58948046f, 0.6364537f, 0.76479393f, 0.019551396f, 0.2518608f, 0.9561854f, 0.50437135f, 0.35633576f, 0.9818012f, 0.05957359f, 0.18300074f, 0.11738366f, 0.7109484f, 0.80618876f, 0.95526606f, 0.8954678f, 0.28225982f, 0.67330027f, 0.5251776f, 0.031327665f, 0.5913362f, 0.35413134f, 0.32669246f, 0.65654963f, 0.24897677f, 0.8357329f, 0.7307541f, 0.5143061f, 0.6362953f, 0.81512636f, 0.8975062f, 0.36139202f, 0.56915474f, 0.11711925f, 0.4287027f, 0.4200098f, 0.20275605f, 0.035132706f, 0.5027276f, 0.7535496f, 0.310475f, 0.96286094f, 0.34638035f, 0.29910475f, 0.7620957f, 0.5705672f, 0.5701176f, 0.45319545f, 0.33221525f, 0.12193096f, 0.37634134f, 0.8193006f, 0.89465934f, 0.35780776f, 0.9562797f, 0.8701253f, 0.43627113f, 0.9899036f, 0.48584515f, 0.6284509f, 0.06454408f, 0.06368184f, 0.18351716f, 0.9429874f, 0.5275206f, 0.8448999f, 0.5258512f, 0.83552134f, 0.52855825f, 0.052761912f, 0.2538656f, 0.6691251f, 0.94847935f, 0.06510055f, 0.52461463f, 0.37117463f, 0.7069012f, 0.5332659f, 0.94816893f, 0.6169564f, 0.45495182f, 0.8080832f, 0.23556727f, 0.10788506f, 0.22299147f, 0.8505874f, 0.40576214f, 0.8716053f, 0.007391572f, 0.30508882f, 0.54998755f, 0.76891094f, 0.6060042f, 0.08595711f, 0.824268f, 0.1545369f, 0.6669414f, 0.8774278f, 0.8820336f, 0.33611572f, 0.34206152f, 0.087462485f, 0.3192116f, 0.1792404f, 0.40563303f, 0.017583013f, 0.78703463f, 0.87854385f, 0.55865216f, 0.8116311f, 0.33960134f, 0.65753907f, 0.56698114f, 0.39417303f, 0.8835062f, 0.46682012f, 0.13173908f, 0.38600725f, 0.54832006f, 0.7548995f, 0.04621786f, 0.43778813f, 0.6151736f, 0.11285722f, 0.41614866f, 0.6166311f, 0.745116f, 0.20814842f, 0.9986693f, 0.24381286f, 0.51135975f, 0.48001832f, 0.117213964f, 0.7590519f, 0.23517823f, 0.76529574f, 0.03028369f, 0.8887019f, 0.38241404f, 0.4457968f, 0.045282245f, 0.24748898f, 0.027725935f, 0.0847016f, 0.37607938f, 0.8977768f, 0.32142735f, 0.46723914f, 0.6245751f, 0.7339741f, 0.3867373f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ClusterEncoderTelemetry(imageSD, imageMean, overscanSD, overscanMean, psf));
        Assert.assertTrue((boolean)(item instanceof ClusterEncoderTelemetry));
        ClusterEncoderTelemetry item_ = (ClusterEncoderTelemetry)item;
        Assert.assertArrayEquals((float[])imageSD, (float[])item_.getImageSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])imageMean, (float[])item_.getImageMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanSD, (float[])item_.getOverscanSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanMean, (float[])item_.getOverscanMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])psf, (float[])item_.getPsf(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveCyroTelemetry() throws Exception {
        float[] coldTemperature = new float[]{0.7396143f, 0.5302887f, 0.52546227f};
        float compressor = 0.4743011f;
        float[] compressorSpeed = new float[]{0.09875047f, 0.06402588f};
        float[] cryoTemperature = new float[]{0.2277928f, 0.5498887f, 0.51414365f, 0.15622997f, 0.7129836f, 0.2873063f, 0.9425869f, 0.040100098f, 0.3452611f, 0.8819695f, 0.74802613f, 0.8744506f};
        float[] dischargePressure = new float[]{0.07389665f, 0.34459049f};
        float[] dischargeTemp = new float[]{0.77425283f, 0.5902373f};
        short[] flowInterlock = new short[]{35, 403};
        float[] heaterCurrent = new float[]{0.09007406f, 0.70443845f, 0.02442491f, 0.9676601f, 0.5781851f, 0.6704366f};
        float[] heaterVoltage = new float[]{0.092953384f, 0.8538468f, 0.65399295f, 0.51821005f, 0.22342896f, 0.46468568f};
        float[] intakeFlow = new float[]{0.7535202f, 0.49164075f};
        float[] intakePressure = new float[]{0.2608568f, 0.27152407f};
        float[] intakeTemp = new float[]{0.23528773f, 0.85333914f};
        float[] postExpansionPressure = new float[]{0.81593496f, 0.28954864f};
        float[] postExpansionTemp = new float[]{0.80540466f, 0.31695497f};
        float[] preExpansionPressure = new float[]{0.21462613f, 0.34066665f};
        float[] preExpansionTemp = new float[]{0.94427f, 0.8284989f};
        float[] returnTemp = new float[]{0.58450115f, 0.39886826f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CyroTelemetry(coldTemperature, compressor, compressorSpeed, cryoTemperature, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, returnTemp));
        Assert.assertTrue((boolean)(item instanceof CyroTelemetry));
        CyroTelemetry item_ = (CyroTelemetry)item;
        Assert.assertArrayEquals((float[])coldTemperature, (float[])item_.getColdTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)compressor, (float)item_.getCompressor(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])cryoTemperature, (float[])item_.getCryoTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
    }

    @Test
    public void sendReceivePurgeTelemetry() throws Exception {
        float[] accelerometer = new float[]{0.42422295f, 0.87537193f, 0.6650663f, 0.7452285f, 0.33771592f, 0.7063473f};
        float blowerSetting = 0.004302442f;
        float blowerSpeed = 0.7798169f;
        float bodyFlowMeter = 0.9732813f;
        float bodyTemp = 0.92755526f;
        float heaterCurrent = 0.868564f;
        float heaters = 0.35125768f;
        int microphone = 966;
        float trunkFlowMeter = 0.856595f;
        float trunkTemp = 0.3706646f;
        int valveSetting = 922;
        int valves = 852;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PurgeTelemetry(accelerometer, blowerSetting, blowerSpeed, bodyFlowMeter, bodyTemp, heaterCurrent, heaters, microphone, trunkFlowMeter, trunkTemp, valveSetting, valves));
        Assert.assertTrue((boolean)(item instanceof PurgeTelemetry));
        PurgeTelemetry item_ = (PurgeTelemetry)item;
        Assert.assertArrayEquals((float[])accelerometer, (float[])item_.getAccelerometer(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSetting, (float)item_.getBlowerSetting(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSpeed, (float)item_.getBlowerSpeed(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyFlowMeter, (float)item_.getBodyFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyTemp, (float)item_.getBodyTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)heaterCurrent, (float)item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)heaters, (float)item_.getHeaters(), (float)1.0E-6f);
        Assert.assertEquals((long)microphone, (long)item_.getMicrophone());
        Assert.assertEquals((float)trunkFlowMeter, (float)item_.getTrunkFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)trunkTemp, (float)item_.getTrunkTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)valveSetting, (long)item_.getValveSetting());
        Assert.assertEquals((long)valves, (long)item_.getValves());
    }

    @Test
    public void sendReceiveWdsTelemetry() throws Exception {
        short rebID = 718;
        int[] timingParameters = new int[]{117, 683, 247, 676, 969, 969, 805, 212, 429, 825};
        int[] flag = new int[]{563, 202, 460, 281, 92, 135, 473, 97, 190, 796, 635, 397, 199, 42, 411, 4, 557, 851, 418, 0};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof WdsTelemetry));
        WdsTelemetry item_ = (WdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGdsTelemetry() throws Exception {
        short rebID = 442;
        int[] timingParameters = new int[]{960, 992, 106, 550, 104, 511, 145, 295, 394, 30};
        int[] flag = new int[]{927, 147, 728, 105, 16, 902, 792, 366, 936, 759, 39, 266, 792, 756, 876, 722, 693, 598, 79, 94};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof GdsTelemetry));
        GdsTelemetry item_ = (GdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveSdsTelemetry() throws Exception {
        short rebID = 5;
        int[] timingParameters = new int[]{960, 12, 943, 422, 817, 776, 849, 493, 761, 615};
        int[] flag = new int[]{20, 352, 640, 743, 285, 377, 89, 884, 961, 247, 229, 857, 153, 346, 772, 864, 816, 323, 255, 278};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof SdsTelemetry));
        SdsTelemetry item_ = (SdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGasTelemetry() throws Exception {
        short boardID = 978;
        float[] boardCurrent = new float[]{0.64201677f, 0.4715088f, 0.50902003f, 0.63220024f};
        float[] boardTemp = new float[]{0.5558464f, 0.1021713f, 0.90215826f, 0.4317305f, 0.5601807f, 0.75105715f, 0.43343014f, 0.8926217f, 0.9593026f, 0.04695213f, 0.075282216f, 0.6676659f};
        float[] boardVoltage = new float[]{0.2685765f, 0.26970363f, 0.51194763f, 0.26749486f};
        int[] cabacMUX = new int[]{554, 261, 876, 179};
        short ccdID = 759;
        int ccdtemp = 738;
        int[] fpgaCheckSum = new int[]{56, 323};
        short rebID = 290;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof GasTelemetry));
        GasTelemetry item_ = (GasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceivePcmsTelemetry() throws Exception {
        short biasStatus = 530;
        float biasCurrent = 0.45652407f;
        float biasVoltage = 0.77292246f;
        short clockStatus = 54;
        short clockCurrent = 601;
        float clockVoltage = 0.011489689f;
        short fpgaStatus = 340;
        float fpgaCurrent = 0.6930427f;
        float fpgaVoltage = 0.77683115f;
        short lowStatus = 164;
        float lowCurrent = 0.8903203f;
        short lowVoltage = 51;
        short odStatus = 230;
        float odCurrent = 0.4258297f;
        float odVoltage = 0.053610384f;
        float rebID = 0.24392968f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PcmsTelemetry(biasStatus, biasCurrent, biasVoltage, clockStatus, clockCurrent, clockVoltage, fpgaStatus, fpgaCurrent, fpgaVoltage, lowStatus, lowCurrent, lowVoltage, odStatus, odCurrent, odVoltage, rebID));
        Assert.assertTrue((boolean)(item instanceof PcmsTelemetry));
        PcmsTelemetry item_ = (PcmsTelemetry)item;
        Assert.assertEquals((long)biasStatus, (long)item_.getBiasStatus());
        Assert.assertEquals((float)biasCurrent, (float)item_.getBiasCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)biasVoltage, (float)item_.getBiasVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)clockStatus, (long)item_.getClockStatus());
        Assert.assertEquals((long)clockCurrent, (long)item_.getClockCurrent());
        Assert.assertEquals((float)clockVoltage, (float)item_.getClockVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)fpgaStatus, (long)item_.getFpgaStatus());
        Assert.assertEquals((float)fpgaCurrent, (float)item_.getFpgaCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)fpgaVoltage, (float)item_.getFpgaVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)lowStatus, (long)item_.getLowStatus());
        Assert.assertEquals((float)lowCurrent, (float)item_.getLowCurrent(), (float)1.0E-6f);
        Assert.assertEquals((long)lowVoltage, (long)item_.getLowVoltage());
        Assert.assertEquals((long)odStatus, (long)item_.getOdStatus());
        Assert.assertEquals((float)odCurrent, (float)item_.getOdCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)odVoltage, (float)item_.getOdVoltage(), (float)1.0E-6f);
        Assert.assertEquals((float)rebID, (float)item_.getRebID(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveSasTelemetry() throws Exception {
        short boardID = 55;
        float[] boardCurrent = new float[]{0.664438f, 0.49324584f, 0.21087271f, 0.68430936f};
        float[] boardTemp = new float[]{0.5088151f, 0.9471758f, 0.24645013f, 0.14021534f, 0.7455449f, 0.7289993f, 0.40985757f, 0.38185102f, 0.37497604f, 0.74177843f, 0.08210707f, 0.80134714f};
        float[] boardVoltage = new float[]{0.773384f, 0.02753681f, 0.8756334f, 0.07495028f};
        int[] cabacMUX = new int[]{834, 57, 48, 288};
        short ccdID = 673;
        int ccdtemp = 287;
        int[] fpgaCheckSum = new int[]{508, 849};
        short rebID = 684;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof SasTelemetry));
        SasTelemetry item_ = (SasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveColdTelemetry() throws Exception {
        float[] compressorLoad = new float[]{0.725014f, 0.56564045f, 0.23044276f, 0.81361234f, 0.56374925f, 0.7748759f};
        float[] compressorSpeed = new float[]{0.55720896f, 0.6217286f, 0.14100736f, 0.9639228f, 0.46244025f, 0.47606295f};
        float[] dischargePressure = new float[]{0.45142865f, 0.22423041f, 0.5843902f, 0.7225638f, 0.97311574f, 0.3730232f};
        float[] dischargeTemp = new float[]{0.3244326f, 0.11809343f, 0.14921409f, 0.55918217f, 0.5470287f, 0.79782516f};
        short[] flowInterlock = new short[]{642, 948, 914, 225, 14, 2};
        float[] heaterCurrent = new float[]{0.757791f, 0.32069433f, 0.61010224f, 0.4256962f, 0.25409085f, 0.69308966f};
        float[] heaterVoltage = new float[]{0.11766535f, 0.17105383f, 0.3179798f, 0.99313754f, 0.49693203f, 0.47408754f};
        float[] intakeFlow = new float[]{0.31805003f, 0.39571905f, 0.4318617f, 0.68852544f, 0.90788734f, 0.48430747f};
        float[] intakePressure = new float[]{0.6080067f, 0.92334574f, 0.24350768f, 0.28825122f, 0.73312366f, 0.6507946f};
        float[] intakeTemp = new float[]{0.9513334f, 0.6948141f, 0.091041505f, 0.5089883f, 0.31607246f, 0.64782596f};
        float[] ionPump = new float[]{0.97983956f, 0.3926283f, 0.7510979f, 0.8851513f};
        short[] mechPump = new short[]{258, 998, 410, 728};
        float[] postExpansionPressure = new float[]{0.9607942f, 0.38068634f, 0.7788728f, 0.48019898f, 0.987775f, 0.4404745f};
        float[] postExpansionTemp = new float[]{0.32937318f, 0.4958784f, 0.6876863f, 0.56839395f, 0.42152137f, 0.74160457f};
        float[] preExpansionPressure = new float[]{0.70746773f, 0.87280655f, 0.5851613f, 0.2281056f, 0.5251348f, 0.22448945f};
        float[] preExpansionTemp = new float[]{0.13484722f, 0.785979f, 0.36149693f, 0.8780798f, 0.77848995f, 0.2296859f};
        int[] rga = new int[]{259, 803, 284, 374, 598, 540, 359, 978, 352, 601};
        float[] returnTemp = new float[]{0.48347563f, 0.95595574f, 0.09901911f, 0.36171508f, 0.8507198f, 0.81304663f};
        float utilityRoomTemperature = 0.4670303f;
        float[] vacuumGauge = new float[]{0.42893237f, 0.6161232f, 0.59781915f, 0.5353048f, 0.40111113f};
        short[] valveStatus = new short[]{183, 59, 546, 633, 308, 447};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ColdTelemetry(compressorLoad, compressorSpeed, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, ionPump, mechPump, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, rga, returnTemp, utilityRoomTemperature, vacuumGauge, valveStatus));
        Assert.assertTrue((boolean)(item instanceof ColdTelemetry));
        ColdTelemetry item_ = (ColdTelemetry)item;
        Assert.assertArrayEquals((float[])compressorLoad, (float[])item_.getCompressorLoad(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])ionPump, (float[])item_.getIonPump(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])mechPump, (short[])item_.getMechPump());
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])rga, (int[])item_.getRga());
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)utilityRoomTemperature, (float)item_.getUtilityRoomTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])vacuumGauge, (float[])item_.getVacuumGauge(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])valveStatus, (short[])item_.getValveStatus());
    }
}

