package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class WdsTelemetry extends CameraTelemetry {
  private final short rebID;

  private final int[] timingParameters;

  private final int[] flag;

  public WdsTelemetry(short rebID, int[] timingParameters, int[] flag) {
    this.rebID = rebID;
    this.timingParameters = timingParameters;
    this.flag = flag;
  }

  public short getRebID() {
    return rebID;
  }

  public int[] getTimingParameters() {
    return timingParameters;
  }

  public int[] getFlag() {
    return flag;
  }

  @Override
  public String toString() {
    return "WdsTelemetry{" + "rebID=" + rebID +
        ", timingParameters=" + Arrays.toString(timingParameters) +
        ", flag=" + Arrays.toString(flag) +"}";
  }
}
