package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class WasTelemetry extends CameraTelemetry {
  private final short boardID;

  private final float[] boardCurrent;

  private final float[] boardTemp;

  private final float[] boardVoltage;

  private final int[] cabacMUX;

  private final short ccdID;

  private final int ccdtemp;

  private final int[] fpgaCheckSum;

  private final short rebID;

  public WasTelemetry(short boardID, float[] boardCurrent, float[] boardTemp, float[] boardVoltage,
      int[] cabacMUX, short ccdID, int ccdtemp, int[] fpgaCheckSum, short rebID) {
    this.boardID = boardID;
    this.boardCurrent = boardCurrent;
    this.boardTemp = boardTemp;
    this.boardVoltage = boardVoltage;
    this.cabacMUX = cabacMUX;
    this.ccdID = ccdID;
    this.ccdtemp = ccdtemp;
    this.fpgaCheckSum = fpgaCheckSum;
    this.rebID = rebID;
  }

  public short getBoardID() {
    return boardID;
  }

  public float[] getBoardCurrent() {
    return boardCurrent;
  }

  public float[] getBoardTemp() {
    return boardTemp;
  }

  public float[] getBoardVoltage() {
    return boardVoltage;
  }

  public int[] getCabacMUX() {
    return cabacMUX;
  }

  public short getCcdID() {
    return ccdID;
  }

  public int getCcdtemp() {
    return ccdtemp;
  }

  public int[] getFpgaCheckSum() {
    return fpgaCheckSum;
  }

  public short getRebID() {
    return rebID;
  }

  @Override
  public String toString() {
    return "WasTelemetry{" + "boardID=" + boardID +
        ", boardCurrent=" + Arrays.toString(boardCurrent) +
        ", boardTemp=" + Arrays.toString(boardTemp) +
        ", boardVoltage=" + Arrays.toString(boardVoltage) +
        ", cabacMUX=" + Arrays.toString(cabacMUX) +", ccdID=" + ccdID +", ccdtemp=" + ccdtemp +
        ", fpgaCheckSum=" + Arrays.toString(fpgaCheckSum) +", rebID=" + rebID +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private short boardID;

    private float[] boardCurrent;

    private float[] boardTemp;

    private float[] boardVoltage;

    private int[] cabacMUX;

    private short ccdID;

    private int ccdtemp;

    private int[] fpgaCheckSum;

    private short rebID;

    private Builder() {
    }

    public Builder boardID(short boardID) {
      this.boardID = boardID;
      return this;
    }

    public Builder boardCurrent(float[] boardCurrent) {
      this.boardCurrent = boardCurrent;
      return this;
    }

    public Builder boardTemp(float[] boardTemp) {
      this.boardTemp = boardTemp;
      return this;
    }

    public Builder boardVoltage(float[] boardVoltage) {
      this.boardVoltage = boardVoltage;
      return this;
    }

    public Builder cabacMUX(int[] cabacMUX) {
      this.cabacMUX = cabacMUX;
      return this;
    }

    public Builder ccdID(short ccdID) {
      this.ccdID = ccdID;
      return this;
    }

    public Builder ccdtemp(int ccdtemp) {
      this.ccdtemp = ccdtemp;
      return this;
    }

    public Builder fpgaCheckSum(int[] fpgaCheckSum) {
      this.fpgaCheckSum = fpgaCheckSum;
      return this;
    }

    public Builder rebID(short rebID) {
      this.rebID = rebID;
      return this;
    }

    public WasTelemetry build() {
      return new WasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID);
    }
  }
}
