package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class ColdTelemetry extends CameraTelemetry {
  private final float[] compressorLoad;

  private final float[] compressorSpeed;

  private final float[] dischargePressure;

  private final float[] dischargeTemp;

  private final short[] flowInterlock;

  private final float[] heaterCurrent;

  private final float[] heaterVoltage;

  private final float[] intakeFlow;

  private final float[] intakePressure;

  private final float[] intakeTemp;

  private final float[] ionPump;

  private final short[] mechPump;

  private final float[] postExpansionPressure;

  private final float[] postExpansionTemp;

  private final float[] preExpansionPressure;

  private final float[] preExpansionTemp;

  private final int[] rga;

  private final float[] returnTemp;

  private final float utilityRoomTemperature;

  private final float[] vacuumGauge;

  private final short[] valveStatus;

  public ColdTelemetry(float[] compressorLoad, float[] compressorSpeed, float[] dischargePressure,
      float[] dischargeTemp, short[] flowInterlock, float[] heaterCurrent, float[] heaterVoltage,
      float[] intakeFlow, float[] intakePressure, float[] intakeTemp, float[] ionPump,
      short[] mechPump, float[] postExpansionPressure, float[] postExpansionTemp,
      float[] preExpansionPressure, float[] preExpansionTemp, int[] rga, float[] returnTemp,
      float utilityRoomTemperature, float[] vacuumGauge, short[] valveStatus) {
    this.compressorLoad = compressorLoad;
    this.compressorSpeed = compressorSpeed;
    this.dischargePressure = dischargePressure;
    this.dischargeTemp = dischargeTemp;
    this.flowInterlock = flowInterlock;
    this.heaterCurrent = heaterCurrent;
    this.heaterVoltage = heaterVoltage;
    this.intakeFlow = intakeFlow;
    this.intakePressure = intakePressure;
    this.intakeTemp = intakeTemp;
    this.ionPump = ionPump;
    this.mechPump = mechPump;
    this.postExpansionPressure = postExpansionPressure;
    this.postExpansionTemp = postExpansionTemp;
    this.preExpansionPressure = preExpansionPressure;
    this.preExpansionTemp = preExpansionTemp;
    this.rga = rga;
    this.returnTemp = returnTemp;
    this.utilityRoomTemperature = utilityRoomTemperature;
    this.vacuumGauge = vacuumGauge;
    this.valveStatus = valveStatus;
  }

  public float[] getCompressorLoad() {
    return compressorLoad;
  }

  public float[] getCompressorSpeed() {
    return compressorSpeed;
  }

  public float[] getDischargePressure() {
    return dischargePressure;
  }

  public float[] getDischargeTemp() {
    return dischargeTemp;
  }

  public short[] getFlowInterlock() {
    return flowInterlock;
  }

  public float[] getHeaterCurrent() {
    return heaterCurrent;
  }

  public float[] getHeaterVoltage() {
    return heaterVoltage;
  }

  public float[] getIntakeFlow() {
    return intakeFlow;
  }

  public float[] getIntakePressure() {
    return intakePressure;
  }

  public float[] getIntakeTemp() {
    return intakeTemp;
  }

  public float[] getIonPump() {
    return ionPump;
  }

  public short[] getMechPump() {
    return mechPump;
  }

  public float[] getPostExpansionPressure() {
    return postExpansionPressure;
  }

  public float[] getPostExpansionTemp() {
    return postExpansionTemp;
  }

  public float[] getPreExpansionPressure() {
    return preExpansionPressure;
  }

  public float[] getPreExpansionTemp() {
    return preExpansionTemp;
  }

  public int[] getRga() {
    return rga;
  }

  public float[] getReturnTemp() {
    return returnTemp;
  }

  public float getUtilityRoomTemperature() {
    return utilityRoomTemperature;
  }

  public float[] getVacuumGauge() {
    return vacuumGauge;
  }

  public short[] getValveStatus() {
    return valveStatus;
  }

  @Override
  public String toString() {
    return "ColdTelemetry{" + "compressorLoad=" + Arrays.toString(compressorLoad) +
        ", compressorSpeed=" + Arrays.toString(compressorSpeed) +
        ", dischargePressure=" + Arrays.toString(dischargePressure) +
        ", dischargeTemp=" + Arrays.toString(dischargeTemp) +
        ", flowInterlock=" + Arrays.toString(flowInterlock) +
        ", heaterCurrent=" + Arrays.toString(heaterCurrent) +
        ", heaterVoltage=" + Arrays.toString(heaterVoltage) +
        ", intakeFlow=" + Arrays.toString(intakeFlow) +
        ", intakePressure=" + Arrays.toString(intakePressure) +
        ", intakeTemp=" + Arrays.toString(intakeTemp) +", ionPump=" + Arrays.toString(ionPump) +
        ", mechPump=" + Arrays.toString(mechPump) +
        ", postExpansionPressure=" + Arrays.toString(postExpansionPressure) +
        ", postExpansionTemp=" + Arrays.toString(postExpansionTemp) +
        ", preExpansionPressure=" + Arrays.toString(preExpansionPressure) +
        ", preExpansionTemp=" + Arrays.toString(preExpansionTemp) +", rga=" + Arrays.toString(rga) +
        ", returnTemp=" + Arrays.toString(returnTemp) +
        ", utilityRoomTemperature=" + utilityRoomTemperature +
        ", vacuumGauge=" + Arrays.toString(vacuumGauge) +
        ", valveStatus=" + Arrays.toString(valveStatus) +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private float[] compressorLoad;

    private float[] compressorSpeed;

    private float[] dischargePressure;

    private float[] dischargeTemp;

    private short[] flowInterlock;

    private float[] heaterCurrent;

    private float[] heaterVoltage;

    private float[] intakeFlow;

    private float[] intakePressure;

    private float[] intakeTemp;

    private float[] ionPump;

    private short[] mechPump;

    private float[] postExpansionPressure;

    private float[] postExpansionTemp;

    private float[] preExpansionPressure;

    private float[] preExpansionTemp;

    private int[] rga;

    private float[] returnTemp;

    private float utilityRoomTemperature;

    private float[] vacuumGauge;

    private short[] valveStatus;

    private Builder() {
    }

    public Builder compressorLoad(float[] compressorLoad) {
      this.compressorLoad = compressorLoad;
      return this;
    }

    public Builder compressorSpeed(float[] compressorSpeed) {
      this.compressorSpeed = compressorSpeed;
      return this;
    }

    public Builder dischargePressure(float[] dischargePressure) {
      this.dischargePressure = dischargePressure;
      return this;
    }

    public Builder dischargeTemp(float[] dischargeTemp) {
      this.dischargeTemp = dischargeTemp;
      return this;
    }

    public Builder flowInterlock(short[] flowInterlock) {
      this.flowInterlock = flowInterlock;
      return this;
    }

    public Builder heaterCurrent(float[] heaterCurrent) {
      this.heaterCurrent = heaterCurrent;
      return this;
    }

    public Builder heaterVoltage(float[] heaterVoltage) {
      this.heaterVoltage = heaterVoltage;
      return this;
    }

    public Builder intakeFlow(float[] intakeFlow) {
      this.intakeFlow = intakeFlow;
      return this;
    }

    public Builder intakePressure(float[] intakePressure) {
      this.intakePressure = intakePressure;
      return this;
    }

    public Builder intakeTemp(float[] intakeTemp) {
      this.intakeTemp = intakeTemp;
      return this;
    }

    public Builder ionPump(float[] ionPump) {
      this.ionPump = ionPump;
      return this;
    }

    public Builder mechPump(short[] mechPump) {
      this.mechPump = mechPump;
      return this;
    }

    public Builder postExpansionPressure(float[] postExpansionPressure) {
      this.postExpansionPressure = postExpansionPressure;
      return this;
    }

    public Builder postExpansionTemp(float[] postExpansionTemp) {
      this.postExpansionTemp = postExpansionTemp;
      return this;
    }

    public Builder preExpansionPressure(float[] preExpansionPressure) {
      this.preExpansionPressure = preExpansionPressure;
      return this;
    }

    public Builder preExpansionTemp(float[] preExpansionTemp) {
      this.preExpansionTemp = preExpansionTemp;
      return this;
    }

    public Builder rga(int[] rga) {
      this.rga = rga;
      return this;
    }

    public Builder returnTemp(float[] returnTemp) {
      this.returnTemp = returnTemp;
      return this;
    }

    public Builder utilityRoomTemperature(float utilityRoomTemperature) {
      this.utilityRoomTemperature = utilityRoomTemperature;
      return this;
    }

    public Builder vacuumGauge(float[] vacuumGauge) {
      this.vacuumGauge = vacuumGauge;
      return this;
    }

    public Builder valveStatus(short[] valveStatus) {
      this.valveStatus = valveStatus;
      return this;
    }

    public ColdTelemetry build() {
      return new ColdTelemetry(compressorLoad, compressorSpeed, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, ionPump, mechPump, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, rga, returnTemp, utilityRoomTemperature, vacuumGauge, valveStatus);
    }
  }
}
