package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class ClusterEncoderTelemetry extends CameraTelemetry {
  private final float[] imageSD;

  private final float[] imageMean;

  private final float[] overscanSD;

  private final float[] overscanMean;

  private final float[] psf;

  public ClusterEncoderTelemetry(float[] imageSD, float[] imageMean, float[] overscanSD,
      float[] overscanMean, float[] psf) {
    this.imageSD = imageSD;
    this.imageMean = imageMean;
    this.overscanSD = overscanSD;
    this.overscanMean = overscanMean;
    this.psf = psf;
  }

  public float[] getImageSD() {
    return imageSD;
  }

  public float[] getImageMean() {
    return imageMean;
  }

  public float[] getOverscanSD() {
    return overscanSD;
  }

  public float[] getOverscanMean() {
    return overscanMean;
  }

  public float[] getPsf() {
    return psf;
  }

  @Override
  public String toString() {
    return "ClusterEncoderTelemetry{" + "imageSD=" + Arrays.toString(imageSD) +
        ", imageMean=" + Arrays.toString(imageMean) +", overscanSD=" + Arrays.toString(overscanSD) +
        ", overscanMean=" + Arrays.toString(overscanMean) +", psf=" + Arrays.toString(psf) +"}";
  }
}
