/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.CCSTelemetry;
import org.lsst.sal.camera.telemetry.ClusterEncoderTelemetry;
import org.lsst.sal.camera.telemetry.ColdTelemetry;
import org.lsst.sal.camera.telemetry.CyroTelemetry;
import org.lsst.sal.camera.telemetry.FilterTelemetry;
import org.lsst.sal.camera.telemetry.GasTelemetry;
import org.lsst.sal.camera.telemetry.GdsTelemetry;
import org.lsst.sal.camera.telemetry.HeartbeatTelemetry;
import org.lsst.sal.camera.telemetry.PcmsTelemetry;
import org.lsst.sal.camera.telemetry.ProtTelemetry;
import org.lsst.sal.camera.telemetry.PurgeTelemetry;
import org.lsst.sal.camera.telemetry.SasTelemetry;
import org.lsst.sal.camera.telemetry.SdsTelemetry;
import org.lsst.sal.camera.telemetry.ShutterTelemetry;
import org.lsst.sal.camera.telemetry.WasTelemetry;
import org.lsst.sal.camera.telemetry.WdsTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveShutterTelemetry() throws Exception {
        short[] bladeHome = new short[]{827, 74};
        float[] closeProfile = new float[]{0.76328856f, 0.29622638f, 0.11591315f, 0.4327585f, 0.03410977f, 0.3431815f, 0.30898368f, 0.087475955f, 0.5024643f, 0.5691242f, 0.33874393f, 0.2125802f, 0.61208856f, 0.60701907f, 0.726321f, 0.7670446f, 0.6325419f, 0.14544326f, 0.15658772f, 0.20130384f, 0.49040705f, 0.6301425f, 0.57159907f, 0.93082523f};
        float[] motorCurrent = new float[]{0.8303445f, 0.08115542f};
        float[] motorTemp = new float[]{0.41710728f, 0.51619023f};
        short openDirection = 130;
        float[] openProfile = new float[]{0.2256726f, 0.68357563f, 0.49712306f, 0.46246642f, 0.37017685f, 0.18240207f, 0.1282174f, 0.7758813f, 0.7670015f, 0.8115732f, 0.95828426f, 0.728636f, 0.19857323f, 0.4796157f, 0.25690705f, 0.5727071f, 0.83871365f, 0.100034475f, 0.02270621f, 0.18902206f, 0.3390364f, 0.2585823f, 0.5878645f, 0.32090956f};
        String profileFunction = "nrfolwdtagkeleuhhbztttdrsfjbgqdfsneofxskfdzvsqrtwmkxgioicdkgcpziuossdxmcxmlcxrosfkxcodszzakszruqckzqjtwiovgnykacsgwxhlgvhxrnqlwqlejqqincqyaheyukoixjxrficebtxgewpomwrufkjqfrgndwfaycrneiehwmdnkemwkgpehebirroscmsbtbwmg";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ShutterTelemetry(bladeHome, closeProfile, motorCurrent, motorTemp, openDirection, openProfile, profileFunction));
        Assert.assertTrue((boolean)(item instanceof ShutterTelemetry));
        ShutterTelemetry item_ = (ShutterTelemetry)item;
        Assert.assertArrayEquals((short[])bladeHome, (short[])item_.getBladeHome());
        Assert.assertArrayEquals((float[])closeProfile, (float[])item_.getCloseProfile(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorCurrent, (float[])item_.getMotorCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorTemp, (float[])item_.getMotorTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)openDirection, (long)item_.getOpenDirection());
        Assert.assertArrayEquals((float[])openProfile, (float[])item_.getOpenProfile(), (float)1.0E-6f);
        Assert.assertEquals((Object)profileFunction, (Object)item_.getProfileFunction());
    }

    @Test
    public void sendReceiveProtTelemetry() throws Exception {
        int[] status = new int[]{980, 163};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ProtTelemetry(status));
        Assert.assertTrue((boolean)(item instanceof ProtTelemetry));
        ProtTelemetry item_ = (ProtTelemetry)item;
        Assert.assertArrayEquals((int[])status, (int[])item_.getStatus());
    }

    @Test
    public void sendReceiveFilterTelemetry() throws Exception {
        int loaderTelemetry = 780;
        short rebID = 68;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterTelemetry(loaderTelemetry, rebID));
        Assert.assertTrue((boolean)(item instanceof FilterTelemetry));
        FilterTelemetry item_ = (FilterTelemetry)item;
        Assert.assertEquals((long)loaderTelemetry, (long)item_.getLoaderTelemetry());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveHeartbeatTelemetry() throws Exception {
        boolean heartbeat = false;
        int priority = 831;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new HeartbeatTelemetry(heartbeat, priority));
        Assert.assertTrue((boolean)(item instanceof HeartbeatTelemetry));
        HeartbeatTelemetry item_ = (HeartbeatTelemetry)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveWasTelemetry() throws Exception {
        short boardID = 356;
        float[] boardCurrent = new float[]{0.65392965f, 0.17105341f, 0.32642913f, 0.17832279f};
        float[] boardTemp = new float[]{0.59132904f, 0.21629053f, 0.585883f, 0.54648966f, 0.8570885f, 0.60224223f, 0.028786123f, 0.31259924f, 0.33504725f, 0.70348465f, 0.48716873f, 0.3174442f};
        float[] boardVoltage = new float[]{0.46432948f, 0.29730546f, 0.0031346083f, 0.105174005f};
        int[] cabacMUX = new int[]{406, 889, 32, 65};
        short ccdID = 812;
        int ccdtemp = 349;
        int[] fpgaCheckSum = new int[]{318, 558};
        short rebID = 584;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof WasTelemetry));
        WasTelemetry item_ = (WasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveCCSTelemetry() throws Exception {
        int[] ccsStatus = new int[]{469, 609, 695, 647, 906, 499, 95, 337, 15, 60, 617, 953, 622, 768, 36, 607, 278, 530, 879, 110};
        int[] imageStatus = new int[]{794, 46, 38, 993, 785, 971, 969, 41, 197, 199, 93, 906, 258, 965, 266, 428, 253, 594, 521, 612};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CCSTelemetry(ccsStatus, imageStatus));
        Assert.assertTrue((boolean)(item instanceof CCSTelemetry));
        CCSTelemetry item_ = (CCSTelemetry)item;
        Assert.assertArrayEquals((int[])ccsStatus, (int[])item_.getCcsStatus());
        Assert.assertArrayEquals((int[])imageStatus, (int[])item_.getImageStatus());
    }

    @Test
    public void sendReceiveClusterEncoderTelemetry() throws Exception {
        float[] imageSD = new float[]{0.021574795f, 0.59101915f, 0.8295904f, 0.71529776f, 0.49980235f, 0.3440103f, 0.4326051f, 0.21062565f, 0.07925898f, 0.2721265f, 0.4227059f, 0.5238474f, 0.600369f, 0.7923103f, 0.101676464f, 0.52289623f, 0.9924355f, 0.15684432f, 0.9987385f, 0.47297782f, 0.93405455f, 0.48599404f, 0.013784826f, 0.14531678f, 0.12934476f, 0.67723775f, 0.42665136f, 0.3735013f, 0.04779643f, 0.2569039f, 0.6709095f, 0.9702103f, 0.078682125f, 0.24574816f, 0.6333491f, 0.13586271f, 0.119746685f, 0.08891684f, 0.52616924f, 0.3023141f, 0.40137637f, 0.5835315f, 0.03028053f, 0.9788788f, 0.29183292f, 0.095071435f, 0.19555652f, 0.09001446f, 0.33974743f, 0.64875025f, 0.3559845f, 0.51495826f, 0.49334407f, 0.31671005f, 0.25121927f, 0.82604676f, 0.35138333f, 0.6892633f, 0.39591485f, 0.35660863f, 0.2112596f, 0.75238055f, 0.08741033f, 0.75904834f, 0.300897f, 0.7185729f, 0.9520105f, 0.7025131f, 0.8319878f, 0.9392833f, 0.58948046f, 0.6364537f, 0.76479393f, 0.019551396f, 0.2518608f, 0.9561854f, 0.50437135f, 0.35633576f, 0.9818012f, 0.05957359f, 0.18300074f, 0.11738366f, 0.7109484f, 0.80618876f, 0.95526606f, 0.8954678f, 0.28225982f, 0.67330027f, 0.5251776f, 0.031327665f, 0.5913362f, 0.35413134f, 0.32669246f, 0.65654963f, 0.24897677f, 0.8357329f, 0.7307541f, 0.5143061f, 0.6362953f, 0.81512636f};
        float[] imageMean = new float[]{0.8975062f, 0.36139202f, 0.56915474f, 0.11711925f, 0.4287027f, 0.4200098f, 0.20275605f, 0.035132706f, 0.5027276f, 0.7535496f, 0.310475f, 0.96286094f, 0.34638035f, 0.29910475f, 0.7620957f, 0.5705672f, 0.5701176f, 0.45319545f, 0.33221525f, 0.12193096f, 0.37634134f, 0.8193006f, 0.89465934f, 0.35780776f, 0.9562797f, 0.8701253f, 0.43627113f, 0.9899036f, 0.48584515f, 0.6284509f, 0.06454408f, 0.06368184f, 0.18351716f, 0.9429874f, 0.5275206f, 0.8448999f, 0.5258512f, 0.83552134f, 0.52855825f, 0.052761912f, 0.2538656f, 0.6691251f, 0.94847935f, 0.06510055f, 0.52461463f, 0.37117463f, 0.7069012f, 0.5332659f, 0.94816893f, 0.6169564f, 0.45495182f, 0.8080832f, 0.23556727f, 0.10788506f, 0.22299147f, 0.8505874f, 0.40576214f, 0.8716053f, 0.007391572f, 0.30508882f, 0.54998755f, 0.76891094f, 0.6060042f, 0.08595711f, 0.824268f, 0.1545369f, 0.6669414f, 0.8774278f, 0.8820336f, 0.33611572f, 0.34206152f, 0.087462485f, 0.3192116f, 0.1792404f, 0.40563303f, 0.017583013f, 0.78703463f, 0.87854385f, 0.55865216f, 0.8116311f, 0.33960134f, 0.65753907f, 0.56698114f, 0.39417303f, 0.8835062f, 0.46682012f, 0.13173908f, 0.38600725f, 0.54832006f, 0.7548995f, 0.04621786f, 0.43778813f, 0.6151736f, 0.11285722f, 0.41614866f, 0.6166311f, 0.745116f, 0.20814842f, 0.9986693f, 0.24381286f};
        float[] overscanSD = new float[]{0.51135975f, 0.48001832f, 0.117213964f, 0.7590519f, 0.23517823f, 0.76529574f, 0.03028369f, 0.8887019f, 0.38241404f, 0.4457968f, 0.045282245f, 0.24748898f, 0.027725935f, 0.0847016f, 0.37607938f, 0.8977768f, 0.32142735f, 0.46723914f, 0.6245751f, 0.7339741f, 0.3867373f, 0.7396143f, 0.5302887f, 0.52546227f, 0.4743011f, 0.09875047f, 0.06402588f, 0.2277928f, 0.5498887f, 0.51414365f, 0.15622997f, 0.7129836f, 0.2873063f, 0.9425869f, 0.040100098f, 0.3452611f, 0.8819695f, 0.74802613f, 0.8744506f, 0.07389665f, 0.34459049f, 0.77425283f, 0.5902373f, 0.6808578f, 0.33548397f, 0.09007406f, 0.70443845f, 0.02442491f, 0.9676601f, 0.5781851f, 0.6704366f, 0.092953384f, 0.8538468f, 0.65399295f, 0.51821005f, 0.22342896f, 0.46468568f, 0.7535202f, 0.49164075f, 0.2608568f, 0.27152407f, 0.23528773f, 0.85333914f, 0.81593496f, 0.28954864f, 0.80540466f, 0.31695497f, 0.21462613f, 0.34066665f, 0.94427f, 0.8284989f, 0.58450115f, 0.39886826f, 0.42422295f, 0.87537193f, 0.6650663f, 0.7452285f, 0.33771592f, 0.7063473f, 0.004302442f, 0.7798169f, 0.9732813f, 0.92755526f, 0.868564f, 0.35125768f, 0.8905129f, 0.856595f, 0.3706646f, 0.46235365f, 0.05489999f, 0.8053671f, 0.4498847f, 0.48599327f, 0.43867534f, 0.48635f, 0.6218813f, 0.32657474f, 0.0055295825f, 0.9392091f, 0.07578653f};
        float[] overscanMean = new float[]{0.73859596f, 0.046394527f, 0.52534467f, 0.21549892f, 0.6692019f, 0.8824235f, 0.4858775f, 0.12327844f, 0.6317869f, 0.60233015f, 0.4804054f, 0.43285573f, 0.80279744f, 0.7475592f, 0.17451727f, 0.51857966f, 0.526363f, 0.33413875f, 0.9065344f, 0.78451276f, 0.9271167f, 0.8289187f, 0.3993911f, 0.7363129f, 0.2895035f, 0.3452732f, 0.38123178f, 0.7683166f, 0.13407975f, 0.44489986f, 0.40556508f, 0.5431897f, 0.5829771f, 0.22437662f, 0.51419187f, 0.09218466f, 0.68616164f, 0.4145456f, 0.13724142f, 0.446424f, 0.10880494f, 0.75513387f, 0.576267f, 0.61530536f, 0.6425738f, 0.04444164f, 0.9483559f, 0.9643364f, 0.7876291f, 0.7632317f, 0.7895995f, 0.6842986f, 0.4984275f, 0.6825486f, 0.9111864f, 0.77508664f, 0.6389829f, 0.17711788f, 0.18508023f, 0.24498057f, 0.7491421f, 0.25989568f, 0.90110517f, 0.51920116f, 0.08285338f, 0.4505406f, 0.20379978f, 0.095731676f, 0.19567943f, 0.20298082f, 0.98423743f, 0.53253627f, 0.48837215f, 0.5973848f, 0.8959169f, 0.91506547f, 0.36575752f, 0.59288305f, 0.88967466f, 0.068546176f, 0.058166325f, 0.22311515f, 0.653375f, 0.24384958f, 0.64201677f, 0.4715088f, 0.50902003f, 0.63220024f, 0.5558464f, 0.1021713f, 0.90215826f, 0.4317305f, 0.5601807f, 0.75105715f, 0.43343014f, 0.8926217f, 0.9593026f, 0.04695213f, 0.075282216f, 0.6676659f};
        float[] psf = new float[]{0.2685765f, 0.26970363f, 0.51194763f, 0.26749486f, 0.853928f, 0.041564107f, 0.48947698f, 0.6060689f, 0.32494718f, 0.15466553f, 0.29480177f, 0.6795168f, 0.26758075f, 0.872297f, 0.45652407f, 0.77292246f, 0.8473112f, 0.80322593f, 0.011489689f, 0.17364383f, 0.6930427f, 0.77683115f, 0.07446909f, 0.8903203f, 0.5326937f, 0.47295874f, 0.4258297f, 0.053610384f, 0.24392968f, 0.95546806f, 0.664438f, 0.49324584f, 0.21087271f, 0.68430936f, 0.5088151f, 0.9471758f, 0.24645013f, 0.14021534f, 0.7455449f, 0.7289993f, 0.40985757f, 0.38185102f, 0.37497604f, 0.74177843f, 0.08210707f, 0.80134714f, 0.773384f, 0.02753681f, 0.8756334f, 0.07495028f, 0.33909255f, 0.64575577f, 0.76538277f, 0.9860984f, 0.6068594f, 0.4100852f, 0.110777795f, 0.98423976f, 0.2674836f, 0.725014f, 0.56564045f, 0.23044276f, 0.81361234f, 0.56374925f, 0.7748759f, 0.55720896f, 0.6217286f, 0.14100736f, 0.9639228f, 0.46244025f, 0.47606295f, 0.45142865f, 0.22423041f, 0.5843902f, 0.7225638f, 0.97311574f, 0.3730232f, 0.3244326f, 0.11809343f, 0.14921409f, 0.55918217f, 0.5470287f, 0.79782516f, 0.9469821f, 0.34314948f, 0.8814008f, 0.7366548f, 0.80753255f, 0.29442966f, 0.757791f, 0.32069433f, 0.61010224f, 0.4256962f, 0.25409085f, 0.69308966f, 0.11766535f, 0.17105383f, 0.3179798f, 0.99313754f, 0.49693203f, 0.47408754f, 0.31805003f, 0.39571905f, 0.4318617f, 0.68852544f, 0.90788734f, 0.48430747f, 0.6080067f, 0.92334574f, 0.24350768f, 0.28825122f, 0.73312366f, 0.6507946f, 0.9513334f, 0.6948141f, 0.091041505f, 0.5089883f, 0.31607246f, 0.64782596f, 0.97983956f, 0.3926283f, 0.7510979f, 0.8851513f, 0.35671014f, 0.96105033f, 0.17450577f, 0.09201777f, 0.9607942f, 0.38068634f, 0.7788728f, 0.48019898f, 0.987775f, 0.4404745f, 0.32937318f, 0.4958784f, 0.6876863f, 0.56839395f, 0.42152137f, 0.74160457f, 0.70746773f, 0.87280655f, 0.5851613f, 0.2281056f, 0.5251348f, 0.22448945f, 0.13484722f, 0.785979f, 0.36149693f, 0.8780798f, 0.77848995f, 0.2296859f, 0.7122565f, 0.952198f, 0.13673967f, 0.6192258f, 0.33778584f, 0.69596547f, 0.06633496f, 0.47886324f, 0.6652513f, 0.26929963f, 0.48347563f, 0.95595574f, 0.09901911f, 0.36171508f, 0.8507198f, 0.81304663f, 0.4670303f, 0.42893237f, 0.6161232f, 0.59781915f, 0.5353048f, 0.40111113f, 0.31011975f, 0.9112754f, 0.2477749f, 0.12679148f, 0.23840517f, 0.055725396f, 0.65773356f, 0.4815923f, 0.42286444f, 0.48011905f, 0.7394168f, 0.36245394f, 0.693045f, 0.9182974f, 0.74834484f, 0.78191215f, 0.3141111f, 0.33139765f, 0.1473794f, 8.8083744E-4f, 0.8405324f, 0.19254524f, 0.45798522f, 0.32413626f, 0.73550195f, 0.09186447f, 0.624524f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ClusterEncoderTelemetry(imageSD, imageMean, overscanSD, overscanMean, psf));
        Assert.assertTrue((boolean)(item instanceof ClusterEncoderTelemetry));
        ClusterEncoderTelemetry item_ = (ClusterEncoderTelemetry)item;
        Assert.assertArrayEquals((float[])imageSD, (float[])item_.getImageSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])imageMean, (float[])item_.getImageMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanSD, (float[])item_.getOverscanSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanMean, (float[])item_.getOverscanMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])psf, (float[])item_.getPsf(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveCyroTelemetry() throws Exception {
        float[] coldTemperature = new float[]{0.5147181f, 0.81240964f, 0.4726234f};
        float compressor = 0.5007707f;
        float[] compressorSpeed = new float[]{0.14947772f, 0.49540645f};
        float[] cryoTemperature = new float[]{0.7430022f, 0.055093765f, 0.97883695f, 0.91059196f, 0.32867038f, 0.5323425f, 0.013417423f, 0.69769037f, 0.05334121f, 0.5605527f, 0.63562727f, 0.35490358f};
        float[] dischargePressure = new float[]{0.7501117f, 0.51883096f};
        float[] dischargeTemp = new float[]{0.22574902f, 0.7182397f};
        short[] flowInterlock = new short[]{961, 265};
        float[] heaterCurrent = new float[]{0.25287485f, 0.54291964f, 0.82644033f, 0.4044199f, 0.36763537f, 0.95101f};
        float[] heaterVoltage = new float[]{0.84263295f, 9.699464E-4f, 0.055625856f, 0.9793729f, 0.103371024f, 0.16762918f};
        float[] intakeFlow = new float[]{0.8804579f, 0.4891575f};
        float[] intakePressure = new float[]{0.98193365f, 0.11643481f};
        float[] intakeTemp = new float[]{0.22926104f, 0.056796134f};
        float[] postExpansionPressure = new float[]{0.21339798f, 0.41991132f};
        float[] postExpansionTemp = new float[]{0.9401851f, 0.07184994f};
        float[] preExpansionPressure = new float[]{0.45219064f, 0.50861824f};
        float[] preExpansionTemp = new float[]{0.8630732f, 0.4247344f};
        float[] returnTemp = new float[]{0.44716918f, 0.5448827f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CyroTelemetry(coldTemperature, compressor, compressorSpeed, cryoTemperature, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, returnTemp));
        Assert.assertTrue((boolean)(item instanceof CyroTelemetry));
        CyroTelemetry item_ = (CyroTelemetry)item;
        Assert.assertArrayEquals((float[])coldTemperature, (float[])item_.getColdTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)compressor, (float)item_.getCompressor(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])cryoTemperature, (float[])item_.getCryoTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
    }

    @Test
    public void sendReceivePurgeTelemetry() throws Exception {
        float[] accelerometer = new float[]{0.6061836f, 0.8236429f, 0.25778496f, 0.9509667f, 0.73196155f, 0.77177787f};
        float blowerSetting = 0.9057209f;
        float blowerSpeed = 0.0024883747f;
        float bodyFlowMeter = 0.964837f;
        float bodyTemp = 0.5408458f;
        float heaterCurrent = 0.29337072f;
        float heaters = 0.30691797f;
        int microphone = 280;
        float trunkFlowMeter = 0.46282715f;
        float trunkTemp = 0.75350183f;
        int valveSetting = 450;
        int valves = 371;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PurgeTelemetry(accelerometer, blowerSetting, blowerSpeed, bodyFlowMeter, bodyTemp, heaterCurrent, heaters, microphone, trunkFlowMeter, trunkTemp, valveSetting, valves));
        Assert.assertTrue((boolean)(item instanceof PurgeTelemetry));
        PurgeTelemetry item_ = (PurgeTelemetry)item;
        Assert.assertArrayEquals((float[])accelerometer, (float[])item_.getAccelerometer(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSetting, (float)item_.getBlowerSetting(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSpeed, (float)item_.getBlowerSpeed(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyFlowMeter, (float)item_.getBodyFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyTemp, (float)item_.getBodyTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)heaterCurrent, (float)item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)heaters, (float)item_.getHeaters(), (float)1.0E-6f);
        Assert.assertEquals((long)microphone, (long)item_.getMicrophone());
        Assert.assertEquals((float)trunkFlowMeter, (float)item_.getTrunkFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)trunkTemp, (float)item_.getTrunkTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)valveSetting, (long)item_.getValveSetting());
        Assert.assertEquals((long)valves, (long)item_.getValves());
    }

    @Test
    public void sendReceiveWdsTelemetry() throws Exception {
        short rebID = 15;
        int[] timingParameters = new int[]{280, 811, 185, 625, 336, 307, 945, 158, 476, 200};
        int[] flag = new int[]{346, 718, 883, 955, 500, 227, 5, 995, 355, 364, 993, 777, 152, 514, 906, 518, 286, 592, 710, 128};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof WdsTelemetry));
        WdsTelemetry item_ = (WdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGdsTelemetry() throws Exception {
        short rebID = 230;
        int[] timingParameters = new int[]{639, 931, 507, 976, 639, 302, 637, 814, 2, 873};
        int[] flag = new int[]{634, 894, 387, 264, 174, 461, 332, 881, 177, 586, 325, 286, 476, 238, 624, 591, 465, 334, 544, 488};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof GdsTelemetry));
        GdsTelemetry item_ = (GdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveSdsTelemetry() throws Exception {
        short rebID = 513;
        int[] timingParameters = new int[]{218, 18, 549, 72, 94, 220, 758, 882, 642, 43};
        int[] flag = new int[]{659, 233, 607, 272, 245, 182, 649, 26, 358, 573, 76, 839, 262, 189, 20, 67, 915, 924, 469, 140};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof SdsTelemetry));
        SdsTelemetry item_ = (SdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGasTelemetry() throws Exception {
        short boardID = 372;
        float[] boardCurrent = new float[]{0.6178314f, 0.09379089f, 0.3732726f, 0.3123772f};
        float[] boardTemp = new float[]{0.34344143f, 0.37719345f, 0.37783432f, 0.22163934f, 0.55179244f, 0.651653f, 0.5180367f, 0.97135127f, 0.608476f, 0.22524887f, 0.96301264f, 0.06866783f};
        float[] boardVoltage = new float[]{0.34441042f, 0.22022235f, 0.32170266f, 0.83380437f};
        int[] cabacMUX = new int[]{778, 930, 886, 622};
        short ccdID = 385;
        int ccdtemp = 454;
        int[] fpgaCheckSum = new int[]{545, 224};
        short rebID = 994;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof GasTelemetry));
        GasTelemetry item_ = (GasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceivePcmsTelemetry() throws Exception {
        short biasStatus = 526;
        float biasCurrent = 0.9183059f;
        float biasVoltage = 0.29094613f;
        short clockStatus = 838;
        short clockCurrent = 189;
        float clockVoltage = 0.5121147f;
        short fpgaStatus = 214;
        float fpgaCurrent = 0.8564506f;
        float fpgaVoltage = 0.4120152f;
        short lowStatus = 764;
        float lowCurrent = 0.63176143f;
        short lowVoltage = 204;
        short odStatus = 450;
        float odCurrent = 0.26769376f;
        float odVoltage = 0.41402632f;
        float rebID = 0.19649518f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PcmsTelemetry(biasStatus, biasCurrent, biasVoltage, clockStatus, clockCurrent, clockVoltage, fpgaStatus, fpgaCurrent, fpgaVoltage, lowStatus, lowCurrent, lowVoltage, odStatus, odCurrent, odVoltage, rebID));
        Assert.assertTrue((boolean)(item instanceof PcmsTelemetry));
        PcmsTelemetry item_ = (PcmsTelemetry)item;
        Assert.assertEquals((long)biasStatus, (long)item_.getBiasStatus());
        Assert.assertEquals((float)biasCurrent, (float)item_.getBiasCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)biasVoltage, (float)item_.getBiasVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)clockStatus, (long)item_.getClockStatus());
        Assert.assertEquals((long)clockCurrent, (long)item_.getClockCurrent());
        Assert.assertEquals((float)clockVoltage, (float)item_.getClockVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)fpgaStatus, (long)item_.getFpgaStatus());
        Assert.assertEquals((float)fpgaCurrent, (float)item_.getFpgaCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)fpgaVoltage, (float)item_.getFpgaVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)lowStatus, (long)item_.getLowStatus());
        Assert.assertEquals((float)lowCurrent, (float)item_.getLowCurrent(), (float)1.0E-6f);
        Assert.assertEquals((long)lowVoltage, (long)item_.getLowVoltage());
        Assert.assertEquals((long)odStatus, (long)item_.getOdStatus());
        Assert.assertEquals((float)odCurrent, (float)item_.getOdCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)odVoltage, (float)item_.getOdVoltage(), (float)1.0E-6f);
        Assert.assertEquals((float)rebID, (float)item_.getRebID(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveSasTelemetry() throws Exception {
        short boardID = 63;
        float[] boardCurrent = new float[]{0.41995746f, 0.8990327f, 0.8155597f, 0.65469944f};
        float[] boardTemp = new float[]{0.22514522f, 0.926028f, 0.661967f, 0.46607977f, 0.9350161f, 0.6609916f, 0.92892903f, 0.2519201f, 0.24715221f, 0.07819593f, 0.68156976f, 0.6558336f};
        float[] boardVoltage = new float[]{0.03810513f, 0.07685894f, 0.90088737f, 0.25283664f};
        int[] cabacMUX = new int[]{52, 998, 21, 148};
        short ccdID = 231;
        int ccdtemp = 16;
        int[] fpgaCheckSum = new int[]{47, 576};
        short rebID = 530;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof SasTelemetry));
        SasTelemetry item_ = (SasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveColdTelemetry() throws Exception {
        float[] compressorLoad = new float[]{0.4996801f, 0.28035337f, 0.5281224f, 0.8113967f, 0.20921391f, 0.919331f};
        float[] compressorSpeed = new float[]{0.15211505f, 0.1929841f, 0.18480426f, 0.46555334f, 0.57001895f, 0.0494743f};
        float[] dischargePressure = new float[]{0.100367725f, 0.09727442f, 0.24976319f, 0.14794374f, 0.09035599f, 0.50681186f};
        float[] dischargeTemp = new float[]{0.5165084f, 0.9408082f, 0.26719368f, 0.8248472f, 0.053814054f, 0.5187244f};
        short[] flowInterlock = new short[]{732, 385, 640, 409, 726, 767};
        float[] heaterCurrent = new float[]{0.4572158f, 0.83463997f, 0.19628906f, 0.29260403f, 0.6542793f, 0.37268287f};
        float[] heaterVoltage = new float[]{0.46251094f, 0.3193243f, 0.3706587f, 0.88690907f, 0.99370396f, 0.1980843f};
        float[] intakeFlow = new float[]{0.15577364f, 0.65969664f, 0.044072628f, 0.35289842f, 0.26424748f, 0.71716636f};
        float[] intakePressure = new float[]{0.31904346f, 0.6289816f, 0.34782183f, 0.4623984f, 0.033944964f, 0.52440447f};
        float[] intakeTemp = new float[]{0.11709833f, 0.47953242f, 0.78264666f, 0.6695271f, 0.5121549f, 0.26177055f};
        float[] ionPump = new float[]{0.27514833f, 0.85136896f, 0.09483904f, 0.28809005f};
        short[] mechPump = new short[]{78, 763, 291, 876};
        float[] postExpansionPressure = new float[]{0.27921462f, 0.8730942f, 0.8501835f, 0.35790187f, 0.8696877f, 0.86267406f};
        float[] postExpansionTemp = new float[]{0.82564783f, 0.4204433f, 0.3785746f, 0.95583016f, 0.07319802f, 0.9752457f};
        float[] preExpansionPressure = new float[]{0.3518139f, 0.9940738f, 0.76298124f, 0.40967506f, 0.1955548f, 0.81881803f};
        float[] preExpansionTemp = new float[]{0.8055725f, 0.091529965f, 0.5571169f, 0.5297868f, 0.1083616f, 0.81703424f};
        int[] rga = new int[]{288, 549, 827, 260, 949, 84, 274, 152, 827, 710};
        float[] returnTemp = new float[]{0.6231984f, 0.8787864f, 0.7579361f, 0.1715014f, 0.8883354f, 0.14395869f};
        float utilityRoomTemperature = 0.018800735f;
        float[] vacuumGauge = new float[]{0.3617394f, 0.79723173f, 0.8253457f, 0.8163587f, 0.54579103f};
        short[] valveStatus = new short[]{652, 902, 229, 197, 504, 621};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ColdTelemetry(compressorLoad, compressorSpeed, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, ionPump, mechPump, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, rga, returnTemp, utilityRoomTemperature, vacuumGauge, valveStatus));
        Assert.assertTrue((boolean)(item instanceof ColdTelemetry));
        ColdTelemetry item_ = (ColdTelemetry)item;
        Assert.assertArrayEquals((float[])compressorLoad, (float[])item_.getCompressorLoad(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])ionPump, (float[])item_.getIonPump(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])mechPump, (short[])item_.getMechPump());
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])rga, (int[])item_.getRga());
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)utilityRoomTemperature, (float)item_.getUtilityRoomTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])vacuumGauge, (float[])item_.getVacuumGauge(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])valveStatus, (short[])item_.getValveStatus());
    }
}

