/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AuthListEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 899;
        String imageType = "";
        String groupId = "e";
        String additionalKeys = "";
        String additionalValues = "j";
        int imagesInSequence = 902;
        String imageName = "lpkystpmanw";
        int imageIndex = 564;
        String imageSource = "n";
        String imageController = "d";
        String imageDate = "sqfvxu";
        int imageNumber = 782;
        double timeStampAcquisitionStart = 0.3559340238571167;
        double exposureTime = 0.24237751960754395;
        double timeStampEndOfReadout = 0.9880634546279907;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampEndOfReadout, (double)item_.getTimeStampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 456;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 418;
        String filterName = "fomtyjrzxwfucnamoaezfanauhnnootuhjusprpmldiutxsqcaageunvdyvuwxmpzbhnnlfaodrmazjfkyewrpjmwrtkaigzuaqyzmyymnpodojhymuggilkxlhgpseuuibuyrlojdhzqoveaoljumwxnuioaorfjzvnqofqitxyuovvualrabkzcmdpadrmgbelsctwtzrcarsgmdvjveke";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 866;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 838;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 138;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 962;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 277;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 979;
        String imageType = "";
        String groupId = "";
        String additionalKeys = "";
        String additionalValues = "";
        int imagesInSequence = 751;
        String imageName = "tnyevpdyypbtxoocfivm";
        int imageIndex = 888;
        String imageSource = "r";
        String imageController = "f";
        String imageDate = "vgtpc";
        int imageNumber = 823;
        double timeStampAcquisitionStart = 0.6106455326080322;
        double exposureTime = 0.3151012659072876;
        String imageTag = "kkmza";
        double timestampDateObs = 0.7984322309494019;
        double timestampDateEnd = 0.4590691328048706;
        double expTime = 0.10363179445266724;
        double darkTime = 0.3349548f;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, expTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 871;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 538;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 68;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 163;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 812;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 618;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 246;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 50;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 459;
        String imageType = "";
        String groupId = "k";
        String additionalKeys = "";
        String additionalValues = "v";
        int imagesInSequence = 979;
        String imageName = "txwoodkupplkollcjrpomewlsbnekp";
        int imageIndex = 581;
        String imageSource = "e";
        String imageController = "";
        String imageDate = "lpc";
        int imageNumber = 541;
        double timeStampAcquisitionStart = 0.6334140300750732;
        double exposureTime = 0.6464796662330627;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 81;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 462;
        String filterName = "zoxdddmstgamvxepfhnbalwbbvpjjlkmgjgegwjxarixcbliiqhlcuvyeokvqfqyopyzkchujmsoynpdaobosbnvaqpqbwcwopreybzpb";
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 264;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 58;
        String filterNames = "ryjnegvmcstfbbblnhzowivzorqcfesdkjpffyoozlesdckkxaufzjksuaglzfdnugafnvmueolsyotiiw";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 114;
        String imageType = "";
        String groupId = "n";
        String additionalKeys = "";
        String additionalValues = "p";
        int imagesInSequence = 248;
        String imageName = "warjdvmqyjsggyhpei";
        int imageIndex = 166;
        String imageSource = "hm";
        String imageController = "s";
        String imageDate = "h";
        int imageNumber = 853;
        double timeStampAcquisitionStart = 0.300825834274292;
        double exposureTime = 0.15915173292160034;
        double timeStampStartOfReadout = 0.4622097f;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, imageType, groupId, additionalKeys, additionalValues, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((Object)additionalKeys, (Object)item_.getAdditionalKeys());
        Assert.assertEquals((Object)additionalValues, (Object)item_.getAdditionalValues());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampStartOfReadout, (double)item_.getTimeStampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 795;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 285;
        String imageName = "n";
        String ccdLocation = "e";
        String raftBay = "t";
        String ccdSlot = "z";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = new int[]{565, 106, 583, 249, 267, 515, 222, 127, 800, 670, 429, 224, 819, 927, 868, 927, 780, 41, 185, 73, 772, 155, 81, 269, 956, 583, 371, 970, 582, 172, 314, 161, 235, 811, 53, 106, 546, 982, 69, 330, 210, 396, 554, 361, 76, 554, 594, 946, 784, 811, 775, 235, 187, 112, 68, 668, 274, 51, 332, 413, 941, 341, 711, 112, 427, 568, 25, 478, 757, 558, 177, 702, 402, 480, 627, 847, 791, 811, 834, 534, 392, 348, 774, 123, 920, 308, 941, 430, 81, 143, 410, 503, 880, 791, 463, 899, 928, 693, 255, 650, 1, 663, 453, 454, 549, 917, 483, 950, 479, 630, 848, 720, 632, 15, 376, 501, 727, 3, 17, 93, 988, 839, 600, 780, 802, 220, 798, 997, 815, 679, 859, 770, 201, 797, 205, 30, 974, 344, 909, 49, 632, 215, 54, 931, 787, 81, 419, 620, 388, 890, 163, 311, 992, 206, 156, 719, 655, 242, 929, 986, 147, 202, 369, 298, 89, 237, 798, 786, 330, 684, 6, 358, 422, 378, 522, 595, 262, 382, 657, 93, 900, 435, 560, 631, 929, 512, 328, 973, 235, 619, 100, 614, 705, 673, 685, 646, 277, 481, 316, 503, 541};
        int[] overCols = new int[]{54, 427, 951, 237, 379, 40, 476, 988, 48, 135, 700, 705, 483, 787, 290, 203, 786, 89, 410, 234, 517, 370, 918, 629, 769, 746, 257, 113, 222, 297, 96, 130, 674, 670, 161, 465, 686, 467, 331, 298, 998, 793, 197, 105, 46, 65, 258, 217, 536, 875, 314, 97, 634, 647, 461, 987, 277, 806, 120, 865, 712, 3, 921, 614, 146, 796, 447, 407, 999, 799, 243, 100, 2, 219, 635, 663, 648, 4, 133, 784, 397, 10, 441, 562, 56, 455, 223, 542, 89, 659, 719, 98, 484, 102, 647, 925, 749, 249, 687, 193, 730, 793, 168, 110, 704, 865, 867, 607, 806, 867, 799, 531, 406, 98, 586, 539, 394, 599, 904, 27, 219, 591, 121, 374, 396, 717, 109, 546, 677, 41, 179, 373, 507, 892, 455, 979, 629, 719, 857, 989, 2, 791, 522, 120, 846, 799, 842, 551, 644, 915, 933, 685, 788, 404, 916, 395, 517, 772, 511, 202, 654, 864, 368, 966, 247, 789, 147, 704, 133, 720, 697, 22, 378, 422, 12, 736, 314, 277, 589, 458, 169, 269, 297, 25, 163, 391, 114, 628, 36, 584, 554, 329, 557, 393, 394, 184, 616, 679, 448, 704, 347};
        int[] readRows = new int[]{818, 319, 580, 336, 804, 184, 938, 61, 976, 711, 216, 327, 892, 616, 11, 698, 388, 960, 205, 411, 692, 368, 562, 46, 226, 244, 48, 643, 574, 154, 592, 67, 527, 502, 885, 217, 188, 723, 360, 964, 771, 195, 501, 345, 353, 335, 998, 981, 431, 522, 426, 447, 757, 383, 418, 860, 414, 500, 56, 309, 367, 878, 724, 875, 781, 43, 644, 762, 538, 943, 239, 363, 44, 774, 22, 603, 698, 377, 407, 49, 652, 723, 472, 13, 934, 291, 821, 364, 224, 28, 126, 688, 597, 719, 863, 716, 518, 162, 781, 61, 763, 674, 338, 116, 533, 724, 398, 113, 187, 698, 602, 569, 790, 697, 17, 679, 19, 886, 174, 977, 261, 401, 988, 913, 677, 25, 558, 556, 975, 71, 516, 64, 698, 919, 206, 406, 819, 873, 376, 751, 110, 414, 395, 282, 947, 502, 523, 11, 609, 70, 562, 688, 642, 190, 264, 445, 522, 825, 813, 895, 420, 134, 85, 381, 595, 947, 319, 227, 827, 769, 674, 208, 690, 474, 109, 944, 822, 759, 313, 660, 251, 422, 100, 748, 697, 521, 885, 270, 768, 714, 471, 352, 233, 426, 869, 666, 883, 809, 904, 39, 303};
        int[] readCols = new int[]{943, 800, 898, 648, 497, 676, 766, 322, 831, 735, 277, 854, 531, 234, 322, 623, 500, 656, 898, 732, 288, 249, 772, 618, 760, 807, 218, 782, 933, 879, 463, 324, 448, 628, 432, 206, 31, 590, 824, 68, 36, 297, 532, 565, 951, 54, 149, 120, 964, 995, 683, 673, 383, 591, 742, 291, 588, 406, 808, 430, 259, 773, 367, 534, 80, 3, 127, 584, 697, 421, 667, 321, 808, 756, 827, 596, 216, 524, 402, 160, 637, 340, 303, 860, 44, 949, 931, 168, 721, 560, 810, 113, 280, 57, 522, 296, 171, 162, 321, 329, 914, 421, 371, 395, 784, 770, 184, 888, 826, 65, 540, 98, 122, 261, 912, 400, 2, 758, 191, 140, 637, 248, 635, 923, 975, 37, 77, 232, 292, 884, 355, 805, 630, 580, 259, 151, 192, 345, 934, 180, 991, 521, 136, 84, 849, 540, 340, 58, 997, 78, 884, 21, 58, 939, 86, 703, 580, 397, 819, 129, 897, 525, 729, 449, 297, 348, 128, 433, 804, 468, 761, 277, 253, 784, 937, 289, 548, 180, 486, 596, 906, 874, 521, 237, 549, 395, 601, 969, 915, 135, 89, 182, 36, 369, 87, 296, 128, 641, 965, 413, 255};
        int[] readCols2 = new int[]{663, 260, 606, 607, 321, 532, 436, 40, 153, 585, 349, 188, 830, 664, 626, 146, 310, 935, 390, 953, 309, 186, 149, 73, 732, 33, 814, 246, 753, 639, 943, 630, 446, 605, 83, 506, 953, 325, 27, 145, 88, 387, 774, 775, 878, 557, 622, 812, 102, 92, 73, 817, 955, 594, 48, 606, 994, 363, 528, 951, 885, 729, 626, 597, 693, 559, 921, 16, 715, 279, 928, 714, 555, 895, 133, 111, 429, 213, 30, 657, 305, 164, 359, 855, 519, 127, 613, 189, 424, 538, 961, 399, 604, 624, 28, 272, 969, 414, 684, 151, 140, 158, 832, 920, 784, 433, 502, 521, 264, 28, 62, 603, 2, 243, 587, 88, 35, 643, 990, 332, 169, 272, 62, 579, 904, 703, 600, 578, 708, 870, 638, 762, 272, 592, 79, 479, 673, 52, 308, 656, 827, 749, 842, 895, 798, 949, 961, 487, 75, 746, 600, 477, 521, 202, 834, 462, 550, 659, 969, 40, 716, 539, 765, 902, 43, 150, 529, 187, 292, 430, 99, 216, 177, 29, 590, 872, 7, 734, 574, 688, 669, 705, 487, 252, 924, 189, 522, 453, 34, 31, 428, 662, 812, 393, 653, 638, 144, 918, 618, 168, 916};
        int[] preCols = new int[]{218, 592, 765, 591, 31, 566, 636, 618, 914, 157, 776, 571, 531, 231, 231, 142, 227, 745, 954, 391, 584, 726, 648, 496, 76, 697, 910, 683, 948, 462, 249, 366, 196, 598, 916, 873, 456, 230, 757, 68, 197, 123, 849, 993, 917, 243, 784, 467, 761, 963, 939, 50, 10, 929, 914, 876, 272, 893, 378, 378, 555, 385, 811, 716, 512, 530, 736, 778, 843, 89, 696, 952, 107, 923, 257, 260, 51, 89, 804, 848, 548, 781, 931, 238, 656, 482, 271, 685, 937, 934, 847, 599, 448, 847, 834, 68, 18, 430, 822, 927, 532, 301, 25, 442, 720, 329, 836, 808, 344, 836, 871, 295, 918, 914, 399, 369, 102, 629, 572, 21, 883, 951, 552, 903, 990, 907, 642, 40, 934, 345, 352, 587, 145, 844, 187, 638, 312, 754, 940, 521, 208, 615, 341, 326, 301, 70, 506, 925, 481, 30, 117, 706, 114, 100, 321, 749, 946, 923, 143, 510, 312, 805, 108, 763, 828, 620, 420, 976, 191, 249, 487, 594, 280, 736, 177, 272, 435, 494, 624, 30, 925, 560, 78, 23, 794, 554, 486, 958, 879, 185, 244, 1, 772, 358, 469, 875, 673, 767, 966, 629, 737};
        int[] preRows = new int[]{955, 304, 144, 932, 593, 296, 865, 198, 182, 501, 985, 645, 489, 371, 296, 336, 37, 780, 342, 570, 258, 806, 446, 910, 160, 672, 559, 605, 442, 990, 551, 274, 707, 212, 806, 47, 487, 710, 269, 417, 112, 190, 666, 733, 484, 415, 505, 934, 895, 574, 904, 975, 683, 25, 599, 698, 16, 215, 466, 971, 633, 359, 876, 559, 669, 45, 914, 438, 830, 999, 865, 55, 450, 390, 189, 115, 812, 879, 919, 337, 351, 161, 865, 369, 542, 225, 289, 780, 482, 193, 777, 368, 672, 791, 247, 226, 958, 889, 14, 116, 259, 599, 127, 630, 56, 201, 605, 288, 559, 663, 636, 725, 406, 727, 181, 980, 344, 489, 209, 296, 248, 807, 599, 168, 843, 440, 964, 432, 937, 547, 374, 446, 711, 993, 725, 49, 613, 123, 398, 802, 439, 275, 390, 807, 938, 910, 87, 509, 765, 238, 242, 603, 873, 294, 601, 982, 38, 151, 903, 46, 27, 96, 127, 375, 785, 722, 6, 923, 829, 281, 70, 109, 633, 222, 848, 321, 262, 857, 940, 431, 408, 292, 688, 391, 558, 923, 123, 70, 988, 688, 61, 566, 959, 803, 45, 732, 108, 478, 294, 770, 957};
        int[] postCols = new int[]{950, 519, 37, 513, 485, 582, 185, 711, 813, 208, 488, 375, 639, 319, 313, 45, 377, 760, 389, 475, 494, 760, 117, 657, 240, 955, 192, 804, 481, 929, 329, 160, 142, 110, 516, 795, 428, 596, 969, 96, 157, 590, 305, 901, 339, 443, 45, 202, 589, 950, 231, 701, 271, 134, 704, 622, 707, 199, 296, 812, 126, 876, 308, 75, 662, 646, 353, 123, 735, 462, 966, 590, 133, 331, 968, 397, 427, 169, 392, 719, 418, 262, 615, 832, 133, 546, 945, 770, 201, 610, 391, 466, 842, 665, 6, 161, 345, 972, 118, 189, 10, 608, 125, 324, 753, 435, 313, 325, 604, 67, 68, 867, 132, 591, 161, 806, 645, 784, 374, 239, 453, 955, 258, 104, 993, 206, 421, 246, 347, 780, 735, 989, 232, 975, 88, 814, 21, 609, 703, 55, 34, 167, 991, 639, 975, 859, 307, 372, 971, 996, 505, 419, 995, 236, 548, 300, 287, 686, 172, 511, 448, 153, 969, 390, 230, 878, 941, 569, 166, 450, 223, 920, 465, 232, 835, 321, 943, 678, 870, 990, 658, 170, 640, 306, 408, 642, 850, 880, 160, 581, 503, 959, 405, 152, 935, 470, 176, 17, 815, 0, 135};
        int[] underCols = new int[]{426, 604, 660, 164, 650, 805, 445, 1, 606, 209, 600, 303, 63, 213, 951, 942, 592, 88, 801, 87, 223, 514, 147, 485, 653, 590, 992, 466, 972, 201, 928, 381, 508, 147, 592, 640, 737, 970, 861, 800, 621, 309, 670, 623, 374, 638, 654, 275, 603, 25, 931, 577, 8, 577, 526, 828, 411, 298, 895, 495, 675, 777, 36, 515, 13, 727, 525, 545, 354, 212, 160, 785, 96, 177, 348, 515, 906, 750, 724, 395, 959, 162, 514, 258, 165, 704, 565, 751, 791, 190, 208, 172, 962, 929, 272, 589, 568, 981, 282, 51, 991, 641, 191, 559, 818, 975, 6, 594, 905, 96, 92, 448, 143, 734, 306, 774, 568, 379, 370, 337, 773, 439, 335, 565, 734, 799, 257, 727, 866, 336, 970, 834, 414, 372, 296, 637, 192, 587, 127, 350, 686, 258, 90, 544, 544, 161, 150, 536, 823, 878, 92, 398, 752, 320, 640, 638, 857, 966, 874, 733, 375, 165, 81, 585, 234, 416, 47, 650, 918, 642, 885, 973, 486, 991, 139, 455, 806, 952, 60, 581, 981, 646, 876, 538, 493, 301, 999, 123, 497, 114, 168, 868, 539, 952, 2, 245, 575, 243, 167, 199, 847};
        String daqFolder = "o";
        String daqAnnotation = "";
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdLocation, raftBay, ccdSlot, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols, underCols, daqFolder, daqAnnotation));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdLocation, (Object)item_.getCcdLocation());
        Assert.assertEquals((Object)raftBay, (Object)item_.getRaftBay());
        Assert.assertEquals((Object)ccdSlot, (Object)item_.getCcdSlot());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
        Assert.assertArrayEquals((int[])underCols, (int[])item_.getUnderCols());
        Assert.assertEquals((Object)daqFolder, (Object)item_.getDaqFolder());
        Assert.assertEquals((Object)daqAnnotation, (Object)item_.getDaqAnnotation());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 971;
        String recommendedSettingsVersion = "l";
        String recommendedSettingsLabels = "y";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 495;
        int errorCode = 41;
        String errorReport = "r";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 642;
        boolean appliedSettingsMatchStartIsTrue = false;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 220;
        int level = 0;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 535;
        String name = "";
        int level = 286;
        String message = "h";
        String traceback = "e";
        String filePath = "u";
        String functionName = "q";
        int lineNumber = 844;
        int process = 546;
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, name, level, message, traceback, filePath, functionName, lineNumber, process));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)name, (Object)item_.getName());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
        Assert.assertEquals((Object)filePath, (Object)item_.getFilePath());
        Assert.assertEquals((Object)functionName, (Object)item_.getFunctionName());
        Assert.assertEquals((long)lineNumber, (long)item_.getLineNumber());
        Assert.assertEquals((long)process, (long)item_.getProcess());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 672;
        String settingsVersion = "gajfmwfnumigypsarrrkxbyzisqsbcumlkunzntl";
        String otherSettingsEvents = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 78;
        int mode = 538;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 659;
        String salVersion = "tey";
        String xmlVersion = "zm";
        String openSpliceVersion = "xingxgntzwjdexu";
        String cscVersion = "fshqoq";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 234;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }

    @Test
    public void sendReceiveAuthListEvent() throws Exception {
        int priority = 436;
        String authorizedUsers = "";
        String nonAuthorizedCSCs = "g";
        SALEvent item = this.testSendReceive((SALEvent)new AuthListEvent(priority, authorizedUsers, nonAuthorizedCSCs));
        Assert.assertTrue((boolean)(item instanceof AuthListEvent));
        AuthListEvent item_ = (AuthListEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)authorizedUsers, (Object)item_.getAuthorizedUsers());
        Assert.assertEquals((Object)nonAuthorizedCSCs, (Object)item_.getNonAuthorizedCSCs());
    }
}

