/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.CCSTelemetry;
import org.lsst.sal.camera.telemetry.ClusterEncoderTelemetry;
import org.lsst.sal.camera.telemetry.ColdTelemetry;
import org.lsst.sal.camera.telemetry.CyroTelemetry;
import org.lsst.sal.camera.telemetry.FilterTelemetry;
import org.lsst.sal.camera.telemetry.GasTelemetry;
import org.lsst.sal.camera.telemetry.GdsTelemetry;
import org.lsst.sal.camera.telemetry.HeartbeatTelemetry;
import org.lsst.sal.camera.telemetry.PcmsTelemetry;
import org.lsst.sal.camera.telemetry.ProtTelemetry;
import org.lsst.sal.camera.telemetry.PurgeTelemetry;
import org.lsst.sal.camera.telemetry.SasTelemetry;
import org.lsst.sal.camera.telemetry.SdsTelemetry;
import org.lsst.sal.camera.telemetry.ShutterTelemetry;
import org.lsst.sal.camera.telemetry.WasTelemetry;
import org.lsst.sal.camera.telemetry.WdsTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveShutterTelemetry() throws Exception {
        short[] bladeHome = new short[]{586, 528};
        float[] closeProfile = new float[]{0.6825828f, 0.34709775f, 0.013252199f, 0.79560786f, 0.22558087f, 0.63254106f, 0.5006039f, 0.6652115f, 0.416421f, 0.7190467f, 0.47800446f, 0.19095176f, 0.6294053f, 0.14714211f, 0.809719f, 0.7315373f, 0.112249136f, 0.4983493f, 0.3177681f, 0.95481884f, 0.71602905f, 0.044832468f, 0.24072522f, 0.115276396f};
        float[] motorCurrent = new float[]{0.97277135f, 0.76622134f};
        float[] motorTemp = new float[]{0.99605185f, 0.82400835f};
        short openDirection = 952;
        float[] openProfile = new float[]{0.60346216f, 0.3448001f, 0.9650728f, 0.9620434f, 0.959519f, 0.9063346f, 0.43924105f, 0.54618f, 0.9720297f, 0.6965589f, 0.63172674f, 0.011635423f, 0.4003561f, 0.98258084f, 0.21382213f, 0.7619113f, 0.093761206f, 0.2920429f, 0.11229926f, 0.34644657f, 0.77168006f, 0.18433094f, 0.1807397f, 0.76832885f};
        String profileFunction = "fkjqfrgndwfaycrneiehwmdnkemwkgpehebirroscmsbtbwmgstsefxwruvrdbodloqasmdcokepctsdwlymchhttylhhxwrlwkcpyijysskjxrrbjnryaliwzsjmpudytfuylhcmrbjcningvartwwolaefsgtqejkkqkiuxlogpawfuzgzhufvenutyztafirdzwezdwvbfwleprlnrkqddbwrhvcsgxkvgxpyxs";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ShutterTelemetry(bladeHome, closeProfile, motorCurrent, motorTemp, openDirection, openProfile, profileFunction));
        Assert.assertTrue((boolean)(item instanceof ShutterTelemetry));
        ShutterTelemetry item_ = (ShutterTelemetry)item;
        Assert.assertArrayEquals((short[])bladeHome, (short[])item_.getBladeHome());
        Assert.assertArrayEquals((float[])closeProfile, (float[])item_.getCloseProfile(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorCurrent, (float[])item_.getMotorCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorTemp, (float[])item_.getMotorTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)openDirection, (long)item_.getOpenDirection());
        Assert.assertArrayEquals((float[])openProfile, (float[])item_.getOpenProfile(), (float)1.0E-6f);
        Assert.assertEquals((Object)profileFunction, (Object)item_.getProfileFunction());
    }

    @Test
    public void sendReceiveProtTelemetry() throws Exception {
        int[] status = new int[]{394, 47};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ProtTelemetry(status));
        Assert.assertTrue((boolean)(item instanceof ProtTelemetry));
        ProtTelemetry item_ = (ProtTelemetry)item;
        Assert.assertArrayEquals((int[])status, (int[])item_.getStatus());
    }

    @Test
    public void sendReceiveFilterTelemetry() throws Exception {
        int loaderTelemetry = 250;
        short rebID = 157;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterTelemetry(loaderTelemetry, rebID));
        Assert.assertTrue((boolean)(item instanceof FilterTelemetry));
        FilterTelemetry item_ = (FilterTelemetry)item;
        Assert.assertEquals((long)loaderTelemetry, (long)item_.getLoaderTelemetry());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveHeartbeatTelemetry() throws Exception {
        boolean heartbeat = false;
        int priority = 96;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new HeartbeatTelemetry(heartbeat, priority));
        Assert.assertTrue((boolean)(item instanceof HeartbeatTelemetry));
        HeartbeatTelemetry item_ = (HeartbeatTelemetry)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveWasTelemetry() throws Exception {
        short boardID = 774;
        float[] boardCurrent = new float[]{0.5701176f, 0.45319545f, 0.33221525f, 0.12193096f};
        float[] boardTemp = new float[]{0.37634134f, 0.8193006f, 0.89465934f, 0.35780776f, 0.9562797f, 0.8701253f, 0.43627113f, 0.9899036f, 0.48584515f, 0.6284509f, 0.06454408f, 0.06368184f};
        float[] boardVoltage = new float[]{0.18351716f, 0.9429874f, 0.5275206f, 0.8448999f};
        int[] cabacMUX = new int[]{896, 516, 286, 385};
        short ccdID = 313;
        int ccdtemp = 209;
        int[] fpgaCheckSum = new int[]{986, 479};
        short rebID = 351;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof WasTelemetry));
        WasTelemetry item_ = (WasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveCCSTelemetry() throws Exception {
        int[] ccsStatus = new int[]{572, 854, 807, 344, 879, 700, 426, 967, 514, 570, 605, 595, 143, 290, 347, 405, 731, 149, 542, 60};
        int[] imageStatus = new int[]{552, 887, 981, 734, 120, 631, 354, 741, 852, 406, 266, 27, 611, 393, 503, 372, 422, 732, 179, 199};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CCSTelemetry(ccsStatus, imageStatus));
        Assert.assertTrue((boolean)(item instanceof CCSTelemetry));
        CCSTelemetry item_ = (CCSTelemetry)item;
        Assert.assertArrayEquals((int[])ccsStatus, (int[])item_.getCcsStatus());
        Assert.assertArrayEquals((int[])imageStatus, (int[])item_.getImageStatus());
    }

    @Test
    public void sendReceiveClusterEncoderTelemetry() throws Exception {
        float[] imageSD = new float[]{0.46682012f, 0.13173908f, 0.38600725f, 0.54832006f, 0.7548995f, 0.04621786f, 0.43778813f, 0.6151736f, 0.11285722f, 0.41614866f, 0.6166311f, 0.745116f, 0.20814842f, 0.9986693f, 0.24381286f, 0.51135975f, 0.48001832f, 0.117213964f, 0.7590519f, 0.23517823f, 0.76529574f, 0.03028369f, 0.8887019f, 0.38241404f, 0.4457968f, 0.045282245f, 0.24748898f, 0.027725935f, 0.0847016f, 0.37607938f, 0.8977768f, 0.32142735f, 0.46723914f, 0.6245751f, 0.7339741f, 0.3867373f, 0.7396143f, 0.5302887f, 0.52546227f, 0.4743011f, 0.09875047f, 0.06402588f, 0.2277928f, 0.5498887f, 0.51414365f, 0.15622997f, 0.7129836f, 0.2873063f, 0.9425869f, 0.040100098f, 0.3452611f, 0.8819695f, 0.74802613f, 0.8744506f, 0.07389665f, 0.34459049f, 0.77425283f, 0.5902373f, 0.6808578f, 0.33548397f, 0.09007406f, 0.70443845f, 0.02442491f, 0.9676601f, 0.5781851f, 0.6704366f, 0.092953384f, 0.8538468f, 0.65399295f, 0.51821005f, 0.22342896f, 0.46468568f, 0.7535202f, 0.49164075f, 0.2608568f, 0.27152407f, 0.23528773f, 0.85333914f, 0.81593496f, 0.28954864f, 0.80540466f, 0.31695497f, 0.21462613f, 0.34066665f, 0.94427f, 0.8284989f, 0.58450115f, 0.39886826f, 0.42422295f, 0.87537193f, 0.6650663f, 0.7452285f, 0.33771592f, 0.7063473f, 0.004302442f, 0.7798169f, 0.9732813f, 0.92755526f, 0.868564f, 0.35125768f};
        float[] imageMean = new float[]{0.8905129f, 0.856595f, 0.3706646f, 0.46235365f, 0.05489999f, 0.8053671f, 0.4498847f, 0.48599327f, 0.43867534f, 0.48635f, 0.6218813f, 0.32657474f, 0.0055295825f, 0.9392091f, 0.07578653f, 0.73859596f, 0.046394527f, 0.52534467f, 0.21549892f, 0.6692019f, 0.8824235f, 0.4858775f, 0.12327844f, 0.6317869f, 0.60233015f, 0.4804054f, 0.43285573f, 0.80279744f, 0.7475592f, 0.17451727f, 0.51857966f, 0.526363f, 0.33413875f, 0.9065344f, 0.78451276f, 0.9271167f, 0.8289187f, 0.3993911f, 0.7363129f, 0.2895035f, 0.3452732f, 0.38123178f, 0.7683166f, 0.13407975f, 0.44489986f, 0.40556508f, 0.5431897f, 0.5829771f, 0.22437662f, 0.51419187f, 0.09218466f, 0.68616164f, 0.4145456f, 0.13724142f, 0.446424f, 0.10880494f, 0.75513387f, 0.576267f, 0.61530536f, 0.6425738f, 0.04444164f, 0.9483559f, 0.9643364f, 0.7876291f, 0.7632317f, 0.7895995f, 0.6842986f, 0.4984275f, 0.6825486f, 0.9111864f, 0.77508664f, 0.6389829f, 0.17711788f, 0.18508023f, 0.24498057f, 0.7491421f, 0.25989568f, 0.90110517f, 0.51920116f, 0.08285338f, 0.4505406f, 0.20379978f, 0.095731676f, 0.19567943f, 0.20298082f, 0.98423743f, 0.53253627f, 0.48837215f, 0.5973848f, 0.8959169f, 0.91506547f, 0.36575752f, 0.59288305f, 0.88967466f, 0.068546176f, 0.058166325f, 0.22311515f, 0.653375f, 0.24384958f, 0.64201677f};
        float[] overscanSD = new float[]{0.4715088f, 0.50902003f, 0.63220024f, 0.5558464f, 0.1021713f, 0.90215826f, 0.4317305f, 0.5601807f, 0.75105715f, 0.43343014f, 0.8926217f, 0.9593026f, 0.04695213f, 0.075282216f, 0.6676659f, 0.2685765f, 0.26970363f, 0.51194763f, 0.26749486f, 0.853928f, 0.041564107f, 0.48947698f, 0.6060689f, 0.32494718f, 0.15466553f, 0.29480177f, 0.6795168f, 0.26758075f, 0.872297f, 0.45652407f, 0.77292246f, 0.8473112f, 0.80322593f, 0.011489689f, 0.17364383f, 0.6930427f, 0.77683115f, 0.07446909f, 0.8903203f, 0.5326937f, 0.47295874f, 0.4258297f, 0.053610384f, 0.24392968f, 0.95546806f, 0.664438f, 0.49324584f, 0.21087271f, 0.68430936f, 0.5088151f, 0.9471758f, 0.24645013f, 0.14021534f, 0.7455449f, 0.7289993f, 0.40985757f, 0.38185102f, 0.37497604f, 0.74177843f, 0.08210707f, 0.80134714f, 0.773384f, 0.02753681f, 0.8756334f, 0.07495028f, 0.33909255f, 0.64575577f, 0.76538277f, 0.9860984f, 0.6068594f, 0.4100852f, 0.110777795f, 0.98423976f, 0.2674836f, 0.725014f, 0.56564045f, 0.23044276f, 0.81361234f, 0.56374925f, 0.7748759f, 0.55720896f, 0.6217286f, 0.14100736f, 0.9639228f, 0.46244025f, 0.47606295f, 0.45142865f, 0.22423041f, 0.5843902f, 0.7225638f, 0.97311574f, 0.3730232f, 0.3244326f, 0.11809343f, 0.14921409f, 0.55918217f, 0.5470287f, 0.79782516f, 0.9469821f, 0.34314948f};
        float[] overscanMean = new float[]{0.8814008f, 0.7366548f, 0.80753255f, 0.29442966f, 0.757791f, 0.32069433f, 0.61010224f, 0.4256962f, 0.25409085f, 0.69308966f, 0.11766535f, 0.17105383f, 0.3179798f, 0.99313754f, 0.49693203f, 0.47408754f, 0.31805003f, 0.39571905f, 0.4318617f, 0.68852544f, 0.90788734f, 0.48430747f, 0.6080067f, 0.92334574f, 0.24350768f, 0.28825122f, 0.73312366f, 0.6507946f, 0.9513334f, 0.6948141f, 0.091041505f, 0.5089883f, 0.31607246f, 0.64782596f, 0.97983956f, 0.3926283f, 0.7510979f, 0.8851513f, 0.35671014f, 0.96105033f, 0.17450577f, 0.09201777f, 0.9607942f, 0.38068634f, 0.7788728f, 0.48019898f, 0.987775f, 0.4404745f, 0.32937318f, 0.4958784f, 0.6876863f, 0.56839395f, 0.42152137f, 0.74160457f, 0.70746773f, 0.87280655f, 0.5851613f, 0.2281056f, 0.5251348f, 0.22448945f, 0.13484722f, 0.785979f, 0.36149693f, 0.8780798f, 0.77848995f, 0.2296859f, 0.7122565f, 0.952198f, 0.13673967f, 0.6192258f, 0.33778584f, 0.69596547f, 0.06633496f, 0.47886324f, 0.6652513f, 0.26929963f, 0.48347563f, 0.95595574f, 0.09901911f, 0.36171508f, 0.8507198f, 0.81304663f, 0.4670303f, 0.42893237f, 0.6161232f, 0.59781915f, 0.5353048f, 0.40111113f, 0.31011975f, 0.9112754f, 0.2477749f, 0.12679148f, 0.23840517f, 0.055725396f, 0.65773356f, 0.4815923f, 0.42286444f, 0.48011905f, 0.7394168f, 0.36245394f};
        float[] psf = new float[]{0.693045f, 0.9182974f, 0.74834484f, 0.78191215f, 0.3141111f, 0.33139765f, 0.1473794f, 8.8083744E-4f, 0.8405324f, 0.19254524f, 0.45798522f, 0.32413626f, 0.73550195f, 0.09186447f, 0.624524f, 0.5147181f, 0.81240964f, 0.4726234f, 0.5007707f, 0.14947772f, 0.49540645f, 0.7430022f, 0.055093765f, 0.97883695f, 0.91059196f, 0.32867038f, 0.5323425f, 0.013417423f, 0.69769037f, 0.05334121f, 0.5605527f, 0.63562727f, 0.35490358f, 0.7501117f, 0.51883096f, 0.22574902f, 0.7182397f, 0.23621595f, 0.1245659f, 0.25287485f, 0.54291964f, 0.82644033f, 0.4044199f, 0.36763537f, 0.95101f, 0.84263295f, 9.699464E-4f, 0.055625856f, 0.9793729f, 0.103371024f, 0.16762918f, 0.8804579f, 0.4891575f, 0.98193365f, 0.11643481f, 0.22926104f, 0.056796134f, 0.21339798f, 0.41991132f, 0.9401851f, 0.07184994f, 0.45219064f, 0.50861824f, 0.8630732f, 0.4247344f, 0.44716918f, 0.5448827f, 0.6061836f, 0.8236429f, 0.25778496f, 0.9509667f, 0.73196155f, 0.77177787f, 0.9057209f, 0.0024883747f, 0.964837f, 0.5408458f, 0.29337072f, 0.30691797f, 0.49842578f, 0.46282715f, 0.75350183f, 0.82962465f, 0.8760385f, 0.5380935f, 0.68143857f, 0.8291117f, 0.75786567f, 0.6234201f, 0.8782471f, 0.55722064f, 0.9745615f, 0.35837436f, 0.3649506f, 0.5733171f, 0.8472592f, 0.94360983f, 0.9561455f, 0.7335068f, 0.7785151f, 0.9710594f, 0.0770241f, 0.33213663f, 0.49061483f, 0.6858005f, 0.5193767f, 0.9941746f, 0.113530576f, 0.43501168f, 0.7364018f, 0.0101469755f, 0.16416246f, 0.12411064f, 0.12797755f, 0.15235835f, 0.5740245f, 0.38764793f, 0.6504524f, 0.15999162f, 0.5300692f, 0.9172468f, 0.15912962f, 0.094846606f, 0.41182655f, 0.13586086f, 0.6467033f, 0.4780379f, 0.40953457f, 0.722536f, 0.044342697f, 0.36565733f, 0.06765795f, 0.571001f, 0.3994167f, 0.41856527f, 0.5444426f, 0.69567806f, 0.008641839f, 0.19408691f, 0.54238933f, 0.60765564f, 0.7694753f, 0.727053f, 0.8313154f, 0.38894427f, 0.49574882f, 0.381571f, 0.9427034f, 0.35475147f, 0.9338546f, 0.61598516f, 0.80213696f, 0.9599622f, 0.4993806f, 0.9001702f, 0.8297342f, 0.76754624f, 0.44521487f, 0.510695f, 0.8736819f, 0.53389007f, 0.963172f, 0.27522123f, 0.4494468f, 0.100364864f, 0.13265306f, 0.7781202f, 0.29030818f, 0.023699284f, 0.26036018f, 0.8256701f, 0.52997047f, 0.08247328f, 0.9314156f, 0.61794317f, 0.74474066f, 0.7064469f, 0.51925343f, 0.6178314f, 0.09379089f, 0.3732726f, 0.3123772f, 0.34344143f, 0.37719345f, 0.37783432f, 0.22163934f, 0.55179244f, 0.651653f, 0.5180367f, 0.97135127f, 0.608476f, 0.22524887f, 0.96301264f, 0.06866783f, 0.34441042f, 0.22022235f, 0.32170266f, 0.83380437f, 0.7473956f, 0.22523284f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ClusterEncoderTelemetry(imageSD, imageMean, overscanSD, overscanMean, psf));
        Assert.assertTrue((boolean)(item instanceof ClusterEncoderTelemetry));
        ClusterEncoderTelemetry item_ = (ClusterEncoderTelemetry)item;
        Assert.assertArrayEquals((float[])imageSD, (float[])item_.getImageSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])imageMean, (float[])item_.getImageMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanSD, (float[])item_.getOverscanSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanMean, (float[])item_.getOverscanMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])psf, (float[])item_.getPsf(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveCyroTelemetry() throws Exception {
        float[] coldTemperature = new float[]{0.04850787f, 0.5823819f, 0.2988243f};
        float compressor = 0.83699703f;
        float[] compressorSpeed = new float[]{0.2857654f, 0.23230499f};
        float[] cryoTemperature = new float[]{0.28623635f, 0.5503937f, 0.9183059f, 0.29094613f, 0.65763146f, 0.6336575f, 0.5121147f, 0.32204443f, 0.8564506f, 0.4120152f, 0.32654858f, 0.63176143f};
        float[] dischargePressure = new float[]{0.025355816f, 0.07298839f};
        float[] dischargeTemp = new float[]{0.26769376f, 0.41402632f};
        short[] flowInterlock = new short[]{262, 63};
        float[] heaterCurrent = new float[]{0.41995746f, 0.8990327f, 0.8155597f, 0.65469944f, 0.22514522f, 0.926028f};
        float[] heaterVoltage = new float[]{0.661967f, 0.46607977f, 0.9350161f, 0.6609916f, 0.92892903f, 0.2519201f};
        float[] intakeFlow = new float[]{0.24715221f, 0.07819593f};
        float[] intakePressure = new float[]{0.68156976f, 0.6558336f};
        float[] intakeTemp = new float[]{0.03810513f, 0.07685894f};
        float[] postExpansionPressure = new float[]{0.90088737f, 0.25283664f};
        float[] postExpansionTemp = new float[]{0.4659691f, 0.2931435f};
        float[] preExpansionPressure = new float[]{0.89405197f, 0.27460563f};
        float[] preExpansionTemp = new float[]{0.95119894f, 0.45476294f};
        float[] returnTemp = new float[]{0.57077223f, 0.85088587f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CyroTelemetry(coldTemperature, compressor, compressorSpeed, cryoTemperature, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, returnTemp));
        Assert.assertTrue((boolean)(item instanceof CyroTelemetry));
        CyroTelemetry item_ = (CyroTelemetry)item;
        Assert.assertArrayEquals((float[])coldTemperature, (float[])item_.getColdTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)compressor, (float)item_.getCompressor(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])cryoTemperature, (float[])item_.getCryoTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
    }

    @Test
    public void sendReceivePurgeTelemetry() throws Exception {
        float[] accelerometer = new float[]{0.3246765f, 0.4996801f, 0.28035337f, 0.5281224f, 0.8113967f, 0.20921391f};
        float blowerSetting = 0.919331f;
        float blowerSpeed = 0.15211505f;
        float bodyFlowMeter = 0.1929841f;
        float bodyTemp = 0.18480426f;
        float heaterCurrent = 0.46555334f;
        float heaters = 0.57001895f;
        int microphone = 301;
        float trunkFlowMeter = 0.100367725f;
        float trunkTemp = 0.09727442f;
        int valveSetting = 477;
        int valves = 809;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PurgeTelemetry(accelerometer, blowerSetting, blowerSpeed, bodyFlowMeter, bodyTemp, heaterCurrent, heaters, microphone, trunkFlowMeter, trunkTemp, valveSetting, valves));
        Assert.assertTrue((boolean)(item instanceof PurgeTelemetry));
        PurgeTelemetry item_ = (PurgeTelemetry)item;
        Assert.assertArrayEquals((float[])accelerometer, (float[])item_.getAccelerometer(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSetting, (float)item_.getBlowerSetting(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSpeed, (float)item_.getBlowerSpeed(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyFlowMeter, (float)item_.getBodyFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyTemp, (float)item_.getBodyTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)heaterCurrent, (float)item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)heaters, (float)item_.getHeaters(), (float)1.0E-6f);
        Assert.assertEquals((long)microphone, (long)item_.getMicrophone());
        Assert.assertEquals((float)trunkFlowMeter, (float)item_.getTrunkFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)trunkTemp, (float)item_.getTrunkTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)valveSetting, (long)item_.getValveSetting());
        Assert.assertEquals((long)valves, (long)item_.getValves());
    }

    @Test
    public void sendReceiveWdsTelemetry() throws Exception {
        short rebID = 114;
        int[] timingParameters = new int[]{256, 400, 219, 146, 18, 900, 226, 732, 385, 640};
        int[] flag = new int[]{409, 726, 767, 451, 722, 612, 399, 168, 473, 713, 784, 598, 801, 61, 904, 359, 813, 331, 661, 219};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof WdsTelemetry));
        WdsTelemetry item_ = (WdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGdsTelemetry() throws Exception {
        short rebID = 84;
        int[] timingParameters = new int[]{646, 743, 808, 63, 279, 81, 776, 127, 950, 598};
        int[] flag = new int[]{335, 87, 602, 928, 320, 705, 78, 763, 291, 876, 923, 528, 205, 539, 164, 446, 339, 153, 818, 659};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof GdsTelemetry));
        GdsTelemetry item_ = (GdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveSdsTelemetry() throws Exception {
        short rebID = 628;
        int[] timingParameters = new int[]{232, 660, 345, 747, 594, 722, 459, 910, 158, 558};
        int[] flag = new int[]{566, 862, 692, 288, 549, 827, 260, 949, 84, 274, 152, 827, 710, 430, 457, 428, 514, 857, 991, 348};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof SdsTelemetry));
        SdsTelemetry item_ = (SdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGasTelemetry() throws Exception {
        short boardID = 536;
        float[] boardCurrent = new float[]{0.79723173f, 0.8253457f, 0.8163587f, 0.54579103f};
        float[] boardTemp = new float[]{0.8366264f, 0.9802058f, 0.7885984f, 0.42483866f, 0.3071276f, 0.4132169f, 0.019812226f, 0.77617073f, 0.04545039f, 0.45299548f, 0.34995073f, 0.27151412f};
        float[] boardVoltage = new float[]{0.070926666f, 0.4394496f, 0.08574283f, 0.5146962f};
        int[] cabacMUX = new int[]{458, 343, 390, 501};
        short ccdID = 198;
        int ccdtemp = 737;
        int[] fpgaCheckSum = new int[]{249, 904};
        short rebID = 620;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof GasTelemetry));
        GasTelemetry item_ = (GasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceivePcmsTelemetry() throws Exception {
        short biasStatus = 314;
        float biasCurrent = 0.77572125f;
        float biasVoltage = 0.14799285f;
        short clockStatus = 283;
        short clockCurrent = 711;
        float clockVoltage = 0.77787405f;
        short fpgaStatus = 734;
        float fpgaCurrent = 0.094240546f;
        float fpgaVoltage = 0.09243494f;
        short lowStatus = 877;
        float lowCurrent = 0.6962412f;
        short lowVoltage = 83;
        short odStatus = 78;
        float odCurrent = 0.7404935f;
        float odVoltage = 0.6423062f;
        float rebID = 0.3885188f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PcmsTelemetry(biasStatus, biasCurrent, biasVoltage, clockStatus, clockCurrent, clockVoltage, fpgaStatus, fpgaCurrent, fpgaVoltage, lowStatus, lowCurrent, lowVoltage, odStatus, odCurrent, odVoltage, rebID));
        Assert.assertTrue((boolean)(item instanceof PcmsTelemetry));
        PcmsTelemetry item_ = (PcmsTelemetry)item;
        Assert.assertEquals((long)biasStatus, (long)item_.getBiasStatus());
        Assert.assertEquals((float)biasCurrent, (float)item_.getBiasCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)biasVoltage, (float)item_.getBiasVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)clockStatus, (long)item_.getClockStatus());
        Assert.assertEquals((long)clockCurrent, (long)item_.getClockCurrent());
        Assert.assertEquals((float)clockVoltage, (float)item_.getClockVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)fpgaStatus, (long)item_.getFpgaStatus());
        Assert.assertEquals((float)fpgaCurrent, (float)item_.getFpgaCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)fpgaVoltage, (float)item_.getFpgaVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)lowStatus, (long)item_.getLowStatus());
        Assert.assertEquals((float)lowCurrent, (float)item_.getLowCurrent(), (float)1.0E-6f);
        Assert.assertEquals((long)lowVoltage, (long)item_.getLowVoltage());
        Assert.assertEquals((long)odStatus, (long)item_.getOdStatus());
        Assert.assertEquals((float)odCurrent, (float)item_.getOdCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)odVoltage, (float)item_.getOdVoltage(), (float)1.0E-6f);
        Assert.assertEquals((float)rebID, (float)item_.getRebID(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveSasTelemetry() throws Exception {
        short boardID = 259;
        float[] boardCurrent = new float[]{0.13518113f, 0.047433436f, 0.7023966f, 0.7760049f};
        float[] boardTemp = new float[]{0.47076523f, 0.9501651f, 0.32409412f, 0.5757404f, 0.8858348f, 0.78265864f, 0.22693807f, 0.3246299f, 0.6487502f, 0.74353284f, 0.9011956f, 0.1350187f};
        float[] boardVoltage = new float[]{0.3059649f, 0.8811158f, 0.47207063f, 0.80958384f};
        int[] cabacMUX = new int[]{195, 73, 562, 263};
        short ccdID = 870;
        int ccdtemp = 624;
        int[] fpgaCheckSum = new int[]{628, 710};
        short rebID = 380;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof SasTelemetry));
        SasTelemetry item_ = (SasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveColdTelemetry() throws Exception {
        float[] compressorLoad = new float[]{0.43705064f, 0.62574416f, 0.84456265f, 0.73452806f, 0.39627677f, 0.02667129f};
        float[] compressorSpeed = new float[]{0.031641543f, 0.6872088f, 0.28083235f, 0.46498173f, 0.4443695f, 0.5950102f};
        float[] dischargePressure = new float[]{0.7605145f, 0.92083025f, 0.5145847f, 0.109687746f, 0.9940269f, 0.7169211f};
        float[] dischargeTemp = new float[]{0.74150616f, 0.6434655f, 0.4256611f, 0.9521959f, 0.35298115f, 0.28606188f};
        short[] flowInterlock = new short[]{464, 590, 403, 331, 97, 341};
        float[] heaterCurrent = new float[]{0.1951778f, 0.60177225f, 0.3040431f, 0.88142663f, 0.21412659f, 0.90417415f};
        float[] heaterVoltage = new float[]{0.12834424f, 0.3603968f, 0.4494092f, 0.030228376f, 0.49550438f, 0.44420385f};
        float[] intakeFlow = new float[]{0.57239276f, 0.018464565f, 0.8732677f, 0.7745011f, 0.008116722f, 0.4760129f};
        float[] intakePressure = new float[]{0.50744283f, 0.70765203f, 0.52581847f, 0.8131406f, 0.19448334f, 0.69638854f};
        float[] intakeTemp = new float[]{0.42318958f, 0.250414f, 0.18982506f, 0.68786675f, 0.09356868f, 0.24630785f};
        float[] ionPump = new float[]{0.98540753f, 0.48031747f, 0.06487125f, 0.7954068f};
        short[] mechPump = new short[]{129, 370, 109, 82};
        float[] postExpansionPressure = new float[]{0.23665273f, 0.97771126f, 0.71211773f, 0.0114604235f, 0.04457748f, 0.8001117f};
        float[] postExpansionTemp = new float[]{0.24677908f, 0.7336034f, 0.84230477f, 0.038469672f, 0.9684794f, 0.19005513f};
        float[] preExpansionPressure = new float[]{0.4912036f, 0.5835068f, 0.62616515f, 0.026599586f, 0.84042007f, 0.9843845f};
        float[] preExpansionTemp = new float[]{0.87512016f, 0.6035534f, 0.5533763f, 0.42616296f, 0.49712783f, 0.2837546f};
        int[] rga = new int[]{61, 730, 15, 658, 254, 673, 569, 510, 10, 472};
        float[] returnTemp = new float[]{0.13328624f, 0.2192828f, 0.71775436f, 0.08703965f, 0.5052968f, 0.41217083f};
        float utilityRoomTemperature = 0.76945996f;
        float[] vacuumGauge = new float[]{0.8757722f, 0.95184994f, 0.05150199f, 0.7941093f, 0.9142529f};
        short[] valveStatus = new short[]{725, 158, 422, 267, 522, 955};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ColdTelemetry(compressorLoad, compressorSpeed, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, ionPump, mechPump, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, rga, returnTemp, utilityRoomTemperature, vacuumGauge, valveStatus));
        Assert.assertTrue((boolean)(item instanceof ColdTelemetry));
        ColdTelemetry item_ = (ColdTelemetry)item;
        Assert.assertArrayEquals((float[])compressorLoad, (float[])item_.getCompressorLoad(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])ionPump, (float[])item_.getIonPump(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])mechPump, (short[])item_.getMechPump());
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])rga, (int[])item_.getRga());
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)utilityRoomTemperature, (float)item_.getUtilityRoomTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])vacuumGauge, (float[])item_.getVacuumGauge(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])valveStatus, (short[])item_.getValveStatus());
    }
}

