package org.lsst.sal.camera.states;

import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraStateChangeEvent;

public class CCSCommandStateEvent extends CameraStateChangeEvent {
  private final CCSCommandState substate;

  public CCSCommandStateEvent(int priority, CCSCommandState substate) {
    super (priority);
    this.substate = substate;
  }

  @Override
  public CCSCommandState getSubstate() {
    return substate;
  }

  @Override
  public String toString() {
    return "CCSCommandStateEvent{" + "substate=" + substate +"}";
  }

  public enum CCSCommandState implements SALEnum {
    IDLE,

    BUSY
  }
}
