package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class PurgeTelemetry extends CameraTelemetry {
  private final float[] accelerometer;

  private final float blowerSetting;

  private final float blowerSpeed;

  private final float bodyFlowMeter;

  private final float bodyTemp;

  private final float heaterCurrent;

  private final float heaters;

  private final int microphone;

  private final float trunkFlowMeter;

  private final float trunkTemp;

  private final int valveSetting;

  private final int valves;

  public PurgeTelemetry(float[] accelerometer, float blowerSetting, float blowerSpeed,
      float bodyFlowMeter, float bodyTemp, float heaterCurrent, float heaters, int microphone,
      float trunkFlowMeter, float trunkTemp, int valveSetting, int valves) {
    this.accelerometer = accelerometer;
    this.blowerSetting = blowerSetting;
    this.blowerSpeed = blowerSpeed;
    this.bodyFlowMeter = bodyFlowMeter;
    this.bodyTemp = bodyTemp;
    this.heaterCurrent = heaterCurrent;
    this.heaters = heaters;
    this.microphone = microphone;
    this.trunkFlowMeter = trunkFlowMeter;
    this.trunkTemp = trunkTemp;
    this.valveSetting = valveSetting;
    this.valves = valves;
  }

  public float[] getAccelerometer() {
    return accelerometer;
  }

  public float getBlowerSetting() {
    return blowerSetting;
  }

  public float getBlowerSpeed() {
    return blowerSpeed;
  }

  public float getBodyFlowMeter() {
    return bodyFlowMeter;
  }

  public float getBodyTemp() {
    return bodyTemp;
  }

  public float getHeaterCurrent() {
    return heaterCurrent;
  }

  public float getHeaters() {
    return heaters;
  }

  public int getMicrophone() {
    return microphone;
  }

  public float getTrunkFlowMeter() {
    return trunkFlowMeter;
  }

  public float getTrunkTemp() {
    return trunkTemp;
  }

  public int getValveSetting() {
    return valveSetting;
  }

  public int getValves() {
    return valves;
  }

  @Override
  public String toString() {
    return "PurgeTelemetry{" + "accelerometer=" + Arrays.toString(accelerometer) +
        ", blowerSetting=" + blowerSetting +", blowerSpeed=" + blowerSpeed +
        ", bodyFlowMeter=" + bodyFlowMeter +", bodyTemp=" + bodyTemp +
        ", heaterCurrent=" + heaterCurrent +", heaters=" + heaters +", microphone=" + microphone +
        ", trunkFlowMeter=" + trunkFlowMeter +", trunkTemp=" + trunkTemp +
        ", valveSetting=" + valveSetting +", valves=" + valves +"}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private float[] accelerometer;

    private float blowerSetting;

    private float blowerSpeed;

    private float bodyFlowMeter;

    private float bodyTemp;

    private float heaterCurrent;

    private float heaters;

    private int microphone;

    private float trunkFlowMeter;

    private float trunkTemp;

    private int valveSetting;

    private int valves;

    private Builder() {
    }

    public Builder accelerometer(float[] accelerometer) {
      this.accelerometer = accelerometer;
      return this;
    }

    public Builder blowerSetting(float blowerSetting) {
      this.blowerSetting = blowerSetting;
      return this;
    }

    public Builder blowerSpeed(float blowerSpeed) {
      this.blowerSpeed = blowerSpeed;
      return this;
    }

    public Builder bodyFlowMeter(float bodyFlowMeter) {
      this.bodyFlowMeter = bodyFlowMeter;
      return this;
    }

    public Builder bodyTemp(float bodyTemp) {
      this.bodyTemp = bodyTemp;
      return this;
    }

    public Builder heaterCurrent(float heaterCurrent) {
      this.heaterCurrent = heaterCurrent;
      return this;
    }

    public Builder heaters(float heaters) {
      this.heaters = heaters;
      return this;
    }

    public Builder microphone(int microphone) {
      this.microphone = microphone;
      return this;
    }

    public Builder trunkFlowMeter(float trunkFlowMeter) {
      this.trunkFlowMeter = trunkFlowMeter;
      return this;
    }

    public Builder trunkTemp(float trunkTemp) {
      this.trunkTemp = trunkTemp;
      return this;
    }

    public Builder valveSetting(int valveSetting) {
      this.valveSetting = valveSetting;
      return this;
    }

    public Builder valves(int valves) {
      this.valves = valves;
      return this;
    }

    public PurgeTelemetry build() {
      return new PurgeTelemetry(accelerometer, blowerSetting, blowerSpeed, bodyFlowMeter, bodyTemp, heaterCurrent, heaters, microphone, trunkFlowMeter, trunkTemp, valveSetting, valves);
    }
  }
}
