package org.lsst.sal.camera.command;

import org.lsst.sal.camera.CameraCommand;

public class StartImageCommand extends CameraCommand {
  private final boolean shutter;

  private final boolean science;

  private final boolean guide;

  private final boolean wfs;

  private final double timeout;

  private final String imageType;

  private final String groupId;

  public StartImageCommand(boolean shutter, boolean science, boolean guide, boolean wfs,
      double timeout, String imageType, String groupId) {
    this.shutter = shutter;
    this.science = science;
    this.guide = guide;
    this.wfs = wfs;
    this.timeout = timeout;
    this.imageType = imageType;
    this.groupId = groupId;
  }

  public boolean isShutter() {
    return shutter;
  }

  public boolean isScience() {
    return science;
  }

  public boolean isGuide() {
    return guide;
  }

  public boolean isWfs() {
    return wfs;
  }

  public double getTimeout() {
    return timeout;
  }

  public String getImageType() {
    return imageType;
  }

  public String getGroupId() {
    return groupId;
  }

  @Override
  public String toString() {
    return "StartImageCommand{" + "shutter=" + shutter +", science=" + science +", guide=" + guide +
        ", wfs=" + wfs +", timeout=" + timeout +", imageType=" + imageType +", groupId=" + groupId +
        "}";
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {
    private boolean shutter;

    private boolean science;

    private boolean guide;

    private boolean wfs;

    private double timeout;

    private String imageType;

    private String groupId;

    private Builder() {
    }

    public Builder shutter(boolean shutter) {
      this.shutter = shutter;
      return this;
    }

    public Builder science(boolean science) {
      this.science = science;
      return this;
    }

    public Builder guide(boolean guide) {
      this.guide = guide;
      return this;
    }

    public Builder wfs(boolean wfs) {
      this.wfs = wfs;
      return this;
    }

    public Builder timeout(double timeout) {
      this.timeout = timeout;
      return this;
    }

    public Builder imageType(String imageType) {
      this.imageType = imageType;
      return this;
    }

    public Builder groupId(String groupId) {
      this.groupId = groupId;
      return this;
    }

    public StartImageCommand build() {
      return new StartImageCommand(shutter, science, guide, wfs, timeout, imageType, groupId);
    }
  }
}
