/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.telemetry.CCSTelemetry;
import org.lsst.sal.camera.telemetry.ClusterEncoderTelemetry;
import org.lsst.sal.camera.telemetry.ColdTelemetry;
import org.lsst.sal.camera.telemetry.CyroTelemetry;
import org.lsst.sal.camera.telemetry.FilterTelemetry;
import org.lsst.sal.camera.telemetry.GasTelemetry;
import org.lsst.sal.camera.telemetry.GdsTelemetry;
import org.lsst.sal.camera.telemetry.HeartbeatTelemetry;
import org.lsst.sal.camera.telemetry.PcmsTelemetry;
import org.lsst.sal.camera.telemetry.ProtTelemetry;
import org.lsst.sal.camera.telemetry.PurgeTelemetry;
import org.lsst.sal.camera.telemetry.SasTelemetry;
import org.lsst.sal.camera.telemetry.SdsTelemetry;
import org.lsst.sal.camera.telemetry.ShutterTelemetry;
import org.lsst.sal.camera.telemetry.WasTelemetry;
import org.lsst.sal.camera.telemetry.WdsTelemetry;

public class TelemetrySendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALTelemetry testSendReceive(SALTelemetry item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALTelemetry> future = executor.submit(() -> sal.getTelemetry(Duration.ofSeconds(10L)));
        try {
            sal.sendTelemetry(item);
            SALTelemetry sALTelemetry = future.get(10L, TimeUnit.SECONDS);
            return sALTelemetry;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveShutterTelemetry() throws Exception {
        short[] bladeHome = new short[]{639, 302};
        float[] closeProfile = new float[]{0.094846606f, 0.41182655f, 0.13586086f, 0.6467033f, 0.4780379f, 0.40953457f, 0.722536f, 0.044342697f, 0.36565733f, 0.06765795f, 0.571001f, 0.3994167f, 0.41856527f, 0.5444426f, 0.69567806f, 0.008641839f, 0.19408691f, 0.54238933f, 0.60765564f, 0.7694753f, 0.727053f, 0.8313154f, 0.38894427f, 0.49574882f};
        float[] motorCurrent = new float[]{0.381571f, 0.9427034f};
        float[] motorTemp = new float[]{0.35475147f, 0.9338546f};
        short openDirection = 72;
        float[] openProfile = new float[]{0.80213696f, 0.9599622f, 0.4993806f, 0.9001702f, 0.8297342f, 0.76754624f, 0.44521487f, 0.510695f, 0.8736819f, 0.53389007f, 0.963172f, 0.27522123f, 0.4494468f, 0.100364864f, 0.13265306f, 0.7781202f, 0.29030818f, 0.023699284f, 0.26036018f, 0.8256701f, 0.52997047f, 0.08247328f, 0.9314156f, 0.61794317f};
        String profileFunction = "oiqdaesjnsdplbhrqgseliyccihubuyshqwnviuomvcitfmduyusijaprpcoegzmvmyaocdadgpicpclfqpgwoiytcrbrkmqxqawkkngpcnxumpyhdyudjydvbdhaibcxbrcrmcfhemofgplyrebraetrypwaetlowzwqquauavtgpkeuhoehwozvoctdu";
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ShutterTelemetry(bladeHome, closeProfile, motorCurrent, motorTemp, openDirection, openProfile, profileFunction));
        Assert.assertTrue((boolean)(item instanceof ShutterTelemetry));
        ShutterTelemetry item_ = (ShutterTelemetry)item;
        Assert.assertArrayEquals((short[])bladeHome, (short[])item_.getBladeHome());
        Assert.assertArrayEquals((float[])closeProfile, (float[])item_.getCloseProfile(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorCurrent, (float[])item_.getMotorCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])motorTemp, (float[])item_.getMotorTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)openDirection, (long)item_.getOpenDirection());
        Assert.assertArrayEquals((float[])openProfile, (float[])item_.getOpenProfile(), (float)1.0E-6f);
        Assert.assertEquals((Object)profileFunction, (Object)item_.getProfileFunction());
    }

    @Test
    public void sendReceiveProtTelemetry() throws Exception {
        int[] status = new int[]{402, 652};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ProtTelemetry(status));
        Assert.assertTrue((boolean)(item instanceof ProtTelemetry));
        ProtTelemetry item_ = (ProtTelemetry)item;
        Assert.assertArrayEquals((int[])status, (int[])item_.getStatus());
    }

    @Test
    public void sendReceiveFilterTelemetry() throws Exception {
        int loaderTelemetry = 902;
        short rebID = 229;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new FilterTelemetry(loaderTelemetry, rebID));
        Assert.assertTrue((boolean)(item instanceof FilterTelemetry));
        FilterTelemetry item_ = (FilterTelemetry)item;
        Assert.assertEquals((long)loaderTelemetry, (long)item_.getLoaderTelemetry());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveHeartbeatTelemetry() throws Exception {
        boolean heartbeat = false;
        int priority = 504;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new HeartbeatTelemetry(heartbeat, priority));
        Assert.assertTrue((boolean)(item instanceof HeartbeatTelemetry));
        HeartbeatTelemetry item_ = (HeartbeatTelemetry)item;
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveWasTelemetry() throws Exception {
        short boardID = 621;
        float[] boardCurrent = new float[]{0.019812226f, 0.77617073f, 0.04545039f, 0.45299548f};
        float[] boardTemp = new float[]{0.34995073f, 0.27151412f, 0.070926666f, 0.4394496f, 0.08574283f, 0.5146962f, 0.9062464f, 0.31702417f, 0.26001376f, 0.6229004f, 0.31414217f, 0.9994347f};
        float[] boardVoltage = new float[]{0.5962114f, 0.6705964f, 0.38250983f, 0.35566616f};
        int[] cabacMUX = new int[]{774, 224, 283, 711};
        short ccdID = 839;
        int ccdtemp = 734;
        int[] fpgaCheckSum = new int[]{136, 562};
        short rebID = 877;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof WasTelemetry));
        WasTelemetry item_ = (WasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveCCSTelemetry() throws Exception {
        int[] ccsStatus = new int[]{611, 83, 78, 694, 187, 913, 259, 305, 628, 234, 885, 751, 94, 863, 159, 784, 634, 866, 461, 519};
        int[] imageStatus = new int[]{628, 889, 543, 595, 853, 88, 129, 195, 73, 562, 263, 870, 624, 628, 710, 380, 160, 438, 590, 12};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CCSTelemetry(ccsStatus, imageStatus));
        Assert.assertTrue((boolean)(item instanceof CCSTelemetry));
        CCSTelemetry item_ = (CCSTelemetry)item;
        Assert.assertArrayEquals((int[])ccsStatus, (int[])item_.getCcsStatus());
        Assert.assertArrayEquals((int[])imageStatus, (int[])item_.getImageStatus());
    }

    @Test
    public void sendReceiveClusterEncoderTelemetry() throws Exception {
        float[] imageSD = new float[]{0.39627677f, 0.02667129f, 0.031641543f, 0.6872088f, 0.28083235f, 0.46498173f, 0.4443695f, 0.5950102f, 0.7605145f, 0.92083025f, 0.5145847f, 0.109687746f, 0.9940269f, 0.7169211f, 0.74150616f, 0.6434655f, 0.4256611f, 0.9521959f, 0.35298115f, 0.28606188f, 0.12607193f, 0.9344544f, 0.571897f, 0.5963595f, 0.23745048f, 0.011470318f, 0.1951778f, 0.60177225f, 0.3040431f, 0.88142663f, 0.21412659f, 0.90417415f, 0.12834424f, 0.3603968f, 0.4494092f, 0.030228376f, 0.49550438f, 0.44420385f, 0.57239276f, 0.018464565f, 0.8732677f, 0.7745011f, 0.008116722f, 0.4760129f, 0.50744283f, 0.70765203f, 0.52581847f, 0.8131406f, 0.19448334f, 0.69638854f, 0.42318958f, 0.250414f, 0.18982506f, 0.68786675f, 0.09356868f, 0.24630785f, 0.98540753f, 0.48031747f, 0.06487125f, 0.7954068f, 0.110162914f, 0.17981386f, 0.8396306f, 0.26013613f, 0.23665273f, 0.97771126f, 0.71211773f, 0.0114604235f, 0.04457748f, 0.8001117f, 0.24677908f, 0.7336034f, 0.84230477f, 0.038469672f, 0.9684794f, 0.19005513f, 0.4912036f, 0.5835068f, 0.62616515f, 0.026599586f, 0.84042007f, 0.9843845f, 0.87512016f, 0.6035534f, 0.5533763f, 0.42616296f, 0.49712783f, 0.2837546f, 0.79895556f, 0.7486593f, 0.101374924f, 0.2630747f, 0.962894f, 0.25970656f, 0.27124423f, 0.20248932f, 0.9968197f, 0.16947949f, 0.13328624f, 0.2192828f};
        float[] imageMean = new float[]{0.71775436f, 0.08703965f, 0.5052968f, 0.41217083f, 0.76945996f, 0.8757722f, 0.95184994f, 0.05150199f, 0.7941093f, 0.9142529f, 0.94975144f, 0.95988536f, 0.8893788f, 0.309744f, 0.7952384f, 0.86733603f, 0.6587892f, 0.17254132f, 0.11250186f, 0.6532259f, 0.13419604f, 0.6934769f, 0.73305935f, 0.21797144f, 0.85659575f, 0.43984562f, 0.08205372f, 0.17162406f, 0.25835347f, 0.16580886f, 0.9457472f, 0.823606f, 0.7756659f, 0.14401186f, 0.9099818f, 0.9251386f, 0.4292819f, 0.8909226f, 0.7984728f, 0.8989484f, 0.8045603f, 0.45758396f, 0.93941003f, 0.6132452f, 0.81483036f, 0.6715085f, 0.026496828f, 0.17049521f, 0.48633176f, 0.7789118f, 0.08442831f, 0.31605667f, 0.41598076f, 0.48706537f, 0.6076806f, 0.3852988f, 0.9476799f, 0.035080075f, 0.21477282f, 0.7365331f, 0.42734998f, 0.42184657f, 0.187908f, 0.22519594f, 0.8354001f, 0.5392314f, 0.4807614f, 0.90462613f, 0.3777069f, 0.6471555f, 0.24646002f, 0.060976744f, 0.2276879f, 0.28817934f, 0.6253896f, 0.25293404f, 0.05370879f, 0.47913796f, 0.5409242f, 0.9077301f, 0.5044582f, 0.39577538f, 0.073657274f, 0.47832626f, 0.74228776f, 0.045916975f, 0.75500816f, 0.27561045f, 0.9586937f, 0.8233169f, 0.8636089f, 0.015129745f, 0.64059526f, 0.7668579f, 0.6876677f, 0.34952736f, 0.00993675f, 0.6903498f, 0.28923535f, 0.26285213f};
        float[] overscanSD = new float[]{0.37713814f, 0.6719495f, 0.7682473f, 0.076768816f, 0.24139053f, 0.22754365f, 0.4622993f, 0.93504894f, 0.46371704f, 0.5707303f, 0.15987098f, 0.29332495f, 0.123696625f, 0.8678842f, 0.86830974f, 0.025825739f, 0.15500414f, 0.21788555f, 0.22210962f, 0.9776892f, 0.21130973f, 0.06325132f, 0.3912856f, 0.9265983f, 0.6310747f, 0.9165858f, 0.6439909f, 0.08516902f, 0.8014886f, 0.16051793f, 0.21261233f, 0.16811699f, 0.63793135f, 0.45083237f, 0.12970668f, 0.18624818f, 0.53127617f, 0.07462853f, 0.45120972f, 0.11139405f, 0.72203916f, 0.8445212f, 0.12191075f, 0.30929965f, 0.1544435f, 0.5556836f, 0.40539283f, 0.6660559f, 0.97711474f, 0.2076317f, 0.68129104f, 0.97095567f, 0.7882214f, 0.5628792f, 0.7812221f, 0.7757748f, 0.7848882f, 0.84889174f, 0.30613726f, 0.3667f, 0.2487483f, 0.63021845f, 0.34780306f, 0.97781694f, 0.37628645f, 0.909467f, 0.17191517f, 0.0897547f, 0.7045116f, 0.13723469f, 0.04690981f, 0.8173778f, 0.16545892f, 0.003666103f, 0.9983982f, 0.5480917f, 0.768664f, 0.08253455f, 0.70247066f, 0.27725708f, 0.71629685f, 0.74035007f, 0.5106943f, 0.4574076f, 0.3239451f, 0.29878998f, 0.124867976f, 0.6695594f, 0.88957185f, 0.542678f, 0.25054747f, 0.40215707f, 0.8280426f, 0.044879317f, 0.58566946f, 0.628489f, 0.18854606f, 0.88401896f, 0.31558007f, 0.47724944f};
        float[] overscanMean = new float[]{0.58257735f, 0.56419635f, 0.35032028f, 0.94194067f, 0.571884f, 0.91430247f, 0.45668316f, 0.44976944f, 0.46549863f, 0.50771797f, 0.19949186f, 0.9644698f, 0.034921706f, 0.46377695f, 0.8475499f, 0.71309114f, 0.9245282f, 0.086241126f, 0.64419496f, 0.26536012f, 0.07382548f, 0.5800908f, 0.75538564f, 0.54501355f, 0.60839164f, 0.43826848f, 0.8454303f, 0.9828876f, 0.7418994f, 0.079805255f, 0.28811997f, 0.82705164f, 0.8729289f, 0.9783458f, 0.08606315f, 0.079514325f, 0.38327742f, 0.076893926f, 0.37098116f, 0.4337762f, 0.5407762f, 0.42522043f, 0.0107732415f, 0.3226267f, 0.28646177f, 0.088479936f, 0.11408645f, 0.95910287f, 0.7161639f, 0.80001396f, 0.7493444f, 0.35156757f, 0.4386468f, 0.11200529f, 0.77273774f, 0.31068933f, 0.1604752f, 0.93166995f, 0.46922284f, 0.63409215f, 0.28149313f, 0.01822418f, 0.5734026f, 0.97410613f, 0.7195647f, 0.9102601f, 0.8651876f, 0.46401232f, 0.8699944f, 0.7108558f, 0.7808997f, 0.42520612f, 0.5604331f, 0.48830038f, 0.58713967f, 0.4066761f, 0.11830467f, 0.76642823f, 0.51609665f, 0.25212336f, 0.52271163f, 0.6460507f, 0.6314314f, 0.76006114f, 0.87987196f, 0.6867908f, 0.9984662f, 0.037592053f, 0.7195051f, 0.4088412f, 0.27682108f, 0.6666459f, 0.4539482f, 0.47196645f, 0.084138334f, 0.9477828f, 0.63249964f, 0.5327886f, 0.23305213f, 0.48485178f};
        float[] psf = new float[]{0.7365258f, 0.9524612f, 0.1976214f, 0.2756111f, 0.3378386f, 0.8598362f, 0.28822005f, 0.9087363f, 0.640973f, 0.20784467f, 0.014158666f, 0.8944817f, 0.17212439f, 0.9838724f, 0.8905048f, 0.110746324f, 0.60212153f, 0.44235873f, 0.5397211f, 0.6926897f, 0.102003455f, 0.3667515f, 0.78050965f, 0.8747262f, 0.9472829f, 0.88850766f, 0.5569304f, 0.5792065f, 0.29614544f, 0.19636154f, 0.0023627877f, 0.28500617f, 0.66864777f, 0.6660289f, 0.75774306f, 0.5783386f, 0.9150266f, 0.08845544f, 0.36490005f, 0.042281568f, 0.66375035f, 0.036338627f, 0.26751482f, 0.8637517f, 0.93178177f, 0.19977874f, 0.6986639f, 0.8881233f, 0.8241538f, 0.1614902f, 0.6801071f, 0.32161433f, 0.876488f, 0.44210166f, 0.060114622f, 0.93734586f, 0.44724208f, 0.30188203f, 0.1699813f, 0.37811917f, 0.756597f, 0.26508057f, 0.37136763f, 0.94108975f, 0.3219779f, 0.36839265f, 0.72477084f, 0.3784014f, 0.04783368f, 0.9104452f, 0.85193044f, 0.63335896f, 0.49671435f, 0.88232034f, 0.050605834f, 0.7618788f, 0.5727296f, 0.13082838f, 0.998331f, 0.34988666f, 0.17562342f, 0.6904462f, 0.2425074f, 0.64329696f, 0.28806257f, 0.11362529f, 0.7981903f, 0.050585866f, 0.410033f, 0.23273724f, 0.88345504f, 0.17927194f, 0.48782492f, 0.7535896f, 0.32720798f, 0.72547305f, 0.25193703f, 0.76665074f, 0.8382721f, 0.27687806f, 0.694943f, 0.47744364f, 0.87069213f, 0.91883683f, 0.8191748f, 0.7146966f, 0.6422613f, 0.7838386f, 0.56282544f, 0.53960127f, 0.2356804f, 0.7675569f, 0.2852471f, 0.22085816f, 0.04956305f, 0.2891341f, 0.43691498f, 0.08017099f, 0.975362f, 0.5168593f, 0.1514669f, 0.076670706f, 0.002496183f, 0.058349967f, 0.8367744f, 0.26472765f, 0.834425f, 0.9504293f, 0.28511775f, 0.40919822f, 0.010683179f, 0.4298448f, 0.010835111f, 0.5099129f, 0.84211725f, 0.5516842f, 0.11451912f, 0.91084725f, 0.687547f, 0.20582688f, 0.8887909f, 0.13974166f, 0.12922364f, 0.49914235f, 0.060374677f, 0.9349001f, 0.9818091f, 0.18668503f, 0.21072006f, 0.81456566f, 0.7258255f, 0.7912064f, 0.7525074f, 0.480847f, 0.46290475f, 0.017427087f, 0.34737056f, 0.7279629f, 0.30862325f, 0.8943129f, 0.8320593f, 0.9500392f, 0.8717734f, 0.94183856f, 0.3426444f, 0.8763936f, 0.10976654f, 0.31328171f, 0.17146307f, 0.5648836f, 0.03226763f, 0.89298004f, 0.0071698427f, 0.67228264f, 0.9735508f, 0.39383298f, 0.15796733f, 0.5137422f, 0.13346684f, 0.5879006f, 0.4709499f, 0.7932596f, 0.8530025f, 0.4846211f, 0.2812246f, 0.2088964f, 0.33946776f, 0.93995285f, 0.4634294f, 0.43860728f, 0.8752904f, 0.3097682f, 0.6414281f, 0.5263809f, 0.6607657f, 0.15385169f, 0.730922f, 0.09853965f, 0.47306317f, 0.03276348f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ClusterEncoderTelemetry(imageSD, imageMean, overscanSD, overscanMean, psf));
        Assert.assertTrue((boolean)(item instanceof ClusterEncoderTelemetry));
        ClusterEncoderTelemetry item_ = (ClusterEncoderTelemetry)item;
        Assert.assertArrayEquals((float[])imageSD, (float[])item_.getImageSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])imageMean, (float[])item_.getImageMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanSD, (float[])item_.getOverscanSD(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])overscanMean, (float[])item_.getOverscanMean(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])psf, (float[])item_.getPsf(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveCyroTelemetry() throws Exception {
        float[] coldTemperature = new float[]{0.15170866f, 0.5341876f, 0.03012669f};
        float compressor = 0.3266275f;
        float[] compressorSpeed = new float[]{0.4241926f, 0.5327517f};
        float[] cryoTemperature = new float[]{0.9782284f, 0.028725326f, 0.14698112f, 0.009285271f, 0.5658923f, 0.24188334f, 0.9930897f, 0.90175235f, 0.50535244f, 0.8244086f, 0.8311557f, 0.9940951f};
        float[] dischargePressure = new float[]{0.07694638f, 0.31527025f};
        float[] dischargeTemp = new float[]{0.1104759f, 0.8978132f};
        short[] flowInterlock = new short[]{309, 57};
        float[] heaterCurrent = new float[]{0.4956053f, 0.749509f, 0.96611285f, 0.32585716f, 0.41430515f, 0.28193545f};
        float[] heaterVoltage = new float[]{0.13068229f, 0.21339059f, 0.7240076f, 0.72423226f, 0.82254165f, 0.6510754f};
        float[] intakeFlow = new float[]{0.40454704f, 0.449058f};
        float[] intakePressure = new float[]{0.14185333f, 0.27757835f};
        float[] intakeTemp = new float[]{0.86215794f, 0.5791765f};
        float[] postExpansionPressure = new float[]{0.15868092f, 0.21217859f};
        float[] postExpansionTemp = new float[]{0.6607599f, 0.51579994f};
        float[] preExpansionPressure = new float[]{0.51234037f, 0.07157433f};
        float[] preExpansionTemp = new float[]{0.87607205f, 0.88082594f};
        float[] returnTemp = new float[]{0.94372016f, 0.23266453f};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new CyroTelemetry(coldTemperature, compressor, compressorSpeed, cryoTemperature, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, returnTemp));
        Assert.assertTrue((boolean)(item instanceof CyroTelemetry));
        CyroTelemetry item_ = (CyroTelemetry)item;
        Assert.assertArrayEquals((float[])coldTemperature, (float[])item_.getColdTemperature(), (float)1.0E-6f);
        Assert.assertEquals((float)compressor, (float)item_.getCompressor(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])cryoTemperature, (float[])item_.getCryoTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
    }

    @Test
    public void sendReceivePurgeTelemetry() throws Exception {
        float[] accelerometer = new float[]{0.65646756f, 0.95335096f, 0.38640785f, 0.060896516f, 0.34767973f, 0.80894417f};
        float blowerSetting = 0.8129307f;
        float blowerSpeed = 0.21386588f;
        float bodyFlowMeter = 0.8380926f;
        float bodyTemp = 0.9726934f;
        float heaterCurrent = 0.5340975f;
        float heaters = 0.86595535f;
        int microphone = 755;
        float trunkFlowMeter = 0.11168361f;
        float trunkTemp = 0.09111643f;
        int valveSetting = 525;
        int valves = 612;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PurgeTelemetry(accelerometer, blowerSetting, blowerSpeed, bodyFlowMeter, bodyTemp, heaterCurrent, heaters, microphone, trunkFlowMeter, trunkTemp, valveSetting, valves));
        Assert.assertTrue((boolean)(item instanceof PurgeTelemetry));
        PurgeTelemetry item_ = (PurgeTelemetry)item;
        Assert.assertArrayEquals((float[])accelerometer, (float[])item_.getAccelerometer(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSetting, (float)item_.getBlowerSetting(), (float)1.0E-6f);
        Assert.assertEquals((float)blowerSpeed, (float)item_.getBlowerSpeed(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyFlowMeter, (float)item_.getBodyFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)bodyTemp, (float)item_.getBodyTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)heaterCurrent, (float)item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)heaters, (float)item_.getHeaters(), (float)1.0E-6f);
        Assert.assertEquals((long)microphone, (long)item_.getMicrophone());
        Assert.assertEquals((float)trunkFlowMeter, (float)item_.getTrunkFlowMeter(), (float)1.0E-6f);
        Assert.assertEquals((float)trunkTemp, (float)item_.getTrunkTemp(), (float)1.0E-6f);
        Assert.assertEquals((long)valveSetting, (long)item_.getValveSetting());
        Assert.assertEquals((long)valves, (long)item_.getValves());
    }

    @Test
    public void sendReceiveWdsTelemetry() throws Exception {
        short rebID = 513;
        int[] timingParameters = new int[]{318, 510, 509, 203, 489, 573, 693, 121, 441, 578};
        int[] flag = new int[]{653, 153, 777, 444, 436, 393, 317, 121, 355, 441, 226, 598, 507, 739, 935, 863, 346, 618, 993, 724};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new WdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof WdsTelemetry));
        WdsTelemetry item_ = (WdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGdsTelemetry() throws Exception {
        short rebID = 221;
        int[] timingParameters = new int[]{132, 645, 17, 135, 246, 671, 368, 744, 362, 343};
        int[] flag = new int[]{412, 417, 311, 299, 5, 115, 966, 159, 811, 879, 724, 832, 712, 864, 353, 737, 911, 69, 803, 13};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof GdsTelemetry));
        GdsTelemetry item_ = (GdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveSdsTelemetry() throws Exception {
        short rebID = 379;
        int[] timingParameters = new int[]{482, 815, 11, 798, 174, 582, 984, 455, 800, 64};
        int[] flag = new int[]{574, 550, 850, 128, 105, 231, 208, 140, 306, 856, 42, 815, 973, 505, 220, 988, 725, 607, 199, 609};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SdsTelemetry(rebID, timingParameters, flag));
        Assert.assertTrue((boolean)(item instanceof SdsTelemetry));
        SdsTelemetry item_ = (SdsTelemetry)item;
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
        Assert.assertArrayEquals((int[])timingParameters, (int[])item_.getTimingParameters());
        Assert.assertArrayEquals((int[])flag, (int[])item_.getFlag());
    }

    @Test
    public void sendReceiveGasTelemetry() throws Exception {
        short boardID = 24;
        float[] boardCurrent = new float[]{0.20766753f, 0.31833577f, 0.091483355f, 0.87396944f};
        float[] boardTemp = new float[]{0.011934459f, 0.8722002f, 0.13280964f, 0.22874731f, 0.44182825f, 0.4428752f, 0.014871478f, 0.7785091f, 0.29804146f, 0.23427302f, 0.35692495f, 0.005169034f};
        float[] boardVoltage = new float[]{0.41407597f, 0.30284178f, 0.37502426f, 0.6544218f};
        int[] cabacMUX = new int[]{165, 719, 790, 940};
        short ccdID = 235;
        int ccdtemp = 523;
        int[] fpgaCheckSum = new int[]{339, 880};
        short rebID = 908;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new GasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof GasTelemetry));
        GasTelemetry item_ = (GasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceivePcmsTelemetry() throws Exception {
        short biasStatus = 212;
        float biasCurrent = 0.96995753f;
        float biasVoltage = 0.30715775f;
        short clockStatus = 422;
        short clockCurrent = 833;
        float clockVoltage = 0.6894886f;
        short fpgaStatus = 229;
        float fpgaCurrent = 0.46903098f;
        float fpgaVoltage = 0.92431545f;
        short lowStatus = 553;
        float lowCurrent = 0.3376835f;
        short lowVoltage = 465;
        short odStatus = 279;
        float odCurrent = 0.7849602f;
        float odVoltage = 0.5333129f;
        float rebID = 0.97985f;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new PcmsTelemetry(biasStatus, biasCurrent, biasVoltage, clockStatus, clockCurrent, clockVoltage, fpgaStatus, fpgaCurrent, fpgaVoltage, lowStatus, lowCurrent, lowVoltage, odStatus, odCurrent, odVoltage, rebID));
        Assert.assertTrue((boolean)(item instanceof PcmsTelemetry));
        PcmsTelemetry item_ = (PcmsTelemetry)item;
        Assert.assertEquals((long)biasStatus, (long)item_.getBiasStatus());
        Assert.assertEquals((float)biasCurrent, (float)item_.getBiasCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)biasVoltage, (float)item_.getBiasVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)clockStatus, (long)item_.getClockStatus());
        Assert.assertEquals((long)clockCurrent, (long)item_.getClockCurrent());
        Assert.assertEquals((float)clockVoltage, (float)item_.getClockVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)fpgaStatus, (long)item_.getFpgaStatus());
        Assert.assertEquals((float)fpgaCurrent, (float)item_.getFpgaCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)fpgaVoltage, (float)item_.getFpgaVoltage(), (float)1.0E-6f);
        Assert.assertEquals((long)lowStatus, (long)item_.getLowStatus());
        Assert.assertEquals((float)lowCurrent, (float)item_.getLowCurrent(), (float)1.0E-6f);
        Assert.assertEquals((long)lowVoltage, (long)item_.getLowVoltage());
        Assert.assertEquals((long)odStatus, (long)item_.getOdStatus());
        Assert.assertEquals((float)odCurrent, (float)item_.getOdCurrent(), (float)1.0E-6f);
        Assert.assertEquals((float)odVoltage, (float)item_.getOdVoltage(), (float)1.0E-6f);
        Assert.assertEquals((float)rebID, (float)item_.getRebID(), (float)1.0E-6f);
    }

    @Test
    public void sendReceiveSasTelemetry() throws Exception {
        short boardID = 782;
        float[] boardCurrent = new float[]{0.73152435f, 0.18049961f, 0.92349297f, 0.34092408f};
        float[] boardTemp = new float[]{0.013272345f, 0.106493056f, 0.83456105f, 0.8406642f, 0.6731714f, 0.63888973f, 0.13770556f, 0.015667975f, 0.33322024f, 0.91519874f, 0.5983132f, 0.3930413f};
        float[] boardVoltage = new float[]{0.12675136f, 0.3148263f, 0.733615f, 0.66971135f};
        int[] cabacMUX = new int[]{645, 769, 39, 230};
        short ccdID = 835;
        int ccdtemp = 314;
        int[] fpgaCheckSum = new int[]{212, 78};
        short rebID = 573;
        SALTelemetry item = this.testSendReceive((SALTelemetry)new SasTelemetry(boardID, boardCurrent, boardTemp, boardVoltage, cabacMUX, ccdID, ccdtemp, fpgaCheckSum, rebID));
        Assert.assertTrue((boolean)(item instanceof SasTelemetry));
        SasTelemetry item_ = (SasTelemetry)item;
        Assert.assertEquals((long)boardID, (long)item_.getBoardID());
        Assert.assertArrayEquals((float[])boardCurrent, (float[])item_.getBoardCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardTemp, (float[])item_.getBoardTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])boardVoltage, (float[])item_.getBoardVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])cabacMUX, (int[])item_.getCabacMUX());
        Assert.assertEquals((long)ccdID, (long)item_.getCcdID());
        Assert.assertEquals((long)ccdtemp, (long)item_.getCcdtemp());
        Assert.assertArrayEquals((int[])fpgaCheckSum, (int[])item_.getFpgaCheckSum());
        Assert.assertEquals((long)rebID, (long)item_.getRebID());
    }

    @Test
    public void sendReceiveColdTelemetry() throws Exception {
        float[] compressorLoad = new float[]{0.914562f, 0.8024911f, 0.5618668f, 0.65246296f, 0.8501238f, 0.73717576f};
        float[] compressorSpeed = new float[]{0.31950688f, 0.39543325f, 0.37063318f, 0.71040046f, 0.7501804f, 0.7821298f};
        float[] dischargePressure = new float[]{0.34100187f, 0.10711503f, 0.8710757f, 0.43429983f, 0.33723027f, 0.9117512f};
        float[] dischargeTemp = new float[]{0.26001537f, 0.15313941f, 0.9253021f, 0.87222236f, 0.11161643f, 0.4767692f};
        short[] flowInterlock = new short[]{68, 82, 687, 715, 243, 691};
        float[] heaterCurrent = new float[]{0.6357722f, 0.42668915f, 0.378991f, 0.3403865f, 0.95765615f, 0.91841024f};
        float[] heaterVoltage = new float[]{0.4528998f, 0.61800593f, 0.43196988f, 0.0030002594f, 0.6589389f, 0.6346587f};
        float[] intakeFlow = new float[]{0.31179804f, 0.78282505f, 0.33912957f, 0.29800022f, 0.91114885f, 0.5686033f};
        float[] intakePressure = new float[]{0.57441425f, 0.46609718f, 0.32455868f, 0.18661416f, 0.37383097f, 0.9825586f};
        float[] intakeTemp = new float[]{0.13037598f, 0.85172564f, 0.9634334f, 0.34117705f, 0.25867152f, 0.15205252f};
        float[] ionPump = new float[]{0.8976141f, 0.06368655f, 0.40839905f, 0.46033037f};
        short[] mechPump = new short[]{671, 109, 345, 165};
        float[] postExpansionPressure = new float[]{0.8960791f, 0.5843249f, 0.6405413f, 0.61843044f, 0.66517943f, 0.6012641f};
        float[] postExpansionTemp = new float[]{0.7447822f, 0.8340408f, 0.01802504f, 0.55247164f, 0.011943638f, 0.7377426f};
        float[] preExpansionPressure = new float[]{0.047021985f, 0.17870826f, 0.30876988f, 0.19880056f, 0.47124535f, 0.0036298037f};
        float[] preExpansionTemp = new float[]{0.48100972f, 0.27893543f, 0.58724385f, 0.74264634f, 0.8933253f, 0.30920178f};
        int[] rga = new int[]{695, 615, 857, 649, 763, 338, 304, 508, 47, 891};
        float[] returnTemp = new float[]{0.54717827f, 0.6729531f, 0.4603349f, 0.082799196f, 0.03532797f, 0.20786029f};
        float utilityRoomTemperature = 0.13053024f;
        float[] vacuumGauge = new float[]{0.15609562f, 0.509138f, 0.2533955f, 0.5670695f, 0.7915202f};
        short[] valveStatus = new short[]{424, 908, 391, 780, 896, 173};
        SALTelemetry item = this.testSendReceive((SALTelemetry)new ColdTelemetry(compressorLoad, compressorSpeed, dischargePressure, dischargeTemp, flowInterlock, heaterCurrent, heaterVoltage, intakeFlow, intakePressure, intakeTemp, ionPump, mechPump, postExpansionPressure, postExpansionTemp, preExpansionPressure, preExpansionTemp, rga, returnTemp, utilityRoomTemperature, vacuumGauge, valveStatus));
        Assert.assertTrue((boolean)(item instanceof ColdTelemetry));
        ColdTelemetry item_ = (ColdTelemetry)item;
        Assert.assertArrayEquals((float[])compressorLoad, (float[])item_.getCompressorLoad(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])compressorSpeed, (float[])item_.getCompressorSpeed(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargePressure, (float[])item_.getDischargePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])dischargeTemp, (float[])item_.getDischargeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])flowInterlock, (short[])item_.getFlowInterlock());
        Assert.assertArrayEquals((float[])heaterCurrent, (float[])item_.getHeaterCurrent(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])heaterVoltage, (float[])item_.getHeaterVoltage(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeFlow, (float[])item_.getIntakeFlow(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakePressure, (float[])item_.getIntakePressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])intakeTemp, (float[])item_.getIntakeTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])ionPump, (float[])item_.getIonPump(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])mechPump, (short[])item_.getMechPump());
        Assert.assertArrayEquals((float[])postExpansionPressure, (float[])item_.getPostExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])postExpansionTemp, (float[])item_.getPostExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionPressure, (float[])item_.getPreExpansionPressure(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])preExpansionTemp, (float[])item_.getPreExpansionTemp(), (float)1.0E-6f);
        Assert.assertArrayEquals((int[])rga, (int[])item_.getRga());
        Assert.assertArrayEquals((float[])returnTemp, (float[])item_.getReturnTemp(), (float)1.0E-6f);
        Assert.assertEquals((float)utilityRoomTemperature, (float)item_.getUtilityRoomTemperature(), (float)1.0E-6f);
        Assert.assertArrayEquals((float[])vacuumGauge, (float[])item_.getVacuumGauge(), (float)1.0E-6f);
        Assert.assertArrayEquals((short[])valveStatus, (short[])item_.getValveStatus());
    }
}

