package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class ShutterTelemetry extends CameraTelemetry {
  private final short[] bladeHome;

  private final float[] closeProfile;

  private final float[] motorCurrent;

  private final float[] motorTemp;

  private final short openDirection;

  private final float[] openProfile;

  private final String profileFunction;

  public ShutterTelemetry(short[] bladeHome, float[] closeProfile, float[] motorCurrent,
      float[] motorTemp, short openDirection, float[] openProfile, String profileFunction) {
    this.bladeHome = bladeHome;
    this.closeProfile = closeProfile;
    this.motorCurrent = motorCurrent;
    this.motorTemp = motorTemp;
    this.openDirection = openDirection;
    this.openProfile = openProfile;
    this.profileFunction = profileFunction;
  }

  public short[] getBladeHome() {
    return bladeHome;
  }

  public float[] getCloseProfile() {
    return closeProfile;
  }

  public float[] getMotorCurrent() {
    return motorCurrent;
  }

  public float[] getMotorTemp() {
    return motorTemp;
  }

  public short getOpenDirection() {
    return openDirection;
  }

  public float[] getOpenProfile() {
    return openProfile;
  }

  public String getProfileFunction() {
    return profileFunction;
  }

  @Override
  public String toString() {
    return "ShutterTelemetry{" + "bladeHome=" + bladeHome +", closeProfile=" + closeProfile +
        ", motorCurrent=" + motorCurrent +", motorTemp=" + motorTemp +
        ", openDirection=" + openDirection +", openProfile=" + openProfile +
        ", profileFunction=" + profileFunction +"}";
  }
}
