/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.sal.SAL;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.CCSConfiguredEvent;
import org.lsst.sal.camera.event.EndInitializeGuiderEvent;
import org.lsst.sal.camera.event.EndInitializeImageEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndTakeImageEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LogLevelEvent;
import org.lsst.sal.camera.event.LogMessageEvent;
import org.lsst.sal.camera.event.NotReadyToTakeImageEvent;
import org.lsst.sal.camera.event.PrepareToTakeImageEvent;
import org.lsst.sal.camera.event.ReadyToTakeImageEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;

public class EventSendReceiveTest {
    private static SAL sal;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpClass() {
        sal = SALCamera.create();
        executor = Executors.newFixedThreadPool(1);
    }

    @AfterClass
    public static void tearDownClass() throws InterruptedException, SALException {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        sal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SALEvent testSendReceive(SALEvent item) throws InterruptedException, SALException, ExecutionException, TimeoutException {
        Future<SALEvent> future = executor.submit(() -> sal.getNextEvent(Duration.ofSeconds(10L)));
        try {
            sal.logEvent(item);
            SALEvent sALEvent = future.get(10L, TimeUnit.SECONDS);
            return sALEvent;
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void sendReceiveEndReadoutEvent() throws Exception {
        int priority = 905;
        String imageType = "oozlesdckkxaufzjksuaglzfdnugafnvmueolsyotiiwwktnbppqswarjdvmqyjsggyhpeieyhmxsthjqexhvrnvehtzzyacghyievhzqndcmiedpvlosnkjzjuuelccashwbzlwlvxlrubehevrqjukuesnyzotxvwbpeikmvlpfktaxpdxmlyolrslvuhwmyfmtnpka";
        String groupId = "uymsozvlmwvpvwsczyygfqxmcaepcv";
        int imagesInSequence = 949;
        String imageName = "feydnqcek";
        int imageIndex = 523;
        String imageSource = "m";
        String imageController = "";
        String imageDate = "htly";
        int imageNumber = 270;
        double timeStampAcquisitionStart = 0.7530982494354248;
        double exposureTime = 0.6354634165763855;
        double timeStampEndOfReadout = 0.11419862508773804;
        SALEvent item = this.testSendReceive((SALEvent)new EndReadoutEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampEndOfReadout));
        Assert.assertTrue((boolean)(item instanceof EndReadoutEvent));
        EndReadoutEvent item_ = (EndReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampEndOfReadout, (double)item_.getTimeStampEndOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndTakeImageEvent() throws Exception {
        int priority = 89;
        SALEvent item = this.testSendReceive((SALEvent)new EndTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndTakeImageEvent));
        EndTakeImageEvent item_ = (EndTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartSetFilterEvent() throws Exception {
        int priority = 624;
        String filterName = "fvbjifmszhikjkwjedzeimvffipgumgxuxbpunhjralcafgnlydoxlpmrfpqxrgygazxxzkwwneoogvaqaqwbdxpekigtoptrbizuvelqbeqaztjdwyysopgkrcfzmbo";
        SALEvent item = this.testSendReceive((SALEvent)new StartSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof StartSetFilterEvent));
        StartSetFilterEvent item_ = (StartSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartUnloadFilterEvent() throws Exception {
        int priority = 791;
        SALEvent item = this.testSendReceive((SALEvent)new StartUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartUnloadFilterEvent));
        StartUnloadFilterEvent item_ = (StartUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveNotReadyToTakeImageEvent() throws Exception {
        int priority = 463;
        SALEvent item = this.testSendReceive((SALEvent)new NotReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof NotReadyToTakeImageEvent));
        NotReadyToTakeImageEvent item_ = (NotReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartShutterCloseEvent() throws Exception {
        int priority = 899;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterCloseEvent));
        StartShutterCloseEvent item_ = (StartShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndInitializeGuiderEvent() throws Exception {
        int priority = 928;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeGuiderEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeGuiderEvent));
        EndInitializeGuiderEvent item_ = (EndInitializeGuiderEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterCloseEvent() throws Exception {
        int priority = 693;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterCloseEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterCloseEvent));
        EndShutterCloseEvent item_ = (EndShutterCloseEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndOfImageTelemetryEvent() throws Exception {
        int priority = 255;
        String imageType = "zlbejnzmrgoqsnypfrtnqtmoqgwhdfjgfblquwnporwzppfwqkbngkuzdwzidmnqjbswmaywayynowtrwnulfacxhnmwrnxivxmzbatnddascitozxtcfkvyqfaajdyphkrogiabrydtauvlrcbinovajubbdnysr";
        String groupId = "hrew";
        int imagesInSequence = 796;
        String imageName = "jjnfoobpzsyvmzw";
        int imageIndex = 441;
        String imageSource = "";
        String imageController = "";
        String imageDate = "vcl";
        int imageNumber = 659;
        double timeStampAcquisitionStart = 0.4550822377204895;
        double exposureTime = 0.8304072618484497;
        String imageTag = "kltbvrhgvouipdzgrdpesevgjslvnvaabfgnhxtvoj";
        double timestampDateObs = 0.8993031978607178;
        double timestampDateEnd = 0.389864444732666;
        double expTime = 0.87402f;
        double darkTime = 0.24330562353134155;
        SALEvent item = this.testSendReceive((SALEvent)new EndOfImageTelemetryEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, imageTag, timestampDateObs, timestampDateEnd, expTime, darkTime));
        Assert.assertTrue((boolean)(item instanceof EndOfImageTelemetryEvent));
        EndOfImageTelemetryEvent item_ = (EndOfImageTelemetryEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((Object)imageTag, (Object)item_.getImageTag());
        Assert.assertEquals((double)timestampDateObs, (double)item_.getTimestampDateObs(), (double)1.0E-6f);
        Assert.assertEquals((double)timestampDateEnd, (double)item_.getTimestampDateEnd(), (double)1.0E-6f);
        Assert.assertEquals((double)expTime, (double)item_.getExpTime(), (double)1.0E-6f);
        Assert.assertEquals((double)darkTime, (double)item_.getDarkTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndUnloadFilterEvent() throws Exception {
        int priority = 989;
        SALEvent item = this.testSendReceive((SALEvent)new EndUnloadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndUnloadFilterEvent));
        EndUnloadFilterEvent item_ = (EndUnloadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndRotateCarouselEvent() throws Exception {
        int priority = 2;
        SALEvent item = this.testSendReceive((SALEvent)new EndRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndRotateCarouselEvent));
        EndRotateCarouselEvent item_ = (EndRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartLoadFilterEvent() throws Exception {
        int priority = 791;
        SALEvent item = this.testSendReceive((SALEvent)new StartLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartLoadFilterEvent));
        StartLoadFilterEvent item_ = (StartLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveReadyToTakeImageEvent() throws Exception {
        int priority = 522;
        SALEvent item = this.testSendReceive((SALEvent)new ReadyToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof ReadyToTakeImageEvent));
        ReadyToTakeImageEvent item_ = (ReadyToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceivePrepareToTakeImageEvent() throws Exception {
        int priority = 120;
        SALEvent item = this.testSendReceive((SALEvent)new PrepareToTakeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof PrepareToTakeImageEvent));
        PrepareToTakeImageEvent item_ = (PrepareToTakeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveCCSConfiguredEvent() throws Exception {
        int priority = 846;
        SALEvent item = this.testSendReceive((SALEvent)new CCSConfiguredEvent(priority));
        Assert.assertTrue((boolean)(item instanceof CCSConfiguredEvent));
        CCSConfiguredEvent item_ = (CCSConfiguredEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndLoadFilterEvent() throws Exception {
        int priority = 799;
        SALEvent item = this.testSendReceive((SALEvent)new EndLoadFilterEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndLoadFilterEvent));
        EndLoadFilterEvent item_ = (EndLoadFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndShutterOpenEvent() throws Exception {
        int priority = 842;
        SALEvent item = this.testSendReceive((SALEvent)new EndShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndShutterOpenEvent));
        EndShutterOpenEvent item_ = (EndShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveStartIntegrationEvent() throws Exception {
        int priority = 551;
        String imageType = "fjdcygrt";
        String groupId = "rcekkmppbabqpewcaumtxwnnhxdxousukjpdoiujcivovaqkmutsjsdwutkucxnkmcaokqncaqvhcnrspiofdrptratbkajdbywwqebdasnjlscwtzrsustgxfzgxavknpsuwcs";
        int imagesInSequence = 597;
        String imageName = "lckk";
        int imageIndex = 781;
        String imageSource = "";
        String imageController = "";
        String imageDate = "";
        int imageNumber = 338;
        double timeStampAcquisitionStart = 0.7775058150291443;
        double exposureTime = 0.10151857137680054;
        SALEvent item = this.testSendReceive((SALEvent)new StartIntegrationEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime));
        Assert.assertTrue((boolean)(item instanceof StartIntegrationEvent));
        StartIntegrationEvent item_ = (StartIntegrationEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveEndInitializeImageEvent() throws Exception {
        int priority = 724;
        SALEvent item = this.testSendReceive((SALEvent)new EndInitializeImageEvent(priority));
        Assert.assertTrue((boolean)(item instanceof EndInitializeImageEvent));
        EndInitializeImageEvent item_ = (EndInitializeImageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveEndSetFilterEvent() throws Exception {
        int priority = 398;
        String filterName = "zkopkhrdbeqjbjivltqcbvksqdwsrdkragxankbzfmqwccmlofjzmiztzpbnfpg";
        SALEvent item = this.testSendReceive((SALEvent)new EndSetFilterEvent(priority, filterName));
        Assert.assertTrue((boolean)(item instanceof EndSetFilterEvent));
        EndSetFilterEvent item_ = (EndSetFilterEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterName, (Object)item_.getFilterName());
    }

    @Test
    public void sendReceiveStartShutterOpenEvent() throws Exception {
        int priority = 208;
        SALEvent item = this.testSendReceive((SALEvent)new StartShutterOpenEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartShutterOpenEvent));
        StartShutterOpenEvent item_ = (StartShutterOpenEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveAvailableFiltersEvent() throws Exception {
        int priority = 690;
        String filterNames = "pgyxtuvgsklntesqjwhetavdyxrdiukvymcttfohealssscajwuw";
        SALEvent item = this.testSendReceive((SALEvent)new AvailableFiltersEvent(priority, filterNames));
        Assert.assertTrue((boolean)(item instanceof AvailableFiltersEvent));
        AvailableFiltersEvent item_ = (AvailableFiltersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)filterNames, (Object)item_.getFilterNames());
    }

    @Test
    public void sendReceiveStartReadoutEvent() throws Exception {
        int priority = 807;
        String imageType = "kbfxsomuctoauuxmjjgnwqphxdpctesikdvbkudtgpjdpmotwmouafgbkkjjgxccdyvuoherhkxhnkkckkfqeyvmoyupmrcntbzfyselziwzdafualjcejeewreankfolkflbpvhvpykfuqlptqxhqwocmidhftfrbbvuqffcgfrzdbygnrqkkvbbieyykwpejjulnyzoqlplwaljyjzrnavkzkpecckdjdgwsspqd";
        String groupId = "xsrhhzcjfsgzljzdbejtqhztxvrgspliwuqzuglcmmagvqpkcorirrijxkadmahkdas";
        int imagesInSequence = 708;
        String imageName = "mkakrxjiycrfcdkzzvzeyd";
        int imageIndex = 521;
        String imageSource = "q";
        String imageController = "";
        String imageDate = "vbkexxk";
        int imageNumber = 43;
        double timeStampAcquisitionStart = 0.4058322310447693;
        double exposureTime = 0.15907102823257446;
        double timeStampStartOfReadout = 0.5351780652999878;
        SALEvent item = this.testSendReceive((SALEvent)new StartReadoutEvent(priority, imageType, groupId, imagesInSequence, imageName, imageIndex, imageSource, imageController, imageDate, imageNumber, timeStampAcquisitionStart, exposureTime, timeStampStartOfReadout));
        Assert.assertTrue((boolean)(item instanceof StartReadoutEvent));
        StartReadoutEvent item_ = (StartReadoutEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageType, (Object)item_.getImageType());
        Assert.assertEquals((Object)groupId, (Object)item_.getGroupId());
        Assert.assertEquals((long)imagesInSequence, (long)item_.getImagesInSequence());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((long)imageIndex, (long)item_.getImageIndex());
        Assert.assertEquals((Object)imageSource, (Object)item_.getImageSource());
        Assert.assertEquals((Object)imageController, (Object)item_.getImageController());
        Assert.assertEquals((Object)imageDate, (Object)item_.getImageDate());
        Assert.assertEquals((long)imageNumber, (long)item_.getImageNumber());
        Assert.assertEquals((double)timeStampAcquisitionStart, (double)item_.getTimeStampAcquisitionStart(), (double)1.0E-6f);
        Assert.assertEquals((double)exposureTime, (double)item_.getExposureTime(), (double)1.0E-6f);
        Assert.assertEquals((double)timeStampStartOfReadout, (double)item_.getTimeStampStartOfReadout(), (double)1.0E-6f);
    }

    @Test
    public void sendReceiveStartRotateCarouselEvent() throws Exception {
        int priority = 292;
        SALEvent item = this.testSendReceive((SALEvent)new StartRotateCarouselEvent(priority));
        Assert.assertTrue((boolean)(item instanceof StartRotateCarouselEvent));
        StartRotateCarouselEvent item_ = (StartRotateCarouselEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
    }

    @Test
    public void sendReceiveImageReadoutParametersEvent() throws Exception {
        int priority = 430;
        String imageName = "";
        String ccdNames = "";
        Object[] ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.ITL, ImageReadoutParametersEvent.CcdType.E2V};
        int[] overRows = new int[]{280, 736, 177, 272, 435, 494, 624, 30, 925, 560, 78, 23, 794, 554, 486, 958, 879, 185, 244, 1, 772, 358, 469, 875, 673, 767, 966, 629, 737, 955, 304, 144, 932, 593, 296, 865, 198, 182, 501, 985, 645, 489, 371, 296, 336, 37, 780, 342, 570, 258, 806, 446, 910, 160, 672, 559, 605, 442, 990, 551, 274, 707, 212, 806, 47, 487, 710, 269, 417, 112, 190, 666, 733, 484, 415, 505, 934, 895, 574, 904, 975, 683, 25, 599, 698, 16, 215, 466, 971, 633, 359, 876, 559, 669, 45, 914, 438, 830, 999, 865, 55, 450, 390, 189, 115, 812, 879, 919, 337, 351, 161, 865, 369, 542, 225, 289, 780, 482, 193, 777, 368, 672, 791, 247, 226, 958, 889, 14, 116, 259, 599, 127, 630, 56, 201, 605, 288, 559, 663, 636, 725, 406, 727, 181, 980, 344, 489, 209, 296, 248, 807, 599, 168, 843, 440, 964, 432, 937, 547, 374, 446, 711, 993, 725, 49, 613, 123, 398, 802, 439, 275, 390, 807, 938, 910, 87, 509, 765, 238, 242, 603, 873, 294, 601, 982, 38, 151, 903, 46, 27, 96, 127, 375, 785, 722, 6, 923, 829, 281, 70, 109};
        int[] overCols = new int[]{633, 222, 848, 321, 262, 857, 940, 431, 408, 292, 688, 391, 558, 923, 123, 70, 988, 688, 61, 566, 959, 803, 45, 732, 108, 478, 294, 770, 957, 950, 519, 37, 513, 485, 582, 185, 711, 813, 208, 488, 375, 639, 319, 313, 45, 377, 760, 389, 475, 494, 760, 117, 657, 240, 955, 192, 804, 481, 929, 329, 160, 142, 110, 516, 795, 428, 596, 969, 96, 157, 590, 305, 901, 339, 443, 45, 202, 589, 950, 231, 701, 271, 134, 704, 622, 707, 199, 296, 812, 126, 876, 308, 75, 662, 646, 353, 123, 735, 462, 966, 590, 133, 331, 968, 397, 427, 169, 392, 719, 418, 262, 615, 832, 133, 546, 945, 770, 201, 610, 391, 466, 842, 665, 6, 161, 345, 972, 118, 189, 10, 608, 125, 324, 753, 435, 313, 325, 604, 67, 68, 867, 132, 591, 161, 806, 645, 784, 374, 239, 453, 955, 258, 104, 993, 206, 421, 246, 347, 780, 735, 989, 232, 975, 88, 814, 21, 609, 703, 55, 34, 167, 991, 639, 975, 859, 307, 372, 971, 996, 505, 419, 995, 236, 548, 300, 287, 686, 172, 511, 448, 153, 969, 390, 230, 878, 941, 569, 166, 450, 223, 920};
        int[] readRows = new int[]{465, 232, 835, 321, 943, 678, 870, 990, 658, 170, 640, 306, 408, 642, 850, 880, 160, 581, 503, 959, 405, 152, 935, 470, 176, 17, 815, 0, 135, 426, 604, 660, 164, 650, 805, 445, 1, 606, 209, 600, 303, 63, 213, 951, 942, 592, 88, 801, 87, 223, 514, 147, 485, 653, 590, 992, 466, 972, 201, 928, 381, 508, 147, 592, 640, 737, 970, 861, 800, 621, 309, 670, 623, 374, 638, 654, 275, 603, 25, 931, 577, 8, 577, 526, 828, 411, 298, 895, 495, 675, 777, 36, 515, 13, 727, 525, 545, 354, 212, 160, 785, 96, 177, 348, 515, 906, 750, 724, 395, 959, 162, 514, 258, 165, 704, 565, 751, 791, 190, 208, 172, 962, 929, 272, 589, 568, 981, 282, 51, 991, 641, 191, 559, 818, 975, 6, 594, 905, 96, 92, 448, 143, 734, 306, 774, 568, 379, 370, 337, 773, 439, 335, 565, 734, 799, 257, 727, 866, 336, 970, 834, 414, 372, 296, 637, 192, 587, 127, 350, 686, 258, 90, 544, 544, 161, 150, 536, 823, 878, 92, 398, 752, 320, 640, 638, 857, 966, 874, 733, 375, 165, 81, 585, 234, 416, 47, 650, 918, 642, 885, 973};
        int[] readCols = new int[]{486, 991, 139, 455, 806, 952, 60, 581, 981, 646, 876, 538, 493, 301, 999, 123, 497, 114, 168, 868, 539, 952, 2, 245, 575, 243, 167, 199, 847, 415, 930, 673, 971, 939, 651, 919, 508, 479, 495, 41, 710, 29, 256, 642, 464, 220, 0, 535, 649, 286, 590, 23, 233, 652, 827, 834, 81, 792, 844, 546, 672, 87, 356, 902, 435, 705, 676, 318, 791, 489, 442, 960, 494, 552, 444, 593, 28, 718, 351, 215, 765, 656, 145, 587, 174, 237, 206, 340, 716, 810, 107, 766, 252, 878, 165, 26, 704, 719, 941, 15, 603, 491, 402, 78, 538, 659, 939, 291, 614, 242, 400, 679, 626, 107, 419, 2, 821, 432, 281, 278, 389, 111, 887, 136, 17, 239, 138, 695, 920, 344, 207, 942, 115, 592, 820, 958, 980, 234, 569, 436, 90, 881, 214, 827, 74, 811, 331, 610, 827, 281, 654, 422, 294, 922, 964, 66, 537, 278, 631, 514, 846, 432, 32, 616, 724, 141, 770, 733, 2, 354, 971, 73, 171, 130, 255, 518, 651, 84, 754, 591, 796, 443, 258, 198, 861, 975, 783, 954, 696, 184, 936, 519, 231, 827, 148, 352, 498, 118, 41, 7, 295};
        int[] readCols2 = new int[]{109, 668, 381, 334, 135, 421, 766, 256, 474, 814, 187, 828, 898, 857, 203, 285, 41, 203, 299, 35, 881, 873, 538, 813, 957, 989, 602, 912, 861, 469, 96, 775, 904, 944, 341, 111, 860, 694, 773, 189, 833, 411, 980, 134, 563, 31, 792, 794, 390, 477, 498, 222, 444, 478, 830, 85, 730, 802, 730, 403, 369, 186, 652, 902, 752, 388, 107, 833, 862, 796, 111, 798, 677, 700, 493, 919, 202, 856, 675, 208, 561, 512, 258, 461, 934, 443, 793, 884, 870, 236, 501, 839, 164, 140, 326, 704, 55, 508, 277, 817, 800, 340, 986, 815, 66, 517, 498, 202, 586, 528, 454, 804, 894, 897, 279, 675, 802, 891, 293, 141, 797, 825, 654, 343, 442, 398, 187, 2, 859, 906, 790, 994, 567, 218, 576, 932, 180, 459, 952, 148, 616, 106, 598, 488, 729, 83, 725, 869, 957, 964, 886, 228, 411, 597, 9, 688, 496, 838, 455, 334, 750, 588, 667, 282, 23, 898, 991, 66, 175, 553, 34, 985, 503, 20, 175, 450, 230, 810, 145, 839, 754, 624, 442, 237, 12, 378, 603, 797, 594, 574, 342, 386, 598, 358, 975, 450, 179, 488, 777, 228, 567};
        int[] preCols = new int[]{475, 60, 484, 972, 984, 252, 357, 193, 99, 830, 780, 646, 980, 163, 780, 68, 783, 831, 356, 307, 468, 283, 281, 461, 459, 334, 681, 639, 352, 746, 774, 600, 822, 963, 274, 2, 740, 586, 493, 406, 889, 32, 65, 812, 349, 318, 558, 584, 469, 609, 695, 647, 906, 499, 95, 337, 15, 60, 617, 953, 622, 768, 36, 607, 278, 530, 879, 110, 794, 46, 38, 993, 785, 971, 969, 41, 197, 199, 93, 906, 258, 965, 266, 428, 253, 594, 521, 612, 599, 86, 807, 346, 485, 517, 442, 238, 373, 213, 70, 764, 687, 489, 581, 142, 149, 700, 697, 184, 1, 362, 759, 487, 874, 56, 858, 947, 98, 20, 281, 876, 598, 167, 998, 8, 75, 494, 964, 634, 202, 400, 60, 335, 559, 442, 476, 633, 68, 590, 933, 494, 389, 690, 391, 27, 960, 669, 691, 258, 587, 988, 349, 972, 473, 627, 60, 471, 202, 591, 703, 927, 478, 312, 949, 539, 238, 235, 89, 343, 192, 605, 112, 199, 269, 573, 361, 331, 304, 744, 905, 293, 789, 712, 559, 703, 515, 38, 866, 650, 919, 500, 557, 682, 151, 247, 420, 5, 448, 394, 47, 250, 157};
        int[] preRows = new int[]{678, 96, 774, 228, 829, 889, 841, 926, 678, 335, 327, 27, 866, 141, 955, 624, 29, 407, 750, 223, 40, 924, 797, 896, 516, 286, 385, 313, 209, 986, 479, 351, 572, 854, 807, 344, 879, 700, 426, 967, 514, 570, 605, 595, 143, 290, 347, 405, 731, 149, 542, 60, 552, 887, 981, 734, 120, 631, 354, 741, 852, 406, 266, 27, 611, 393, 503, 372, 422, 732, 179, 199, 640, 645, 354, 384, 434, 138, 898, 277, 116, 497, 199, 523, 448, 82, 167, 772, 553, 154, 692, 511, 145, 791, 888, 933, 431, 907, 538, 995, 415, 439, 70, 41, 540, 781, 499, 6, 641, 346, 750, 909, 101, 582, 333, 8, 124, 409, 733, 607, 978, 412, 604, 133, 914, 433, 923, 528, 301, 9, 35, 403, 687, 136, 201, 329, 107, 758, 932, 128, 222, 676, 130, 904, 409, 553, 770, 615, 552, 953, 13, 18, 407, 665, 118, 161, 492, 857, 680, 128, 872, 6, 119, 86, 424, 347, 494, 164, 784, 811, 16, 243, 966, 734, 266, 922, 852, 718, 117, 683, 247, 676, 969, 969, 805, 212, 429, 825, 563, 202, 460, 281, 92, 135, 473, 97, 190, 796, 635, 397, 199};
        int[] postCols = new int[]{42, 411, 4, 557, 851, 418, 0, 442, 960, 992, 106, 550, 104, 511, 145, 295, 394, 30, 927, 147, 728, 105, 16, 902, 792, 366, 936, 759, 39, 266, 792, 756, 876, 722, 693, 598, 79, 94, 5, 960, 12, 943, 422, 817, 776, 849, 493, 761, 615, 20, 352, 640, 743, 285, 377, 89, 884, 961, 247, 229, 857, 153, 346, 772, 864, 816, 323, 255, 278, 978, 534, 481, 222, 799, 101, 220, 208, 269, 66, 975, 254, 556, 680, 989, 427, 634, 775, 225, 184, 871, 554, 261, 876, 179, 759, 738, 56, 323, 290, 530, 68, 450, 54, 601, 953, 340, 897, 218, 164, 406, 51, 230, 436, 537, 91, 55, 840, 462, 742, 226, 224, 643, 693, 243, 550, 195, 529, 851, 960, 148, 638, 924, 470, 930, 489, 605, 834, 57, 48, 288, 673, 287, 508, 849, 684, 672, 637, 146, 235, 315, 387, 177, 63, 66, 524, 979, 530, 767, 150, 481, 70, 177, 363, 729, 814, 886, 588, 288, 509, 642, 948, 914, 225, 14, 2, 852, 900, 596, 730, 49, 735, 519, 305, 481, 658, 423, 322, 256, 284, 58, 218, 322, 380, 526, 973, 884, 882, 186, 842, 6, 13};
        SALEvent item = this.testSendReceive((SALEvent)new ImageReadoutParametersEvent(priority, imageName, ccdNames, (ImageReadoutParametersEvent.CcdType[])ccdType, overRows, overCols, readRows, readCols, readCols2, preCols, preRows, postCols));
        Assert.assertTrue((boolean)(item instanceof ImageReadoutParametersEvent));
        ImageReadoutParametersEvent item_ = (ImageReadoutParametersEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)imageName, (Object)item_.getImageName());
        Assert.assertEquals((Object)ccdNames, (Object)item_.getCcdNames());
        Assert.assertArrayEquals((Object[])ccdType, (Object[])item_.getCcdType());
        Assert.assertArrayEquals((int[])overRows, (int[])item_.getOverRows());
        Assert.assertArrayEquals((int[])overCols, (int[])item_.getOverCols());
        Assert.assertArrayEquals((int[])readRows, (int[])item_.getReadRows());
        Assert.assertArrayEquals((int[])readCols, (int[])item_.getReadCols());
        Assert.assertArrayEquals((int[])readCols2, (int[])item_.getReadCols2());
        Assert.assertArrayEquals((int[])preCols, (int[])item_.getPreCols());
        Assert.assertArrayEquals((int[])preRows, (int[])item_.getPreRows());
        Assert.assertArrayEquals((int[])postCols, (int[])item_.getPostCols());
    }

    @Test
    public void sendReceiveSettingVersionsEvent() throws Exception {
        int priority = 157;
        String recommendedSettingsVersion = "";
        String recommendedSettingsLabels = "";
        String settingsUrl = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingVersionsEvent(priority, recommendedSettingsVersion, recommendedSettingsLabels, settingsUrl));
        Assert.assertTrue((boolean)(item instanceof SettingVersionsEvent));
        SettingVersionsEvent item_ = (SettingVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)recommendedSettingsVersion, (Object)item_.getRecommendedSettingsVersion());
        Assert.assertEquals((Object)recommendedSettingsLabels, (Object)item_.getRecommendedSettingsLabels());
        Assert.assertEquals((Object)settingsUrl, (Object)item_.getSettingsUrl());
    }

    @Test
    public void sendReceiveErrorCodeEvent() throws Exception {
        int priority = 478;
        int errorCode = 880;
        String errorReport = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new ErrorCodeEvent(priority, errorCode, errorReport, traceback));
        Assert.assertTrue((boolean)(item instanceof ErrorCodeEvent));
        ErrorCodeEvent item_ = (ErrorCodeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)errorCode, (long)item_.getErrorCode());
        Assert.assertEquals((Object)errorReport, (Object)item_.getErrorReport());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveAppliedSettingsMatchStartEvent() throws Exception {
        int priority = 258;
        boolean appliedSettingsMatchStartIsTrue = true;
        SALEvent item = this.testSendReceive((SALEvent)new AppliedSettingsMatchStartEvent(priority, appliedSettingsMatchStartIsTrue));
        Assert.assertTrue((boolean)(item instanceof AppliedSettingsMatchStartEvent));
        AppliedSettingsMatchStartEvent item_ = (AppliedSettingsMatchStartEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)appliedSettingsMatchStartIsTrue, (Object)item_.isAppliedSettingsMatchStartIsTrue());
    }

    @Test
    public void sendReceiveLogLevelEvent() throws Exception {
        int priority = 410;
        int level = 728;
        SALEvent item = this.testSendReceive((SALEvent)new LogLevelEvent(priority, level));
        Assert.assertTrue((boolean)(item instanceof LogLevelEvent));
        LogLevelEvent item_ = (LogLevelEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
    }

    @Test
    public void sendReceiveLogMessageEvent() throws Exception {
        int priority = 868;
        int level = 788;
        String message = "";
        String traceback = "";
        SALEvent item = this.testSendReceive((SALEvent)new LogMessageEvent(priority, level, message, traceback));
        Assert.assertTrue((boolean)(item instanceof LogMessageEvent));
        LogMessageEvent item_ = (LogMessageEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)level, (long)item_.getLevel());
        Assert.assertEquals((Object)message, (Object)item_.getMessage());
        Assert.assertEquals((Object)traceback, (Object)item_.getTraceback());
    }

    @Test
    public void sendReceiveSettingsAppliedEvent() throws Exception {
        int priority = 791;
        String settingsVersion = "bzvezlwjuviqrlfocphdwqyejsuflbcjgnkcfemjbnyzebsgnkguovfsplmrhvdcpmujhsxzjkhissokivbkevvoxddtcbiyqyrgzbcfehvwltkv";
        String otherSettingsEvents = "";
        SALEvent item = this.testSendReceive((SALEvent)new SettingsAppliedEvent(priority, settingsVersion, otherSettingsEvents));
        Assert.assertTrue((boolean)(item instanceof SettingsAppliedEvent));
        SettingsAppliedEvent item_ = (SettingsAppliedEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)settingsVersion, (Object)item_.getSettingsVersion());
        Assert.assertEquals((Object)otherSettingsEvents, (Object)item_.getOtherSettingsEvents());
    }

    @Test
    public void sendReceiveSimulationModeEvent() throws Exception {
        int priority = 6;
        int mode = 439;
        SALEvent item = this.testSendReceive((SALEvent)new SimulationModeEvent(priority, mode));
        Assert.assertTrue((boolean)(item instanceof SimulationModeEvent));
        SimulationModeEvent item_ = (SimulationModeEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((long)mode, (long)item_.getMode());
    }

    @Test
    public void sendReceiveSoftwareVersionsEvent() throws Exception {
        int priority = 725;
        String salVersion = "xtjpsl";
        String xmlVersion = "ksssatroxao";
        String openSpliceVersion = "zavvjexzmouasr";
        String cscVersion = "kpjvpmbbguk";
        String subsystemVersions = "";
        SALEvent item = this.testSendReceive((SALEvent)new SoftwareVersionsEvent(priority, salVersion, xmlVersion, openSpliceVersion, cscVersion, subsystemVersions));
        Assert.assertTrue((boolean)(item instanceof SoftwareVersionsEvent));
        SoftwareVersionsEvent item_ = (SoftwareVersionsEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)salVersion, (Object)item_.getSalVersion());
        Assert.assertEquals((Object)xmlVersion, (Object)item_.getXmlVersion());
        Assert.assertEquals((Object)openSpliceVersion, (Object)item_.getOpenSpliceVersion());
        Assert.assertEquals((Object)cscVersion, (Object)item_.getCscVersion());
        Assert.assertEquals((Object)subsystemVersions, (Object)item_.getSubsystemVersions());
    }

    @Test
    public void sendReceiveHeartbeatEvent() throws Exception {
        int priority = 286;
        boolean heartbeat = false;
        SALEvent item = this.testSendReceive((SALEvent)new HeartbeatEvent(priority, heartbeat));
        Assert.assertTrue((boolean)(item instanceof HeartbeatEvent));
        HeartbeatEvent item_ = (HeartbeatEvent)item;
        Assert.assertEquals((long)priority, (long)item_.getPriority());
        Assert.assertEquals((Object)heartbeat, (Object)item_.isHeartbeat());
    }
}

