package org.lsst.sal.camera.telemetry;

import org.lsst.sal.camera.CameraTelemetry;

public class GasTelemetry extends CameraTelemetry {
  private final short boardID;

  private final float[] boardCurrent;

  private final float[] boardTemp;

  private final float[] boardVoltage;

  private final int[] cabacMUX;

  private final short ccdID;

  private final int ccdtemp;

  private final int[] fpgaCheckSum;

  private final short rebID;

  public GasTelemetry(short boardID, float[] boardCurrent, float[] boardTemp, float[] boardVoltage,
      int[] cabacMUX, short ccdID, int ccdtemp, int[] fpgaCheckSum, short rebID) {
    this.boardID = boardID;
    this.boardCurrent = boardCurrent;
    this.boardTemp = boardTemp;
    this.boardVoltage = boardVoltage;
    this.cabacMUX = cabacMUX;
    this.ccdID = ccdID;
    this.ccdtemp = ccdtemp;
    this.fpgaCheckSum = fpgaCheckSum;
    this.rebID = rebID;
  }

  public short getBoardID() {
    return boardID;
  }

  public float[] getBoardCurrent() {
    return boardCurrent;
  }

  public float[] getBoardTemp() {
    return boardTemp;
  }

  public float[] getBoardVoltage() {
    return boardVoltage;
  }

  public int[] getCabacMUX() {
    return cabacMUX;
  }

  public short getCcdID() {
    return ccdID;
  }

  public int getCcdtemp() {
    return ccdtemp;
  }

  public int[] getFpgaCheckSum() {
    return fpgaCheckSum;
  }

  public short getRebID() {
    return rebID;
  }

  @Override
  public String toString() {
    return "GasTelemetry{" + "boardID=" + boardID +", boardCurrent=" + boardCurrent +
        ", boardTemp=" + boardTemp +", boardVoltage=" + boardVoltage +", cabacMUX=" + cabacMUX +
        ", ccdID=" + ccdID +", ccdtemp=" + ccdtemp +", fpgaCheckSum=" + fpgaCheckSum +
        ", rebID=" + rebID +"}";
  }
}
